/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import vash.AnimationMode;
import vash.InvalidAlgorithmException;
import vash.Options;
import vash.Seed;
import vash.operation.OpParams;
import vash.operation.Operation;

public class TreeParameters {
    private final Seed seed;
    private final short minDepth;
    private final short maxDepth;
    private final HashMap<Operation, OpParams> ops;
    private final AnimationMode animationMode;
    private final double duration;
    private final double minPeriod;
    private final double fps;

    public static TreeParameters createInstance(String string, byte[] byArray) throws NoSuchAlgorithmException {
        try {
            return new TreeParameters(string, null, new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static TreeParameters createInstance(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        try {
            return new TreeParameters(string, byArray, new ByteArrayInputStream(byArray2));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static TreeParameters createInstanceOrDie(String string, byte[] byArray, InputStream inputStream) {
        try {
            return new TreeParameters(string, byArray, inputStream);
        }
        catch (IOException iOException) {
            System.err.format("Failed to create TreeParameters: %s%n", iOException.toString());
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.format("Failed to create TreeParameters: %s%n", noSuchAlgorithmException.toString());
            noSuchAlgorithmException.printStackTrace(System.err);
            System.exit(1);
        }
        return null;
    }

    public static TreeParameters createInstanceOrDie(Options options) {
        try {
            return new TreeParameters(options);
        }
        catch (IOException iOException) {
            System.err.format("Failed to create TreeParameters: %s%n", iOException.toString());
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.format("Failed to create TreeParameters: %s%n", noSuchAlgorithmException.toString());
            noSuchAlgorithmException.printStackTrace(System.err);
            System.exit(1);
        }
        return null;
    }

    public TreeParameters(Options options) throws IOException, NoSuchAlgorithmException {
        this(options.getAlgorithm(), options.getSalt(), options.getData());
    }

    public TreeParameters(String string, String string2) throws IOException, NoSuchAlgorithmException {
        this(string2, null, new ByteArrayInputStream(string.getBytes()));
    }

    public TreeParameters(String string, byte[] byArray, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        this.seed = new Seed(string, byArray, inputStream);
        this.ops = new HashMap();
        if (string.equals("1") || string.equals("1-fast")) {
            this.minDepth = (short)2;
            this.maxDepth = (short)8;
            this.ops.put(Operation.RGB, new OpParams(1.0));
            this.ops.put(Operation.ABSOLUTE, new OpParams(0.5));
            this.ops.put(Operation.ADD, new OpParams(0.5));
            this.ops.put(Operation.DIVIDE, new OpParams(0.5));
            this.ops.put(Operation.EXPONENTIATE, new OpParams(0.5));
            this.ops.put(Operation.INVERT, new OpParams(0.5));
            this.ops.put(Operation.MODULUS, new OpParams(0.5));
            this.ops.put(Operation.MULTIPLY, new OpParams(0.5));
            this.ops.put(Operation.SINC, new OpParams(0.0));
            this.ops.put(Operation.SINE, new OpParams(0.0));
            this.ops.put(Operation.SPIRAL, new OpParams(0.1));
            this.ops.put(Operation.SQUIRCLE, new OpParams(2.0));
            this.ops.put(Operation.CONST, new OpParams(0.0));
            this.ops.put(Operation.FLOWER, new OpParams(3.5));
            this.ops.put(Operation.GRADIENT_RADIAL, new OpParams(1.0));
            this.ops.put(Operation.ELLIPSE, new OpParams(0.0));
            this.ops.put(Operation.GRADIENT_LINEAR, new OpParams(1.0));
            this.ops.put(Operation.POLAR_THETA, new OpParams(2.0));
        } else if (string.equals("1.1")) {
            this.minDepth = (short)2;
            this.maxDepth = (short)8;
            this.ops.put(Operation.RGB, new OpParams(1.0, 3.0));
            this.ops.put(Operation.ABSOLUTE, new OpParams(0.2, 0.9));
            this.ops.put(Operation.ADD, new OpParams(0.3, 3.0));
            this.ops.put(Operation.DIVIDE, new OpParams(0.3, 3.0));
            this.ops.put(Operation.EXPONENTIATE, new OpParams(0.5, 3.0));
            this.ops.put(Operation.INVERT, new OpParams(0.1, 3.0));
            this.ops.put(Operation.MODULUS, new OpParams(0.5, 3.0));
            this.ops.put(Operation.MULTIPLY, new OpParams(0.3, 3.0));
            this.ops.put(Operation.SINC, new OpParams(0.0, 0.0));
            this.ops.put(Operation.SINE, new OpParams(0.0, 0.0));
            this.ops.put(Operation.SPIRAL, new OpParams(0.2, 2.0));
            this.ops.put(Operation.SQUIRCLE, new OpParams(2.0, 1.8));
            this.ops.put(Operation.CONST, new OpParams(0.0, 0.0));
            this.ops.put(Operation.FLOWER, new OpParams(3.5, 3.0));
            this.ops.put(Operation.GRADIENT_RADIAL, new OpParams(1.0, 3.0));
            this.ops.put(Operation.ELLIPSE, new OpParams(2.0, 3.0));
            this.ops.put(Operation.GRADIENT_LINEAR, new OpParams(1.0, 3.0));
            this.ops.put(Operation.POLAR_THETA, new OpParams(2.0, 3.0));
        } else {
            throw new InvalidAlgorithmException("Unrecognized algorithm string: \"" + string + "\"");
        }
        this.animationMode = null;
        this.duration = 0.0;
        this.minPeriod = 0.0;
        this.fps = 30.0;
    }

    public Seed getSeed() {
        return this.seed;
    }

    public short getMinDepth() {
        return this.minDepth;
    }

    public short getMaxDepth() {
        return this.maxDepth;
    }

    public double getOperationRatio(Operation operation) {
        OpParams opParams = this.ops.get((Object)operation);
        return opParams.ratio;
    }

    public double getOperationChannels(Operation operation) {
        OpParams opParams = this.ops.get((Object)operation);
        return opParams.channels;
    }

    AnimationMode getAnimationMode() {
        return this.animationMode;
    }

    double getDuration() {
        return this.duration;
    }

    double getMinPeriod() {
        return this.minPeriod;
    }

    double getFps() {
        return this.fps;
    }
}

