/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import vash.ImageParameters;
import vash.Options;
import vash.Output;
import vash.OutputParameters;
import vash.Tree;
import vash.TreeParameters;

public class Vash {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    public static final int REVISION = 0;
    public static final String VERSION = String.format("%d.%d.%d", 1, 1, 0);

    public static void main(String[] stringArray) {
        Options options = null;
        TreeParameters treeParameters = null;
        OutputParameters outputParameters = null;
        try {
            options = new Options(stringArray);
            treeParameters = TreeParameters.createInstanceOrDie(options);
            outputParameters = new OutputParameters(options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: " + illegalArgumentException.getLocalizedMessage());
            System.exit(1);
        }
        Tree tree = new Tree(treeParameters);
        if (options.hasADebugFlagSet("TREE", "ENTROPY")) {
            if (options.hasDebugFlag("TREE")) {
                try {
                    tree.show("-");
                }
                catch (IOException iOException) {
                    System.err.println("IO Error: " + iOException.getLocalizedMessage());
                }
            }
            if (options.hasDebugFlag("ENTROPY")) {
                System.out.format("Entropy Used: %d bits%n", treeParameters.getSeed().getBitsOfEntropyUsed());
            }
            return;
        }
        Output output = new Output(outputParameters, tree);
        try {
            output.generate();
        }
        catch (IOException iOException) {
            System.err.println("IO Error: " + iOException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public static BufferedImage createImage(String string, String string2, int n, int n2) throws NoSuchAlgorithmException {
        return Vash.createImage(string, string2.getBytes(), n, n2);
    }

    public static BufferedImage createImage(String string, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return Vash.createImage(string, byteArrayInputStream, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static BufferedImage createImage(String string, InputStream inputStream, int n, int n2) throws IOException, NoSuchAlgorithmException {
        TreeParameters treeParameters = new TreeParameters(string, null, inputStream);
        Tree tree = new Tree(treeParameters);
        ImageParameters imageParameters = new ImageParameters(n, n2);
        tree.setGenerationParameters(imageParameters);
        byte[] byArray = tree.generateCurrentFrame();
        return Output.dataToImage(byArray, n, n2);
    }

    public static BufferedImage createImage(String string, byte[] byArray, String string2, int n, int n2) throws NoSuchAlgorithmException {
        return Vash.createImage(string, byArray, string2.getBytes(), n, n2);
    }

    public static BufferedImage createImage(String string, byte[] byArray, byte[] byArray2, int n, int n2) throws NoSuchAlgorithmException {
        try {
            return Vash.createImage(string, byArray, new ByteArrayInputStream(byArray2), n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static BufferedImage createImage(String string, byte[] byArray, InputStream inputStream, int n, int n2) throws IOException, NoSuchAlgorithmException {
        TreeParameters treeParameters = new TreeParameters(string, byArray, inputStream);
        Tree tree = new Tree(treeParameters);
        ImageParameters imageParameters = new ImageParameters(n, n2);
        tree.setGenerationParameters(imageParameters);
        byte[] byArray2 = tree.generateCurrentFrame();
        return Output.dataToImage(byArray2, n, n2);
    }
}

