/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Position;

public class LinearGradient
extends OperationNode {
    private final Position p0;
    private final Position p1;

    private LinearGradient(Position position, Position position2) {
        super(2, 0);
        this.p0 = position;
        this._values[0] = this.p0;
        this.p1 = position2;
        this._values[1] = this.p1;
    }

    public LinearGradient(double d, double d2, double d3, double d4) {
        this(new Position(d, d2), new Position(d3, d4));
    }

    public LinearGradient(Seed seed) {
        this(new Position(seed), new Position(seed));
    }

    public LinearGradient clone() {
        return new LinearGradient(this.p0.clone(), this.p1.clone());
    }

    private void _computeInternal(Plane plane, float f, float f2, float[] fArray, float[] fArray2, float f3, float f4, float f5, float f6) {
        float f7 = f5 - f3;
        float f8 = (f6 - f4) / f7;
        float f9 = f8 * f3 - f4;
        float f10 = LinearGradient.distance(f3, f4, f5, f6);
        int n = 0;
        while ((float)n < f2) {
            int n2 = 0;
            while ((float)n2 < f) {
                float f11 = (f8 * fArray2[n] + fArray[n2] - f8 * f9) / (f8 * f8 + 1.0f);
                float f12 = (f8 * f8 * fArray2[n] + f8 * fArray[n2] + f9) / (f8 * f8 + 1.0f);
                float f13 = LinearGradient.distance(f3, f4, f11, f12);
                float f14 = LinearGradient.distance(f5, f6, f11, f12);
                float f15 = f13 / f10;
                plane.data[n2][n] = (double)(f13 + f14) > (double)f10 + 1.0E-4 ? (f14 > f13 ? -1.0f : 1.0f) : f15 * 2.0f - 1.0f;
                ++n2;
            }
            ++n;
        }
    }

    public Plane compute(ImageParameters imageParameters) {
        float f = imageParameters.getW();
        float f2 = imageParameters.getH();
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f3 = (float)this.p0.getX();
        float f4 = (float)this.p0.getY();
        float f5 = (float)this.p1.getX();
        float f6 = (float)this.p1.getY();
        Plane plane = imageParameters.getPlane();
        float f7 = f5 - f3;
        if (f7 < 0.1f) {
            if (f == f2) {
                this._computeInternal(plane, f, f2, fArray, fArray2, f4, f3, f6, f5);
                Plane plane2 = imageParameters.getPlane();
                int n = 0;
                while ((float)n < f2) {
                    int n2 = 0;
                    while ((float)n2 < f) {
                        plane2.data[n2][n] = plane.data[n][n2];
                        ++n2;
                    }
                    ++n;
                }
                imageParameters.putPlane(plane);
                plane = plane2;
            } else {
                Plane plane3 = imageParameters.getYXPlane();
                this._computeInternal(plane3, f2, f, fArray2, fArray, f4, f3, f6, f5);
                int n = 0;
                while ((float)n < f2) {
                    int n3 = 0;
                    while ((float)n3 < f) {
                        plane.data[n3][n] = plane3.data[(int)f2 - n - 1][(int)f - n3 - 1];
                        ++n3;
                    }
                    ++n;
                }
                imageParameters.putYXPlane(plane3);
            }
        } else {
            this._computeInternal(plane, f, f2, fArray, fArray2, f3, f4, f5, f6);
        }
        return plane;
    }
}

