/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Position;

public class LinearGradient1
extends OperationNode {
    private final Position p0;
    private final Position p1;

    private LinearGradient1(Position position, Position position2) {
        super(2, 0);
        this.p0 = position;
        this._values[0] = this.p0;
        this.p1 = position2;
        this._values[1] = this.p1;
    }

    public LinearGradient1(double d, double d2, double d3, double d4) {
        this(new Position(d, d2), new Position(d3, d4));
    }

    public LinearGradient1(Seed seed) {
        this(new Position(seed), new Position(seed));
    }

    public OperationNode clone() {
        return new LinearGradient1(this.p0.clone(), this.p1.clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float f = imageParameters.getW();
        float f2 = imageParameters.getH();
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f3 = (float)this.p0.getX();
        float f4 = (float)this.p0.getY();
        float f5 = (float)this.p1.getX();
        float f6 = (float)this.p1.getY();
        Plane plane = imageParameters.getPlane();
        double d = Math.atan2(f6 - f4, f5 - f3);
        d = 4.71238898038469 - d;
        float f7 = LinearGradient1.distance(f3, f4, f5, f6);
        float f8 = (float)Math.sin(d);
        float f9 = (float)Math.cos(d);
        int n = 0;
        while ((float)n < f2) {
            float f10 = fArray2[n] - f4;
            int n2 = 0;
            while ((float)n2 < f) {
                float f11 = fArray[n2] - f3;
                float f12 = f11 * f8 + f10 * f9;
                float f13 = f12 / f7 + 1.0f;
                f13 -= 0.5f;
                plane.data[n2][n] = LinearGradient1.clampf(f13 *= 2.0f, -1.0f, 1.0f);
                ++n2;
            }
            ++n;
        }
        return plane;
    }
}

