/*
 * Decompiled with CFR 0.152.
 */
package vash.value;

import vash.Seed;
import vash.value.Value;

public class Bounded
implements Value {
    private double v;
    private double lower = -1.0;
    private double upper = 1.0;

    public Bounded() {
        this.v = 0.0;
    }

    public Bounded(Seed seed, double d, double d2) {
        double d3 = d2 - d;
        this.v = seed.nextDouble() * d3 + d;
        this.lower = d;
        this.upper = d2;
    }

    public Bounded(double d) {
        this(d, -1.0, 1.0);
    }

    public Bounded(double d, double d2, double d3) {
        this.lower = d2;
        this.upper = d3;
        if (d < this.lower || d > this.upper) {
            throw new IllegalArgumentException("Bounded value '" + Double.toString(d) + "' is out of range [" + this.lower + "," + this.upper + "]");
        }
        this.v = d;
    }

    public Bounded clone() {
        return new Bounded(this.v, this.lower, this.upper);
    }

    public double getV() {
        return this.v;
    }

    public void setV(double d) {
        this.v = d;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public boolean hasBounds(double d, double d2) {
        return this.lower == d && this.upper == d2;
    }

    public String toString() {
        return String.format("B[%.2f]", this.v);
    }

    public void createKeyFrame(double d, Seed seed) {
    }

    public void setTime(double d, double d2) {
    }
}

