#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.net.conch_channels import ExecLineChannel
from winswitch.util.simple_logger import Logger
from conch_test_common import make_factory
from winswitch.util.main_loop import loop_init, loop_run, loop_exit, callLater, connectTCP
logger = Logger("conch_watch_test")


def ssh_watch(host, port, command):
	factory = make_factory(host, port)
	def echo(s):
		logger.slog(None, s)
	echo_line_channel = lambda connection : ExecLineChannel(command, None, echo, connection)
	factory.channel_constructors.append(echo_line_channel)
	loop_init(False)
	callLater(20, loop_exit)
	connectTCP(host, port, factory)
	try:
		loop_run()
	except Exception, e:
		logger.serr(None, e, host, port, command)
	logger.slog("ended", host, port, command)
	#callFromThread(reactor.stop)


def main():
	ssh_watch("127.0.0.1", 22, "winswitch_server_portinfo_monitor")

if __name__ == "__main__":
	main()
