#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
from winswitch.ui.notification_util import get_notification_util
from winswitch.util.main_loop import loop_init, loop_run, loop_exit, callLater, callWhenRunning

logger = Logger("notification_util_test")

tray = None

def test_notification():
	loop_init(True)

	def ready():
		def cb():
			logger.slog()
		def n2():
			get_notification_util().notify(None, "hello2", "world2", 5, ("test2", cb), None)
		get_notification_util().notify(None, "hello", "world", 5, ("test", cb), None)
		callLater(5, n2)
	
	callLater(20, loop_exit)
	callWhenRunning(ready)
	loop_run()

if __name__ == "__main__":
	test_notification()
