#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import time
import os

from winswitch.consts import ROOT_WINDOW_UUID_PROPERTY
from winswitch.ui.window_xlib import get_display_size, get_root_window_string_property, xlib_wm
from winswitch.util.simple_logger import Logger

logger = Logger("window_xlib")

def test_get_display_size():
	logger.slog("=%s" % str(get_display_size(os.environ.get("DISPLAY"))))

def test_get_display_uuid():
	logger.slog("=%s" % str(get_root_window_string_property(os.environ.get("DISPLAY"), ROOT_WINDOW_UUID_PROPERTY)))

def test_xlib_wm():
	wm = xlib_wm()
	logger.slog("is_screensaver_running_xlib=%s" % wm.is_screensaver_running_xlib())
	logger.slog("xlib_get_modifiers_set=%s" % str(wm.get_modifiers_set()))


def test_fd_leak():
	for _ in xrange(10):
		test_get_display_uuid()
		logger.slog("test_fd_leak() sleeping for 10 seconds")
		time.sleep(10);


if __name__ == "__main__":
	test_get_display_size()
	test_get_display_uuid()
	test_xlib_wm()
	test_fd_leak()
