#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.util.gstreamer_util import get_pa_device_options, get_default_gst_sound_source_module_options,\
	get_default_gst_sound_clone_module_options, get_default_gst_clone_module, get_default_gst_sound_clone_options, \
	get_default_gst_video_sink_module_options, get_default_gst_video_source_module_options


def test_init():
	from winswitch.util.gstreamer_util import has_gst, has_tcp_plugins, supported_gstaudio_codecs, supported_gstvideo_codecs
	print("has_gst=%s, has_tcp_plugins=%s" % (has_gst, has_tcp_plugins))
	print("supported_gstaudio_codecs=%s, supported_gstvideo_codecs=%s" % (supported_gstaudio_codecs, supported_gstvideo_codecs))


def device_options():
	for allow_monitors in [True,False]:
		for input_or_output in [True,False]:
			opts = get_pa_device_options(allow_monitors, input_or_output)
			print("device_options() get_pa_device_options(%s,%s)=%s" % (allow_monitors, input_or_output, opts))	

def test_get_source_options():
	print("test_get_source_options()")
	devices = get_pa_device_options(False, True)
	print("test_get_source_options()=%s" % str(devices))

def test_source_module_options():
	options = get_default_gst_sound_source_module_options()
	print("test_source_module_options() options=%s" % options)

def test_clone():
	print("test_clone() get_default_gst_sound_clone_module_options()=%s" % get_default_gst_sound_clone_module_options())
	mod = get_default_gst_clone_module()
	print("test_clone() get_default_gst_clone_module()=%s" % mod)
	if mod:
		print("test_clone() get_default_gst_sound_clone_options(%s)=%s" % (mod, get_default_gst_sound_clone_options(mod)))

def test_video():
	print("get_default_gst_video_source_module_options()=%s" % get_default_gst_video_source_module_options())
	print("get_default_gst_video_sink_module_options()=%s" % get_default_gst_video_sink_module_options())


if __name__ == "__main__":
	test_init()
	device_options()
	test_get_source_options()
	test_source_module_options()
	test_clone()
	test_video()
