#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.util.simple_logger import Logger, msig

logger=Logger("simple_logger_test", log_colour=Logger.RED, _debug=True)

def test_msig():
	sigs = [
		([1, 2, 3] , "(1,2,3)"),
		(['a', 'b', 'c'] , "(a,b,c)"),
		([1, 'a', '2', 'b'] , "(1,a,2,b)")
		]

	for (params, expected) in sigs:
		sig = msig(*params)
		logger.log("() sig=%s, expected=%s" % (sig, expected))
		assert sig == expected

def test_slog():
	logger.slog("hello", 1,2,3)

def test_exception():
	def raise_exception():
		raise Exception("hellO!")
	try:
		raise_exception()
	except Exception, e:
		logger.serr("exception!", e)

def main():
	test_msig()
	test_slog()
	test_exception()

if __name__ == "__main__":
	main()