#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gobject
import gtk_osxapplication		#@UnresolvedImport

from winswitch.ui import icons
from winswitch.ui.tray_util import BaseTray

ATTENTION_ICON = "winswitch_attention"

class MacDockTray(BaseTray):

	def __init__(self, popup_menu, activate_menu, exit_cb, ask_quit, default_icon_name):
		BaseTray.__init__(self, popup_menu, activate_menu, exit_cb, ask_quit, default_icon_name)

	def setup_widget(self):
		self.tray_widget = gtk_osxapplication.OSXApplication()
		self.tray_widget.connect("NSApplicationBlockTermination", self.exit)
		self.tray_widget.set_dock_icon_pixbuf(icons.get("winswitch_dock"))
		self.attention_ids = []
		self.tray_widget.connect("NSApplicationDidBecomeActive", self.cancel_all_attention_requests)

	def getMacDock(self):
		return	self.tray_widget

	def ready(self):
		self.tray_widget.ready()

	def close(self):
		pass

	def cancel_all_attention_requests(self, *args):
		self.slog(None, *args)
		for atn_id in self.attention_ids:
			self.tray_widget.cancel_attention_request(atn_id)
		self.attention_ids = []

	def request_attention(self, message, delay):
		self.sdebug(None, message, delay)
		atn_id = self.tray_widget.attention_request(0)
		self.attention_ids.append(atn_id)
		def mac_dock_cancel_attention_request():
			if atn_id in self.attention_ids:
				self.tray_widget.cancel_attention_request(atn_id)
				self.attention_ids.remove(atn_id)
		gobject.timeout_add(int(delay*1000), mac_dock_cancel_attention_request)
		
	def set_icon(self, icon_name):
		icon = icons.get(icon_name)
		self.tray_widget.set_dock_icon_pixbuf(icon)
