#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk

from winswitch.util.simple_logger import Logger
from winswitch.ui.ui_util import get_ui_util


class SessionStartOptionsBase:
	"""
	Utility superclass for session configuration dialogs.
	"""

	def __init__(self, command_type=None, shadowed_session=False, opts=None):
		Logger(self, log_colour=Logger.CRIMSON)
		self.command_type = command_type
		self.shadowed_session = shadowed_session
		self.window = None
		self.populating = False					# flag used to prevent us from resetting things when (re)populating the form
		self.ui_util = get_ui_util()
		self.session_start_options = opts or {}


	def create_button_box(self):
		button_box = gtk.HBox(True, 10)
		button_box.pack_start(self.ui_util.make_imagebutton("Cancel", "close", None, self.close_window))
		self.start_button = self.ui_util.make_imagebutton("Start", "play", None, self.start_session)
		button_box.pack_start(self.start_button)
		return	button_box


	def populate_form(self):
		self.sdebug("window=%s" % self.window)
		if not self.window:
			return	False
		try:
			self.populating = True
			self.do_populate_form()
		finally:
			self.populating = False

	def close_window(self, *args):
		self.destroy_window()
		return True

	def destroy_window(self, *args):
		self.sdebug(None, *args)
		if self.window:
			self.window.destroy()
			self.window = None

	def unhide(self):
		self.show()
		self.window.present()

	def show(self):
		if not self.window:
			self.window = self.create_window()
			self.populate_form()
		self.window.show()

	def refresh(self):
		self.show()
		self.unhide()



	""" Below are the methods which MUST be implemented in the subclasses """

	def start_session(self, *args):
		raise Exception("override me!")

	def do_populate_form(self):
		raise Exception("override me!")

	def create_window(self):
		raise Exception("override me!")

	def get_selected_client_util(self):
		raise Exception("override me!")

	def get_selected_session_type(self):
		raise Exception("override me!")
