#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk

from winswitch.util.simple_logger import Logger

# This class will not work as intended as GTK/GDK cannot access windows not created by the application.

class gtk_wm:
	def __init__(self):
		Logger(self, log_colour=Logger.HIGHLIGHTED_CRIMSON)
		self.net_wm_pid=0
		self.display_manager = gtk.gdk.DisplayManager()

	def for_matching_pids(self, pids, callback):
		sig = "(%s,%s)" % (pids, callback)
		self.error(sig+" not implemented!")
		#does nothing....
	
	def close_windows(self, pids):
		self.error("(%s)" % pids)
		self.for_matching_pids([pids], self.close_callback)

	def close_callback(self, screen_index, window, pid):
		self.error("(%s,%s,%s)" % (screen_index, window, pid))
		

	def minimize_windows(self, pids):
		self.for_matching_pids(pids, self.minimize_callback)

	def minimize_callback(self, screen_index, window, pid):
		sig = "(%s,%s,%s)" % (screen_index, window, pid)
		self.error(sig)

		
