/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import vash.ImageParameters;
import vash.OutputParameters;
import vash.Tree;

public class Output {
    private final OutputParameters params;
    private final Tree tree;

    public Output(OutputParameters outputParameters, Tree tree) {
        this.params = outputParameters;
        this.tree = tree;
        ImageParameters imageParameters = new ImageParameters(outputParameters.getWidth(), outputParameters.getHeight());
        tree.setGenerationParameters(imageParameters);
    }

    public void generate() throws IOException {
        BufferedImage bufferedImage = this.generateImage();
        Output.writeImageFile(this.params.getFilename(), this.params.getImageType(), bufferedImage);
    }

    public BufferedImage generateImage() {
        byte[] byArray = this.tree.generateCurrentFrame();
        BufferedImage bufferedImage = Output.dataToImage(byArray, this.params.getWidth(), this.params.getHeight());
        return bufferedImage;
    }

    public static void writeImageFile(String string, String string2, BufferedImage bufferedImage) throws IOException {
        if (string.equals("-")) {
            ImageIO.write((RenderedImage)bufferedImage, string2, System.out);
        } else {
            File file = new File(string);
            file = new File(file.getCanonicalPath());
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
    }

    public static BufferedImage dataToImage(byte[] byArray, int n, int n2) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{2, 1, 0};
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n, n2, 3, n * 3, nArray);
        Raster raster = Raster.createRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        bufferedImage.setData(raster);
        return bufferedImage;
    }
}

