/*
 * Decompiled with CFR 0.152.
 */
package vash;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import vash.Vash;
import vash.VashImagePanel;

public class VashApplet
extends JApplet
implements ActionListener {
    static final long serialVersionUID = 0L;
    private final String ALGORITHM = "1-fast";
    private final int SIZE = 200;
    private final String initial = "Vash";
    private VashImagePanel hashImagePanel;
    private JTextField hashInput;

    public void init() {
        this.buildLayout();
    }

    public void start() {
        this.hash(this.initial);
    }

    public void buildLayout() {
        this.hashImagePanel = new VashImagePanel();
        this.hashImagePanel.setPreferredSize(new Dimension(200, 200));
        this.hashInput = new JTextField();
        this.hashInput.setText(this.initial);
        this.hashInput.setActionCommand("input");
        this.hashInput.addActionListener(this);
        JButton jButton = new JButton("Vash It");
        jButton.setActionCommand("hash");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.hashInput);
        jPanel.add(jButton);
        this.add((Component)this.hashImagePanel, "Center");
        this.add((Component)jPanel, "South");
    }

    public void hash(String string) {
        final String string2 = string;
        this.hashImagePanel.setLabel("Drawing...");
        this.hashImagePanel.setImage(null);
        this.repaint();
        SwingWorker<BufferedImage, Object> swingWorker = new SwingWorker<BufferedImage, Object>(){

            @Override
            public BufferedImage doInBackground() {
                try {
                    return Vash.createImage("1-fast", string2, 200, 200);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    VashApplet.this.hashImagePanel.setLabel(noSuchAlgorithmException.getLocalizedMessage());
                    return null;
                }
            }

            @Override
            public void done() {
                try {
                    VashApplet.this.hashImagePanel.setImage((BufferedImage)this.get());
                }
                catch (InterruptedException interruptedException) {
                    VashApplet.this.hashImagePanel.setLabel(interruptedException.getLocalizedMessage());
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    VashApplet.this.hashImagePanel.setLabel(executionException.getLocalizedMessage());
                    executionException.printStackTrace();
                }
                VashApplet.this.repaint();
            }
        };
        swingWorker.execute();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public String getAppletInfo() {
        return "Vash: Making data memorable.  Visually pleasing and distinct abstract artwork, generated uniquely for any input data.";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("hash")) {
            this.hash(this.hashInput.getText());
        } else if (actionEvent.getActionCommand().equals("input")) {
            this.hash(this.hashInput.getText());
        } else {
            System.out.format("unknown action: %s%n", actionEvent.getActionCommand());
        }
    }
}

