/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Position;
import vash.value.Wrapping;

public class Flower
extends OperationNode {
    private static final double MAX_SIZE = 2.5;
    private final Position center;
    private final Wrapping angle;
    private final Bounded size;
    private final Bounded ratio;
    private final int n_points;

    private Flower(Position position, Wrapping wrapping, Bounded bounded, Bounded bounded2, int n) {
        super(4, 0);
        assert (position.hasBounds(-1.0, -1.0, 1.0, 1.0));
        assert (wrapping.hasBounds(0.0, 360.0));
        assert (bounded.hasBounds(0.0, 2.5));
        assert (bounded2.hasBounds(0.0, 1.0));
        this.center = position;
        this._values[0] = this.center;
        this.angle = wrapping;
        this._values[1] = this.angle;
        this.size = bounded;
        this._values[2] = this.size;
        this.ratio = bounded2;
        this._values[3] = this.ratio;
        this.n_points = n;
    }

    public Flower(double d, double d2, double d3, double d4, double d5, int n) {
        this(new Position(d, d2), new Wrapping(d3, 0.0, 360.0), new Bounded(d4, 0.0, 2.5), new Bounded(d5, 0.0, 1.0), n);
    }

    public Flower(Seed seed) {
        super(4, 0);
        this.center = new Position(seed);
        this._values[0] = this.center;
        this.angle = new Wrapping(seed, 0.0, 360.0);
        this._values[1] = this.angle;
        this.size = new Bounded(seed, 0.0, 2.5);
        this._values[2] = this.size;
        this.ratio = new Bounded(seed, 0.0, 1.0);
        this._values[3] = this.ratio;
        this.n_points = (int)(seed.nextDouble() * 11.0) + 1;
    }

    public OperationNode clone() {
        return new Flower(this.center.clone(), this.angle.clone(), this.size.clone(), this.ratio.clone(), this.n_points);
    }

    public Plane compute(ImageParameters imageParameters) {
        Plane plane = imageParameters.getPlane();
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f = (float)this.center.getX();
        float f2 = (float)this.center.getY();
        float f3 = (float)this.angle.getV();
        float f4 = (float)this.size.getV();
        float f5 = (float)this.ratio.getV();
        float f6 = f4 * f5;
        float f7 = fArray[2] - fArray[0];
        float f8 = (float)Math.cos((double)f3 * Math.PI / 180.0 - 1.5707963267948966);
        float f9 = (float)Math.sin((double)f3 * Math.PI / 180.0 - 1.5707963267948966);
        for (int i = 0; i < imageParameters.getH(); ++i) {
            float f10 = fArray2[i] - f2;
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f11 = fArray[j] - f;
                float f12 = (float)Math.sqrt(f11 * f11 + f10 * f10);
                float f13 = f11 * f8 - f10 * f9;
                float f14 = f11 * f9 + f10 * f8;
                if (f12 < f4 * f5) {
                    plane.data[j][i] = 1.0f;
                    continue;
                }
                if (f12 > f4) {
                    plane.data[j][i] = -1.0f;
                    continue;
                }
                float f15 = (float)((Math.atan2(f14, f13) / Math.PI + 1.0) / 2.0);
                float f16 = f15 * (float)this.n_points;
                float f17 = f16 - (float)((int)f16);
                float f18 = (f12 - f6) * (1.0f / (f4 - f6));
                float f19 = f18 - Math.abs(f17 = f17 * 2.0f - 1.0f);
                plane.data[j][i] = f19 < 0.0f ? 1.0f : (f19 < f7 ? 1.0f - 2.0f * f19 / f7 : -1.0f);
            }
        }
        return plane;
    }
}

