/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.Seed;
import vash.operation.Absolute;
import vash.operation.Add;
import vash.operation.Const;
import vash.operation.Divide;
import vash.operation.Ellipse;
import vash.operation.Exponentiate;
import vash.operation.Flower;
import vash.operation.Invert;
import vash.operation.LinearGradient;
import vash.operation.LinearGradient1;
import vash.operation.Modulus;
import vash.operation.Multiply;
import vash.operation.Operation;
import vash.operation.OperationNode;
import vash.operation.PolarTheta;
import vash.operation.RGB_Space;
import vash.operation.RadialGradient;
import vash.operation.Sinc;
import vash.operation.Sine;
import vash.operation.Spiral;
import vash.operation.Squircle;

public final class OperationFactory {
    public static OperationNode createNode(Operation operation, Seed seed) {
        switch (operation) {
            case RGB: {
                return new RGB_Space(seed);
            }
            case ABSOLUTE: {
                return new Absolute(seed);
            }
            case ADD: {
                return new Add(seed);
            }
            case DIVIDE: {
                return new Divide(seed);
            }
            case EXPONENTIATE: {
                return new Exponentiate(seed);
            }
            case INVERT: {
                return new Invert(seed);
            }
            case MODULUS: {
                return new Modulus(seed);
            }
            case MULTIPLY: {
                return new Multiply(seed);
            }
            case SINC: {
                return new Sinc(seed);
            }
            case SINE: {
                return new Sine(seed);
            }
            case SPIRAL: {
                return new Spiral(seed);
            }
            case SQUIRCLE: {
                return new Squircle(seed);
            }
            case CONST: {
                return new Const(seed);
            }
            case ELLIPSE: {
                return new Ellipse(seed);
            }
            case FLOWER: {
                return new Flower(seed);
            }
            case GRADIENT_LINEAR: {
                return OperationFactory.createLinearGradient(seed);
            }
            case GRADIENT_RADIAL: {
                return new RadialGradient(seed);
            }
            case POLAR_THETA: {
                return new PolarTheta(seed);
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + operation.toString());
    }

    private static OperationNode createLinearGradient(Seed seed) {
        String string = seed.getAlgorithm();
        if (string.equals("1") || string.equals("1-fast")) {
            return new LinearGradient(seed);
        }
        return new LinearGradient1(seed);
    }
}

