/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import vash.ImageParameters;
import vash.Plane;
import vash.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationNode {
    protected final Value[] _values;
    protected final OperationNode[] _children;

    protected OperationNode(int n, int n2) {
        this._values = n > 0 ? new Value[n] : null;
        this._children = n2 > 0 ? new OperationNode[n2] : null;
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.length;
    }

    public void setChildren(OperationNode ... operationNodeArray) {
        assert (operationNodeArray.length == this._children.length);
        for (int i = 0; i < operationNodeArray.length; ++i) {
            assert (this._children[i] == null);
            this._children[i] = operationNodeArray[i];
        }
    }

    public void setChild(int n, OperationNode operationNode) {
        assert (n < this._children.length);
        assert (this._children[n] == null);
        this._children[n] = operationNode;
    }

    public OperationNode getChild(int n) {
        assert (n < this._children.length);
        return this._children[n];
    }

    public Value[] getValues() {
        return this._values;
    }

    public void accumulateValues(ArrayList<Value> arrayList) {
        if (this._values != null) {
            for (Value object : this._values) {
                arrayList.add(object);
            }
        }
        if (this._children != null) {
            for (OperationNode operationNode : this._children) {
                operationNode.accumulateValues(arrayList);
            }
        }
    }

    public void show(OutputStream outputStream, int n) {
        int n2;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                outputStream.write("  ".getBytes("UTF-8"));
            }
            outputStream.write(String.format("%s(", this.getClass().getName()).getBytes("UTF-8"));
            if (this._values != null) {
                for (n2 = 0; n2 < this._values.length; ++n2) {
                    if (n2 != 0) {
                        outputStream.write(", ".getBytes("UTF-8"));
                    }
                    outputStream.write(this._values[n2].toString().getBytes("UTF-8"));
                }
            }
            outputStream.write(String.format(")%n", new Object[0]).getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            return;
        }
        if (this._children != null) {
            for (n2 = 0; n2 < this._children.length; ++n2) {
                this._children[n2].show(outputStream, n + 1);
            }
        }
    }

    protected static float clampf(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    protected static float distance(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        return (float)Math.sqrt(f5 * f5 + f6 * f6);
    }

    public abstract OperationNode clone();

    public abstract Plane compute(ImageParameters var1);
}

