/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Wrapping;

public class Sinc
extends OperationNode {
    private static final double MIN_FREQ = -3.1415927410125732;
    private static final double MAX_FREQ = 3.1415927410125732;
    private static final double MIN_PHASE = -3.1415927410125732;
    private static final double MAX_PHASE = 3.1415927410125732;
    private final Bounded frequency;
    private final Wrapping phase;

    private Sinc(Bounded bounded, Wrapping wrapping, OperationNode operationNode) {
        super(2, 1);
        assert (bounded.hasBounds(-3.1415927410125732, 3.1415927410125732));
        assert (wrapping.hasBounds(-3.1415927410125732, 3.1415927410125732));
        this.frequency = bounded;
        this._values[0] = this.frequency;
        this.phase = wrapping;
        this._values[1] = this.phase;
        this._children[0] = operationNode;
    }

    public Sinc(double d, double d2, OperationNode operationNode) {
        this(new Bounded(d, -3.1415927410125732, 3.1415927410125732), new Wrapping(d2, -3.1415927410125732, 3.1415927410125732), operationNode);
    }

    public Sinc(Seed seed) {
        this(new Bounded(seed, -3.1415927410125732, 3.1415927410125732), new Wrapping(seed, -3.1415927410125732, 3.1415927410125732), null);
    }

    public OperationNode clone() {
        return new Sinc(this.frequency.clone(), this.phase.clone(), this._children[0].clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float f = (float)this.frequency.getV();
        float f2 = (float)this.phase.getV();
        Plane plane = this._children[0].compute(imageParameters);
        Plane plane2 = imageParameters.getPlane();
        for (int i = 0; i < imageParameters.getH(); ++i) {
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f3 = plane.data[j][i] * f + f2;
                plane2.data[j][i] = f3 == 0.0f ? 1.0f : OperationNode.clampf((float)(Math.sin(f3) / (double)f3), -1.0f, 1.0f);
            }
        }
        imageParameters.putPlane(plane);
        return plane2;
    }
}

