/*
 * Decompiled with CFR 0.152.
 */
package vash.operation;

import vash.ImageParameters;
import vash.Plane;
import vash.Seed;
import vash.operation.OperationNode;
import vash.value.Bounded;
import vash.value.Position;

public class Squircle
extends OperationNode {
    private static final double MIN_R = 0.0;
    private static final double MAX_R = 2.0;
    private static final double MIN_N = 0.0;
    private static final double MAX_N = 4.0;
    private final Position center;
    private final Bounded r;
    private final Bounded n;

    private Squircle(Position position, Bounded bounded, Bounded bounded2, OperationNode operationNode, OperationNode operationNode2) {
        super(3, 2);
        assert (bounded.hasBounds(0.0, 2.0));
        assert (bounded2.hasBounds(0.0, 4.0));
        this.center = position;
        this._values[0] = this.center;
        this.r = bounded;
        this._values[1] = this.r;
        this.n = bounded2;
        this._values[2] = this.n;
        this._children[0] = operationNode;
        this._children[1] = operationNode2;
    }

    public Squircle(double d, double d2, double d3, double d4, OperationNode operationNode, OperationNode operationNode2) {
        this(new Position(d, d2), new Bounded(d3, 0.0, 2.0), new Bounded(d4, 0.0, 4.0), operationNode, operationNode2);
    }

    public Squircle(Seed seed) {
        this(new Position(seed), new Bounded(seed, 0.0, 2.0), new Bounded(seed, 0.0, 4.0), null, null);
    }

    public OperationNode clone() {
        return new Squircle(this.center.clone(), this.r.clone(), this.n.clone(), this._children[0].clone(), this._children[1].clone());
    }

    public Plane compute(ImageParameters imageParameters) {
        float[] fArray = imageParameters.getXValues();
        float[] fArray2 = imageParameters.getYValues();
        float f = (float)this.center.getX();
        float f2 = (float)this.center.getY();
        float f3 = (float)this.r.getV();
        float f4 = (float)this.n.getV();
        Plane plane = this._children[0].compute(imageParameters);
        Plane plane2 = this._children[1].compute(imageParameters);
        Plane plane3 = imageParameters.getPlane();
        for (int i = 0; i < imageParameters.getH(); ++i) {
            float f5 = fArray2[i] - f2;
            for (int j = 0; j < imageParameters.getW(); ++j) {
                float f6 = fArray[j] - f;
                float f7 = Math.abs(f6 - plane.data[j][i]);
                float f8 = Math.abs(f5 - plane2.data[j][i]);
                float f9 = (float)(-(Math.pow(f7, f4) + Math.pow(f8, f4)));
                float f10 = (float)Math.pow(f3, f4);
                plane3.data[j][i] = f10 == 0.0f ? 1.0f : Squircle.clampf(f9 / f10, -1.0f, 1.0f);
            }
        }
        imageParameters.putPlane(plane);
        imageParameters.putPlane(plane2);
        return plane3;
    }
}

