#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from conch_test_common import make_factory
from winswitch.consts import LOCALHOST
from winswitch.net.conch_channels import ExecChannel
from winswitch.util.main_loop import test_loop, connectTCP
from winswitch.util.simple_logger import Logger
logger = Logger("conch_exec_test")


def ssh_exec(host, port, command):
	factory = make_factory(host, port)
	echo_channel = lambda connection : ExecChannel(command, connection)
	factory.channel_constructors.append(echo_channel)

	connectTCP(host, port, factory)
	logger.slog("ended", host, port, command)

def ssh_localhost():
	ssh_exec(LOCALHOST, 22, "winswitch_server_portinfo")

def main():
	test_loop(ssh_localhost)

if __name__ == "__main__":
	main()
