#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.net.conch_channels import ReverseForward
from winswitch.consts import LOCALHOST
from winswitch.util.simple_logger import Logger
from conch_test_common import make_factory
from winswitch.util.main_loop import loop_init, loop_run, loop_exit, callLater, connectTCP
logger = Logger("conch_reverse_tunnel_test")


def reverse_forward(host, port, local_port, remote_host, remote_port):
	factory = make_factory(host, port)
	pf = lambda connection : ReverseForward(local_port, remote_host, remote_port, connection)
	factory.channel_constructors.append(pf)
	loop_init()
	connectTCP(host, port, factory)
	callLater(20, loop_exit)
	try:
		loop_run()
	except Exception, e:
		logger.serr(None, e, host, port, local_port, remote_host, remote_port)
	logger.slog("ended", host, port, local_port, remote_host, remote_port)

def main():
	reverse_forward(LOCALHOST, 22, 10000, LOCALHOST, 8080)

if __name__ == "__main__":
	main()
