#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.util.simple_logger import Logger
from winswitch.util.load_desktop_menus import load_desktop_commands
from winswitch.consts import DEFAULT_IGNORED_XSESSIONS
from winswitch.util.common import csv_list

logger=Logger("load_xsessions_test", log_colour=Logger.RED, _debug=True)

def test_load_xsessions():
	pass

def main():
	ignored_xsessions = DEFAULT_IGNORED_XSESSIONS
	whitelist_xsessions = ["*"]
	logger.slog("loading desktop commands but ignoring: %s" % csv_list(ignored_xsessions))
	desktop_commands = load_desktop_commands(ignored_xsessions, whitelist_xsessions)
	logger.slog("found the following xsessions:")
	for x in desktop_commands:
		logger.slog("%s" % x)

if __name__ == "__main__":
	main()