#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os
import sys
import getpass
import locale
import socket

from winswitch.util.simple_logger import Logger, write_log
from winswitch.consts import WINSWITCH_VERSION
from winswitch import __version__;

KDE = os.environ.get("KDE_FULL_SESSION") is not None or os.environ.get("DESKTOP_SESSION", "")=="KDE"
LXDE = os.environ.get("DESKTOP_SESSION")=="LXDE" or os.environ.get("GDMSESSION")=="LXDE" or os.environ.get("XDG_CURRENT_DESKTOP")=="LXDE"
WIN32 = sys.platform.startswith("win")
OSX = sys.platform.startswith("darwin")
LINUX = sys.platform.startswith("linux")

def log(msg):
	write_log(Logger.WHITE, "II", "globals", msg) 

(LOCALE_LANGUAGE, LOCALE_ENCODING) = locale.getlocale()
if not LOCALE_LANGUAGE:
	(LOCALE_LANGUAGE, LOCALE_ENCODING) = locale.getdefaultlocale()
if not LOCALE_LANGUAGE:
	LOCALE_LANGUAGE = "en"


exit_hooks=[]
last_exit_hooks=[]
def get_exit_hooks():
	global exit_hooks, last_exit_hooks
	hooks = exit_hooks[:]
	hooks += last_exit_hooks
	return	hooks
def add_exit_hook(func):
	exit_hooks.append(func)
def insert_exit_hook(func):
	exit_hooks.insert(0, func)
def add_last_exit_hook(func):
	last_exit_hooks.append(func)

def call_exit_hooks():
	all_exit_hooks = get_exit_hooks()
	log(" exit hooks=%s" % (str(all_exit_hooks)))
	for exit_hook in all_exit_hooks:
		log(" calling exit hook=%s" % exit_hook)
		try:
			exit_hook()
		except Exception, e:
			log(" error on exit hook %s: %s" % (exit_hook, e))
	log(" done")


# User / Host info
HOSTNAME = socket.gethostname()
LOCAL_SAMBA_PORT = 139
if sys.platform.startswith("win"):
	USERNAME = getpass.getuser()
	import win32api, win32process		#@UnresolvedImport
	NAME = win32api.GetUserName()
	USER_ID = 100
	SUBPROCESS_CREATION_FLAGS = win32process.CREATE_NO_WINDOW
	LOCAL_IPP_PORT = 0
	SAMBA_ENABLED = True
	get_user_id = None
else:
	import pwd
	USER_ID = os.getuid()
	pw = pwd.getpwuid(USER_ID)
	USERNAME = pw.pw_name
	NAME = pw.pw_gecos.replace(",", "")
	SUBPROCESS_CREATION_FLAGS = 0
	LOCAL_IPP_PORT = 631
	write_log(Logger.WHITE, "II", "globals", " os.uname=%s" % str(os.uname()))
	c = None
	try:
		from winswitch.util.which import which
		c = which("which samba")
	except:
		pass	#python3... PITA
	SAMBA_ENABLED = (c is not None) and os.path.exists(c)
if not NAME:
	NAME = USERNAME

log(" python package info: __version__=%s" % (__version__))
try:
	from winswitch.build_info import BUILT_ON, BUILT_BY, BUILD_DATE, REVISION, LOCAL_MODIFICATIONS, RELEASE_BUILD
	log(" version=%s (svn revision %s - %s local modifications), built on %s by %s, %s, release_build=%s" % (WINSWITCH_VERSION, REVISION, LOCAL_MODIFICATIONS, BUILT_ON, BUILT_BY, BUILD_DATE, RELEASE_BUILD))
except:
	pass
args = "[%s]" % (" ".join([str(t) for t in sys.argv]))
log(" uid=%d, username=%s, name=%s, hostname=%s, locale=%s, argv=%s" % (USER_ID, USERNAME, NAME, HOSTNAME, LOCALE_LANGUAGE, args))
log(" Python version %s" % sys.version.replace("\n", "").replace("\r", ""))
