#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.objects.user_base import UserBase
from winswitch.consts import LOCALHOST, OPEN_LOCALLY, OPEN_NEW_SESSION

class User(UserBase):
	def __init__(self):
		"""
		Represents a remote user.
		"""
		UserBase.__init__(self)
		self.uuid = ""
		self.host = ""
		self.name = ""
		self.username = ""
		self.auth_username = ""
		self.password = ""

		self.remote_username = None
		self.remote_host = None
		self.remote_port = 0

		self.ssh_pub_keydata = ""			#the remote user's public key 

		#used by the server only: these are the local (to the server) ports assigned that must be tunneled back to the user's PC
		self.local_ipp_port = 0				#local ipp port of the tunnel
		self.local_samba_host = LOCALHOST
		self.local_samba_port = 139			#samba

		self.open_urls = OPEN_LOCALLY		# or "new-session" or "existing-session"
		self.open_files = OPEN_NEW_SESSION	# or "existing-session"
		self.client_type = "pygtk"

		self.xpra_x11 = True				#tells us if Xpra is running as an X11 client (so we know the xmodmap must apply to it) - False on OSX and win32
		self.vnc_x11 = True					#tells us if VNC is running as an X11 client (so we know the xmodmap must apply to it) - False on win32
		self.app_version = None				#used on server only to test for protocol features
		self.platform = "unknown"			#remote sys.platform
		self.active = True					#goes inactive when timed out
		self.tunneled = False				#used by server: sets this to true when connected via a tunnel
		self.local = False					#set to True when connecting over local unix domain sockets

	def update(self, user):
		UPDATABLE_FIELDS = ["locale", "preferred_session_type", "preferred_desktop_type",
						"supports_xpra", "supports_nx", "supports_vnc", "supports_rdp", "supports_ssh",
						"line_speed", "tunnel_fs", "tunnel_sink", "tunnel_source", "tunnel_printer",
						"name", "password",
						"open_urls", "open_files",
						"app_version", "tunneled",
						"xpra_x11", "vnc_x11",
						"xkbmap_print", "xkbmap_query"]
		return	self.update_fields(UPDATABLE_FIELDS, user)
