#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

#@PydevCodeAnalysisIgnore

import gtk.gdk

from winswitch.consts import MODIFIER_KEY_SHIFT, MODIFIER_KEY_CONTROL, MODIFIER_KEY_ALT, MODIFIER_KEY_ANY

STD_SPECIAL = gtk.gdk.SHIFT_MASK | gtk.gdk.CONTROL_MASK | gtk.gdk.MOD1_MASK
ALL_SPECIAL = gtk.gdk.SHIFT_MASK | gtk.gdk.CONTROL_MASK | gtk.gdk.MOD1_MASK | gtk.gdk.MOD2_MASK | gtk.gdk.MOD3_MASK |  gtk.gdk.MOD4_MASK | gtk.gdk.MOD5_MASK

MODIFIER_KEY_TO_GDKMASK = {"Disabled" : 0,
			MODIFIER_KEY_SHIFT : gtk.gdk.SHIFT_MASK,
			MODIFIER_KEY_CONTROL : gtk.gdk.CONTROL_MASK,
			MODIFIER_KEY_ALT : gtk.gdk.MOD1_MASK,
			MODIFIER_KEY_ANY : STD_SPECIAL}

def get_modifier_name(code):
	if code==gtk.gdk.SHIFT_MASK:
		return	MODIFIER_KEY_SHIFT
	elif code==gtk.gdk.CONTROL_MASK:
		return	MODIFIER_KEY_CONTROL
	elif code==gtk.gdk.MOD1_MASK:
		return	MODIFIER_KEY_ALT;
	elif code==gtk.gdk.MOD2_MASK:
		return	"Mod2";
	elif code==gtk.gdk.MOD3_MASK:
		return	"Mod3";
	elif code==gtk.gdk.MOD4_MASK:
		return	"Mod4";
	elif code==gtk.gdk.MOD5_MASK:
		return	"Mod5";
	else:
		return	"Unknown"


def get_modifier_mask(name):
	if name in MODIFIER_KEY_TO_GDKMASK.keys():
		return	MODIFIER_KEY_TO_GDKMASK[name]
	return	0
