#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2012 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk
import gobject

from winswitch.ui.config_common import table_init, add_tableline
from winswitch.objects.server_command import ServerCommand
from winswitch.ui.session_start_options import SessionStartOptions, CELL_WIDTH
from winswitch.virt.options_common import SCREEN_SIZE
from winswitch.ui import icons


class SessionCustomCommandDialog(SessionStartOptions):
	"""
	This dialog allows the user to start a custom command on one of the servers we are connected to.
	It extends SessionStartOptions to allow the user to enter the command desired.
	(plus all the options from SessionStartOptions)
	"""
	
	def __init__(self, server, client_utils, current_session_type, callback):
		#use a throw-away command object:
		command_obj = ServerCommand(ServerCommand.CUSTOM_UUID_PREFIX, "Custom Command", "", "Type in by user", "custom_command")
		SessionStartOptions.__init__(self, server, client_utils, command_obj, ServerCommand.COMMAND, current_session_type, callback, None, False)

	def get_title(self):
		return	"Start Custom Remote Application"
	
	def create_form_box(self):
		box = gtk.VBox(False, 0)
		box.set_spacing(15)
		#title:
		hbox = gtk.HBox(False, 0)
		hbox.pack_start(self.ui_util.scaled_image(icons.get("run"), 48))
		vbox = gtk.VBox(False, 0)
		vbox.pack_start(self.ui_util.make_label(self.get_title(), "sans 16"))
		hbox.pack_start(vbox)
		box.pack_start(hbox)
		#form
		table = table_init(self)
		#categories
		(self.command_label, self.command) = add_tableline(self, table, "Command", gtk.Entry(max=4096), homogeneous=CELL_WIDTH)
		self.command.set_width_chars(24)
		self.command.connect("activate", self.start_session)
		self.command.connect("changed", self.check_server)
		#Adds the form elements from session_start_options.py
		self.add_start_options(table)
		box.pack_start(table)

		box.pack_start(self.create_button_box())
		return	box

	def start_session(self, *args):
		self.server_command.command = self.command.get_text()
		self.server_command.uuid = ServerCommand.CUSTOM_UUID_PREFIX+""+self.command.get_text()
		session_type = self.get_selected_session_type()
		screen_size = self.session_start_options.get(SCREEN_SIZE)
		if session_type and self.server_command:
			bookmark = self.can_bookmark and self.bookmark.get_active()
			self.close_window()
			gobject.idle_add(self.callback, self.server, self.server_command, session_type, screen_size, self.session_start_options, bookmark)

	def get_server_warning_text(self):
		"""
		Override this method so we can add some extra checks.
		"""
		cmd = self.command.get_text()
		if len(cmd)==0:
			return "Please specify a command to run"
		return SessionStartOptions.get_server_warning_text(self)
	
	def do_populate_form(self):
		SessionStartOptions.do_populate_form(self)		#populates session types, their options, screen size, bookmark
