/*
 * THIS FILE IS AUTOGENERATED, DO NOT EDIT
 * generated from http://www.iana.org/assignments/enterprise-numbers
 * run "tools/make-sminmpec.pl <infile> <outfile>" to regenerate
 *
 * Note 1: "Gaps" in the iana enterprise-numbers list have been "filled in"
 *       with "(Unknown)" as the name so that direct (indexed) access to
 *       the list is possible.
 *
 * Note 2: We should probably parse "enterprise-numbers" at program start
 *       instead of generating this file.
 */
#include "config.h"

#include <glib.h>

#include <epan/value_string.h>
#include <epan/sminmpec.h>

static const gchar sminmpec_unknown[] = "(Unknown)";

const value_string sminmpec_values[] = {
    {     0, "Reserved" },
    {     1, "NxNetworks" },
    {     2, "IBM (https://w3.ibm.com/standards)" },
    {     3, "Carnegie Mellon" },
    {     4, "Unix" },
    {     5, "ACC" },
    {     6, "TWG" },
    {     7, "CAYMAN" },
    {     8, "PSI" },
    {     9, "ciscoSystems" },
    {    10, "NSC" },
    {    11, "Hewlett-Packard" },
    {    12, "Epilogue" },
    {    13, "U of Tennessee" },
    {    14, "BBN Technologies" },
    {    15, "Xylogics, Inc." },
    {    16, "Timeplex" },
    {    17, "Canstar" },
    {    18, "Wellfleet" },
    {    19, "TRW" },
    {    20, "MIT" },
    {    21, "EON" },
    {    22, "Fibronics" },
    {    23, "Novell" },
    {    24, "Spider Systems" },
    {    25, "NSFNET" },
    {    26, "Hughes LAN Systems" },
    {    27, "Intergraph" },
    {    28, "Interlan" },
    {    29, "Vitalink Communications" },
    {    30, "Ulana" },
    {    31, "NSWC" },
    {    32, "Santa Cruz Operation" },
    {    33, "MRV Communications, In-Reach Product Division" },
    {    34, "Cray" },
    {    35, "Nortel Networks" },
    {    36, "DEC" },
    {    37, "Touch" },
    {    38, "Network Research Corp." },
    {    39, "Baylor College of Medicine" },
    {    40, "NMFECC-LLNL" },
    {    41, "SRI" },
    {    42, "Sun Microsystems" },
    {    43, "3Com" },
    {    44, "CMC" },
    {    45, "SynOptics" },
    {    46, "Cheyenne Software" },
    {    47, "Prime Computer" },
    {    48, "MCNC/North Carolina" },
    {    49, "Chippcom" },
    {    50, "Optical Data Systems" },
    {    51, "gated" },
    {    52, "Enterasys Networks Inc." },
    {    53, "Apollo Computers" },
    {    54, "DeskTalk Systems, Inc." },
    {    55, "SSDS" },
    {    56, "Castle Rock Computing" },
    {    57, "MIPS Computer Systems" },
    {    58, "TGV, Inc." },
    {    59, "Silicon Graphics, Inc." },
    {    60, "University of British Columbia" },
    {    61, "Merit" },
    {    62, "NetEdge" },
    {    63, "Apple Computer, Inc." },
    {    64, "Gandalf" },
    {    65, "Dartmouth College" },
    {    66, "David Systems" },
    {    67, "Reuter" },
    {    68, "Cornell" },
    {    69, "Michael Sabo" },
    {    70, "Locus Computing Corp." },
    {    71, "NASA" },
    {    72, "Retix" },
    {    73, "Boeing" },
    {    74, "AT&T" },
    {    75, "Ungermann-Bass" },
    {    76, "Digital Analysis Corporation" },
    {    77, "LAN Manager" },
    {    78, "LogMatrix Inc (formerly 'OpenService Inc.')" },
    {    79, "Fujitsu Services" },
    {    80, "Auspex Systems, Inc" },
    {    81, "Lannet Company" },
    {    82, "Network Computing Devices" },
    {    83, "Raycom Systems" },
    {    84, "Pirelli Focom Ltd." },
    {    85, "Datability Software Systems" },
    {    86, "Network Application Technology" },
    {    87, "Institute of Telematics, Karlsruhe Institute of Technology (KIT)" },
    {    88, "New York University" },
    {    89, "RND" },
    {    90, "InterCon Systems Corporation" },
    {    91, "Coral Network Corporation" },
    {    92, "Webster Computer Corporation" },
    {    93, "Frontier Technologies Corporation" },
    {    94, "Nokia" },
    {    95, "Allen-Bradely Company" },
    {    96, "CERN" },
    {    97, "Sigma Network Systems, Inc." },
    {    98, "Emerging Technologies, Inc." },
    {    99, "SNMP Research" },
    {   100, "Ohio State University" },
    {   101, "Ultra Network Technologies Julie" },
    {   102, "Microcom" },
    {   103, "Lockheed Martin" },
    {   104, "Micro Technology" },
    {   105, "Process Software Corporation" },
    {   106, "EMC Data General Division" },
    {   107, "Bull Company" },
    {   108, "Emulex Corporation" },
    {   109, "Warwick University Computing Services" },
    {   110, "NetScout Systems, Inc. (formerly 'Network General Corporation')" },
    {   111, "Oracle" },
    {   112, "Control Data Corporation" },
    {   113, "Hughes Aircraft Company" },
    {   114, "Synernetics, Inc." },
    {   115, "Mitre" },
    {   116, "Hitachi, Ltd." },
    {   117, "Telebit" },
    {   118, "Salomon Technology Services" },
    {   119, "NEC Corporation" },
    {   120, "Fibermux" },
    {   121, "FTP Software Inc." },
    {   122, "Sony" },
    {   123, "Newbridge Networks Corporation" },
    {   124, "Racal-Datacom" },
    {   125, "CR SYSTEMS" },
    {   126, "DSET Corporation" },
    {   127, "Computone" },
    {   128, "Tektronix, Inc." },
    {   129, "Interactive Systems Corporation" },
    {   130, "Banyan Systems Inc." },
    {   131, "Sintrom Datanet Limited" },
    {   132, "Bell Canada" },
    {   133, "Olicom Enterprise Products Inc." },
    {   134, "Rice University" },
    {   135, "OnStream Networks" },
    {   136, "Concurrent Computer Corporation" },
    {   137, "Basser" },
    {   138, "Luxcom" },
    {   139, "Artel" },
    {   140, "Independence Technologies, Inc.(ITI)" },
    {   141, "NetScout Systems, Inc. (formerly 'Frontier Software Development')" },
    {   142, "Digital Computer Limited" },
    {   143, "Eyring, Inc." },
    {   144, "Case Communications" },
    {   145, "Penril DataComm, Inc." },
    {   146, "American Airlines, Inc." },
    {   147, "Sequent Computer Systems" },
    {   148, "Bellcore" },
    {   149, "Concord Communications" },
    {   150, "University of Washington" },
    {   151, "Develcon" },
    {   152, "Solarix Systems" },
    {   153, "Unifi Communications Corp." },
    {   154, "Roadnet" },
    {   155, "Network Systems Corp." },
    {   156, "ENE (European Network Engineering)" },
    {   157, "Dansk Data Elektronik A/S" },
    {   158, "Morningstar, Inc." },
    {   159, "Dupont EOP" },
    {   160, "Legato Systems, Inc." },
    {   161, "Motorola" },
    {   162, "European Space Agency (ESA)" },
    {   163, "Aethis sa/nv" },
    {   164, "Rad Data Communications Ltd." },
    {   165, "OfficeNet, Inc." },
    {   166, "Shiva Corporation" },
    {   167, "Fujikura America" },
    {   168, "Xlnt Designs INC (XDI)" },
    {   169, "Tandem Computers" },
    {   170, "BICC" },
    {   171, "D-Link Systems, Inc." },
    {   172, "AMP, Inc." },
    {   173, "Netlink" },
    {   174, "C. Itoh Electronics" },
    {   175, "Sumitomo Electric Industries (SEI)" },
    {   176, "DHL Systems, Inc." },
    {   177, "Network Equipment Technologies" },
    {   178, "APTEC Computer Systems" },
    {   179, "Schneider & Koch & Co, Datensysteme GmbH" },
    {   180, "Hill Air Force Base" },
    {   181, "Kentrox" },
    {   182, "Japan Radio Co." },
    {   183, "Versitron" },
    {   184, "Telecommunication Systems" },
    {   185, "Interphase" },
    {   186, "Toshiba Corporation" },
    {   187, "Clearpoint Research Corp." },
    {   188, "Ascom" },
    {   189, "Fujitsu America" },
    {   190, "NovaQuest InfoSystems" },
    {   191, "NCR" },
    {   192, "Dr. Materna GmbH" },
    {   193, "Ericsson AB" },
    {   194, "Metaphor Computer Systems" },
    {   195, "Patriot Partners" },
    {   196, "The Software Group Limited (TSG)" },
    {   197, "Kalpana, Inc." },
    {   198, "University of Waterloo" },
    {   199, "CCL/ITRI" },
    {   200, "Coeur Postel" },
    {   201, "Mitsubish Cable Industries, Ltd." },
    {   202, "SMC" },
    {   203, "Crescendo Communication, Inc." },
    {   204, "Goodall Software Engineering" },
    {   205, "Intecom" },
    {   206, "Victoria University of Wellington" },
    {   207, "Allied Telesis, Inc." },
    {   208, "Cray Communications A/S" },
    {   209, "Protools" },
    {   210, "NIPPON TELEGRAPH AND TELEPHONE CORPORATION" },
    {   211, "Fujitsu Limited" },
    {   212, "Network Peripherals Inc." },
    {   213, "Netronix, Inc." },
    {   214, "University of Wisconsin Madison" },
    {   215, "NetWorth, Inc." },
    {   216, "Tandberg Data A/S" },
    {   217, "Technically Elite Concepts, Inc." },
    {   218, "Labtam Australia Pty. Ltd." },
    {   219, "Republic Telcom Systems, Inc." },
    {   220, "ADI Systems, Inc." },
    {   221, "Microwave Bypass Systems, Inc." },
    {   222, "Pyramid Technology Corp." },
    {   223, "Unisys_Corp" },
    {   224, "LANOPTICS LTD., Israel" },
    {   225, "NKK Corporation" },
    {   226, "CODIMA Technologies Ltd" },
    {   227, "Acals" },
    {   228, "ASTEC, Inc." },
    {   229, "Delmarva Power" },
    {   230, "Telematics International, Inc." },
    {   231, "Fujitsu Technology Solutions GmbH (formerly 'Fujitsu Siemens Computers')" },
    {   232, "Compaq" },
    {   233, "NetManage, Inc." },
    {   234, "NC State University" },
    {   235, "Empirical Tools and Technologies" },
    {   236, "Samsung Electronics Co., LTD." },
    {   237, "Takaoka Electric Mfg. Co., Ltd." },
    {   238, "NxNetworks" },
    {   239, "WINDATA" },
    {   240, "RC International A/S" },
    {   241, "Netexp Research" },
    {   242, "Internode Systems Pty Ltd" },
    {   243, "netCS Informationstechnik GmbH" },
    {   244, "Lantronix" },
    {   245, "Avatar Consultants" },
    {   246, "Furukawa Electoric Co. Ltd." },
    {   247, "ND SatCom - Gesellschaft f\0303\0274r SatellitenkommunikationssystemembH" },
    {   248, "Richard Hirschmann GmbH & Co." },
    {   249, "G2R Inc." },
    {   250, "University of Michigan" },
    {   251, "Netcomm, Ltd." },
    {   252, "Sable Technology Corporation" },
    {   253, "Xerox" },
    {   254, "Conware Computer Consulting GmbH" },
    {   255, "Compatible Systems Corp." },
    {   256, "Scitec Communications Systems Ltd." },
    {   257, "Transarc Corporation" },
    {   258, "Matsushita Electric Industrial Co., Ltd." },
    {   259, "ACCTON Technology" },
    {   260, "Star-Tek, Inc." },
    {   261, "ADC Codenoll Technology Corporation" },
    {   262, "Formation, Inc." },
    {   263, "Seiko Instruments, Inc." },
    {   264, "RCE (Reseaux de Communication d'Entreprise S.A.)" },
    {   265, "Xenocom, Inc." },
    {   266, "Nexans Deutschland Industries" },
    {   267, "Systech Computer Corporation" },
    {   268, "Visual" },
    {   269, "CSC Airline Solutions Denmark A/S" },
    {   270, "Zenith Electronics Corporation" },
    {   271, "TELECOM FINLAND" },
    {   272, "BinTec Communications GmbH" },
    {   273, "EUnet Germany" },
    {   274, "PictureTel Corporation" },
    {   275, "Michigan State University" },
    {   276, "GTE Government Systems - Network Management Organization" },
    {   277, "Cascade Communications Corp." },
    {   278, "APRESIA Systems, Ltd. (formerly 'Hitachi Cable, Ltd.')" },
    {   279, "Olivetti" },
    {   280, "Vitacom Corporation" },
    {   281, "INMOS" },
    {   282, "AIC Systems Laboratories Ltd." },
    {   283, "Cameo Communications, Inc." },
    {   284, "Diab Data AB" },
    {   285, "Olicom A/S" },
    {   286, "Digital-Kienzle Computersystems" },
    {   287, "CSELT(Centro Studi E Laboratori Telecomunicazioni)" },
    {   288, "Electronic Data Systems" },
    {   289, "Brocade Communications Systems, Inc. (formerly 'McData Corporation')" },
    {   290, "Harris Corporation" },
    {   291, "Technology Dynamics, Inc." },
    {   292, "DATAHOUSE Information Systems Ltd." },
    {   293, "Teltrend (NZ) Limited" },
    {   294, "Texas Instruments" },
    {   295, "PlainTree Systems Inc." },
    {   296, "Hedemann Software Development" },
    {   297, "Fuji Xerox Co., Ltd." },
    {   298, "Asante Technology" },
    {   299, "Stanford University" },
    {   300, "Digital Link" },
    {   301, "Raylan Corporation" },
    {   302, "Commscraft" },
    {   303, "Hughes Communications, Inc." },
    {   304, "Farallon Computing, Inc." },
    {   305, "GE Information Services" },
    {   306, "Gambit Computer Communications" },
    {   307, "Livingston Enterprises, Inc." },
    {   308, "Star Technologies" },
    {   309, "Micronics Computers Inc." },
    {   310, "Basis, Inc." },
    {   311, "Microsoft" },
    {   312, "US West Advance Technologies" },
    {   313, "University College London" },
    {   314, "Eastman Kodak Company" },
    {   315, "Network Resources Corporation" },
    {   316, "Atlas Telecom" },
    {   317, "Bridgeway" },
    {   318, "American Power Conversion Corp." },
    {   319, "DOE Atmospheric Radiation Measurement Project" },
    {   320, "VerSteeg CodeWorks" },
    {   321, "Verilink Corp" },
    {   322, "Sybus Corportation" },
    {   323, "Tekelec" },
    {   324, "NASA Ames Research Center" },
    {   325, "Simon Fraser University" },
    {   326, "Fore Systems, Inc." },
    {   327, "Centrum Communications, Inc." },
    {   328, "NeXT Computer, Inc." },
    {   329, "Netcore, Inc." },
    {   330, "Northwest Digital Systems" },
    {   331, "Andrew Corporation" },
    {   332, "Digi International" },
    {   333, "Computer Network Technology" },
    {   334, "Lotus Development Corp." },
    {   335, "MICOM Communication Corporation" },
    {   336, "ASCII Corporation" },
    {   337, "PUREDATA Research" },
    {   338, "NTT DATA" },
    {   339, "Siemens Industry Inc." },
    {   340, "Kendall Square Research (KSR)" },
    {   341, "ORNL" },
    {   342, "Network Innovations, Inc." },
    {   343, "Intel Corporation" },
    {   344, "Compuware Corporation" },
    {   345, "Epson Research Center" },
    {   346, "Fibernet" },
    {   347, "Dot Hill Systems" },
    {   348, "American Express Company" },
    {   349, "Compu-Shack" },
    {   350, "Parallan Computer, Inc." },
    {   351, "Stratacom" },
    {   352, "Open Networks Engineering, Inc." },
    {   353, "ATM Forum" },
    {   354, "SSD Management, Inc." },
    {   355, "Automated Network Management, Inc." },
    {   356, "Magnalink Communications Corporation" },
    {   357, "Kasten Chase Applied Research" },
    {   358, "Skyline Technology, Inc." },
    {   359, "Nu-Mega Technologies, Inc." },
    {   360, "Morgan Stanley & Co. International PLC" },
    {   361, "Integrated Business Network" },
    {   362, "L & N Technologies, Ltd." },
    {   363, "Cincinnati Bell Information Systems, Inc." },
    {   364, "RAMA Technologies" },
    {   365, "MICROGNOSIS" },
    {   366, "Datapoint Corporation" },
    {   367, "RICOH Co. Ltd." },
    {   368, "Axis Communications AB" },
    {   369, "Pacer Software" },
    {   370, "3COM/Axon" },
    {   371, "Alebra Technologies, Inc." },
    {   372, "GSI" },
    {   373, "Tatung Co., Ltd." },
    {   374, "DIS Research Ltd." },
    {   375, "Quotron Systems, Inc." },
    {   376, "Dassault Electronique" },
    {   377, "Corollary, Inc." },
    {   378, "SEEL, Ltd." },
    {   379, "Lexcel" },
    {   380, "pier64" },
    {   381, "OST" },
    {   382, "Megadata Pty Ltd." },
    {   383, "LLNL Livermore Computer Center" },
    {   384, "Dynatech Communications" },
    {   385, "Symplex Communications Corp." },
    {   386, "Tribe Computer Works" },
    {   387, "Taligent, Inc." },
    {   388, "Symbol Technologies, Inc." },
    {   389, "Lancert" },
    {   390, "Alantec" },
    {   391, "Ridgeback Solutions" },
    {   392, "Metrix, Inc." },
    {   393, "Symantec Corporation" },
    {   394, "NRL Communication Systems Branch" },
    {   395, "I.D.E. Corporation" },
    {   396, "Panasonic Electric Works Co., Ltd." },
    {   397, "MegaPAC" },
    {   398, "Tyco Electronics" },
    {   399, "Hitachi Computer Products (America), Inc." },
    {   400, "METEO FRANCE" },
    {   401, "PRC Inc." },
    {   402, "Wal-Mart Stores, Inc." },
    {   403, "Nissin Electric Company, Ltd." },
    {   404, "Distributed Support Information Standard" },
    {   405, "SMDS Interest Group (SIG)" },
    {   406, "SolCom Systems Ltd." },
    {   407, "Bell Atlantic" },
    {   408, "Advanced Multiuser Technologies Corporation" },
    {   409, "Mitsubishi Electric Corporation" },
    {   410, "C.O.L. Systems, Inc." },
    {   411, "University of Auckland" },
    {   412, "Distributed Management Task Force (DMTF)" },
    {   413, "Klever Computers, Inc.Tom Su" },
    {   414, "Amdahl Corporation" },
    {   415, "JTEC Pty, Ltd." },
    {   416, "Matra Communcation" },
    {   417, "HAL Computer Systems" },
    {   418, "Lawrence Berkeley Laboratory" },
    {   419, "Dale Computer Corporation" },
    {   420, "University of Tuebingen" },
    {   421, "Bytex Corporation" },
    {   422, "Cogwheel, Inc." },
    {   423, "Lanwan Technologies" },
    {   424, "Thomas-Conrad Corporation" },
    {   425, "TxPort" },
    {   426, "Compex, Inc." },
    {   427, "Evergreen Systems, Inc." },
    {   428, "HNV, Inc." },
    {   429, "UTStarcom Incorporated" },
    {   430, "Canada Post Corporation" },
    {   431, "Open Systems Solutions, Inc." },
    {   432, "Toronto Stock Exchange" },
    {   433, "Mamakos\\TransSys Consulting" },
    {   434, "EICON" },
    {   435, "Jupiter Systems" },
    {   436, "SSTI" },
    {   437, "Grand Junction Networks" },
    {   438, "Pegasus Solutions, Inc." },
    {   439, "Edward D. Jones and Company" },
    {   440, "Amnet, Inc." },
    {   441, "Chase Research" },
    {   442, "BMC Software" },
    {   443, "Gateway Communications, Inc." },
    {   444, "Peregrine Systems" },
    {   445, "Daewoo Telecom" },
    {   446, "Norwegian Telecom Research" },
    {   447, "WilTel" },
    {   448, "Ericsson-Camtec" },
    {   449, "Codex" },
    {   450, "Basis" },
    {   451, "AGE Logic" },
    {   452, "INDE Electronics" },
    {   453, "Isode Limited" },
    {   454, "J.I. Case" },
    {   455, "Trillium" },
    {   456, "Bacchus Inc." },
    {   457, "MCC" },
    {   458, "Stratus Computer" },
    {   459, "Quotron" },
    {   460, "Beame & Whiteside" },
    {   461, "Cellular Technical Services" },
    {   462, "Shore Microsystems, Inc." },
    {   463, "Telecommunications Techniques Corp." },
    {   464, "DNPAP (Technical University Delft)" },
    {   465, "Plexcom, Inc." },
    {   466, "Tylink" },
    {   467, "Brookhaven Laboratory" },
    {   468, "Computer Communication Systems" },
    {   469, "Norand Corporation" },
    {   470, "MUX-LAP" },
    {   471, "Premisys Communications, Inc" },
    {   472, "Bell South Telecommunications" },
    {   473, "J. Stainsbury PLC" },
    {   474, "Manage Operations" },
    {   475, "Wandel and Goltermann Technologies" },
    {   476, "Vertiv (formerly 'Emerson Computer Power')" },
    {   477, "Network Software Associates" },
    {   478, "Procter and Gamble" },
    {   479, "Meridian Technology Corporation" },
    {   480, "QMS, Inc." },
    {   481, "Network ExpressTom Jarema" },
    {   482, "LANcity Corporation" },
    {   483, "Dayna Communications, Inc." },
    {   484, "kn-X Ltd." },
    {   485, "Sync Research, Inc." },
    {   486, "PremNet" },
    {   487, "SIAC" },
    {   488, "New York Stock Exchange" },
    {   489, "American Stock Exchange" },
    {   490, "FCR Software, Inc." },
    {   491, "National Medical Care, Inc." },
    {   492, "DCS Dialog Communication Systems Aktiengesellschaft Berlin" },
    {   493, "NorTele" },
    {   494, "Madge Networks, Inc." },
    {   495, "Memotec Communications" },
    {   496, "ON" },
    {   497, "Leap Technology, Inc." },
    {   498, "General DataComm, Inc." },
    {   499, "ACE Communications, Ltd." },
    {   500, "ADP" },
    {   501, "European Agency of Digital Trust (formerly 'Programa SPRITEL')" },
    {   502, "Adacom" },
    {   503, "Metrodata Ltd" },
    {   504, "Ellemtel Telecommunication Systems Laboratories" },
    {   505, "Arizona Public Service" },
    {   506, "NETWIZ, Ltd.," },
    {   507, "Science and Engineering Research Council (SERC)" },
    {   508, "508 Credit Suisse First Boston - Watcher" },
    {   509, "Hadax Electronics Inc." },
    {   510, "VTKK" },
    {   511, "North Hills Israel Ltd." },
    {   512, "TECSIEL" },
    {   513, "Bayerische Motoren Werke (BMW) AG" },
    {   514, "CNET Technologies" },
    {   515, "MCI" },
    {   516, "Human Engineering AG (HEAG)" },
    {   517, "FileNet Corporation" },
    {   518, "Kongsberg Gruppen ASA (formerly 'NFT-Ericsson')" },
    {   519, "Dun & Bradstreet" },
    {   520, "Intercomputer Communications" },
    {   521, "Defense Intelligence Agency" },
    {   522, "Telesystems SLW Inc." },
    {   523, "APT Communications" },
    {   524, "Delta Airlines" },
    {   525, "California Microwave" },
    {   526, "Avid Technology Inc" },
    {   527, "Integro Advanced Computer Systems" },
    {   528, "RPTI" },
    {   529, "Ascend Communications Inc." },
    {   530, "Eden Computer Systems Inc." },
    {   531, "Kawasaki-Steel Corp" },
    {   532, "Systems Management Infrasture, Barclays Bank PLC" },
    {   533, "B.U.G., Inc." },
    {   534, "Eaton Corporation" },
    {   535, "Superconducting Supercollider Lab." },
    {   536, "Triticom" },
    {   537, "Universal Instruments Corp." },
    {   538, "Information Resources, Inc." },
    {   539, "Kentrox" },
    {   540, "Crypto AG" },
    {   541, "Infinite Networks, Ltd." },
    {   542, "Tangram Enterprise Solutions, Inc." },
    {   543, "Alebra Technologies, Inc." },
    {   544, "Equinox Systems, Inc." },
    {   545, "Hayes Microcomputer Products" },
    {   546, "Empire Technologies Inc." },
    {   547, "Glaxochem, Ltd." },
    {   548, "Software Professionals, Inc" },
    {   549, "Agent Technology, Inc." },
    {   550, "Dornier GMBH" },
    {   551, "Telxon Corporation" },
    {   552, "Entergy Corporation" },
    {   553, "GarrettCom, Inc (formerly 'Garrett Communications')" },
    {   554, "Agile Networks, Inc." },
    {   555, "Larscom" },
    {   556, "Stock Equipment" },
    {   557, "ITT Corporation" },
    {   558, "Universal Data Systems, Inc." },
    {   559, "Sonix Communications, Ltd." },
    {   560, "Paul Freeman Associates, Inc." },
    {   561, "John S. Barnes, Corp." },
    {   562, "Northern Telecom, Ltd." },
    {   563, "CAP Debris" },
    {   564, "Telco Systems NAC" },
    {   565, "Tosco Refining Co" },
    {   566, "Russell Info Sys" },
    {   567, "University of Salford" },
    {   568, "NetQuest Corp." },
    {   569, "Armon Networking Ltd." },
    {   570, "IA Corporation" },
    {   571, "AU-System Communicaton AB" },
    {   572, "GoldStar Information & Communications, Ltd." },
    {   573, "SECTRA AB" },
    {   574, "ONEAC Corporation" },
    {   575, "Tree Technologies" },
    {   576, "General Dynamics C4 Systems" },
    {   577, "Geneva Software, Inc." },
    {   578, "Interlink Computer Sciences, Inc." },
    {   579, "Bridge Information Systems, Inc." },
    {   580, "Leeds and Northrup Australia (LNA) Nigel Cook" },
    {   581, "CSG Systems International (formerly 'Intec Telecom Systems')" },
    {   582, "Newport Systems Solutions, Inc." },
    {   583, "azel Corporation" },
    {   584, "ROBOTIKER" },
    {   585, "PeerLogic Inc." },
    {   586, "Digital Transmittion Systems" },
    {   587, "Far Point Communications" },
    {   588, "Xircom" },
    {   589, "Mead Data Central" },
    {   590, "Royal Bank of Canada" },
    {   591, "Advantis, Inc." },
    {   592, "Chemical Banking Corp." },
    {   593, "Eagle Technology" },
    {   594, "BT" },
    {   595, "Radix BV" },
    {   596, "TAINET Communication System Corp." },
    {   597, "Comtek Services Inc." },
    {   598, "Fair Isaac Corporation" },
    {   599, "AST Research Inc." },
    {   600, "Soft*Star s.r.l. Ing. Enrico Badella" },
    {   601, "Bancomm" },
    {   602, "Trusted Information Systems, Inc." },
    {   603, "Harris & Jeffries, Inc." },
    {   604, "Axel Technology Corp." },
    {   605, "NetTest Inc." },
    {   606, "CAP debis" },
    {   607, "Lachman Technology, Inc." },
    {   608, "Galcom Networking Ltd." },
    {   609, "BAZIS" },
    {   610, "SYNAPTEL" },
    {   611, "Investment Management Services, Inc." },
    {   612, "Taiwan Telecommunication Lab" },
    {   613, "Anagram Corporation" },
    {   614, "Univel" },
    {   615, "University of California, San Diego" },
    {   616, "CompuServe" },
    {   617, "Telstra - OTC Australia" },
    {   618, "Westinghouse Electric Corp." },
    {   619, "DGA Ltd." },
    {   620, "Elegant Communications Inc." },
    {   621, "Experdata" },
    {   622, "Unisource Business Networks Sweden AB" },
    {   623, "Molex, Inc." },
    {   624, "Quay Financial Software" },
    {   625, "VMX Inc." },
    {   626, "Hypercom, Inc." },
    {   627, "University of Guelph" },
    {   628, "DIaLOGIKa" },
    {   629, "NBASE Switch Communication" },
    {   630, "Anchor Datacomm B.V." },
    {   631, "PACDATA" },
    {   632, "University of Colorado" },
    {   633, "Tricom Communications Limited" },
    {   634, "Santix Software GmbH" },
    {   635, "Encore Networks, Inc." },
    {   636, "Georgia Institute of Technology" },
    {   637, "Alcatel-Lucent (formerly 'Alcatel Data Network')" },
    {   638, "GTECH" },
    {   639, "UNOCAL Corporation" },
    {   640, "First Pacific Network" },
    {   641, "Lexmark International" },
    {   642, "Qnix Computer" },
    {   643, "Jigsaw Software Concepts (Pty) Ltd." },
    {   644, "Eastern Research Inc." },
    {   645, "nsgdata.com Inc" },
    {   646, "SEIKO Communication Systems, Inc." },
    {   647, "Unified Management" },
    {   648, "RADLINX Ltd." },
    {   649, "Microplex Systems Ltd." },
    {   650, "Trio Information Systems AB" },
    {   651, "Phoenix Microsystems" },
    {   652, "Distributed Systems International, Inc." },
    {   653, "Evolving Systems, Inc." },
    {   654, "SAT GmbH" },
    {   655, "CeLAN Technology, Inc." },
    {   656, "Landmark Systems Corp." },
    {   657, "Netone Systems Co., Ltd." },
    {   658, "Loral Data Systems" },
    {   659, "Cellware Broadband Technology" },
    {   660, "MuSys Corporation" },
    {   661, "IMC Networks Corp." },
    {   662, "Octel Communications Corp." },
    {   663, "RIT Technologies Ltd." },
    {   664, "Adtran" },
    {   665, "Netvion, Inc." },
    {   666, "Oki Electric Industry Co., Ltd." },
    {   667, "Specialix International" },
    {   668, "INESC (Instituto de Engenharia de Sistemas e Computadores)" },
    {   669, "Globalnet Communications" },
    {   670, "Product Line Engineer SVEC Computer Corp." },
    {   671, "Printer Systems Corp." },
    {   672, "Contec Micro Electronics USA" },
    {   673, "Unix Integration Services" },
    {   674, "Dell Inc." },
    {   675, "Whittaker Electronic Systems" },
    {   676, "QPSX Communications" },
    {   677, "Loral WDl" },
    {   678, "Federal Express Corp." },
    {   679, "E-COMMS Inc." },
    {   680, "Software Clearing House" },
    {   681, "Antlow Computers Ltd." },
    {   682, "Emcom Corp." },
    {   683, "Extended Systems, Inc." },
    {   684, "Sola Electric" },
    {   685, "Esix Systems, Inc." },
    {   686, "3M/MMM" },
    {   687, "Cylink Corp." },
    {   688, "Znyx Advanced Systems Division, Inc." },
    {   689, "Texaco, Inc." },
    {   690, "McCaw Cellular Communication Corp." },
    {   691, "ASP Computer Product Inc." },
    {   692, "HiPerformance Systems" },
    {   693, "Regionales Rechenzentrum Erlangen" },
    {   694, "SAP AG" },
    {   695, "ElectroSpace System Inc." },
    {   696, "( Unassigned )" },
    {   697, "MultiPort Corporation" },
    {   698, "Combinet, Inc." },
    {   699, "TSCC" },
    {   700, "Teleos Communications Inc." },
    {   701, "Alta Research" },
    {   702, "Independence Blue Cross" },
    {   703, "ADACOM Station Interconnectivity Ltd." },
    {   704, "MIROR Systems" },
    {   705, "Merlin Gerin" },
    {   706, "Owen-Corning Fiberglas" },
    {   707, "Talking Networks Inc." },
    {   708, "Cubix Corporation" },
    {   709, "Formation Inc." },
    {   710, "Lannair Ltd." },
    {   711, "LightStream Corp." },
    {   712, "LANart Corp." },
    {   713, "University of Stellenbosch" },
    {   714, "Wyse Technology" },
    {   715, "DSC Communications Corp." },
    {   716, "NetEc" },
    {   717, "Breltenbach Software Engineering GmbH" },
    {   718, "Victor Company of Japan,Limited" },
    {   719, "Japan Direx Corporation" },
    {   720, "NECSY Network Control Systems S.p.A. Piero Fiozzo" },
    {   721, "ISDN Systems Corp." },
    {   722, "Zero-One Technologies, Ltd." },
    {   723, "Radix Technologies, Inc." },
    {   724, "National Institute of Standards and Technology" },
    {   725, "Digital Technology Inc." },
    {   726, "Castelle Corp." },
    {   727, "Memotec Inc." },
    {   728, "Showa Electric Wire & Cable Co., Ltd." },
    {   729, "SpectraGraphics" },
    {   730, "Connectware Inc." },
    {   731, "Wind River Systems" },
    {   732, "RADWAY International Ltd." },
    {   733, "System Management ARTS, Inc." },
    {   734, "Persoft, Inc." },
    {   735, "Xnet Technology Inc." },
    {   736, "Unison-Tymlabs" },
    {   737, "Micro-Matic Research" },
    {   738, "B.A.T.M. Advance Technologies" },
    {   739, "University of Copenhagen" },
    {   740, "Network Security Systems, Inc." },
    {   741, "JNA Telecommunications" },
    {   742, "Encore Computer Corporation" },
    {   743, "Central Intelligence Agency" },
    {   744, "ISC (GB) Limited" },
    {   745, "Digital Communication Associates" },
    {   746, "CyberMedia Inc." },
    {   747, "Distributed Systems International, Inc." },
    {   748, "Peter Radig EDP-Consulting" },
    {   749, "Vicorp Interactive Systems" },
    {   750, "Inet Inc." },
    {   751, "Argonne National Lab" },
    {   752, "Teklogix" },
    {   753, "North Western University" },
    {   754, "Astarte Fiber Networks" },
    {   755, "Diederich & Associates, Inc." },
    {   756, "Florida Power Corporation" },
    {   757, "Ingres Corporation" },
    {   758, "Open Network Enterprise" },
    {   759, "The Home Depot" },
    {   760, "Pan Dacom Telekommunikations" },
    {   761, "NetTek" },
    {   762, "Karlnet Corp." },
    {   763, "Efficient Networks, Inc." },
    {   764, "Fiberdata" },
    {   765, "Lanser" },
    {   766, "Ericsson Denmark A/S, Telebit Division" },
    {   767, "QoSCom" },
    {   768, "Network Computing Inc." },
    {   769, "Walgreens Company" },
    {   770, "Internet Initiative Japan Inc." },
    {   771, "GP van Niekerk Ondernemings" },
    {   772, "Queen's University Belfast" },
    {   773, "Securities Industry Automation Corporation" },
    {   774, "SYNaPTICS" },
    {   775, "Data Switch Corporation" },
    {   776, "Telindus Distribution" },
    {   777, "MAXM Systems Corporation" },
    {   778, "Fraunhofer Gesellschaft" },
    {   779, "EQS Business Services" },
    {   780, "CNet Technology Inc." },
    {   781, "Datentechnik GmbH" },
    {   782, "Network Solutions, LLC" },
    {   783, "Viaman Software" },
    {   784, "Schweizerische Bankgesellschaft Zuerich" },
    {   785, "University of Twente - TIOS" },
    {   786, "Simplesoft Inc." },
    {   787, "Stony Brook, Inc." },
    {   788, "Unified Systems Solutions, Inc." },
    {   789, "Network Appliance Corporation" },
    {   790, "Ornet Data Communication Technologies Ltd." },
    {   791, "Computer Associates International" },
    {   792, "Wireless Incorporated" },
    {   793, "NYNEX Science & Technology" },
    {   794, "Commercial Link Systems" },
    {   795, "Adaptec Inc." },
    {   796, "Softswitch" },
    {   797, "Link Technologies, Inc." },
    {   798, "IIS" },
    {   799, "Mobile Solutions Inc." },
    {   800, "Xylan Corp." },
    {   801, "Airtech Software Forge Limited" },
    {   802, "National Semiconductor" },
    {   803, "Video Lottery Technologies" },
    {   804, "National Semiconductor Corp" },
    {   805, "Applications Management Corp" },
    {   806, "Travelers Insurance Company" },
    {   807, "Taiwan International Standard Electronics Ltd." },
    {   808, "US Patent and Trademark Office Rick" },
    {   809, "Hynet, Ltd." },
    {   810, "Aydin, Corp." },
    {   811, "ADDTRON Technology Co., Ltd." },
    {   812, "Fannie Mae" },
    {   813, "MultiNET Services" },
    {   814, "GECKO mbH" },
    {   815, "Memorex Telex" },
    {   816, "Advanced Communications Networks (ACN) SA" },
    {   817, "Telekurs AG" },
    {   818, "IMV Victron bv" },
    {   819, "CF6 Company" },
    {   820, "Walker Richer and Quinn Inc." },
    {   821, "Saturn Systems" },
    {   822, "Mitsui Marine and Fire Insurance Co. Ltd." },
    {   823, "Loop Telecommunication International, Inc." },
    {   824, "Telenex Corporation" },
    {   825, "Bus-Tech, Inc." },
    {   826, "ATRIE" },
    {   827, "Gallagher & Robertson A/S" },
    {   828, "Networks Northwest, Inc." },
    {   829, "Conner Peripherials" },
    {   830, "Elf Antar France" },
    {   831, "Lloyd Internetworking" },
    {   832, "Datatec Industries, Inc." },
    {   833, "TAICOM" },
    {   834, "Brown's Operating System Services Ltd." },
    {   835, "MiLAN Technology Corp." },
    {   836, "NetEdge Systems, Inc." },
    {   837, "NetFrame Systems" },
    {   838, "Xedia Corporation" },
    {   839, "Pepsi" },
    {   840, "Tricord Systems, Inc." },
    {   841, "Proxim Wireless, Inc" },
    {   842, "Applications Plus, Inc." },
    {   843, "Pacific Bell" },
    {   844, "Scorpio Communications" },
    {   845, "TPS-Teleprocessing Systems" },
    {   846, "Technology Solutions Company" },
    {   847, "Computer Site Technologies" },
    {   848, "NetPort Software" },
    {   849, "Alon Systems" },
    {   850, "Tripp Lite" },
    {   851, "NetComm Limited" },
    {   852, "Precision Systems, Inc.(PSI)" },
    {   853, "Objective Systems Integrators" },
    {   854, "Simpact, Inc." },
    {   855, "Systems Enhancement Corporation" },
    {   856, "Information Integration, Inc." },
    {   857, "CETREL S.C." },
    {   858, "Platinum Technology, Inc." },
    {   859, "Olivetti North America" },
    {   860, "WILMA" },
    {   861, "Thomson Financial" },
    {   862, "Total Peripherals Inc." },
    {   863, "SunNetworks Consultant" },
    {   864, "Arkhon Technologies, Inc." },
    {   865, "Computer Sciences Corporation" },
    {   866, "Philips Communication d'Entreprise Claude Lubin" },
    {   867, "Katron Technologies Inc." },
    {   868, "Transition Engineering Inc." },
    {   869, "Altos Engineering Applications, Inc." },
    {   870, "Nicecom Ltd." },
    {   871, "Fiskars/Deltec" },
    {   872, "AVM GmbH" },
    {   873, "Comm Vision" },
    {   874, "Institute for Information Industry" },
    {   875, "Legent Corporation" },
    {   876, "Network Automation" },
    {   877, "EView Technology" },
    {   878, "Coman Data Communications Ltd." },
    {   879, "Skattedirektoratet" },
    {   880, "Client-Server Technologies" },
    {   881, "Societe Internationale de Telecommunications Aeronautiques" },
    {   882, "Maximum Strategy Inc." },
    {   883, "Integrated Systems, Inc." },
    {   884, "E-Systems" },
    {   885, "RELTEC Corporation" },
    {   886, "Summa Four Inc." },
    {   887, "J & L Information Systems" },
    {   888, "Forest Computer Inc." },
    {   889, "Palindrome Corp." },
    {   890, "ZyXEL Communications Corp." },
    {   891, "Network Managers (UK) Ltd," },
    {   892, "Sensible Office Systems Inc." },
    {   893, "Informix Software" },
    {   894, "Dynatek Communications" },
    {   895, "Versalynx Corp." },
    {   896, "Potomac Scheduling Communications Company" },
    {   897, "Sybase, Inc" },
    {   898, "DiviCom Inc." },
    {   899, "Datus elektronische Informationssysteme GmbH" },
    {   900, "Matrox Electronic Systems Limited" },
    {   901, "Digital Products, Inc." },
    {   902, "Scitex Corp.Ltd." },
    {   903, "RAD Vision" },
    {   904, "Tran Network Systems" },
    {   905, "Scorpion Logic" },
    {   906, "Inotech Inc.Eric Jacobs" },
    {   907, "Controlled Power Co." },
    {   908, "ABB Inc. (formerly 'Elsag Bailey Incorporated')" },
    {   909, "J.P. Morgan" },
    {   910, "Clear Communications Corp." },
    {   911, "General Technology Inc." },
    {   912, "Adax Inc." },
    {   913, "Mtel Technologies, Inc." },
    {   914, "Underscore, Inc." },
    {   915, "SerComm Corp." },
    {   916, "Allegiance Corporation" },
    {   917, "Tellus Technology" },
    {   918, "Continuous Electron Beam Accelerator Facility" },
    {   919, "Canoga Perkins" },
    {   920, "R.I.S Technologies" },
    {   921, "INFONEX Corp." },
    {   922, "WordPerfect Corp." },
    {   923, "NRaD" },
    {   924, "Hong Kong Telecommunications Ltd." },
    {   925, "Signature Systems" },
    {   926, "Alpha Technologies, Inc." },
    {   927, "PairGain Technologies, Inc." },
    {   928, "Sonic Systems" },
    {   929, "Steinbrecher Corp." },
    {   930, "Centillion Networks, Inc." },
    {   931, "Network Communication Corp." },
    {   932, "Sysnet A.S." },
    {   933, "Telecommunication Systems Lab" },
    {   934, "QMI" },
    {   935, "Phoenixtec Power Co., Ltd." },
    {   936, "Hirakawa Hewtech Corp." },
    {   937, "No Wires Needed B.V." },
    {   938, "Primary Access" },
    {   939, "FD Software AS" },
    {   940, "g.a.m.s. edv-dienstleistungen" },
    {   941, "Nemesys Research Ltd." },
    {   942, "Pacific Communication Sciences, Inc." },
    {   943, "Level One Communications, Inc." },
    {   944, "Intellimon Software, LLC." },
    {   945, "Accenture (formerly 'Andersen Consulting')" },
    {   946, "Bay Technologies Pty Ltd." },
    {   947, "Integrated Network Corp." },
    {   948, "CyberPro International" },
    {   949, "Wang Laboratories Inc." },
    {   950, "Polaroid Corp." },
    {   951, "Sunrise Sierra" },
    {   952, "Silcon Group" },
    {   953, "Coastcom" },
    {   954, "4th DIMENSION SOFTWARE Ltd." },
    {   955, "SEIKO SYSTEMS Inc." },
    {   956, "PERFORM" },
    {   957, "TV/COM International" },
    {   958, "Network Integration, Inc." },
    {   959, "Sola Electric, A Unit of General Signal" },
    {   960, "Gradient Technologies, Inc." },
    {   961, "Tokyo Electric Co., Ltd." },
    {   962, "Codonics, Inc." },
    {   963, "Delft Technical University" },
    {   964, "Carrier Access Corp." },
    {   965, "eoncorp" },
    {   966, "Naval Undersea Warfare Center" },
    {   967, "AWA Limited" },
    {   968, "Distinct Corp." },
    {   969, "National Technical University of Athens" },
    {   970, "BGS Systems, Inc." },
    {   971, "AT&T Wireless (McCaw Wireless Data)" },
    {   972, "Bekaert" },
    {   973, "Epic Data Inc." },
    {   974, "Prodigy Services Co." },
    {   975, "First Pacific Networks (FPN)" },
    {   976, "Xylink Ltd." },
    {   977, "Relia Technologies Corp." },
    {   978, "Legacy Storage Systems Inc." },
    {   979, "Digicom, SPA" },
    {   980, "Ark Telecom" },
    {   981, "National Security Agency (NSA)" },
    {   982, "Southwestern Bell Corporation (AT&T) (formerly 'Southwestern Bell Corporation')" },
    {   983, "Virtual Design Group, Inc." },
    {   984, "Rhone Poulenc" },
    {   985, "Swiss Bank Corporation" },
    {   986, "ATEA N.V." },
    {   987, "Computer Communications Specialists, Inc." },
    {   988, "Object Quest, Inc." },
    {   989, "DCL System International, Ltd." },
    {   990, "SOLITON SYSTEMS K.K." },
    {   991, "U S Software" },
    {   992, "Systems Research and Applications Corporation" },
    {   993, "University of Florida" },
    {   994, "Dantel, Inc." },
    {   995, "Multi-Tech Systems, Inc." },
    {   996, "Softlink Ltd." },
    {   997, "ProSum" },
    {   998, "March Systems Consultancy, Ltd." },
    {   999, "Hong Technology, Inc." },
    {  1000, "Internet Assigned Numbers Authority" },
    {  1001, "PECO Energy Co." },
    {  1002, "United Parcel Service" },
    {  1003, "Storage Dimensions, Inc." },
    {  1004, "ITV Technologies, Inc." },
    {  1005, "TCPSI" },
    {  1006, "Promptus Communications, Inc." },
    {  1007, "Norman Data Defense Systems" },
    {  1008, "Pilot Network Services, Inc." },
    {  1009, "Integrated Systems Solutions Corporation" },
    {  1010, "SISRO" },
    {  1011, "NetVantage" },
    {  1012, "Marconi" },
    {  1013, "SURECOM" },
    {  1014, "Royal Hong Kong Jockey Club" },
    {  1015, "Gupta" },
    {  1016, "Tone Software Corporation" },
    {  1017, "Opus Telecom" },
    {  1018, "Cogsys Ltd." },
    {  1019, "Komatsu, Ltd." },
    {  1020, "ROI Systems, Inc" },
    {  1021, "Lightning Instrumentation SA" },
    {  1022, "TimeStep Corp." },
    {  1023, "INTELSAT" },
    {  1024, "Network Research Corporation Japan, Ltd." },
    {  1025, "Relational Development, Inc." },
    {  1026, "Emerald Systems, Corp." },
    {  1027, "Mitel, Corp." },
    {  1028, "Software AG" },
    {  1029, "MillenNet, Inc." },
    {  1030, "NK-EXA Corp." },
    {  1031, "BMC Software" },
    {  1032, "StarFire Enterprises, Inc." },
    {  1033, "Hybrid Networks, Inc." },
    {  1034, "Quantum Software GmbH" },
    {  1035, "Openvision Technologies Limited" },
    {  1036, "Healthcare Communications, Inc.(HCI)" },
    {  1037, "SAIT Systems" },
    {  1038, "SAGEMCOM SAS " },
    {  1039, "CompuSci Inc." },
    {  1040, "Aim Technology" },
    {  1041, "CIESIN" },
    {  1042, "Systems & Technologies International" },
    {  1043, "Israeli Electric Company (IEC) Yoram Harlev" },
    {  1044, "Phoenix Wireless Group, Inc." },
    {  1045, "SWL" },
    {  1046, "nCUBE" },
    {  1047, "Cerner, Corp." },
    {  1048, "Andersen Consulting" },
    {  1049, "Windstream Communications" },
    {  1050, "Acer" },
    {  1051, "Cedros" },
    {  1052, "AirAccess" },
    {  1053, "Expersoft Corporation" },
    {  1054, "Eskom" },
    {  1055, "SBE, Inc." },
    {  1056, "SS8" },
    {  1057, "American Computer and Electronics, Corp." },
    {  1058, "Syndesis Limited" },
    {  1059, "Isis Distributed Systems, Inc." },
    {  1060, "Priority Call Management" },
    {  1061, "Koelsch & Altmann GmbH" },
    {  1062, "WIPRO INFOTECH Ltd." },
    {  1063, "Controlware" },
    {  1064, "Mosaic Software" },
    {  1065, "Canon Information Systems" },
    {  1066, "AOL Inc." },
    {  1067, "Whitetree Network Technologies, Inc." },
    {  1068, "Northrop Grumman / Xetron" },
    {  1069, "Target Concepts, Inc." },
    {  1070, "DMH Software" },
    {  1071, "Innosoft International, Inc." },
    {  1072, "Controlware GmbH" },
    {  1073, "Telecommunications Industry Association (TIA) Mike" },
    {  1074, "Boole & Babbage" },
    {  1075, "System Engineering Support, Ltd." },
    {  1076, "SURFnet" },
    {  1077, "OpenConnect Systems, Inc." },
    {  1078, "PDTS (Process Data Technology and Systems)" },
    {  1079, "Cornet, Inc." },
    {  1080, "NetStar, Inc." },
    {  1081, "Semaphore Communications, Corp." },
    {  1082, "Casio Computer Co., Ltd." },
    {  1083, "CSIR" },
    {  1084, "APOGEE Communications" },
    {  1085, "Information Management Company" },
    {  1086, "Wordlink, Inc." },
    {  1087, "PEER" },
    {  1088, "Telstra Corp" },
    {  1089, "Net X, Inc." },
    {  1090, "PNC PLC" },
    {  1091, "DanaSoft, Inc." },
    {  1092, "Yokogawa-Hewlett-Packard" },
    {  1093, "Citem" },
    {  1094, "Link Telecom, Ltd." },
    {  1095, "Xirion bv" },
    {  1096, "Centigram Communications, Corp." },
    {  1097, "Gensym Corp." },
    {  1098, "Apricot Computers, Ltd." },
    {  1099, "CANAL+" },
    {  1100, "Cambridge Technology Partners" },
    {  1101, "MoNet Systems, Inc." },
    {  1102, "Metricom, Inc." },
    {  1103, "Xact, Inc" },
    {  1104, "Brave Software, Inc." },
    {  1105, "NetCell Systems, Inc." },
    {  1106, "Uni-QLennart Norlanderlennart.norlander&uniq.se" },
    {  1107, "DISA Space Systems Development Division" },
    {  1108, "INTERSOLV" },
    {  1109, "Vela Research, Inc." },
    {  1110, "Tetherless Access, Inc." },
    {  1111, "Magistrat Wien, AT" },
    {  1112, "Franklin Telecom, Inc." },
    {  1113, "EDA Instruments, Inc." },
    {  1114, "EFI Electronics, Corporation" },
    {  1115, "GMD" },
    {  1116, "Voicetek, Corp" },
    {  1117, "Avanti Technology, Inc." },
    {  1118, "ATLan LTD" },
    {  1119, "Lehman Brothers" },
    {  1120, "LAN-hopper Systems, Inc." },
    {  1121, "Web-Systems" },
    {  1122, "Piller GmbH" },
    {  1123, "Engenio Information Technologies, Inc." },
    {  1124, "NetSpan, Corp." },
    {  1125, "Nielsen Media Research" },
    {  1126, "Sterling Software" },
    {  1127, "Applied Network Technology, Inc." },
    {  1128, "Union Pacific Railroad" },
    {  1129, "Tec Corporation" },
    {  1130, "Datametrics Systems, Corporation Karl S." },
    {  1131, "Intersection Development Corporation Michael" },
    {  1132, "BACS Limited, GB" },
    {  1133, "Engage Communication" },
    {  1134, "Fastware, S.A." },
    {  1135, "LONGSHINE Electronics Corp." },
    {  1136, "BOW Networks, Inc." },
    {  1137, "emotion, Inc." },
    {  1138, "Rautaruukki steel factory, Information systems" },
    {  1139, "EMC Corp" },
    {  1140, "University of West England" },
    {  1141, "Com21" },
    {  1142, "Compression Tehnologies Inc." },
    {  1143, "Buslogic Inc." },
    {  1144, "Firefox Corporation" },
    {  1145, "Mercury Communications Ltd" },
    {  1146, "COMPUTER PROTOCOL MALAYSIA SDN. BHD." },
    {  1147, "Institute for Information Industry" },
    {  1148, "Pacific Electric Wire & Cable Co. Ltd." },
    {  1149, "MPR Teltech Ltd" },
    {  1150, "P-COM, Inc" },
    {  1151, "Anritsu Corporation" },
    {  1152, "SPYRUS" },
    {  1153, "NeTpower, Inc." },
    {  1154, "Diehl ISDN GmbH" },
    {  1155, "CARNet" },
    {  1156, "AS-TECH" },
    {  1157, "SG2 Innovation et Produits" },
    {  1158, "CellAccess Technology, Inc." },
    {  1159, "Bureau of Meteorology" },
    {  1160, "ELTRAX" },
    {  1161, "Thames Water Utilities Limited" },
    {  1162, "Micropolis, Corp." },
    {  1163, "Integrated Systems Technology" },
    {  1164, "Brite Voice Systems, Inc." },
    {  1165, "Associated Grocer" },
    {  1166, "General Instrument" },
    {  1167, "Stanford Telecom" },
    {  1168, "ICOM Informatique" },
    {  1169, "MPX Data Systems Inc." },
    {  1170, "Syntellect" },
    {  1171, "Polyhedra Ltd (formerly 'Perihelion Technology Ltd')" },
    {  1172, "Shoppers Drug Mart" },
    {  1173, "Apollo Travel Services Judith Williams-Murphy" },
    {  1174, "Time Warner Cable, Inc." },
    {  1175, "American Technology Labs Inc." },
    {  1176, "Dow Jones & Company, Inc." },
    {  1177, "FRA" },
    {  1178, "Equitable Life Assurance Society" },
    {  1179, "Smith Barney Inc." },
    {  1180, "Compact Data Ltd" },
    {  1181, "I.Net Communications" },
    {  1182, "Yamaha Corporation" },
    {  1183, "Illinois State University" },
    {  1184, "RADGuard Ltd." },
    {  1185, "Calypso Software Systems, Inc." },
    {  1186, "ACT Networks Inc." },
    {  1187, "Kingston Communications" },
    {  1188, "Incite" },
    {  1189, "VVNET, Inc." },
    {  1190, "Ontario Hydro" },
    {  1191, "CS-Telecom" },
    {  1192, "ICTV" },
    {  1193, "CORE International Inc." },
    {  1194, "Mibs4You" },
    {  1195, "ITK" },
    {  1196, "Network Integrity, Inc." },
    {  1197, "BlueLine Software, Inc." },
    {  1198, "Migrant Computing Services,Inc." },
    {  1199, "Linklaters & Paines" },
    {  1200, "EJV Partners, L.P." },
    {  1201, "Guardeonic Solutions Ltd." },
    {  1202, "VARCOM Corporation" },
    {  1203, "Equitel" },
    {  1204, "The Southern Company" },
    {  1205, "Dataproducts Corporation" },
    {  1206, "National Electrical Manufacturers Association (NEMA)" },
    {  1207, "RISCmanagement, Inc." },
    {  1208, "GVC Corporation" },
    {  1209, "timonWare Inc." },
    {  1210, "Capital Resources Computer Corporation" },
    {  1211, "Storage Technology Corporation" },
    {  1212, "Tadiran Telecom TTL." },
    {  1213, "NCP" },
    {  1214, "Operations Control Systems (OCS)" },
    {  1215, "The NASDAQ Stock Market Inc." },
    {  1216, "Tiernan Communications, Inc." },
    {  1217, "Goldman, Sachs Company" },
    {  1218, "Advanced Telecommunications Modules Ltd" },
    {  1219, "Phoenix Data Communications" },
    {  1220, "Quality Consulting Services" },
    {  1221, "MILAN" },
    {  1222, "Instrumental Inc." },
    {  1223, "Yellow Technology Services Inc." },
    {  1224, "Mier Communications Inc." },
    {  1225, "Cable Services Group Inc." },
    {  1226, "Forte Networks Inc." },
    {  1227, "American Management Systems, Inc." },
    {  1228, "Choice Hotels Intl." },
    {  1229, "SEH Computertechnik Gm Rainer Ellerbrake" },
    {  1230, "McAFee Associates Inc." },
    {  1231, "Network Intelligent Inc." },
    {  1232, "Luxcom Technologies, Inc." },
    {  1233, "ITRON Inc." },
    {  1234, "Linkage Software Inc." },
    {  1235, "Spardat AG" },
    {  1236, "VeriFone Inc." },
    {  1237, "Revco D.S., Inc." },
    {  1238, "HRB Systems, Inc." },
    {  1239, "Litton Fibercom" },
    {  1240, "Silex Technology America, Inc.  (formerly 'XCD, Incorporated')" },
    {  1241, "ProsjektLeveranser AS" },
    {  1242, "Halcyon Inc." },
    {  1243, "SBB" },
    {  1244, "LeuTek" },
    {  1245, "Zeitnet, Inc" },
    {  1246, "Visual Networks, Inc." },
    {  1247, "Coronet Systems" },
    {  1248, "SEIKO EPSON CORPORATION" },
    {  1249, "DnH Technologies" },
    {  1250, "Deluxe Data" },
    {  1251, "Michael A. Okulski Inc." },
    {  1252, "Saber Software Corporation" },
    {  1253, "Mission Systems, Inc." },
    {  1254, "Siemens Plessey Electronics Systems" },
    {  1255, "Applied Communications Inc," },
    {  1256, "Transaction Technology, Inc." },
    {  1257, "HST Ltd" },
    {  1258, "Michigan Technological University Onwuka" },
    {  1259, "Next Level Communications" },
    {  1260, "Instinet Corp." },
    {  1261, "Analog & Digital Systems Ltd." },
    {  1262, "Ansaldo Trasporti SpA" },
    {  1263, "ECCI" },
    {  1264, "Imatek Corporation" },
    {  1265, "PTT Telecom bv" },
    {  1266, "Data Race, Inc." },
    {  1267, "Network Safety Group, Inc." },
    {  1268, "Application des Techniques Nouvelles en Electronique" },
    {  1269, "MFS Communications Company" },
    {  1270, "Information Services Division" },
    {  1271, "Ciena Corporation" },
    {  1272, "Fujitsu Nexion" },
    {  1273, "Standard Networks, Inc" },
    {  1274, "Scientific Research Corporation" },
    {  1275, "micado SoftwareConsult GmbH" },
    {  1276, "Concert Management Services, Inc." },
    {  1277, "University of Delaware" },
    {  1278, "Bias Consultancy Ltd." },
    {  1279, "Micromuse Inc." },
    {  1280, "Translink Systems" },
    {  1281, "PI-NET" },
    {  1282, "Amber Wave Systems" },
    {  1283, "Superior Electronics Group Inc." },
    {  1284, "Network Telemetrics Inc" },
    {  1285, "BSW-Data" },
    {  1286, "ECI Telecom Ltd." },
    {  1287, "BroadVision" },
    {  1288, "ALFA, Inc." },
    {  1289, "TELEFONICA SISTEMAS, S.A." },
    {  1290, "Image Sciences, Inc." },
    {  1291, "MITSUBISHI ELECTRIC INFORMATION NETWORK CORPORATION (MIND)" },
    {  1292, "Central Flow Management Unit" },
    {  1293, "Woods Hole Oceanographic Institution" },
    {  1294, "Raptor Systems, Inc." },
    {  1295, "TeleLink Technologies Inc." },
    {  1296, "First Virtual Corporation" },
    {  1297, "Network Services Group" },
    {  1298, "SilCom Manufacturing Technology Inc." },
    {  1299, "NETSOFT Inc." },
    {  1300, "Fidelity Investments" },
    {  1301, "Telrad Telecommunications" },
    {  1302, "VERITAS Software Corp." },
    {  1303, "LeeMah DataCom Security Corporation" },
    {  1304, "Racemi, Inc." },
    {  1305, "USAir, Inc" },
    {  1306, "Jet Propulsion Laboratory" },
    {  1307, "ABIT Co" },
    {  1308, "Dataplex Pty. Ltd." },
    {  1309, "Creative Interaction Technologies, Inc." },
    {  1310, "AimNet Solutions" },
    {  1311, "Unassigned" },
    {  1312, "Klos Technologies, Inc." },
    {  1313, "ACOTEC" },
    {  1314, "Datacomm Management Sciences Inc." },
    {  1315, "MG-SOFT d.o.o." },
    {  1316, "Plessey Tellumat SA" },
    {  1317, "PaineWebber, Inc." },
    {  1318, "DATASYS Ltd." },
    {  1319, "QVC Inc." },
    {  1320, "IPL Systems" },
    {  1321, "Pacific Micro Data, Inc." },
    {  1322, "DeskNet Systems, Inc" },
    {  1323, "TC Technologies" },
    {  1324, "Racotek, Inc." },
    {  1325, "CelsiusTech AB" },
    {  1326, "Xing Technology Corp." },
    {  1327, "dZine n.v." },
    {  1328, "Electronic merchant Services, Inc." },
    {  1329, "Linmor Information Systems Management, Inc." },
    {  1330, "ABL Canada Inc." },
    {  1331, "University of Coimbra" },
    {  1332, "Iskratel, Ltd., Telecommunications Systems" },
    {  1333, "ISA Co.,Ltd." },
    {  1334, "CONNECT, Inc." },
    {  1335, "Digital Video" },
    {  1336, "InterVoice, Inc." },
    {  1337, "Liveware Tecnologia a Servico a Ltda" },
    {  1338, "Precept Software, Inc." },
    {  1339, "Heroix Corporation" },
    {  1340, "Holland House B.V." },
    {  1341, "Dedalus Engenharia S/C Ltda" },
    {  1342, "GEC ALSTHOM I.T." },
    {  1343, "Deutsches Elektronen-Synchrotron" },
    {  1344, "Avotus Corporation" },
    {  1345, "Dacoll Ltd" },
    {  1346, "NetCorp Inc." },
    {  1347, "KYOCERA Corporation" },
    {  1348, "The Longaberger Company" },
    {  1349, "ILEX" },
    {  1350, "Conservation Through Innovation, Limited" },
    {  1351, "SeeBeyond Technology Corporation" },
    {  1352, "Multex Systems, Inc." },
    {  1353, "Gambit Communications, Inc." },
    {  1354, "Central Data Corporation" },
    {  1355, "CompuCom Systems, Inc." },
    {  1356, "Generex Systems GMBH" },
    {  1357, "Periphonics Corporation" },
    {  1358, "Freddie Mac" },
    {  1359, "Digital Equipment bv" },
    {  1360, "PhoneLink plc" },
    {  1361, "Voice-Tel Enterprises, Inc." },
    {  1362, "AUDILOG" },
    {  1363, "SanRex Corporation" },
    {  1364, "Chloride" },
    {  1365, "GA Systems Ltd" },
    {  1366, "Microdyne Corporation" },
    {  1367, "Boston College" },
    {  1368, "Orange (formerly 'France Telecom')" },
    {  1369, "Stonesoft Corp" },
    {  1370, "A. G. Edwards & Sons, Inc." },
    {  1371, "Attachmate Corp." },
    {  1372, "LSI Logic" },
    {  1373, "interWAVE Communications, Inc." },
    {  1374, "mdl-Consult" },
    {  1375, "Frobbit AB (formerly 'Firma PAF')" },
    {  1376, "Nashoba Networks Inc" },
    {  1377, "Comedia Information AB" },
    {  1378, "Harvey Mudd College" },
    {  1379, "First National Bank of Chicago" },
    {  1380, "Department of National Defence (Canada)" },
    {  1381, "CBM Technologies, Inc." },
    {  1382, "InterProc Inc." },
    {  1383, "Glenayre R&D Inc." },
    {  1384, "Telenet GmbH Kommunikationssysteme" },
    {  1385, "Softlab GmbH" },
    {  1386, "Storage Computer Corporation" },
    {  1387, "CellStack Systems Ltd" },
    {  1388, "Viewgate Networks" },
    {  1389, "Simple Network Magic Corporation" },
    {  1390, "Stallion Technologies Pty Ltd" },
    {  1391, "Loan System" },
    {  1392, "DLR - Deutsche Forschungsanstalt fuer Luft- und Raumfahrt e.V." },
    {  1393, "ICRA, Inc." },
    {  1394, "Probita" },
    {  1395, "NEXOR Ltd" },
    {  1396, "American Internation Facsimile Products" },
    {  1397, "Tellabs" },
    {  1398, "DATAX" },
    {  1399, "IntelliSys Corporation" },
    {  1400, "Sandia National Laboratories" },
    {  1401, "Synerdyne Corp." },
    {  1402, "UNICOM Electric, Inc." },
    {  1403, "Central Design Systems Inc." },
    {  1404, "The Silk Road Group, Ltd." },
    {  1405, "Positive Computing Concepts" },
    {  1406, "First Data Resources" },
    {  1407, "INETCO Systems Limited" },
    {  1408, "NTT Mobile Communications Network Inc." },
    {  1409, "Target Stores" },
    {  1410, "Advanced Peripherals Technologies, Inc." },
    {  1411, "Juniper Networks/Funk Software" },
    {  1412, "DunsGate, a Dun and Bradstreet Company" },
    {  1413, "AFP" },
    {  1414, "VertexRSI, Controls and Structures" },
    {  1415, "The Williams Companies, Inc." },
    {  1416, "ASP Technologies, Inc." },
    {  1417, "Philips Communication Systems" },
    {  1418, "Dataprobe Inc." },
    {  1419, "ASTROCOM Corp." },
    {  1420, "CSTI(Communication Systems Technology, Inc.)" },
    {  1421, "Sprint" },
    {  1422, "Syntax" },
    {  1423, "LIGHT-INFOCON" },
    {  1424, "Performance Technology, Inc." },
    {  1425, "CXR" },
    {  1426, "Amir Technology Labs" },
    {  1427, "ISOCOR" },
    {  1428, "Array Technology Corportion" },
    {  1429, "Scientific-Atlanta, Inc." },
    {  1430, "GammaTech, Inc." },
    {  1431, "Telkom SA Limited" },
    {  1432, "CIREL SYSTEMES" },
    {  1433, "Redflex Limited Australia" },
    {  1434, "Hermes - Enterprise Messaging LTD" },
    {  1435, "Acacia Networks Inc." },
    {  1436, "NATIONAL AUSTRALIA BANK Ltd." },
    {  1437, "SineTec Technology Co.,Ltd." },
    {  1438, "Applied Innovation Inc." },
    {  1439, "Arizona State University" },
    {  1440, "Xionics Document Technologies, Inc." },
    {  1441, "Southern Information System Inc." },
    {  1442, "Nebula Consultants Inc." },
    {  1443, "SITRE, SA" },
    {  1444, "Paradigm Technology Ltd" },
    {  1445, "Telub AB" },
    {  1446, "Virginia Polytechnic Institute and State University" },
    {  1447, "Martis Oy" },
    {  1448, "ISKRA TRANSMISSION" },
    {  1449, "QUALCOMM Incorporated" },
    {  1450, "AOL / Netscape Communications Corp." },
    {  1451, "BellSouth Wireless, Inc." },
    {  1452, "NUKO Information Systems, Inc." },
    {  1453, "IPC Information Systems, Inc." },
    {  1454, "Estudios y Proyectos de Telecomunicacion, S.A." },
    {  1455, "Winstar Wireless" },
    {  1456, "Terayon Corp." },
    {  1457, "CyberGuard CorporationDavid Rhein" },
    {  1458, "AMCC" },
    {  1459, "Jupiter Technology, Inc." },
    {  1460, "Delphi Internet Services" },
    {  1461, "Kesmai Corporation" },
    {  1462, "Compact Devices, Inc." },
    {  1463, "OPTIQUEST" },
    {  1464, "Loral Defense Systems-Eagan" },
    {  1465, "OnRamp Technologies" },
    {  1466, "Mark Wahl" },
    {  1467, "Loran International Technologies, Inc." },
    {  1468, "S & S International PLC" },
    {  1469, "Atlantech Technologies Ltd." },
    {  1470, "IN-SNEC" },
    {  1471, "Melita International Corporation" },
    {  1472, "Sharp Laboratories of America" },
    {  1473, "Groupe Decan" },
    {  1474, "Spectronics Micro Systems Limited" },
    {  1475, "varetis COMMUNICATIONS GmbH" },
    {  1476, "ION Networks, Inc." },
    {  1477, "Telegate GlobalAccess Technology Ltd." },
    {  1478, "Merrill Lynch & Co., Inc." },
    {  1479, "JCPenney Co., Inc." },
    {  1480, "The Torrington Company" },
    {  1481, "GS-ProActive" },
    {  1482, "BarcoNet" },
    {  1483, "vortex Computersysteme GmbH" },
    {  1484, "DataFusion Systems (Pty) Ltd" },
    {  1485, "Allen & Overy" },
    {  1486, "Atlantic Systems Group" },
    {  1487, "Kongsberg Informasjonskontroll AS" },
    {  1488, "ELTECO a.s." },
    {  1489, "Schlumberger Limited" },
    {  1490, "CNI Communications Network International GmbH" },
    {  1491, "M&C Systems, Inc." },
    {  1492, "OM Systems International (OMSI) Mats" },
    {  1493, "DAVIC (Digital Audio-Visual Council) Richard" },
    {  1494, "ISM GmbH" },
    {  1495, "E.F. Johnson Co." },
    {  1496, "Baranof Software, Inc." },
    {  1497, "University of Texas Houston" },
    {  1498, "Ukiah Software Solutions/EDS/HDS" },
    {  1499, "STERIA" },
    {  1500, "ATI Australia Pty Limited" },
    {  1501, "The Aerospace Corporation Michael" },
    {  1502, "Orckit Communications Ltd." },
    {  1503, "Tertio Limited" },
    {  1504, "Comsoft Solutions GmbH (formerly 'COMSOFT GmbH')" },
    {  1505, "Power Center Software LLC" },
    {  1506, "Technologic, Inc." },
    {  1507, "Vertex Data Science Limited" },
    {  1508, "ESIGETEL" },
    {  1509, "Illinois Business Training Center Weixiong" },
    {  1510, "Arris Networks, Inc." },
    {  1511, "TeamQuest Corporation" },
    {  1512, "Sentient Networks" },
    {  1513, "Skyrr hf." },
    {  1514, "Tecnologia y Gestion de la Innovacion" },
    {  1515, "Connector GmbH" },
    {  1516, "Kaspia Systems, Inc." },
    {  1517, "SmithKline Beecham" },
    {  1518, "NetCentric Corp." },
    {  1519, "ATecoM GmbH" },
    {  1520, "Citibank Canada" },
    {  1521, "MMS (Matra Marconi Space)" },
    {  1522, "Intermedia Communications, Inc." },
    {  1523, "School of Computer Science, University Science of Malaysia" },
    {  1524, "University of Limerick" },
    {  1525, "ACTANE" },
    {  1526, "Collaborative Information Technology Research Institute(CITRI)" },
    {  1527, "Intermedium A/S" },
    {  1528, "ANS CO+RE Systems, Inc." },
    {  1529, "UUNET Technologies, Inc." },
    {  1530, "Telesciences, Inc." },
    {  1531, "QSC Audio Products" },
    {  1532, "Australian Department of Employment, Education and Training" },
    {  1533, "Network Media Communications Ltd." },
    {  1534, "Sodalia" },
    {  1535, "Innovative Concepts, Inc." },
    {  1536, "Japan Computer Industry Inc." },
    {  1537, "Telogy Networks, Inc." },
    {  1538, "Merck & Company, Inc." },
    {  1539, "GeoTel Communications Corporation" },
    {  1540, "Sun Alliance (UK)" },
    {  1541, "AG Communication Systems" },
    {  1542, "Pivotal Networking, Inc." },
    {  1543, "TSI TelSys Inc." },
    {  1544, "Harmonic Systems Incorporated" },
    {  1545, "ASTRONET Corporation" },
    {  1546, "Frontec" },
    {  1547, "NetVision" },
    {  1548, "FlowPoint Corporation" },
    {  1549, "Allied Data Technologies" },
    {  1550, "Nuera Communication Inc." },
    {  1551, "Radnet Ltd." },
    {  1552, "Oc\0303\0251 Technologies BV" },
    {  1553, "Air France" },
    {  1554, "Communications & Power Engineering, Inc." },
    {  1555, "Charter Systems" },
    {  1556, "Performance Technologies, Inc." },
    {  1557, "Paragon Networks International" },
    {  1558, "Skog-Data AS" },
    {  1559, "mitec a/s" },
    {  1560, "THOMSON-CSF / Departement Reseaux d'Entreprise" },
    {  1561, "Ipsilon Networks, Inc." },
    {  1562, "Kingston Technology Company" },
    {  1563, "Harmonic Lightwaves" },
    {  1564, "InterActive Digital Solutions" },
    {  1565, "Coactive Aesthetics, Inc." },
    {  1566, "Tech Data Corporation" },
    {  1567, "Z-Com" },
    {  1568, "COTEP" },
    {  1569, "Raytheon Company" },
    {  1570, "Telesend Inc." },
    {  1571, "NCC" },
    {  1572, "Forte Software, Inc." },
    {  1573, "McAfee (formerly 'Secure Computing Corporation')" },
    {  1574, "BEZEQ" },
    {  1575, "TU Braunschweig" },
    {  1576, "Stac Inc." },
    {  1577, "StarNet Communications" },
    {  1578, "Universidade do Minho" },
    {  1579, "Department of Computer Science, University of Liverpool" },
    {  1580, "Tekram Technology, Ltd." },
    {  1581, "RATP" },
    {  1582, "Rainbow Diamond Limited" },
    {  1583, "Magellan Communications, Inc" },
    {  1584, "Bay Networks Incorporated" },
    {  1585, "Quantitative Data Systems (QDS)" },
    {  1586, "ESYS Limited" },
    {  1587, "Switched Network Technologies (SNT)" },
    {  1588, "Brocade Communications Systems, Inc." },
    {  1589, "Computer Resources International A/S (CRI)" },
    {  1590, "Luchtverkeersleiding Nederland" },
    {  1591, "GTIL" },
    {  1592, "XactLabs Corporation" },
    {  1593, "Quest Software, Inc. (formerly 'NetPro Computing, Inc.')" },
    {  1594, "TELESYNC" },
    {  1595, "ewt breitbandnetze gmbh" },
    {  1596, "INS GmbH" },
    {  1597, "Distributed Processing Technology" },
    {  1598, "Tivoli Systems Inc." },
    {  1599, "Network Management Technologies" },
    {  1600, "SIRTI" },
    {  1601, "TASKE Technology Inc." },
    {  1602, "CANON Inc." },
    {  1603, "Systems and Synchronous, Inc." },
    {  1604, "XFER International" },
    {  1605, "Scandpower A/S" },
    {  1606, "Consultancy & Projects Group srl" },
    {  1607, "STS Technologies, Inc." },
    {  1608, "Mylex Corporation" },
    {  1609, "CRYPTOCard Corporation" },
    {  1610, "LXE, Inc." },
    {  1611, "BDM International, Inc." },
    {  1612, "Spacenet Inc." },
    {  1613, "Datanet GmbH" },
    {  1614, "Opcom, Inc." },
    {  1615, "Mlink Internet Inc." },
    {  1616, "SR-Telecom Inc." },
    {  1617, "Net Partners Inc." },
    {  1618, "Peek Traffic - Transyt Corp." },
    {  1619, "Comverse Information Systems" },
    {  1620, "Data Comm for Business, Inc." },
    {  1621, "CYBEC Pty. Ltd." },
    {  1622, "Mitsui Knowledge Industry Co.,Ltd." },
    {  1623, "Tech Laboratories, Inc." },
    {  1624, "Blockade Systems Corp." },
    {  1625, "Nixu Oy" },
    {  1626, "Australian Software Innovations (Services) Pty. Ltd." },
    {  1627, "Omicron Telesystems Inc." },
    {  1628, "DEMON Internet Ltd." },
    {  1629, "PB Farradyne, Inc." },
    {  1630, "Telos Corporation Sharon" },
    {  1631, "Manage Information Technologies" },
    {  1632, "Harlow Butler Broking Services Ltd." },
    {  1633, "Eurologic Systems Ltd" },
    {  1634, "Telco Research Corporation" },
    {  1635, "Mercedes-Benz AG" },
    {  1636, "HOB GmbH & Co. KG - HOB Germany" },
    {  1637, "NOAA" },
    {  1638, "Cornerstone Software" },
    {  1639, "Wink Communications" },
    {  1640, "Thomson Electronic Information Resources (TEIR)" },
    {  1641, "HITT Holland Institute of Traffic Technology B.V." },
    {  1642, "KPMG" },
    {  1643, "Loral Federal Systems" },
    {  1644, "S.I.A.- Societa Interbancaria per l'Automazione" },
    {  1645, "United States Cellular Corp." },
    {  1646, "AMPER DATOS S.A." },
    {  1647, "Carelcomp Forest Oy" },
    {  1648, "Open Environment Australia" },
    {  1649, "Integrated Telecom Technology, Inc." },
    {  1650, "Langner Gesellschaft fuer Datentechnik mbH" },
    {  1651, "Wayne State University" },
    {  1652, "SICC (SsangYong Information & Communications Corp.)" },
    {  1653, "THOMSON - CSF" },
    {  1654, "Teleconnect Dresden GmbH" },
    {  1655, "Panorama Software Inc." },
    {  1656, "CompuNet Systemhaus GmbH" },
    {  1657, "JAPAN TELECOM CO.,LTD." },
    {  1658, "TechForce Corporation" },
    {  1659, "Granite Systems Inc." },
    {  1660, "Bit Incorporated" },
    {  1661, "Companhia de Informatica do Parana - Celepar" },
    {  1662, "Rockwell International Corporation" },
    {  1663, "Ancor Communications" },
    {  1664, "Royal Institute of Technology, Sweden (KTH)" },
    {  1665, "SUNET, Swedish University Network" },
    {  1666, "Sage Instruments, Inc." },
    {  1667, "Candle Corporation" },
    {  1668, "CSO GmbH" },
    {  1669, "M3i Systems Inc." },
    {  1670, "CREDINTRANS" },
    {  1671, "ADVA Optical Networking Ltd." },
    {  1672, "Pierce & Associates" },
    {  1673, "RTS Wireless" },
    {  1674, "R.I.C. Electronics" },
    {  1675, "Amoco Corporation" },
    {  1676, "Qualix Group, Inc." },
    {  1677, "Sahara Networks, Inc." },
    {  1678, "Hyundai Electronics Industries Co.,Ltd." },
    {  1679, "RICH, Inc." },
    {  1680, "Amati Communications Corp." },
    {  1681, "P.H.U. RysTECH" },
    {  1682, "Data Labs Inc." },
    {  1683, "Occidental Petroleum Corporation" },
    {  1684, "Rijnhaave Internet Services" },
    {  1685, "Lynx Real-Time Systems, Inc." },
    {  1686, "QA IT Services Ltd" },
    {  1687, "SofTouch Systems, Inc." },
    {  1688, "Sonda S.A." },
    {  1689, "McCormick Nunes Company" },
    {  1690, "Ume E5 Universitet" },
    {  1691, "NetiQ Corporation" },
    {  1692, "Starlight Networks" },
    {  1693, "Informacion Selectiva S.A. de C.V. ( Infosel )" },
    {  1694, "HCL Technologies Limited" },
    {  1695, "Maryville Data Systems, Inc" },
    {  1696, "EtherCom Corp" },
    {  1697, "MultiCom Software" },
    {  1698, "BEA Systems Ltd." },
    {  1699, "Advanced Technology Ltd." },
    {  1700, "Mobil Oil" },
    {  1701, "Arena Consulting Limited" },
    {  1702, "Netsys International (Pty) Ltd" },
    {  1703, "Titan Information Systems Corp." },
    {  1704, "Cogent Data Technologies" },
    {  1705, "Reliasoft Corporation" },
    {  1706, "Midland Business Systems, Inc." },
    {  1707, "Optimal Networks" },
    {  1708, "Gresham Computing plc" },
    {  1709, "Leidos, Inc. (formerly 'SAIC')" },
    {  1710, "Acclaim Communications" },
    {  1711, "BISS Limited" },
    {  1712, "Caravelle Inc." },
    {  1713, "Diamond Lane Communications Corporation" },
    {  1714, "Infortrend Technology, Inc." },
    {  1715, "Ardatis N.V (formerly 'Orda-B N.V.')" },
    {  1716, "Ariel Corporation" },
    {  1717, "Datalex Communications Ltd." },
    {  1718, "Server Technology Inc." },
    {  1719, "Unimax Systems Corporation" },
    {  1720, "DeTeMobil GmbH" },
    {  1721, "INFONOVA GmbH" },
    {  1722, "Kudelski SA" },
    {  1723, "Pronet GmbH" },
    {  1724, "Westell, Inc." },
    {  1725, "Nupon Computing, Inc." },
    {  1726, "Cianet Ind e Com Ltda (Cianet Networking)" },
    {  1727, "Aumtech of Virginia (amteva)" },
    {  1728, "CheongJo data communication, Inc." },
    {  1729, "Genesys Telecommunications Laboratories Inc.(Genesys Labs.)" },
    {  1730, "Progress SoftwareAndrew Neumann" },
    {  1731, "ERICSSON FIBER ACCESS" },
    {  1732, "Open Access Pty Ltd" },
    {  1733, "Sterling Commerce" },
    {  1734, "Predictive Systems Inc." },
    {  1735, "Architel Systems Corporation" },
    {  1736, "QWEST NMS" },
    {  1737, "Eclipse Technologies Inc." },
    {  1738, "Navy" },
    {  1739, "Bindi Technologies, Pty Ltd" },
    {  1740, "Hallmark Cards Inc." },
    {  1741, "Object Design, Inc." },
    {  1742, "Unassigned" },
    {  1743, "Zenith Data Systems (ZDS)" },
    {  1744, "Gobi Corp." },
    {  1745, "Universitat de Barcelona" },
    {  1746, "Institute for Simulation and Training (IST)" },
    {  1747, "US Agency for International Development" },
    {  1748, "Tut Systems, Inc." },
    {  1749, "AnswerZ Pty Ltd (Australia)" },
    {  1750, "H.Bollmann Manufacturers Ltd (HBM)" },
    {  1751, "Lucent Technologies" },
    {  1752, "phase2 networks Inc." },
    {  1753, "Unify Corporation" },
    {  1754, "Gadzoox Microsystems Inc." },
    {  1755, "Network One, Inc." },
    {  1756, "MuLogic b.v." },
    {  1757, "Optical Microwave Networks, Inc." },
    {  1758, "SITEL, Ltd." },
    {  1759, "Cerg Finance" },
    {  1760, "American Internet Corporation" },
    {  1761, "PLUSKOM GmbH" },
    {  1762, "Dept. of Communications, Graz University of Technology" },
    {  1763, "EarthLink Inc." },
    {  1764, "Real Soft, Inc" },
    {  1765, "Apex Voice Communications, Inc." },
    {  1766, "National DataComm Corporation" },
    {  1767, "Telenor Conax AS" },
    {  1768, "Patton Electronics Company" },
    {  1769, "Digital Fairway Corporation" },
    {  1770, "BroadBand Technologies, Inc." },
    {  1771, "Myricom" },
    {  1772, "DecisionOne" },
    {  1773, "Tandberg Television" },
    {  1774, "AUDITEC SA" },
    {  1775, "PC Magic" },
    {  1776, "Koninklijke Philips Electronics NV" },
    {  1777, "ORIGIN" },
    {  1778, "CSG Systems" },
    {  1779, "Alphameric Technologies Ltd" },
    {  1780, "NCR Austria Michael Ostendorf" },
    {  1781, "ChuckK, Inc." },
    {  1782, "PowerTV, Inc." },
    {  1783, "webMethods" },
    {  1784, "Enron Capitol & Trade Resources" },
    {  1785, "ORBCOMM" },
    {  1786, "Jw direct shop" },
    {  1787, "B.E.T.A." },
    {  1788, "Healtheon" },
    {  1789, "Integralis Ltd." },
    {  1790, "Folio Corporation" },
    {  1791, "ECTF" },
    {  1792, "WebPlanet" },
    {  1793, "nStor Corporation" },
    {  1794, "Deutsche Bahn AG" },
    {  1795, "Paradyne" },
    {  1796, "Nastel Technologies, Inc." },
    {  1797, "Metaphase Technology, Inc." },
    {  1798, "Zweigart & Sawitzki" },
    {  1799, "PIXEL" },
    {  1800, "WaveAccess Inc." },
    {  1801, "The SABRE Group" },
    {  1802, "Redland Technology Corp." },
    {  1803, "PBS" },
    {  1804, "Consensus Development Corporation" },
    {  1805, "SAGEM SA" },
    {  1806, "I-Cube Inc." },
    {  1807, "INTRACOM S.A HELLENIC TELECOMMUNICATION AND ELECTRONICS INDUSTRY)" },
    {  1808, "Aetna, Inc." },
    {  1809, "Dow Jones Markets, Inc." },
    {  1810, "Czech Railways s.o. CITJaroslav Militky" },
    {  1811, "Scan-Matic A/S" },
    {  1812, "DECISION Europe Joel CHOTARD" },
    {  1813, "VTEL Corporation" },
    {  1814, "Bloomberg, L.P." },
    {  1815, "Verint Systems, Inc (formerly Witness Systems, Inc)" },
    {  1816, "Rose-Hulman Institute of Technology" },
    {  1817, "Aether Technologies" },
    {  1818, "Infonet Software SolutionsDavid Hauck" },
    {  1819, "CSTI (Compagnie des Signaux / Technologies Informatiques)Mr Camille Breeus" },
    {  1820, "LEROY MERLINRIGAULT Alain" },
    {  1821, "Total Entertainment Network" },
    {  1822, "Open Port Technology" },
    {  1823, "Mikroelektronik Anwendungszentrum Hamburg GmbHZ" },
    {  1824, "International Management Consulting, Inc." },
    {  1825, "Fore Systems, Inc." },
    {  1826, "MTech Systems" },
    {  1827, "RxSoft Ltd.Timothy Madden" },
    {  1828, "Dept. Computer Studies, Loughborough University" },
    {  1829, "Beta80 S.p.A." },
    {  1830, "Galiso Incorporated" },
    {  1831, "S2 Systems, Inc." },
    {  1832, "Optivision, Inc." },
    {  1833, "Countrywide Home Loans" },
    {  1834, "OA Laboratory Co., Ltd." },
    {  1835, "SDX Business Systems Ltd" },
    {  1836, "West End Systems Corp." },
    {  1837, "DK Digital Media" },
    {  1838, "Westel" },
    {  1839, "Fujitsu Service Limited" },
    {  1840, "Inmarsat" },
    {  1841, "TIMS Technology Ltd" },
    {  1842, "CallWare Technologies" },
    {  1843, "NextLink, L.L.C." },
    {  1844, "TurnQuay Solutions Limited" },
    {  1845, "Accusort Systems Inc" },
    {  1846, "Deutscher Bundestag" },
    {  1847, "Joint Research Centre" },
    {  1848, "FaxSav" },
    {  1849, "Chevy Chase Applications Design" },
    {  1850, "Bank Brussel Lambert (BBL)" },
    {  1851, "OutBack Resource Group, Inc." },
    {  1852, "Screen Subtitling Systems Ltd" },
    {  1853, "Cambridge Parallel Processing Ltd" },
    {  1854, "Boston University" },
    {  1855, "News Digital Systems Ltd" },
    {  1856, "NuTek 2000, Inc." },
    {  1857, "Overland Mobile Communication AB" },
    {  1858, "Axon IT AB" },
    {  1859, "Gradient Medical Systems" },
    {  1860, "WaveSpan Corporation" },
    {  1861, "Net Research, Inc." },
    {  1862, "Browncroft Community Church" },
    {  1863, "Net2Net Corporation" },
    {  1864, "US Internet" },
    {  1865, "Absolute Time" },
    {  1866, "VPNet" },
    {  1867, "NTech" },
    {  1868, "Nippon Unisoft Corporation" },
    {  1869, "Optical Transmission Labs, Inc." },
    {  1870, "CyberCash, Inc." },
    {  1871, "NetSpeed, Inc." },
    {  1872, "Alteon Networks, Inc." },
    {  1873, "Internet Middleware Corporation" },
    {  1874, "ISOnova GmbH" },
    {  1875, "Amiga IOPS Project" },
    {  1876, "Softbank Services Group" },
    {  1877, "Sourcecom Corporation" },
    {  1878, "Telia Promotor AB" },
    {  1879, "HeliOss Communications, Inc." },
    {  1880, "Optical Access International, Inc." },
    {  1881, "MMC Networks, Inc." },
    {  1882, "Lanyon Ltd." },
    {  1883, "Rubico" },
    {  1884, "Quantum Telecom Solutions, Inc." },
    {  1885, "Archinet" },
    {  1886, "i-cubed Ltd." },
    {  1887, "Albis Technologies Ltd. (formerly 'Siemens Switzerland Ltd.')" },
    {  1888, "GigaLabs, Inc." },
    {  1889, "MET Matra-Ericsson" },
    {  1890, "Red Lion Controls (JBM Electronics)" },
    {  1891, "OPTIM Systems, Inc." },
    {  1892, "Software Brewery" },
    {  1893, "WaveLinQ" },
    {  1894, "Siemens ICN" },
    {  1895, "IEX Corporation" },
    {  1896, "TrueTime" },
    {  1897, "HT Communications Inc." },
    {  1898, "Avantcomp Oy" },
    {  1899, "InfoVista" },
    {  1900, "Openwave Systems, Inc." },
    {  1901, "Sea Wonders" },
    {  1902, "HeadStart Enterprise" },
    {  1903, "B-SMART Inc." },
    {  1904, "ISMA Ltd" },
    {  1905, "3DV Technology, Inc." },
    {  1906, "StarCom Technologies Inc." },
    {  1907, "L.L.Bean" },
    {  1908, "NetIcs Inc." },
    {  1909, "Infratec plus GmbH" },
    {  1910, "3edges" },
    {  1911, "GISE mbHVolkmar Brisse / Hans-Jurgen Laub" },
    {  1912, "lan & pc services" },
    {  1913, "RedPoint Software Corporation" },
    {  1914, "Atempo Inc" },
    {  1915, "I-95-CC" },
    {  1916, "Extreme Networks" },
    {  1917, "Village of Rockville Centre" },
    {  1918, "Swichtec Power Systems" },
    {  1919, "Deutscher Wetterdienst" },
    {  1920, "Bluebird Software" },
    {  1921, "Svaha Interactive Media, Inc." },
    {  1922, "Sully Solutions" },
    {  1923, "Blue Line" },
    {  1924, "Castleton Network Systems Corp Glen Tracey tracey&castleton.com" },
    {  1925, "Visual Edge Software Ltd." },
    {  1926, "NetGuard Technologies, Inc." },
    {  1927, "SoftSell, Inc." },
    {  1928, "MARNE SOFTWARE" },
    {  1929, "Cadia Networks, Inc." },
    {  1930, "Milton" },
    {  1931, "Del Mar Solutions, Inc." },
    {  1932, "KUMARAN SYSTEMS" },
    {  1933, "Equivalence" },
    {  1934, "Homewatch International, Inc." },
    {  1935, "John Rivers" },
    {  1936, "Remark Services, Inc." },
    {  1937, "Deloitte & Touche Consulting Group" },
    {  1938, "Flying Penguin Productions" },
    {  1939, "The Matrix" },
    {  1940, "Eastern Computers, Inc." },
    {  1941, "Princeton BioMedica Inc." },
    {  1942, "SanCom Technology, Inc." },
    {  1943, "National Computing Centre Ltd." },
    {  1944, "Aval Communications" },
    {  1945, "WORTEC SearchNet CO." },
    {  1946, "Dogwood Media" },
    {  1947, "Allied Domecq" },
    {  1948, "Telesoft Russia" },
    {  1949, "UTStarcom, Inc." },
    {  1950, "comunit" },
    {  1951, "Traffic Sofware Ltd" },
    {  1952, "Qualop Systems Corp" },
    {  1953, "Vinca Corporation" },
    {  1954, "AMTEC spa" },
    {  1955, "GRETACODER Data Systems AG" },
    {  1956, "KMSystems, Inc." },
    {  1957, "GEVA" },
    {  1958, "Red Creek Communications, Inc." },
    {  1959, "BORG Technology Inc." },
    {  1960, "Concord Electronics" },
    {  1961, "Richard Ricci DDS" },
    {  1962, "Link International Corp." },
    {  1963, "Intermec Technologies Corp." },
    {  1964, "OPTIMUM Data AG" },
    {  1965, "DMCNW" },
    {  1966, "Perle Systems Limited" },
    {  1967, "inktomi corporation" },
    {  1968, "TELE-TV Systems, L.P." },
    {  1969, "Fritz-Haber-Institut" },
    {  1970, "mediaone.net" },
    {  1971, "SeaChange International Peter H." },
    {  1972, "CASTON Corporation" },
    {  1973, "Local Net" },
    {  1974, "JapanNet" },
    {  1975, "NabiscoKen ChristChristK&nabisco.com" },
    {  1976, "micrologica GmbH" },
    {  1977, "Network Harmoni, Inc." },
    {  1978, "SITA ADS" },
    {  1979, "Global Maintech Corporation" },
    {  1980, "Tele2 AB" },
    {  1981, "EMC CLARiiON Advanced Storage Solutions" },
    {  1982, "ITS Corporation" },
    {  1983, "CleverSoft, Inc." },
    {  1984, "The Perseus Group, Inc." },
    {  1985, "Joe's WWW Pages" },
    {  1986, "Everything Internet Store" },
    {  1987, "Numara Software, Inc" },
    {  1988, "Lycoming County PA" },
    {  1989, "Statens Institutions styrelse SiS" },
    {  1990, "INware Solutions Inc." },
    {  1991, "Brocade Communication Systems, Inc. (formerly 'Foundry Networks, Inc.')" },
    {  1992, "Deutsche Bank" },
    {  1993, "Xyratex" },
    {  1994, "Bausch Datacom B.V." },
    {  1995, "Advanced Radio Telecom (ART)" },
    {  1996, "Copper Mountain Communications Inc." },
    {  1997, "PlaNet Software Inc." },
    {  1998, "Carltan Computer Corporation" },
    {  1999, "Littva Mitchell, Inc." },
    {  2000, "TIBCO Inc." },
    {  2001, "Oki Data Corporation" },
    {  2002, "GoTel" },
    {  2003, "Adobe Systems Incorporated" },
    {  2004, "Sentricity" },
    {  2005, "Aeroports De Paris" },
    {  2006, "ECONZ Ltd" },
    {  2007, "TELDAT, S.A." },
    {  2008, "Offset Info Service srl" },
    {  2009, "A. J. Boggs & Company" },
    {  2010, "Stale Odegaard AS" },
    {  2011, "HUAWEI Technology Co.,Ltd" },
    {  2012, "Schroff GmbH" },
    {  2013, "Rehabilitation Institute of Chicago Angie" },
    {  2014, "ADC Telecommunications, Inc." },
    {  2015, "SYSTOR AG" },
    {  2016, "GraIyMage, Inc." },
    {  2017, "Symicron Computer Communications Ltd." },
    {  2018, "Scandorama AB" },
    {  2019, "I-NET" },
    {  2020, "Xland, Ltd." },
    {  2021, "U.C. Davis, ECE Dept. Tom" },
    {  2022, "CANARY COMMUNICATIONS, Inc." },
    {  2023, "NetGain" },
    {  2024, "West Information Publishing Group" },
    {  2025, "Deutsche Bundesbank" },
    {  2026, "Broadxent, Inc" },
    {  2027, "Gauss Interprise AG" },
    {  2028, "Aldiscon" },
    {  2029, "Vivid Image" },
    {  2030, "AfriQ*Access, Inc." },
    {  2031, "Reliant Networks Corporation Steven" },
    {  2032, "Mavenir Systems (formerly 'airwide solutions')" },
    {  2033, "McKinney Lighting & Sound" },
    {  2034, "Whole Systems Design, Inc." },
    {  2035, "O'Reilly & Associates, Inc." },
    {  2036, "Quantum Corporation" },
    {  2037, "Ernst and Young LLP" },
    {  2038, "Teleware Oy" },
    {  2039, "Fiducia Informationszentrale AG Ian" },
    {  2040, "Kinetics, Inc." },
    {  2041, "EMCEE Broadcast Products" },
    {  2042, "Clariant Corporation" },
    {  2043, "IEEE 802.5" },
    {  2044, "Open Development Corporation" },
    {  2045, "RFG SystemsRamon Ferreris" },
    {  2046, "Aspect Telecommunications" },
    {  2047, "Leo & Associates" },
    {  2048, "SoftLinx, Inc." },
    {  2049, "Generale Bank" },
    {  2050, "Windward Technologies Inc." },
    {  2051, "NetSolve, Inc." },
    {  2052, "Xantel" },
    {  2053, "arago, Institut fuer komplexes Datenmanagement GmbH" },
    {  2054, "Kokusai Denshin Denwa Co., Ltd" },
    {  2055, "GILLAM-SATEL" },
    {  2056, "MOEBIUS SYSTEMS" },
    {  2057, "Financial Internet Technology" },
    {  2058, "MARC Systems" },
    {  2059, "Bova Gallery" },
    {  2060, "OSx Telecomunicacoes" },
    {  2061, "Telecom Solutions" },
    {  2062, "CyberIQ Systems" },
    {  2063, "Ardent Communications Corporation" },
    {  2064, "Aware, Inc." },
    {  2065, "Racal Radio Limited" },
    {  2066, "Control Resources Corporation" },
    {  2067, "Advanced Fibre Communications (AFC)" },
    {  2068, "Elproma Electronica B.V." },
    {  2069, "MTA SZTAKI" },
    {  2070, "Consensys Computers Inc" },
    {  2071, "Jade Digital Research Co." },
    {  2072, "Byte This Interactive Pty.Ltd. Mike" },
    {  2073, "Financial Network Technologies Inc." },
    {  2074, "BROKAT Informationssysteme GmbH" },
    {  2075, "MediaWise Networks" },
    {  2076, "Future Software" },
    {  2077, "Commit Information Systems" },
    {  2078, "Virtual Access Ltd" },
    {  2079, "JDS FITEL Inc." },
    {  2080, "IPM DATACOM" },
    {  2081, "StarBurst Communications Corporation Kevin" },
    {  2082, "Tollgrade Communications, Inc." },
    {  2083, "Orange Services US" },
    {  2084, "Sanken Electric Co., Ltd." },
    {  2085, "Isolation Systems Limited" },
    {  2086, "AVIDIA Systems, Inc." },
    {  2087, "Cidera-Mainstream Services" },
    {  2088, "Radstone Technology Plc" },
    {  2089, "Philips Business Communications" },
    {  2090, "FMS Services" },
    {  2091, "Supernova Communications" },
    {  2092, "Murphy & Murphy Real Estate" },
    {  2093, "Multi-Platform Information Systems" },
    {  2094, "Allegro Consultants, Inc." },
    {  2095, "AIAB" },
    {  2096, "Preview Multimedia Services" },
    {  2097, "Access Beyond" },
    {  2098, "SunBurst Technology, Inc." },
    {  2099, "sotas" },
    {  2100, "CyberSouls Eternal Life Systems Inc." },
    {  2101, "HANWHA CORP./TELECOM" },
    {  2102, "COMET TELECOMMUNICATIONS INC" },
    {  2103, "CARY SYSTEMS, Inc." },
    {  2104, "Peerless Systems Corp Frank" },
    {  2105, "Adicom Wireless, Inc" },
    {  2106, "High Technology Software Corp" },
    {  2107, "Lynk" },
    {  2108, "Robin's Limousine" },
    {  2109, "Secant Network Tech" },
    {  2110, "Orion Pictures Corporation" },
    {  2111, "Global Village Communication, Inc." },
    {  2112, "ioWave, Inc." },
    {  2113, "Signals and Semaphores" },
    {  2114, "Mayo Foundation" },
    {  2115, "KRONE AG" },
    {  2116, "Computer Networking Resources, Inc" },
    {  2117, "Telenetworks" },
    {  2118, "Staffordshire University" },
    {  2119, "Broadband Networks Inc." },
    {  2120, "Federal Aviation Administration" },
    {  2121, "Technical Communications Corporation" },
    {  2122, "REZO+" },
    {  2123, "GrafxLab, Inc." },
    {  2124, "Savant Corp" },
    {  2125, "COMTEC SYSTEMS CO.,LTD. DEOK-HYOENG" },
    {  2126, "Satcom Media" },
    {  2127, "UconX Corporation" },
    {  2128, "TPG Network" },
    {  2129, "CNJ Incorporated" },
    {  2130, "Greenbrier & Russel" },
    {  2131, "mainnet" },
    {  2132, "Comnet DatensystemeHolger Zimmermanhzimmermann&cnd.de" },
    {  2133, "Novadigm, Inc." },
    {  2134, "Alfatech, Inc." },
    {  2135, "Financial Sciences Corporation Gary" },
    {  2136, "Electronics For Imaging, Inc." },
    {  2137, "Casabyte" },
    {  2138, "AssureNet Pathways, Inc." },
    {  2139, "Alexander LAN, Inc." },
    {  2140, "Gill-Simpson" },
    {  2141, "MCNS, L.P." },
    {  2142, "Future Systems, Inc." },
    {  2143, "IMGIS" },
    {  2144, "Skywire Corporation" },
    {  2145, "Irdeto Access B. V." },
    {  2146, "Peasantworks" },
    {  2147, "Onion Peel Software" },
    {  2148, "PS Partnership" },
    {  2149, "IRdg, Inc." },
    {  2150, "SDS Ltd." },
    {  2151, "Promus Hotel Corporation Oscar Pearce" },
    {  2152, "Cavid Lawrence Center" },
    {  2153, "Insider Technologies Ltd Paul Hancock" },
    {  2154, "Berkeley Networks" },
    {  2155, "Infonautics Corporation" },
    {  2156, "Easy Software" },
    {  2157, "CESG" },
    {  2158, "SALIX Technologies, Inc." },
    {  2159, "Essential Communications" },
    {  2160, "University of Hawaii" },
    {  2161, "Foxtel Management Pty" },
    {  2162, "ZOHO Corporation (formerly 'Advent Network Management')" },
    {  2163, "Vayris, S.A." },
    {  2164, "Telecom Multimedia Systems, Inc." },
    {  2165, "Guardall Ltd." },
    {  2166, "WKK SYSTEMS, Inc." },
    {  2167, "Prominet Corporation" },
    {  2168, "LMC Lan Management Consulting GmbH" },
    {  2169, "Lewis Enterprise" },
    {  2170, "Teles AG" },
    {  2171, "PCSI (Phoenix Control) Wayne Edward" },
    {  2172, "Fourth Wave Designs, Inc." },
    {  2173, "MediaGate, Inc." },
    {  2174, "Interactive Online Services, Inc." },
    {  2175, "Mutek Transcom Ltd." },
    {  2176, "University of Dortmund, IRB" },
    {  2177, "Network Diagnostic Clinic" },
    {  2178, "TSI - Telecom Systems Ltd." },
    {  2179, "WireSpeed Comm. Corp." },
    {  2180, "Versanet Communications, Inc." },
    {  2181, "EUnet Communications Services BV" },
    {  2182, "pow communications" },
    {  2183, "AMCommunications Inc." },
    {  2184, "Open Architecture Systems Integration Solutions (OASIS),Inc." },
    {  2185, "NetPartner s.r.o." },
    {  2186, "Vina Technologies" },
    {  2187, sminmpec_unknown },  /* (Added by Wireshark) */
    {  2188, sminmpec_unknown },  /* (Added by Wireshark) */
    {  2189, "Deutsches Klimarechenzentrum GmbH" },
    {  2190, "ABSYSSClaude-Aime MOTONGANEmotongane&absyss.fr" },
    {  2191, "Quadrophonics, Inc." },
    {  2192, "Hypercore Technology Inc." },
    {  2193, "OBTK, Inc., dba Network Designs Corporation" },
    {  2194, "VOIS Corporation" },
    {  2195, "IXO S.A." },
    {  2196, "Macro4 Open Systems Ltd." },
    {  2197, "RSA Security" },
    {  2198, "NextWave Wireless Inc." },
    {  2199, "Pisces Consultancy" },
    {  2200, "TPS Call Sciences, Inc (TPS) Paul L." },
    {  2201, "ICONSULT" },
    {  2202, "Third Point Systems" },
    {  2203, "MAS Technology Ltd." },
    {  2204, "Advanced Logic Research, Inc.(ALR)" },
    {  2205, "Documentum, Inc." },
    {  2206, "Siemens Business Communication Systems, Inc." },
    {  2207, "Telmax Communications Corp." },
    {  2208, "Zypcom, Inc." },
    {  2209, "Remote Sense" },
    {  2210, "OOTek Corporation" },
    {  2211, "eSoft, Inc." },
    {  2212, "anydata limited" },
    {  2213, "Data Fellows Ltd." },
    {  2214, "Productions Medialog Inc." },
    {  2215, "Inovamerci, Lda" },
    {  2216, "OKITEC" },
    {  2217, "Vertex Networks Inc." },
    {  2218, "Pulse Communications" },
    {  2219, "CXA Communications Ltd." },
    {  2220, "IDD Information Service" },
    {  2221, "Atlas Computer Equipment, Inc." },
    {  2222, "Syntegra" },
    {  2223, "CCC Information Services" },
    {  2224, "W. Quinn Associates" },
    {  2225, "Broadcom Eireann Research Ltd." },
    {  2226, "Risk Management Services llc" },
    {  2227, "Watkins-Johnson Company" },
    {  2228, "Eric E. Westbrook" },
    {  2229, "Martinho-Davis Systems Inc." },
    {  2230, "XYPOINT Corporation" },
    {  2231, "Innovat Communications, Inc." },
    {  2232, "Charleswood & Co." },
    {  2233, "ID Software AS" },
    {  2234, "Telia AB" },
    {  2235, "Exploration Enterprises, Inc." },
    {  2236, "Daimler-Benz Aerospace AG" },
    {  2237, "Xara Networks Ltd." },
    {  2238, "The FreeBSD Project" },
    {  2239, "World Merchandise Exchange (WOMEX) Ltd." },
    {  2240, "lysis" },
    {  2241, "CFL Research" },
    {  2242, "NET-TEL Computer Systems Limited" },
    {  2243, "Sattel Communications" },
    {  2244, "Promatory Communications Inc." },
    {  2245, "Catalogic Software Inc. (formerly 'Syncsort, Inc.')" },
    {  2246, "LloydsTSB Group Plc" },
    {  2247, "IT Consultancy Engineering Management Group Ltd." },
    {  2248, "LITE-ON COMMUNICATIONS Corp." },
    {  2249, "The New Millennium" },
    {  2250, "Quatraco Yugoslavia" },
    {  2251, "BR Business Systems" },
    {  2252, "WheelGroup Corporation Jonathan" },
    {  2253, "Ultimate Technology, Inc." },
    {  2254, "Delta Electronics, Inc." },
    {  2255, "Waffle Productions" },
    {  2256, "Korea Internet" },
    {  2257, "Selex Communications Limited (formerly 'BAE SYSTEMS')" },
    {  2258, "THOMSON BROADCAST SYSTEMS" },
    {  2259, "Workflow Automation Company Ltd." },
    {  2260, "Associated RT, Inc." },
    {  2261, "DRS Codem Systems" },
    {  2262, "RIGHT TIME WATCH CENTER FELIX" },
    {  2263, "Advanced-Vision Technologies, Inc." },
    {  2264, "Applied Intelligence Group Dana" },
    {  2265, "Acorn Computers Ltd." },
    {  2266, "Tempest Consulting Inc." },
    {  2267, "Digital Sound Corporation" },
    {  2268, "Fastlan Solutions, Inc." },
    {  2269, "Ordinox Network, Inc." },
    {  2270, "Telinc Corporation" },
    {  2271, "DRS Consulting Group" },
    {  2272, "Rapid City Communication" },
    {  2273, "Invisible Fence Sales Company" },
    {  2274, "Troika Management Services" },
    {  2275, "VXtreme Inc." },
    {  2276, "CryptSoft Pty Ltd" },
    {  2277, "Brooktrout Technology" },
    {  2278, "GRASS mbH" },
    {  2279, "EPiCon Inc." },
    {  2280, "SAD Trasporto Locale S.p.a" },
    {  2281, "Giganet Ltd" },
    {  2282, "INCAA Informatica Italia srl" },
    {  2283, "Vermont Firmware Corporation" },
    {  2284, "Automated Concepts" },
    {  2285, "Flash Networks Ltd" },
    {  2286, "Oracom Inc." },
    {  2287, "Shell Services Company" },
    {  2288, "Black Pigs of Death" },
    {  2289, "N3ERZ" },
    {  2290, "Technology Rendezvous Inc." },
    {  2291, "ZapNet! Inc." },
    {  2292, "Premier Technologies" },
    {  2293, "Tennyson Technologies" },
    {  2294, "Dot Hill Systems" },
    {  2295, "DH Technology, Inc." },
    {  2296, "DAGAZ Technologies, Inc." },
    {  2297, "Ganymede Software Inc." },
    {  2298, "Tele-Communications Inc." },
    {  2299, "FreeGate Corportation" },
    {  2300, "MainControl Inc." },
    {  2301, "Luminate Software Corp." },
    {  2302, "K2Net" },
    {  2303, "Aurora Communciations Pty. Ltd." },
    {  2304, "LANscape Limited" },
    {  2305, "Gateway Technologies Inc." },
    {  2306, "Zergo Limited" },
    {  2307, "C4U Solutions" },
    {  2308, "BOLL Engineering AG" },
    {  2309, "Internet Mail Consortium" },
    {  2310, "College of Mathematics and Science - Univ. of Central Oklahoma" },
    {  2311, "Institute for Applied Supercomputing - CSUSB" },
    {  2312, "Red Hat Software" },
    {  2313, "Legal & General Assurance Society Ltd." },
    {  2314, "Fire Networks Inc." },
    {  2315, "icti" },
    {  2316, "Internet Communication Security" },
    {  2317, "TALX Corporation" },
    {  2318, "Repeater Technologies Inc." },
    {  2319, "Aumtech Inc." },
    {  2320, "EuroSInet" },
    {  2321, "ke Kommunikations-Elektronik" },
    {  2322, "Starvision Multimedia Corp." },
    {  2323, "Alcatel Telecom ASD" },
    {  2324, "AVAL DATA Coporation" },
    {  2325, "Pacific Northwest National Laboratory" },
    {  2326, "Tortoise Software Systems" },
    {  2327, "Verio, Inc." },
    {  2328, "ArrayComm, Inc." },
    {  2329, "DST Systems Inc." },
    {  2330, "Vision Service Plan" },
    {  2331, "Best Buy" },
    {  2332, "Shared Network Services (SNS)" },
    {  2333, "BBC" },
    {  2334, "Packeteer Inc." },
    {  2335, "Applied Digital Access" },
    {  2336, "HIS Technologies" },
    {  2337, "DNE Technologies, Inc." },
    {  2338, "Vertical Networks, Inc." },
    {  2339, "CSoft Ltd." },
    {  2340, "National Grocers" },
    {  2341, "Reliance Computer Corp." },
    {  2342, "AK-NORD EDV Vertriebsges mbH" },
    {  2343, "Financial Technologies International" },
    {  2344, "SpaceWorks, Inc." },
    {  2345, "Torrent Networking Technologies Corp." },
    {  2346, "CTI" },
    {  2347, "Datastream International Abbas Foroughi" },
    {  2348, "Killion Inc." },
    {  2349, "Mission Critical Software, Inc." },
    {  2350, "Data Research and Applications, Inc." },
    {  2351, "Resonate Inc." },
    {  2352, "Ericsson, Inc. (formerly 'RedBack Networks')" },
    {  2353, "Nexware Corporation" },
    {  2354, "ADC Wireless Systems" },
    {  2355, "ITIS" },
    {  2356, "LANCOM Systems" },
    {  2357, "PSIMED Corporation" },
    {  2358, "Transfer Data Test GmbH" },
    {  2359, "T.I.P. Group S.A." },
    {  2360, "Redlink" },
    {  2361, "Japan Information Engineering Co, Ltd." },
    {  2362, "Richter Systems Development, Inc." },
    {  2363, "Eurocontrol MAS UAC" },
    {  2364, "Konica Corporation" },
    {  2365, "Viacom" },
    {  2366, "XIOtech Corporation" },
    {  2367, "IMS Gesellschaft fuer Informations- und Managementsysteme mbH" },
    {  2368, "Softworks" },
    {  2369, "MobileWare Corporation" },
    {  2370, "Memco Software Ltd." },
    {  2371, "Advanced TechCom, Inc." },
    {  2372, "Bedford Associates, Inc." },
    {  2373, "CyberWizard, Inc." },
    {  2374, "SMART Technologies, Inc." },
    {  2375, "Concentric Network Corporation" },
    {  2376, "The SNMP WorkShop" },
    {  2377, "Reltec Corp" },
    {  2378, "Nera" },
    {  2379, "Nations Bank" },
    {  2380, "Integrated Design Techniques Limited" },
    {  2381, "OpenLink Software, Inc." },
    {  2382, "NetReality, Inc." },
    {  2383, "Imation Corp." },
    {  2384, "SIBIS Ltd." },
    {  2385, "SHARP Corporation" },
    {  2386, "Desktop Data, Inc." },
    {  2387, "Telecom Device K.K." },
    {  2388, "Captech Communication Inc." },
    {  2389, "Performance Telecom Corp." },
    {  2390, "Com'X" },
    {  2391, "Karim" },
    {  2392, "Systems Integration Group" },
    {  2393, "Witcom Innovative Radio Systems" },
    {  2394, "S.F. Software" },
    {  2395, "MARBEN Italia S.p.A." },
    {  2396, "ActivCard, Inc." },
    {  2397, "Cognos, Inc." },
    {  2398, "Eagle Traffic Control Systems W.L.(Bud)" },
    {  2399, "Netwave" },
    {  2400, "Hemet.net" },
    {  2401, "NBX Corporation" },
    {  2402, "Al-Bader Shipping & Gen. Cont. Co. Domnic Faia" },
    {  2403, "@Home Network" },
    {  2404, "Primeur" },
    {  2405, "ILTS Inc." },
    {  2406, "Computer Generation, Inc." },
    {  2407, "Mouton Noir Enterprises Inc." },
    {  2408, "Baystate Sound & Recording" },
    {  2409, "Metapath Corporation" },
    {  2410, "Tajeet Gourmet Food Manufacturing" },
    {  2411, "Telcel" },
    {  2412, "Intertrader Ltd" },
    {  2413, "Maxtronics" },
    {  2414, "Spiderplant" },
    {  2415, "Software.com, Inc." },
    {  2416, "Adherent Systems Ltd" },
    {  2417, "Korfmacher" },
    {  2418, "Svenska EDIT AB" },
    {  2419, "MLM5000" },
    {  2420, "INIT" },
    {  2421, "Teltone Corporation" },
    {  2422, "Faircross Computers" },
    {  2423, "Carycom (H.K.) LTD" },
    {  2424, "Dominio Publico Internet, S.L." },
    {  2425, "bkr - Network Systems" },
    {  2426, "Mariposa Technology, Inc." },
    {  2427, "Brocade Communications Systems, Inc. (formerly 'NuView Inc.')" },
    {  2428, "Uninett" },
    {  2429, "A.C.E." },
    {  2430, "Oy Comptel Ab" },
    {  2431, "mms Communication GmbH" },
    {  2432, "Sortova Consulting Group, Inc." },
    {  2433, "ENVOY Corporation" },
    {  2434, "Metron Technology Limited" },
    {  2435, "Brother Industries, Ltd." },
    {  2436, "NetCom Systems, Inc." },
    {  2437, "Kapsch AG." },
    {  2438, "Shomiti Systems" },
    {  2439, "Computerm Corporation" },
    {  2440, "Efficient IP" },
    {  2441, "CertiSoft Tecnologia Ltda." },
    {  2442, "EDI Enterprises, Inc." },
    {  2443, "CCII Systems (Pty) Ltd" },
    {  2444, "Connetix, Inc." },
    {  2445, "TUNIX Open System Consultants" },
    {  2446, "GNP Computers" },
    {  2447, "Intercope International" },
    {  2448, "NXT" },
    {  2449, "Pan Dacom Forcom Telekommunikationssysteme GmbH" },
    {  2450, "Auco, Inc." },
    {  2451, "Tecnotree (formerly 'Tecnomen')" },
    {  2452, "Helax AB" },
    {  2453, "Omtool Ltd." },
    {  2454, "G-connect" },
    {  2455, "Dynamic Mutual Funds" },
    {  2456, "Antec Network Technologies" },
    {  2457, "Premiere Promotions" },
    {  2458, "LANQuest" },
    {  2459, "Guardian Bank p. Zagreb" },
    {  2460, "ihlas net" },
    {  2461, "WAVTrace" },
    {  2462, "VIGGEN Corporation" },
    {  2463, "SAIF ALI CO., Ltd." },
    {  2464, "CARYNET Information Center" },
    {  2465, "Application Telematiques, Numeriques et Reseaux (ATNR)" },
    {  2466, "Channelmatic-LIMT, Inc." },
    {  2467, "ArrowPoint Communications Inc." },
    {  2468, "Ingrasys" },
    {  2469, "Netbuilding" },
    {  2470, "Personal & Confidential Klaus" },
    {  2471, "Comsys International B.V." },
    {  2472, "Advance Telecommunication Krisada Arjinpattara" },
    {  2473, "GateKey Solutions, Inc." },
    {  2474, "Avici Systems, Inc." },
    {  2475, "Sierra Technology, Inc.John Fischerjfischer&stisierra.com" },
    {  2476, "Encanto Networks Inc." },
    {  2477, "Mount Olive College" },
    {  2478, "FUJITSU ACCESS LIMITED" },
    {  2479, "EDS GmbH" },
    {  2480, "Jyra Research Inc." },
    {  2481, "Summit Communications" },
    {  2482, "Ministry of Transport, Public Works and Water Management" },
    {  2483, "WinNet MCS Inc." },
    {  2484, "ICG Communications" },
    {  2485, "CrossLink Internet Services" },
    {  2486, "Cygnus Computer Associates, Ltd." },
    {  2487, "Phoenix Technologies Ltd." },
    {  2488, "Internetclub" },
    {  2489, "CV. MITRA ADI PRANATA Ir. Fx Wahyu Hartono" },
    {  2490, "Vixel Corporation" },
    {  2491, "Atmosphere Networks Inc." },
    {  2492, "Montana Tel-Net" },
    {  2493, "JCP Computer Services Ltd." },
    {  2494, "Inter Clear Service Ltd." },
    {  2495, "Internet Systems Consortium, Inc." },
    {  2496, "LightSpeed International, Inc." },
    {  2497, "GammaGraphX, Inc." },
    {  2498, "iManage Inc." },
    {  2499, "Internet Security Systems" },
    {  2500, "Vienna Systems Corporation" },
    {  2501, "Yago Systems, Inc." },
    {  2502, "LunarWave Communications" },
    {  2503, "Bangkok Pattaya Hospital" },
    {  2504, "Roke Manor Research Limited Keith" },
    {  2505, "New Oak Communications, Inc." },
    {  2506, "Bug Free Development" },
    {  2507, "ARC Technologies Group, Inc." },
    {  2508, "Internet Dynamics, Inc." },
    {  2509, "Aviat Networks" },
    {  2510, "Bear Mountain Software" },
    {  2511, "AccessLAN Communications,Inc." },
    {  2512, "Crossroads Systems, Inc." },
    {  2513, "CR2A-DI" },
    {  2514, "Mantra Communications Inc." },
    {  2515, "DiscoverNet" },
    {  2516, "VocalTec Communications Ltd." },
    {  2517, "Riversoft Limited" },
    {  2518, "Phaos Technology Corp." },
    {  2519, "POWEREDCOM, Inc." },
    {  2520, "Internet Systems Inc." },
    {  2521, "ComConsult" },
    {  2522, "Osicom Technologies" },
    {  2523, "Hitron Technology Inc." },
    {  2524, "Rabenstein Enterprises" },
    {  2525, "AT Sistemas, C.A." },
    {  2526, "iPass Inc." },
    {  2527, "InterLinear Technology Inc" },
    {  2528, "World One Telecom Ltd" },
    {  2529, "Quadritek Systems, Inc." },
    {  2530, "Syseca" },
    {  2531, "NetSpeak Corporation" },
    {  2532, "OpNet Inc." },
    {  2533, "MRM Consulting" },
    {  2534, "TNSys-Trading Net System" },
    {  2535, "JCMT" },
    {  2536, "Endeavour Hills Computer Services" },
    {  2537, "Diversified Technology, Inc." },
    {  2538, "Lateral Management Limited" },
    {  2539, "Proxy Software Systems Ltd." },
    {  2540, "Combox Ltd." },
    {  2541, "Spectrix Corporation" },
    {  2542, "Electronics and Telecommunications Research Institute" },
    {  2543, "Arlotto Comnet, Inc." },
    {  2544, "ADVA AG Optical Networking" },
    {  2545, "NewTec GmbH Systementwicklung und Beratung Harald" },
    {  2546, "PVT a.s. - pvt.net" },
    {  2547, "Catholic University of Pelotas" },
    {  2548, "Cryptonym Corporation" },
    {  2549, "Aker Consultoria e Informatica Rodrigo Ormonde" },
    {  2550, "ELVIS-PLUS" },
    {  2551, "Telegyr Systems" },
    {  2552, "Netegrity, Inc." },
    {  2553, "Cardinal Network, New Zealand Ltd" },
    {  2554, "Micro Integrated Innnovations Paul" },
    {  2555, "JayaTek Sdn. Bhd." },
    {  2556, "Central Electronic Industry" },
    {  2557, "Transcend Access Systems, Inc." },
    {  2558, "Outreach Communications Corp." },
    {  2559, "BocaTel" },
    {  2560, "AT&T GNMC Amsterdam" },
    {  2561, "Teamphone.com Ltd," },
    {  2562, "SBB Software Beratung GmbH" },
    {  2563, "Comstat DataComm Corporation" },
    {  2564, "The Network Technology Group" },
    {  2565, "Avery Dennison" },
    {  2566, "ROHDE & SCHWARZ GmbH & Co.KG" },
    {  2567, "Datamedia SA" },
    {  2568, "Integrix, Inc." },
    {  2569, "Telenor Novit AS" },
    {  2570, "Prefered Communications" },
    {  2571, "Mu'Tah University" },
    {  2572, "Network TeleSystems, Inc." },
    {  2573, "Decision-Science Applications,Inc. Simeon Fitch" },
    {  2574, "Concentricity, LLC" },
    {  2575, "Artiza Networks Inc." },
    {  2576, "ComputerShare Systems Limited" },
    {  2577, "EDR Technologies" },
    {  2578, "AbirNet" },
    {  2579, "Trikota, Inc." },
    {  2580, "Diebold Company of Canada Limited Rajan Raman" },
    {  2581, "Precise Connectivity Solutions" },
    {  2582, "ANS Communications" },
    {  2583, "Hydro-Quebec TransEnergie" },
    {  2584, "RadioLAN, Inc." },
    {  2585, "Youth Opportunities Upheld, Inc." },
    {  2586, "Teracom AB" },
    {  2587, "Freemont Avenue Software, Inc." },
    {  2588, "Positron Fiber Systems" },
    {  2589, "Chuo Electronics, Co., Ltd." },
    {  2590, "Minolta Co., Ltd." },
    {  2591, "Radyne Corporation" },
    {  2592, "NSI Software" },
    {  2593, "Exstream PC" },
    {  2594, "Simulation Laboritories Inc." },
    {  2595, "WebTV Networks, Inc." },
    {  2596, "Credit Management Solutions, Inc." },
    {  2597, "Chisholm Technologies Inc." },
    {  2598, "WonderNet International Corp" },
    {  2599, "Percpetics Corporation" },
    {  2600, "Distributed Systems Logic, Inc." },
    {  2601, "US West !nterprise Networking Services" },
    {  2602, "Intrasoft Corporation" },
    {  2603, "Allot Communications" },
    {  2604, "Sophos Plc" },
    {  2605, "TaylorMade-Math" },
    {  2606, "Rittal-Werk Rudolf Loh GmbH & Co.KG" },
    {  2607, "LAN International, Inc." },
    {  2608, "Precise Software Solutions" },
    {  2609, "New Prime Inc." },
    {  2610, "DataHaven Project, Inc." },
    {  2611, "Interspeed" },
    {  2612, "MPI Tech a/s (formerly 'i-data international a-s')" },
    {  2613, "Accelerated Networks, Inc." },
    {  2614, "Forschungszentrum Karlsruhe GmbH" },
    {  2615, "ixMicro" },
    {  2616, "CAO Diffusion" },
    {  2617, "Computer Communications Consulting, Inc." },
    {  2618, "Tracewell Systems, Inc." },
    {  2619, "Advanced Internet Management, Inc." },
    {  2620, "Check Point Software Technologies Ltd" },
    {  2621, "Martin Zwernemann" },
    {  2622, "Amarex Technology, Inc." },
    {  2623, "ASUSTek Computer Inc." },
    {  2624, "Wave Wireless Networking" },
    {  2625, "FCI Telecommunications Corporation" },
    {  2626, "Entuity Limited (formerly 'Prosum Ltd')" },
    {  2627, "TCAM Systems (UK) Ltd" },
    {  2628, "Natural MicroSystems" },
    {  2629, "City of Wauwatosa" },
    {  2630, "The Esys Corporation" },
    {  2631, "Altvater Airdata Systems GmbH Peter Haaf" },
    {  2632, "PT Wiryamas Sinar Palapa" },
    {  2633, "Compucentre" },
    {  2634, "Western Telematic, Inc." },
    {  2635, "ADTX" },
    {  2636, "Juniper Networks, Inc." },
    {  2637, "Aptis Communications, Inc." },
    {  2638, "Bstpromark" },
    {  2639, "EdgePoint Networks, Inc." },
    {  2640, "AIMetrix Incorporated" },
    {  2641, "Arctunn Consulting" },
    {  2642, "Computel Electronica S.A.Jose" },
    {  2643, "FlowWise Networks Inc." },
    {  2644, "Synaptyx Corporation" },
    {  2645, "First Union National Bank" },
    {  2646, "Kommunikator GmbH" },
    {  2647, "C2S (Communication Systeme Service)" },
    {  2648, "Siligom" },
    {  2649, "Radcom Ltd." },
    {  2650, "Go Ahead Software, Inc." },
    {  2651, "Space Connection NV" },
    {  2652, "Merck-Medco Managed Care LLC" },
    {  2653, "City Com BV" },
    {  2654, "R&S BICK Mobilfunk GmbH Andreas" },
    {  2655, "Kepler Software, Ltd." },
    {  2656, "Banque Paribas" },
    {  2657, "Zitech Net" },
    {  2658, "Century Analysis Inc." },
    {  2659, "Talent Development GmbH Hans-Georg" },
    {  2660, "CopperCom Inc." },
    {  2661, "Yutaka Electric Mfg. Co. Ltd." },
    {  2662, "SBF-Bourse De Paris" },
    {  2663, "Economatica" },
    {  2664, "GVN Technologies" },
    {  2665, "Olsy UK" },
    {  2666, "Room 42 Software, LLC" },
    {  2667, "Cirilium" },
    {  2668, "Tavve Software Co." },
    {  2669, "Solari di Udine" },
    {  2670, "NetVenture, Inc." },
    {  2671, "Connected Systems Group" },
    {  2672, "Corporate Software & Technologies, INT, Inc." },
    {  2673, "Fibex Systems" },
    {  2674, "Claude Jardine Design" },
    {  2675, "Net Marketing, Inc." },
    {  2676, "IBP, Inc." },
    {  2677, "RD6 Inc." },
    {  2678, "MassMedia Communications Inc." },
    {  2679, "Nexans Suisse SA." },
    {  2680, "Peak Audio, Inc." },
    {  2681, "Sia Yiu" },
    {  2682, "DPS Inc." },
    {  2683, "Callisto Software" },
    {  2684, "ViaVideo Communications, Inc." },
    {  2685, "Sequel Technology Corporation" },
    {  2686, "Wi-LAN Inc." },
    {  2687, "Network System Technologies, Inc." },
    {  2688, "Center Technology" },
    {  2689, "Coby Roberts" },
    {  2690, "Netronix Inc." },
    {  2691, "Network Computer, Incorporated" },
    {  2692, "WebWeaving" },
    {  2693, "Institut Jozef Stefan" },
    {  2694, "Eldat Communication Ltd." },
    {  2695, "MetaCommunications. Inc." },
    {  2696, "Digital Video Broadcasting (DVB)" },
    {  2697, "Bayly Communications Inc." },
    {  2698, "Poznan Supercomputing and Networking Center - POZMAN" },
    {  2699, "Printer Working Group" },
    {  2700, "DIRECTV" },
    {  2701, "Argon Networks Inc." },
    {  2702, "WACOS Inc." },
    {  2703, "Object Zone AB" },
    {  2704, "ICCC A/S" },
    {  2705, "SECUDE IT Security GmbH" },
    {  2706, "Institute for Applied Information Processing and Communications,Graz University of Technology" },
    {  2707, "International Network Services" },
    {  2708, "JNR Systems" },
    {  2709, "Congreve Computing Ltd." },
    {  2710, "Northrop Grumman - Surveillance and Battle Management Systems" },
    {  2711, "Littlewoods Stores, Ltd." },
    {  2712, "ICE-TEL TLCA" },
    {  2713, "Mauswerks, Inc." },
    {  2714, "Dep. of Signal Theory and Communications - UPC" },
    {  2715, "Zapex Technologiesn Inc." },
    {  2716, "Glueck & Kanja Technology AG" },
    {  2717, "Alcatel Telspace" },
    {  2718, "Intercall" },
    {  2719, "Townsend Analytics Ltd." },
    {  2720, "NorCom Informationstechnologie und Unternehmensberatung GmbH" },
    {  2721, "News Internet Services" },
    {  2722, "Georgia Tech Research Institute" },
    {  2723, "Guerrilla Mail, Inc." },
    {  2724, "EasyStreet Online Services, Inc." },
    {  2725, "Art Technology Group, Inc." },
    {  2726, "Capital One Financial Corp." },
    {  2727, "SFA, Inc." },
    {  2728, "Packard Bell NEC, Inc." },
    {  2729, "Empire Net" },
    {  2730, "Ottosen" },
    {  2731, "Dialogdesign" },
    {  2732, "Innovative Data Technology" },
    {  2733, "Group 2000 Nederland b.v." },
    {  2734, "Digital Lightwave, Inc." },
    {  2735, "MIBS-R-US" },
    {  2736, "EtherWAN Systems, Inc." },
    {  2737, "Cordless Technology A/S" },
    {  2738, "Punjab Communications Ltd.(PunCom)" },
    {  2739, "Tanstaafl! Consulting" },
    {  2740, "Artevea" },
    {  2741, "Calirnet Systems, Inc." },
    {  2742, "Manage.com" },
    {  2743, "RFL Electronics, Inc." },
    {  2744, "Sarnoff Real Time Corporation" },
    {  2745, "LANCAST, Inc." },
    {  2746, "Martin Communications" },
    {  2747, "Dirig Software, Inc." },
    {  2748, "ICL Retail Systems Europe" },
    {  2749, "Aptia, Inc." },
    {  2750, "WaveCom Electronics Inc." },
    {  2751, "Globalcast Communications Inc." },
    {  2752, "McComm International bv" },
    {  2753, "ARGO Data Resource Corporation Thomas" },
    {  2754, "Excel Switching Corporation" },
    {  2755, "Palomar Communications, Inc." },
    {  2756, "NetStart, Inc." },
    {  2757, "SmartCommerce Solutions" },
    {  2758, "Universal Micro Applications, Inc." },
    {  2759, "SNS Consultants" },
    {  2760, "Enhanced Messaging System, Inc." },
    {  2761, "Informatica S.p.A." },
    {  2762, "Netgame Ltd." },
    {  2763, "IntelliNet Technologies, Inc." },
    {  2764, "Acxiom Corporation" },
    {  2765, "Dafur GmbH" },
    {  2766, "Platform Computing Corporation" },
    {  2767, "Automotive Products plc" },
    {  2768, "RandD Computer Services Razvan" },
    {  2769, "Knuerr AG" },
    {  2770, "Eurotel Praha s.r.o." },
    {  2771, "Inlab Software GmbH" },
    {  2772, "Intersolve Technologies" },
    {  2773, "Redstone Communications, Inc." },
    {  2774, "Algorithmic Research Ltd." },
    {  2775, "AGT International, Inc." },
    {  2776, "Fourthtrack Systems" },
    {  2777, "Flextel S.p.a." },
    {  2778, "WarpSpeed Computers" },
    {  2779, "21C3" },
    {  2780, "Neo Networks Inc." },
    {  2781, "Technical University of Madrid (UPM)" },
    {  2782, "BOM Computer Services Ltd." },
    {  2783, "Control Systems International" },
    {  2784, "bbcom Broadband Communications GmbH & Co. KG" },
    {  2785, "Tecnopro SA" },
    {  2786, "Politecnico di Torino" },
    {  2787, "ING Group" },
    {  2788, "Wytec Incorporated Dave" },
    {  2789, "Mauro Enterprise" },
    {  2790, "RoadRunner" },
    {  2791, "Deterministic Networks, Inc." },
    {  2792, "Sprint PCS" },
    {  2793, "Interactive Intelligence" },
    {  2794, "JAYCOR" },
    {  2795, "Edify Corporation" },
    {  2796, "Fox IT Ltd" },
    {  2797, "University of Pennsylvania" },
    {  2798, "Metawave Communications Corp." },
    {  2799, "Enterprise Solutions Ltd" },
    {  2800, "CBL GmbH" },
    {  2801, "ADP Dealer Services" },
    {  2802, "EFKON" },
    {  2803, "SICAN GmbH" },
    {  2804, "KeyTrend Inc." },
    {  2805, "ACC TelEnterprises" },
    {  2806, "EBA" },
    {  2807, "Teleware Co., Ltd." },
    {  2808, "eFusion, Inc." },
    {  2809, "Participants Trust Company" },
    {  2810, "PeopleSoft, Inc." },
    {  2811, "Entrata Communication" },
    {  2812, "Musics.com" },
    {  2813, "First Telecom plc." },
    {  2814, "Telesnap GmbH" },
    {  2815, "Newpoint Technologies, Inc." },
    {  2816, "T&E" },
    {  2817, "Disney Regional Entertainment, Inc." },
    {  2818, "Ramp Networks, Inc." },
    {  2819, "Open Software Associates" },
    {  2820, "Procom Technology" },
    {  2821, "University of Notre Dame (Office of Information Technology)" },
    {  2822, "Arquitectura Animada" },
    {  2823, "Sumbha Holograms & Packaging Systems Ltd." },
    {  2824, "The A Consulting Team, Inc." },
    {  2825, "WorldGate Communications, Inc." },
    {  2826, "TOA Electronics Ltd." },
    {  2827, "Sytex Systems Corp." },
    {  2828, "Zell Distributors" },
    {  2829, "YRless Internet Corporation" },
    {  2830, "HALO Technologies" },
    {  2831, "Beijing Univ. of Posts & Telecom., Training Center" },
    {  2832, "Virtual Data Systems, Inc." },
    {  2833, "NetDox, Inc." },
    {  2834, "Expert Computer Service Jim Mac" },
    {  2835, "Dictaphone" },
    {  2836, "Unex Technology Corporation" },
    {  2837, "Global Mobility Systems, Inc." },
    {  2838, "TFM Associates" },
    {  2839, "Teleran Technologies, L.P. Carmen Randazzo" },
    {  2840, "Digital Telecommunications, Inc." },
    {  2841, "KB Internet Ltd." },
    {  2842, "Agri Datalog" },
    {  2843, "Braid Systems Limited" },
    {  2844, "Newsnet ITN" },
    {  2845, "JTCS" },
    {  2846, "KEYCORP Pty. Ltd." },
    {  2847, "GTE Internetworking" },
    {  2848, "Royalblue Technologies plc Trevor Goff" },
    {  2849, "U&R Consultores Argentina" },
    {  2850, "Tevycom Fapeco S.A." },
    {  2851, "Polaris Communications" },
    {  2852, "Competitive Automation, Inc." },
    {  2853, "IDEXX Laboratories, Inc." },
    {  2854, "Network Computing Technologies, Inc." },
    {  2855, "Axxcelera Broadband Wireless" },
    {  2856, "Cableware Electronics" },
    {  2857, "Network Power and Light" },
    {  2858, "Clarent Corporation" },
    {  2859, "Kingston - SCL" },
    {  2860, "netVest" },
    {  2861, "VSN systemen BV" },
    {  2862, "Northwest Consulting Services Randy" },
    {  2863, "Thomson Inc." },
    {  2864, "Digitel S/A Industria Eletronica" },
    {  2865, "Nortel Networks - Optical Metro" },
    {  2866, "Technical Insights" },
    {  2867, "NKF Electronics" },
    {  2868, "Glasshouse Business Networks B.V." },
    {  2869, "VSI Enterprises" },
    {  2870, "E-TECH, Inc." },
    {  2871, "UltraDNS" },
    {  2872, "Unisource Business Networks Nederland bv" },
    {  2873, "AGENTics" },
    {  2874, "OTC Telecom Inc." },
    {  2875, "G.U.I.Dev. International Inc." },
    {  2876, "Cothern Computer Systems" },
    {  2877, "Arbinet Communications Inc." },
    {  2878, "FaxForward Canada, Ltd." },
    {  2879, "Sonus Networks, Inc." },
    {  2880, "IPHighway Ltd." },
    {  2881, "Clarion" },
    {  2882, "Comtrol Corporation" },
    {  2883, "Coherent Communications Systems Inc" },
    {  2884, "ADS Networks" },
    {  2885, "Chicago-Soft Ltd." },
    {  2886, "Netbalance" },
    {  2887, "AS Proekspert" },
    {  2888, "Adfm Multimedia Internet" },
    {  2889, "Praxis International Inc." },
    {  2890, "Solectek Corporation" },
    {  2891, "NanoSpace, Inc." },
    {  2892, "KAPS, Inc." },
    {  2893, "Computer Associates, Italy" },
    {  2894, "Mainsail Networks, Inc." },
    {  2895, "EDS, SSMC-Tools Support and Development" },
    {  2896, "Breece Hill Technologies Inc." },
    {  2897, "AT&T Capital Corp Ernest" },
    {  2898, "HighGround Systems, Inc Thomas Bakerman" },
    {  2899, "Omnia Communications, Inc." },
    {  2900, "Mer Telemanagement Solutions" },
    {  2901, "Replicase, Inc." },
    {  2902, "Microlog Corporation" },
    {  2903, "Smartways Technology Limited" },
    {  2904, "Computer Services" },
    {  2905, "Trumpet Software International Pty Ltd" },
    {  2906, "Rsi Solutions Ltd." },
    {  2907, "C-Cor Electronics" },
    {  2908, "Castle Networks, Inc." },
    {  2909, "Nexabit Networks, LLC" },
    {  2910, "General Electric Company" },
    {  2911, "Objective Software Services, Inc." },
    {  2912, "Ameristar Technologies Corp." },
    {  2913, "Hycor Biomedical, Inc." },
    {  2914, "Fellesdata AS" },
    {  2915, "Network Engines, Inc." },
    {  2916, "Daimler-Benz AG" },
    {  2917, "Data Interface Systems Corp" },
    {  2918, "Symmetry Communications Systems, Inc." },
    {  2919, "Rambus Corp." },
    {  2920, "Will-Do Information Services" },
    {  2921, "Swiss Pharma Contract Ltd." },
    {  2922, "I-O Corporation" },
    {  2923, "Formula Consultants Inc." },
    {  2924, "Star TV (Satellite Television Asia Region Ltd)" },
    {  2925, "Cyclades Corporation" },
    {  2926, "Sonoma Systems, Inc." },
    {  2927, "Jacksonville Electric Authority" },
    {  2928, "Net Insight AB" },
    {  2929, "Quallaby" },
    {  2930, "ValiCert, Inc." },
    {  2931, "GADC Networks" },
    {  2932, "TERMA Elektronik AS" },
    {  2933, "Floware System Solutions Ltd." },
    {  2934, "Citicorp" },
    {  2935, "Quantum Corp. (formerly 'Pathlight Technology Inc.')" },
    {  2936, "Prominence Dot Com, Inc." },
    {  2937, "Deutsche Telekom AG" },
    {  2938, "Proginet Corporation" },
    {  2939, "InfoExpress, Inc." },
    {  2940, "Argent Software" },
    {  2941, "ReadyCom Inc." },
    {  2942, "COCOM A/S" },
    {  2943, "ObjTech Software" },
    {  2944, "Top Layer Networks, Inc." },
    {  2945, "TdSoft Communications Software Ltd." },
    {  2946, "SWITCH" },
    {  2947, "Best Power - A Division of General Signal Power Systems" },
    {  2948, "TeleSuite Corporation" },
    {  2949, "Global Quest Consaltance" },
    {  2950, "Ampersand, Inc." },
    {  2951, "Nentec" },
    {  2952, "T&E Soft" },
    {  2953, "Imedia" },
    {  2954, "Universitaet Bielefeld, Technische Fakultaet" },
    {  2955, "PSINet UK Ltd." },
    {  2956, "InfoLibria, Inc." },
    {  2957, "Ericsson Communications Ltd." },
    {  2958, "Secure Network Solutions Ltd.Brendan Simon" },
    {  2959, "Workstation Solutions, Inc." },
    {  2960, "National Landscape Assn. Inc." },
    {  2961, "DIALOGS Software GmbH" },
    {  2962, "Netwise AB" },
    {  2963, "Security Dynamics Technology, Inc." },
    {  2964, "Zeta Communications Ltd." },
    {  2965, "Fujikura Solutions Ltd. (formerly 'Syscom Ltd.')" },
    {  2966, "Digital ChoreoGraphics" },
    {  2967, "CableData Inc." },
    {  2968, "Allen Telecom Systems" },
    {  2969, "Charles Craft" },
    {  2970, "Sunstone Enterprises" },
    {  2971, "Corecess Inc." },
    {  2972, "Network Alchemy, Inc." },
    {  2973, "Integral Access, Inc." },
    {  2974, "IP Metrics Software, Inc." },
    {  2975, "Notarius T.S.I.N. Inc." },
    {  2976, "Sphairon Technologies GmbH (formerly 'Philips Multimedia Network Systems GmbH')" },
    {  2977, "Teubner and Associates, Inc." },
    {  2978, "ImageCom Ltd." },
    {  2979, "Waverider Communications Inc." },
    {  2980, "ENT - Empresa Nacional de Telecomunicacoes, S.A." },
    {  2981, "Duke Energy" },
    {  2982, "Deutsches Patentamt" },
    {  2983, "SEMA Group GmbH, TS-V" },
    {  2984, "Keycode Style Ltd." },
    {  2985, "Bay Systems Consulting, Inc." },
    {  2986, "Qiangjin Corp.Ltd." },
    {  2987, "IPivot" },
    {  2988, "Consultronics Development Ltd." },
    {  2989, "University of North London" },
    {  2990, "Illuminata, Inc." },
    {  2991, "Enterprise IT, Inc." },
    {  2992, "CyberTel, Inc.Jonathan Chu" },
    {  2993, "ConvergeNet Technologies, Inc." },
    {  2994, "Teligent" },
    {  2995, "AcuComm, Inc." },
    {  2996, "SpectraWorks Inc." },
    {  2997, "RedTitan" },
    {  2998, "Anderson Consulting" },
    {  2999, "American Family Insurance" },
    {  3000, "IDB Systems, a Division of WorldCom Inc." },
    {  3001, "BAILO" },
    {  3002, "ADAXIS Group" },
    {  3003, "Packet Engines Inc." },
    {  3004, "Softwire Corporation" },
    {  3005, "TDS (Telecoms Data Systems)" },
    {  3006, "HCI Technologies" },
    {  3007, "TOPCALL International" },
    {  3008, "LogMatrix Inc (formerly 'Open Service')" },
    {  3009, "SYNCLAYER Inc." },
    {  3010, "university of aizu" },
    {  3011, "VideoServer, Inc." },
    {  3012, "Space & Telecommunications Systems Pte. Ltd." },
    {  3013, "Bicol Infonet System,Inc." },
    {  3014, "MediaSoft Telecom" },
    {  3015, "Netpro Computing, Inc." },
    {  3016, "OzEmail Pty Ltd" },
    {  3017, "Arcxel Technologies, Inc." },
    {  3018, "EnterNet Corporation" },
    {  3019, "Jones Waldo Holbrook McDonough" },
    {  3020, "University Access" },
    {  3021, "Sendit AB" },
    {  3022, "Telecom Sciences Corporation Limited" },
    {  3023, "Quality Quorm, Inc." },
    {  3024, "Grapevine Systems Inc" },
    {  3025, "The Panda Project, Inc." },
    {  3026, "Mission Control Development" },
    {  3027, "IONA Technologies Ltd" },
    {  3028, "Dialogic Corporation" },
    {  3029, "Digital Data Security" },
    {  3030, "ISCNI" },
    {  3031, "dao Consulting, LLC" },
    {  3032, "Beaufort Memorial Hospital" },
    {  3033, "Informationstechnik Dr. Hansmeyer" },
    {  3034, "URMET SUD s.p.a." },
    {  3035, "Avesta Technologies Inc" },
    {  3036, "Hyundai Electronics America" },
    {  3037, "DMV Ltd" },
    {  3038, "Fax International, Inc." },
    {  3039, "MidAmerican Energy Company (MEC)" },
    {  3040, "Bellsouth.net" },
    {  3041, "Assured Access Technology, Inc." },
    {  3042, "Logicon - Eagle Technology" },
    {  3043, "Frequentis GmbH" },
    {  3044, "ISIS 2000" },
    {  3045, "james e. gray, atty" },
    {  3046, "Jamaica Cable T.V. & Internet Services" },
    {  3047, "Information Technology Consultants Pty. Ltd." },
    {  3048, "LinickGrp.com" },
    {  3049, "Yankee Know-How" },
    {  3050, "SeAH group" },
    {  3051, "Cinco Networks, Inc." },
    {  3052, "Asentria Corporation" },
    {  3053, "Genie Telecommunication Inc." },
    {  3054, "Ixia Communications" },
    {  3055, "Transmeta Corporation" },
    {  3056, "Systemsoft Corp." },
    {  3057, "Jaspal Miracles Ltd." },
    {  3058, "T-Systems" },
    {  3059, "Sisler Promotions, Inc." },
    {  3060, "ice-man refrigeration" },
    {  3061, "Listing Service Solutions, Inc." },
    {  3062, "Jovian Networks" },
    {  3063, "Elebra Com. Dados" },
    {  3064, "Safetran Systems" },
    {  3065, "Video Network Communications, Inc." },
    {  3066, "Phasecom Ltd." },
    {  3067, "Eurocontrol" },
    {  3068, "SilverStream Software Inc." },
    {  3069, "Cownet" },
    {  3070, "World Access, Inc." },
    {  3071, "Virtual Line L.L.P." },
    {  3072, "Integrated Concepts L.L.P." },
    {  3073, "Exabyte Corporation" },
    {  3074, "Interactive Media Corporation" },
    {  3075, "NetCore Systems, Inc." },
    {  3076, "Altiga Networks, Inc." },
    {  3077, "National Center for Supercomputing Applications" },
    {  3078, "EMASS Inc." },
    {  3079, "PRIMA Telematic" },
    {  3080, "BackWeb Technologies" },
    {  3081, "NTP Software" },
    {  3082, "PBS A/S" },
    {  3083, "W.Quinn Associates, Inc." },
    {  3084, "QUZA (Racal-Integralis)" },
    {  3085, "Cosine Communications" },
    {  3086, "PipeLinks Inc." },
    {  3087, "WaiLAN Communications, Inc." },
    {  3088, "Axent Technologies" },
    {  3089, "SPAWAR" },
    {  3090, "Airsys ATM S.A." },
    {  3091, "Whiter Morn Software, Inc." },
    {  3092, "ENTV" },
    {  3093, "CyberTAN Technology, Inc." },
    {  3094, "Frilot, Patridge, Kohnke & Clements, L.C." },
    {  3095, "FirstSense Software, Inc." },
    {  3096, "StarVox, Inc." },
    {  3097, "WatchGuard Technologies Inc." },
    {  3098, "MTI Technology Corporation" },
    {  3099, "Lumbrera" },
    {  3100, "CELOGIC" },
    {  3101, "Experian Information Solutions Inc." },
    {  3102, "Kansai Electric Co., Ltd." },
    {  3103, "Innet" },
    {  3104, "Thales Communications GmbH" },
    {  3105, "Vodafone Sweden" },
    {  3106, "LCI International, Inc." },
    {  3107, "City of Los Angeles" },
    {  3108, "G2 Networks" },
    {  3109, "TradeWeb LLC." },
    {  3110, "Rafael" },
    {  3111, "Crystal Group Inc." },
    {  3112, "C-bridge Internet Solutions" },
    {  3113, "Phase Forward" },
    {  3114, "WONOA" },
    {  3115, "Dialog" },
    {  3116, "NICE CTI Systems UK Ltd." },
    {  3117, "E*TRADE Group Inc." },
    {  3118, "Juno Online Services, Inc." },
    {  3119, "DnB ASA" },
    {  3120, "Cintel Technologies, Inc." },
    {  3121, "Tele1024 Denmark" },
    {  3122, "Interlink Network Group, Inc." },
    {  3123, "L. Richards' Enterprises, Inc." },
    {  3124, "Media Communications Eur AB" },
    {  3125, "Rocx Software Corp." },
    {  3126, "Ardax Systems, Inc." },
    {  3127, "Pluris, Inc." },
    {  3128, "OAZ Communications" },
    {  3129, "Advanced Switching Communications, Inc." },
    {  3130, "GreatLink Networks, Inc." },
    {  3131, "Aydin Telecom" },
    {  3132, "NetKit Inc." },
    {  3133, "IDP" },
    {  3134, "TTM Nederland" },
    {  3135, "Labouchere" },
    {  3136, "Comtrend Corporation" },
    {  3137, "Berbee Information Networks Corp." },
    {  3138, "Wireless Online, Inc." },
    {  3139, "LIFFE" },
    {  3140, "Celo Communications AB" },
    {  3141, "Mark IV Industries Ltd.(F-P Electronics Division)" },
    {  3142, "Leitch Technology International Incorporated" },
    {  3143, "Chalcroft International" },
    {  3144, "Clarity Wireless Inc." },
    {  3145, "C-C-C Technology Ltd" },
    {  3146, "FREQUENTIS Network Systems GmbH" },
    {  3147, "Daewoo Electronics" },
    {  3148, "France Caraibe Mobiles" },
    {  3149, "Winchester Systems Inc." },
    {  3150, "SWD" },
    {  3151, "Automotive Industry Action Group (AIAG)" },
    {  3152, "Orion Technologies Inc." },
    {  3153, "DirectoryNET, Inc." },
    {  3154, "Kisan Telecom Co., LTD" },
    {  3155, "Concord-Eracom" },
    {  3156, "Secant" },
    {  3157, "NetraCorp, LLC" },
    {  3158, "MASPRO DENKOH Corp." },
    {  3159, "Utimaco Safeware AG" },
    {  3160, "Financial Information System Center (FISC)" },
    {  3161, "Xybx Inc." },
    {  3162, "Relational Data Systems" },
    {  3163, "M&T Clear Solutions Inc." },
    {  3164, "ARBED S.A." },
    {  3165, "Cap Gemini Telecom" },
    {  3166, "Westek Technology Ltd John Tucker" },
    {  3167, "NICE Systems Ltd." },
    {  3168, "INC S.A." },
    {  3169, "Silis Sarl" },
    {  3170, "InterWorking Labs, Inc." },
    {  3171, "Ikon Systems, Inc." },
    {  3172, "GTE Intelligent Network Services" },
    {  3173, "Turnstone Systems, Inc." },
    {  3174, "Tasman Networks, Inc." },
    {  3175, "WebTrends Corporation" },
    {  3176, "Werner Training and Consulting, Inc." },
    {  3177, "IVC, Inc." },
    {  3178, "Blue Cross and Blue Shield of Florida" },
    {  3179, "Level8 Systems" },
    {  3180, "RESCOM A/S" },
    {  3181, "MICROSENS GmbH & Co. KG" },
    {  3182, "Unihold Technologies" },
    {  3183, "Wired for Management" },
    {  3184, "Raymond and Lae Engineering, Inc." },
    {  3185, "Parapsco Designs Ltd." },
    {  3186, "TouchNet Information Systems, Inc." },
    {  3187, "FUZZY! Informatik GmbH" },
    {  3188, "Sunny Comm. Inc." },
    {  3189, "DSD Computing" },
    {  3190, "Caja de Ahorros del Mediterraneo" },
    {  3191, "Dynetcom Guernsey Ltd." },
    {  3192, "Tachyon, Inc." },
    {  3193, "Silent Communications" },
    {  3194, "EFFNET AB" },
    {  3195, "AUDI AG" },
    {  3196, "Side by Side GmbH" },
    {  3197, "Vodacom South Africa" },
    {  3198, "Volamp LtdW.G. Saich+44(0) 1252 724055" },
    {  3199, "Shasta Networks" },
    {  3200, "Applied Resources, Inc." },
    {  3201, "LANCOME" },
    {  3202, "Spar Aerospace Limited" },
    {  3203, "GlaxoWellcome Inc." },
    {  3204, "A.T.I. System Co., Ltd." },
    {  3205, "EXODUS Communications Inc." },
    {  3206, "Assured Digital, Inc." },
    {  3207, "Web@venture" },
    {  3208, "Athens University of Economics and Business" },
    {  3209, "Dynarc AB" },
    {  3210, "VOLKSWAGEN AG" },
    {  3211, "Allgon AB" },
    {  3212, "Crestron Electronics, Inc." },
    {  3213, "TRANSICIEL" },
    {  3214, "SAN People (Pty) Ltd." },
    {  3215, "Network Instruments, LLC" },
    {  3216, "Texas Networking, Inc." },
    {  3217, "Pini Computer Trading" },
    {  3218, "XLN-t" },
    {  3219, "Silicomp" },
    {  3220, "Signet Systems Pty Ltd" },
    {  3221, "Ohkura Electric Co., Ltd." },
    {  3222, "New Elite Technologies, Inc." },
    {  3223, "TXCOM" },
    {  3224, "NetScreen Technologies, Inc." },
    {  3225, "Sycamore Networks" },
    {  3226, "France Connexion Ingenierie" },
    {  3227, "NetLeader, Inc." },
    {  3228, "Tekmar Sistemi s.r.l." },
    {  3229, "DSTC" },
    {  3230, "Runtop Inc." },
    {  3231, "L-3 Communications" },
    {  3232, "Eumetsat" },
    {  3233, "TongGong High New Technology Development Company" },
    {  3234, "Trifolium, Inc." },
    {  3235, "Zenon N.S.P." },
    {  3236, "ERCOM" },
    {  3237, "SDC" },
    {  3238, "Los Angeles Web" },
    {  3239, "Florence on Line s.r.l." },
    {  3240, "Escalate Networks" },
    {  3241, "TranNexus" },
    {  3242, "Brigham Young University" },
    {  3243, "ConNova Systems AB" },
    {  3244, "Voxtron Flanders NV" },
    {  3245, "Yomi Software Ltd." },
    {  3246, "Mirapoint, Inc." },
    {  3247, "Colorbus" },
    {  3248, "DPB S.A." },
    {  3249, "StarGuide Digital Networks, Inc." },
    {  3250, "Telinet Technologies, LLC. Donald" },
    {  3251, "Authentica Security Technologies, Inc." },
    {  3252, "Hologram Systems Ltd." },
    {  3253, "TranSystem, Inc." },
    {  3254, "R.R.C. Exports" },
    {  3255, "Lakeside Software, Inc." },
    {  3256, "Channel 100" },
    {  3257, "MAGMA, Inc." },
    {  3258, "LANSource Technologies Inc." },
    {  3259, "INCAA Datacom BV" },
    {  3260, "GlobeSet, Inc." },
    {  3261, "Martin Pestana" },
    {  3262, "Acuson Corporation" },
    {  3263, "Drake Automation Limited" },
    {  3264, "Kerr Vayne Systems Ltd." },
    {  3265, "KSquared Consulting" },
    {  3266, "HSBC Group" },
    {  3267, "IronBridge Networks, Inc." },
    {  3268, "Real Time Logic Inc." },
    {  3269, "TelServe" },
    {  3270, "UNIQUEST-Korea" },
    {  3271, "StockPower, Inc." },
    {  3272, "Yontem Computer & Electronics" },
    {  3273, "nwe GmbH" },
    {  3274, "The Information Systems Manager Inc." },
    {  3275, "Kosmos Image S.r.l." },
    {  3276, "Taihan Electric Wire Co., Ltd." },
    {  3277, "Telspec" },
    {  3278, "C-COM Corporation" },
    {  3279, "Adlex Corp." },
    {  3280, "CCI Europe" },
    {  3281, "SMS Enterprises" },
    {  3282, "Vicom Systems, Inc." },
    {  3283, "International Software Solutions" },
    {  3284, "OASIS Consortium" },
    {  3285, "NOVA Telecommunications, Inc." },
    {  3286, "Nera Satcom AS" },
    {  3287, "Proactive Networks, Inc." },
    {  3288, "Jacobs Rimell Limited" },
    {  3289, "Cryptomathic A/S" },
    {  3290, "AppliScope" },
    {  3291, "Simac Techniek NV" },
    {  3292, "Earthmen Technology" },
    {  3293, "Biffsters International" },
    {  3294, "Digitronic" },
    {  3295, "Internet Multifeed Co." },
    {  3296, "Argosy Research Inc." },
    {  3297, "NxNetworks" },
    {  3298, "MQSoftware, Inc." },
    {  3299, "Altair Data System" },
    {  3300, "Telsis Limited" },
    {  3301, "IMPACT" },
    {  3302, "SMI Computersysteme GmbH Nicole" },
    {  3303, "IDM, Ltd." },
    {  3304, "WinVista Corp." },
    {  3305, "Splitrock Services, Inc." },
    {  3306, "Vail Systems Incorporated" },
    {  3307, "SANE.net" },
    {  3308, "Ensemble Solutions, Inc." },
    {  3309, "Nomadix" },
    {  3310, "Jett International Inc." },
    {  3311, "Crocodial Communications Entwicklungsgesellschaft mbH" },
    {  3312, "Consulting Informatico de Cantabria S.L." },
    {  3313, "Broadcast Services" },
    {  3314, "Bergstresser Associates" },
    {  3315, "KingStar Computer Ltd." },
    {  3316, "Micro Logic Systems" },
    {  3317, "Port Community Rotterdam" },
    {  3318, "Computer & Competence GmbH" },
    {  3319, "GNOME project" },
    {  3320, "Shanghai Baud Data Communication Development Corp." },
    {  3321, "Teledata Communication Ltd." },
    {  3322, "Ipswitch, Inc." },
    {  3323, "Tadiran Microwave Networks" },
    {  3324, "Call Technologies, Inc." },
    {  3325, "Vocalis Ltd." },
    {  3326, "Bergen Data Consulting" },
    {  3327, "CA Technologies, Inc." },
    {  3328, "Indus River Networks, Inc." },
    {  3329, "NewCom Technologies, Inc." },
    {  3330, "PartnerGroup" },
    {  3331, "DeTeWe - Deutsche Telephonwerke Aktiengesellschaft & Co." },
    {  3332, "RCX System" },
    {  3333, "Auburn University" },
    {  3334, "Cap'Mediatel" },
    {  3335, "HAHT Software" },
    {  3336, "UTBF" },
    {  3337, "Chicago Police Department - Data Systems Division" },
    {  3338, "MORA Technological Services" },
    {  3339, "JHC" },
    {  3340, "OpenTV Inc." },
    {  3341, "SwitchSoft Systems, Inc." },
    {  3342, "MachOne Communications Inc." },
    {  3343, "Philips Digital Video Systems Harry" },
    {  3344, "Helsinki Televisio Oy" },
    {  3345, "Nemetschek AG" },
    {  3346, "Vocom" },
    {  3347, "Hitachi Kokusai Electric Inc." },
    {  3348, "Reliable Network Solutions" },
    {  3349, "Vogo Networks" },
    {  3350, "beusen" },
    {  3351, "Overland Data, Inc." },
    {  3352, "Go2 Technologies, Inc." },
    {  3353, "TransMedia Communications, Inc." },
    {  3354, "InnoMedia, Inc." },
    {  3355, "Orkit FI" },
    {  3356, "WebMaster, Incorporated" },
    {  3357, "Software & Management Associates, Inc." },
    {  3358, "Researcher" },
    {  3359, "Cygnus Global Consulting" },
    {  3360, "Columbine JDS Systems Inc." },
    {  3361, "Intraplex" },
    {  3362, "Selta S.p.A." },
    {  3363, "Southern New England Telecommunications" },
    {  3364, "Baltic Oil Ltd." },
    {  3365, "MailWizard Incorporated" },
    {  3366, "Da Vinci Systems cc" },
    {  3367, "NMS Research" },
    {  3368, "KimSungEun Co., Ltd." },
    {  3369, "Genicom Corporation" },
    {  3370, "Trango Software Corporation" },
    {  3371, "SungEun Systems" },
    {  3372, "COVE Sistemas, S.L." },
    {  3373, "SIAE Microelettronica S.p.A." },
    {  3374, "Cybertek Corp." },
    {  3375, "F5 Labs, Inc." },
    {  3376, "Valencia Systems" },
    {  3377, "HKC Communications, Inc." },
    {  3378, "Plant Equipment Inc." },
    {  3379, "HT Industrial Co." },
    {  3380, "Fuelling & Partner" },
    {  3381, "Atreve Software, Inc." },
    {  3382, "Venturi Wireless" },
    {  3383, "South East Water Limited" },
    {  3384, "WAM!NET" },
    {  3385, "University of Leicester" },
    {  3386, "21st Century Net" },
    {  3387, "Intellivoice, Inc" },
    {  3388, "Integral Partners" },
    {  3389, "Novotec Computers GmbH" },
    {  3390, "Marathon Technologies Corporation" },
    {  3391, "Software Technologies Group, Inc." },
    {  3392, "Quvintheumn Foundation" },
    {  3393, "SandS International" },
    {  3394, "NeTrue Communications" },
    {  3395, "Certicom Corp." },
    {  3396, "DICOS GmbH Kommunikationssysteme Stephan" },
    {  3397, "Border Blues Productions" },
    {  3398, "Fieldbus Foundation" },
    {  3399, "Olencom Electronics Ltd." },
    {  3400, "Alacrity Communications Inc." },
    {  3401, "McAfee Inc. (formerly 'Network Associates, Inc.')" },
    {  3402, "Magicom Integrated Solutions" },
    {  3403, "Marimba, Inc." },
    {  3404, "Adicom" },
    {  3405, "Expand Networks Inc." },
    {  3406, "EIS Corporation" },
    {  3407, "compu-DAWN, Inc." },
    {  3408, "Nylcare Health Plans" },
    {  3409, "Z-Tel Communications, Inc." },
    {  3410, "Land-5 Corporation" },
    {  3411, "J. Slivko's Web Design Consulting" },
    {  3412, "SanCastle Technologies Inc." },
    {  3413, "Radiotel" },
    {  3414, "VoiceStream Wireless, Inc." },
    {  3415, "Mobile Telephone Networks" },
    {  3416, "Neto Corporation" },
    {  3417, "CacheFlow Inc." },
    {  3418, "Interactive Channel Technologies, Inc." },
    {  3419, "DERA" },
    {  3420, "Rossiyskiy Kredit Bank" },
    {  3421, "Performance Reporting Services Ltd" },
    {  3422, "Network Aware, Inc." },
    {  3423, "Project 25" },
    {  3424, "Evident Software, Inc. (formerly 'Apogee Networks, Inc.')" },
    {  3425, "Amsdell Inc." },
    {  3426, "Tokyo Denshi Sekei K.K." },
    {  3427, "MicroJuris, Inc." },
    {  3428, "Computer Associates TCG Software" },
    {  3429, "GenNet Technology Co., Ltd." },
    {  3430, "Microtronix Datacom Ltd." },
    {  3431, "Western DataCom Co., Inc." },
    {  3432, "Tellium, Inc." },
    {  3433, "Goldencom Technologies, Inc." },
    {  3434, "Leightronix, Inc." },
    {  3435, "Porta Systems Ltd" },
    {  3436, "Brivida, Inc." },
    {  3437, "PitchonPe" },
    {  3438, "Missouri FreeNet" },
    {  3439, "Braintree Communications Pty Ltd" },
    {  3440, "Borealis Technology" },
    {  3441, "South Carolina State Ports Authority (SCSPA)" },
    {  3442, "Advantech Inc." },
    {  3443, "United Healthcare" },
    {  3444, "egnite Software GmbH" },
    {  3445, "Radiant Communications Corp." },
    {  3446, "Ridge Technologies Dave" },
    {  3447, "JGI, Inc." },
    {  3448, "Rivkin Science & Technology, Inc." },
    {  3449, "Fisher Berkeley Corp." },
    {  3450, "Ardence, Inc." },
    {  3451, "Vita Nuova Limited" },
    {  3452, "MDSI Mobile Data Solutions Inc." },
    {  3453, "AAE Systems, Inc." },
    {  3454, "ELVIS-PLUS" },
    {  3455, "Internet Freaks Luxembourg a.s.b.l.Department Technique" },
    {  3456, "Adtech, Inc." },
    {  3457, "Advanced Intelligent Networks Corp." },
    {  3458, "Transaction Network Services, Inc." },
    {  3459, "COM:ON Communication Systems GmbH" },
    {  3460, "Telecommunications Specialists Pte Ltd" },
    {  3461, "Inferentia SPA" },
    {  3462, "Makonin Consulting Corp." },
    {  3463, "Toucan Technology Ltd." },
    {  3464, "Gimlet Management Consultants Ltd" },
    {  3465, "Sanyo Denki Co., Ltd." },
    {  3466, "Optical Networks, Inc." },
    {  3467, "NORCOM Networks Corporation" },
    {  3468, "GTE Interactive" },
    {  3469, "Schumann Unternehmensberatung AG" },
    {  3470, "ATM R&D Center of BUPT" },
    {  3471, "Bear Stearns & Company, Inc." },
    {  3472, "Telamon, Inc." },
    {  3473, "Microgate Corporation" },
    {  3474, "Fujitu ICL Espana S.A." },
    {  3475, "Network Concepts" },
    {  3476, "Arepa Inc." },
    {  3477, "Dorado Software" },
    {  3478, "Spectra Logic" },
    {  3479, "ViewTouch, Inc." },
    {  3480, "VIEWS Net, Inc." },
    {  3481, "Himel Technology" },
    {  3482, "Ton & Lichttechnik" },
    {  3483, "Mariner Networks" },
    {  3484, "Alaska Textiles, Inc." },
    {  3485, "Alaska Cleaners, Inc." },
    {  3486, "Wellsprings Holdings, LLC" },
    {  3487, "Allure of Alaska" },
    {  3488, "SevenX" },
    {  3489, "Denali Sites, Inc." },
    {  3490, "United Systems Base" },
    {  3491, "CDConsultants Inc." },
    {  3492, "Comdisco, Inc." },
    {  3493, "Broadband Access Systems, Inc." },
    {  3494, "Convergent Networks, Inc." },
    {  3495, "National Laboratory for Applied Network Research" },
    {  3496, "Web-Resumes" },
    {  3497, "Virtual Vendor Inc." },
    {  3498, "BusinessBuilder Technologies Inc." },
    {  3499, "Cyber Server Park Inc." },
    {  3500, "COMSAT Laboratories" },
    {  3501, "Vodafone Value Added Services Ltd" },
    {  3502, "J & A Services" },
    {  3503, "Blue Lance, Inc." },
    {  3504, "Sandvik Coromant" },
    {  3505, "Virtual Virgin Islands, Inc." },
    {  3506, "PageTek" },
    {  3507, "e-Net, Inc." },
    {  3508, "NEST" },
    {  3509, "Capital Holdings Ltd" },
    {  3510, "TWO-WAY LAUNDRY" },
    {  3511, "SkyStream, Inc." },
    {  3512, "Portal Software, Inc." },
    {  3513, sminmpec_unknown },  /* (Added by Wireshark) */
    {  3514, "VStream Incorporated" },
    {  3515, "Joanneum Research GesmbH" },
    {  3516, "Cybernetica" },
    {  3517, "Tieto Technology A/S, Denmark" },
    {  3518, "Pressler Inc." },
    {  3519, "amplify.net, Inc." },
    {  3520, "TPS (La Television Par Satellite) Denis" },
    {  3521, "Atlas Technologies, Inc." },
    {  3522, "Biodata GmbH" },
    {  3523, "Netco GmbH" },
    {  3524, "Continium" },
    {  3525, "SilverBack Technologies" },
    {  3526, "ITC GmbH" },
    {  3527, "IntraSoft, Inc." },
    {  3528, "ESP, LLC" },
    {  3529, "AVT Corporation" },
    {  3530, "Research In Motion Ltd." },
    {  3531, "Orange DK" },
    {  3532, "Meisei System Service Company" },
    {  3533, "Acies Sistemas S/C Ltda." },
    {  3534, "CTAM Pty. Ltd." },
    {  3535, "Hutchison Avenue Software Corp." },
    {  3536, "Globus" },
    {  3537, "AirFiber, Inc." },
    {  3538, "Europe Connection Ltd" },
    {  3539, "Unassigned" },
    {  3540, "Conelly International, Inc." },
    {  3541, "Bindview Development Corp." },
    {  3542, "Galea Network Security" },
    {  3543, "Abilis gmbh" },
    {  3544, "Baycorp ID Services Ltd." },
    {  3545, "Maddox Broadcast Ltd." },
    {  3546, "Acute Communications Corporation" },
    {  3547, "Tollbridge Technologies" },
    {  3548, "Oresis Communications" },
    {  3549, "MLI Enterprises" },
    {  3550, "Allstor Software Limited" },
    {  3551, "Spring Tide Networks, Inc." },
    {  3552, "EES Technology Ltd." },
    {  3553, "CSP AG" },
    {  3554, "SAS Institue Inc" },
    {  3555, "NetLock Ltd." },
    {  3556, "GENO-RZ GmbH" },
    {  3557, "MS3.net" },
    {  3558, "BGS Systemplanung AG" },
    {  3559, "The Digital Schoolhouse" },
    {  3560, "Sphere Logic Corporation" },
    {  3561, "The Broadband Forum (formerly 'ADSL Forum')" },
    {  3562, "Selway Moore Limited" },
    {  3563, "National Network Data Services" },
    {  3564, "Ciphernet" },
    {  3565, "Grolier Interactive Europe On Line Groupe" },
    {  3566, "Midnight Technologies" },
    {  3567, "Scott Supply Service, Inc." },
    {  3568, "Service Co LLC" },
    {  3569, "Electronic Payment Services, Inc." },
    {  3570, "Tait Limited" },
    {  3571, "Gift-Trek Malaysia Sdn. Bhd." },
    {  3572, "HanA Systems, Inc." },
    {  3573, "South African Networking People (Pty) Ltd" },
    {  3574, "ORSYP SA" },
    {  3575, "RKB Onsite Computer Service" },
    {  3576, "MCI" },
    {  3577, "Himachal Futuristic Communications Limited" },
    {  3578, "PixStream Incorporated" },
    {  3579, "Hurley" },
    {  3580, "Bell Emergis" },
    {  3581, "Seagate Technology" },
    {  3582, "LSI Logic" },
    {  3583, "JetCell, Inc." },
    {  3584, "Pacific Fiberoptics, Inc." },
    {  3585, "Omnisec AG" },
    {  3586, "Diebold, Incorporated" },
    {  3587, "TIW Systems, Inc." },
    {  3588, "NovoGroup Oyj" },
    {  3589, "SoGot" },
    {  3590, "IA Information Systems AG" },
    {  3591, "R.W. Shore" },
    {  3592, "Draeger Medizintechnik GmbH" },
    {  3593, "Alcatel Sistemas de Informacion" },
    {  3594, "LJL Enterprises, Inc." },
    {  3595, "BC TEL Advanced Communications" },
    {  3596, "CMLTechnologies Inc." },
    {  3597, "WildThings" },
    {  3598, "Dixie Cake" },
    {  3599, "Type & Graphics Pty Limited" },
    {  3600, "Teltronics, Inc." },
    {  3601, "C.R. McGuffin Consulting Services" },
    {  3602, "International Datacasting Corporation" },
    {  3603, "Westpac Banking Corporation" },
    {  3604, "XYPI MEDIANET PVT. Ltd." },
    {  3605, "Nesser & Nesser Consulting" },
    {  3606, "Incognito Software Systems Inc." },
    {  3607, "Cerent Corporation" },
    {  3608, "The Tillerman Group" },
    {  3609, "Cequs Inc." },
    {  3610, "Ryan Net Works" },
    {  3611, "Foo Chicken, Ltd" },
    {  3612, "Marcel Enterprises" },
    {  3613, "Rubicon Technologies, Inc." },
    {  3614, "Altor plc" },
    {  3615, "SoftWell Performance AB" },
    {  3616, "United Resource Economic & Trading Center C.," },
    {  3617, "SurfControl plc" },
    {  3618, "Flying Crocodile, Inc" },
    {  3619, "ProxyMed, Inc." },
    {  3620, "Transact Systems, Inc." },
    {  3621, "Nuance Communications" },
    {  3622, "GEFM" },
    {  3623, "Systemintegrering AB" },
    {  3624, "Enator Communications AB" },
    {  3625, "iHighway.net, Inc." },
    {  3626, "Dipl.-Ing. (FH) Markus Drechsler" },
    {  3627, "Criptolab" },
    {  3628, "Tietokesko Ltd" },
    {  3629, "Atos Origin" },
    {  3630, "DeltaKabel Telecom cv" },
    {  3631, "Bridgewater Systems Corp." },
    {  3632, "MaxComm Technologies Inc." },
    {  3633, "iD2 Technologies AB" },
    {  3634, "Allied Riser Communications Inc." },
    {  3635, "Wavesat Telecom, Inc." },
    {  3636, "dpa Deutsche Presse-Agentur GmbH" },
    {  3637, "Power & Data Technology, Inc." },
    {  3638, "IntelliReach Corporation" },
    {  3639, "WM-data" },
    {  3640, "DataPath, Inc." },
    {  3641, "Netaphor Software, Inc." },
    {  3642, "CryptoConsult" },
    {  3643, "DIRTSA" },
    {  3644, "Carden Enterprise Ltd" },
    {  3645, "SONZ Ltd" },
    {  3646, "ASKEY Computer Corp." },
    {  3647, "RaidTec, Inc." },
    {  3648, "Harcourt Brace & Company" },
    {  3649, "Rollins Technology Inc." },
    {  3650, "NetOps Corp" },
    {  3651, "Know IT AB" },
    {  3652, "Pan Dacom Direkt GmbH (formerly 'Pan Dacom Networking AG')" },
    {  3653, "Cirque Networks, Inc." },
    {  3654, "NaviNet" },
    {  3655, "Germanischer Lloyd AG" },
    {  3656, "FORCE Computers GmbH" },
    {  3657, "Ericsson Wireless LAN Systems" },
    {  3658, "Dalian F.T.Z. TianYang Int'l Trade Co., Ltd." },
    {  3659, "Ethercity Designs and Hosting Solutions" },
    {  3660, "G3M Corporation" },
    {  3661, "Secure Data Access Inc." },
    {  3662, "QWES.com Incorporated" },
    {  3663, "Megaxess" },
    {  3664, "Polygon" },
    {  3665, "Netoids Inc." },
    {  3666, "Acriter Software B.V." },
    {  3667, "InteleNet Communications" },
    {  3668, "Control Module Inc.(CMI)" },
    {  3669, "Aveo Inc." },
    {  3670, "MD PREI" },
    {  3671, "Picazo Communication Inc." },
    {  3672, "Scottsdale Securities, Inc." },
    {  3673, "WebManage Technologies, Inc." },
    {  3674, "Infoclubindia" },
    {  3675, "Connor Plumbing & Heating" },
    {  3676, "Sentryl Software, Inc." },
    {  3677, "Engetron - Engenharia Eletronica Ind. e Com. Ltda." },
    {  3678, "Icaro" },
    {  3679, "Unity Health" },
    {  3680, "Parity Software Dev. Corp." },
    {  3681, "David D. Hartman, CPA" },
    {  3682, "ComGates Communications Ltd." },
    {  3683, "Honeywell Oy, Varkaus" },
    {  3684, "InterWorld Corp." },
    {  3685, "Sento Pty Ltd" },
    {  3686, "Wicks By Julie" },
    {  3687, "HSD - Hardware Software Development GmbH" },
    {  3688, "Morpho e-documents (formerly 'Sagem Orga GmbH')" },
    {  3689, "New Technology Development, Inc." },
    {  3690, "TIAA-CREF" },
    {  3691, "Team2it-CopyLeft S.r.l." },
    {  3692, "Intuit" },
    {  3693, "Hakusan Corporation" },
    {  3694, "Thyssen Informatik GmbH" },
    {  3695, "Chromatis Networks Inc." },
    {  3696, "MicroProdigy" },
    {  3697, "Quantum Corporation" },
    {  3698, "Saraide" },
    {  3699, "Network Technologies Inc" },
    {  3700, "Stellar One Corporation" },
    {  3701, "TurboNet Communications" },
    {  3702, "Printrak International Inc." },
    {  3703, "CyberFax Inc." },
    {  3704, "AMD" },
    {  3705, "ICET SpA" },
    {  3706, "ADiTel Telekommunikation Network GmbH" },
    {  3707, "ADiT Holding GmbH" },
    {  3708, "ADLER DATA Software GmbH" },
    {  3709, "Teracom Telematica Ltda." },
    {  3710, "LANmetrix Pty Ltd" },
    {  3711, "SINETICA" },
    {  3712, "GigaNet Incorporated" },
    {  3713, "Voxent Systems Ltd" },
    {  3714, "BellSouth Wireless Data, L.P." },
    {  3715, "Teleste Corporation" },
    {  3716, "Brand Communications Limited" },
    {  3717, "GeNUA mbH" },
    {  3718, "Philips Broadband Networks" },
    {  3719, "Exmicro" },
    {  3720, "Visiqn" },
    {  3721, "OTONET s.a.r.l." },
    {  3722, "Vulkan-Com Ltd." },
    {  3723, "Ankey" },
    {  3724, "Interactive Communications Systems" },
    {  3725, "AC&E Ltd" },
    {  3726, "enCommerce, Incorporated" },
    {  3727, "Western Multiplex" },
    {  3728, "REALM Information Technoligies, Inc." },
    {  3729, "Nokia (formerly 'Alcatel-Lucent')" },
    {  3730, "Westport Technologies" },
    {  3731, "The SABRE Group" },
    {  3732, "Calamp Wireless Networks Inc (formerly 'Dataradio Inc.')" },
    {  3733, "Datakom Austria DI Erich" },
    {  3734, "Security-7 Ltd." },
    {  3735, "Telesafe AS" },
    {  3736, "Goodfield Corp." },
    {  3737, "Pleiades Communications, Inc." },
    {  3738, "StreamSoft, Inc." },
    {  3739, "The Eighteenth Software Co.,Ltd." },
    {  3740, "Aquila Technologies Group, Inc" },
    {  3741, "Foliage Software Systems" },
    {  3742, "VIATechnologies,Inc" },
    {  3743, "P.D. Systems International Ltd" },
    {  3744, "DATEV eG" },
    {  3745, "ClustRa AS" },
    {  3746, "Swisscom AG" },
    {  3747, "AS Yegen" },
    {  3748, "Bank of America" },
    {  3749, "TeleHub Communication Corp" },
    {  3750, "Iscape Software" },
    {  3751, "Dragon Industries" },
    {  3752, "Thales Norway AS" },
    {  3753, "Aitek S.r.L." },
    {  3754, "Crag Technologies" },
    {  3755, "ATOP Technologies, Inc." },
    {  3756, "Julien Daniel" },
    {  3757, "PT. Usaha Mediantara Intranet" },
    {  3758, "Core Networks, Inc" },
    {  3759, "OMEGA Micro Systems" },
    {  3760, "Content Technologies Ltd" },
    {  3761, "HAGER-ELECTRONICS GmbH" },
    {  3762, "Kwangwoon University" },
    {  3763, "Veramark" },
    {  3764, "Quantum Corporation  (formerly 'Advanced Digital Information Corporation')" },
    {  3765, "StrategicLink Consulting" },
    {  3766, "Hannibal Teknologies" },
    {  3767, "Pan-International Industrial Corp." },
    {  3768, "Department of Veterans Affairs" },
    {  3769, "Banyan Networks Pvt. Ltd." },
    {  3770, "MCK Communications" },
    {  3771, "ko6yd" },
    {  3772, "POS Resources Inc." },
    {  3773, "Siara Systems" },
    {  3774, "Wavelink" },
    {  3775, "AGFA Corporation" },
    {  3776, "Millenium Solutions" },
    {  3777, "HydraWEB Technologies" },
    {  3778, "CP Eletronica Industrial S/A" },
    {  3779, "Kingmax Technology Inc." },
    {  3780, "Level 3 Communications, Inc." },
    {  3781, "WXN, Inc." },
    {  3782, "University of North Texas" },
    {  3783, "EMR Corporation" },
    {  3784, "Speakerbus Ltd." },
    {  3785, "Cirrus Logic" },
    {  3786, "Highland Technology Group, Inc." },
    {  3787, "Russel Lane & Associates, Inc." },
    {  3788, "Talktyme Technologies Inc" },
    {  3789, "Wire Terminator (WT)" },
    {  3790, "Hamamatsu Photonics K.K. Kazuhiko" },
    {  3791, "TeleComp, Inc." },
    {  3792, "LOGEC Systems" },
    {  3793, "Lanier Worldwide, Inc." },
    {  3794, "Midas Communication Technologies Private Limited" },
    {  3795, "Enact Inc." },
    {  3796, "imt Information Management Technology AG" },
    {  3797, "BENQ Corporation" },
    {  3798, "Jinny Paging" },
    {  3799, "Live Networking Inc." },
    {  3800, "Unisource Italia S.p.A." },
    {  3801, "Agranat Systems, Inc." },
    {  3802, "Softamed" },
    {  3803, "Praxon" },
    {  3804, "Standard Chartered Bank (Treasury)" },
    {  3805, "Longhai Yongchuan Foods Co., Ltd." },
    {  3806, "Shiron Satellite Communications(1996) Ltd." },
    {  3807, "Wuhan Research Institute of Posts and Telecommunications" },
    {  3808, "Cyber Power System Inc." },
    {  3809, "Cyras Systems Inc" },
    {  3810, "NetLine" },
    {  3811, "SpectraSoft Inc." },
    {  3812, "Anda Networks, Inc." },
    {  3813, "Ellacoya Networks, Inc." },
    {  3814, "CallNet Communications, Inc." },
    {  3815, "Control Solutions, Inc." },
    {  3816, "Nominet UK" },
    {  3817, "Monfox, Inc." },
    {  3818, "MetraTech Corp." },
    {  3819, "OptiSystems Solutions Ltd." },
    {  3820, "Ziga Corporation" },
    {  3821, "Indian Valley Enterpriseses Inc." },
    {  3822, "Edimax Technology Co., Ltd." },
    {  3823, "Touchbase Communications" },
    {  3824, "Attune Networks" },
    {  3825, "Advanced Network & Services, Inc." },
    {  3826, "Nextpoint Networks, Inc." },
    {  3827, "Moscow Central Depository" },
    {  3828, "STG Inc." },
    {  3829, "Imaging Technologies Corporation" },
    {  3830, "Acision" },
    {  3831, "Oblix Inc." },
    {  3832, "Taylored Solutions" },
    {  3833, "Schneider Electric" },
    {  3834, "Novartis Pharma AG" },
    {  3835, "ALPS Electric" },
    {  3836, "Terese Brown Real Estate" },
    {  3837, "HBOC Imaging Solutions Group" },
    {  3838, "Gasper Corporation" },
    {  3839, "NeoWave Inc." },
    {  3840, "Globe Institute of Technology" },
    {  3841, "Flycast Communications Corp." },
    {  3842, "lkis" },
    {  3843, "Pyderion Contact Technologies Inc." },
    {  3844, "Graham Technology plc" },
    {  3845, "Citrix Systems Inc." },
    {  3846, "QMaster Software Solutions, Inc." },
    {  3847, "Ensemble Communications Incorporated" },
    {  3848, "Northchurch Communications, Inc." },
    {  3849, "Object Integration, Inc." },
    {  3850, "Xnet Communications GmbH" },
    {  3851, "Optika Inc." },
    {  3852, "Soft-Inter Technologies" },
    {  3853, "ViaGate Technologies" },
    {  3854, "KCP, Inc." },
    {  3855, "Elastic Networks" },
    {  3856, "Siebel Systems" },
    {  3857, "Sage Research Facility" },
    {  3858, "Capricon Engineers" },
    {  3859, "VXL Instruments Ltd" },
    {  3860, "First International Computer, Inc." },
    {  3861, "Fujitsu Network Communications, Inc." },
    {  3862, "Royal Bank of Scotland" },
    {  3863, "Canadian Marconi Company" },
    {  3864, "InTalk, Inc." },
    {  3865, "Thorne, West" },
    {  3866, "Global Net Center" },
    {  3867, "Presence Technology GmbH+Co.KGMichael" },
    {  3868, "Convergys Information Management Group" },
    {  3869, "IntelliLogic Networks, Inc." },
    {  3870, "Internet Business Emporium" },
    {  3871, "Ditech Corporation" },
    {  3872, "Miranda Technologies Inc." },
    {  3873, "QLogic" },
    {  3874, "InfoValue Computing, Inc." },
    {  3875, "Metro Computing Consultants, Inc." },
    {  3876, "ARINC Incorporated" },
    {  3877, "First American National Bank" },
    {  3878, "Real Software Company" },
    {  3879, "Taiwan Telecommunication Industry Co., Ltd." },
    {  3880, "Wireless Information Transfer Systems" },
    {  3881, "Telefonaktiebolaget LM Ericsson" },
    {  3882, "Pacom Systems Pty Ltd" },
    {  3883, "Next plc" },
    {  3884, "Phobos Corporation" },
    {  3885, "Lifeline Systems Inc." },
    {  3886, "MiMax Information" },
    {  3887, "Elder Enterprises" },
    {  3888, "Iapetus Software" },
    {  3889, "CE Infosys GmbH" },
    {  3890, "Across Wireless AB" },
    {  3891, "Chicago Board of Trade" },
    {  3892, "ATEB" },
    {  3893, "Parks Comunicacoes Digitais" },
    {  3894, "Pitney Bowes" },
    {  3895, "Advent Communications Ltd" },
    {  3896, "Automated Integrated Solutions, Inc." },
    {  3897, "Edison Technology Solutions" },
    {  3898, "Mitsubishi Telecommunications Network Division" },
    {  3899, "South China Morning Post Publishers Ltd" },
    {  3900, "Raster Solutions Pty. Ltd." },
    {  3901, "Managed Messaging, LLC" },
    {  3902, "Zhongxing Telecom Co.,ltd. (abbr. ZTE)" },
    {  3903, "Tornado Development, Inc." },
    {  3904, "Xlink Internet Service GmbH" },
    {  3905, "Telenordia Internet" },
    {  3906, "Data Communication Technology Research Institute" },
    {  3907, "California Independent System Operator" },
    {  3908, "GSP" },
    {  3909, "Nodes, Inc." },
    {  3910, "Railtrack PLC" },
    {  3911, "Glasner Consulting" },
    {  3912, "GWcom, Inc." },
    {  3913, "Array Telecom Corp." },
    {  3914, "TCOSoft, Inc." },
    {  3915, "Teknis Electronics" },
    {  3916, "Neo-Core, Inc." },
    {  3917, "V-Bits, Inc." },
    {  3918, "Watson Wyatt Worldwide" },
    {  3919, "Monterey Networks, Inc." },
    {  3920, "CSNet Consulting, Inc." },
    {  3921, "Aplion Networks, Inc." },
    {  3922, "Operational Research Consultants" },
    {  3923, "Intrak, Inc." },
    {  3924, "Policy Management Systems Corp." },
    {  3925, "Encompass Enterprise Management Consultants" },
    {  3926, "NewSouth Communications Corp." },
    {  3927, "WarpSpeed Communications" },
    {  3928, "Sandwich Wireless Communications, Inc." },
    {  3929, "NEITH Creative Beauty" },
    {  3930, "NTT Electronics Corporation" },
    {  3931, "EasyAccess" },
    {  3932, "Lara Technology, Inc." },
    {  3933, "NEXO" },
    {  3934, "Net-Wise Communications Ltd" },
    {  3935, "Centro Cantonale d'Informatica" },
    {  3936, "SINTECA" },
    {  3937, "EMS Technologies Canada Ltd." },
    {  3938, "Deccan Technologies, Inc.Vijay Burgula/Vik Jang" },
    {  3939, "Internet Devices, Inc." },
    {  3940, "Ninety.De" },
    {  3941, "Santak Electronics Co. Ltd." },
    {  3942, "Infinet LLC (formerly 'Aqua Project Group')" },
    {  3943, "Deva.net" },
    {  3944, "Data Solutions Group" },
    {  3945, "Sylantro Systems" },
    {  3946, "Conklin Corporation" },
    {  3947, "Inverse Network Technology" },
    {  3948, "MicroLegend Telecom Systems Inc." },
    {  3949, "Intrinsix Corporation" },
    {  3950, "TierTwo Systems" },
    {  3951, "Visionik A/S" },
    {  3952, "Caly Corporation" },
    {  3953, "Albert Ackermann GmbH + Co KG" },
    {  3954, "Mitra Imaging Inc." },
    {  3955, "Linksys" },
    {  3956, "Envox" },
    {  3957, "Globalarchitect" },
    {  3958, "Solution Associates" },
    {  3959, "InterCall Communications & Consulting" },
    {  3960, "Government Technology Solutions" },
    {  3961, "Corona Networks" },
    {  3962, "MGL Groupe AUBAY" },
    {  3963, "R.C. Wright & Associates" },
    {  3964, "Danet GmbH" },
    {  3965, "Spacebridge Networks Corporation" },
    {  3966, "Allianz Elementar Versicherungs-Aktiengesellschaften" },
    {  3967, "Bosch Sicherheitssysteme Engineering GmbH" },
    {  3968, "Webline Communications Corp." },
    {  3969, "RealNetworks, Inc." },
    {  3970, "FragRage Network" },
    {  3971, "IMECOM" },
    {  3972, "Apsion" },
    {  3973, "Aelita Software Group" },
    {  3974, "Custom Internetworking Inc." },
    {  3975, "Boston Communications Group, Inc." },
    {  3976, "LinkData Solutions (Pty) Limited" },
    {  3977, "Broadband Networks, Inc." },
    {  3978, "Ingenieurbuero fuer Telekommunikations- undSoftware-Systemloesungen" },
    {  3979, "AsGa Microeletronica S.A." },
    {  3980, "Home Account Network, Inc." },
    {  3981, "Troika Networks, Inc." },
    {  3982, "FaxNET Corporation" },
    {  3983, "Video Networks, Inc" },
    {  3984, "EBSCO Publishing" },
    {  3985, "Avery Computer Systems" },
    {  3986, "HighwayMaster" },
    {  3987, "Concept Webcd Services Pvt. Ltd." },
    {  3988, "Finecom Co., Ltd." },
    {  3989, "DigiComm Corporation" },
    {  3990, "Innovative Technology Software Systems Ltd" },
    {  3991, "Reticom" },
    {  3992, "Ohmega Electronic Products Ltd." },
    {  3993, "Perfect Order" },
    {  3994, "Virtual Resources Communications Inc." },
    {  3995, "VASCO Data Security International, Inc." },
    {  3996, "Open Systems AG" },
    {  3997, "ImproWare AG" },
    {  3998, "Cherus" },
    {  3999, "dydx" },
    {  4000, "Hi-net Research Group" },
    {  4001, "KADAK Products Ltd." },
    {  4002, "Banco del Buen Ayre" },
    {  4003, "George Mason University" },
    {  4004, "Aloha Networks Inc." },
    {  4005, "Tundo Corporation" },
    {  4006, "Tundo Communication and Telephony Ltd." },
    {  4007, "Cable & Wireless Communications plc" },
    {  4008, "Ardebil Pty Ltd" },
    {  4009, "Telephonics Corporation" },
    {  4010, "Dorsai Technology" },
    {  4011, "CNUT Archetype Ltd" },
    {  4012, "Selectica, Inc." },
    {  4013, "KPMG LLP ICE Telecom-SVO" },
    {  4014, "StarBurst Software" },
    {  4015, "Computer Configurations Holdings" },
    {  4016, "Iperia, Incorporated" },
    {  4017, "Logisistem Srl" },
    {  4018, "Security First Technologies, Inc." },
    {  4019, "APIS Software GmbH" },
    {  4020, "Coop Genossenschaft Switzerland" },
    {  4021, "Ensim Corporation" },
    {  4022, "AEC Ltd." },
    {  4023, "Imran" },
    {  4024, "Avantel S.A." },
    {  4025, "Lexitech, Inc." },
    {  4026, "Internet Access AG" },
    {  4027, "GTE Laboratories Incorporated" },
    {  4028, "Decision Networks" },
    {  4029, "NSI Communications Systems Inc." },
    {  4030, "Mitsubishi Electric Automation, Inc.- UPS division" },
    {  4031, "Orillion USA, Inc." },
    {  4032, "DataKinetics Ltd" },
    {  4033, "Signal Core" },
    {  4034, "IntraNet, Inc." },
    {  4035, "Ignitus Communications" },
    {  4036, "Enator Telub AB" },
    {  4037, "Presbyterian Church (USA)" },
    {  4038, "Softov Advanced Systems Ltd." },
    {  4039, "Mayan Networks Corporation" },
    {  4040, "MicroSignals Group" },
    {  4041, "Nomura International Plc" },
    {  4042, "DigiCommerce Ltd." },
    {  4043, "QNX Software Systems Ltd." },
    {  4044, "Eloquence Limited" },
    {  4045, "Thomson-CSF Communications" },
    {  4046, "SCORT" },
    {  4047, "Hunan Computer CO., Ltd." },
    {  4048, "Kinko's, Inc." },
    {  4049, "Opus Comunicacao de Dados" },
    {  4050, "Infuntainment Limited" },
    {  4051, "SowsEar Solution Design Group" },
    {  4052, "Vanguard Security Technologies Ltd Raviv Karnieli" },
    {  4053, "Switchcore" },
    {  4054, "Abatis Systems Corporation" },
    {  4055, "Nimbus Software AS" },
    {  4056, "StreamCORE" },
    {  4057, "ControlNet, Inc." },
    {  4058, "Generali IT-Solutions GmbH" },
    {  4059, "Broadlogic" },
    {  4060, "JFAX.COM" },
    {  4061, "Technology Control Services" },
    {  4062, "Astral Point Communications, Inc." },
    {  4063, "ASC Technologies AG (formerly 'ASC Telecom AG')" },
    {  4064, "Elma Oy Electronic Trading" },
    {  4065, "InfraServ GmbH & Co Gendorf KG" },
    {  4066, "Carioli Consulting Inc." },
    {  4067, "Fivemere Ltd." },
    {  4068, "Pathway Inc." },
    {  4069, "Ellison Software Consulting, Inc." },
    {  4070, "US West Internet Services" },
    {  4071, "PRAIM S.p.A." },
    {  4072, "Qeyton Systems AB" },
    {  4073, "TeleDiffusion de France" },
    {  4074, "Krutulis Enterprises" },
    {  4075, "Sedona Networks" },
    {  4076, "Novera Software, Inc." },
    {  4077, "The Limited, Inc." },
    {  4078, "Symon Communications" },
    {  4079, "24/7 Media, Inc." },
    {  4080, "Archangels Realty, Inc." },
    {  4081, "Zelea" },
    {  4082, "Timko Enterprises" },
    {  4083, "Spark New Zealand (formerly 'Telecom New Zealand')" },
    {  4084, "Trilogy Development Group" },
    {  4085, "D.I.B. Ges. fuer Standortbetreiberdienste mbH" },
    {  4086, "Ericsson Research Montreal (LMC)" },
    {  4087, "USWeb/CKS" },
    {  4088, "aku awekku & co." },
    {  4089, "SALUtel" },
    {  4090, "Consorte Tele AS" },
    {  4091, "Infitel Italia srl" },
    {  4092, "Computel Standby BV" },
    {  4093, "Merlot Communications, Inc." },
    {  4094, "Quality Tank & Construction Co. Inc." },
    {  4095, "Axent Technologies" },
    {  4096, "Thales e-Security" },
    {  4097, "Elan Text to Speech" },
    {  4098, "Signaal Communications" },
    {  4099, "Tristrata Inc." },
    {  4100, "Wavetek Wandel Goltermann" },
    {  4101, "John Hancock Financial Services" },
    {  4102, "SHYM Technology Inc." },
    {  4103, "CNN" },
    {  4104, "Redwood Technology B.V." },
    {  4105, "Stargus, Inc." },
    {  4106, "Astrophysikalisches Institut Potsdam" },
    {  4107, "Beijing Telecom Administration, China" },
    {  4108, "Serendip" },
    {  4109, "Durango Security Group" },
    {  4110, "Softstart Services Inc." },
    {  4111, "Westell (UK) Ltd" },
    {  4112, "Tunitas Group" },
    {  4113, "Tenor Networks, Inc." },
    {  4114, "T10.net" },
    {  4115, "Arris Interactive LLC" },
    {  4116, "InfoInterActive Inc." },
    {  4117, "Entertainment Systems Technology" },
    {  4118, "Tesla Liptovsky Hradok a.s." },
    {  4119, "Remote Management Systems Pty Ltd" },
    {  4120, "Sonik Technologies Corp." },
    {  4121, "Digital Chicago.net" },
    {  4122, "The University of Texas Health Science Center at Houston" },
    {  4123, "Hitachi America Ltd" },
    {  4124, "Unify Consulting Group, Inc." },
    {  4125, "Siemens AG ICP Kornelius" },
    {  4126, "LogMatrix Inc (formerly 'Open Service')" },
    {  4127, "Mercury Computer Systems, Inc." },
    {  4128, "ARM Ltd." },
    {  4129, "Mnaccari@consulting" },
    {  4130, "Microwave Data Systems" },
    {  4131, "Tridium" },
    {  4132, "Connecticut Hospital Association" },
    {  4133, "philipjeddycpas" },
    {  4134, "Philip J. Eddy & Partners Pty Ltd" },
    {  4135, "NiceTec GmbH" },
    {  4136, "UQAM | Universit\0303\0251 du Qu\0303\0251bec \0303\0240 Montr\0303\0251al" },
    {  4137, "GAURI Info-Comm.Inc." },
    {  4138, "Sychron Ltd" },
    {  4139, "WapIT Ltd." },
    {  4140, "Computer & Telephony Systems AB" },
    {  4141, "IMR Worldwide Pty Ltd" },
    {  4142, "FDS Networks Limited" },
    {  4143, "M&I Data Services Alexander" },
    {  4144, "PricewaterhouseCoopers-FP5" },
    {  4145, "Cristie Data Products Limited" },
    {  4146, "GlobalSign NV/SA" },
    {  4147, "Zuercher Kantonalbank" },
    {  4148, "DeWitt, Ross &Stevens, S.C." },
    {  4149, "Accrue Software, Inc." },
    {  4150, "Northwestern Mutual Life Insurance Company" },
    {  4151, "iMPath Networks Inc." },
    {  4152, "Two Way TV" },
    {  4153, "Simple Networks" },
    {  4154, "Versa Technology, Inc." },
    {  4155, "Cemoc Ltd" },
    {  4156, "New Access Communications, Inc." },
    {  4157, "BCE Emergis" },
    {  4158, "Milman Consulting" },
    {  4159, "Electronic Theatre Controls, Inc." },
    {  4160, "VIVE Synergies Inc." },
    {  4161, "Qtera Corporation" },
    {  4162, "Input Output Inc." },
    {  4163, "Quarry Technologies" },
    {  4164, sminmpec_unknown },  /* (Added by Wireshark) */
    {  4165, "SE Electronics" },
    {  4166, "The Mercy Foundation" },
    {  4167, "Markus Lauer IT Consulting" },
    {  4168, "Systems Management Specialists" },
    {  4169, "Syzygy Solutions" },
    {  4170, "University of Wisconsin-Milwaukee" },
    {  4171, "BOSUNG Data Communication Co." },
    {  4172, "Narae Information & Communication Enterprise" },
    {  4173, "VIERLING Communication S.A.S." },
    {  4174, "Critical Devices, Inc." },
    {  4175, "Tessler's Nifty Tools" },
    {  4176, "Newton Solutions" },
    {  4177, "Redding Enterprises" },
    {  4178, "Aspect Software" },
    {  4179, "Commercial Technologies Corp" },
    {  4180, "Talkstar.Com Inc." },
    {  4181, "Generic Telecom Ltd." },
    {  4182, "Leningrad Nuclear Power Plant" },
    {  4183, "Hammer Technologies" },
    {  4184, "SMS - Shared Medical Systems, Inc." },
    {  4185, "Boostworks" },
    {  4186, "AKA Consulting, Inc." },
    {  4187, "Storage Area Networks Ltd" },
    {  4188, "Realize Communications" },
    {  4189, "EGIS K.K." },
    {  4190, "ETRADE Securities" },
    {  4191, "SIGOS Systemintegration GmbH" },
    {  4192, "Tennessee Valley Authority" },
    {  4193, "VUT BRNO, faculty of EE and CS" },
    {  4194, "Leonia plc" },
    {  4195, "TeleSoft Inc." },
    {  4196, "Siemens AG Automation & Drives" },
    {  4197, "Cap Gemini Denmark A/S" },
    {  4198, "VPN Consortium" },
    {  4199, "Cellnet Technology, Inc." },
    {  4200, "Fast Search & Transfer" },
    {  4201, "Tonna Electronique" },
    {  4202, "Samwoo Telecommunications Co., Ltd." },
    {  4203, "The OpenLDAP Foundation" },
    {  4204, "Adtec Co., Ltd." },
    {  4205, "Durak Unlimited" },
    {  4206, "MITA Industrial Co., Ltd." },
    {  4207, "Daydream Promotions" },
    {  4208, "Tantivy Communications, Inc." },
    {  4209, "CDVS Inc." },
    {  4210, "Assumption University" },
    {  4211, "Corillian" },
    {  4212, "SPM - Systementwicklung und Projektmanagement GmbH" },
    {  4213, "Infrax Inc." },
    {  4214, "Sunquest Information Systems, Inc." },
    {  4215, "SilkRoad, Inc." },
    {  4216, "Triton Network Systems" },
    {  4217, "Opalis" },
    {  4218, "Gecko Software Limited" },
    {  4219, "regioconnect GmbH" },
    {  4220, "ARCANVS" },
    {  4221, "Soundscaipe" },
    {  4222, "OnDisplay Incorporated" },
    {  4223, "Milgo Solutions, Inc." },
    {  4224, "John H. Harland Company" },
    {  4225, "Peach Networks" },
    {  4226, "Composit Communications" },
    {  4227, "Sixtra Chile S.A." },
    {  4228, "DASCOM, Inc." },
    {  4229, "Westfair Foods Ltd." },
    {  4230, "Pirouette, Inc." },
    {  4231, "OB Telematics" },
    {  4232, "CTX Opto-Electronics Corp." },
    {  4233, "Dalian Daxian Network System Co.ltd" },
    {  4234, "Pragma Ltda." },
    {  4235, "CultureShock Multimedia" },
    {  4236, "Spectel Ltd." },
    {  4237, "Busby Software" },
    {  4238, "Media Station Inc." },
    {  4239, "Kommunedata A/S" },
    {  4240, "Vodafone Information Systems GmbH" },
    {  4241, "Peakstone Corporation" },
    {  4242, "The Clorox Company" },
    {  4243, "NPO Infoservice" },
    {  4244, "Cinnabar Networks Inc." },
    {  4245, "Posten SDS AS" },
    {  4246, "Comverse Network Systems (CNS)" },
    {  4247, "The University of Edinburgh" },
    {  4248, "Interconexion Electrica S.A." },
    {  4249, "NATEKS Ltd." },
    {  4250, "H.I.T. Industries Sales Ltd" },
    {  4251, "System Design Repair" },
    {  4252, "High Speed Access" },
    {  4253, "LuxN, Inc." },
    {  4254, "arvato systems GmbH" },
    {  4255, "Perfecto Technologies" },
    {  4256, "Kipling Information Technology AB" },
    {  4257, "Cyberstation, Inc." },
    {  4258, "Open4Rent" },
    {  4259, "FDP" },
    {  4260, "3rd Millennium Consulting" },
    {  4261, "Globol Solutions" },
    {  4262, "Jean=Claude Metal Craft" },
    {  4263, "Dr. Andreas Muller, Beratung und Entwicklung" },
    {  4264, "World Ramp, Inc." },
    {  4265, "Tachion Network Technologies Inc." },
    {  4266, "FernUniversitaet Hagen" },
    {  4267, "Transcend, Inc." },
    {  4268, "BancTec Computer and Network Services" },
    {  4269, "WorldPort Communications, Inc." },
    {  4270, "EDV-Beratung Blechschmidt" },
    {  4271, "Nevex Software Technologies Inc." },
    {  4272, "Exact Solutions, Inc." },
    {  4273, "LEROY AUTOMATIQUE INDUSTRIELLE" },
    {  4274, "Pangolin UK Ltd" },
    {  4275, "Duke University" },
    {  4276, "PCS Innovations Inc." },
    {  4277, "Telocity Communications, Inc." },
    {  4278, "Yahoo!" },
    {  4279, "Sirocco Systems" },
    {  4280, "ARtem GmbHMichael Marsanu/Catrinel Catrinescu" },
    {  4281, "Assumption" },
    {  4282, "KenCast Inc." },
    {  4283, "Dual-Zentrumn GmbH" },
    {  4284, "Norweb Internett Tjenester" },
    {  4285, "Ruslan CommunicationsDmitry Shibayev, Alexandr Gorbachev" },
    {  4286, "e-Security, Inc." },
    {  4287, "Philips Consumer Electronics" },
    {  4288, "Forge Research Pty Ltd" },
    {  4289, "VBrick Systems, Inc." },
    {  4290, "Logic Innovations, Inc." },
    {  4291, "Chordiant Software Inc." },
    {  4292, "Entera, Inc." },
    {  4293, "Bensons" },
    {  4294, "Salbu (Pty) Ltd" },
    {  4295, "Kalki Communication Technologies Pvt Ltd" },
    {  4296, "Cenfor S.L." },
    {  4297, "Finisar Corporation" },
    {  4298, "ETC (Excellence in Technology Consulting)" },
    {  4299, "Open Solution Providers" },
    {  4300, "Inmon Corp." },
    {  4301, "UniServe Consulting Limited" },
    {  4302, "Cybex Computer Products Corporation" },
    {  4303, "CamART" },
    {  4304, "CSIRO - Div. of Animal Health" },
    {  4305, "University of Maryland" },
    {  4306, "JMDEL Systems" },
    {  4307, "Office Connect, Inc." },
    {  4308, "Consejo Superior de Camaras" },
    {  4309, "IP Technologies" },
    {  4310, "Unique Computer Services, Inc." },
    {  4311, "Equinix" },
    {  4312, "VITA Systems, Inc." },
    {  4313, "Allayer Technologies" },
    {  4314, "Xilinx, Inc." },
    {  4315, "XACCT Technologies, Ltd." },
    {  4316, "Brandeis University" },
    {  4317, "Javelin Technology Corp." },
    {  4318, "Edixia" },
    {  4319, "Ennovate Networks, Inc" },
    {  4320, "Freshwater Software, Inc." },
    {  4321, "Riverbed Technologies" },
    {  4322, "Murata Machinery, Ltd." },
    {  4323, "Quantum Bridge" },
    {  4324, "SAEJIN T&M Co., Ltd." },
    {  4325, "Aperto Networks" },
    {  4326, "Crown International" },
    {  4327, "Trading WorldCom" },
    {  4328, "M.I. Systems, K.K." },
    {  4329, "Siemens AG" },
    {  4330, "PMC-Sierra Inc." },
    {  4331, "Aventail Corporation" },
    {  4332, "Institute of Systems & information Technologies/KYUSHU" },
    {  4333, "Insight Technology, Inc." },
    {  4334, "Ampersand Chantilly Communications" },
    {  4335, "TechWorld Incorporated" },
    {  4336, "Expertech Pty Ltd" },
    {  4337, "RadiSys Corp." },
    {  4338, "Case Corporation" },
    {  4339, "Rhode Island Economic Development Corporation" },
    {  4340, "Bacteriophage Lambda" },
    {  4341, "Spider Internet Services" },
    {  4342, "USHealth Real Estate" },
    {  4343, "Boundless Technologies" },
    {  4344, "Post-Industrial Training Institute" },
    {  4345, "Thomas & Betts" },
    {  4346, "Phoenix Contact GmbH & Co." },
    {  4347, "MessageWise Inc." },
    {  4348, "Domino Computers Nigeria Ltd" },
    {  4349, "LXCO Technologies AG" },
    {  4350, "Maxpert AG" },
    {  4351, "Network Systems Group" },
    {  4352, "Urgle" },
    {  4353, "Builders Network Ltd" },
    {  4354, "NetDragon Ltd" },
    {  4355, "RapidStream, Inc." },
    {  4356, "Inform GmbH & Co. KG" },
    {  4357, "Coteng" },
    {  4358, "Ziatech Corporation" },
    {  4359, "TelGen Corporation" },
    {  4360, "Tumbleweed Communications" },
    {  4361, "Amgen, Inc." },
    {  4362, "Nylorac Software, Inc." },
    {  4363, "University of Bristol Julius" },
    {  4364, "BV Solutions Group" },
    {  4365, "Myowngig" },
    {  4366, "Locus Corp." },
    {  4367, "Electronic Laboratory Services CC" },
    {  4368, "H.A.N.D. GmbH" },
    {  4369, "Brocade Communications Systems, Inc. (formerly 'McDATA,Inc')" },
    {  4370, "Tokyo DisneySea" },
    {  4371, "Digital United Inc." },
    {  4372, "Softlink s.r.o." },
    {  4373, "Rivere Corporation" },
    {  4374, "Motive Communications, Inc." },
    {  4375, "DT Research, Inc" },
    {  4376, "Nettech Systems, Inc." },
    {  4377, "X-Point Communications" },
    {  4378, sminmpec_unknown },  /* (Added by Wireshark) */
    {  4379, "Alien Internet Services" },
    {  4380, "Elipse Software" },
    {  4381, "Astracon Inc." },
    {  4382, "Aladdin Knowledge Systems Ltd." },
    {  4383, "Glassey.com" },
    {  4384, "Meridianus" },
    {  4385, "Stime.org WG" },
    {  4386, "TDC A/S" },
    {  4387, "Ubique Ltd." },
    {  4388, "Alcatel Altech Telecoms" },
    {  4389, "Sys-Dis" },
    {  4390, "Kemper Insurance" },
    {  4391, "Texas A&M University" },
    {  4392, "Northbrook Services, Inc." },
    {  4393, "Pentacom Ltd." },
    {  4394, "SoftFx" },
    {  4395, "Unified Technologies Sverige HB" },
    {  4396, "The Open Group" },
    {  4397, "OPT Technologies Limited" },
    {  4398, "B&L Associates, Inc." },
    {  4399, "Johnson Controls, Inc." },
    {  4400, "Cypress Corporation" },
    {  4401, "MoonVine" },
    {  4402, "NetPredict, Inc" },
    {  4403, "Visual Brain Ltd S.a.r.l." },
    {  4404, "Tekelec" },
    {  4405, "Ansid Inc." },
    {  4406, "Toyo Information Systems Co., Ltd." },
    {  4407, "Dracom Ltd." },
    {  4408, "EDSL" },
    {  4409, "Campus Pipeline, Inc." },
    {  4410, "Earth Star Group" },
    {  4411, "Swinburne.com" },
    {  4412, "Wrox Press" },
    {  4413, "Broadcom Corporation" },
    {  4414, "Scandinavian Softline Technology Oy" },
    {  4415, "Florida Department of Law Enforcement" },
    {  4416, "Starfire Experts Ltd" },
    {  4417, "Alidian Networks, Inc." },
    {  4418, "MegaSys Computer Technologies" },
    {  4419, "Sony Online Entertainment" },
    {  4420, "Westica Limited" },
    {  4421, "Santera Systems Inc." },
    {  4422, "GTE I.T." },
    {  4423, "Garnet Systems Co., Ltd." },
    {  4424, "Rapid Logic" },
    {  4425, "Meta Gymnastics, Inc." },
    {  4426, "Fujitsu Australia Software Technology Pty Ltd" },
    {  4427, "Pironet Intranet AG" },
    {  4428, "Supercomputing Systems AG" },
    {  4429, "MegaChips Corporation" },
    {  4430, "Silicon Automation Systems (India) Ltd" },
    {  4431, "Netia" },
    {  4432, "Apani Networks" },
    {  4433, "Strategic Financial Planning" },
    {  4434, "Bluestone Software Inc." },
    {  4435, "Suedtiroler Informatik AG" },
    {  4436, "Mission Critical" },
    {  4437, "Canadian Imperial Bank of Commerce" },
    {  4438, "G\0303\0266teborg Energi AB" },
    {  4439, "EnZane Enterprise" },
    {  4440, "Purdue University" },
    {  4441, "GE Capital Fleet Services" },
    {  4442, "KARA" },
    {  4443, "Ned Boddie & Assoc." },
    {  4444, "SAINCO" },
    {  4445, "INTER s.a.r.l." },
    {  4446, "Prairie Development, Inc." },
    {  4447, "Rochester Institute of Technology" },
    {  4448, "E-Lock Technologies, Inc." },
    {  4449, "SSH Communications Security, Inc." },
    {  4450, "iC-Consult" },
    {  4451, "MORION" },
    {  4452, "Telenor 4tel" },
    {  4453, "Infonet Services Corp." },
    {  4454, "Gottfried Web and Computer Consulting" },
    {  4455, "I-Bus Corporation" },
    {  4456, "AWI (formerly 'Qualimetrics')" },
    {  4457, "O ROCK ActiveWear (formerly 'Alpha & Omega Storehouse, LLC')" },
    {  4458, "Radwin Ltd." },
    {  4459, "Industree B.V." },
    {  4460, "FirstWorld Communications" },
    {  4461, "OpenNetwork Technologies" },
    {  4462, "SVM Microwaves, s.r.o." },
    {  4463, "TaoNet" },
    {  4464, "MPB Communications Inc." },
    {  4465, "ViewCast.com" },
    {  4466, "Harmonic Video Network  (formerly 'Tadiran Scopus')" },
    {  4467, "FibroLan" },
    {  4468, "Telkoor-QPS" },
    {  4469, "Diversinet Corp." },
    {  4470, "TeleDream Inc." },
    {  4471, "Network Security Wizards" },
    {  4472, "MONTAGE IT Services Inc." },
    {  4473, "Opto 22" },
    {  4474, "PaxComm" },
    {  4475, "Rainbow Software Solutions, Inc." },
    {  4476, "Lightrealm" },
    {  4477, "Infocom Systems Services" },
    {  4478, "Alacritech" },
    {  4479, "SpectraPoint Wireless LLC" },
    {  4480, "FastForward Networks, Inc." },
    {  4481, "CIA Europe" },
    {  4482, "RWE AG" },
    {  4483, "IBI Co., Ltd." },
    {  4484, "Pacific Softworks, Inc." },
    {  4485, "Dataport Communications" },
    {  4486, "Verio Web Hosting" },
    {  4487, "Johnson & Johnson NCS" },
    {  4488, "MediaHouse Software Inc" },
    {  4489, "Sierra Networks, Inc." },
    {  4490, "POLYGON Consultants in Informatics Ltd." },
    {  4491, "Cable Television Laboratories, Inc." },
    {  4492, "SolutionSoft Systems, Inc." },
    {  4493, "UniRel Sistemi srl Mauro" },
    {  4494, "Novartis AG" },
    {  4495, "Taima Corp." },
    {  4496, "Siemens Canada Ltd." },
    {  4497, "Avail Networks, Inc." },
    {  4498, "NetQoS, Inc." },
    {  4499, "Safefunds.com" },
    {  4500, "Jordan Tech" },
    {  4501, "EforNet Corporation" },
    {  4502, "playbeing.org" },
    {  4503, "Corporate Information Technologies" },
    {  4504, "Seamless Kludge Internetworking Labs Ltd" },
    {  4505, "Caltex Australia Petroleum Pty Ltd" },
    {  4506, "Channels Measurement Services" },
    {  4507, "The Miami Herald" },
    {  4508, "Geeks Like Us" },
    {  4509, "Nakayo Telecommunications, Inc." },
    {  4510, "Dracom" },
    {  4511, "Concord-Eracom Computer Security GmbH" },
    {  4512, "Sofreavia" },
    {  4513, "Terawave Communications, Inc." },
    {  4514, "Bank America" },
    {  4515, "PacketLight Networks Ltd." },
    {  4516, "SIAS" },
    {  4517, "Helius, Inc." },
    {  4518, "KMZ Consulting Group, Inc." },
    {  4519, "VERO Electronics Ltd." },
    {  4520, "Joohong Information and Communications" },
    {  4521, "Global ADSI Soltuions, Inc." },
    {  4522, "Ontario Power Generation" },
    {  4523, "eXaLink Ltd." },
    {  4524, "StorageSoft, Inc." },
    {  4525, "Micron Technology, Inc." },
    {  4526, "Netgear" },
    {  4527, "zeitgeist y2k01 Ltd." },
    {  4528, "8x8 Incorporated" },
    {  4529, "Internet Service Dept, WorldTelecom Plc" },
    {  4530, "Tunbridge Wells Equitable Friendly Society Ltd" },
    {  4531, "ON Technology Corporation Robert Smokey Montgomery" },
    {  4532, "GVCTW Corporation" },
    {  4533, "Atcomm Corporation" },
    {  4534, "onebox.com" },
    {  4535, "Javelinx Corporation" },
    {  4536, "Digitech" },
    {  4537, "Planex Communications Inc." },
    {  4538, "Easybuy" },
    {  4539, "RemarQ Communities, Inc." },
    {  4540, "Intelect Network Technologies Inc." },
    {  4541, "OutReach Technologies, Inc." },
    {  4542, "Alerting Specifications Forum" },
    {  4543, "Digitellum, Inc." },
    {  4544, "Gjensidige Forsikring" },
    {  4545, "Atlantis Software Inc" },
    {  4546, "AST Engineering Services, Inc." },
    {  4547, "ATTO Technology, Inc." },
    {  4548, "QuickStart Consulting Inc." },
    {  4549, "WebGear, Inc." },
    {  4550, "The Japan Electrical Manufacturers' Association" },
    {  4551, "Empirix, Inc" },
    {  4552, "Wayport, Inc." },
    {  4553, "NextCom K.K." },
    {  4554, "Trisol Technologies" },
    {  4555, "Socomec Sicon Ups" },
    {  4556, "Scali" },
    {  4557, "Qwest" },
    {  4558, "Euromove s.r.o." },
    {  4559, "NVision" },
    {  4560, "Shebang Networking" },
    {  4561, "OpenDOF Project, Inc. (formerly 'Panasonic Electric Works Laboratory of America, Inc./SLC Lab')" },
    {  4562, "Centermark Engineering LC" },
    {  4563, "Syllogi, Inc." },
    {  4564, "Diverse Networks, Inc." },
    {  4565, sminmpec_unknown },  /* (Added by Wireshark) */
    {  4566, "Cedelbank" },
    {  4567, "Cedel Global Services" },
    {  4568, "Cedel International" },
    {  4569, "Ensigma Ltd" },
    {  4570, "NetEnterprise, Inc." },
    {  4571, "JMCS, Inc." },
    {  4572, "Daedalus Corporation" },
    {  4573, "SecureSoft Inc." },
    {  4574, "Compu-Alvarado" },
    {  4575, "MANi Network Co., Ltd." },
    {  4576, "Corporacion ZIGOR S.A." },
    {  4577, "Internet Research" },
    {  4578, "SSE Telecom" },
    {  4579, "Vest Internett" },
    {  4580, "Diversified Business Group" },
    {  4581, "Seeburger GmbH" },
    {  4582, "World Telecom plc" },
    {  4583, "NetStar" },
    {  4584, "Headhunters London Limited" },
    {  4585, "Eel Valley Internet" },
    {  4586, "Enterprise Consulting Group" },
    {  4587, "Diamond Multimedia Systems, Inc." },
    {  4588, "Critical Path, Inc." },
    {  4589, "DATAP Division of TCEnet Inc." },
    {  4590, "Zoom Telephonics, Inc." },
    {  4591, "SpaceCom Systems, Inc." },
    {  4592, "Frontier Communications" },
    {  4593, "SAET I.S. S.p.A." },
    {  4594, "Saritel S.p.A." },
    {  4595, "IS Production" },
    {  4596, "Videoframe Systems" },
    {  4597, "Fiberview Technologies Inc." },
    {  4598, "JCampus" },
    {  4599, "MIMSOFT" },
    {  4600, sminmpec_unknown },  /* (Added by Wireshark) */
    {  4601, "Cybertime Informatik GmbH" },
    {  4602, "BEA Systems" },
    {  4603, "TERS Ltd." },
    {  4604, "Beca Carter Hollings & Ferner Ltd Mike Beamish" },
    {  4605, "Toronto School of Business" },
    {  4606, "Information Security Agency Ltd." },
    {  4607, "Software Shelf Technologies" },
    {  4608, "Harco Technology Ltd" },
    {  4609, "Seamless Technologies, Inc." },
    {  4610, "Strategic Technologies" },
    {  4611, "Digital Wireless Corporation" },
    {  4612, "Baker Street Technologies Inc." },
    {  4613, "Sphere Communications Inc" },
    {  4614, "Luminous Networks, Inc" },
    {  4615, "I-O Data Device, Inc." },
    {  4616, "ComputerJobs.com" },
    {  4617, "MARCOMPUTER" },
    {  4618, "ARMILLAIRE TECHNOLOGIES" },
    {  4619, "e!reminder.com" },
    {  4620, "Progressive Systems, Inc." },
    {  4621, "NSTOP Technologies Inc." },
    {  4622, "Legian Consultancy & Network Services" },
    {  4623, "Lifix Systems Oy" },
    {  4624, "Training for Tomorrow" },
    {  4625, "Mazone Systems" },
    {  4626, "WestLB" },
    {  4627, "SAET IS s.r.l." },
    {  4628, "Xtra On-Line" },
    {  4629, "Veraz Networks Inc. (formerly 'ipVerse')" },
    {  4630, "FileTek, Inc." },
    {  4631, "homeloandotcom" },
    {  4632, "FreeMarkets" },
    {  4633, "CQOS, Inc." },
    {  4634, "VCON Telecommunications Ltd." },
    {  4635, "The VE Group" },
    {  4636, "Intrust Software" },
    {  4637, "RGE, Inc." },
    {  4638, "SGI Soluciones Globales Internet" },
    {  4639, "TETRAGONE S.A." },
    {  4640, "Eckerd College" },
    {  4641, "Tellabs Inc (ADP)" },
    {  4642, "Bel. Studio H. Sager" },
    {  4643, "nworks" },
    {  4644, "Wincom Technology Inc." },
    {  4645, "Data Ductus AB" },
    {  4646, "NetConvergence, Inc." },
    {  4647, "Internet Chess Club" },
    {  4648, "The Grateful Net" },
    {  4649, "CPlane, Inc." },
    {  4650, "Marc August International" },
    {  4651, "Aztec Radiomedia" },
    {  4652, "Technical University of Ilmenau" },
    {  4653, "Precise Software Technologies Inc." },
    {  4654, "OCLC Online Computer Library Center, Inc." },
    {  4655, "TeleCheck International Inc." },
    {  4656, "Banco de Galicia y Buenos Aires" },
    {  4657, "Goodall Secure Services" },
    {  4658, "Entertainment International, Inc." },
    {  4659, "Teco Image Systems Co., Ltd." },
    {  4660, "RCMS Ltd" },
    {  4661, "Spazio R&D" },
    {  4662, "Frank Matthiess" },
    {  4663, "decor metall GmbH + CO. KG" },
    {  4664, "Ark Research Corporation" },
    {  4665, "Performance Design Limited" },
    {  4666, "Itchigo Communications GmbH" },
    {  4667, "Telperion Network Systems" },
    {  4668, "Turning Point Technologies" },
    {  4669, "Muro Enterprises, Inc." },
    {  4670, "National Computational Science Alliance" },
    {  4671, "Advanced Telecom Systems, Inc." },
    {  4672, "US Healthcare PKI" },
    {  4673, "Wave Research N.V." },
    {  4674, "Crunch Technologies BV" },
    {  4675, "WK Audiosystems BV" },
    {  4676, "Healthaxis.com Inc." },
    {  4677, "Concert Technologies" },
    {  4678, "Information Developers Unlimited" },
    {  4679, "OPICOM" },
    {  4680, "Telecommunications Systems Group - UCL" },
    {  4681, "dvg Hannover Datenverarbeitungsgesellschaft mbH" },
    {  4682, "Linux-HA Project" },
    {  4683, "Trading Technologies International, Inc." },
    {  4684, "Ambit Microsystems Corporation" },
    {  4685, "TONTRU Information Industry Group Co. Ltd." },
    {  4686, "VegaStream" },
    {  4687, "Digitro Tecnologia Ltda" },
    {  4688, "Luimes Computer Consulting" },
    {  4689, "Urbis.Net Ltd" },
    {  4690, "MBC Europe, B.V." },
    {  4691, "VAW Aluminum Technologie GmbH" },
    {  4692, "Digital Technics, LP" },
    {  4693, "Maxtor Corp.," },
    {  4694, "Willamette University" },
    {  4695, "Extricity Software" },
    {  4696, "WEBB Studios" },
    {  4697, "ATLANTEL" },
    {  4698, "Connectivity Software Systems" },
    {  4699, "Burning Door" },
    {  4700, "InternetPirate.com" },
    {  4701, "Syskoplan GmbH" },
    {  4702, "SpeechWorks International, Inc." },
    {  4703, "Sanford C. Bernstein & Co. Inc." },
    {  4704, "Visual Media Technologies, Inc." },
    {  4705, "Gabriel Communications" },
    {  4706, "Zero7.com" },
    {  4707, "Aldea Internet, S.A. de C.V. Javier" },
    {  4708, "iMedium Inc" },
    {  4709, "Oxydian S.A." },
    {  4710, "Safelayer S.A." },
    {  4711, "Mail.com" },
    {  4712, "Entropic Ltd" },
    {  4713, "WhereNet, Inc." },
    {  4714, "Centerpoint Broadband Technologies" },
    {  4715, "Advice Netbusiness Ltda" },
    {  4716, "Arbortext" },
    {  4717, "Media Management Consulting" },
    {  4718, "MDL Information Systems" },
    {  4719, "Montagnaleader s.c.a.r.l." },
    {  4720, "Lunatech Research" },
    {  4721, "Cositel Inc." },
    {  4722, "Jacksonville University" },
    {  4723, "Mockingbird Networks" },
    {  4724, "TechnoSoft" },
    {  4725, "Bestnet Internet Inc" },
    {  4726, "Capital Computer Services, Inc." },
    {  4727, "Langtang JV Company" },
    {  4728, "NSI Technology" },
    {  4729, "Crannog Software" },
    {  4730, "epita" },
    {  4731, "Socketware, Inc." },
    {  4732, "CVF" },
    {  4733, "Middlesex University" },
    {  4734, "Zarak Systems Corporation" },
    {  4735, "SOMA Networks, Inc." },
    {  4736, "Appliant, Inc." },
    {  4737, "Crosswalk.com, Inc." },
    {  4738, "Shanghai E-way Computer Network Technology Ltd." },
    {  4739, "OLDE Discount Corporation" },
    {  4740, "VoteHere" },
    {  4741, "Amber Networks, Inc" },
    {  4742, "Operational Technologies Services, Inc." },
    {  4743, "NextNet" },
    {  4744, "Internalnetwork" },
    {  4745, "DigiSAFE Pte Ltd" },
    {  4746, "PT Inovacao" },
    {  4747, "Service Technique de la Navigation Aerienne" },
    {  4748, "DoBiT nv" },
    {  4749, "e-Plaza" },
    {  4750, "Lykon Consulting" },
    {  4751, "SARL K1" },
    {  4752, "Crescent Networks" },
    {  4753, "MontaVista Software, Inc." },
    {  4754, "Symas Corp." },
    {  4755, "Directory Works" },
    {  4756, "CTC Union Technologies Co., Ltd." },
    {  4757, "IBS" },
    {  4758, "AnIX Group Ltd" },
    {  4759, "Peco II, Inc." },
    {  4760, "Viditec, Inc." },
    {  4761, "NuDesign Technologies Inc." },
    {  4762, "GRIC Communication Inc" },
    {  4763, "Teddybear Computer Services" },
    {  4764, "Global Crossing" },
    {  4765, "Tomorrow Factory" },
    {  4766, "Hochschule Heilbronn" },
    {  4767, "TrafficMaster PLC" },
    {  4768, "E.ON SE (formerly 'E.ON AG')" },
    {  4769, "IBM Corporation" },
    {  4770, "Ol'e Communications, Inc." },
    {  4771, "Narus Inc" },
    {  4772, "CyberSource Corporation" },
    {  4773, "RealNames Corporation" },
    {  4774, "Netpliance.net" },
    {  4775, "Network ICE" },
    {  4776, "Knight Fisk Ltd" },
    {  4777, "Cuperus Consultants" },
    {  4778, "Biscom, Inc." },
    {  4779, "Bay Technical Associates" },
    {  4780, "VADEM" },
    {  4781, "E.piphany, Inc." },
    {  4782, "3Cube, Inc." },
    {  4783, "CrosStor Software" },
    {  4784, "March Networks" },
    {  4785, "Appian Communications, Inc." },
    {  4786, "Sierra PartnersStephen Ells" },
    {  4787, "Shanghai Holdfast Online Information" },
    {  4788, "D-Trust GmbH" },
    {  4789, "Telica, Inc." },
    {  4790, "SecureLogix Corporation" },
    {  4791, "Dresdner Bank AG" },
    {  4792, "Wavefront" },
    {  4793, "Levi, Ray & Shoup, Inc." },
    {  4794, "eCoin, Inc." },
    {  4795, "Unified Productions, Inc." },
    {  4796, "Joe Chapa" },
    {  4797, "City Group Inc." },
    {  4798, "Vigil Technologies Ltd." },
    {  4799, "Leaselogix, Inc." },
    {  4800, "Jensley Pty Ltd" },
    {  4801, "Compass Corporate Systems, Inc." },
    {  4802, "Systematic Software Engineering A/S" },
    {  4803, "POWWOW" },
    {  4804, "Castello Cities Internet Network" },
    {  4805, "INOVA Corporation" },
    {  4806, "Rosslea Associates LLC" },
    {  4807, "Control Z Corporation" },
    {  4808, "Net-star Technology Corporation" },
    {  4809, "BSW Telecoms" },
    {  4810, "Bloemenveiling Holland" },
    {  4811, "Network Flight Recorder, Inc." },
    {  4812, "shanghai radio communication equipment manufacture company(srcem)" },
    {  4813, "GlenEvin" },
    {  4814, "Alex Temex Multimedia S.A." },
    {  4815, "H.B. Fuller Company" },
    {  4816, "Pacific Gas & Electric Company" },
    {  4817, "Innovative Technologies & Consulting, Inc." },
    {  4818, "Sinclair Internetworking Services" },
    {  4819, "RMS Technology Integration, Inc." },
    {  4820, "Quicknet Technologies, Inc." },
    {  4821, "SN2AI" },
    {  4822, "Fial Computer Inc." },
    {  4823, "Shanghai HuaLong Information Technology Development Center" },
    {  4824, "DSL Communications" },
    {  4825, "Golden Screens Interactive Technologies, Inc." },
    {  4826, "The European Clearing House" },
    {  4827, "Interoute Telecommunications Inc" },
    {  4828, "Intelidata Technologies Corp." },
    {  4829, "A to Z Pest Control" },
    {  4830, "Gloabl Media Corp." },
    {  4831, "BANCHILE" },
    {  4832, "Network Phenomena, LLC." },
    {  4833, "SDNI Inc." },
    {  4834, "Factum Electronics AB" },
    {  4835, "OPNET Technologies Co., Ltd." },
    {  4836, "LHS Telekom GmbH & Co. KG" },
    {  4837, "trrrippleRRRdesigns" },
    {  4838, "New Image Company" },
    {  4839, "2Wire, Inc." },
    {  4840, "Bedet Information Technologies" },
    {  4841, "iFace.com" },
    {  4842, "SecureAgent" },
    {  4843, "Amazon.com Inc." },
    {  4844, "NeoPoint, Inc." },
    {  4845, "Miralink Corp" },
    {  4846, "Lucent INS" },
    {  4847, "Vikram Kulkarni" },
    {  4848, "Interphiz Ltd" },
    {  4849, "Dipl. Phys. Peer Stritzinger Peer" },
    {  4850, "Eddie George Limited" },
    {  4851, "KRONE Telecell GmbH" },
    {  4852, "CMA Small Systems AB" },
    {  4853, "Syndeo Corporation" },
    {  4854, "Mk1 Design" },
    {  4855, "AddPac Technology Co., Ltd." },
    {  4856, "Veraluz International Corporation" },
    {  4857, "Cisco's Etc." },
    {  4858, "Fortech" },
    {  4859, "GEMS" },
    {  4860, "boo.com Group LTD" },
    {  4861, "PowerCom Technologies Inc Katta Veeraiah" },
    {  4862, "Redwood Marketing" },
    {  4863, "Parion" },
    {  4864, "JOH-DATA A/S" },
    {  4865, "ERG Group" },
    {  4866, "Moseley Associate Inc." },
    {  4867, "Viet Marketing" },
    {  4868, "Nextra (Schweiz) AG" },
    {  4869, "SIT Europe" },
    {  4870, "Fritz Egger GmbH & Co" },
    {  4871, "DiscoveryCom" },
    {  4872, "Bouygues Telecom" },
    {  4873, "Seay Systems, Inc." },
    {  4874, "Juniper Networks/Unisphere" },
    {  4875, "DoubleClick Inc." },
    {  4876, "Eyestreet Software" },
    {  4877, "Salon Press" },
    {  4878, "Village Networks, Inc." },
    {  4879, "SecureMethods, Inc." },
    {  4880, "Standard & Poors Compustat" },
    {  4881, "Ruijie Networks Co., Ltd. (formerly 'Start Network Technology Co., Ltd.')" },
    {  4882, "Root, Inc." },
    {  4883, "Saatch & Saatchi" },
    {  4884, "Protek Ltd" },
    {  4885, "Photon Technology Co., Ltd." },
    {  4886, "Westwave Communications" },
    {  4887, "IQ Wireless GmbH" },
    {  4888, "Multidata GmbH" },
    {  4889, "Inflow" },
    {  4890, "Skinners Computer Center" },
    {  4891, "Network Address Solutions" },
    {  4892, "The Chinese University of Hong Kong" },
    {  4893, "ATSHAW Technologies" },
    {  4894, "Kleinwort Benson Ltd." },
    {  4895, "Woodwind Communications Systems Inc." },
    {  4896, "TeleSoft International, Inc." },
    {  4897, "DoBusinessOnline Services" },
    {  4898, "Time Inc." },
    {  4899, "Walker Systems Corporation" },
    {  4900, "Conexant Systems" },
    {  4901, "USAA" },
    {  4902, "Beijing Huaguang Electronics Co., Ltd." },
    {  4903, "GCC Technologies Inc." },
    {  4904, "SDF" },
    {  4905, "WebDialogs, Inc" },
    {  4906, "Edgix Corporation" },
    {  4907, "AppWorx Corporation" },
    {  4908, "ATS, Advanced Technology Solutions S.A." },
    {  4909, "Experts Exchange" },
    {  4910, "Ubizen" },
    {  4911, "pcOrder.com, Inc." },
    {  4912, "HolisticMeta, LLC (formerly 'One World Information System')" },
    {  4913, sminmpec_unknown },  /* (Added by Wireshark) */
    {  4914, "hole-in-the.net" },
    {  4915, "Sipher Internet Technology Ltd.+44 1494 765335" },
    {  4916, "Blacksound SA" },
    {  4917, "Sociedad Estatal de Loterias y Apuestas de Estado" },
    {  4918, "Taurusent Technologies" },
    {  4919, "Luminate Software Corporation" },
    {  4920, "Boston Globe" },
    {  4921, "Network Solutions" },
    {  4922, "Telcordia Technologies, Inc." },
    {  4923, "AudioCodes" },
    {  4924, "SAN Valley Systems, Inc." },
    {  4925, "Zuma Networks" },
    {  4926, "TouchTunes Digital Jukebox" },
    {  4927, "time4you GmbH" },
    {  4928, "Xrosstech, Inc." },
    {  4929, "LAN Crypto" },
    {  4930, "Concord Technologies" },
    {  4931, "Standard & Poor's Corp." },
    {  4932, "Foglight Software" },
    {  4933, "Shunra Software Ltd." },
    {  4934, "WebDialogs, Inc" },
    {  4935, "Mediatrix Telecom Inc." },
    {  4936, "First American Financial Corporation John" },
    {  4937, "Stormbreaker Network Services" },
    {  4938, "Daeyoung Electronic Ind.CO., Ltd." },
    {  4939, "Procter & Gamble" },
    {  4940, "Convergent Communications Services, Inc." },
    {  4941, "Echelon Corporation" },
    {  4942, "Liberty Press & Letter Service Joseph De Silvis" },
    {  4943, "Novell GmbH" },
    {  4944, "Future Networks, Inc." },
    {  4945, "Logicon, Inc." },
    {  4946, "Psychedelic Illuminations Magazine" },
    {  4947, "Grass Valley USA, LLC" },
    {  4948, "MIGROS" },
    {  4949, "Fortress Technologies" },
    {  4950, "Luxor Software Inc." },
    {  4951, "State Farm Insurance" },
    {  4952, "Thinking Objects GmbH" },
    {  4953, "Tecnet Teleinformatica Ltda." },
    {  4954, "Wrox Press Itd" },
    {  4955, "Asgard Technologies, Inc" },
    {  4956, "GRAPHICS FIVE" },
    {  4957, "CNet Computer Systeme Netzwerk GmbH" },
    {  4958, "TerraLink Technologies, LLC" },
    {  4959, "U Force, Inc." },
    {  4960, "Chromisys" },
    {  4961, "Ardent Technologies" },
    {  4962, "Artel Video Systems, Inc." },
    {  4963, "@manage" },
    {  4964, "W.B. Love Enterprises Inc." },
    {  4965, "Greenwich Mean Time" },
    {  4966, "AACom" },
    {  4967, "Starwood Hotels & Resorts" },
    {  4968, "Universtiy of North Texas (unofficial)" },
    {  4969, "Park Air Systems Ltd." },
    {  4970, "National Grid for Learning" },
    {  4971, "Anglers Club" },
    {  4972, "Los Alamos National LaboratoryGiri" },
    {  4973, "SetNet Corporation" },
    {  4974, "eATM" },
    {  4975, "INTERVU Inc." },
    {  4976, "AGENT++" },
    {  4977, "Tiesse S.p.A" },
    {  4978, "Direkcija RS za poslovno informacijsko sredisce" },
    {  4979, "Licer Solutions" },
    {  4980, "Oxymium" },
    {  4981, "RiverDelta Networks" },
    {  4982, "Persistence Software Inc." },
    {  4983, "InnoMediaLogic Inc." },
    {  4984, "Pinnacle Systems" },
    {  4985, "Vigilant Networks" },
    {  4986, "KB/Tel" },
    {  4987, "Simpler Networks Inc." },
    {  4988, "Ronningen Consulting" },
    {  4989, "Connect Austria GmbH" },
    {  4990, "TTI Telecom" },
    {  4991, "Stonebridge Technologies, Inc.S.E." },
    {  4992, "Thyssen Krupp Information Systems GmbHHaynes" },
    {  4993, "CTU Prague" },
    {  4994, "CUT-THROAT TRAVEL OUTLET" },
    {  4995, "Universtiy of California, Berkeley" },
    {  4996, "Forest Networks LLC" },
    {  4997, "Inetd.Com Consulting" },
    {  4998, "Cadant Inc." },
    {  4999, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5000, "Personal Business" },
    {  5001, "LogicMedia" },
    {  5002, "RC Networks" },
    {  5003, "AudioCodes LTD" },
    {  5004, "Predictive Networks" },
    {  5005, "NCvision" },
    {  5006, "Vishwnet India" },
    {  5007, "Effective Computer Solutions, Inc." },
    {  5008, "drugstore.com" },
    {  5009, "Schiano" },
    {  5010, "Splash Technology, Inc." },
    {  5011, "Scaldis" },
    {  5012, "Lottomatica spa" },
    {  5013, "Maverick Internet Technology" },
    {  5014, "Viacast" },
    {  5015, "Verbind, Inc." },
    {  5016, "Oregon State University" },
    {  5017, "University of Akron" },
    {  5018, "Ameritrade Technology Group" },
    {  5019, "eBusiness Interactive" },
    {  5020, "sekwang eng. co." },
    {  5021, "Television Internacional S.A. de C.V." },
    {  5022, "Equipe Communications Corporation" },
    {  5023, "Bit by Bit Solutions, Inc." },
    {  5024, "3Domes, Inc." },
    {  5025, "OPUS 2 Revenue Technologies" },
    {  5026, "Aspiro AB" },
    {  5027, "Orebro Kommun" },
    {  5028, "Lightbridge" },
    {  5029, "Comma Soft AG" },
    {  5030, "University of Ulm" },
    {  5031, "Recovery" },
    {  5032, "Norscan Instruments Ltd" },
    {  5033, "eCharge Corporation" },
    {  5034, "LogicalSolutions.net" },
    {  5035, "Inter-National Research Institute" },
    {  5036, "Input Software" },
    {  5037, "Bri-link Technologies Inc." },
    {  5038, "T&S Software Associates Inc." },
    {  5039, "Xstreamis plc" },
    {  5040, "Wiesemann & Theis GmbH" },
    {  5041, "Menicx International Co. Ltd." },
    {  5042, "Broadwing Inc." },
    {  5043, "Micro Focus International Ltd" },
    {  5044, "Velocity Software Systems Ltd." },
    {  5045, "Bithop Systems, Inc." },
    {  5046, "CS SI" },
    {  5047, "Kimley-Horn and Associates" },
    {  5048, "Kudale Inc." },
    {  5049, "Equifax Inc." },
    {  5050, "Nordmark NorLan Consult" },
    {  5051, "Brix Networks" },
    {  5052, "Intermine Pty Ltd" },
    {  5053, "Agilent Technologies" },
    {  5054, "will" },
    {  5055, "Eolring" },
    {  5056, "Frank Lima" },
    {  5057, "Gifford Hesketh" },
    {  5058, "Avistar Systems" },
    {  5059, "Carmona Engineering Services" },
    {  5060, "Singapore Press Holdings Ltd" },
    {  5061, "Swisskey Ltd" },
    {  5062, "DFN Directory Services" },
    {  5063, "Telesta" },
    {  5064, "Deutsche Post AG" },
    {  5065, "PrivateExpress.com" },
    {  5066, "NetVision, Inc." },
    {  5067, "Open Society Fund - BH" },
    {  5068, "Jewsih Community of Bosnia and Herzegovina" },
    {  5069, "Call Connect" },
    {  5070, "Ganna Construction, Inc." },
    {  5071, "HIQ Networks" },
    {  5072, "Ditech Communications Corporation" },
    {  5073, "knOwhere, Inc." },
    {  5074, "Miva Corporation" },
    {  5075, "CNL CentralNet GmbH" },
    {  5076, "LongView International, Inc." },
    {  5077, "Clicknet Software" },
    {  5078, "Media Vision Computer Technologies" },
    {  5079, "Crosskeys Systems Corporation" },
    {  5080, "Power Systems" },
    {  5081, "Empowerment Group, Inc" },
    {  5082, "More Magic Software MMS Oy" },
    {  5083, "Daktronics" },
    {  5084, "SierraCom" },
    {  5085, "SmartMove" },
    {  5086, "ICS Advent" },
    {  5087, "Great Dragon Telecom(Group)" },
    {  5088, "Digital Burro, INC" },
    {  5089, "Clavister AB" },
    {  5090, "Carumba" },
    {  5091, "Norske Troll AS" },
    {  5092, "INFORMATIONSTECHNOLOGIE AUSTRIA GES. M.B.H." },
    {  5093, "SDF Enterprise" },
    {  5094, "The University of Tulsa" },
    {  5095, "Credit Suisse Group" },
    {  5096, "Computer Science and Engineering, CUHK" },
    {  5097, "Rock Marketing" },
    {  5098, "OPUSWAVE Networks, Inc." },
    {  5099, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5100, "Tricast Multimedia" },
    {  5101, "Novalabs" },
    {  5102, "Integro A.C.S." },
    {  5103, "Foxcom Ltd." },
    {  5104, "SarangNet" },
    {  5105, "Datang Telecom Technology CO., LTD" },
    {  5106, "elephant project" },
    {  5107, "Pinkl Consulting Services" },
    {  5108, "Modius Inc." },
    {  5109, "CHINA GREAT DRAGON TELECOMMUNICATION(GROUP) CO., LTD" },
    {  5110, "Health Business Systems, Inc." },
    {  5111, "Medea Corporation" },
    {  5112, "Corvia Networks, Inc." },
    {  5113, "gridware" },
    {  5114, "Future fibre Technologies" },
    {  5115, "PowerCom Technology Co., Ltd." },
    {  5116, "IBM, NUMA-Q Division" },
    {  5117, "Kaelin Colclasure" },
    {  5118, "Dantel,Inc." },
    {  5119, "SYCOR AG" },
    {  5120, "EMF Home Inspection Inc." },
    {  5121, "League Scoring" },
    {  5122, "Everest eCommerce, Inc." },
    {  5123, "Lucent Tech. Taiwan Telco." },
    {  5124, "Phonetic Systems Ltd." },
    {  5125, "Celestica Power" },
    {  5126, "Symtrex Inc." },
    {  5127, "Western Digital Corporation" },
    {  5128, "Saitama University Far Laboratory" },
    {  5129, "Macquarie University" },
    {  5130, "Omron Canada Inc." },
    {  5131, "lotz.de" },
    {  5132, "Mammut Net" },
    {  5133, "Halfdome Systems, Inc." },
    {  5134, "IP Unity" },
    {  5135, "CyberSafe Corporation" },
    {  5136, "Gruner + Jahr AG & Co KG (formerly 'Electronic Media Service')" },
    {  5137, "DFC, Inc." },
    {  5138, "Easynet Group Plc" },
    {  5139, "ARESCOM, Inc." },
    {  5140, "Compudisk Systems Ltd." },
    {  5141, "Hart Edwards Corporation, Inc." },
    {  5142, "IVANS" },
    {  5143, "Cereva Networks Inc." },
    {  5144, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5145, "ICT electronics SA" },
    {  5146, "Eclipsys Corporation" },
    {  5147, "MICEX" },
    {  5148, "cTc Computer Technik Czakay GmbH" },
    {  5149, "Managed Object Solutions, Inc." },
    {  5150, "Opsware" },
    {  5151, "NetGain, LLC" },
    {  5152, "Cable AML, Inc." },
    {  5153, "The University of Akron" },
    {  5154, "Incyte Genomics" },
    {  5155, "CS & S GH computer System Tech. Co., Ltd." },
    {  5156, "newproductshowroom.com" },
    {  5157, "The University of Queensland" },
    {  5158, "CompuTECH Services" },
    {  5159, "Ultra d.o.o." },
    {  5160, "DAIN Telecom Co., Ltd" },
    {  5161, "Morehead State University" },
    {  5162, "Societe Europeenne des Satellites" },
    {  5163, "Digital Marketplace, Inc." },
    {  5164, "Cygnet Technologies, Inc." },
    {  5165, "Sassafras Software Inc." },
    {  5166, "Mercom Systems, Inc." },
    {  5167, "Orchestream Ltd." },
    {  5168, "Levitte Programming" },
    {  5169, "NET CONSULTING S.R.L." },
    {  5170, "Aegis Data Systems, Inc." },
    {  5171, "WhizBang! Labs" },
    {  5172, "Protocom Development Systems" },
    {  5173, "Taqua Systems Inc." },
    {  5174, "PrivateExpress .com" },
    {  5175, "Lindsay Electronics" },
    {  5176, "2Win Information Systems, Inc." },
    {  5177, "Private Express Technologies Pte, Ltd." },
    {  5178, "Telephony Experts, Inc." },
    {  5179, "Arima Computer Corp." },
    {  5180, "The DocSpace Company Inc." },
    {  5181, "Firat Universites" },
    {  5182, "I Theta Corp." },
    {  5183, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5184, "C&N Touristic AG" },
    {  5185, "Sungmi Telecom Electronics Co., Ltd." },
    {  5186, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5187, "Bytware, Inc." },
    {  5188, "BITHOP SYSTEMS, Inc." },
    {  5189, "TELEFONICA I+D" },
    {  5190, "Organic" },
    {  5191, "DEKRA AG" },
    {  5192, "Gotham Networks" },
    {  5193, "Chemical Abstracts Service" },
    {  5194, "Okanagan Spring Brewery" },
    {  5195, "AdRem Software" },
    {  5196, "E-Tech, Inc." },
    {  5197, "Startup .com" },
    {  5198, "\"Universita`\" degli Studi di Roma \"Tor Vergata\"" },
    {  5199, "Odetics ITS" },
    {  5200, "EnFlex Corp." },
    {  5201, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5202, "Aalto University (formerly 'Helsinki University of Technology')" },
    {  5203, "The Naqvi Group" },
    {  5204, "ClickNet Software Corporation" },
    {  5205, "Ruby Tech Corp." },
    {  5206, "Voltaire" },
    {  5207, "USA-NET CORPORATIONS" },
    {  5208, "UPMACS Communications Inc." },
    {  5209, "Profound Rational Organization(PRO), Internatioal" },
    {  5210, "Linkline/Freegates" },
    {  5211, "NCvision Ltd." },
    {  5212, "Placeware, Inc." },
    {  5213, "Greylink, Inc." },
    {  5214, "Athens Chamber" },
    {  5215, "United Connections" },
    {  5216, "Senior Informatica Ltda." },
    {  5217, "SOFHA GmbH" },
    {  5218, "Networks Experts, Inc." },
    {  5219, "BeVocal Inc." },
    {  5220, "World Telecom Labs" },
    {  5221, "Wireless Systems International" },
    {  5222, "Dantel Inc." },
    {  5223, "Korea Electronics Technology Institute" },
    {  5224, "Hitachi Data Systems (Europe) Ltd." },
    {  5225, "Universidad de Cantabria- ATC" },
    {  5226, "Harmonix Limited" },
    {  5227, "MELCO Inc." },
    {  5228, "Littlefeet Inc." },
    {  5229, "Big Fish Communications" },
    {  5230, "ComRoesGroup" },
    {  5231, "Oswego State University" },
    {  5232, "Counterpane Internet Security" },
    {  5233, "Mercury Interactive Corp." },
    {  5234, "Shenzhen SED Info. Tech. Corp." },
    {  5235, "Persistent Systems Private Limited" },
    {  5236, "Great Dragon Telecom(Group)" },
    {  5237, "Trustis Limited" },
    {  5238, "SOcieta GEnerale di Informatica (SOGEI SPA)" },
    {  5239, "FESTE" },
    {  5240, "RAND" },
    {  5241, "TECHMATH AG" },
    {  5242, "Envilogg AB" },
    {  5243, "ICIS, School of EEE,Nayang Technological University" },
    {  5244, "Casey's Baja Tours" },
    {  5245, "Quarterstone Communications Inc.(QCI)" },
    {  5246, "SS8 Networks Inc." },
    {  5247, "Zinnia Design" },
    {  5248, "Michael Brehm" },
    {  5249, "Warner-Lambert" },
    {  5250, "Center7" },
    {  5251, "Donald E. Bynum" },
    {  5252, "CIS Technology" },
    {  5253, "Aldebaran" },
    {  5254, "Datang Telecom Technology CO., LTD" },
    {  5255, "EuroPKI" },
    {  5256, "Freeonline .com. au Pty Ltd" },
    {  5257, "AXUS Microsystems Inc." },
    {  5258, "Zeta Technologies Co. Ltd" },
    {  5259, "MATRA SYSTEMES & INFORMATION" },
    {  5260, "Digital Engineering" },
    {  5261, "LUTHER DANIEL" },
    {  5262, "QWIKWIRE. NET" },
    {  5263, "CAIS INTERNET" },
    {  5264, "Varian Medical Systems" },
    {  5265, "TeleDanmark Erhverv, CTIUdvikling" },
    {  5266, "Johannes Gutenberg-Universitaet Mainz" },
    {  5267, "Hong Kong University of Science and Technology" },
    {  5268, "IKEA IT CENTER AB" },
    {  5269, "The Fantastic Corporation" },
    {  5270, "da6d Technologies" },
    {  5271, "Comverse Network Systems" },
    {  5272, "w-Trade Technologies" },
    {  5273, "Unistra Technologies" },
    {  5274, "UNIF/X" },
    {  5275, "Malibu Networks" },
    {  5276, "Hearme.com" },
    {  5277, "SarangNET" },
    {  5278, "Swisscom. AG" },
    {  5279, "2Support Directory Solutions" },
    {  5280, "Citi" },
    {  5281, "Graeffet Communications" },
    {  5282, "Connected Systems" },
    {  5283, "CheckFree Corporation" },
    {  5284, "Filanet Corporation" },
    {  5285, "Network Experts, Inc." },
    {  5286, "CALENCE, Inc." },
    {  5287, "Persistent Systems Private Limited" },
    {  5288, "A-Plus Networks, Inc." },
    {  5289, "VidyaWeb. com, Inc." },
    {  5290, "Guide" },
    {  5291, "Bloemenveiling Aalsmeer" },
    {  5292, "Pirus Networks" },
    {  5293, "HYOSUNG CORPORATION" },
    {  5294, "Infinity Trade Inc" },
    {  5295, "\"DigitalThink Inc.\"" },
    {  5296, "IPCell Technologies, Inc." },
    {  5297, "Baxworks, Inc." },
    {  5298, "xputer.com" },
    {  5299, "WorldCast Systems (formerly 'AUDEMAT\")" },
    {  5300, "Jetstream Communications" },
    {  5301, "PentaSafe, Inc." },
    {  5302, "Advanced Health Technologies" },
    {  5303, "IPmobile Inc." },
    {  5304, "Airslide Systems Inc." },
    {  5305, "IIT KANPUR" },
    {  5306, "XESystems, Inc." },
    {  5307, "Ciprico, Inc." },
    {  5308, "SiemensS.A.(Portugal)" },
    {  5309, "EdelWeb SA" },
    {  5310, "Depository Trust & Clearing Corporation" },
    {  5311, "F&F Inc." },
    {  5312, "DIGICERT SDN" },
    {  5313, "Revlis, Inc." },
    {  5314, "Baunwall A/S" },
    {  5315, "CCIT(Beijing Creative Century Information Technology)Co. Ltd." },
    {  5316, "Guide Unusual" },
    {  5317, "Adaptive Computer Development Corp." },
    {  5318, "Robert Bosch GmbH" },
    {  5319, "EarthWatch Inc." },
    {  5320, "Surety Technologies Inc." },
    {  5321, "Burrito.org" },
    {  5322, "PADL Software Pty Ltd" },
    {  5323, "Telrad" },
    {  5324, "Delta Networks Inc." },
    {  5325, "Cmgi" },
    {  5326, "LightChip, Inc." },
    {  5327, "KIM Computing" },
    {  5328, "North Communications Inc." },
    {  5329, "ShoreTel, Inc (formerly 'Shoreline Teleworks')" },
    {  5330, "Spacelink Systems" },
    {  5331, "OI ELECTRIC CO., Ltd." },
    {  5332, "Information Freeway" },
    {  5333, "Celera Genomics" },
    {  5334, "START" },
    {  5335, "Multifunction Products Association" },
    {  5336, "BlueKite.com" },
    {  5337, "Ciprico, Inc." },
    {  5338, "ELDEC Corporation" },
    {  5339, "VisioWave" },
    {  5340, "CITI, S.A. de C.V." },
    {  5341, "PC Network Design" },
    {  5342, "Sensormatic" },
    {  5343, "Lone Wolf ComputingGeorge" },
    {  5344, "Originative Solutions Ltd." },
    {  5345, "SUNGMI TELECOM ELECTRONICS CO., Ltd." },
    {  5346, "SSM Health Care" },
    {  5347, "GE Harris Aviation Information Solutions, LLC" },
    {  5348, "TimeSpace Radio AB" },
    {  5349, "Inalp Networks Inc." },
    {  5350, "Infotron System Corp" },
    {  5351, "ATM S.A." },
    {  5352, "Maelstrom" },
    {  5353, "EVS Broadcast Equipment" },
    {  5354, "Simplement Ltd" },
    {  5355, "Eland Technologies" },
    {  5356, "Object Oriented Pty Ltd." },
    {  5357, "Evans Computer Consulting" },
    {  5358, "enhanced Global Convergence Services (eGCS)" },
    {  5359, "InnoVentry" },
    {  5360, "Haedong" },
    {  5361, "Westbridge Design Ltd." },
    {  5362, "QASYS CORP" },
    {  5363, "R. Smith Engineering Co." },
    {  5364, "Certall Finland OY" },
    {  5365, "Neartek, Inc." },
    {  5366, "Charlotte's Web Networks Ltd." },
    {  5367, "Telena S.p.A." },
    {  5368, "CoreExpress" },
    {  5369, "APD Communications Limited" },
    {  5370, "BANCO ZARAGOZANO S.A." },
    {  5371, "NetSubject Canada, Inc." },
    {  5372, "myCFO, Inc." },
    {  5373, "Open Telecommunications Limited" },
    {  5374, "Dirigo Incorporated" },
    {  5375, "BAE SYSTEMS, Tactical Comms (Filton)" },
    {  5376, "Oleane" },
    {  5377, "TriNexus" },
    {  5378, "PrairieFyre Software Inc." },
    {  5379, "Colonial State Bank" },
    {  5380, "CDOT" },
    {  5381, "SuperNova" },
    {  5382, "IRIS Technologies, Inc." },
    {  5383, "iFleet Inc." },
    {  5384, "Tsuruki Promotions" },
    {  5385, "City-NET CZ, s.r.o." },
    {  5386, "M-S Technology Consultants" },
    {  5387, "HyperFeed" },
    {  5388, "Network Alchemy Ltd." },
    {  5389, "Inter-Tel" },
    {  5390, "OPNET Technologies Co., Ltd." },
    {  5391, "Tyco Submarine Systems Ltd." },
    {  5392, "\"Online Creations\", Inc." },
    {  5393, "Renault" },
    {  5394, "Gateway Inc." },
    {  5395, "Laurel Networks, Inc." },
    {  5396, "BigChalk.com" },
    {  5397, "Standard and Poor's Fund Services" },
    {  5398, "ElephantX" },
    {  5399, "Extremis" },
    {  5400, "Evercom systems International Inc." },
    {  5401, "Master Soft" },
    {  5402, "IDF" },
    {  5403, "Vircom" },
    {  5404, "eConvergence Pty Ltd." },
    {  5405, "Start Printer equipment co. Ltd." },
    {  5406, "Nick Conte, Inc." },
    {  5407, "NetSupport GmbH" },
    {  5408, "Intellitel Communications" },
    {  5409, "East West Consulting K.K." },
    {  5410, "Les Howard" },
    {  5411, "SignalSoft Corporation" },
    {  5412, "Zantaz.com, Inc." },
    {  5413, "PeopleWeb CommunicationsInc." },
    {  5414, "John & Associate" },
    {  5415, "Fujitsu Asia Pte Ltd" },
    {  5416, "Nesral" },
    {  5417, "ABSA Group Ltd." },
    {  5418, "Fortis, Inc." },
    {  5419, "Cambridge Broadband Ltd." },
    {  5420, "Spider Technologies" },
    {  5421, "Marietta Dodge Inc." },
    {  5422, "RHC Enterprises Inc." },
    {  5423, "McLeodUSA" },
    {  5424, "Columbia Diversified Services" },
    {  5425, "NetSpace Online Systems" },
    {  5426, "GadLine Ltd." },
    {  5427, "stroeder.com" },
    {  5428, "ENDFORCE, Inc." },
    {  5429, "Propack Data Soft- und Hardware Entwicklungs GmbH" },
    {  5430, "Masterguard GmbH" },
    {  5431, "LM Digital" },
    {  5432, "SightPath" },
    {  5433, "Netonomy" },
    {  5434, "Advanced Hi-Tech Corporation" },
    {  5435, "OvisLink Corp" },
    {  5436, "OPEN" },
    {  5437, "Pensar Corporation" },
    {  5438, "Utrecht School of Arts" },
    {  5439, "Parallel Ltd." },
    {  5440, "Primeon, Ltd." },
    {  5441, "The Timken Company" },
    {  5442, "New Zealand Post Limited" },
    {  5443, "Nekema.com" },
    {  5444, "Joe Minineri" },
    {  5445, "Metrostat Technologies, Inc." },
    {  5446, "Skygate Technology Ltd" },
    {  5447, "Aeolon Research" },
    {  5448, "Kykink Communications Corp" },
    {  5449, "OneNetPlus.com" },
    {  5450, "I-Link Inc." },
    {  5451, "SEGAINTERSETTLE AG" },
    {  5452, "Business Layers" },
    {  5453, "Intelis, Inc" },
    {  5454, "Trango Systems, Inc." },
    {  5455, "Artemis Management Systems" },
    {  5456, "FOCUS Online GmbH" },
    {  5457, "CastleNet Technology Inc." },
    {  5458, "Gupta" },
    {  5459, "SANtools, Inc" },
    {  5460, "BroadLink Communications, Inc." },
    {  5461, "KSI Inc" },
    {  5462, "Resume.Com" },
    {  5463, "Eduardo Fermin" },
    {  5464, "Manukau Institute of Technology" },
    {  5465, "eBusiness Technologies" },
    {  5466, "International Biometric Society, IBS" },
    {  5467, "TELEFONICA INVESTIGACION Y DESARROLLO" },
    {  5468, "Actelis Networks" },
    {  5469, "Codebase" },
    {  5470, "Transparity Limited" },
    {  5471, "Switzerland" },
    {  5472, "timeproof" },
    {  5473, "AlgaCom" },
    {  5474, "Ericsson Ahead Communications Systems GmbH" },
    {  5475, "Thysys Engineering" },
    {  5476, "Apex Inc." },
    {  5477, "Netattach, Inc" },
    {  5478, "Critical Path Berlin/LEM" },
    {  5479, "Pinnacle Data Systems Inc (PDSi)" },
    {  5480, "T. Sqware Incorporated" },
    {  5481, "Agencia de Certificion Electronica" },
    {  5482, "Murakami Electro-Communication Laboratories, Inc." },
    {  5483, "Netensity, Inc." },
    {  5484, "University of the Aegean" },
    {  5485, "The OPEN Group Ltd" },
    {  5486, "China Merchants Bank" },
    {  5487, "Multitrade Spa" },
    {  5488, "Temblast" },
    {  5489, "ALS International Ltd." },
    {  5490, "CommNav, Inc." },
    {  5491, "UPS Manufacturing" },
    {  5492, "Telephia" },
    {  5493, "Palm Computing" },
    {  5494, "Marathon Innovations, Inc." },
    {  5495, "Convergence Equipment Company" },
    {  5496, "GEMPLUS" },
    {  5497, "Trondent Development Corp." },
    {  5498, "Kardinia Software" },
    {  5499, "YhKim Co. Ltd." },
    {  5500, "Gemeentelijk Havenbedrijf Rotterdam" },
    {  5501, "NTT PC Communications, Inc." },
    {  5502, "Canon Aptex Inc." },
    {  5503, "Orinda Technology Group" },
    {  5504, "Zhone Technologies, Inc." },
    {  5505, "Metrostat Technologies, Inc." },
    {  5506, "Digital-X, Inc." },
    {  5507, "Tight Informatics" },
    {  5508, "SWOD Org." },
    {  5509, "B&E Construction Co. Dennis" },
    {  5510, "PrismTech" },
    {  5511, "syscall() Network Solutions GbR" },
    {  5512, "GMD FIRST" },
    {  5513, "iXL" },
    {  5514, "Timeline Technology Inc." },
    {  5515, "Directory Tools and Application Services, Inc." },
    {  5516, "SecureWorks, Inc." },
    {  5517, "Rapid5 Networks" },
    {  5518, "TDS Telecom" },
    {  5519, "LSITEC" },
    {  5520, "Alfred Wegener Institute for Polar and Marine Research" },
    {  5521, "St. John Health System" },
    {  5522, "Cybernet Corporation" },
    {  5523, "GRCP" },
    {  5524, "Emory University" },
    {  5525, "SSF" },
    {  5526, "Adero, Inc." },
    {  5527, "Context Systems Group" },
    {  5528, "NetBotz" },
    {  5529, "Neoforma.com" },
    {  5530, "Cescom Inc." },
    {  5531, "Mien Information Solutions" },
    {  5532, "Q-Telecell GmbH" },
    {  5533, "WideAwake Ltd" },
    {  5534, "Vogon AB" },
    {  5535, "3rd Generation Partnership Project 2 (3GPP2)" },
    {  5536, "Quintus Corporation" },
    {  5537, "Comdial Corporation" },
    {  5538, "Micron Tech. Information co. kr" },
    {  5539, "Cybertek Holdings" },
    {  5540, "RWTH Aachen University" },
    {  5541, "Paragea Communications, Inc" },
    {  5542, "eOn Communications Corporation" },
    {  5543, "INIEMP HOLDINGS CORPORATION S.L." },
    {  5544, "Thomson-CSF Systems Canada" },
    {  5545, "TANTAU Software Inc." },
    {  5546, "MailVision Inc." },
    {  5547, "BSQUARE Corporation" },
    {  5548, "Cobalt Networks" },
    {  5549, "TimesTen Performance Software" },
    {  5550, "Monggo, Inc." },
    {  5551, "Oscilloquartz, S.A." },
    {  5552, "Air Atlanta Icelandic" },
    {  5553, "Macromedia eBusiness Solutions" },
    {  5554, "SpotCast Communications" },
    {  5555, "Authentic8 pty Ltd" },
    {  5556, "Service Factory" },
    {  5557, "OneMain.com" },
    {  5558, "S-Link Corporation" },
    {  5559, "Vitria Technology, Inc." },
    {  5560, "The Color Registry" },
    {  5561, "2nd Wave, Inc." },
    {  5562, "Redknee Inc." },
    {  5563, "Ola Internet" },
    {  5564, "Omega Enterprise" },
    {  5565, "Syswave Co., Ltd" },
    {  5566, "VisionGlobal Network Corporation" },
    {  5567, "Riverstone Networks" },
    {  5568, "Southview Technologies, Inc." },
    {  5569, "Soluzioni Tecnologiche Bancarie s.r.l." },
    {  5570, "Sony Pictures Entertainment" },
    {  5571, "GetThere.Com" },
    {  5572, "HoTek TechnologyCo., Ltd." },
    {  5573, "Tong" },
    {  5574, "BankEngine Inc." },
    {  5575, "CertEngine Inc." },
    {  5576, "T.I.L.L. Photonics GmbHAnselm Kruis" },
    {  5577, "Persimmon Development" },
    {  5578, "New Mexico State University" },
    {  5579, "Mercata, Inc." },
    {  5580, "EXEJone" },
    {  5581, "Communications Networks of Africa (GH) Ltd (NETAFRICA)" },
    {  5582, "iTRUST Solutions AG" },
    {  5583, "MD Information Systems" },
    {  5584, "General Bandwidth" },
    {  5585, "Very Clever Software Ltd." },
    {  5586, "IPWireless Inc." },
    {  5587, "Flughafen Muenchen GmbH" },
    {  5588, "Thomcast Communication, Inc.Comwave Division (\"Comwave\")" },
    {  5589, "Synopsys, Inc." },
    {  5590, "Marimba Inc." },
    {  5591, "SCTE" },
    {  5592, "Wilson & Sanders, Inc." },
    {  5593, "Magnum Technologies Inc." },
    {  5594, "Koankeiso Co., Ltd." },
    {  5595, "Ingrian Systems, Inc" },
    {  5596, "Tandberg ASA" },
    {  5597, "Meinberg Funkuhren" },
    {  5598, "Submarine Warfare Systems Centre" },
    {  5599, "Comp Sci & Eng, 'De Montfort University'" },
    {  5600, "Clearstream Services" },
    {  5601, "Clearstream Banking" },
    {  5602, "T/R Systems, Inc." },
    {  5603, "Capital One Financial Services" },
    {  5604, "digit-safe" },
    {  5605, "William Data Systems Ltd." },
    {  5606, "Cerplus SAPierre" },
    {  5607, "Erwann ABALEA" },
    {  5608, "Red Planet Technologies" },
    {  5609, "Smartleaf, Inc." },
    {  5610, "Exbit TechnologyA/S" },
    {  5611, "vmunix.org" },
    {  5612, "Korea Data Communications" },
    {  5613, "tdressler.net (formerly 'SQLcompetence')" },
    {  5614, "SonyBPE" },
    {  5615, "Inherit S AB" },
    {  5616, "TEKOPS" },
    {  5617, "Trio Communications 2000 Pty. Ltd" },
    {  5618, "WareNet Inc." },
    {  5619, "Amaranth Networks Inc." },
    {  5620, "CFX Communications" },
    {  5621, "Heriot-Watt University" },
    {  5622, "DreGIS GmbH" },
    {  5623, "KPMG" },
    {  5624, "Enterasys Networks" },
    {  5625, "A. Gell, CxA" },
    {  5626, "Internet Barter Inc.aka Bartertrust.com" },
    {  5627, "Hitachi Process Computer Engineering, Inc." },
    {  5628, "X.O. Soft, Ltd" },
    {  5629, "Continuus Software Corporation" },
    {  5630, "ExiO Communications Inc." },
    {  5631, "Alliance Systems, Inc." },
    {  5632, "TelePassport Hellas S.A." },
    {  5633, "BASF Computer Services GmbH" },
    {  5634, "Universiteit van Amsterdam" },
    {  5635, "Dale W. Liu" },
    {  5636, "Dignos EDV GmbH" },
    {  5637, "IDN Technology Inc." },
    {  5638, "PK Electronics" },
    {  5639, "Dept. Of Biology Western KY University" },
    {  5640, "Lama Law Firm" },
    {  5641, "Anthem Inc." },
    {  5642, "MicroCast, Inc." },
    {  5643, "University of Arizona" },
    {  5644, "PassEdge" },
    {  5645, "BowStreet Software" },
    {  5646, "Onyx Networks" },
    {  5647, "Emperative, Inc." },
    {  5648, "L-3  Communications (PrimeWave Communications)" },
    {  5649, "Webswap Inc." },
    {  5650, "Merck & Co., Inc." },
    {  5651, "Maipu Electric Industrial Co., Ltd" },
    {  5652, "Kraig Sigman" },
    {  5653, "CSP" },
    {  5654, "Ando Electric Corporation" },
    {  5655, "P-Cube Ltd." },
    {  5656, "Monmouth University" },
    {  5657, "Universidad de La Coruna" },
    {  5658, "ISL, Institute of Shipping Economics and Logistics" },
    {  5659, "CoProSys Inc." },
    {  5660, "XI'AN DATANG TELEPHONE Corp." },
    {  5661, "T-Mobile" },
    {  5662, "Nordic Global Inc." },
    {  5663, "TecnoLogica Informatica" },
    {  5664, "Monastery of the Glorious Ascension, Inc." },
    {  5665, "Vertical One, Inc." },
    {  5666, "Servevcast" },
    {  5667, "Teldata Computer Industries, Inc." },
    {  5668, "Mycroft Inc." },
    {  5669, "Digital Island" },
    {  5670, "Redwood Technologies Ltd." },
    {  5671, "Horus IT GmbH" },
    {  5672, "CIENA Corporation (formerly 'ONI Systems Corp.')" },
    {  5673, "eConvergent, Inc." },
    {  5674, "Texcel Technology Plc." },
    {  5675, "Genosys Technology Management Inc." },
    {  5676, "DataFlow/Alaska, Inc." },
    {  5677, "Clunix, Inc." },
    {  5678, "Stalker Software, Inc" },
    {  5679, "EWE & EVE's Gourds & Things" },
    {  5680, "Windsor Group" },
    {  5681, "fruittm" },
    {  5682, "Synergon Ltd." },
    {  5683, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5684, "Metro Optix, Inc." },
    {  5685, "DataLink SNMP Solution" },
    {  5686, "A H Computer Company" },
    {  5687, "Icon Laboratories, Inc." },
    {  5688, "StrataSource, Inc." },
    {  5689, "Net & Sys Co., Ltd" },
    {  5690, "Agri-Com Holdings" },
    {  5691, "SilverPlatter Information" },
    {  5692, "Kilfoil Information Technologies, Inc." },
    {  5693, "Accordion Networks" },
    {  5694, "Integrated Digital Solutions Limited" },
    {  5695, "bbq.com" },
    {  5696, "Walter Graphtek GmbH" },
    {  5697, "HanseNetTelefongesellschaft mbH" },
    {  5698, "Digitrans" },
    {  5699, "Cornerstone Solutions Corporation" },
    {  5700, "University of the West Indies" },
    {  5701, "Maple Networks, Inc." },
    {  5702, "Touch Technology International" },
    {  5703, "NVIDIA Corporation" },
    {  5704, "CITGO Petroleum Corporation" },
    {  5705, "DTA" },
    {  5706, "LGS Group Inc." },
    {  5707, "Fiberspace Unlimited, LLC" },
    {  5708, "CTS Network Services" },
    {  5709, "EDS/CFSM" },
    {  5710, "Wellknit" },
    {  5711, "ECCS, Inc." },
    {  5712, "System Integrators, Incorporated" },
    {  5713, "Niksun Inc." },
    {  5714, "Insh_Allah" },
    {  5715, "Enigma Enterprises" },
    {  5716, "WebSpectrum Software Pvt. Ltd." },
    {  5717, "UUcom" },
    {  5718, "Cellit, Inc." },
    {  5719, "PNC Financial Services Group" },
    {  5720, "iMimic Networking, Inc." },
    {  5721, "IntellOps" },
    {  5722, "OPNET Technologies, Inc  (formerly 'Altaworks  Corporation')" },
    {  5723, "SAMAC Software GmbH" },
    {  5724, "Cicero Communications, Inc." },
    {  5725, "Xel Communications" },
    {  5726, "Lyondell Chemical Company" },
    {  5727, "Smart Card Applications Pty Limited" },
    {  5728, "K Ring Technologies" },
    {  5729, "SQLI" },
    {  5730, "Simpson Professional Services" },
    {  5731, "DJM Enterprises" },
    {  5732, "One, Inc - Plano" },
    {  5733, "Dept.3,ISCAS(Institute of Software, the Chinese Academyof Sciences" },
    {  5734, "FABRICA NACIONAL DE MONEDA Y TIMBRE - REAL CASA DE LA MONEDA" },
    {  5735, "EBSnet Inc." },
    {  5736, "Power Conversion Products, LLC" },
    {  5737, "E-Commerce Enterprises, LLC" },
    {  5738, "Vovida Networks" },
    {  5739, "Xpeed, Inc." },
    {  5740, "Birionic Pvt Ltd" },
    {  5741, "a2zcom" },
    {  5742, "S.S.C. 'HENGELO'" },
    {  5743, "GT Group Telecom Services Corp." },
    {  5744, "TARSEC Inc." },
    {  5745, "Ericsson Nikola Tesla d.d." },
    {  5746, "Lanex Sp. z o.o." },
    {  5747, "Bluetail AB" },
    {  5748, "Applied Expert Systems" },
    {  5749, "TGS-NOPEC Geophysical Company" },
    {  5750, "General Mills" },
    {  5751, "Illumination Enterprises, Inc." },
    {  5752, "HyperSoft, Inc." },
    {  5753, "University of Maribor" },
    {  5754, "Clearstream International" },
    {  5755, "ITS (UK) Ltd." },
    {  5756, "Supertel , JSC" },
    {  5757, "Trilithic" },
    {  5758, "Stins Coman" },
    {  5759, "bridges.com" },
    {  5760, "Bell Atlantic Mobile" },
    {  5761, "Hannetware Inc." },
    {  5762, "Interland" },
    {  5763, "DB POWER ELECTRONICS (P) Ltd." },
    {  5764, "Jazzey GmbH" },
    {  5765, "aXess-pro networks GmbH" },
    {  5766, "IBM Global Services" },
    {  5767, "Quark, Inc." },
    {  5768, "Polish-Japanese Institute of Information Technology" },
    {  5769, "HealthMagic, Inc." },
    {  5770, "Medepass.com, Inc." },
    {  5771, "Cisco Systems, Inc." },
    {  5772, "C-it" },
    {  5773, "Equiinet Ltd." },
    {  5774, "Beijing Telecable Network System Ltd." },
    {  5775, "Advanced Technology Solutions International" },
    {  5776, "Express Scripts, Inc." },
    {  5777, sminmpec_unknown },  /* (Added by Wireshark) */
    {  5778, "Universidad Autonoma de Madrid" },
    {  5779, "Data-GUYS Inc." },
    {  5780, "PDA Verticals Corp." },
    {  5781, "Jordan Network Engineering" },
    {  5782, "University of Wisconsin System" },
    {  5783, "BROADPAC Communications" },
    {  5784, "Cogita Ltd" },
    {  5785, "Intershop Communications AG" },
    {  5786, "Mc Coy Marine Consultants" },
    {  5787, "Adventist Health" },
    {  5788, "Softdev Corp." },
    {  5789, "MobileQ.com Inc." },
    {  5790, "Shawn Starr" },
    {  5791, "Compu-Mentor, Inc." },
    {  5792, "Dean Gakis" },
    {  5793, "The Edge Consultants" },
    {  5794, "OBR CTM" },
    {  5795, "BPT TELBANK SA" },
    {  5796, "STC Informatik" },
    {  5797, "Western Power Distribution" },
    {  5798, "VIACCESS S.A." },
    {  5799, "Nyherji" },
    {  5800, "Cruise Controls Pvt. Ltd.- FRESNEL" },
    {  5801, "Second Opinion Software" },
    {  5802, "Electroline Equipment Inc." },
    {  5803, "2AB, Inc." },
    {  5804, "Lantern Communications" },
    {  5805, "Televideo, Inc." },
    {  5806, "SK Telecom" },
    {  5807, "Flora van Kesteren Tuinadviezen" },
    {  5808, "INRANGE Technologies Corporation" },
    {  5809, "Nieden-Nsm" },
    {  5810, "Global Crossing" },
    {  5811, "The GoldParrot Corporation" },
    {  5812, "Coriolis Networks" },
    {  5813, "The OpenNMS Group, Inc." },
    {  5814, "General Communications Inc." },
    {  5815, "Optima Tele.com, Inc." },
    {  5816, "Lockstep Systems" },
    {  5817, "High Precision Record Company Limited" },
    {  5818, "Cherry Cyber Net" },
    {  5819, "X.Net Ltda" },
    {  5820, "Flyforms" },
    {  5821, "Orangesoft, Inc." },
    {  5822, "Reynolds and Reynolds Pty Ltd" },
    {  5823, "nRose" },
    {  5824, "Nikkai Electronic, Inc." },
    {  5825, "Native Networks" },
    {  5826, "MIND CTI Ltd." },
    {  5827, "HERMES SoftLab" },
    {  5828, "SpaceNet Communication AB" },
    {  5829, "AMCC Switching Corp." },
    {  5830, "XcelleNet" },
    {  5831, "Cleondris GmbH" },
    {  5832, "Horgan.net" },
    {  5833, "Tailyn Communication Company" },
    {  5834, "Identikey ltd" },
    {  5835, "Newtec Cy" },
    {  5836, "TOYO COMMUNICATION EQUIPMENT CO., LTD" },
    {  5837, "Nedcor Limited" },
    {  5838, "Cabletime Ltd" },
    {  5839, "Bioplasma Andaluza S.L." },
    {  5840, "Aravox Technologies, Inc." },
    {  5841, "Netfish Technologies" },
    {  5842, "Cisco Systems" },
    {  5843, "FiberLogic Communications" },
    {  5844, "LG Space Engineering Corp" },
    {  5845, "Cyberus Online Inc." },
    {  5846, "NetCentrex" },
    {  5847, "Knowledge Design" },
    {  5848, "Rissa Solutions Corp." },
    {  5849, "Signal-COM" },
    {  5850, "H.S. Leader Srl" },
    {  5851, "eWindowShop.com" },
    {  5852, "Oscar Jacobsson" },
    {  5853, "Bell Technology" },
    {  5854, "Bell Network Solutions" },
    {  5855, "John Deere (dba Deere & Company)" },
    {  5856, "Vianet Technologies, Inc." },
    {  5857, "VirtualWorkout" },
    {  5858, "Cyclone Commerce, Inc." },
    {  5859, "EFA Software Services Ltd." },
    {  5860, "TeleNet Inc." },
    {  5861, "Mitsubishi Heavy Industries, Ltd" },
    {  5862, "CEYCO Internet Applications" },
    {  5863, "D'ALASKA CO." },
    {  5864, "REITC, LLC" },
    {  5865, "Parallel Networks" },
    {  5866, "London School of Economics Computer Security Research Centre" },
    {  5867, "San Joaquin Delta Community College District" },
    {  5868, "CRONOS Research Centre Sdn Bhd" },
    {  5869, "Deutsche Post eBusiness" },
    {  5870, "BioFone Inc." },
    {  5871, "HyperXS" },
    {  5872, "TDC Systems" },
    {  5873, "Software Dynamics Inc." },
    {  5874, "Tellabs MNG" },
    {  5875, "China Advanced Info-Optical Network (CAINONET)" },
    {  5876, "A2B s.r.o." },
    {  5877, "Ruhr-Universitaet Bochum" },
    {  5878, "NICE GmbH" },
    {  5879, "Unassigned" },
    {  5880, "Opteway" },
    {  5881, "ARZ Allgemeiness Rechenzentrum GmbH" },
    {  5882, "Inopoly Inc." },
    {  5883, "Zaffire, Inc." },
    {  5884, "University of Utah" },
    {  5885, "McGough Enterprises L.L.C." },
    {  5886, "NuSpeed Internet Systems" },
    {  5887, "Falconnect, Inc." },
    {  5888, "Agiliti, Inc." },
    {  5889, "Universidad Iberoamericana GC" },
    {  5890, "Lantop Systems LTD" },
    {  5891, "Autotote Systems, Inc." },
    {  5892, "Legacy Computer Services Limited" },
    {  5893, "PinPoint Corporation" },
    {  5894, "Dreamchal Inc." },
    {  5895, "At Fut AS" },
    {  5896, "csseEvens St. Hilaire" },
    {  5897, "BP Amoco PLC" },
    {  5898, "RITLABS S.R.L." },
    {  5899, "Microm Electronics" },
    {  5900, "Schrader-Bridgeport International" },
    {  5901, "Nominum Inc." },
    {  5902, "Maharajah Infosys" },
    {  5903, "Pace Micro Technology plc" },
    {  5904, "Walgreens" },
    {  5905, "StorageNetworks" },
    {  5906, "Travsys BV" },
    {  5907, "Lokasoft" },
    {  5908, "Otelnet, Inc." },
    {  5909, "Skybitz Inc." },
    {  5910, "Availant" },
    {  5911, "cbrook" },
    {  5912, "Yuasa Corporation" },
    {  5913, "Oliver Fehr" },
    {  5914, "Balsa Software" },
    {  5915, "Trilogic Systems" },
    {  5916, "i-Nebula.com" },
    {  5917, "Gigalink" },
    {  5918, "BBL" },
    {  5919, "Departamento de Informatica da Fac. Ciencias da Univ. Lisboa" },
    {  5920, "Zurich Financial Services Group" },
    {  5921, "Sema Group AB" },
    {  5922, "Real Time Monitors, Inc." },
    {  5923, "Internet2" },
    {  5924, "Xevo Corp." },
    {  5925, "Interactive People Unplugged AB" },
    {  5926, "interlink" },
    {  5927, "NexComm Systems, Inc." },
    {  5928, "Zydacron, Inc." },
    {  5929, "Amer.com" },
    {  5930, "ImagicTV Inc." },
    {  5931, "PRESIDEO, Inc." },
    {  5932, "OpenSystems.com, Inc." },
    {  5933, "Software Services" },
    {  5934, "University of Louisiana at Lafayette" },
    {  5935, "ACADEMIA Sinica Computing Centre" },
    {  5936, "Ahhaaa AB" },
    {  5937, "HypoVereinsbank" },
    {  5938, "Macfarlane TeleSystems Ltd." },
    {  5939, "HALCOM Informatika, d.o.o." },
    {  5940, "Red Lion Controls (JBM Electronics Co., Inc.)" },
    {  5941, "Cosmocom Inc." },
    {  5942, "ThoughtShare Communications" },
    {  5943, "MatchCraft, Inc." },
    {  5944, "nROSE" },
    {  5945, "AtBusiness Communications Oyj" },
    {  5946, "MULTITEL Inc." },
    {  5947, "WebForce LLC" },
    {  5948, "3NO Systems" },
    {  5949, "IBM, AIX Tools Team" },
    {  5950, "Imagineering Inc." },
    {  5951, "Netscaler" },
    {  5952, "Breakaway Solutions, Inc." },
    {  5953, "EleTel Inc." },
    {  5954, "Aaron Telecommunication Technology" },
    {  5955, "ASCONA" },
    {  5956, "Travelport (formerly 'Worldspan')" },
    {  5957, "Essematica S.r.l." },
    {  5958, "KCell" },
    {  5959, "Eastern Communications Co. Ltd." },
    {  5960, "CEFRIEL" },
    {  5961, "Powec AS" },
    {  5962, "David Clunie" },
    {  5963, "RadioScape Ltd." },
    {  5964, "Fenestrae B.V." },
    {  5965, "Cenosis" },
    {  5966, "Hummingbird Ltd." },
    {  5967, "Jane Ellen Shatz, Ph. D." },
    {  5968, "VAMS" },
    {  5969, "Lightspeed Systems" },
    {  5970, "CSIRO" },
    {  5971, "LEAD Technologies, Inc." },
    {  5972, "AirNet Communications Corporation" },
    {  5973, "Rainbow Technologies, Inc." },
    {  5974, "Telecom Technologies, Inc." },
    {  5975, "Telchemy" },
    {  5976, "Red Hill Networks" },
    {  5977, "University of Texas at Dallas (UTD)" },
    {  5978, "California State University Northridge" },
    {  5979, "CSCare Inc." },
    {  5980, "CSSoftware Inc." },
    {  5981, "media transfer AG" },
    {  5982, "Infor" },
    {  5983, "Descartes Systems Group Inc." },
    {  5984, "Cedere Corporation" },
    {  5985, "BioCor, L.L.C." },
    {  5986, "Vpacket Communications, Inc." },
    {  5987, "Pacific Broadband Communications" },
    {  5988, "esutel" },
    {  5989, "Go.com" },
    {  5990, "INFORMZASCHITA" },
    {  5991, "Ntown Communications, Inc." },
    {  5992, "ePower Solutions, Inc." },
    {  5993, "Terabeam Networks" },
    {  5994, "Arcom Control Systems" },
    {  5995, "Everypath Inc." },
    {  5996, "Communication Weaver Co., Ltd." },
    {  5997, "TeamTronic p.s.c.r.l." },
    {  5998, "CITI-DIC IT CO., LTD" },
    {  5999, "SCITEL Industrieberatungs-GmbH" },
    {  6000, "CES Computer Solutions Inc." },
    {  6001, "Memorial Sloan-Kettering Cancer Center" },
    {  6002, "Impresse Corporation" },
    {  6003, "Jasmine Networks, Inc." },
    {  6004, "SYSMATE Co., Ltd." },
    {  6005, "City of Sydney" },
    {  6006, "The Schleutker Sites" },
    {  6007, "Redux Communications Ltd." },
    {  6008, "Lynxus, Inc." },
    {  6009, "gcs Global Communication & Services GmbH" },
    {  6010, "SERVICECO" },
    {  6011, "Cinta Corporation" },
    {  6012, "PiNGPoNG.CoM" },
    {  6013, "Tieturi" },
    {  6014, "National Library of Medicine" },
    {  6015, "Chicago Board Options Exchange" },
    {  6016, "Technauts" },
    {  6017, "G2X Software" },
    {  6018, "Excel Medical Electronics Inc." },
    {  6019, "Simplified Telesys, Inc." },
    {  6020, "Lutris Technologies" },
    {  6021, "Arcadian Wireless" },
    {  6022, "DFKI GmbH" },
    {  6023, "Steele Raymond Solicitors" },
    {  6024, "Scannex Electronics Ltd." },
    {  6025, "Advanced Network Solutions S.p.A." },
    {  6026, "U.S. Army STRICOM" },
    {  6027, "Force10 Networks, Inc." },
    {  6028, "ODSI Coalition" },
    {  6029, "Exactis.com" },
    {  6030, "Fluke Electronics" },
    {  6031, "Computer Problem Solving" },
    {  6032, "Stainless Steel Networks" },
    {  6033, "e-talk Corporation" },
    {  6034, "BroadJump" },
    {  6035, "Sensis Corporation" },
    {  6036, "Bose Corporation" },
    {  6037, "Edge Networks Corp." },
    {  6038, "Netwhistle.com" },
    {  6039, "Resscom Computers and Communications" },
    {  6040, "University of Kalmar" },
    {  6041, "Kokua Communications" },
    {  6042, "Southeastern Aluminum Products, Inc." },
    {  6043, "AstroTerra Corporation" },
    {  6044, "Poyntz, Inc." },
    {  6045, "Synaptique Information & Technologie" },
    {  6046, "Near2 Communications, Inc." },
    {  6047, "Florida Teaching Profession - NEA" },
    {  6048, "Exyst" },
    {  6049, "Hitachi Information Systems, Ltd." },
    {  6050, "GAMATRONIC ELECTRONIC INDUSTRIES LTD" },
    {  6051, "Ameritrade" },
    {  6052, "Novasonics" },
    {  6053, "Eredyne Corporation" },
    {  6054, "Access360" },
    {  6055, "Lees Communication" },
    {  6056, "Rensselaer Polytechnic Institute" },
    {  6057, "AppNet" },
    {  6058, "Havas Interactive" },
    {  6059, "AdNovum Informatik AG" },
    {  6060, "ISP Systems Pty. Ltd." },
    {  6061, "Netuitive, Inc." },
    {  6062, "TEKELEC TEMEX" },
    {  6063, "Axent Technologies, Inc.(Utah)" },
    {  6064, "JK microsystems" },
    {  6065, "ZUniversity.com" },
    {  6066, "Occam Networks, Inc." },
    {  6067, "Adapcom, Inc." },
    {  6068, "kc. marching" },
    {  6069, "BlocWare, Inc." },
    {  6070, "AVIV INFOCOM CO.," },
    {  6071, "SIGMA Informatique" },
    {  6072, "Plan Software GmbH" },
    {  6073, "Business Global Systems" },
    {  6074, "Cenosis, Inc." },
    {  6075, "Siemens AG" },
    {  6076, "TrelliSoft, Inc." },
    {  6077, "Call-Net Technology Services Inc." },
    {  6078, "CyberIntelligent Technologies" },
    {  6079, "appoconnect.com" },
    {  6080, "BridgeWave Communications" },
    {  6081, "Nexsi" },
    {  6082, "AReS" },
    {  6083, "AATR" },
    {  6084, "PRISMedia Networks, Inc." },
    {  6085, "Hypergene AB" },
    {  6086, "New York Life Insurance Co." },
    {  6087, "Mentat Inc." },
    {  6088, "opNIX, Inc." },
    {  6089, "LastMile" },
    {  6090, "DespatchBox" },
    {  6091, "epki" },
    {  6092, "Agillion Corporation" },
    {  6093, "TESSAG AG" },
    {  6094, "Wapcom" },
    {  6095, "KHALED FAHMI" },
    {  6096, "Netsecure Software" },
    {  6097, "State of Michigan" },
    {  6098, "AvantGo" },
    {  6099, "INTELLIDEN, Incorporated" },
    {  6100, "Covalent Technologies, Inc." },
    {  6101, "Trend Micro Inc." },
    {  6102, "Integrated Research Ltd." },
    {  6103, "Al Rasheed" },
    {  6104, "Cosmobridge Co., Ltd." },
    {  6105, "Center Vlade za Informatiko" },
    {  6106, "Maharaja Infosys Limited" },
    {  6107, "IDN Telecom, Inc." },
    {  6108, "Insurance Auto Auctions" },
    {  6109, "ADIC" },
    {  6110, "Atrica" },
    {  6111, "Worldsport Networks Ltd." },
    {  6112, "XINETRON CO., LTD" },
    {  6113, "Datek Telecom S.A." },
    {  6114, "ProSyst Software AG" },
    {  6115, "Open Interactive Limited" },
    {  6116, "Medtegrity, Inc." },
    {  6117, "Fiber Network Engineering" },
    {  6118, "Quintiles" },
    {  6119, "IPWorks, Inc." },
    {  6120, "NXTV" },
    {  6121, "Excite@Home E-Business Services" },
    {  6122, "Mover S.p.A." },
    {  6123, "National Institute of Telecommunications" },
    {  6124, "Sane Solutions, LLC" },
    {  6125, "ACERFI-MICRONICSFrancois Regis K." },
    {  6126, "epicRealm" },
    {  6127, "LapLink.com" },
    {  6128, "Wireless Planet" },
    {  6129, "Bromax Communication Inc.," },
    {  6130, "CVI" },
    {  6131, "Starmedia Mobile" },
    {  6132, "LVL7 Systems, Inc." },
    {  6133, "Dead Fish Technologies" },
    {  6134, "Trioniq" },
    {  6135, "Chubu Telecommunications Co., Inc." },
    {  6136, "idealhost.com" },
    {  6137, "University of Canterbury" },
    {  6138, "Trasys" },
    {  6139, "Healthcare Specialists, Inc." },
    {  6140, "Enikia Incorporated" },
    {  6141, "World Wide Packets" },
    {  6142, "TF1" },
    {  6143, "Eventlogic" },
    {  6144, "SUNTECH Sp. zo.o" },
    {  6145, "Cendio Systems AB" },
    {  6146, "Whirlpool Corporation" },
    {  6147, "Alliegiance Telecom" },
    {  6148, "Cidera, Inc." },
    {  6149, "London School of Economics" },
    {  6150, "Open Networks Engineering Ltd." },
    {  6151, "Copyprint S.L." },
    {  6152, "Sendmail, Inc." },
    {  6153, "JOLT Ltd." },
    {  6154, "Soneris Engineering" },
    {  6155, "FIREBIT Ltd." },
    {  6156, "TTC TESLA TELEKOMUNIKACE, Ltd." },
    {  6157, "ICCRI BANCA FEDERALE EUROPEA SPA" },
    {  6158, "NAGUS" },
    {  6159, "University of Iowa" },
    {  6160, "Affinity Technology Group" },
    {  6161, "OnFiber Communications, Inc." },
    {  6162, "Solid Data Systems" },
    {  6163, "Inara Networks, Inc." },
    {  6164, "Kinva Network System Ltd." },
    {  6165, "Portwell Inc." },
    {  6166, "Interactive Enterprise" },
    {  6167, "SPHINX" },
    {  6168, "Banco do Brasil S/A" },
    {  6169, "Serendipity Simplex" },
    {  6170, "PartMiner, Inc." },
    {  6171, "Kidata AG" },
    {  6172, "Worldwide Entrepreneuric Enterprises, Inc." },
    {  6173, "Fisher & Paykel Industries Limited" },
    {  6174, "Fusionx" },
    {  6175, "Pines of Woodedge" },
    {  6176, "VIPCom" },
    {  6177, "Blitz Information Technologies Berhad" },
    {  6178, "NTT Advanced Technology Corporation" },
    {  6179, "R.M. EDIZIONI SRL" },
    {  6180, "CanDo.com" },
    {  6181, "Creative Logic Corporation" },
    {  6182, "Encore Electronics Inc." },
    {  6183, "Sharemedia" },
    {  6184, "Mitsui & Co., Ltd." },
    {  6185, "Ghent University" },
    {  6186, "Space CyberLink Inc." },
    {  6187, "Dartmouth-Hitchcock Medical Center" },
    {  6188, "University of Massachusetts Lowell" },
    {  6189, "Atos Information Technology GmbH - Trustcenter" },
    {  6190, "Network365 Ltd" },
    {  6191, "Plasmon, Inc." },
    {  6192, "Environmental Monitoring Solutions" },
    {  6193, "CPL Systems Ltd." },
    {  6194, "NetCalibrate Inc." },
    {  6195, "Advanced Communication Research" },
    {  6196, "Atlantec Enterprise Solutions GmbH" },
    {  6197, "Arcordia/JP Morgan Chase" },
    {  6198, "Eastern Nazarene College" },
    {  6199, "Nyherji hf" },
    {  6200, "DNPG" },
    {  6201, "Asenti, Inc." },
    {  6202, "Nimble, Inc." },
    {  6203, "Topspin Networks" },
    {  6204, "SIBS - Sociedade Interbancaria de Servicos, S.A." },
    {  6205, "LKC-Technology" },
    {  6206, "eCritical Inc." },
    {  6207, "The Polished Group SA" },
    {  6208, "Enterprise Internet Services Limited" },
    {  6209, "The Open University" },
    {  6210, "Mayah Communications GmbH" },
    {  6211, "Murex" },
    {  6212, "XM Satellite Radio, Inc." },
    {  6213, "Redline Networks, Inc." },
    {  6214, "SureFire Commerce Inc." },
    {  6215, "Streaming21, Inc." },
    {  6216, "Ci Technologies" },
    {  6217, "ngkindsoftltd" },
    {  6218, "SCAN COIN" },
    {  6219, "Iskra SYSEN d.d." },
    {  6220, "Cyber Internet Services" },
    {  6221, "BAE Systems, CNIR" },
    {  6222, "STSN, Inc." },
    {  6223, "CDS Technologies" },
    {  6224, "Roxy.com" },
    {  6225, "Broadcast Towers" },
    {  6226, "BARIELD'S INTERNET PROVIDER SERVICE" },
    {  6227, "Resolve Engineering Pty Ltd" },
    {  6228, "Engineering Center for Information Security,Chinese Acadamy of Sciences" },
    {  6229, "Tango/04 Computing Group" },
    {  6230, "SITE Skunkworks" },
    {  6231, "Fiduciary Automation" },
    {  6232, "Corinex Global Corp." },
    {  6233, "UUNET EMEA" },
    {  6234, "Paul Abrahams, Sc.D." },
    {  6235, "nawilson.com" },
    {  6236, "Crayfish Co.,Ltd." },
    {  6237, "NetAge Solutions GmbH Netzwerkl\0303\0266sungen" },
    {  6238, "Queen Mary, University of London" },
    {  6239, "TechnoTrend AG" },
    {  6240, "Bryttan, Ltd." },
    {  6241, "Calvin College" },
    {  6242, "Possm Technologies" },
    {  6243, "Weber Enterprise" },
    {  6244, "PDR/SAGN Publishing" },
    {  6245, "CiRCLEX Limited" },
    {  6246, "Mythological Solutions" },
    {  6247, "Comtech EFData Corporation" },
    {  6248, "Atecs Dematic" },
    {  6249, "HCL Technologies Ltd" },
    {  6250, "PepsiCo Business Solutions Group (PBSG)" },
    {  6251, "Atoga Systems, Inc." },
    {  6252, "SrvLoc.Org" },
    {  6253, "ipSEAL, Inc" },
    {  6254, "TimeVision Inc." },
    {  6255, "Commerce Onc, Inc." },
    {  6256, "Southwest Communications Institute" },
    {  6257, "Disappearing, Inc." },
    {  6258, "Iwatsu Electric Co., Ltd." },
    {  6259, "Sohonet Limited" },
    {  6260, sminmpec_unknown },  /* (Added by Wireshark) */
    {  6261, "MAKU Informationstechnik GmbH" },
    {  6262, "IMC Communications" },
    {  6263, "Avstar Systems, LLC" },
    {  6264, "OpenNetwork Technologies" },
    {  6265, "gocek.com" },
    {  6266, "Everest eCommerce Inc." },
    {  6267, "MUSHTAQ SONS" },
    {  6268, "Evistel" },
    {  6269, "DiGiMATiON" },
    {  6270, "iAsiaWorks" },
    {  6271, "N.S.C." },
    {  6272, "KPNQwest Finland" },
    {  6273, "Weir Consulting Ltd" },
    {  6274, "Drael Computer Corporation" },
    {  6275, "HOB GmbH & Co. KG - HOB Germany" },
    {  6276, "Mahindra British Telecom Limited" },
    {  6277, "Federaci\0303\0263n de Organizaciones Privadas de Desarrollo - FOPRIDEH" },
    {  6278, "Invision.com, Inc" },
    {  6279, "Visible Markets, Inc." },
    {  6280, "Coreon, Inc." },
    {  6281, "Jingle Cats Music" },
    {  6282, "SDC Communications Ltd" },
    {  6283, "City-Net Technology Inc." },
    {  6284, "Wireless Networks, Inc." },
    {  6285, "Crossport Systems" },
    {  6286, "One Tech Telecom Co.,Ltd." },
    {  6287, "Nextenso" },
    {  6288, "Euskaltel S.A." },
    {  6289, "Adapcom Inc." },
    {  6290, "LightSand Communications, Inc." },
    {  6291, "Bates College" },
    {  6292, "Leadership Technologies, Inc." },
    {  6293, "Kasenna, Inc." },
    {  6294, "Active Telco" },
    {  6295, "Wilhoyt Industries" },
    {  6296, "DASAN Co.,LTD." },
    {  6297, "Enel.it" },
    {  6298, "MP3.com" },
    {  6299, "SUNY Cortland" },
    {  6300, "Karl Miller" },
    {  6301, "Packet Dynamics Ltd" },
    {  6302, "Emerson Energy Systems" },
    {  6303, "Cityspace Ltd" },
    {  6304, "fogcity" },
    {  6305, "Flextronics International" },
    {  6306, "Dartware, LLC" },
    {  6307, "Ipanema Technologies" },
    {  6308, "cholul" },
    {  6309, "Dan Nielsen Consulting" },
    {  6310, "KaanBaan Technologies" },
    {  6311, "Gomez Advisors, Inc." },
    {  6312, "Pelican Security, Inc." },
    {  6313, "InnovaCom, Inc." },
    {  6314, "VillaMontage Systems" },
    {  6315, "Comiss\0303\0243o para Coordena\0303\0247\0303\0243o do Projeto SIVAM" },
    {  6316, "Bill Fenner" },
    {  6317, "Netfox" },
    {  6318, "lesswire AG" },
    {  6319, "Caldera Systems, Inc." },
    {  6320, "simonstl.com" },
    {  6321, "Calix Networks" },
    {  6322, "Entone Technologies Ltd." },
    {  6323, "NewCross Technologies, Inc" },
    {  6324, "CoolAlerts, Inc." },
    {  6325, "Harmonix Corporation" },
    {  6326, "LongBoard, Inc." },
    {  6327, "Drews TC" },
    {  6328, "WizWise Technology" },
    {  6329, "Internet Business Factory" },
    {  6330, "Microdot Computing Services" },
    {  6331, "Optimation New Zealand Limited" },
    {  6332, "Four Seasons Produce, Inc." },
    {  6333, "Accord Networks Ltd." },
    {  6334, "beTRUSTed" },
    {  6335, "Adroit Controls" },
    {  6336, "Digital Fountain" },
    {  6337, "Crytaliz, Inc." },
    {  6338, "Sportshuddle.Com" },
    {  6339, "Digital China (Shanghai) Networks Ltd." },
    {  6340, "Otto Kind" },
    {  6341, "Harvard University" },
    {  6342, "Hyperchip, Inc." },
    {  6343, "YMCA England" },
    {  6344, "Hunter Technology Inc." },
    {  6345, "Compuprint S.P.A" },
    {  6346, "DIMAT, S.A." },
    {  6347, "Sierra Monitor Corporation" },
    {  6348, "Liquid Digital Information Systems" },
    {  6349, "Treeblossom Technologies" },
    {  6350, "Blue Cross Blue Shield of Michigan" },
    {  6351, "Shawn Systems, Inc." },
    {  6352, "Ciena Corporation (formerly 'Catena Networks')" },
    {  6353, "Avisto SA" },
    {  6354, "Telways Communication Co.,Ltd." },
    {  6355, "Sipher Internet Tachnology" },
    {  6356, "Innovative Software AG" },
    {  6357, "B2 Systems, Inc." },
    {  6358, "Unimark, Inc." },
    {  6359, "Cyveillance Inc." },
    {  6360, "LiveVault Corporation" },
    {  6361, "Siemens Building Technologies Ltd" },
    {  6362, "Baumann Technologie" },
    {  6363, "CyberSolutions GmbH" },
    {  6364, "Andr\0303\0251a Informatique" },
    {  6365, "Novamedia Sistemas S.L." },
    {  6366, "KOREA LINK" },
    {  6367, "Linkabit - A Titan Systems Company" },
    {  6368, "Schmid Telecom AG" },
    {  6369, "Lexi-Comp, Inc." },
    {  6370, "First USA Bank" },
    {  6371, "Minerva Networks Inc" },
    {  6372, "Kresa Ranch" },
    {  6373, "4DL Inc." },
    {  6374, "CECI" },
    {  6375, "CHINA ENGINEERING CONSULTANTS,INC." },
    {  6376, "PDVSA" },
    {  6377, "OpenPages, Inc." },
    {  6378, "Lanit" },
    {  6379, "Servgate Technologies Canada Inc." },
    {  6380, "Isdnet" },
    {  6381, "burst.com" },
    {  6382, "SAGA Software, Incorporated" },
    {  6383, "OC" },
    {  6384, "V&S Multimedia S.A." },
    {  6385, "Pfizer" },
    {  6386, "Saturn Technologies" },
    {  6387, "Big Band Networks, Ltd" },
    {  6388, "TeleRelay" },
    {  6389, "COM DEV International" },
    {  6390, "DBCORP Information Systems Inc." },
    {  6391, "Xtremesoft Inc." },
    {  6392, "Chiaro Networks Ltd." },
    {  6393, "Haliplex Pty Ltd" },
    {  6394, "Skelton Consulting GmbH" },
    {  6395, "ProSaldo Software B.V." },
    {  6396, "Absolute Website Solutions" },
    {  6397, "Nayna Networks, Inc." },
    {  6398, "Lindner & Pelc Consult GmbH" },
    {  6399, "Intelligent Maintenance Systems Ltd (formerly 'Edrich Integration')" },
    {  6400, "Millenux GmbH" },
    {  6401, "JTI OF GEORGIA" },
    {  6402, "OPTEL Ges. f\0303\0274r Lasertechnik und Elektronik mbH" },
    {  6403, "Universidad Blas Pascal" },
    {  6404, "ECRESO (formerly 'Ecreso RFTS Broadcast')" },
    {  6405, "Activ Australia" },
    {  6406, "Neomar" },
    {  6407, "bit-Services GmbH" },
    {  6408, "Mikom GmbH" },
    {  6409, "Mondial Assistance Limited" },
    {  6410, "Zoneworx, Inc." },
    {  6411, "Overland Storage, Inc.  (formerly 'Quantum Corp - Snap Division')" },
    {  6412, "HiddenMind Technology" },
    {  6413, "I.S. Associates, Inc." },
    {  6414, "Embry-Riddle University" },
    {  6415, "Caspian Networks, Inc." },
    {  6416, "SolutionZ Pty Ltd (Australia)" },
    {  6417, "Victorian Automobile Chamber of Commerce" },
    {  6418, "The Templar Corporation" },
    {  6419, "Pro-bel Ltd" },
    {  6420, "IN-MX" },
    {  6421, "H M Customs & Excise" },
    {  6422, "BT" },
    {  6423, "ObjectSpace, Inc." },
    {  6424, "Viawest Internet Services" },
    {  6425, "Branch Systems" },
    {  6426, "e-Appliance Corporation" },
    {  6427, "Locus Dialogue" },
    {  6428, "T-Online International AG" },
    {  6429, "ALTO" },
    {  6430, "Ericsson Consulting GmbH" },
    {  6431, "BroadSoft, Inc." },
    {  6432, "Orblynx, Inc." },
    {  6433, "Excel.Net, Inc." },
    {  6434, "WebMD" },
    {  6435, "Holistix, Inc." },
    {  6436, "Wapme Systems AG" },
    {  6437, "Kathrein Werke K.G." },
    {  6438, "MKNET ADVIES" },
    {  6439, "NexTReT s.l." },
    {  6440, "TradeCast, Ltd." },
    {  6441, "i2 Technologies, Inc." },
    {  6442, "TWCT dba Daughters and Dad" },
    {  6443, "Out of our minds." },
    {  6444, "Gearhead Group" },
    {  6445, "Sportsplanet2000" },
    {  6446, "Gaton Technologies LTD" },
    {  6447, "Synaxia Networks" },
    {  6448, "DigiVision Tech." },
    {  6449, "Comodo CA Ltd" },
    {  6450, "Idsec Limited" },
    {  6451, "Mystical Creations" },
    {  6452, "Advanced Network Solutions, Inc" },
    {  6453, "CORE COMMUNICATIONS CO., Ltd." },
    {  6454, "Postel Services" },
    {  6455, "Technology Thesaurus Corp." },
    {  6456, "NETdefence Co. Limited" },
    {  6457, "Eureka Soft" },
    {  6458, "GPr Sistemas Ltda" },
    {  6459, "Linfield College" },
    {  6460, "uclick" },
    {  6461, "Center for Internet Research" },
    {  6462, "freiheit.com" },
    {  6463, "VocalData, Inc" },
    {  6464, "Stevens Institute of Technology OIT" },
    {  6465, "Cacheon, Inc." },
    {  6466, "The Devil You Say" },
    {  6467, "Land Of Linking" },
    {  6468, "Patent Off" },
    {  6469, "Karma Kahn" },
    {  6470, "We're no dummies" },
    {  6471, "Con Temporaries" },
    {  6472, "Antiballistic" },
    {  6473, "Halls Of Ivy" },
    {  6474, "Wiffenpoof" },
    {  6475, "Home Is The Hunter" },
    {  6476, "The Craft of Elves" },
    {  6477, "I Was Misinformed" },
    {  6478, "Shot To Shingles" },
    {  6479, "Right-hand Twist" },
    {  6480, "Solomon Tech. Corp." },
    {  6481, "MAGISTRAL, Ltd." },
    {  6482, "ICSynergy" },
    {  6483, "Captus Networks" },
    {  6484, "Campus Crusade for Christ, Inc." },
    {  6485, "Spatial Technologies" },
    {  6486, "Alcatel-Lucent Enterprise (previous was 'Alcatel')" },
    {  6487, "YouSync" },
    {  6488, "TalentStorm Enterprises" },
    {  6489, "Siemens Cerberus" },
    {  6490, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
    {  6491, "Cytek Media Systems, Inc." },
    {  6492, "Phyve" },
    {  6493, "COMTRUST" },
    {  6494, "Kraft und Partner GmbH" },
    {  6495, "SeeDragon Software" },
    {  6496, "Cottons Car Superstore" },
    {  6497, "NetEye Solutions" },
    {  6498, "Maintenance One" },
    {  6499, "ekit.com Pty Ltd" },
    {  6500, "VA Linux Systems" },
    {  6501, "Macro 4" },
    {  6502, "refat" },
    {  6503, "NETGEM" },
    {  6504, "Navini Networks" },
    {  6505, "TARGUSinfo" },
    {  6506, "LiveWire Communications, Inc." },
    {  6507, "OptiMight Communications Inc." },
    {  6508, "Shanghai DigiVision Technology Co.,Ltd" },
    {  6509, "Antrim Studios and Software Cellar" },
    {  6510, "Pioneer Corporation" },
    {  6511, "TelCom Technology" },
    {  6512, "FamTek Professional Services, Inc." },
    {  6513, "Whale Communications" },
    {  6514, "Innovative Systems, L.L.C." },
    {  6515, "Zvolve Systems, Inc." },
    {  6516, "Comprehensive Test Ban Treaty Organization" },
    {  6517, "FlowServer" },
    {  6518, "Systems Solutions of the Southern Tier, Inc." },
    {  6519, "Sabre Inc./ Sabre BTS" },
    {  6520, "Dot Hill Systems" },
    {  6521, "ChainLink Technologies" },
    {  6522, "cv cryptovision GmbH" },
    {  6523, "Bilboko Trading" },
    {  6524, "Greenbytes GmbH" },
    {  6525, "Jasmine Networks, Inc." },
    {  6526, "Windward Consulting Group" },
    {  6527, "Alcatel-Lucent (formerly 'Panthera Networks, Inc.')" },
    {  6528, "Source One" },
    {  6529, "Bundesamt f\0303\0274r Sicherheit in der Informationstechnik" },
    {  6530, "2N spol. s r.o." },
    {  6531, "TeamWork Consulting" },
    {  6532, "Niobrara R&D Corp." },
    {  6533, "FaceTime Communications" },
    {  6534, "hp" },
    {  6535, "TECORE, Inc." },
    {  6536, "NetForensics.com" },
    {  6537, "Brown University" },
    {  6538, "Winford Engineering" },
    {  6539, "EdgeOn Systems, Inc." },
    {  6540, "Alamo Personal Computers, Inc." },
    {  6541, "Transindigo, Inc" },
    {  6542, "Slamdunk Networks" },
    {  6543, "AmBell" },
    {  6544, "Fivesight Technologies" },
    {  6545, "THINK iT" },
    {  6546, "ITOCHU Techno-Solutions Corporation" },
    {  6547, "Network Management Solutions, Inc." },
    {  6548, "Wavelength Digital Limited" },
    {  6549, "Axxcelera Broadband Wireless" },
    {  6550, "weblicon technologies AG" },
    {  6551, "Hotline Communications Ltd." },
    {  6552, "Virbus AG" },
    {  6553, "GHAKO FISHERIES COMPANY LIMITED" },
    {  6554, "Optima Technologies, Inc." },
    {  6555, "DataFoundry.net, Inc." },
    {  6556, "Sigma Networks" },
    {  6557, "dotRocket, Inc" },
    {  6558, "Security Technologies Inc." },
    {  6559, "Usha Communications Technology" },
    {  6560, "TelEnergy H. GmbH" },
    {  6561, "P.S.K. AG" },
    {  6562, "Nexland Inc." },
    {  6563, "TimeBridge Technologies" },
    {  6564, "Gradient Solutions" },
    {  6565, "Johns Hopkins Institutions" },
    {  6566, "Metropolitan Life Insurance" },
    {  6567, "Klimke Industry Consulting" },
    {  6568, "Promptu Systems Corporation (formerly 'AgileTV')" },
    {  6569, "INVENTEC CORPORATION" },
    {  6570, "ACOMZ NETWORKS Corp." },
    {  6571, "Fusion In Tech co.,Ltd." },
    {  6572, "NETLINKS CO.,LTD." },
    {  6573, "PerVigil, Inc." },
    {  6574, "Synology Inc." },
    {  6575, "Marriott International, Inc." },
    {  6576, "Privada, Inc." },
    {  6577, "Indura Corporation" },
    {  6578, "RedWave Networks" },
    {  6579, "Maru Networks, Inc." },
    {  6580, "OSS Systems" },
    {  6581, "Ex\0303\0251rcito Brasileiro" },
    {  6582, "Sigma Services S\0303\0251n\0303\0251gal" },
    {  6583, "Barone, Budge and Dominick" },
    {  6584, "Bundesrechenzentrum GmbH" },
    {  6585, "W-Phone Inc." },
    {  6586, "GeoworksAdam" },
    {  6587, "Airvana Inc." },
    {  6588, "tietoenator" },
    {  6589, "IFA Me\0303\0237-, Regel- und Elektrotechnik GmbH & Co." },
    {  6590, "Keipher Solutions" },
    {  6591, "Haansoft Inc." },
    {  6592, "Darin Vision Co" },
    {  6593, "neoConsulting, LLC" },
    {  6594, "Shijin & Co" },
    {  6595, "SA Mart.com" },
    {  6596, "Julie Julie" },
    {  6597, "MessageHero, Inc." },
    {  6598, "Cybertron Network Solutions" },
    {  6599, "Silver Bow Co.Ltd" },
    {  6600, "International Charities Dep. of Taihe Travel Agency,China" },
    {  6601, "IP Dynamics Inc." },
    {  6602, "Sunrise Telecom Inc." },
    {  6603, "Vitesse Semiconductors" },
    {  6604, "Tosky Management Consulting Co.ltd" },
    {  6605, "Euroclear Operations Centre" },
    {  6606, "Platypus Technology" },
    {  6607, "Radiant Networks Plc" },
    {  6608, "circuLAB" },
    {  6609, "Western New England College" },
    {  6610, "Aditya Systems" },
    {  6611, "SIGMA SERVICES SENEGAL" },
    {  6612, "Juniper Financial Corp." },
    {  6613, "Millimetrix Broadband NetworksLtd." },
    {  6614, "Telecom Technologies Inc." },
    {  6615, "Clairvoyant Software" },
    {  6616, "Lexica, LLC" },
    {  6617, "MicroStrategy" },
    {  6618, "Quintum Technologies, Inc." },
    {  6619, sminmpec_unknown },  /* (Added by Wireshark) */
    {  6620, "Global Telemann System Inc." },
    {  6621, "Department of Foreign Affairs and Trade (Australia)" },
    {  6622, "secondomillennio" },
    {  6623, "servizi2000" },
    {  6624, "Sauro Prosperi" },
    {  6625, "PVT, a.s." },
    {  6626, "Tekotelecom S.p.A." },
    {  6627, "Telematica International B.V." },
    {  6628, "Juaben" },
    {  6629, "ulticom" },
    {  6630, "Accuris Ltd" },
    {  6631, "Bowling Green State University" },
    {  6632, "DST Controls" },
    {  6633, "Personal Genie, Inc." },
    {  6634, "UUNET" },
    {  6635, "Cenus Technologies, Inc." },
    {  6636, "Indiana District - LCMS" },
    {  6637, "Rainbow Computer Warehouse" },
    {  6638, "3Ware Inc" },
    {  6639, "hhl" },
    {  6640, "GMV Network, LLC" },
    {  6641, "Netco Systems Inc." },
    {  6642, "scommtech" },
    {  6643, "IPR Systems Pty Ltd" },
    {  6644, "OzAuthors Pty Ltd" },
    {  6645, "gForce Systems" },
    {  6646, "Chevron" },
    {  6647, "Planet" },
    {  6648, "Intramon Ltd" },
    {  6649, "NewGrid Technology Inc." },
    {  6650, "The Distribution Systems Research Institute" },
    {  6651, "FIREBONE" },
    {  6652, "ID-Karta" },
    {  6653, "Tyan Computer Corporation" },
    {  6654, "Chic Technology Corp." },
    {  6655, "Agenetics Inc" },
    {  6656, "Cauris" },
    {  6657, "Courion Corporation" },
    {  6658, "Koshy's Computer Academy, Edathua" },
    {  6659, "Alisa" },
    {  6660, "keraladotcom" },
    {  6661, "Spike Broadband Systems, Inc." },
    {  6662, "S.E.S.A. AG" },
    {  6663, "Janeva Interactive" },
    {  6664, "Precidia Technologies" },
    {  6665, "Atreus Systems Corp." },
    {  6666, "innovaphone GmbH" },
    {  6667, "mediumrareJulian" },
    {  6668, "To Be Or Not" },
    {  6669, "Videotron ltee" },
    {  6670, "Intelligent Instrumentation" },
    {  6671, "Versonix" },
    {  6672, "Proscend Communications Inc.," },
    {  6673, "Align Systems Pty Ltd" },
    {  6674, "Mercator" },
    {  6675, "News Interactive" },
    {  6676, "Science Dynamics Corporation" },
    {  6677, "ONELINE AG" },
    {  6678, "Hyperknowledge (Europe)" },
    {  6679, "Surgient Networks, Inc." },
    {  6680, "SOUTHPAW" },
    {  6681, "Altea Communications Inc." },
    {  6682, "CommsHouse Ltd" },
    {  6683, "AlphaTrust Corporation" },
    {  6684, "eOriginal Inc." },
    {  6685, "INOVA Diagnostics, Inc." },
    {  6686, "VeCommerce (NZ) Ltd." },
    {  6687, "pAsia Inc." },
    {  6688, "National Center for Software Technology,Ministry of InformationTechnology,Government of India" },
    {  6689, "Zolera Systems, Inc" },
    {  6690, "OmniCluster Technologies, Inc." },
    {  6691, "UTEL" },
    {  6692, "Telenisus Corporation" },
    {  6693, "NetCertainty" },
    {  6694, "P.G.P. s.a." },
    {  6695, "SAMS, Inc." },
    {  6696, "Niagara Mohawk Power Corporation" },
    {  6697, "DOTCOM" },
    {  6698, "Micronet srl" },
    {  6699, "Vulcan Networks" },
    {  6700, "FinGO" },
    {  6701, "Creativ Network Technologies" },
    {  6702, "Entrust CygnaCom" },
    {  6703, "Cognitronics Corporation" },
    {  6704, "Vancouver Language Institute Ltd." },
    {  6705, "Zygox, Inc." },
    {  6706, "NOAA/PMEL/EPIC" },
    {  6707, "Rolf Buurke" },
    {  6708, "Handuru Telecom" },
    {  6709, "Scarlet Telecom BV" },
    {  6710, "South Birmingham College" },
    {  6711, "Connect One" },
    {  6712, "VOXTRONIC Technology" },
    {  6713, "EIZO" },
    {  6714, "Banco Santander Central Hispano" },
    {  6715, "HTT Consulting" },
    {  6716, "AMS Systems" },
    {  6717, "GiantLoop Network, Inc." },
    {  6718, "Exfo Fiber Optic Test Equipment" },
    {  6719, "TransComm Technology System, Inc" },
    {  6720, "PT. Hariff DTE" },
    {  6721, "Lodbroker Pty Ltd" },
    {  6722, "comMATCH Ltd." },
    {  6723, "Internet Names UK" },
    {  6724, "Cap Gemini Telecom France IPNS" },
    {  6725, "Data Interchange Plc" },
    {  6726, "CellPoint Systems" },
    {  6727, "WINIT s.a." },
    {  6728, "Interlink Networks, Inc." },
    {  6729, "Dolby Laboratories, Inc." },
    {  6730, "Nextel Partners Inc." },
    {  6731, "WIT Soundview" },
    {  6732, "Intercim Inc." },
    {  6733, "CMD Technology" },
    {  6734, "WEGO, Inc" },
    {  6735, "Tenebrous" },
    {  6736, "Jinny Software Ltd" },
    {  6737, "New Era of Networks, Inc" },
    {  6738, "Riversman" },
    {  6739, "Spring Yellow" },
    {  6740, "Cal Poly State University" },
    {  6741, "Nulli Secundus Inc" },
    {  6742, "priceline.com Incorporated" },
    {  6743, "Sophicomm" },
    {  6744, "Dantron" },
    {  6745, "LASAT Networks A/S" },
    {  6746, "Aftek Infosys Ltd." },
    {  6747, "TeraBurst Networks" },
    {  6748, "Up4grab. Inc" },
    {  6749, "Bosung Hi-Net Co., Ltd" },
    {  6750, "Gascom" },
    {  6751, "Dolphin Interconnect Solutions AS" },
    {  6752, "Axtronics Inc." },
    {  6753, "SysControl AG" },
    {  6754, "EzGov" },
    {  6755, "Rush Presbyterian St. Lukes Medical Center" },
    {  6756, "Unixguy.org" },
    {  6757, "Grid" },
    {  6758, "SimplySay Inc." },
    {  6759, "Allcharge" },
    {  6760, "Virginia Tech" },
    {  6761, "Axonn Wireless Solutions" },
    {  6762, "Cambridge Positioning Systems Limit" },
    {  6763, "Metakernel Network Laboratories" },
    {  6764, "Imagine Solutions" },
    {  6765, "ML Hightower, Inc." },
    {  6766, "CPNI" },
    {  6767, "RLX Technologies, Inc." },
    {  6768, "Pixelmetrix Corporation Pte" },
    {  6769, "Dynamic Imaging Corporation" },
    {  6770, "OpenCon Communication Systems" },
    {  6771, "CyberPath Inc." },
    {  6772, "eBSure Inc." },
    {  6773, "Engineering International Corporation" },
    {  6774, "University of Virginia" },
    {  6775, "Cablevision" },
    {  6776, "bmypc" },
    {  6777, "TriGem InfoComm" },
    {  6778, "AboCom Systems, Inc." },
    {  6779, "CHL NETHERLANDS B.V." },
    {  6780, "Linux Communications AS" },
    {  6781, "Vast" },
    {  6782, "Ciena (formerly 'Akara Inc.')" },
    {  6783, "Tidepoint" },
    {  6784, "JP Systems" },
    {  6785, "Delta Electronics Inc." },
    {  6786, "Dreamworks SKG" },
    {  6787, "NetConnect" },
    {  6788, "Whitebird" },
    {  6789, "OCTOGON Software Development GmbH" },
    {  6790, "Finjan Software" },
    {  6791, "EXE Technologies, Inc." },
    {  6792, "Active+ Software" },
    {  6793, "UTIasi" },
    {  6794, "Adhesive Software Incorporated" },
    {  6795, "Pocono Pet Sitters" },
    {  6796, "TekVision Communications" },
    {  6797, "ConfigureSoft, Inc." },
    {  6798, "MaxLinear Hispania S.L.U." },
    {  6799, "GlueCode, Inc." },
    {  6800, "Express Rail Link sdn Bhd" },
    {  6801, "Gamma Technologies" },
    {  6802, "M Design Communications" },
    {  6803, "BCI (Basic Commerce and Industries, Inc.)" },
    {  6804, "Weinschel Corp" },
    {  6805, "PSA WORLD NET Inc." },
    {  6806, "The Pennsylvania State University" },
    {  6807, "Eotvos Lorand University" },
    {  6808, "Buyers Laboratory Inc." },
    {  6809, "Ontika Computersystems" },
    {  6810, "MUXCOM Inc." },
    {  6811, "Nameflow" },
    {  6812, "Yoda Communications, Inc." },
    {  6813, "Olympia College" },
    {  6814, "ItchyFeet Networks" },
    {  6815, "CyberSpacia Pty Ltd" },
    {  6816, "b4" },
    {  6817, "Metanate Ltd" },
    {  6818, "Tripwire, Inc." },
    {  6819, "Musicfans, Inc." },
    {  6820, "Menta Software" },
    {  6821, "TELECOM Lille1 (formerly 'ENIC')" },
    {  6822, "University of Cambridge, Card Office" },
    {  6823, "Distributed Object Technologies, Inc." },
    {  6824, "List & Niemann" },
    {  6825, "iCue Systems, Inc." },
    {  6826, "Dark Matter Network Technologies, Inc." },
    {  6827, "Evertz Microsystems Ltd" },
    {  6828, "Caviness Software" },
    {  6829, "RAMiX Inc." },
    {  6830, "onehottmin Inc." },
    {  6831, "DSS Digital Security Service GmbH" },
    {  6832, "VCHEQ.com Pte Ltd" },
    {  6833, "Scarptor Network ABThomas Berghemmer or Martin Moreythomas.berghemmer&scarptor.se" },
    {  6834, "sbuck networks" },
    {  6835, "chello broadband austria" },
    {  6836, "Felleskj\0303\0270pet Agri BA" },
    {  6837, "Solcom" },
    {  6838, "i.g.c." },
    {  6839, "Accelight Networks" },
    {  6840, "Deutsches Elektronen-Synchrotron" },
    {  6841, "VYX" },
    {  6842, "Telect, Inc." },
    {  6843, "Global Solution" },
    {  6844, "SAT Consulting ApS" },
    {  6845, "Micro Energetics Corp." },
    {  6846, "Paulosoft" },
    {  6847, "Teleias, Inc" },
    {  6848, "Crossbeam Systems, Inc." },
    {  6849, "Reddo Networks AB" },
    {  6850, "MCCT Inc." },
    {  6851, "XOR Inc." },
    {  6852, "University of Colorado at Boulder" },
    {  6853, "Television Systems Ltd" },
    {  6854, "R\0303\0251gie Des Transports De Marseille" },
    {  6855, "WNF Consulting, Inc." },
    {  6856, "LiquidLight" },
    {  6857, "DigitalConvergence" },
    {  6858, "Fantasma Networks" },
    {  6859, "Actzero Inc" },
    {  6860, "\0303\0224\0303\0270\0303\0220\0303\0233\0303\0216\0303\0204" },
    {  6861, "Druma Inc" },
    {  6862, "Wapinspain.com" },
    {  6863, "ZyTrax Communications, Inc." },
    {  6864, "Harmania Multimedia Inc" },
    {  6865, "Elron Telesoft" },
    {  6866, "Lyonnaise Communication" },
    {  6867, "IPOptical, Inc." },
    {  6868, "Georgetown University" },
    {  6869, "Steve Burton" },
    {  6870, "Core Software Technology" },
    {  6871, "CERT Coordination Center" },
    {  6872, "Help/Systems, Inc." },
    {  6873, "bholdcompany" },
    {  6874, "Woodwind Communications Systems, Inc" },
    {  6875, "NewEarth Swedenborgian BBS" },
    {  6876, "VMware Inc." },
    {  6877, "Evergreen Internet" },
    {  6878, "Black Box Corp." },
    {  6879, "digiMine.com" },
    {  6880, sminmpec_unknown },  /* (Added by Wireshark) */
    {  6881, "Kal" },
    {  6882, "Micro Electronics Inc" },
    {  6883, "Linux NetworX, Inc." },
    {  6884, "boco" },
    {  6885, "Intelligent Telecommunications Inc." },
    {  6886, "KPN" },
    {  6887, "IT-Conference" },
    {  6888, "Millenium Installer" },
    {  6889, "Avaya Communication" },
    {  6890, "Shell Services International" },
    {  6891, "Acepta.com" },
    {  6892, "Cnation" },
    {  6893, "TurboLinux, Inc." },
    {  6894, "DataDirect Networks" },
    {  6895, "Ereo, Inc." },
    {  6896, "Mahi Networks" },
    {  6897, "JDV" },
    {  6898, "Verance Corporation" },
    {  6899, "Nanyang Technological University" },
    {  6900, "Baltic Institute of Economics and Finance" },
    {  6901, "AETA.COM" },
    {  6902, "Plisch Gmbh & Co KG" },
    {  6903, "Visoft (Pty) Ltd" },
    {  6904, "IBM, Infrastructure Support Group" },
    {  6905, "Brocade Communication Systems, Inc. (formerly 'Rhapsody Networks Inc.')" },
    {  6906, "Asiana Communications" },
    {  6907, "Broad Telecom, S.A. (Btesa)" },
    {  6908, "Movaz Networks" },
    {  6909, "Network Security Technologies, Inc." },
    {  6910, "Inquent Technologies" },
    {  6911, "AUCS Communications Services" },
    {  6912, "Morgan Stanley Dean Witter Online" },
    {  6913, "Bona Technology" },
    {  6914, "Timing Solutions Corporation" },
    {  6915, "Computable Functions Limited" },
    {  6916, "Norbert Klasen" },
    {  6917, "Alternative Advice" },
    {  6918, "Belle Systems A/S" },
    {  6919, "Cubenet s.r.l" },
    {  6920, "Think & Do Software, Inc." },
    {  6921, "Morrison Industries" },
    {  6922, "Amino Communications Ltd" },
    {  6923, "Shutterfly" },
    {  6924, "Capital Internet, LLC" },
    {  6925, "IT Communications, Kennedy Space Center (KSC)" },
    {  6926, "Optical Access Inc." },
    {  6927, "MAIL.COM" },
    {  6928, "Mobility Next Generation" },
    {  6929, "The Root Group" },
    {  6930, "Lycee Leonard de Vinci" },
    {  6931, "Interessengemeinschaft Software-Engineering" },
    {  6932, "Internet Content Register" },
    {  6933, "Reputy" },
    {  6934, "Corporation One of America, Inc." },
    {  6935, "Arachne" },
    {  6936, "VICORSOFT CORPORATION" },
    {  6937, "NetReliance, Inc." },
    {  6938, "Enigma Inc." },
    {  6939, "Hemp.org" },
    {  6940, "Tufts University" },
    {  6941, "proflash cross-media AG" },
    {  6942, "James Cook University" },
    {  6943, "R-Alpha Ltd." },
    {  6944, "REDSYS (formerly 'SERMEPA')" },
    {  6945, "LAKE Communications" },
    {  6946, "Fouche Enterprises, LLC." },
    {  6947, "Central Bank of Russia, Arkhangelsk" },
    {  6948, "Tumsan Oy" },
    {  6949, "Nextra BW CSP GmbH" },
    {  6950, "Aztec" },
    {  6951, "Freeler BV." },
    {  6952, "iBiomatics LLC" },
    {  6953, "Air2Net AB" },
    {  6954, "Sema Group" },
    {  6955, "ComSol Kommunikationssysteme GmbH" },
    {  6956, "eTopware Labs" },
    {  6957, "Rapi10.net" },
    {  6958, "Kent State University" },
    {  6959, "bluestreak" },
    {  6960, "FELIX DANZIGER INTERNATIONAL KUNSTHANDEL" },
    {  6961, "tele.ring Telekom Service Gmbh" },
    {  6962, "The University of Sydney" },
    {  6963, "Andrews IT Engineering Ltd" },
    {  6964, "Soft Teleware Inc." },
    {  6965, "RSBX" },
    {  6966, "The Bright Oceans Corporation" },
    {  6967, "Digismart" },
    {  6968, "Systek AS" },
    {  6969, "Copernicus Global Billing Services" },
    {  6970, "VCON Ltd." },
    {  6971, "Ferimex IT spol. s r.o." },
    {  6972, "Canbox" },
    {  6973, "Savatech Inc." },
    {  6974, "EarthLink Inc." },
    {  6975, "WaterCove Networks, Inc." },
    {  6976, "HowStuffWorks.com, Inc" },
    {  6977, "Resilience Corporation" },
    {  6978, "JBruce.net" },
    {  6979, "KereniX" },
    {  6980, "MRC Project" },
    {  6981, "interQ, Inc." },
    {  6982, "Erba Holding" },
    {  6983, "Sofaware Technologies" },
    {  6984, "Fovea, Inc." },
    {  6985, "Jumpy Cat Systems, Inc. (formerly 'Prism Software, Inc.')" },
    {  6986, "Kiodex, Inc." },
    {  6987, "WRonline GbR" },
    {  6988, "University of Northern British Columbia" },
    {  6989, "Extel Communications Pty Ltd" },
    {  6990, "Redfern Broadband Networks" },
    {  6991, "N-Space Pty Ltd" },
    {  6992, "KnowNow, Inc" },
    {  6993, "VirtualNet" },
    {  6994, "The Midgard Project (Open Source)" },
    {  6995, "c-base e.V." },
    {  6996, "WhatEverNet Computing" },
    {  6997, "Yale University" },
    {  6998, "Channelogics Incorporated" },
    {  6999, "University of Indianapolis" },
    {  7000, "NET-volution srl" },
    {  7001, "Big Net, Inc." },
    {  7002, "Sebastian Crespo" },
    {  7003, "CISCO-MASBU" },
    {  7004, "Metodo Srl" },
    {  7005, "Kagoor Networks" },
    {  7006, "eyeo.com" },
    {  7007, "Guangzhou Thinker Communications Technology Co., Ltd.\"" },
    {  7008, "Discordian Alliance For Teaching" },
    {  7009, "Chemtex Engineering of India Ltd" },
    {  7010, "Oranje Consulting, Inc." },
    {  7011, "Prism Microsystems, Inc." },
    {  7012, "Edisontel S.p.A." },
    {  7013, "ByteSphere LLC" },
    {  7014, "Adexa Inc." },
    {  7015, "Vignette Corporation" },
    {  7016, "Seneca Networks" },
    {  7017, "Adari TeleComp Inc" },
    {  7018, "PT Multimedia" },
    {  7019, "Polaris Networks, Inc." },
    {  7020, "Saecos Corporation" },
    {  7021, "SysNet S.n.c." },
    {  7022, "MRZ AG" },
    {  7023, "The Direct Connection Ltd" },
    {  7024, "VHB Technologies, Inc." },
    {  7025, "Double D Investments" },
    {  7026, "Sonera SmartTrust" },
    {  7027, "Onix Microsystems Inc" },
    {  7028, "Alloptic, Inc." },
    {  7029, "CUBIweb, LLC" },
    {  7030, "Ethernet, Solucoes Informaticas, lda" },
    {  7031, "McAfee, Inc.  (formerly 'Securify, Inc.')" },
    {  7032, "Chartered Semiconductor Manufacturing" },
    {  7033, "Mat\0303\0255as Software Group" },
    {  7034, "inyourwake" },
    {  7035, "VTT Electronics" },
    {  7036, "MBDyn" },
    {  7037, "Ubris" },
    {  7038, "Tron Network Solutions" },
    {  7039, "bison GmbH" },
    {  7040, "DataLinx Inc" },
    {  7041, "Integra" },
    {  7042, "Permanent Vacations" },
    {  7043, "Apt Computer Systems Limited" },
    {  7044, "Primal" },
    {  7045, "TBA Communications" },
    {  7046, "Tom's NET" },
    {  7047, "Flux Productions" },
    {  7048, "Pico Communications, Inc." },
    {  7049, "DataNet Development Group, Inc." },
    {  7050, "Kazan State University" },
    {  7051, "Epicom S.A." },
    {  7052, "Dipl.-Ing. Markus Leist" },
    {  7053, "Videon CableSystems Alberta Inc." },
    {  7054, "Mazu Networks, Inc." },
    {  7055, "Cox Communications, Inc." },
    {  7056, "Senterprise Inc." },
    {  7057, "SuSE Linux AG" },
    {  7058, "BB4 Technologies Inc" },
    {  7059, "Complete Business Solutions - Global Health" },
    {  7060, "Naikel Software" },
    {  7061, "Automated Logic Corporation" },
    {  7062, "Oasis Telecommunications, Inc." },
    {  7063, "Australian Defence Force Academy" },
    {  7064, "UTStarcom (China) Co., Ltd Shenzhen Branch" },
    {  7065, "Shimin Denshi Jouhou Mou" },
    {  7066, "Dr. Srinivas" },
    {  7067, "TELCO TECH GmbH" },
    {  7068, "CryptoPRO" },
    {  7069, "SFI Open Source Services" },
    {  7070, "Narad Networks" },
    {  7071, "Tele-Info-System" },
    {  7072, "Ehrhart Jewelers" },
    {  7073, "r00tkit.com" },
    {  7074, "TheMagicProgrammer" },
    {  7075, "Lothar Maronn" },
    {  7076, "Australian Online Solutions" },
    {  7077, "Desarrollos Digitales" },
    {  7078, "True North Communications" },
    {  7079, "Megisto Systems, Inc." },
    {  7080, "xeli.net" },
    {  7081, "Maaslandse Unix & Linux Laboratorium (MULL)" },
    {  7082, "DAIDEN CO., Ltd." },
    {  7083, "Applied Generics Ltd" },
    {  7084, "Friends Provident" },
    {  7085, "Cybercomm BV" },
    {  7086, "GTONG Shenzhen Ltd." },
    {  7087, "KMC Technologies (formerly 'Selis Networks Inc.')" },
    {  7088, "Network Systems" },
    {  7089, "Centrum Arbeidsverhoudingen" },
    {  7090, "El Bit Salvaje" },
    {  7091, "CREN" },
    {  7092, "ScienceXchange" },
    {  7093, "Ericsson - Geobility" },
    {  7094, "Wachovia Trust" },
    {  7095, "Pert" },
    {  7096, "JSEIC" },
    {  7097, "LeatherXchange, S.A." },
    {  7098, "Edison Mission Energy" },
    {  7099, "Ripeco Ltd" },
    {  7100, "Killik & Co." },
    {  7101, "CO3i" },
    {  7102, "IDEALX" },
    {  7103, "SaltFire, Inc" },
    {  7104, "Supervertical Sistemas" },
    {  7105, "CANTV" },
    {  7106, "Teleport Corp" },
    {  7107, "Geocast Network Systems" },
    {  7108, "Urscheler Software" },
    {  7109, "City University of Hongkong" },
    {  7110, "Kaashyap Radiant System ltd" },
    {  7111, "Sunamerican Communication Technology Inc." },
    {  7112, "U.S. Department of Commerce" },
    {  7113, "YottaYotta" },
    {  7114, "Universidad de Navarra" },
    {  7115, "book2eat.com limited" },
    {  7116, "TechTrade International Management AB" },
    {  7117, "Invertix, Inc" },
    {  7118, "NetContinuum, Inc" },
    {  7119, "OPNET Technologies, Inc. (formerly 'Network Physics, Inc.')" },
    {  7120, "Sentry Telecom Systems Inc." },
    {  7121, "Comunicaciones Netglobalis" },
    {  7122, "Lusars.net" },
    {  7123, "nSOF Parallel Software Ltd." },
    {  7124, "Stand-by" },
    {  7125, "Digital Creations" },
    {  7126, "Positron Public Safety Systems Inc." },
    {  7127, "Nadeem Hasan" },
    {  7128, "Worcester Polytechnic Institute" },
    {  7129, "Lancaster University" },
    {  7130, "KiddiePot.com" },
    {  7131, "Orient Telecom" },
    {  7132, "ELANsat TECHNOLOGIES Inc." },
    {  7133, "Corenix System Inc." },
    {  7134, "Prosolve" },
    {  7135, "Comit\0303\0251 R\0303\0251seau des Universit\0303\0251s" },
    {  7136, "SysNet" },
    {  7137, "Tunisie Telecom" },
    {  7138, "Allaire Corporation" },
    {  7139, "EchoStar Data Networks" },
    {  7140, "INPG, Institut National Polytechnique de Grenoble" },
    {  7141, "Freesoft" },
    {  7142, "Pingtel Corp." },
    {  7143, "Entrust Technologies, Inc." },
    {  7144, "FaceTime Communications, Inc." },
    {  7145, "eve.com" },
    {  7146, "Zeus Technology Ltd" },
    {  7147, "Imperial Technology, Inc." },
    {  7148, "Unitree Software" },
    {  7149, "Arcot Systems, Inc." },
    {  7150, "INITECH, Co.,Ltd." },
    {  7151, "r pdeshpande" },
    {  7152, "CAPE Technologies Ltd.," },
    {  7153, "Foertsch EDV Beratung" },
    {  7154, "Intelligent Platform Management Interface forum" },
    {  7155, "neohaven.net" },
    {  7156, "Princeton Networks" },
    {  7157, "SC Dart IMPEX SRL" },
    {  7158, "1 Global City.com, Inc." },
    {  7159, "Allianz AG" },
    {  7160, "Granada Learning" },
    {  7161, "Network Solutions, Inc." },
    {  7162, "Delancey Management and Consulting" },
    {  7163, "Fiorano Software, Inc." },
    {  7164, "SchiZo Information Network" },
    {  7165, "SAMBA Team" },
    {  7166, "Peters Securities Co, L.P." },
    {  7167, "WinterTek, LLC" },
    {  7168, "Eurosoft Sas" },
    {  7169, "Engage, Inc." },
    {  7170, "Centell Telecommunication Company" },
    {  7171, "Europesave S.A." },
    {  7172, "SPARKnet S.A." },
    {  7173, "Jiangsu University of Science and Technology" },
    {  7174, "Tonic Software, Inc." },
    {  7175, "TSP Lab(Telecommunication and Signal Processing Lab.) Peter" },
    {  7176, "orangefood.com" },
    {  7177, "IPITEK" },
    {  7178, "SANJOSEDEOCOA.COM.DO" },
    {  7179, "ARIO Data Networks" },
    {  7180, "Talarian Corporation" },
    {  7181, "Trendium, Inc." },
    {  7182, "ypass.net" },
    {  7183, "Springfield Public Schools" },
    {  7184, sminmpec_unknown },  /* (Added by Wireshark) */
    {  7185, "Latitude Communications" },
    {  7186, "BayPackets Inc" },
    {  7187, "Netsystems, Inc." },
    {  7188, "Curtin University of Technology" },
    {  7189, "EMS-Global" },
    {  7190, "Legato Systems India" },
    {  7191, "Gebrueder Weiss GmbH" },
    {  7192, "ID-PRO Aktiengesellschaft" },
    {  7193, "Bourse Connect" },
    {  7194, "Stevens Gagnon Services Info-Techniques" },
    {  7195, "Iquilibrium, Inc." },
    {  7196, "Imagine Software" },
    {  7197, "Intertech" },
    {  7198, "CeLight" },
    {  7199, "2Bridge Software" },
    {  7200, "Forebrick International" },
    {  7201, "Druker Consulting" },
    {  7202, "Seastem" },
    {  7203, "Technology Builders, Inc." },
    {  7204, "PerformanceIT, Inc." },
    {  7205, "CoreTech Consulting Group, Inc." },
    {  7206, "Real Media, Inc" },
    {  7207, "DENON DENTAL" },
    {  7208, "AFCON Software and Electronics Ltd." },
    {  7209, "Societe Bryarde de Travaux Publics" },
    {  7210, "WorkSpot Inc" },
    {  7211, "Raiffeisen Schweiz" },
    {  7212, "Raiffeisen Schweiz" },
    {  7213, "Datria Systems" },
    {  7214, "Virginia-Meryland Regional College of Veterinary Medicine" },
    {  7215, "ABN AMRO" },
    {  7216, "Institut National de la Recherche Agronomique" },
    {  7217, "The University of Memphis" },
    {  7218, "HBESoftware Inc." },
    {  7219, "Firedrop Inc" },
    {  7220, "Shanghai Optical Networking Technology Co. Ltd." },
    {  7221, "Handlink Technologies Inc." },
    {  7222, "TIScover" },
    {  7223, "ofehr.net" },
    {  7224, "Netarchitects SA" },
    {  7225, "Spacechecker nv" },
    {  7226, "Micro F/X" },
    {  7227, "Centre Informatique National de l'Enseignement Superieur" },
    {  7228, "The Web Foundry Limited" },
    {  7229, "Vogeler Enterprise Architectures" },
    {  7230, "Eastern Michigan University" },
    {  7231, "MidStream Technologies" },
    {  7232, "VR1 Entertainment" },
    {  7233, "SierraCities.com" },
    {  7234, "KORE" },
    {  7235, "eRadlink" },
    {  7236, "SIMM-Comm" },
    {  7237, "Aaronsen Group, Ltd." },
    {  7238, "OM Technology" },
    {  7239, "LEGRAND" },
    {  7240, "Princeton Networks Inc" },
    {  7241, "Inter.net" },
    {  7242, "QwicNet, Inc." },
    {  7243, "ZIVO Wellington" },
    {  7244, "Quanta Computer Inc." },
    {  7245, "Northern Districts In-Line Hockey Club" },
    {  7246, "Project X Consulting Ltd" },
    {  7247, "Nexsan Technologies, Ltd." },
    {  7248, "HyperTrust" },
    {  7249, "Manage-IT" },
    {  7250, "Viewgraphics" },
    {  7251, "SPC solutions s.r.o." },
    {  7252, "Institut Mondor de M\0303\0251decine Mol\0303\0251culaire" },
    {  7253, "StreamCache" },
    {  7254, "Intronix Corporation" },
    {  7255, "PointOne Telecommunications, Inc." },
    {  7256, "Geyser Networks, Inc." },
    {  7257, "Mar-Net Ltd." },
    {  7258, "Centre national de Documentation Pedagogique" },
    {  7259, "OULLIM Information Technology, Inc." },
    {  7260, "Opthos Inc." },
    {  7261, "InfoSpace" },
    {  7262, "DragonWave" },
    {  7263, "Litt Productions Ltd." },
    {  7264, sminmpec_unknown },  /* (Added by Wireshark) */
    {  7265, "Interactive Portal, Inc." },
    {  7266, "Softfront" },
    {  7267, "BroadLink Technologies, Inc." },
    {  7268, "Axiavoice Software" },
    {  7269, "University of Klagenfurt" },
    {  7270, "Supanet Limited" },
    {  7271, "TuxWarp" },
    {  7272, "RedSiren Technologies Inc." },
    {  7273, "When Pigs Fly Club" },
    {  7274, "CITY OF WILLCOX" },
    {  7275, "Amsterdamse Hogeschool voor de Kunsten" },
    {  7276, "Parabon Computation, Inc." },
    {  7277, "PolyServe,Inc." },
    {  7278, "Digital Archway" },
    {  7279, "Zembu Labs" },
    {  7280, "Vodafone Network Pty Ltd Australia" },
    {  7281, "Socix Business Internet Software Co., Ltd" },
    {  7282, "Superchannel ApS" },
    {  7283, "Defence Science & Technology Agency" },
    {  7284, "Asita Technologies" },
    {  7285, "Hutchison Ports UK Limited" },
    {  7286, "betanet" },
    {  7287, "Premier Programming Ltd" },
    {  7288, "ActiveSky Inc." },
    {  7289, "Visual Analysis AG" },
    {  7290, "Samjung Data Service LTD.,CO." },
    {  7291, "Lecointe Ludovic" },
    {  7292, "Krone Multimedia Ges.m.b.H Co KG" },
    {  7293, "POWERCOM CO., Ltd." },
    {  7294, "Soci\0303\0251t\0303\0251 G\0303\0251n\0303\0251rale de T\0303\0251l\0303\0251informatique" },
    {  7295, "plan b. solutions GmbH" },
    {  7296, "eFORCE, Inc.- New York" },
    {  7297, "Adventist Care Centers" },
    {  7298, "Yuma Educational Consortium" },
    {  7299, "Valence Semiconductor, Inc." },
    {  7300, "Bangladesh Consultants Ltd." },
    {  7301, "Kinzebach" },
    {  7302, "Medsys" },
    {  7303, "Byg Informatique" },
    {  7304, "WWW. DEPARTMENTSTORE" },
    {  7305, "esurvey" },
    {  7306, "Boku, Inc." },
    {  7307, "PonyExpress.net" },
    {  7308, "Zaantek, LLC" },
    {  7309, "Argus Technologies" },
    {  7310, "EnStor" },
    {  7311, "T-Systems Enterprise Services GmbH" },
    {  7312, "BARCO Control Rooms" },
    {  7313, "1stWAVE" },
    {  7314, "CodeWeavers, Inc" },
    {  7315, "CAB Software" },
    {  7316, "Bridge Solutions AG" },
    {  7317, "Mobile Reach Technologies, Inc." },
    {  7318, "Sinia Corporation" },
    {  7319, "Universite de Toulon et du Var" },
    {  7320, "Ivron Systems Ltd" },
    {  7321, "connext" },
    {  7322, "Tiburon Networks, Inc" },
    {  7323, "Voicecom" },
    {  7324, "Chambre Syndicale des Banques Populaires" },
    {  7325, "Redeye Telecommunications" },
    {  7326, "MCI" },
    {  7327, "WaveSmith Networks" },
    {  7328, "MatrixOne, Inc." },
    {  7329, "Virtual Learn Inc" },
    {  7330, "Bundesanstalt fuer Wasserbau" },
    {  7331, "DDS Projects BV" },
    {  7332, "DiviTech A/S" },
    {  7333, "E-Cottage Industries" },
    {  7334, "The San Joaquin Valley Science Collective" },
    {  7335, "eXperts-MD" },
    {  7336, "6WIND" },
    {  7337, "Lipro AG" },
    {  7338, "Paramhamsa Tech" },
    {  7339, "GeneralSearch.com" },
    {  7340, "Northwestern University" },
    {  7341, "University of Alabama at Birmingham" },
    {  7342, "Omnitron Systems Technology" },
    {  7343, "BroadConnex Networks, Inc." },
    {  7344, "Jedai Broadband Networks" },
    {  7345, "Learnsoft Corporation" },
    {  7346, "Uni-C" },
    {  7347, "Point Reyes Networks, Inc." },
    {  7348, "Torren Software Company" },
    {  7349, "Hangzhou Torren Software Company" },
    {  7350, "Belkamneft" },
    {  7351, "TeleDanmark Development" },
    {  7352, "Gilat Satellite Networks" },
    {  7353, "Datel Defence Limited" },
    {  7354, "Vesper S.A." },
    {  7355, "Hass Asscoiates" },
    {  7356, "Gateway to the Web" },
    {  7357, "scroner.com" },
    {  7358, "POV Corp." },
    {  7359, "SteelEye Technology" },
    {  7360, "Telecom Personal" },
    {  7361, "Certificado Digital S.A." },
    {  7362, "Department Land, Air and Water Resources,University of California,Davis" },
    {  7363, "Prominence Networks Inc." },
    {  7364, "IMS Health" },
    {  7365, "Easily Ltd" },
    {  7366, "MarketTouch" },
    {  7367, "DrayTek Corporation" },
    {  7368, "FalconStor, Inc." },
    {  7369, "Suncom Communications" },
    {  7370, "Cbeyond Communications" },
    {  7371, "INSERM" },
    {  7372, "Cratos Networks, Inc" },
    {  7373, "Narad Networks Inc." },
    {  7374, "C&D Micro Solutions" },
    {  7375, "iSOFT Plc" },
    {  7376, "Magenta Sites" },
    {  7377, "Ubiquity Software Corporation" },
    {  7378, "FireSummit" },
    {  7379, "Soliton Technologies CO.," },
    {  7380, "Shore Corporation" },
    {  7381, "OWL-Online GmbH & Co. KG" },
    {  7382, "JustIT Sdn. Bhd." },
    {  7383, "LIBERTECH" },
    {  7384, "CryptoTech" },
    {  7385, "Celox Networks Inc." },
    {  7386, "Cake Farm" },
    {  7387, "Canon Information Systems Research Australia" },
    {  7388, "Lune Networks" },
    {  7389, "VDSL Systems Oy" },
    {  7390, "Grisoft" },
    {  7391, "Institut National des Telecommunications (INT)" },
    {  7392, "Telispark" },
    {  7393, "Oasys Telecom, Inc." },
    {  7394, "CosmoCom, Inc." },
    {  7395, "Beeline Networks, Inc." },
    {  7396, "OLYMPO controls Ltd." },
    {  7397, "OnePage, inc" },
    {  7398, "Corporation 124" },
    {  7399, "Data Systems West" },
    {  7400, "EHI-INSM" },
    {  7401, "EkotaCentral" },
    {  7402, "Vigor Soft Private Limited" },
    {  7403, "Biomed Translations Ltd." },
    {  7404, "D.J. Williams Editorial Ltd.David" },
    {  7405, "IPS d.o.o." },
    {  7406, "EFS : Etablisssement Francais du Sang" },
    {  7407, "Observatoire de Besancon" },
    {  7408, "Kunskapstv i Sverige AB" },
    {  7409, "Jan Niehusmann" },
    {  7410, "Telekurs Financial" },
    {  7411, "Finix" },
    {  7412, "Angstrom Microsystems" },
    {  7413, "Computer Service Depot" },
    {  7414, "Muffett & Co" },
    {  7415, "Berlin-Brandenburgische Akademie der Wissenschaften" },
    {  7416, "Software Advanced Technology Lab" },
    {  7417, "Cornell University" },
    {  7418, "Procket Networks" },
    {  7419, "Dai hoc su pham ky thuat" },
    {  7420, "Taylor Company" },
    {  7421, "Milcom Systems Corporation" },
    {  7422, "Currenex" },
    {  7423, "MedPlus, Inc." },
    {  7424, "Infosec Technologies Co., Ltd." },
    {  7425, "Company of the Far Countries, Ltd." },
    {  7426, "NeST Information Technologies" },
    {  7427, "Yokogawa Electric Corporation" },
    {  7428, "PowerDsine" },
    {  7429, "BroadWeb Corporation" },
    {  7430, "mediascape communications AG" },
    {  7431, "Altiva Solutions" },
    {  7432, "Excentis" },
    {  7433, "SITTI spa" },
    {  7434, "Planetasia Ltd" },
    {  7435, "T.K COMPANY" },
    {  7436, "Oxir Internet Solutions" },
    {  7437, "Siemens ICN Italy" },
    {  7438, "SAFE. Inc" },
    {  7439, "AppStream, Inc." },
    {  7440, "Omnitech Computer Corp" },
    {  7441, "CipherTrust, Inc." },
    {  7442, "Idaho National Engineering and Environmental Laboratory" },
    {  7443, "EVEREX COMMUNICATION" },
    {  7444, "Imagine Networks" },
    {  7445, "Javelina Software" },
    {  7446, "Institute of Leadership and Management" },
    {  7447, "Signal Technology INC" },
    {  7448, "Advanced Training & Consulting Services, Inc." },
    {  7449, "WHAM COMPUTER" },
    {  7450, "Framfab" },
    {  7451, "nSYS Technologies Co., Ltd" },
    {  7452, "Guangzhou Gaoke Communication Equipment Co., Ltd" },
    {  7453, "Turtlefoot International" },
    {  7454, "OKsystem Ltd." },
    {  7455, "dev/consulting GmbH" },
    {  7456, "Virtual Net" },
    {  7457, "ZAO EMAX" },
    {  7458, "Clemens Benden" },
    {  7459, "memIQ" },
    {  7460, "XS4ALL Internet B.V." },
    {  7461, "Page One AG" },
    {  7462, "Nordnorsk helsenett" },
    {  7463, "white.cell,inc" },
    {  7464, "ECMWF (European Centre for Medium-Range Weather Forecast)" },
    {  7465, "WISI" },
    {  7466, "CLI GmbH" },
    {  7467, "TTi Systems" },
    {  7468, "Mixbaal" },
    {  7469, "VoiceGenie Technologies" },
    {  7470, "Princeton Financial Systems" },
    {  7471, "Discreet Communications Group" },
    {  7472, "MShow.com" },
    {  7473, "easyplanet Corp." },
    {  7474, "Inabled Online" },
    {  7475, "Shanghai Bell Company Ltd." },
    {  7476, "Departamento General de Irrigacion" },
    {  7477, "Unk SA - Argentina" },
    {  7478, "NetCraft Sdn Bhd" },
    {  7479, "Triad Development Group NA, LLC" },
    {  7480, "@MySpend.Com" },
    {  7481, "Talon" },
    {  7482, "Widax Corporation" },
    {  7483, "Alcatel-Lucent (formerly 'Tropic Networks')" },
    {  7484, "Teleias Inc." },
    {  7485, "SPS, Inc." },
    {  7486, "Embassy Systems, Ltda." },
    {  7487, "MEISolutions.com, Inc." },
    {  7488, "Infinitec Networks" },
    {  7489, "e-HealthSign" },
    {  7490, "TotalWisdom Inc." },
    {  7491, "gnumonks.org" },
    {  7492, "Kommunikationsnetz Franken e.V." },
    {  7493, "ldap-abook" },
    {  7494, "Rovor Technologies" },
    {  7495, "Advanced Web Solutions, Inc" },
    {  7496, "JB-Holding b.v." },
    {  7497, "Magnolia Broadband" },
    {  7498, "Gorski.net" },
    {  7499, "Pacific Century CyberWorks - Hongkong Telecom" },
    {  7500, "IICS" },
    {  7501, "BKtel communications GmbH (Systems)" },
    {  7502, "African Medical Imaging" },
    {  7503, "Henkels and McCoy" },
    {  7504, "AerSoft Ltd" },
    {  7505, "Calista Ltd." },
    {  7506, "Scoreline Technologies" },
    {  7507, "WayneWare" },
    {  7508, "Fuji Electric Co.,Ltd." },
    {  7509, "Storability, Inc." },
    {  7510, "Luxxon Corporation" },
    {  7511, "wdt" },
    {  7512, "NetEnS Corporation" },
    {  7513, "Elimpex - Medizintechnik GesmbH." },
    {  7514, "St Helens And Knowsley Hospitals NHS Trust" },
    {  7515, "P. Lancier" },
    {  7516, "Andy Stubbs" },
    {  7517, "Acxsys Corporation" },
    {  7518, "Chicago Mercantile Exchange" },
    {  7519, "RateIntegration, Inc." },
    {  7520, "Harris Corporation (formerly 'M/A-COM Private Radio Systems, Inc.')" },
    {  7521, "Logicalis Australia Pty Ltd (formerly 'NetStar Networks')" },
    {  7522, "Brains Corp" },
    {  7523, "AccessNet" },
    {  7524, "RapidSolution Software GmbH" },
    {  7525, "eCal Corporation" },
    {  7526, "snom technology AG" },
    {  7527, "Quest Software" },
    {  7528, "Metabox Inc" },
    {  7529, "Netarx, Inc." },
    {  7530, "OptXCon Inc." },
    {  7531, "RapidWAN" },
    {  7532, "Munat, Inc." },
    {  7533, "HONDA ELECTRON CO.,LTD" },
    {  7534, "Universita' degli Studi di Genova" },
    {  7535, "CapCLEAR Limited" },
    {  7536, "H+H Zentrum f. Rechnerkommunikation GmbH" },
    {  7537, "e2 Communications" },
    {  7538, "Veriprise Wireless Company" },
    {  7539, "QUACK.COM" },
    {  7540, "ISPsoft" },
    {  7541, "iBuilding.com" },
    {  7542, "Mount Allison University" },
    {  7543, "VisionShop" },
    {  7544, "Wirelink Co., Ltd." },
    {  7545, "QoSBA Systems Co., Ltd." },
    {  7546, "AXXESSIT ASA" },
    {  7547, "CSIC/RedIRIS" },
    {  7548, "Netcentric Systems Ltd." },
    {  7549, "DataCenterDirect.com, Inc." },
    {  7550, "Delta Data Software" },
    {  7551, "Enatel" },
    {  7552, "Infra Valley" },
    {  7553, "Tampere University of Technology" },
    {  7554, "Zlooper Media Perkasa" },
    {  7555, "Institution Saint-Joseph" },
    {  7556, "Movilogic S.A." },
    {  7557, "Echomine" },
    {  7558, "National Air Traffic Services Ltd" },
    {  7559, "Egenera, Inc" },
    {  7560, "Daisy Group" },
    {  7561, "Askoo SA" },
    {  7562, "ICPSR (Inter-university Consortium for Political & Social Research)" },
    {  7563, "OneSpot, Inc." },
    {  7564, "Clickarrray Networks, Inc." },
    {  7565, "USGS South Florida Information Access Project" },
    {  7566, "CodeStream Technologies Corporation" },
    {  7567, "Portera Systems" },
    {  7568, "Ircam" },
    {  7569, "Convedia Corporation" },
    {  7570, "Brience, Inc." },
    {  7571, "SAF tehnika" },
    {  7572, "Quest Software" },
    {  7573, "NBC Internet" },
    {  7574, "Torque Systems, Inc" },
    {  7575, "Maharashtra Institute of Technology, Pune" },
    {  7576, "GEA IT Services GmbH" },
    {  7577, "University Of Strathclyde" },
    {  7578, "Energis Deutschland" },
    {  7579, "University of Freiburg" },
    {  7580, "AnIX Group Limited" },
    {  7581, "Advent Networks, Inc." },
    {  7582, "E-Z Data, Inc." },
    {  7583, "The Eleven" },
    {  7584, "Intertrust Technologies Corporation" },
    {  7585, "Genius Software Ltda" },
    {  7586, "Parametric Technology Corporation" },
    {  7587, "World Digitel Corporation" },
    {  7588, "WIS COMMUNICATION CO. LTD" },
    {  7589, "MemlinkEyal" },
    {  7590, "bodachina" },
    {  7591, "Divisa Inform\0303\0241tica y Telecomunicaciones S.A." },
    {  7592, "Swedish Institute of Space Physics" },
    {  7593, "University of Cambridge, Clinical and Biomedical Computing Unit" },
    {  7594, "Citadel LLC (formerly 'Citadel Investment Group')" },
    {  7595, "RATIO Entwicklungen GmbH" },
    {  7596, "Trellis Photonics" },
    {  7597, "NOVA LJUBLJANSKA BANKA" },
    {  7598, "KTSI" },
    {  7599, "Rebel.com, Inc." },
    {  7600, "eazel" },
    {  7601, "Trinity College" },
    {  7602, "Covers.de" },
    {  7603, "Kingfisher ICT-Services" },
    {  7604, "MSE-iT" },
    {  7605, "e-point S.A" },
    {  7606, "The University of Alabama in Huntsville" },
    {  7607, "AppGate, Inc." },
    {  7608, "Celion Networks, Inc." },
    {  7609, "SpinState" },
    {  7610, "Something 4 Ltd" },
    {  7611, "Federal Reserve System" },
    {  7612, "Digi-Data Corp" },
    {  7613, "Panther Software, Inc." },
    {  7614, "Isovia" },
    {  7615, "Universitat de Girona" },
    {  7616, "STMICROELECTRONICS" },
    {  7617, "Stendahls.net AB" },
    {  7618, "Adomo, Inc." },
    {  7619, "Amon Technologies" },
    {  7620, "France Teaser" },
    {  7621, "DISH Network L.L.C. (formerly 'EchoStar Corporation')" },
    {  7622, "Mesa Systems International" },
    {  7623, "DXO Telecom Co., Ltd." },
    {  7624, "akal systems" },
    {  7625, "ComCon GmbH" },
    {  7626, "University of Osnabrueck" },
    {  7627, "TeleBroad Networks" },
    {  7628, "Reed-Matthews, Inc." },
    {  7629, "4unet" },
    {  7630, "Tioga Technologies" },
    {  7631, "INTERFACE CONCEPT" },
    {  7632, "GNS" },
    {  7633, "City University" },
    {  7634, "Bungee Communications" },
    {  7635, "THOMSON multimedia R&D France" },
    {  7636, "Laponia Veiculos" },
    {  7637, "JPM Consulting" },
    {  7638, "Carrier1" },
    {  7639, "Netverk S.A." },
    {  7640, "Quantum Corp." },
    {  7641, "Astronomical Society of Edinburgh" },
    {  7642, "SpiderTech Software Pvt. Ltd" },
    {  7643, "National Chung Cheng University" },
    {  7644, "EK Gro\0303\0237einkauf eG" },
    {  7645, "NetXL" },
    {  7646, "Exemus Ltd" },
    {  7647, "Oregan Networks Ltd" },
    {  7648, "Nationwide Mutual Insurance Company" },
    {  7649, "EverFile, Inc." },
    {  7650, "Leibniz-Rechenzentrum" },
    {  7651, "UniSecurity" },
    {  7652, "DataCore Software Corporation" },
    {  7653, "Dashbit Incorporated" },
    {  7654, "SnoNet" },
    {  7655, "Sean Kelly, Independent Consultant" },
    {  7656, "Bertrandt AG" },
    {  7657, "DISAT SISTEMAS TELECOMUNICACI\0303\0223N" },
    {  7658, "Webonomics GmbH" },
    {  7659, "UESTC" },
    {  7660, "Okiok Data" },
    {  7661, "HumanScan GmbH" },
    {  7662, "SOGETEK" },
    {  7663, "Taral Networks Inc." },
    {  7664, "mezzoNET Easy Technologie S.L." },
    {  7665, "INTRIA-HP Corp" },
    {  7666, "Provenco Group Ltd" },
    {  7667, "Banque Nationale du Canada" },
    {  7668, "Praeter Technologies, Inc." },
    {  7669, "Network Photonics, Inc." },
    {  7670, "Viator Incorporated" },
    {  7671, "Invertix Corporation" },
    {  7672, "Fujitsu NNC Ltd./ PBN" },
    {  7673, "Fusion Communications Corp." },
    {  7674, "Northern Principle Limited" },
    {  7675, "SPAR Handels AG" },
    {  7676, "Strawberry Software Limited" },
    {  7677, "Lynx Photonic Networks Inc." },
    {  7678, "XYRIUS" },
    {  7679, "WiNag.com" },
    {  7680, "Corrigent Systems Inc." },
    {  7681, "Trakonic" },
    {  7682, "nCipher PLC" },
    {  7683, "Air Liquide Electronics" },
    {  7684, "NexTone Communications" },
    {  7685, "KPMG Consulting, LLC" },
    {  7686, "P\0303\0252ches et Oc\0303\0251ans Canada - Garde c\0303\0264ti\0303\0250re" },
    {  7687, "UFSC/LabSEC" },
    {  7688, "Social Change Online" },
    {  7689, "rasimusi" },
    {  7690, "ThruPoint, Inc." },
    {  7691, "Warp Solutions, Inc." },
    {  7692, "The Stoddard Group, Inc." },
    {  7693, "International Life Sciences Institute (ILSI)" },
    {  7694, "Summit Technologies" },
    {  7695, "Media Cloud, Inc." },
    {  7696, "Bach Systems, Inc." },
    {  7697, "Athabasca University" },
    {  7698, "Context Media, Inc." },
    {  7699, "Syncwave Networks, Inc." },
    {  7700, "Endeavors Technology, Inc." },
    {  7701, "GemStone Systems Inc." },
    {  7702, "Keicho,Ltd." },
    {  7703, "Ecrio Inc." },
    {  7704, "Der Polizeipraesident in Berlin" },
    {  7705, "Centre For Wireless Communications" },
    {  7706, "JonCol.com" },
    {  7707, "Proactive Technology Ltd." },
    {  7708, "WydeBand" },
    {  7709, "Aristotle University of Thessaloniki" },
    {  7710, "Agrilis (pty) Ltd" },
    {  7711, "GNKC" },
    {  7712, "SECARTIS AG" },
    {  7713, "Tomorrow Technologies Marcus" },
    {  7714, "EVIDIAN" },
    {  7715, "EYE Communications AG" },
    {  7716, "ART S.p.A." },
    {  7717, "Flying J Inc." },
    {  7718, "INA" },
    {  7719, "Avilinks" },
    {  7720, "W.I. Simonson Inc." },
    {  7721, "caatoosee schweiz ag" },
    {  7722, "net-linx-ps-sii" },
    {  7723, "Benham.net" },
    {  7724, "Unassigned" },
    {  7725, "Hark Tower Systems" },
    {  7726, "Pointgain Corporation" },
    {  7727, "CIN-NIC" },
    {  7728, "3R Inc." },
    {  7729, "Telson" },
    {  7730, "Voxpath Networks" },
    {  7731, "HomeStore.com" },
    {  7732, "philiplo" },
    {  7733, "Pulsar Technologies, Inc." },
    {  7734, "ProQuent Systems Corporation" },
    {  7735, "Airbiquity Inc" },
    {  7736, "Jarna" },
    {  7737, "Internet Photonics Inc." },
    {  7738, "Encendra Communications" },
    {  7739, "DigEncP" },
    {  7740, "NetMonger Communications Christopher" },
    {  7741, "SNMP Technologies" },
    {  7742, "Aptira Pty Ltd (formerly 'Antithesys Pty Ltd')" },
    {  7743, "Salomon Smith Barney, Autralia" },
    {  7744, "SPE Systemhaus GmbH" },
    {  7745, "AETHRA" },
    {  7746, "Watershed Consultants Ltd" },
    {  7747, "Federation" },
    {  7748, "GlobeCom Interactive" },
    {  7749, "HICOM GmbH" },
    {  7750, "Helicon Networks" },
    {  7751, "mDiversity, Inc." },
    {  7752, "Bravara Communications, Inc." },
    {  7753, "ZELPOS" },
    {  7754, "Infosquare Corp." },
    {  7755, "Disney Technology Solutions and Services" },
    {  7756, "Netarena Communications" },
    {  7757, "Tonbu Inc" },
    {  7758, "E-BUSINESSNETWORK.COM" },
    {  7759, "EENADU.COM" },
    {  7760, "ANYSCAPE.COM" },
    {  7761, "POINTGO.COM" },
    {  7762, "EBIZXML.COM" },
    {  7763, "POINTGAIN.NET" },
    {  7764, "EBUSINESSXCHANGE.COM" },
    {  7765, "SYSDYNAMICS.COM" },
    {  7766, "BUSINESSACROSS.COM" },
    {  7767, "EBUSINESSOPENWORLD.COM" },
    {  7768, "E-BUSINESSOPENWORLD.COM" },
    {  7769, "E-BUSINESSOPENWORLD.NET" },
    {  7770, "EBUSINESSOPENWORLD.NET" },
    {  7771, "EBUSINESSACROSS.COM" },
    {  7772, "EBIZDYNAMICS.COM" },
    {  7773, "E-BUSINESSDYNAMICS.COM" },
    {  7774, "EBUSINESSX.COM" },
    {  7775, "E-DYNAMICS.COM" },
    {  7776, "E-DYNAMICS.NET" },
    {  7777, "E-DYNAMICS.ORG" },
    {  7778, "Excess Trade Zone, Inc." },
    {  7779, "InfoBlox Inc." },
    {  7780, "Mirametric" },
    {  7781, "Conservatoire National des Arts et Metiers" },
    {  7782, "Greek School Network" },
    {  7783, "Riello S.p.A." },
    {  7784, "Lattis Enterprise Management Ltd" },
    {  7785, "Rivne Communication Technologies Ltd." },
    {  7786, "IBCnet Ltd." },
    {  7787, "frontsite AG" },
    {  7788, "Liebregts" },
    {  7789, "LPM Online" },
    {  7790, "LISIT - Lombardia Integrata Servizi Infotelematici per ilTerritorio" },
    {  7791, "Conseil General de la Loire" },
    {  7792, "incshopkorea" },
    {  7793, "HMS" },
    {  7794, "Infinity Tel-Data Inc" },
    {  7795, "Custom Software Solutions" },
    {  7796, "BowdenGS Technoloiges, LLC" },
    {  7797, "Aculeus, Inc." },
    {  7798, "Toko Electric Co., Ltd." },
    {  7799, "The PacificRoot" },
    {  7800, "Premier Network Co., Ltd" },
    {  7801, "Radionet Oy" },
    {  7802, "110 Limited" },
    {  7803, "Terra Networks Brasil S/A" },
    {  7804, "elcan Corp." },
    {  7805, "NetNation Communications Inc." },
    {  7806, "Techsar" },
    {  7807, "Stoneware, Inc." },
    {  7808, "Rearden Steel Technologies, Inc." },
    {  7809, "Phil Pearl (formerly 'Finch Computer Services')" },
    {  7810, "Seek Systems" },
    {  7811, "40 Street Records" },
    {  7812, "Pfadi Limmattal" },
    {  7813, "Cogetec HSI" },
    {  7814, "Infinity Tel-Data Inc." },
    {  7815, "Gilmore House Associates Ltd" },
    {  7816, "Wissenschaftladen Dortmund e.V." },
    {  7817, "Chiphead Consulting, Inc." },
    {  7818, "Rohit Communications Pte. Ltd." },
    {  7819, "Opensource Consult" },
    {  7820, "Configate Inc." },
    {  7821, "University of Silesia" },
    {  7822, "Athena Security" },
    {  7823, "Clickaction" },
    {  7824, "LG Electronics Inc." },
    {  7825, "Cognizant Technology Solutions" },
    {  7826, "KPNQwest Austria GmbH." },
    {  7827, "Sofadex-Puratos" },
    {  7828, "Commsbloke.com" },
    {  7829, "Axon Digital Design B.V." },
    {  7830, "Service Info-Techno Inc." },
    {  7831, "Dataflex Design Communications Limited" },
    {  7832, "ICSA Labs" },
    {  7833, "daveb.net" },
    {  7834, "Wissenschaftsladen Dortmund e.V." },
    {  7835, "Hope Tranportation" },
    {  7836, "Nuark Co., Ltd." },
    {  7837, "Sumtel Communications, Inc." },
    {  7838, "UTOMI AG" },
    {  7839, "Telia UK Limited" },
    {  7840, "Zelax" },
    {  7841, "Skynet Ltd." },
    {  7842, "Universit\0303\0251 Paris 12 - Val de Marne" },
    {  7843, "Callera Ltd" },
    {  7844, "KGB Entertainment" },
    {  7845, "Cipher" },
    {  7846, "ETRALI" },
    {  7847, "The Evangelical Lutheran Good Samaritan Society" },
    {  7848, "S\0303\0244chsische Staatskanzlei" },
    {  7849, "CommeceOne Auction Services" },
    {  7850, "Penford Corporation" },
    {  7851, "Software Munitions" },
    {  7852, "CyberElves" },
    {  7853, "Teknoids" },
    {  7854, "nazit" },
    {  7855, "ISI-CNR" },
    {  7856, "REALTRONIC" },
    {  7857, "XenoSite" },
    {  7858, "Outcome Technology Associates, Inc." },
    {  7859, "NetMount" },
    {  7860, "Datatone Ltd" },
    {  7861, "U4EA Technologies Ltd." },
    {  7862, "Herrns PC" },
    {  7863, "FreeW3, Inc." },
    {  7864, "Megadot Pty Ltd" },
    {  7865, "Litnet NOC" },
    {  7866, "Corinthian Engineering Pty Ltd" },
    {  7867, "Mailvision" },
    {  7868, "Universite de Sherbrooke" },
    {  7869, "Byzantium Solutions Ltd" },
    {  7870, "Polska Platforma Internetowa" },
    {  7871, "NICsys GbR" },
    {  7872, "Arrista Technologies" },
    {  7873, "Info-Onscreen Software Systems Pty. Ltd." },
    {  7874, "Highland Injection Molding Inc." },
    {  7875, "Shibaura Institute of Technology , Science Information Center" },
    {  7876, "Statens vegvesen" },
    {  7877, "Basefarm AS" },
    {  7878, "The University of the South Pacific" },
    {  7879, "T-TeleSec" },
    {  7880, "Peco II Inc." },
    {  7881, "Cognitas Technologies, Inc." },
    {  7882, "City of Prescott IT Department" },
    {  7883, "amirk.com" },
    {  7884, "Francis W. Parker School" },
    {  7885, "Arek Dreyer" },
    {  7886, "K Application" },
    {  7887, "nCUBE, Corp." },
    {  7888, "Iamba Technologies Ltd." },
    {  7889, "Lingnan University" },
    {  7890, "Arrow Electronics, Inc." },
    {  7891, "Confederation of Norwegian Business and Industry" },
    {  7892, "Lannert.de" },
    {  7893, "Yacom Internet Factory S.A" },
    {  7894, "VanCo.net s.r.o." },
    {  7895, "Amethon Solutions" },
    {  7896, "Rietumu Banka" },
    {  7897, "Knowledge Base BV" },
    {  7898, "Openet Telecom Ltd." },
    {  7899, "Cap Gemini, portugal" },
    {  7900, "Neuberger & Hughes GmbH" },
    {  7901, "Capiro" },
    {  7902, "alberta wellnet" },
    {  7903, "EcoProg Ltd." },
    {  7904, "Greenwich Capital Markets" },
    {  7905, "National Training Institute, Inc." },
    {  7906, "Brainworkers Srl" },
    {  7907, "Alliance Race Car Builders" },
    {  7908, "TelSoft Solutions, Inc" },
    {  7909, "American Communication Technologies International, Inc." },
    {  7910, "CSTS, Inc." },
    {  7911, "Dreamintek Co.,Ltd" },
    {  7912, "Staffware PLC" },
    {  7913, "Space Hellas S.A." },
    {  7914, "qmail-ldap project" },
    {  7915, "Cetevo AB" },
    {  7916, "PAGE" },
    {  7917, "Area de Ciencias de la Computaci\0303\0263n e Inteligencia Artificial" },
    {  7918, "Electrosonic Ltd" },
    {  7919, "Spyn Inc." },
    {  7920, "National Education Association of the United States" },
    {  7921, "AethyrNet Soluitions" },
    {  7922, "Spiro Kommunikation" },
    {  7923, "OrgaNet GmbH" },
    {  7924, "Bundesamt fuer Sicherheit in der Informationstechnik" },
    {  7925, "SPECS GmbH Surface Analysis and Computer Technology" },
    {  7926, "University of Antwerp" },
    {  7927, "Splendid Internet GmbH" },
    {  7928, "Wysdom Inc." },
    {  7929, "HBOS plc" },
    {  7930, "Telecom Argentina" },
    {  7931, "SMCC" },
    {  7932, "AmeriNet, Incorporated" },
    {  7933, "Promise Technology Inc." },
    {  7934, "Shanghai JiaoTong University" },
    {  7935, "IVT" },
    {  7936, "YANGJAE MICRO" },
    {  7937, "inPACT technologies" },
    {  7938, "IEE" },
    {  7939, "Liscon GmbH" },
    {  7940, "Celeritas" },
    {  7941, "Tecnica 6000 S.L." },
    {  7942, "Xtempus" },
    {  7943, "Home Wireless Networks, Inc." },
    {  7944, "PennyLan" },
    {  7945, "UMB Bank, n.a." },
    {  7946, "FlashPoint Technology, Inc." },
    {  7947, "MSP Technolgies" },
    {  7948, "DASIR ENTERPRISES" },
    {  7949, "Broadcloud Communications, Inc." },
    {  7950, "Overture Networks" },
    {  7951, "CNCTC" },
    {  7952, "Too Corporation" },
    {  7953, "Majitek" },
    {  7954, "Siemens Business Services AS" },
    {  7955, "Alfaskop AB" },
    {  7956, "Initio IT-l\0303\0270sninger AS" },
    {  7957, "Lares Technology" },
    {  7958, "Efficient Channel Coding, Inc." },
    {  7959, "Gabriel Roman" },
    {  7960, "FreeRein" },
    {  7961, "Harry L. Styron, Attorney at Law" },
    {  7962, "Not Another Corporation, Inc." },
    {  7963, "Tebie" },
    {  7964, "Master Comunicacao e Marketing Ltda. Cass" },
    {  7965, "Ingenieurbuero Tartsch" },
    {  7966, "SPY internetworking" },
    {  7967, "serveroperator.com (formerly 'Tekbabble')" },
    {  7968, "Spearhead Technologies Ltd." },
    {  7969, "BeComm" },
    {  7970, "Athelon Corporation" },
    {  7971, "T\0303\0270lveguten Lars Bahner" },
    {  7972, "XingTang Communication Technology Co.,Ltd." },
    {  7973, "TELEFONICA DE ESPA\0303\0221A" },
    {  7974, "TURBOMECA" },
    {  7975, "Ark e-Management Ltd." },
    {  7976, "Brotsman & Dreger, Inc." },
    {  7977, "VidSoft GmbH" },
    {  7978, "France Telecom Hosting" },
    {  7979, "Storigen Systems" },
    {  7980, "Sistemas y Aplicaciones de Telecomunicaciones S.A.Jose Luis" },
    {  7981, "Interbind" },
    {  7982, "The Simon Shapiro Foundation" },
    {  7983, "HPEB (Health technology Planning & Evaluation Board)" },
    {  7984, "Ticket Master/CitySearch Corp." },
    {  7985, "University of Catania" },
    {  7986, "ip.access" },
    {  7987, "Universite de Pau et des Pays de l'Adour" },
    {  7988, "Universit\0303\0251 Nancy 2" },
    {  7989, "IMAG" },
    {  7990, "EOI Technologies, Inc." },
    {  7991, "eLaw.com Inc" },
    {  7992, "PRFD" },
    {  7993, "Factorit S.p.A" },
    {  7994, "Continuous Computing Corp." },
    {  7995, "Snell & Wilcox Ltd" },
    {  7996, "Electric Power Research Institute(EPRI)" },
    {  7997, "Ball Corporation" },
    {  7998, "MailFriday" },
    {  7999, "TP Internet" },
    {  8000, "Ipace Inc." },
    {  8001, "Qitek" },
    {  8002, "Metamerge AS" },
    {  8003, "Swisscom IP-Plus" },
    {  8004, "MID GmbH" },
    {  8005, "Physics Department, Queen Mary, University of London" },
    {  8006, "EINSTEINet GmbH" },
    {  8007, "threllis GmbH" },
    {  8008, "Pactolus Communication Software, Inc." },
    {  8009, "iSecuritas" },
    {  8010, "ExaNet" },
    {  8011, "McKee Foods Corporation" },
    {  8012, "Hyperdrive Sistemas Ltda" },
    {  8013, "Nextlevel.com Internet Productions Inc." },
    {  8014, "Stonefly Networks, Inc." },
    {  8015, "Airocon" },
    {  8016, "Ravensbourne College of Design & Communication" },
    {  8017, "Primus Canada" },
    {  8018, "Hogeschool van Arnhem en Nijmegen" },
    {  8019, "The Stellar Ice Company" },
    {  8020, "Ecole Normale Sup\0303\0251rieure de Lyon" },
    {  8021, "G. A. Enterprises" },
    {  8022, "Senets Broadband, Inc." },
    {  8023, "InfoCruiser Inc." },
    {  8024, "QuoVadis Limited" },
    {  8025, "Friendlyworks" },
    {  8026, "Rockbrook Systems Group" },
    {  8027, "binHOST.com, Inc." },
    {  8028, "cast" },
    {  8029, "DCTC" },
    {  8030, "Prakash Cotton Mills Ltd." },
    {  8031, "University Library of Kassel, Germany" },
    {  8032, "Agenda d.o.o." },
    {  8033, "Almende" },
    {  8034, "Rohill Technologies B.V." },
    {  8035, "RY Enterprises" },
    {  8036, "USA.NET" },
    {  8037, "COLOMAR Group, Inc" },
    {  8038, "HomeBase Work Solutions" },
    {  8039, "silly-ants" },
    {  8040, "Thunder Systems, Inc." },
    {  8041, "Hostway Corporation" },
    {  8042, "eCELL Technologies, Inc." },
    {  8043, "ProActiveMonitoring, Inc." },
    {  8044, "M.J. DuChene & Associates" },
    {  8045, "Glen Lewis" },
    {  8046, "Utah Java User Group" },
    {  8047, "OSEDU" },
    {  8048, "Avatar Internet Services" },
    {  8049, "NetAccess, Inc." },
    {  8050, "RISS-Telecom" },
    {  8051, "Michael McCafferty" },
    {  8052, "TesserNet Systems Inc." },
    {  8053, "Islington ave." },
    {  8054, "The Scan Shop Pty. Ltd." },
    {  8055, "Optilink Technologies Company Limited" },
    {  8056, "SHENYANG NEU-ALPINE SOFTWARE CO.,LTD." },
    {  8057, "CESNET" },
    {  8058, "MessageVine" },
    {  8059, "Net To Net Technologies" },
    {  8060, "Armstrong Atlantic State University" },
    {  8061, "Multipoint Communications Ltd" },
    {  8062, "ColorMax Interactive" },
    {  8063, "M@innet Communication Ltd." },
    {  8064, "Global Technology Solutions" },
    {  8065, "Uni-Ter Underwriting Management Corporation" },
    {  8066, "WatchMark Corporation" },
    {  8067, "MCI" },
    {  8068, "Buffalo Rock Company" },
    {  8069, "Rozz Enterprises" },
    {  8070, "ZeroHype Technologies, Inc." },
    {  8071, "Sandstorm Enterprises, Inc." },
    {  8072, "net-snmp" },
    {  8073, "Lumos Technologies Inc" },
    {  8074, "Box Solutions Corporation" },
    {  8075, "Lateral Concepts and Designs" },
    {  8076, "Siemens PSE Austria" },
    {  8077, "ChamberSign France" },
    {  8078, "INU Consultancy" },
    {  8079, "ensoport.com" },
    {  8080, "Fastweb S.p.A." },
    {  8081, "Magnum Solutions Ltd" },
    {  8082, "SEPATON, Inc." },
    {  8083, "Packet Design" },
    {  8084, "tangali.eu.org" },
    {  8085, "IronStream Inc" },
    {  8086, "NUASIS Corporation" },
    {  8087, "TierNext" },
    {  8088, "DCSI" },
    {  8089, "Covad Communications" },
    {  8090, "Enterprise Computing Services" },
    {  8091, "IP Soft, Inc." },
    {  8092, "Elgo Maribor d.o.o." },
    {  8093, "Aliroo Ltd." },
    {  8094, "DreamArts Corp." },
    {  8095, "INELCOM Ingenier\0303\0255a Electr\0303\0263nica Comercial S.A" },
    {  8096, "The Voice Technology Forum" },
    {  8097, "Servicom 2000, S. L." },
    {  8098, "Morat Games Ltd" },
    {  8099, "Alex Wilson Coldstream Ltd" },
    {  8100, "Softricity, Inc." },
    {  8101, "Zambeel, Inc." },
    {  8102, "Mark Morgan Enterprises" },
    {  8103, "Winstechnet Co.,Ltd" },
    {  8104, "Sun Microsystems Professional Services" },
    {  8105, "Appilog" },
    {  8106, "LUXMATE Controls GmbH" },
    {  8107, "Kabira" },
    {  8108, "VHI" },
    {  8109, "Price Express" },
    {  8110, "Message Central plc." },
    {  8111, "Pacific Trade & Technology" },
    {  8112, "Green Shield Canada" },
    {  8113, "Bellanet International Secretariat" },
    {  8114, "Naval Operational Logisitics Support Center" },
    {  8115, "Birch Telecom" },
    {  8116, "Danware Data A/S" },
    {  8117, "NAFEM (North American Association of Food Equipment Manufacturers)" },
    {  8118, "Capitol Systems Corporation" },
    {  8119, "Mission Valley Regional Occupational Program David" },
    {  8120, "Transvirtual Technologies, Inc." },
    {  8121, "Ridgeway Systems & Software Ltd." },
    {  8122, "KB Impuls Service GmbH" },
    {  8123, "Kompetenznetz Maligne Lymphome" },
    {  8124, "Carrefour" },
    {  8125, "Internet Services" },
    {  8126, "My Docs Online, Inc" },
    {  8127, "Effinity Labs" },
    {  8128, "Boco" },
    {  8129, "JadeBird HuaGuang Ltd Co." },
    {  8130, "Heimann Biometric Systems GmbH" },
    {  8131, "Glory Telecom. Co.,Ltd." },
    {  8132, "Nasik Welding Products Pvt.Ltd" },
    {  8133, "FSSC-London" },
    {  8134, "Insitel" },
    {  8135, "Andong National University" },
    {  8136, "Centrul de Pregatire in Informatica" },
    {  8137, "Palisade Systems" },
    {  8138, "De Roeck Software Engineering BVBA" },
    {  8139, "Aaxion Software Corporation" },
    {  8140, "C2 Technologies, Inc." },
    {  8141, "Kashpureff Boling Laboratories, Inc." },
    {  8142, "HCA The Healthcare Company" },
    {  8143, "ICTV" },
    {  8144, "Fiberxon (China) Corp., Ltd" },
    {  8145, "University of Salzburg" },
    {  8146, "Snakegully" },
    {  8147, "Mercury Telecommunications" },
    {  8148, "Niragongo Technologies Ltd." },
    {  8149, "Generalitat Valenciana" },
    {  8150, "SECARON AG" },
    {  8151, "Worldweb.net" },
    {  8152, "Visto Corporation" },
    {  8153, "jGuild Internation ltd" },
    {  8154, "Riser Management Systems" },
    {  8155, "Transcept, Inc." },
    {  8156, "AgencyWorks" },
    {  8157, "SynCom Network, Inc." },
    {  8158, "MSP-LUB" },
    {  8159, "SHIN SATELLITE PUBLIC COMPANY LIMITED. Pho" },
    {  8160, "Digital Platform Support Services" },
    {  8161, "Star Home GMBH" },
    {  8162, "DEXIA" },
    {  8163, "Double D Electronics Ltd" },
    {  8164, "Starent Networks" },
    {  8165, "boutemy.com" },
    {  8166, "Viag Interkom" },
    {  8167, "Transversal" },
    {  8168, "Nectar.com" },
    {  8169, "Carroll Lutheran Village" },
    {  8170, "Monitor Group" },
    {  8171, "Oni Solutions" },
    {  8172, "Johns Hopkins University, MSEL-LCS" },
    {  8173, "INDRA Sistemas" },
    {  8174, "Netburner" },
    {  8175, "Carrier9 Networks" },
    {  8176, "AstroDesign,Inc." },
    {  8177, "HCL Communications" },
    {  8178, "Just Innovative Software GmbH" },
    {  8179, "Communications Laboratories Telekommunikations Dienstleistungs-Ges.m.b.H." },
    {  8180, "Spirea" },
    {  8181, "Commarco GmbH (formerly 'Scholz & Friends Dresden GmbH')" },
    {  8182, "The Boston Bit Co" },
    {  8183, "NetSource America Inc." },
    {  8184, "Inspira S.L." },
    {  8185, "Online Creation, Inc." },
    {  8186, "California Institute of Technology" },
    {  8187, "Sharinga Networks Inc." },
    {  8188, "AXA Technology Services Switzerland AG (formerly 'Winterthur Versicherungen')" },
    {  8189, "Gerichhausen, Adomeit & Terstappen GmbH" },
    {  8190, "3M Deutschland GmbH (formerly 'Quante')" },
    {  8191, "glutam.at" },
    {  8192, "Symbiont Networks, Inc." },
    {  8193, "Telemetry Technologies" },
    {  8194, "Targetnet.com Inc." },
    {  8195, "Effinity Net, LC" },
    {  8196, "Teldar Corporation" },
    {  8197, "LearningSoft Corp." },
    {  8198, "eBuilt, Inc." },
    {  8199, "Instituto Tecnol\0303\0263gico Aut\0303\0263nomo de M\0303\0251xico" },
    {  8200, "UNNATI COMPUTERS" },
    {  8201, "XCelaron Pty Ltd" },
    {  8202, "Toro Assicurazioni S.p.A." },
    {  8203, "LPG Innovations" },
    {  8204, "Cymtec Systems, Inc." },
    {  8205, "Unassigned" },
    {  8206, "Centro Regional de Investigaciones Basicas y Aplicadas de Bahia-Blanca" },
    {  8207, "Integratus, Inc." },
    {  8208, "Best Western International" },
    {  8209, "Informio" },
    {  8210, "Centegy" },
    {  8211, "ShenZhen TCL Communication Technology Co.,Ltd." },
    {  8212, "Harbour Networks Co." },
    {  8213, "Faculty of Medicine, University of Sydney" },
    {  8214, "Atomica" },
    {  8215, "Authentified" },
    {  8216, "Cyzen Tech.,Co.LTD" },
    {  8217, "SLAonline.com Ltd" },
    {  8218, "EC - Erdoelchemie GmbH" },
    {  8219, "Ecomda" },
    {  8220, "TCL Holdings Co., Ltd." },
    {  8221, "BAE SYSTEMS, Integrated Defense Solutions" },
    {  8222, "Matthew White" },
    {  8223, "Atlas Commerce" },
    {  8224, "LeasedMinds" },
    {  8225, "Open Connect AG" },
    {  8226, "GigaNews.com, Inc." },
    {  8227, "CyberObject Corp" },
    {  8228, "Jalan Network Services, Inc." },
    {  8229, "Phil Systems" },
    {  8230, "RING! ROSA Products Bv" },
    {  8231, "Lineo" },
    {  8232, "Fachhochschule Giessen-Friedberg" },
    {  8233, "iBasis, Inc." },
    {  8234, "ECET International" },
    {  8235, "CENIT AG Systemhaus" },
    {  8236, "White Horse Interactive" },
    {  8237, "NCC GmbH" },
    {  8238, "Lutheran Brotherhood" },
    {  8239, "Peribit Networks" },
    {  8240, "Path 1" },
    {  8241, "Securant Technologies" },
    {  8242, "Security Portal, Inc" },
    {  8243, "iPass, Inc." },
    {  8244, "Brocade Communications Systems, Inc. (formerly 'McDATA Corp.')" },
    {  8245, "Vsovt Ltd." },
    {  8246, "Cistron Internet Services" },
    {  8247, "University of Rostock" },
    {  8248, "Turin Networks Inc" },
    {  8249, "Verein f\0303\0274r Computergenealogie e.V." },
    {  8250, "Shire.Net LLC" },
    {  8251, "IIGA Co.,Ltd." },
    {  8252, "Digital Strategies, Inc." },
    {  8253, "AWOLart.com" },
    {  8254, "Aleph-Null, Inc." },
    {  8255, "Tejas Networks" },
    {  8256, "Solution - The Computer People eK" },
    {  8257, "Southern Ural State University" },
    {  8258, "kuk-Systemprogrammierung" },
    {  8259, "Banco de Sabadell, S.A." },
    {  8260, "Intrexa Corp" },
    {  8261, "MediaCast" },
    {  8262, "Wavion" },
    {  8263, "Jamby BV" },
    {  8264, "Recreativos Franco, S.A." },
    {  8265, "Entrada Networks, Inc." },
    {  8266, "Intelnet S.A." },
    {  8267, "Arula Systems" },
    {  8268, "Mark Tippetts" },
    {  8269, "CJSC Malva" },
    {  8270, "MJL Technology" },
    {  8271, "Fachhochschule Vorarlberg" },
    {  8272, "Nameplanet Ltd." },
    {  8273, "Standard Communications" },
    {  8274, "Interadnet" },
    {  8275, "INSA Toulouse" },
    {  8276, "Mpathix" },
    {  8277, "PSC-ITSolutions.NET" },
    {  8278, "St. Elisabeth GmbH" },
    {  8279, "f3pu5.net" },
    {  8280, "Fiver LightCom Co., Ltd." },
    {  8281, "Movelife" },
    {  8282, "BAE Systems Defence Pty Ltd (formerly 'Tenix Defence Systems - Systems Adelaide')" },
    {  8283, "TSMT - Magic Touch Ltd" },
    {  8284, "ACTL" },
    {  8285, "FlexLight" },
    {  8286, "Incirco" },
    {  8287, "Klinikum der Johannes Gutenberg-Universit\0303\0244t Mainz" },
    {  8288, "Jung von Matt Werbeagentur GmbH" },
    {  8289, "Universita' degli Studi di Napoli \"Federico II\"" },
    {  8290, "Certus Technology, Inc." },
    {  8291, "DigiStamp, Inc." },
    {  8292, "Mt. Holyoke College" },
    {  8293, "Bang Networks, Inc." },
    {  8294, "infoman" },
    {  8295, "BWA" },
    {  8296, "Dialogos3 s.r.l." },
    {  8297, "IrisOnLine.com BV" },
    {  8298, "v/h Nictoglobe" },
    {  8299, "secunet Security Networks AG" },
    {  8300, "State of Wisconsin - Security and Directory Services" },
    {  8301, "Technische Universitaet Darmstadt" },
    {  8302, "EdeNET Communications, Inc." },
    {  8303, "Gelco Information Network" },
    {  8304, "Atomic Blue Bear" },
    {  8305, "OARnet" },
    {  8306, "Go Local Consulting, Inc." },
    {  8307, "tecnetdev" },
    {  8308, "GTran Inc." },
    {  8309, "Virtela Communications" },
    {  8310, "Trak Systems" },
    {  8311, "Police Information Technology Organization" },
    {  8312, "OskolNET JSC" },
    {  8313, "JARDiX AG" },
    {  8314, "AVL Emission Test Systems GmbH (formerly 'PEUS Systems GmbH')" },
    {  8315, "Minacom Labs Inc." },
    {  8316, "Staffwell" },
    {  8317, "FiberCycle Networks" },
    {  8318, "Twisted Pair Solutions, Inc." },
    {  8319, "Blue Wave Systems" },
    {  8320, "Vonova Corporation" },
    {  8321, "Entidad Acreditadora Ley 19.799 - Gobierno de Chile" },
    {  8322, "Education Networks of America" },
    {  8323, "Gemteq Software" },
    {  8324, "The University of Western Australia" },
    {  8325, "Wanadoo Spain" },
    {  8326, "Unreal Technology spol. s r.o." },
    {  8327, "IUFM Reims" },
    {  8328, "GyD Iberica" },
    {  8329, "iPromoGroup Ltd." },
    {  8330, "Omnexus N.V., Amsterdam, W\0303\0244denswil Branch" },
    {  8331, "Matti Valtuustoon" },
    {  8332, "universit\0303\0251 d'Evry Val d'Essonne" },
    {  8333, "GROW.co,.Ltd" },
    {  8334, "dynamicsoft Inc." },
    {  8335, "Universit\0303\0251 des Sciences Sociales de Toulouse" },
    {  8336, "Superior Consultant Holdings Corporation" },
    {  8337, "Hybricon Corp." },
    {  8338, "Phonetics, Inc." },
    {  8339, "Young & Laramore" },
    {  8340, "Image Computing Incorporated" },
    {  8341, "Utility Data Systems, Inc." },
    {  8342, "NTRU Cryptosystems" },
    {  8343, "NEXTRA Czech Republic s.r.o." },
    {  8344, "Apparate Networks" },
    {  8345, "Health Net, Inc." },
    {  8346, "Universit\0303\0251 de Limoges - S.C.I. - Laine Jean" },
    {  8347, "TechnoCage, Inc" },
    {  8348, "Data Avenue, Inc." },
    {  8349, "ConnectScape, Inc." },
    {  8350, "T-Systems Hungary Kft." },
    {  8351, "I-Land Internet Services" },
    {  8352, "Pronym S.A.R.L." },
    {  8353, "Excelsior Systems Limited" },
    {  8354, "GIB" },
    {  8355, "sarfata's net" },
    {  8356, "Visual Revolutions" },
    {  8357, "Mangosoft Corporation" },
    {  8358, "TELOS Technology Inc." },
    {  8359, "IP blue" },
    {  8360, "Mirant Corporation" },
    {  8361, "Portail des IUFM" },
    {  8362, "mSAFE" },
    {  8363, "Store-O-Matic, Inc." },
    {  8364, "Lichen Hosting" },
    {  8365, "Advanced Information Management Solutions Pty Ltd" },
    {  8366, "Fiberlink Communications Corp" },
    {  8367, "NationNet.Com" },
    {  8368, "ServerWerks Inc" },
    {  8369, "NTIkorea" },
    {  8370, "NextSet" },
    {  8371, "AGENDA" },
    {  8372, "University of Sussex" },
    {  8373, "SEAL Systems AG & Co. KG" },
    {  8374, "DVZ Datenverarbeitungszentrum Mecklenburg-Vorpommern" },
    {  8375, "Outercurve Technologies" },
    {  8376, "Universit\0303\0251 de Bourgogne" },
    {  8377, "ReefEdge, Inc." },
    {  8378, "Texas Memory Systems" },
    {  8379, "BroadRiver Communications" },
    {  8380, "Mentum Group" },
    {  8381, "Certainty Solutions, Inc." },
    {  8382, "C&C Engineering, Inc." },
    {  8383, "SigmaSoft, Inc." },
    {  8384, "eBay, Inc." },
    {  8385, "ENSAM CER de Metz" },
    {  8386, "LION bioscience AG" },
    {  8387, "Globe Internet s.r.o." },
    {  8388, "Techniker Krankenkasse" },
    {  8389, "Ergon Informatik" },
    {  8390, "Mettler Toledo" },
    {  8391, "Bicman Netologies" },
    {  8392, "XMission" },
    {  8393, "GIMAS mbH" },
    {  8394, "Privador AS" },
    {  8395, "Tulane University" },
    {  8396, "virtual earth Gesellschaft f\0303\0274r Wissens re/pr\0303\0244 sentation mbH" },
    {  8397, "Vecerina" },
    {  8398, "University of West Florida" },
    {  8399, "iVEA Technologies" },
    {  8400, "Evercom Systems, Inc." },
    {  8401, "FoxTravel" },
    {  8402, "ePlus, Inc." },
    {  8403, "ARA Network Technologies, Co, Ltd." },
    {  8404, "Akamba Corporation" },
    {  8405, "Tohono Consulting" },
    {  8406, "Morningstar Systems, Inc." },
    {  8407, "MyBau.Com" },
    {  8408, "InterComponentWare AG" },
    {  8409, "ztevision" },
    {  8410, "Landis & Gyr Communications SAS" },
    {  8411, "e-Qual" },
    {  8412, "Satyam Computer Services ltd" },
    {  8413, "GlobalNaps" },
    {  8414, "Cedacri S.p.A." },
    {  8415, "CyberElan LLC" },
    {  8416, "Shaw Cablesystems, G.P." },
    {  8417, "StorageApps, Inc." },
    {  8418, "listless ennui" },
    {  8419, "Rockwell Collins" },
    {  8420, "Digi-Sign Certification Services Limited" },
    {  8421, "VODTEL COMMUNICATIONS Inc." },
    {  8422, "Libritas, Inc" },
    {  8423, "twisd AG" },
    {  8424, "ICUBE SRL" },
    {  8425, "AP Engines, Inc." },
    {  8426, "Watlow" },
    {  8427, "Worldgate Networks Private Limited" },
    {  8428, "Turtle Entertainment GmbH" },
    {  8429, "2NETFX (Media Now, Inc.DBA 2NETFX)" },
    {  8430, "TranSwitch Corporation" },
    {  8431, "Broadcasting Interest Enterprise, Inc.Christopher" },
    {  8432, "TeraGlobal Communications" },
    {  8433, "3e Technologies International Inc." },
    {  8434, "Fox Chase Cancer Center" },
    {  8435, "HyperEdge Inc." },
    {  8436, "Requisite Technology" },
    {  8437, "Bolder Internet Group, Inc." },
    {  8438, "ReFlex Communications, Inc." },
    {  8439, "CADRE Design" },
    {  8440, "Tsuda College" },
    {  8441, "ShangHai WaiGaoQiao Free Trade Zone network development Co.,Ltd" },
    {  8442, "Sendtek Corporation" },
    {  8443, "Telisma" },
    {  8444, "IIE (Institut d'Informatique d'Entreprise)" },
    {  8445, "Bilstone Ltd" },
    {  8446, "Barclaycard" },
    {  8447, "Riverglade Consultants Ltd" },
    {  8448, "Avantis GmbH" },
    {  8449, "ePUREDATA Inc." },
    {  8450, "Cetacean Networks" },
    {  8451, "Petri Laitinen" },
    {  8452, "Guernsey.Net Ltd." },
    {  8453, "npw.net" },
    {  8454, "Donald E Reynolds" },
    {  8455, "Old Donkey Enterprises" },
    {  8456, "OPTIBASE" },
    {  8457, "Deepend Prague" },
    {  8458, "ZOOM Networks Inc." },
    {  8459, "Shandong WeiFang Beida JadeBird Inc." },
    {  8460, "University of Illinois at Chicago" },
    {  8461, "UFO Solutions Limited" },
    {  8462, "Sonic.Net, Inc." },
    {  8463, "PEM Electronics" },
    {  8464, "University of Wollongong IEEE Student Branch" },
    {  8465, "LodeSoft Corp." },
    {  8466, "RAWK Systems, Inc." },
    {  8467, "La Page Trad" },
    {  8468, "American Medical Association" },
    {  8469, "Domestic WANs" },
    {  8470, "Learning Machines, Inc." },
    {  8471, "Universidad Del Bio-Bio" },
    {  8472, "Lynk a division of BOS Ltd" },
    {  8473, "University of Massachusetts Amherst" },
    {  8474, "Saltec Powerlink" },
    {  8475, "Veilex" },
    {  8476, "Kyuden Infocom Company, Inc." },
    {  8477, "CyberTron Software GmbH" },
    {  8478, "TongTech CO., Ltd," },
    {  8479, "now.com" },
    {  8480, "Fairleigh Dickinson University" },
    {  8481, "HiGHKU" },
    {  8482, "Colorado State University" },
    {  8483, "Trenza, Corp" },
    {  8484, "Allegheny Energy" },
    {  8485, "Virtual Software, S.L." },
    {  8486, "City-Net Tech. Inc." },
    {  8487, "MightyView, Inc." },
    {  8488, "University of Alabama" },
    {  8489, "Pico Technology Ltd" },
    {  8490, "Direct Commerce" },
    {  8491, "drzyzgula.org" },
    {  8492, "Iscanet Internet Services" },
    {  8493, "Web Office China" },
    {  8494, "MOSAIC SOFTWARE AG" },
    {  8495, "MILESYS" },
    {  8496, "Facilitair bedrijf, Hogeschool van Utrecht" },
    {  8497, "Deluxe Video Services Ltd" },
    {  8498, "Akumiitti Ltd" },
    {  8499, "Eduserv" },
    {  8500, "Dr. Nagler & Cie. Consult GmbH" },
    {  8501, "ANTEL - Operations" },
    {  8502, "Internet Park, Inc." },
    {  8503, "Unicess Networks" },
    {  8504, "Sparzo Enterprises" },
    {  8505, "SKYTEC AG" },
    {  8506, "Ximian, Inc." },
    {  8507, "CyberTrails, LLC" },
    {  8508, "Final Piece" },
    {  8509, "ViNAWARA Co.,Ltd." },
    {  8510, "Yunbj Co.,Ltd." },
    {  8511, "ThoughtWorks, Inc." },
    {  8512, "Capgemini Telecom Media & Networks Sweden AB" },
    {  8513, "Katelco" },
    {  8514, "Sonocomp GmbH" },
    {  8515, "Deonet Co., Ltd." },
    {  8516, "Proxion Org" },
    {  8517, "APL/Software" },
    {  8518, "JGiovatto" },
    {  8519, "Trevalon, Inc." },
    {  8520, "Winterlink Inc" },
    {  8521, "Bytemobile, Inc." },
    {  8522, "Machinebuilt Software, Inc." },
    {  8523, "Petrasoft Inc" },
    {  8524, "Cybercafe" },
    {  8525, "Paula's Home Creations" },
    {  8526, "Consiglio Nazionale del Notariato" },
    {  8527, "Harvard MIT Data Center" },
    {  8528, "HeyAnita Inc." },
    {  8529, "Salira Optical Network Systems, Inc." },
    {  8530, "MomsDesk Commerce Corporation" },
    {  8531, "SyncWorks" },
    {  8532, "NANYA Technology Corp." },
    {  8533, "Snapshield" },
    {  8534, "HiHat Enterprise Solutions" },
    {  8535, "Nekhem Technologies" },
    {  8536, "Datachorus" },
    {  8537, "Turbo NetWorks Co., Ltd." },
    {  8538, "Saxonia Systems AG" },
    {  8539, "Institute \"Norilskproject\"" },
    {  8540, "LCPC" },
    {  8541, "Interactive Media S.r.l." },
    {  8542, "Sandial Systems, Inc." },
    {  8543, "Global TeleLink Services, Inc." },
    {  8544, "SmallBuddha.org" },
    {  8545, "HTL Steyr" },
    {  8546, "Coleebris" },
    {  8547, "Mississippi State University" },
    {  8548, "South Suburban College" },
    {  8549, "Cylant Technology" },
    {  8550, "Hatteras Networks" },
    {  8551, "Yotta Networks, Inc" },
    {  8552, "TechTracker.com" },
    {  8553, "Subtheory" },
    {  8554, "Departement Elektrotechnik, ETH Zuerich" },
    {  8555, "Digitalwave, Inc" },
    {  8556, "Bank MENATEP SPb, Samara" },
    {  8557, "Globaloop Ltd." },
    {  8558, "Gimnazija Bezigrad Ljubljana" },
    {  8559, "Coconut" },
    {  8560, "Cleverlance s.r.o." },
    {  8561, "Hotsip" },
    {  8562, "Platinet Communications" },
    {  8563, "SSE" },
    {  8564, "CTI2" },
    {  8565, "Medical Research Laboratories" },
    {  8566, "Lasse Hiller\0303\0270e Petersen" },
    {  8567, "Active Power, Inc." },
    {  8568, "VirtualTek Corporation" },
    {  8569, "iXON" },
    {  8570, "Enonic" },
    {  8571, "ConnectSuite" },
    {  8572, "TDS Informationstechnologie AG" },
    {  8573, "S4i" },
    {  8574, "SEAS LLC" },
    {  8575, "ManageIT Company" },
    {  8576, "Flowstone, Inc." },
    {  8577, "Axiowave Networks" },
    {  8578, "People.Com, Inc," },
    {  8579, "Operadora Protel, SA de CV" },
    {  8580, "Tellme Networks, Inc." },
    {  8581, "Oy Comsel System Ab Kristian" },
    {  8582, "Netgene Tech. Inc." },
    {  8583, "Kabelfoon BV" },
    {  8584, "Sorbonne" },
    {  8585, "MEDAV Digitale Signalverarbeitung GmbH" },
    {  8586, "MODCOMP GmbH" },
    {  8587, "WiredMinds Informationssysteme GmbH" },
    {  8588, "Munich Re Insurance AG" },
    {  8589, "Framesoft AG Software Applications" },
    {  8590, "Okena, Inc." },
    {  8591, "ManSoft" },
    {  8592, "CGI" },
    {  8593, "WebTone Technologies" },
    {  8594, "Telia eTelia A/S" },
    {  8595, "HITRON Technology, Inc." },
    {  8596, "NEUSOFT CO.,LTD" },
    {  8597, "Access Solutions International Corporation" },
    {  8598, "Digital Diagnostic Imaging" },
    {  8599, "Velankani Information Systems Ltd." },
    {  8600, "Linux Generation B.V." },
    {  8601, "BellSouth Customer Technologies" },
    {  8602, "Qarana Solutions" },
    {  8603, "Flarion Technologies" },
    {  8604, "Leapfrog Technologies LLC" },
    {  8605, "Wireless Knowledge" },
    {  8606, "Vancouver School District # 37" },
    {  8607, "Portland Internetworks" },
    {  8608, "Cini Systems" },
    {  8609, "Newsradar Deutschland" },
    {  8610, "Snmp Everywhere" },
    {  8611, "VSoft" },
    {  8612, "Toe Technology Company Limited" },
    {  8613, "HealthNetwork Systems" },
    {  8614, "Roxen Internet Software" },
    {  8615, "BioWare Corp." },
    {  8616, "Witt Family" },
    {  8617, "ATYF" },
    {  8618, "iProperty.com" },
    {  8619, "David Hopwood Network Security" },
    {  8620, "AKO" },
    {  8621, "Excido Pty Ltd" },
    {  8622, "Satyam Infoway Limited" },
    {  8623, "RadioMobil a.s." },
    {  8624, "Denis Neuhart Computing" },
    {  8625, "The Lifetime Healthcare Companies" },
    {  8626, "Club Internet" },
    {  8627, "Ailis" },
    {  8628, "Arkoon Network Security" },
    {  8629, "Fireclick" },
    {  8630, "MPI tech" },
    {  8631, "MeshNetworks, Inc." },
    {  8632, "Winphoria Networks" },
    {  8633, "Atmos Energy Corporation" },
    {  8634, "The ZaneRay Group, Inc." },
    {  8635, "Rob Semenoff Enterprises" },
    {  8636, "Planet Pratt" },
    {  8637, "Amphus, Inc." },
    {  8638, "RouteScience Technologies, Inc." },
    {  8639, "Polytrust AB" },
    {  8640, "Santam Limited" },
    {  8641, "7441.com" },
    {  8642, "EnderUNIX" },
    {  8643, "The Math Forum" },
    {  8644, "Anoto" },
    {  8645, "InfiniSwitch Corporation" },
    {  8646, "Scottish Qualifications Authority" },
    {  8647, "Winbox.com" },
    {  8648, "Renaissance Technologies Corp." },
    {  8649, "Pinnacle Technology, Inc." },
    {  8650, "Apriva, Inc." },
    {  8651, "Heart Institute (InCor), University of S\0303\0243o Paulo Medical School" },
    {  8652, "Uppsala University" },
    {  8653, "unassigned" },
    {  8654, "INTRINsec" },
    {  8655, "Apcentric Limited" },
    {  8656, "DCM Online Limited" },
    {  8657, "Hochschulrechenzentrum, Fachhochschule fuer Wirtschaft und Technik(FHTW) Berlin" },
    {  8658, "Empresa Nacional de Certificacion Electronica" },
    {  8659, "Asia e-publications Ltd." },
    {  8660, "Telaid" },
    {  8661, "University of Utah College of Engineering CADE Lab" },
    {  8662, "University of Louisville" },
    {  8663, "Bermuda Triangle Services Ltd" },
    {  8664, "Akeena, Inc." },
    {  8665, "Bruce Technical Services" },
    {  8666, "FirstPeer" },
    {  8667, "Textme.org Ltd" },
    {  8668, "Eli Lilly and Company" },
    {  8669, "Teracom Telecomunica\0303\0247\0303\0265es Ltda" },
    {  8670, "Polyester Media" },
    {  8671, "ETI" },
    {  8672, "Farmers Insurance" },
    {  8673, "Borderware Technologies Inc." },
    {  8674, "Java Secure" },
    {  8675, "Autodesk, Inc." },
    {  8676, "Transparent" },
    {  8677, "ISDN-Net, Inc." },
    {  8678, "Intrusion.com" },
    {  8679, "Atlas Copco Airpower" },
    {  8680, "Open Roads Consulting Inc." },
    {  8681, "Free Speech Media LLC" },
    {  8682, "UltraSecure.com" },
    {  8683, "Integrity Systems Ltd." },
    {  8684, "frd.net" },
    {  8685, "Habeebee" },
    {  8686, "Personal Evaluation" },
    {  8687, "Milestone R/D Labs" },
    {  8688, "Shepherd-Express" },
    {  8689, "Miller Simon McGinn and Clark" },
    {  8690, "IPAGEON Co.Ltd" },
    {  8691, "Moxa Technologies Co., Ltd." },
    {  8692, "Network Programs" },
    {  8693, "A-xell Wireless AB (formerly 'Avitec AB')" },
    {  8694, "University of Wolverhampton" },
    {  8695, "Mission Data" },
    {  8696, "myCustoms" },
    {  8697, "Raiffeisen Informatik GmbH" },
    {  8698, "Viasat, Inc." },
    {  8699, "iWay Software" },
    {  8700, "World Savings" },
    {  8701, "Intelligent Information Systems" },
    {  8702, "Noncyclic Networks" },
    {  8703, "Voyus Canada Inc." },
    {  8704, "Sakhalinsvyaz JSC" },
    {  8705, "Israel Local Authorities Data Processing Center LTD" },
    {  8706, "Unassigned" },
    {  8707, "SpiderNet Services Ltd" },
    {  8708, "Lumentis AB" },
    {  8709, "Landesamt f\0303\0274r Besoldung und Versorgung NRW" },
    {  8710, "Envoy Networks" },
    {  8711, "THALES Broadcast & Multimedia" },
    {  8712, "LANcope, Inc." },
    {  8713, "Abako Media Oy" },
    {  8714, "iNOC, Inc." },
    {  8715, "Health Sciences Centre" },
    {  8716, "Triveni Digital, Inc." },
    {  8717, "David Mistretta" },
    {  8718, "Gwent Consultancy" },
    {  8719, "Raviant Networks, Inc." },
    {  8720, "Zack Systems, Inc." },
    {  8721, "Ingram Technology Limited" },
    {  8722, "etoolbelt.net" },
    {  8723, "Integrated Data Pty Ltd" },
    {  8724, "Human Technology" },
    {  8725, "Canberra Institute of Technology" },
    {  8726, "Incisive Designs" },
    {  8727, "Torry Harris Business Solutions Thirunavukarasu" },
    {  8728, "Computer Network Information Center, Chinese Academy of Sciences" },
    {  8729, "LETEK Communications, Inc." },
    {  8730, "Serck Controls Ltd." },
    {  8731, "Pantor Engineering AB" },
    {  8732, "Tokyo Institute of Technology" },
    {  8733, "Ambient Computing, Inc." },
    {  8734, "Matthias Wimmer" },
    {  8735, "Quark Inc." },
    {  8736, "MetaVector Technologies" },
    {  8737, "SecureNet GmbH - Intranet & Internet Solutions" },
    {  8738, "Pirelli Informatica S.p.A." },
    {  8739, "KAPTECH" },
    {  8740, "KOM Networks" },
    {  8741, "SonicWALL, Inc." },
    {  8742, "Alphion" },
    {  8743, "RadioFrame Networks" },
    {  8744, "Colubris Networks Inc." },
    {  8745, "Inform\0303\0241tica para todos, SA de CV" },
    {  8746, "Queensland University of Technology" },
    {  8747, "Libelle AG" },
    {  8748, "LOQUENDO SpA" },
    {  8749, "TELCOM ITALIA LAB" },
    {  8750, "Bucknell University" },
    {  8751, "Geodesic Systems" },
    {  8752, "Kernel" },
    {  8753, "Dataflow Alaska, Inc." },
    {  8754, "XouL" },
    {  8755, "Hebrew University Computation Center" },
    {  8756, "Celltick" },
    {  8757, "Feather Mobile Systems" },
    {  8758, "Walnut Concepts" },
    {  8759, "LG Innotek Co., Ltd." },
    {  8760, "NEITech" },
    {  8761, "Zavod za varnostne tehnologije informacijske druzbe in elektronsko" },
    {  8762, "SI-CA" },
    {  8763, "eIQnetworks" },
    {  8764, "KB Electronics Ltd" },
    {  8765, "Telesoft Technologies Ltd" },
    {  8766, "Elsag S.p.A." },
    {  8767, "Bayour.COM" },
    {  8768, "Nevion (formerly 'Network Electronics')" },
    {  8769, "TeraOptic Networks, Inc." },
    {  8770, "The Emerginggroup Group" },
    {  8771, "ARCANVS, Inc." },
    {  8772, "e-Manufacturing Networks Inc." },
    {  8773, "CHINA TEXTILE NETWORK CO.,LTD." },
    {  8774, "Universal Scientific Industrial Co., Ltd." },
    {  8775, "BeST (Business Execution-Solutions & Technology) Dave" },
    {  8776, "Zman Tikshuv" },
    {  8777, "aQute" },
    {  8778, "SYAC" },
    {  8779, "Telespazio" },
    {  8780, "ip-connect GmbH" },
    {  8781, "ChamberSign" },
    {  8782, "Keutel" },
    {  8783, "akella.org" },
    {  8784, "BroadQuay Consultancy Ltd." },
    {  8785, "Guay Internet" },
    {  8786, "SecureOps Inc." },
    {  8787, "Ivrnet Inc." },
    {  8788, "CyberGate Internet Services" },
    {  8789, "PreNet Corporation" },
    {  8790, "Prisa Networks" },
    {  8791, "ivv GmbH" },
    {  8792, "Axes India Ltd" },
    {  8793, "Realize IT GmbH" },
    {  8794, "eYak Inc." },
    {  8795, "Inteliguard" },
    {  8796, "Gestion del Conocimiento S.A. Miquel" },
    {  8797, "Mannesmann Arcor AG & Co" },
    {  8798, "IT-Management & Solution GmbH" },
    {  8799, "cypherOptics" },
    {  8800, "YH Consulting" },
    {  8801, "SenaReider" },
    {  8802, "Yehti, Inc." },
    {  8803, "Thuridion" },
    {  8804, "Kirana Networks" },
    {  8805, "Kessler-Huron Computer Systems" },
    {  8806, "Gluon Networks" },
    {  8807, "Finestra Software" },
    {  8808, "Xi'an Xinli Network System Technology Co.,Ltd" },
    {  8809, "Tomorrow Software" },
    {  8810, "Artigas Computer" },
    {  8811, "Prompt2U" },
    {  8812, "ITBS OnLine" },
    {  8813, "Skyline Communications" },
    {  8814, "Funcom NV" },
    {  8815, "Collectively Sharper" },
    {  8816, "getyourcar AG" },
    {  8817, "Websemantix" },
    {  8818, "SandCherry Networks, Inc." },
    {  8819, "Raytion" },
    {  8820, "sysTime-solutions AG" },
    {  8821, "Phi Kappa Theta Fraternity - Gamma Tau Chapter" },
    {  8822, "Linuxcare, Inc." },
    {  8823, "I.NET S.p.A." },
    {  8824, "Wizzy" },
    {  8825, "DNX Communications" },
    {  8826, "ComNet Software Specialists,Inc" },
    {  8827, "Nu-kote International" },
    {  8828, "General Dynamics - Mission Systems" },
    {  8829, "Axell Wireless Limited (formerly 'Aerial Facilities Limited')" },
    {  8830, "Xyphius Solutions Inc." },
    {  8831, "Agora Systems Ltd" },
    {  8832, "Ecominds Ltd" },
    {  8833, "ISPMan" },
    {  8834, "Cognet Corp." },
    {  8835, "Wizard Productions" },
    {  8836, "AUUG Incorporated" },
    {  8837, "AscenVision" },
    {  8838, "ACS Internet, Inc." },
    {  8839, "Microtest" },
    {  8840, "MBridge Systems Inc." },
    {  8841, "InterCom International Communications Ltd." },
    {  8842, "Clockwork Web" },
    {  8843, "INACCESS NETWORKS SA" },
    {  8844, "Diveo Broadband Networks" },
    {  8845, "Enablence USA FTTX Networks Inc (formerly 'wave7optics')" },
    {  8846, "Caramail" },
    {  8847, "Pivotech Systems, Inc" },
    {  8848, "Rootroute Research" },
    {  8849, "LPMD.ORG" },
    {  8850, "Cyradis Technology Group Inc." },
    {  8851, "Ultra Enterprises" },
    {  8852, "AARNet Pty Ltd" },
    {  8853, "A-Trust" },
    {  8854, "INTENS IT" },
    {  8855, "Intelsis Sistemas Inteligentes S.A. Cesar" },
    {  8856, "IdecNet SA" },
    {  8857, "Nauticus Networks Inc." },
    {  8858, "destef.com Software" },
    {  8859, "Private Business Inc." },
    {  8860, "Holcim Group Support Ltd." },
    {  8861, "Secorvo Security Consulting GmbH" },
    {  8862, "AppWired, Inc." },
    {  8863, "Etiers International Inc" },
    {  8864, "Dystopium.com" },
    {  8865, "FAST Search and Transfer" },
    {  8866, "GeoTEC Internet" },
    {  8867, "StoreAge Networking Technologies" },
    {  8868, "Velos, Inc." },
    {  8869, "Coscend Corporation" },
    {  8870, "KINS(Knowlege and Information Net for Sharing) Lab." },
    {  8871, "Porthole Interactive Technologies" },
    {  8872, "Saintjo" },
    {  8873, "JAL INFORMATION TECHNOLOGY CO.,LTD." },
    {  8874, "Utt Technologies" },
    {  8875, "Columbitech AB" },
    {  8876, "willeke.com" },
    {  8877, "Suntail" },
    {  8878, "Firmenich SA" },
    {  8879, "Zetac Limited" },
    {  8880, "IDENTEC Solutions AG" },
    {  8881, "Trust Italia S.p.a." },
    {  8882, "Empower Interactive Group Limited" },
    {  8883, "Moonlight Systems" },
    {  8884, "Versant Corporation" },
    {  8885, "Internet Security One Ltd." },
    {  8886, "Beijing Raisecom Scientific & Technology Development Co., Ltd." },
    {  8887, "VASoft (Pty) Ltd." },
    {  8888, "WEBGSM" },
    {  8889, "virtual solution AG" },
    {  8890, "Broadcast Technology Limited" },
    {  8891, "sforce.org" },
    {  8892, "Chaman Productions" },
    {  8893, "Mobilitec" },
    {  8894, "Rivermen AB" },
    {  8895, "Information Systems Consulting (Insyc)" },
    {  8896, "Sistematica" },
    {  8897, "Alltel Information Services" },
    {  8898, "Weavers Network Consulting" },
    {  8899, "The McGraw-Hill Companies" },
    {  8900, "Intellitactics" },
    {  8901, "Monkeybagel Hardware Solutions" },
    {  8902, "GeoTEC Internet" },
    {  8903, "NetNearU CorporateTAM" },
    {  8904, "Cooper Industries" },
    {  8905, "HuntCorp Enterprises" },
    {  8906, "Solnet Pty Ltd" },
    {  8907, "GE CompuNet Computer AG & Co. oHG" },
    {  8908, "Belgacom NV of public Law" },
    {  8909, "DICA Technologies AG" },
    {  8910, "Meitner - Solu\0303\0247\0303\0265es Internet e Sistemas de Informa\0303\0247\0303\0243o, Lda" },
    {  8911, "Appelsiini Finland Oy" },
    {  8912, "Alice's Registry, Inc." },
    {  8913, "Federal Linux Systems" },
    {  8914, "Galderma Laboratories L.P." },
    {  8915, "Ralf Bensmann" },
    {  8916, "Infogate Online" },
    {  8917, "Strelitzia Be" },
    {  8918, "J-PHONE EAST CO.,LTD." },
    {  8919, "Huysmans en Kuypers Automatiseringsburo" },
    {  8920, "Bamboo MediaCasting" },
    {  8921, "Nice Work Textile Corp.Ltd" },
    {  8922, "RESI Informatica S.r.l." },
    {  8923, "Keyware" },
    {  8924, "Inforad - Com. Serv Ltda." },
    {  8925, "Transora" },
    {  8926, "VIP Switch Inc." },
    {  8927, "Paceline Systems Corporation" },
    {  8928, "Asta Networks" },
    {  8929, "Dominion Electronics Pty Ltd" },
    {  8930, "Pelago Networks" },
    {  8931, "Cordell, Inc" },
    {  8932, "WaterWare Internet Services, Inc." },
    {  8933, "Wokup" },
    {  8934, "b-process" },
    {  8935, "Wisdom Assen BV" },
    {  8936, "WebToGrid" },
    {  8937, "Thirdspace Living Ltd" },
    {  8938, "Cyberell Oy" },
    {  8939, "Frontec netSolution AB" },
    {  8940, "SAVVIS Communications" },
    {  8941, "JC Enterprises" },
    {  8942, "AMX Corp" },
    {  8943, "Analog Design Autoamtion Inc." },
    {  8944, "Obfuscated Networking" },
    {  8945, "In-Q-Tel Inc." },
    {  8946, "ThinAirApps" },
    {  8947, "Viacore, Inc." },
    {  8948, "A S Promotions LTD" },
    {  8949, "OuterSpace Consultants" },
    {  8950, "webBASIS, Inc." },
    {  8951, "Platys Communications" },
    {  8952, "JSC Belsvyaz" },
    {  8953, "MightySun LLC" },
    {  8954, "VTEX Typesetting Services" },
    {  8955, "GORGY TIMING" },
    {  8956, "ZICOM Electronic Security Systems Ltd." },
    {  8957, "Railinfrabeheer BV" },
    {  8958, "James A. Mahlen & Associates" },
    {  8959, "IER Incorporated" },
    {  8960, "Coree Networks Inc." },
    {  8961, "Paradigm Secure Communications" },
    {  8962, "IntruVert Networks, Inc." },
    {  8963, "Advanced Web Communication, division of Xecom, Incorporated" },
    {  8964, "Bezirksregierung Duesseldorf" },
    {  8965, "Dff Internet & Medien" },
    {  8966, "PurOptix" },
    {  8967, "NASA JSC" },
    {  8968, "Juha Saarinen IT Writer" },
    {  8969, "Rio Tinto" },
    {  8970, "Argogroup Interactive Ltd" },
    {  8971, "Speed to Market Engines" },
    {  8972, "IP Powerhouse Ltd." },
    {  8973, "Grupo Eurociber S.A." },
    {  8974, "Universitaet Marburg" },
    {  8975, "Soluzione Script GmbH" },
    {  8976, "Airia, Inc." },
    {  8977, "Synamics Inc." },
    {  8978, "Sears Holdings Corp" },
    {  8979, "The Real Asset Company Limited" },
    {  8980, "Collective Technologies" },
    {  8981, "Joeunsecurity" },
    {  8982, "Ipertrade s.r.l." },
    {  8983, "Bivio Networks" },
    {  8984, "C J SPAANS" },
    {  8985, "The Synaptic Group, Inc." },
    {  8986, "Arcotect Limited" },
    {  8987, "State Infocommunication Foundation of Estonia" },
    {  8988, "Pingworks" },
    {  8989, "Naino Corporation" },
    {  8990, "Redpill Linpro AS (formerly 'Linpro AS')" },
    {  8991, "MARPOSS S.p.A." },
    {  8992, "Unisoft Consultants" },
    {  8993, "Asera Inc." },
    {  8994, "Avantas Networks" },
    {  8995, "Lo-Wang.org" },
    {  8996, "TransactPlus, Inc." },
    {  8997, "ProArp Inc." },
    {  8998, "Cottay" },
    {  8999, "TVS eTechnology Limited" },
    {  9000, "Personal Path Systems, Inc." },
    {  9001, "Goltier Media Group (Sitepak)" },
    {  9002, "LXPRO.COM" },
    {  9003, "slimjones." },
    {  9004, "SuSE Linux Venezuela, C.A." },
    {  9005, "Video Networks Limited" },
    {  9006, "Apache Consulting Ltd." },
    {  9007, "FineGround Networks" },
    {  9008, "Digital Route" },
    {  9009, "Agni Systems Limited" },
    {  9010, "Liebenzell Mission" },
    {  9011, "Laminar Software, Inc." },
    {  9012, "MailVision Ltd." },
    {  9013, "SpiritSoft Inc" },
    {  9014, "Belenos, Inc." },
    {  9015, "World Streaming Network, Inc." },
    {  9016, "FreeRein Corporation" },
    {  9017, "Cogent Systems, Inc." },
    {  9018, "CQR Data Ltd." },
    {  9019, "Cap Gemini Telecom Media & Networks Deutschland GmbH" },
    {  9020, "Computer Adaptive Technologies, Inc." },
    {  9021, "WideOpenWest LLC" },
    {  9022, "TrueSAN Networks" },
    {  9023, "Netsanity Inc." },
    {  9024, "Telia Internet, Inc." },
    {  9025, "NetCologne" },
    {  9026, "adisoft systems GmbH & Co. KG" },
    {  9027, "SoftNerd" },
    {  9028, "Lendx" },
    {  9029, "BSD Users Group Italia" },
    {  9030, "iVMG Incorporated" },
    {  9031, "Nexter Information Technology" },
    {  9032, "IVSTel" },
    {  9033, "Elion Enterprises Ltd" },
    {  9034, "Jabber.com" },
    {  9035, "Carlisle FoodService Products" },
    {  9036, "Jim Dutton" },
    {  9037, "Everyday Office Inc." },
    {  9038, "Well Diagnostics" },
    {  9039, "Chengdu Ideal Telecom Technology,Inc." },
    {  9040, "Chengdu Ideal Information Industry Co,Ltd." },
    {  9041, "Cambridge University Engineering Department" },
    {  9042, "Teinos" },
    {  9043, "Execulink" },
    {  9044, "NEC Eluminant Technologies, Inc." },
    {  9045, "eNetSecure, Inc" },
    {  9046, "Amecisco" },
    {  9047, "Blue Cross Blue Shield of Florida" },
    {  9048, "Open System Consultants" },
    {  9049, "Integrity Online" },
    {  9050, "Telenor Link AS" },
    {  9051, "Faculdade de Ci\0303\0252ncias e Tecnologia da Universidade Nova de Lisboa" },
    {  9052, "Sunbay Software AG" },
    {  9053, "Tovaris IP LC" },
    {  9054, "Tokheim" },
    {  9055, "9Rivers.com" },
    {  9056, "TelStrat International, Ltd." },
    {  9057, "Millennium Communication Network" },
    {  9058, "Jamcracker" },
    {  9059, "Vectrad Networks Corporation" },
    {  9060, "RuleSpace, Inc." },
    {  9061, "Deutscher Go-Bund" },
    {  9062, "SRS Microsystems" },
    {  9063, "iHive Technology Pte Ltd" },
    {  9064, "ATM ComputerSysteme GmbH" },
    {  9065, "Nettasking Technology (Singapore) Pte Ltd." },
    {  9066, "Global Security Technologies, Inc." },
    {  9067, "Cambia Networks" },
    {  9068, "Delphi Associates, Ltd." },
    {  9069, "Phillip's Technical Services" },
    {  9070, "Symmetricom" },
    {  9071, "Spirian Technologies, Inc." },
    {  9072, "AckleyNet" },
    {  9073, "Sunnyvale Community Players" },
    {  9074, "John M. Sutherland, Inc.Insurance" },
    {  9075, "Novex Solutions" },
    {  9076, "Tokyo Metallic Commuynications Corp." },
    {  9077, "Dekart" },
    {  9078, "Be Connected Ltd" },
    {  9079, "The Sanjyot Bharathan Design Association" },
    {  9080, "Babel Com Australia" },
    {  9081, "eachnet" },
    {  9082, "eXtremail" },
    {  9083, "eteamconsulting.com" },
    {  9084, "Keynote Systems, Inc." },
    {  9085, "Optical Switch Corporation" },
    {  9086, "US Robotics" },
    {  9087, "Brightmail, Inc." },
    {  9088, "Oso Grande Technologies, Inc." },
    {  9089, "New Mexico Technet, Inc." },
    {  9090, "Datagrove" },
    {  9091, "MICRO-STAR INT'L CO., Ltd." },
    {  9092, "Veenstra Graphic Solutions" },
    {  9093, "Innovate I.T. Logistics BV" },
    {  9094, "Amber Archer Consulting Co., Inc." },
    {  9095, "NIPPON MITSUBISHI OIL CORPORATION" },
    {  9096, "Zentrum f\0303\0274r Produkt Entwicklung, ETH Z\0303\0274rich" },
    {  9097, "CDFtel" },
    {  9098, "DW Systems" },
    {  9099, "Central Systems International, Inc." },
    {  9100, "Mstel" },
    {  9101, "Optum Computing Solutions, Inc." },
    {  9102, "Telecash Kommunikations-Service GmbH" },
    {  9103, "Yu-Shei Real Estate Co." },
    {  9104, "Chu-Shen Co. Ltd" },
    {  9105, "MIST" },
    {  9106, "ELIOS Informatique" },
    {  9107, "Ferguson Enterprises, Inc." },
    {  9108, "Random Walk Computing, Inc." },
    {  9109, "infogear" },
    {  9110, "Net Asia Angeles CIty" },
    {  9111, "Newway Tech. Inc." },
    {  9112, "Palamedes GmbH" },
    {  9113, "Wiral Ltd" },
    {  9114, "YLine Web Access Services" },
    {  9115, "Archon Technologies, Inc." },
    {  9116, "Ubicom, Inc" },
    {  9117, "LeWiz Communications Inc." },
    {  9118, "1Ci GmbH" },
    {  9119, "Advanced Rotorcraft Technology, Inc." },
    {  9120, "Narada Networks Inc." },
    {  9121, "Eduquip Limited" },
    {  9122, "UPCtv Interactive" },
    {  9123, "Universit\0303\0251 Pierre Mend\0303\0250s France" },
    {  9124, "Intellitactics Inc." },
    {  9125, "Inspiration Technology Pty Ltd" },
    {  9126, "Aetian Networks" },
    {  9127, "ADVANCED PERIPHERALS TECH. Inc." },
    {  9128, "Centre de traduction des organes de l'Union europ\0303\0251enne" },
    {  9129, "Linkvest SA" },
    {  9130, "Hemisphere Technologies" },
    {  9131, "Roland Felnhofer" },
    {  9132, "Hutchison OPTEL Telecom Technology CO.,Ltd" },
    {  9133, "Microraab Electronics" },
    {  9134, "Telenet NV" },
    {  9135, "Heyde AG" },
    {  9136, "ISDN Communications Ltd" },
    {  9137, "Anatel Communications" },
    {  9138, "AnteFacto" },
    {  9139, "Petroleum Business Institute" },
    {  9140, "Media General, Inc." },
    {  9141, "Riptech" },
    {  9142, "Infopaq International A/S" },
    {  9143, "Edmunds.com" },
    {  9144, "Trader Electronic Media" },
    {  9145, "AccessPt. Inc." },
    {  9146, "Reporter-Times, Inc." },
    {  9147, "TeaLeaf Technology, Inc." },
    {  9148, "Acme Packet" },
    {  9149, "LOCUS Corporation" },
    {  9150, "Metromedia Fiber Network" },
    {  9151, "Wiral Ltd." },
    {  9152, "Dit Company Limited" },
    {  9153, "Sodielec Telecom" },
    {  9154, "Figment Technologies Inc." },
    {  9155, "BlueNetworkX" },
    {  9156, "eGurkha Pvt Ltd." },
    {  9157, "CoreComm" },
    {  9158, "The Internet Group" },
    {  9159, "SHad0ws.net" },
    {  9160, "DGT Sp. z o.o." },
    {  9161, "Universidad del Pais Vasco" },
    {  9162, "P\0303\0244dagogische Hochschule Freiburg" },
    {  9163, "GNU Radius Project" },
    {  9164, "Xware AB" },
    {  9165, "Cabinet Remouit" },
    {  9166, "Universidad Galileo" },
    {  9167, "ANXeBusiness Corp" },
    {  9168, "Transaccess" },
    {  9169, "Novis Telecom, SA" },
    {  9170, "Exaecon Inc." },
    {  9171, "NetTone" },
    {  9172, "HVC Technologies" },
    {  9173, "Kohl's" },
    {  9174, "A2V ict" },
    {  9175, "Stream Theory, Inc" },
    {  9176, "Open-IT" },
    {  9177, "ThinkFree.Com, Inc" },
    {  9178, "DaeSung Corp." },
    {  9179, "INTESABCI SISTEMI E SERVIZI" },
    {  9180, "Maranti Networks, Inc" },
    {  9181, "Air Technology Systems" },
    {  9182, "FileFish, Inc." },
    {  9183, "Samba TNG" },
    {  9184, "Alterbox" },
    {  9185, "MS Integration Services Inc." },
    {  9186, "Logipolis Pte Ltd" },
    {  9187, "Eastman Chemical Company" },
    {  9188, "Force Computers" },
    {  9189, "Promedico Gmbh" },
    {  9190, "Katanoo Technologies" },
    {  9191, "Burgiesoft" },
    {  9192, "Pirkan Tietokone Oy" },
    {  9193, "CIRPACK" },
    {  9194, "AustLII" },
    {  9195, "AutocontControl Systems, spol. s r. o." },
    {  9196, "Algotronics" },
    {  9197, "Lyndon State College" },
    {  9198, "Teletron Ltd." },
    {  9199, "Daum Datentechnik" },
    {  9200, "Obermeier Software" },
    {  9201, "Fasturn Inc." },
    {  9202, "EnsureLink" },
    {  9203, "SeguriDATA Privada, S.A. de C.V." },
    {  9204, "Aurora Networks, Inc." },
    {  9205, "Moj. Net d.o.o." },
    {  9206, "DigitalSpark" },
    {  9207, "segNET Technology, Inc." },
    {  9208, "Hamilcar Development" },
    {  9209, "Peace Technology, Inc." },
    {  9210, "Merlin I.T. Services Ltd" },
    {  9211, "Rabobank ICT" },
    {  9212, "Wavium AB" },
    {  9213, "NetSeal Technologies" },
    {  9214, "Kemuri Systems" },
    {  9215, "ERIDAN Informatique" },
    {  9216, "Universidade de \0303\0211vora, Departamento de Inform\0303\0241tica" },
    {  9217, "BIOBASE Biological Databases/ Biologische Datenbanken GmbH" },
    {  9218, "Skysoft Portugal" },
    {  9219, "Juliao.com" },
    {  9220, "OPENJCC" },
    {  9221, "Shaw Communications" },
    {  9222, "Phillips Petroleum Company" },
    {  9223, "Roskilde University" },
    {  9224, "Lawrence University" },
    {  9225, "FJA" },
    {  9226, "Microtest" },
    {  9227, "Entrisphere, Inc." },
    {  9228, "Globetech" },
    {  9229, "Totilities" },
    {  9230, "#B4mad Research Lab Organization" },
    {  9231, "Adir Technologies" },
    {  9232, "Norwegian Mapping Authority" },
    {  9233, "IER SA" },
    {  9234, "Snowshore Networks Inc" },
    {  9235, "FCB Direct Montreal" },
    {  9236, "Fundtech Corporation" },
    {  9237, "Newisys" },
    {  9238, "Imagine Broadband Limited" },
    {  9239, "JonesKnowledge.com" },
    {  9240, "International MRI Accreditation Resources, LLC" },
    {  9241, "uni-X Software AG" },
    {  9242, "Instituto de Matem\0303\0241tica e Estat\0303\0255stica da Universidade de S\0303\0243o Paulo" },
    {  9243, "Air'Prod" },
    {  9244, "PureCarbon, Inc." },
    {  9245, "Neuromics, Inc." },
    {  9246, "Automated Handling Systems, Inc." },
    {  9247, "Federal-Mogul Corporation" },
    {  9248, "Paktronix Systems LLC" },
    {  9249, "Musambi Corporation" },
    {  9250, "Strix Systems" },
    {  9251, "TR Associates" },
    {  9252, "H\0303\0264tel-Dieu De Saint-J\0303\0251r\0303\0264me" },
    {  9253, "Buildscape, LLC" },
    {  9254, "Pajunas Interactive, Inc." },
    {  9255, "Vicinity Corporation" },
    {  9256, "LightPointe Communications" },
    {  9257, "Volera" },
    {  9258, "XMLStrategies.net" },
    {  9259, "SYSPOL Co., Ltd." },
    {  9260, "ADTEC Corporation" },
    {  9261, "Delphi Automotive Systems Investment (China) Holding Co.,Ltd" },
    {  9262, "EAST.NET Co. Ltd." },
    {  9263, "Cybernetics Technology Co., Ltd." },
    {  9264, "Caerdroia" },
    {  9265, "TDISIE" },
    {  9266, "Parsoft Systems Pvt. Ltd." },
    {  9267, "in-systemeGmbH" },
    {  9268, "Ruhrverband" },
    {  9269, "MediaBroadcast GmbH" },
    {  9270, "Callsys Ltd." },
    {  9271, "Siemens NGNI" },
    {  9272, "Elektrobit Ltd." },
    {  9273, "Neuro Telecom" },
    {  9274, "access:Seven Communications GmbH" },
    {  9275, "GENESYS" },
    {  9276, "Sema Spain NEG" },
    {  9277, "LOGICO Smart Card Solutions AG" },
    {  9278, "econia.com" },
    {  9279, "Arqana Technologies Inc." },
    {  9280, "AccessLine Communications Corporation" },
    {  9281, "Standard Insurance Company" },
    {  9282, "NOCpulse" },
    {  9283, "Costa Rica Institute of Technology" },
    {  9284, "Western Illinois University" },
    {  9285, "InternetCDS" },
    {  9286, "Maximum Throughput Inc." },
    {  9287, "Zeus Communications" },
    {  9288, "HostPro" },
    {  9289, "Unirez, Inc." },
    {  9290, "Firinn.org" },
    {  9291, "Rainfinity" },
    {  9292, "Webley System" },
    {  9293, "Staturn Computer" },
    {  9294, "W4y do Brasil Ltda" },
    {  9295, "Workers Compensation Fund" },
    {  9296, "Xlight Photonics Ltd" },
    {  9297, "Ayeca Inc." },
    {  9298, "University of Compi\0303\0250gne" },
    {  9299, "Hellas On Line" },
    {  9300, "Hypostasis" },
    {  9301, "Spider Software" },
    {  9302, "ESI s.r.l." },
    {  9303, "Waystream AB (formerly 'PacketFront Network Products AB')" },
    {  9304, "Connection Technology Systems" },
    {  9305, "Western Michigan University" },
    {  9306, "Octave Communications" },
    {  9307, "RCL Enterprises" },
    {  9308, "Oasis Technology Ltd." },
    {  9309, "Urzad Miasta Pabianic" },
    {  9310, "ABITAB S.A." },
    {  9311, "DI Trute" },
    {  9312, "Truth Consulting & Technology" },
    {  9313, "DaKoMa" },
    {  9314, "Curtis Family" },
    {  9315, "CARTEL SECURITE" },
    {  9316, "NetVoyager" },
    {  9317, "Tech2Work, Inc." },
    {  9318, "DEBEKA Versicherung" },
    {  9319, "NetAktiv" },
    {  9320, "Nanning Telecom" },
    {  9321, "Screenpeaks Ltd." },
    {  9322, "NetTech S.A." },
    {  9323, "PC Away" },
    {  9324, "Division fo Cancer Studies, Birmingham UK" },
    {  9325, "University of California, Riverside" },
    {  9326, "Lewis and Clark College" },
    {  9327, "Hygeia Corporation" },
    {  9328, "National Institutes of Health (NIH)" },
    {  9329, "Crusoe Communications, Inc." },
    {  9330, "Selesta S.p.A." },
    {  9331, "MaXware International AS" },
    {  9332, "Applied SNMP" },
    {  9333, "Lincom Wireless" },
    {  9334, "IPDR.org" },
    {  9335, "PowerSoft" },
    {  9336, "Publix Super Markets, Inc." },
    {  9337, "Minter Corp." },
    {  9338, "Petersen Ventures LLC" },
    {  9339, "Left Coast Systems Corp." },
    {  9340, "Network Infinity" },
    {  9341, "Cyberfuse Technologies, LLC" },
    {  9342, "Penguin Computing" },
    {  9343, "Comcel S.A." },
    {  9344, "Powerwave Technologies Inc." },
    {  9345, "infinetivity, Inc." },
    {  9346, "iGeek, Inc." },
    {  9347, "Avaz Networks" },
    {  9348, "Golden Telecom Ukraine" },
    {  9349, "WizLAN Ltd." },
    {  9350, "Netmagic Solutions Pvt. Ltd." },
    {  9351, "FORTHnet S.A." },
    {  9352, "Conundrum Communications" },
    {  9353, "Universite de Metz" },
    {  9354, "Grey Interactive France" },
    {  9355, "Krivorozhskiy Hlebokombinat N1" },
    {  9356, "nPassage, Inc." },
    {  9357, "IT-Beratung Schaffert" },
    {  9358, "Wicom Communications Ltd" },
    {  9359, "Symeko Datasystems bv" },
    {  9360, "Green Light Inc." },
    {  9361, "Oc\0303\0251 Software Laboratories Namur" },
    {  9362, "ENSEIRB" },
    {  9363, "Spelio" },
    {  9364, "InterPark Incorporated" },
    {  9365, "Mindsurf Networks Inc." },
    {  9366, "Cifra" },
    {  9367, "FASTSIGNS International, Inc" },
    {  9368, "Storage Xstreams" },
    {  9369, "Micah J. Schehl" },
    {  9370, "Space Telescope Science Institute" },
    {  9371, "Okolona Christian Church" },
    {  9372, "Ikadega, Inc." },
    {  9373, "Clear Ink" },
    {  9374, "Hermaion.org" },
    {  9375, "Basler Kantonalbank" },
    {  9376, "CVS / PharmacyRussell" },
    {  9377, "Voyager Computer Corporation" },
    {  9378, "Ilex Systems" },
    {  9379, "Eumitcom Technology Inc." },
    {  9380, "Octogon Gesellschaft f\0303\0274r Computer-Dienstleistungen mbH" },
    {  9381, "Walter Biering GmbH - Mediahaus und Grafischer Betrieb" },
    {  9382, "WORAH.NET" },
    {  9383, "Angeles Design Systems" },
    {  9384, "D2K, Inc." },
    {  9385, "Jason Wood" },
    {  9386, "Clayton College & State University" },
    {  9387, "Compania Mea" },
    {  9388, "AsiaInfo" },
    {  9389, "Magical Fruit" },
    {  9390, "W.T. Services, Inc." },
    {  9391, "Audientia" },
    {  9392, "Cannon Hill Anglican College" },
    {  9393, "Intecs Information Ltd." },
    {  9394, "Visana Services AG" },
    {  9395, "UEC Technologies" },
    {  9396, "Walt Disney International" },
    {  9397, "Vartech Solutions Inc." },
    {  9398, "Tokyo Metallic Communications Corp" },
    {  9399, "CONSUL Risk ManagementDirk Wisse, Koos Lodewijkx" },
    {  9400, "Fachhochschule Konstanz" },
    {  9401, "AML Wireless Systems" },
    {  9402, "dCrypt Ltd" },
    {  9403, "Allinstant" },
    {  9404, "Dewpoint Inc." },
    {  9405, "Kingland Systems Corporation" },
    {  9406, "Synchrologic" },
    {  9407, "Broadata Communications Inc." },
    {  9408, "Chester Enterprises" },
    {  9409, "ClickServices" },
    {  9410, "Axe Online Pty. Limited" },
    {  9411, "Hitwise Pty Ltd" },
    {  9412, "Contela" },
    {  9413, "Operax AB" },
    {  9414, "Digital Globe, Inc." },
    {  9415, "Archimed" },
    {  9416, "Unassigned" },
    {  9417, "egg:|" },
    {  9418, "Ivistar AG" },
    {  9419, "Siemens SiNiA" },
    {  9420, "Baltimore Technologies" },
    {  9421, "Vodafone D2" },
    {  9422, "Atanion GmbH" },
    {  9423, "Msa-Infor Sistemas e Automacao" },
    {  9424, "A&C Automacao e Controle" },
    {  9425, "Rotterdam School of Management" },
    {  9426, "Adigida Solutions" },
    {  9427, "Categoric Software" },
    {  9428, "Orgenic Software" },
    {  9429, "Mariinsky Theatre" },
    {  9430, "Progress Telecom" },
    {  9431, "Push, Inc." },
    {  9432, "Vingage Corporation" },
    {  9433, "Vaticor Inc." },
    {  9434, "Telergy Network Services" },
    {  9435, "Boletin Oficial del Estado" },
    {  9436, "Crysberg A/S" },
    {  9437, "Lancer Insurance Company" },
    {  9438, "YellowShirt Inc." },
    {  9439, "Green Point Pty Ltd" },
    {  9440, "eko system Inc." },
    {  9441, "Wall Street Systems, Inc." },
    {  9442, "Atheros communications, Inc." },
    {  9443, "Virage, Inc." },
    {  9444, "FireMon" },
    {  9445, "TJB" },
    {  9446, "Indiana University" },
    {  9447, "Red Fern Software" },
    {  9448, "Zyfer" },
    {  9449, "Florida State University" },
    {  9450, "Zyoptics Inc." },
    {  9451, "digeo" },
    {  9452, "NetLabs SRL" },
    {  9453, "Barnardos New Zealand" },
    {  9454, "future gate software GmbH" },
    {  9455, "Intelliclaim, Inc." },
    {  9456, "Allegro Networks" },
    {  9457, "Broadband Storage, Inc." },
    {  9458, "TCSI, Inc" },
    {  9459, "NileSOFT Ltd." },
    {  9460, "Salta Monte Solutions, Inc." },
    {  9461, "y2FUN.com" },
    {  9462, "MMLAB KTU" },
    {  9463, "Geyer und Weinig GmbH" },
    {  9464, "SIEL S.p.A." },
    {  9465, "Oldenburgische Landesbank AG" },
    {  9466, "CILEA" },
    {  9467, "iBanx B.V." },
    {  9468, "Universite de la Mediterranee (Aix Marseille 2)" },
    {  9469, "Starlab nv/sa" },
    {  9470, "Alfa.con Team S.p.A." },
    {  9471, "PortWise AB" },
    {  9472, "Jeje.org" },
    {  9473, "SafeStone Technologies PLC" },
    {  9474, "SIRT" },
    {  9475, "365 Corporation" },
    {  9476, "ESRF" },
    {  9477, "Market Central, Inc." },
    {  9478, "MyLuckyWorld" },
    {  9479, "WebCollage" },
    {  9480, "Notus Key Limited" },
    {  9481, "Backer Software Research" },
    {  9482, "ENS-Lyon" },
    {  9483, "PSI AG" },
    {  9484, "ision france" },
    {  9485, "FUTUROCOM" },
    {  9486, "Powwow Germany GmbH" },
    {  9487, "saardata GmbH" },
    {  9488, "Circuit City Stores" },
    {  9489, "SAXA, Inc. (formerly 'Taiko Electric Works, LTD')" },
    {  9490, "Scorecon International" },
    {  9491, "VECTAN" },
    {  9492, "The Cobalt Group" },
    {  9493, "iOpen Technologies Ltd." },
    {  9494, "IFILM" },
    {  9495, "etee2k.net" },
    {  9496, "AT&T Enhanced Network Services" },
    {  9497, "IDini Corporation" },
    {  9498, "Telekommunikation Mittleres Ruhrgebiet GmbH" },
    {  9499, "Exacube System Inc." },
    {  9500, "Byte Alliance" },
    {  9501, "SVA-INTRUSION.COM Co. LTD" },
    {  9502, "Ross Technology Group, Inc." },
    {  9503, "Telemovil El Salvador" },
    {  9504, "tops.net GmbH & Co Online Publishing Services KG" },
    {  9505, "bone labs GmbH" },
    {  9506, "Real Solutions Ltd." },
    {  9507, "Wharton Electronics" },
    {  9508, "MobileSpear Inc." },
    {  9509, "Enkash Payment Network" },
    {  9510, "KONSYS" },
    {  9511, "Vulkan Technic GmbH" },
    {  9512, "Online Consulting, Ltd." },
    {  9513, "Exacomm Systems" },
    {  9514, "Konica Business Technologies, Inc." },
    {  9515, "Sugar Creek Packing Co." },
    {  9516, "Digital World Services" },
    {  9517, "Sanrise Inc" },
    {  9518, "Pratt & Whitney" },
    {  9519, "Soward Network Solutions" },
    {  9520, "Phase2 Software Corp" },
    {  9521, "PED Computers" },
    {  9522, "Personeta" },
    {  9523, "ST E15" },
    {  9524, "Andiamo Systems, Inc" },
    {  9525, "BBC Monitoring" },
    {  9526, "Shawmut Design & Construction" },
    {  9527, "Inkras Networks Corporation" },
    {  9528, "Iyago" },
    {  9529, "Global Relay Inc." },
    {  9530, "CQUR . COM" },
    {  9531, "Integra Telecom" },
    {  9532, "Group 1 Software" },
    {  9533, "TrueDisk" },
    {  9534, "Handrew" },
    {  9535, "Zurita Solutions" },
    {  9536, "Massey University" },
    {  9537, "Navox Corporation" },
    {  9538, "StorageWay Inc." },
    {  9539, "STSN" },
    {  9540, "Altentia" },
    {  9541, "Lokaal Netwerk Gravenstraat" },
    {  9542, "College of Engineering and Computer Science" },
    {  9543, "Schwoo, Inc." },
    {  9544, "Electrical and Computer Engineering Dept., UBC" },
    {  9545, "State Street Corp." },
    {  9546, "Dominet Systems" },
    {  9547, "foo Corporation" },
    {  9548, "Datachron Inc." },
    {  9549, "Southern Network Services, Inc." },
    {  9550, "vox2vox Communications, Inc." },
    {  9551, "Kompu-Art Studiu Komputerowe" },
    {  9552, "Financial IQ Pty Ltd" },
    {  9553, "Automaton Ltd" },
    {  9554, "Clear River Technologies, LLC" },
    {  9555, "AsiaInfo Technologies(China), Inc." },
    {  9556, "Great Wall Broadbank Network Service Co.Lt" },
    {  9557, "Synso Inc." },
    {  9558, "Kent Ridge Digital Labs" },
    {  9559, "National Security Research Institute" },
    {  9560, "SECUi.COM Corporation" },
    {  9561, "Netia Telekom S.A." },
    {  9562, "Magnum Imperium Limited" },
    {  9563, "Suffolk College" },
    {  9564, "mediaWays GmbH Internet-Services" },
    {  9565, "Xerox Mobile Solutions" },
    {  9566, "HBO-CE" },
    {  9567, "Skilldeal AG" },
    {  9568, "DataGrid" },
    {  9569, "MGF Logistique" },
    {  9570, "University of Leoben/Austria" },
    {  9571, "Erskine Systems Ltd" },
    {  9572, "AlienThing.com" },
    {  9573, "MB-NET" },
    {  9574, "NCIC Clinical Trials" },
    {  9575, "Grupo de Programa\0303\0247\0303\0243o na Web(WPG)" },
    {  9576, "Cr\0303\0251dit Mutuel de Bretagne" },
    {  9577, "Xtelligent IT Consulting GmbH" },
    {  9578, "Mission Critical Linux, Inc." },
    {  9579, "Followap" },
    {  9580, "New Hemisphere Computer Services" },
    {  9581, "Quad One Technologies Pvt. Ltd." },
    {  9582, "CCS Communications Pty. Ltd." },
    {  9583, "BBC Technology Supply Ltd" },
    {  9584, "Lucent Technologies NADP" },
    {  9585, "National Enhance Technology Corp." },
    {  9586, "Debian" },
    {  9587, "Global Trust Authority" },
    {  9588, "IT Insourcing" },
    {  9589, "Currenex, Inc." },
    {  9590, "The MathWorks Inc." },
    {  9591, "Thinking Cat Enterprises" },
    {  9592, "Luke Crawford Enterprises" },
    {  9593, "SysNet Inform\0303\0241tica Ltda" },
    {  9594, "Tape Products Company" },
    {  9595, "Zephion Networks" },
    {  9596, "PimpCode" },
    {  9597, "Blue Silicon" },
    {  9598, "MBNA America" },
    {  9599, "LDAPGURU.COM LLC" },
    {  9600, "Williams Technology Consulting Services" },
    {  9601, "Keewaytinook Okimakanak" },
    {  9602, "Zoftech Inc." },
    {  9603, "AF Enterprises" },
    {  9604, "afuu" },
    {  9605, "Xyterra Computing Inc" },
    {  9606, "Linvision B.V." },
    {  9607, "MSTC" },
    {  9608, "ntelsOh" },
    {  9609, "Impaster Co. Ltd" },
    {  9610, "Milosch.net" },
    {  9611, "Infosim" },
    {  9612, "Kobe Steel, Ltd." },
    {  9613, "nlsde" },
    {  9614, "GoCruiseDirect.com" },
    {  9615, "Danfoss A/S" },
    {  9616, "Kreatel Communications AB" },
    {  9617, "GSX Groupware Solutions" },
    {  9618, "Utrechtse Werkbedrijven" },
    {  9619, "Nextra Austria" },
    {  9620, "National Land Survey of Finland" },
    {  9621, "MOLO AFRIKA SPEECH TECHNOLOGIES" },
    {  9622, "QuesCom" },
    {  9623, "Copenhagen Airports" },
    {  9624, "Radianz" },
    {  9625, "Utesch" },
    {  9626, "Alessandro Triglia" },
    {  9627, "S J Shipinski Services" },
    {  9628, "Groupe CASINO" },
    {  9629, "Mastermind Technologies" },
    {  9630, "e-moveum" },
    {  9631, "eSniff, Inc." },
    {  9632, "Individual" },
    {  9633, "SED Systems" },
    {  9634, "API Networks, Inc" },
    {  9635, "Tropico Sistemas e Telecomunica=E7=F5es SA" },
    {  9636, "netFORMAT GmbH" },
    {  9637, "Alliance & Leicester PLC" },
    {  9638, "AlphaGraphics, Inc." },
    {  9639, "Appium AB" },
    {  9640, "Astrolink International LLC" },
    {  9641, "Azusa Pacific University" },
    {  9642, "Bibop Research, int. S.p.A. Gianugo" },
    {  9643, "CEULP/ULBRA" },
    {  9644, "Cornwall Internet Limited" },
    {  9645, "courtade.net" },
    {  9646, "Cybectec" },
    {  9647, "EWIP" },
    {  9648, "GeekBone Co. LTD" },
    {  9649, "Hochschule Bremen" },
    {  9650, "Infoclan" },
    {  9651, "Kele" },
    {  9652, "LNS SA" },
    {  9653, "Mosotech Limited" },
    {  9654, "NIC France" },
    {  9655, "Optidev AB" },
    {  9656, "Routit BV" },
    {  9657, "S://Scape Communications Inc." },
    {  9658, "Solers" },
    {  9659, "Synapsys Ltd" },
    {  9660, "Telecel Comunica\0303\0247\0303\0265es pessoais S.A" },
    {  9661, "Teletron INC" },
    {  9662, "TUEV-AT-TRUST Center GmbH" },
    {  9663, "UNIVERSITE LUMIERE LYON2" },
    {  9664, "Widgital" },
    {  9665, "ZyGATE Communications Inc." },
    {  9666, "Alcatel Optronics" },
    {  9667, "Austar United" },
    {  9668, "Talent Network Security Technology Co., Ltd." },
    {  9669, "University of London" },
    {  9670, "BROADi" },
    {  9671, "Time Warner" },
    {  9672, "Apropos Technology, Inc." },
    {  9673, "Denison University" },
    {  9674, "Fingerhut" },
    {  9675, "Grupo Financiero Uno" },
    {  9676, "hottis.de" },
    {  9677, "Hydriads" },
    {  9678, "K.U. Leuven" },
    {  9679, "mBalance" },
    {  9680, "SelectMetrics, Inc." },
    {  9681, "Mortgage Systems International" },
    {  9682, "Novadeck" },
    {  9683, "Plattsburgh State University" },
    {  9684, "PoweriseNet" },
    {  9685, "Ranch Networks, Inc." },
    {  9686, "Ruby Networks, Inc." },
    {  9687, "SAProperty.com" },
    {  9688, "Tahoe Networks, Inc." },
    {  9689, "TBD Networks" },
    {  9690, "Terralab" },
    {  9691, "Children's Hospital Colorado (formerly 'The Children's Hospital of Denver')" },
    {  9692, "Tool Object" },
    {  9693, "UND School of Medicine and Health Sciences" },
    {  9694, "Arbor Networks" },
    {  9695, "Encotone Ltd." },
    {  9696, "Uffizio India Software Consultants Pvt. Ltd." },
    {  9697, "Accelance" },
    {  9698, "AIA Australia" },
    {  9699, "Axis Consulting" },
    {  9700, "Boehringer-Ingelheim GmbH" },
    {  9701, "Commerce NTI" },
    {  9702, "Comtech Belgium" },
    {  9703, "Datafoundation Inc.Valerii" },
    {  9704, "Diversified Resourceful Solutions Inc." },
    {  9705, "ecos gmbh" },
    {  9706, "HackersLab" },
    {  9707, "Institut National Polytechnique de Lorraine" },
    {  9708, "Jack Morton Worldwide" },
    {  9709, "Micro Connect Pty Ltd" },
    {  9710, "Monzoon Networks AG" },
    {  9711, "Novedia" },
    {  9712, "obzen Inc." },
    {  9713, "Opera Software AS" },
    {  9714, "Ruhrsoft" },
    {  9715, "Sigma AB" },
    {  9716, "State of North Dakota" },
    {  9717, "Teleca AB" },
    {  9718, "TransACT Communications" },
    {  9719, "Tronicplanet Online Datendienst GmbH" },
    {  9720, "Tryx" },
    {  9721, "VWR International" },
    {  9722, "Workhorse Computing" },
    {  9723, "Coradiant" },
    {  9724, "Datacast Inc." },
    {  9725, "INFOservice" },
    {  9726, "Nitroba" },
    {  9727, "Tryllian" },
    {  9728, "WWF Wort + Ton GmbH e-media" },
    {  9729, "EVERelite, Co., Ltd." },
    {  9730, "Solutus Pty Limited" },
    {  9731, "5down" },
    {  9732, "Adrenaline Ingenierie Multimedia" },
    {  9733, "Aral Systems GmbH" },
    {  9734, "Astrum Software Corporation" },
    {  9735, "Coredump Ky" },
    {  9736, "Dublin City University" },
    {  9737, "Fourtheye" },
    {  9738, "Gedoplan GmbH" },
    {  9739, "Hobnobbers.net" },
    {  9740, "iBEAM Broadcasting Corporation" },
    {  9741, "Keiren" },
    {  9742, "DESCOM CONSULTING, S.L." },
    {  9743, "NCHICA" },
    {  9744, "peoplecall.com" },
    {  9745, "Radix Controls Inc." },
    {  9746, "RFNet Technologies Pte Ltd" },
    {  9747, "RoamingTest Ltd" },
    {  9748, "ROW Software and Web Design" },
    {  9749, "SpectraLink Corporation" },
    {  9750, "The Pillars" },
    {  9751, "Trevilon Corp." },
    {  9752, "University of Missouri" },
    {  9753, "Vernier Networks, Inc." },
    {  9754, "Vertis DSG Chicago" },
    {  9755, "Webasto Informationssysteme GmbH" },
    {  9756, "woerd Erdmenger & Wolter GbR" },
    {  9757, "Aral Aktiengesellschaft & Co. KG" },
    {  9758, "Metadigm Ltd" },
    {  9759, "Aplicaciones y Consultoria, S.A. de C.V." },
    {  9760, "Cellcast" },
    {  9761, "Corporate Express" },
    {  9762, "Datacom Systems Inc." },
    {  9763, "Eonite, Inc." },
    {  9764, "Forschungszentrum Rossendorf e.V." },
    {  9765, "ILRYUNG TELESYS" },
    {  9766, "Joseph S Dovgan DDS MS" },
    {  9767, "Lectron CO., LTD" },
    {  9768, "Lynchburg College" },
    {  9769, "Nuance Communications" },
    {  9770, "OpenOffice.org" },
    {  9771, "PAION Co. Ltd.," },
    {  9772, "pentasecurity" },
    {  9773, "SpunHead Industries" },
    {  9774, "Streets Online Ltd." },
    {  9775, "TNT Software, Inc." },
    {  9776, "Wireless Network Services" },
    {  9777, "Arelnet Ltd." },
    {  9778, "AxONLink" },
    {  9779, "Empire State College" },
    {  9780, "Entreprise des Postes et Telecommunications" },
    {  9781, "Jerntorget Sverige AB" },
    {  9782, "JM Family Enterprises, Inc." },
    {  9783, "Vayusphere, Inc." },
    {  9784, "icoserve information technologies" },
    {  9785, "Praxis Technical Group, Inc." },
    {  9786, "A.I.S. AngewandteInformations-Systeme GmbH" },
    {  9787, "ActiveState Corp." },
    {  9788, "Advisor Technologies Limited" },
    {  9789, "Astaro AG" },
    {  9790, "Australia On Line" },
    {  9791, "Centre de Telecomunicacions i Tecnologies de la Informacio" },
    {  9792, "Clayhill KG" },
    {  9793, "CloudShield Technologies, Inc." },
    {  9794, "CYTBeN" },
    {  9795, "EBS Dealing Resources, Inc" },
    {  9796, "ENX Association (formerly 'European Network Exchange')" },
    {  9797, "EVER Sp. z o.o." },
    {  9798, "Griff-IT Ltd." },
    {  9799, "Holos Software, Inc." },
    {  9800, "iNIT-8" },
    {  9801, "ISIS Frontier Communications" },
    {  9802, "IUFM de Rouen" },
    {  9803, "L-3 Communication Systems - East" },
    {  9804, "Lefthand Networks" },
    {  9805, "Neveda City School District" },
    {  9806, "PRIDE Industries" },
    {  9807, "Prism Holding Limited" },
    {  9808, "Rocklea Spinning Mills Pty Ltd" },
    {  9809, "Root, Int." },
    {  9810, "Sagent" },
    {  9811, "Secure Appliance Systems" },
    {  9812, "SolNet" },
    {  9813, "TAB Queensland Limited" },
    {  9814, "Telia IT-Service AB" },
    {  9815, "VSpace, Inc." },
    {  9816, "WANWALL" },
    {  9817, "WaveNET International (Pvt) Ltd." },
    {  9818, "Xwave GmbH" },
    {  9819, "yLez Technologies Pte Ltd" },
    {  9820, "ZOX-IT" },
    {  9821, "Zoznam s.r.o." },
    {  9822, "Accella Technologies Co., Ltd" },
    {  9823, "Diageo" },
    {  9824, "GenTek" },
    {  9825, "Geospiza Inc." },
    {  9826, "ImagiCode Studios" },
    {  9827, "Neocles" },
    {  9828, "pgamAPD" },
    {  9829, "SAIT Ltd" },
    {  9830, "Thunderbird, the American Graduate School of International Management" },
    {  9831, "Vivre Inc" },
    {  9832, "solobird" },
    {  9833, "Legend Holdings Ltd." },
    {  9834, "Agencja Uslug InformatycznychARTCOMP" },
    {  9835, "Alien Network" },
    {  9836, "AOK Bayern" },
    {  9837, "Ball State University" },
    {  9838, "Broadview Networks, Inc." },
    {  9839, "CAREL" },
    {  9840, "carreregroup" },
    {  9841, "Christian Dusek EDV-Dienstleistungen" },
    {  9842, "ET Networks" },
    {  9843, "Kai Industries" },
    {  9844, "Kansas State University" },
    {  9845, "LANBIRD Technology Co., Ltd." },
    {  9846, "LIP - Laborat\0303\0263rio de Instrumenta\0303\0247\0303\0243o e F\0303\0255sica Experimental de Part\0303\0255culas" },
    {  9847, "Listen.com" },
    {  9848, "Lou Johnson" },
    {  9849, "M-Web Indonesia" },
    {  9850, "NextGig" },
    {  9851, "NTT SOFT" },
    {  9852, "Odigo Inc" },
    {  9853, "Payment Technologies" },
    {  9854, "Red Box Recorders Limited" },
    {  9855, "Shawsoft GmbH" },
    {  9856, "UCLA Communications Technology Services" },
    {  9857, "Unicom an e-security company" },
    {  9858, "University of Maryland, Baltimore County" },
    {  9859, "University of Medicine and Dentistry of New Jersey" },
    {  9860, "Vizional Technologies, Inc." },
    {  9861, "Webdesign Internet Service GmbH" },
    {  9862, "Claredi Corporation" },
    {  9863, "DataRojahn A/S" },
    {  9864, "J Walter Thomposon Company" },
    {  9865, "Karmanos Cancer Institute" },
    {  9866, "Outokumpu Oyj" },
    {  9867, "Third Rail Americas" },
    {  9868, "Millinet Co., Ltd" },
    {  9869, "Network Laboratory of Nankai University" },
    {  9870, "graviton, Inc." },
    {  9871, "Findlater Wine Merchants" },
    {  9872, "GEZ" },
    {  9873, "Viterra AG" },
    {  9874, "\0303\0205bo Akademi University" },
    {  9875, "AVAILABLE SUPPLY Inc." },
    {  9876, "B2I Toulouse" },
    {  9877, "California State University, East Bay" },
    {  9878, "CareGroup HealthCare System" },
    {  9879, "Cox Communications, Las Vegas" },
    {  9880, "Data Junction Corporation" },
    {  9881, "Eita Technologies, Inc." },
    {  9882, "Flash Technology" },
    {  9883, "Free Trade Online" },
    {  9884, "Frost-EDV" },
    {  9885, "Green Packet, Inc." },
    {  9886, "Incendiary Networks" },
    {  9887, "Kristina Internet Business Solutions" },
    {  9888, "Linux Terminal Server Project (LTSP)" },
    {  9889, "Winpresa Building Automation Technologies GmbH" },
    {  9890, "Media General Inc" },
    {  9891, "Mensatec" },
    {  9892, "Oregon Graduate Institute of Science and Technology" },
    {  9893, "Paranormal Sweden" },
    {  9894, "Polestar Corp." },
    {  9895, "Project49 AG" },
    {  9896, "R&R Associ\0303\0251s" },
    {  9897, "Seranoa Networks" },
    {  9898, "Shindengen Electric Mfg. Co., Ltd." },
    {  9899, "Stinnes AG" },
    {  9900, "Telekom Applied Business Sdn. Bhd." },
    {  9901, "The College of William and Mary" },
    {  9902, "The University of Chicago" },
    {  9903, "TI SQUARE Technology" },
    {  9904, "University of Nebraska" },
    {  9905, "Volubill" },
    {  9906, "Xtera Communications Inc." },
    {  9907, "Akkaya Consulting GmbH" },
    {  9908, "HiTRUST.COM (HK) Incorporated Limited" },
    {  9909, "Pacific Technology Services" },
    {  9910, "Absolute Software Corp." },
    {  9911, "Bantu, Inc." },
    {  9912, "Baraga Telephone Company" },
    {  9913, "Cerebra Intergrated Technologies Ltd." },
    {  9914, "Charter Communications" },
    {  9915, "Commtouch Software Ltd" },
    {  9916, "Datek Online Holdings Corp." },
    {  9917, "Delos Payment Systems" },
    {  9918, "National Oceanic and Atmospheric Administration (NOAA)" },
    {  9919, "earth9.com Pte Ltd" },
    {  9920, "ENETCO GmbH" },
    {  9921, "ERGO Versicherungsgruppe AG" },
    {  9922, "eSign Australia Limited" },
    {  9923, "European Southern Observatory" },
    {  9924, "Excite UK Ltd" },
    {  9925, "Finest Webs" },
    {  9926, "Genie Network Resource Management" },
    {  9927, "Icehouse Net Services" },
    {  9928, "Inetrify" },
    {  9929, "Integral Concepts, Inc." },
    {  9930, "InterNexus Plc" },
    {  9931, "Inti" },
    {  9932, "IPFilter" },
    {  9933, "JAARS, Inc" },
    {  9934, "JANUS Research Group" },
    {  9935, "Louisiana Tech University" },
    {  9936, "massconfusion.com" },
    {  9937, "MaXXan Systems, Inc." },
    {  9938, "Mercury Corporation" },
    {  9939, "merNet Security" },
    {  9940, "Nine Tiles Networks Ltd" },
    {  9941, "Objective Reality Computer LLC" },
    {  9942, "Optimation Software Engineering" },
    {  9943, "Prometheon, Inc." },
    {  9944, "SIAS Ltd" },
    {  9945, "Siemens Business Services AB" },
    {  9946, "SoftSol India Limitedn" },
    {  9947, "Swales Aerospace, Inc." },
    {  9948, "Telekurier GesmbH & Co KG" },
    {  9949, "Ubiquitous Corp." },
    {  9950, "Visionary Communications Inc." },
    {  9951, "Wireless M2M, LLC" },
    {  9952, "WuhanTIT" },
    {  9953, "Bertelsmann Gamechannel" },
    {  9954, "craigbuchek.com" },
    {  9955, "Crisp Hughes Evans L.L.P." },
    {  9956, "NDS Surgical Imaging (formerly 'Planar Systems, Inc.')" },
    {  9957, "Dynamic Equilibrium Pty Ltd" },
    {  9958, "Formula/400" },
    {  9959, "NODS" },
    {  9960, "nuisys.com" },
    {  9961, "FundsXpress Financial Network" },
    {  9962, "VirCIO, LLP" },
    {  9963, "Advanced Computer Technologies (ACT) Inc." },
    {  9964, "50km Inc." },
    {  9965, "Amministrazione Provinciale di Grosseto" },
    {  9966, "Beijing Huahuan Electronics Ltd." },
    {  9967, "Bluesocket, Inc." },
    {  9968, "British Antarctic Survey" },
    {  9969, "Condat AG" },
    {  9970, "Custodix NV" },
    {  9971, "CyberTel, Inc." },
    {  9972, "Emulive Imaging Corporation Inc." },
    {  9973, "Flexsys (UK) Ltd" },
    {  9974, "Internet Transaction Services, Inc.(iTrans)" },
    {  9975, "J.W. Jensen, Inc." },
    {  9976, "Flexsys Inc" },
    {  9977, "jobpilot AG" },
    {  9978, "Linuxkorea, Inc." },
    {  9979, "Mabuse.De" },
    {  9980, "M-Web South Africa" },
    {  9981, "NeT&Trade GmbH" },
    {  9982, "netEngine" },
    {  9983, "Netstech, Inc." },
    {  9984, "Osmosislatina" },
    {  9985, "RIC" },
    {  9986, "Sencore" },
    {  9987, "Signet" },
    {  9988, "Smart Technology Enablers, Inc." },
    {  9989, "Stochastix" },
    {  9990, "Stonebranch, Incorporated" },
    {  9991, "synchrone" },
    {  9992, "Terion" },
    {  9993, "Terumo Medical Corporation" },
    {  9994, "The Linux Box Corporation" },
    {  9995, "ThinkEngine Networks, Inc." },
    {  9996, "Villanova University" },
    {  9997, "Virtual e-learning group (VEG)" },
    {  9998, "Wynd Communications" },
    {  9999, "Zerna, Koepper & Partner" },
    { 10000, "MapInfo Corporation" },
    { 10001, "blio Corporation" },
    { 10002, "Frogfoot Networks" },
    { 10003, "IP ONE Inc." },
    { 10004, "johnchildress.com" },
    { 10005, "Pure NetworX GmbH" },
    { 10006, "SANTON" },
    { 10007, "RF Innovations Pty Ltd" },
    { 10008, "Groupe ESIEE Paris" },
    { 10009, "KrystalBox Technologies, Inc." },
    { 10010, "Network Storage Solutions, Inc." },
    { 10011, "Advanced Simulation Technology Inc" },
    { 10012, "Alternium SA" },
    { 10013, "caledo GmbH" },
    { 10014, "CERIAS" },
    { 10015, "Certification Centre Ltd" },
    { 10016, "Computer & Communications Innovations" },
    { 10017, "CREWAVE Co., Ltd." },
    { 10018, "Double Precision, Inc." },
    { 10019, "Fen Systems Ltd." },
    { 10020, "Globe" },
    { 10021, "Good Technology, Inc." },
    { 10022, "Iconnect" },
    { 10023, "IMA L.t.d." },
    { 10024, "Integrated Technology Express, Inc" },
    { 10025, "Interland, Inc." },
    { 10026, "Interloci,Inc." },
    { 10027, "Internet Data Systems S.A." },
    { 10028, "level 42 networks" },
    { 10029, "Men & Mice" },
    { 10030, "Mudiaga Obada" },
    { 10031, "NIIEFA CTC CYCLONE" },
    { 10032, "ONEMEDIA Inc." },
    { 10033, "OpenSOS S/B" },
    { 10034, "OSIX AB" },
    { 10035, "SAY Technologies, Inc." },
    { 10036, "Times N Systems" },
    { 10037, "Ultimate People Company Ltd" },
    { 10038, "University of Texas Health Science Center at San Antonio" },
    { 10039, "Videotek, Inc." },
    { 10040, "Yonsei University" },
    { 10041, "ZONE. PL s.c." },
    { 10042, "comma Flex" },
    { 10043, "eTime Capital, Inc." },
    { 10044, "FRB-Par" },
    { 10045, "NetFormFive Informationstechnologie GmbH" },
    { 10046, "Protek, S.C." },
    { 10047, "Servocomp Ltd." },
    { 10048, "VXL eTech (P) Limited" },
    { 10049, "WebRelay, Inc." },
    { 10050, "Dana Corporation" },
    { 10051, "Eftia OSS Solutions Inc" },
    { 10052, "Electronic Commerce Link, Inc." },
    { 10053, "keys" },
    { 10054, "NetValue S.A." },
    { 10055, "Roaring Penguin Software Inc." },
    { 10056, "AppDancer Networks" },
    { 10057, "EMTE Sistemas" },
    { 10058, "HAURI Inc." },
    { 10059, "SANRAD" },
    { 10060, "SELTA Telematica" },
    { 10061, "Pacific Info Tech Corp." },
    { 10062, "Comsquared Systems, Inc." },
    { 10063, "Aaron Grosky & Associates Inc" },
    { 10064, "ASH" },
    { 10065, "Ironoak Software" },
    { 10066, "Digital Multimedia Technologies" },
    { 10067, "DVTEL Inc." },
    { 10068, "E-OfficeServices Ltd." },
    { 10069, "Epsilon AB" },
    { 10070, "Flashwave Ltd" },
    { 10071, "GINKO AG" },
    { 10072, "GW Technologies Co., Ltd." },
    { 10073, "HanseNet Telekommunikation GmbH" },
    { 10074, "Ikimbo" },
    { 10075, "Infodyne Corporation" },
    { 10076, "Institutions of the European Union" },
    { 10077, "MbyN Inc." },
    { 10078, "Medienprojektverein Steiermark" },
    { 10079, "Metrosource, Inc." },
    { 10080, "Microcell I5 Inc." },
    { 10081, "NrjCorporation" },
    { 10082, "Oculus Technologies Corporation" },
    { 10083, "Panda Vista" },
    { 10084, "Priority Telecom N.V. Roger" },
    { 10085, "Prove IT" },
    { 10086, "Segue Software, Inc." },
    { 10087, "SilentOne Limited" },
    { 10088, "Techno Valley Co." },
    { 10089, "Tek Tools, Inc." },
    { 10090, "The ClueNet Project" },
    { 10091, "Transfar" },
    { 10092, "Unassigned" },
    { 10093, "unamite GmbH" },
    { 10094, "University of Novi Sad" },
    { 10095, "Wickander & Associates" },
    { 10096, "Baxter Healthcare Corporation" },
    { 10097, "ECI-IP Inc." },
    { 10098, "Gonicus GmbH" },
    { 10099, "humanIT" },
    { 10100, "onDevice Corporation" },
    { 10101, "Mirai Espana, S.L." },
    { 10102, "Alt-N Technologies" },
    { 10103, "Lewis Curtis Consulting" },
    { 10104, "eBOA" },
    { 10105, "Lawson Software" },
    { 10106, "Albal\0303\0241 Ingenieros, S.A" },
    { 10107, "1stCom Technologies Corp." },
    { 10108, "7 Global Ltd" },
    { 10109, "Active Telecom" },
    { 10110, "Agile Storage, Inc." },
    { 10111, "Get Connected" },
    { 10112, "APLcomp Oy" },
    { 10113, "ApplianceWare Inc." },
    { 10114, "Artesia Technologies" },
    { 10115, "ARTFUL" },
    { 10116, "Auga ApS" },
    { 10117, "Axerra Networks, Inc." },
    { 10118, "BenefitsXML, Inc." },
    { 10119, "BigBangwidth" },
    { 10120, "BRTech" },
    { 10121, "CLEAR Communications Ltd" },
    { 10122, "Creatia Corporation" },
    { 10123, "Crimco Consulting" },
    { 10124, "CUST - Universit\0303\0251 Blaise Pascal (Clermont II)" },
    { 10125, "cyberPIXIE, Inc." },
    { 10126, "DAASI International GmbH" },
    { 10127, "Desana Systems Incorporated" },
    { 10128, "DISA" },
    { 10129, "DiscoverNet, Inc." },
    { 10130, "Ecole Centrale de Lyon" },
    { 10131, "EINK" },
    { 10132, "EM Solutions Pty Ltd" },
    { 10133, "FedEx" },
    { 10134, "FerraraLUG" },
    { 10135, "Front Porch Inc." },
    { 10136, "godot communication technologies gmbh" },
    { 10137, "GTMP Foundation" },
    { 10138, "i2pi" },
    { 10139, "i3sp" },
    { 10140, "INCO Systems, Inc." },
    { 10141, "Infinisys Pty Ltd" },
    { 10142, "Interdimensions" },
    { 10143, "Introut Consulting" },
    { 10144, "iORMYX" },
    { 10145, "Just In Time Consulting" },
    { 10146, "Kern Automatiseringsdiensten BV" },
    { 10147, "Lancaster-Lebanon Intermediate Unit 13" },
    { 10148, "Lightel Systems Corporation" },
    { 10149, "LineOne" },
    { 10150, "Logic One Incorporated" },
    { 10151, "Multimedia University" },
    { 10152, "Muspellsheim" },
    { 10153, "Net2Phone" },
    { 10154, "NetPlay, Inc." },
    { 10155, "Northern Parklife Inc" },
    { 10156, "Novoforum" },
    { 10157, "Onnet Technologies Co." },
    { 10158, "PanAmSat" },
    { 10159, "Panasas Inc." },
    { 10160, "Penn State Outreach Information Systems" },
    { 10161, "PictureIQ" },
    { 10162, "poland.com SA" },
    { 10163, "Remedy Corporation" },
    { 10164, "Roads and Traffic Authority (RTA)" },
    { 10165, "Robert Williams Consulting" },
    { 10166, "Secure Software Services ltd" },
    { 10167, "Siemens Communications Limited" },
    { 10168, "Space Biomedical Center" },
    { 10169, "Suayan Design" },
    { 10170, "Telemig Celular S.A." },
    { 10171, "Telsey" },
    { 10172, "Territory Business Solutions Pty. Ltd." },
    { 10173, "Texil" },
    { 10174, "The Chubb Group of Insurance Companies" },
    { 10175, "Traffion Technologies" },
    { 10176, "Univention" },
    { 10177, "University of Northern Iowa" },
    { 10178, "Western Kentucky University" },
    { 10179, "Wireless Solutions" },
    { 10180, "Am-utils Organization" },
    { 10181, "Cardinal Health Inc." },
    { 10182, "futureLAB AG" },
    { 10183, "Master Quality snc" },
    { 10184, "QCOM TV, Inc." },
    { 10185, "SMP" },
    { 10186, "Weinbrenner Media Consult" },
    { 10187, "Teleview" },
    { 10188, "Piolink, Inc" },
    { 10189, "Congruency, Inc." },
    { 10190, "AEGMIS GmbH" },
    { 10191, "DivergeNet, Inc." },
    { 10192, "E.ON Energie AG" },
    { 10193, "erkle" },
    { 10194, "is:energy" },
    { 10195, "SH Soft" },
    { 10196, "www.thinkingmachines.com" },
    { 10197, "Vovtel Networks, Inc." },
    { 10198, "Carroll-Net, Inc." },
    { 10199, "projecthome limited" },
    { 10200, "i-mail-box project" },
    { 10201, "Eftel" },
    { 10202, "GFT Solutions" },
    { 10203, "Winter AG" },
    { 10204, "Shanghai SCOP Photonics Technology Co. ltd" },
    { 10205, "Apama" },
    { 10206, "ePIK'us Software" },
    { 10207, "Hilgraeve Inc." },
    { 10208, "Valnet Sado S.A." },
    { 10209, "Andes Networks, Inc." },
    { 10210, "AXS-One" },
    { 10211, "BENAU A/S" },
    { 10212, "Cutler & Company" },
    { 10213, "Meriton Networks" },
    { 10214, "ENIGMA SOI SP. Z O.O." },
    { 10215, "FORWARD Technical Co.Ltd" },
    { 10216, "Frantic Films" },
    { 10217, "HotDiary Inc" },
    { 10218, "Hsufarm" },
    { 10219, "I.D.E.A.L. Technology Corporation" },
    { 10220, "IFW Dresden" },
    { 10221, "IMPACT TECHNOLOGIES" },
    { 10222, "InfiniCon Systems" },
    { 10223, "Leo A Daly Company" },
    { 10224, "Lufthansa Systems Infratec GmbH" },
    { 10225, "Marrakech Ltd." },
    { 10226, "MyDN" },
    { 10227, "Neesus Datacom" },
    { 10228, "Net & Publication Consultance GmbH" },
    { 10229, "Netgate s.c." },
    { 10230, "Oriole Corporation" },
    { 10231, "Proficient Networks, Inc." },
    { 10232, "Signiant Corporation" },
    { 10233, "Silicon Goblin Technologies" },
    { 10234, "Snort.org" },
    { 10235, "Startrack Communications (Australia)Pty Ltd" },
    { 10236, "Studio komputerowe AWA" },
    { 10237, "Sullins, Inc." },
    { 10238, "Technische Universitaet Berlin (TU-Berlin)" },
    { 10239, "Tess SA" },
    { 10240, "TransNational Computer Technology" },
    { 10241, "TRPG Association" },
    { 10242, "University of Brighton" },
    { 10243, "Uplogix.com" },
    { 10244, "VALIDATA" },
    { 10245, "Valiosys SA" },
    { 10246, "Virtual Education Space" },
    { 10247, "CollegeUnits.com, Inc." },
    { 10248, "E.Central, Inc" },
    { 10249, "CINtel Intelligent Telecom System Co.,Ltd." },
    { 10250, "NegativeTwenty" },
    { 10251, "Warlock" },
    { 10252, "Diagnostic Laboratory Services, Inc." },
    { 10253, "Napster, Inc." },
    { 10254, "Texuna Technologies Moscow" },
    { 10255, "Infoquenz IT-Dienstleistungen GmbH" },
    { 10256, "ScioByte GmbH" },
    { 10257, "Hadithi Inc" },
    { 10258, "Aracnet Internet Services" },
    { 10259, "Avtec Systems, Inc." },
    { 10260, "BeamReach Networks" },
    { 10261, "Cedar Point Communications" },
    { 10262, "CNC Systems, Inc." },
    { 10263, "Custom Linux Solutions" },
    { 10264, "DATA & INFORMATION TECHNOLOGY LTD" },
    { 10265, "Deltathree, Inc" },
    { 10266, "DIZ Rheinland-Pfalz" },
    { 10267, "Electro Optic Systems" },
    { 10268, "Enterprise Commerce" },
    { 10269, "ePropose" },
    { 10270, "ES-Netze" },
    { 10271, "Forgent" },
    { 10272, "Future Instrument AB" },
    { 10273, "Giant Step Productions LLC" },
    { 10274, "HEXAFLUX-SMS" },
    { 10275, "Master a Distancia" },
    { 10276, "MSI Network Services, Ltd." },
    { 10277, "Multnomah Education Service District" },
    { 10278, "NetAcquire Corporation" },
    { 10279, "Object Valley (Asia Pacific) Limited" },
    { 10280, "Quixotech Systems" },
    { 10281, "SELECT Technology" },
    { 10282, "SpeedKom GmbH" },
    { 10283, "TABCORP" },
    { 10284, "Thomas Jefferson University" },
    { 10285, "Trenitalia S.p.A." },
    { 10286, "Trintech Inc." },
    { 10287, "University At Albany" },
    { 10288, "Vox Mobili" },
    { 10289, "Yukyung Telecom Co., Ltd." },
    { 10290, "Internet Business Constellation S.A." },
    { 10291, "j-m-f.demon.co.uk" },
    { 10292, "Laissez Faire City" },
    { 10293, "LINKAGE SYSTEM INTEGERATION CO.,LTD" },
    { 10294, "DATA SERVICE SRL" },
    { 10295, "iSOLUTION" },
    { 10296, "ITI Ltd." },
    { 10297, "Advantech Co., Ltd." },
    { 10298, "Arbeitsgemeinschaft fuer total abgehobene Technologie" },
    { 10299, "Avantia, Inc" },
    { 10300, "Avantron Technologies Inc." },
    { 10301, "Bluesocket Ltd" },
    { 10302, "Galaxy Systems, Incorporated" },
    { 10303, "ist isdn support technik GmbH" },
    { 10304, "LGT Financial Services" },
    { 10305, "Magnifix Sdn Bhd" },
    { 10306, "MSO Technologies" },
    { 10307, "Optical Solutions Inc" },
    { 10308, "OSGi" },
    { 10309, "SOHO Skyway" },
    { 10310, "tang-IT Consulting GmbH" },
    { 10311, "Kerio Technologies" },
    { 10312, "Translogic Systems, Inc." },
    { 10313, "Autinform GmbH" },
    { 10314, "Provenir" },
    { 10315, "Prima e.V." },
    { 10316, "Rafael Ltd." },
    { 10317, "Nanum Technology" },
    { 10318, "SaskTel International Ltd." },
    { 10319, "Semantics AG" },
    { 10320, "Amherst College" },
    { 10321, "AUNet" },
    { 10322, "Centre For Advanced Technology" },
    { 10323, "Convergence Network Research Ltd." },
    { 10324, "CrabusLDAP" },
    { 10325, "EarthConnect Corporation" },
    { 10326, "Ecole Nationale Superieure des Mines de Paris" },
    { 10327, "FiberCity Networks" },
    { 10328, "Globeflow SA" },
    { 10329, "Integra Micro Systems (P) Ltd." },
    { 10330, "KaVaDo Inc." },
    { 10331, "Lightning Data Networks" },
    { 10332, "MaxHosting GBR" },
    { 10333, "MetaNet" },
    { 10334, "Mischief Networking" },
    { 10335, "RLM Systems Pty. Ltd." },
    { 10336, "Summit Tech Communications" },
    { 10337, "Valis LTD" },
    { 10338, "Locale Systems" },
    { 10339, "StarRemote Wireless, Inc." },
    { 10340, "Indiana State University" },
    { 10341, "Klinik Loewenstein gGmbH" },
    { 10342, "Miami University" },
    { 10343, "NetExcell" },
    { 10344, "Netregistry Pty Ltd" },
    { 10345, "Newport Networks Limitd" },
    { 10346, "OmegaBand, Inc." },
    { 10347, "Plustream, Inc." },
    { 10348, "SOFTPRO GmbH & Co. KG" },
    { 10349, "Sysgem AG" },
    { 10350, "System Software Solutions" },
    { 10351, "Oblivion" },
    { 10352, "Retevisi\0303\0263n M\0303\0263vil, S.A." },
    { 10353, "InnoCom" },
    { 10354, "Brewster Academy" },
    { 10355, "ITAction" },
    { 10356, "Target Revocable E-Mail Corporation" },
    { 10357, "Roy S. Rapoport" },
    { 10358, "Accelio Corporation" },
    { 10359, "Adtel Software" },
    { 10360, "AgesMUD Technology, Co., Ltd." },
    { 10361, "Bharat Heavy Electricals Limited" },
    { 10362, "BluWare, Inc" },
    { 10363, "Catbird Networks" },
    { 10364, "Central Manchester City Learning Center" },
    { 10365, "Davox Corp." },
    { 10366, "Dialpad Communications" },
    { 10367, "donnie21" },
    { 10368, "Fujitsu Technology Solutions GmbH (formerly 'Fujitsu Siemens Computers')" },
    { 10369, "Fujitsu Prime Software Technologies Ltd." },
    { 10370, "Impulsesoft" },
    { 10371, "Inabyte Inc." },
    { 10372, "Intelligent Appliance Lab" },
    { 10373, "Le Reseau" },
    { 10374, "Lifeline Systems Inc" },
    { 10375, "Makina Corpus" },
    { 10376, "NETFRONT" },
    { 10377, "OnMobile System Inc" },
    { 10378, "PacketVideo" },
    { 10379, "Princeton Solutions Group" },
    { 10380, "TeleSys Software, Inc." },
    { 10381, "TrendPoint Systems" },
    { 10382, "UCNET" },
    { 10383, "Universite de Liege" },
    { 10384, "Virginia Commonwealth University" },
    { 10385, "Westronic Systems, Inc." },
    { 10386, "YoungWoo Telecom Co., LTD" },
    { 10387, "Dongah Elecomm" },
    { 10388, "Supportcomm Teleinformatica SA" },
    { 10389, "Intabo" },
    { 10390, "DELTA, Danish Electronics, Light & Acoustics" },
    { 10391, "Bharat Sanchar Nigam Limited" },
    { 10392, "Abeona Networks" },
    { 10393, "APEH" },
    { 10394, "Banamex, S.A." },
    { 10395, "Belo Corporation" },
    { 10396, "California State University, Office of the Chancellor" },
    { 10397, "CK Software GmbH (formerly 'CKSOFT, Christian Kratzer Software Entwicklung und Vertrieb')" },
    { 10398, "Covasoft, Inc." },
    { 10399, "Datakey" },
    { 10400, "Electric Lightwave, Inc." },
    { 10401, "Ideo Concepts Co. Ltd." },
    { 10402, "interdev" },
    { 10403, "Istituto Nazionale di Fisica Nucleare" },
    { 10404, "LivingLogic AG" },
    { 10405, "Mental Health Cooperative, Inc." },
    { 10406, "Neural Audio, Inc." },
    { 10407, "North Coast Software" },
    { 10408, "Percula Consulting GmbH" },
    { 10409, "Tellurian Pty Ltd" },
    { 10410, "The Falcon's Nest" },
    { 10411, "University of North Carolina at Chapel Hill" },
    { 10412, "aTelo, Inc." },
    { 10413, "System Innovations, Inc." },
    { 10414, "Brauerei C. & A. Veltins GmbH & Co." },
    { 10415, "3GPP" },
    { 10416, "ABC Virtual Communications" },
    { 10417, "Amerion, LLC" },
    { 10418, "Avocent Corporation" },
    { 10419, "Bactol Technical Limited" },
    { 10420, "Bayerisches Landeskriminalamt Abt. IuK" },
    { 10421, "C-CURE cvba" },
    { 10422, "China PTIC Information Industry Corporation" },
    { 10423, "CityXpress Corp." },
    { 10424, "Cricket Communications" },
    { 10425, "Electricity Generating Authority of Thailand" },
    { 10426, "Elex NV" },
    { 10427, "Embrace Networks" },
    { 10428, "Furukawa Industrial S.A. - Curitiba" },
    { 10429, "Gelwarg.Net" },
    { 10430, "globalremote.com AG" },
    { 10431, "Ingenieurbuero Kittelberger GmbH" },
    { 10432, "Mott Community College" },
    { 10433, "MuTek Solution Inc." },
    { 10434, "NIKHEF" },
    { 10435, "Omnitel" },
    { 10436, "Oxford university" },
    { 10437, "Peppercon AG" },
    { 10438, "Portima SC" },
    { 10439, "Power Measurement Ltd" },
    { 10440, "Rose I.T. Solutions" },
    { 10441, "Silas Technologies, Inc." },
    { 10442, "Spider Networks" },
    { 10443, "Three Pillars" },
    { 10444, "tichen.net" },
    { 10445, "Trillium Photonics" },
    { 10446, "Trinity Expert Systems plc" },
    { 10447, "University of Mississippi" },
    { 10448, "University of Puget Sound" },
    { 10449, "Xceedium, Inc." },
    { 10450, "Altamar Networks" },
    { 10451, "Boston Market Corporation" },
    { 10452, "Egton Medical Information Systems Ltd" },
    { 10453, "IL JIN TELECOM ELEC.CO., Ltd." },
    { 10454, "Optical Crossing Inc" },
    { 10455, "Paradigm" },
    { 10456, "PLANET Technology Corp." },
    { 10457, "DB Informatik Dienste GmbH" },
    { 10458, "2000-X Technologies, Inc." },
    { 10459, "Hexin Software" },
    { 10460, "HiSolutions AG" },
    { 10461, "Tixo Consulting" },
    { 10462, "Atek Ltd." },
    { 10463, "DEVK Versicherungen" },
    { 10464, "elata plc" },
    { 10465, "Flypaper" },
    { 10466, "Holim Technology" },
    { 10467, "Ingenieurb\0303\0274ro J\0303\0266rg Geistmann" },
    { 10468, "IRTNOG.ORG" },
    { 10469, "Lidcam Technology Pty Ltd" },
    { 10470, "Media Brokers International" },
    { 10471, "OpenFortress" },
    { 10472, "Recourse Technologies, Inc." },
    { 10473, "SEB AB" },
    { 10474, "Servlets.Net Corporation" },
    { 10475, "Slovak University of Agriculture" },
    { 10476, "Summit Media Partners, LLC" },
    { 10477, "Telephony@Work Inc." },
    { 10478, "Transeonic Systems, Inc." },
    { 10479, "Web Services, Inc." },
    { 10480, "Wily Technology" },
    { 10481, "AlJISR Information Services" },
    { 10482, "Nortel" },
    { 10483, "Winalysis Software" },
    { 10484, "TF1 sa" },
    { 10485, "About Web Services" },
    { 10486, "Aspelle Ltd" },
    { 10487, "Business Information Publications" },
    { 10488, "Chelsio Communications" },
    { 10489, "Design Combus Ltd" },
    { 10490, "GNF" },
    { 10491, "Hampshire College" },
    { 10492, "HST High Soft Tech GmbH" },
    { 10493, "Innovance Networks Inc." },
    { 10494, "InphoMatch Inc." },
    { 10495, "Interlink, Inc" },
    { 10496, "Link Simulation & Training" },
    { 10497, "Maly's of California" },
    { 10498, "michaeljcrawford.com" },
    { 10499, "Ministerium des Innern Sachsen-Anhalt" },
    { 10500, "Music Choice" },
    { 10501, "Netman Company" },
    { 10502, "North Dakota University System" },
    { 10503, "Power Innovations International" },
    { 10504, "Printronix, Inc." },
    { 10505, "Quorus Medical Systems" },
    { 10506, "RadioShack Corporation" },
    { 10507, "Reciproca" },
    { 10508, "Res Mod Man" },
    { 10509, "Rightvision" },
    { 10510, "ScreamingMedia" },
    { 10511, "SimpleDevices, Inc." },
    { 10512, "Spectrum Image" },
    { 10513, "Steltor" },
    { 10514, "StrongAuth, Inc." },
    { 10515, "Terry Nazon Inc" },
    { 10516, "T-Nova GmbH, Deutsche Telekom" },
    { 10517, "Toronto POlice Service" },
    { 10518, "TrunkNet" },
    { 10519, "Tsinghua Unisplendour Co., ltd" },
    { 10520, "Tyco Electronics Power Systems" },
    { 10521, "VoicePlanet, Inc." },
    { 10522, "Voigt & Haeffner GmbH" },
    { 10523, "Wanadoo Data" },
    { 10524, "Widevine Technologies" },
    { 10525, "Evangelisch Lutherische Kirche Bayern" },
    { 10526, "Facultad de Ingenieria" },
    { 10527, "METRObility Optical Systems, Inc." },
    { 10528, "Solid Information Technology Corp" },
    { 10529, "Gemtek Systems Holding BV" },
    { 10530, "NordicEdge" },
    { 10531, "C.T.Com" },
    { 10532, "RifeTech Inc." },
    { 10533, "SEITENBAU online agentur GbmH" },
    { 10534, "SECOM Co., Ltd." },
    { 10535, "London Internet Exchange" },
    { 10536, "Simon's Rock College of Bard" },
    { 10537, "AB Trav och Galopp" },
    { 10538, "Abstrakt Design" },
    { 10539, "AlwaysOn Ltd" },
    { 10540, "AXL Software" },
    { 10541, "Caymasa El Sendero, SA" },
    { 10542, "ChongQing GRC Telecom Co., Ltd" },
    { 10543, "DeJarnette Research Systems, Inc." },
    { 10544, "Factual Data" },
    { 10545, "gentics net.solutions" },
    { 10546, "Inturio Property Rights Holdings Limited" },
    { 10547, "Matrix Applied Computing Ltd" },
    { 10548, "Netzwert AG" },
    { 10549, "NewVation" },
    { 10550, "n-tv GmbH & Co. KG" },
    { 10551, "parergy" },
    { 10552, "Passlogix Inc." },
    { 10553, "Q-Networks" },
    { 10554, "Qwest Wireless, L.L.C" },
    { 10555, "Ramcar Group of Companies" },
    { 10556, "recomp GmbH Netzwerke & Systemberatung" },
    { 10557, "Sherwood International Limited" },
    { 10558, "Silogix" },
    { 10559, "Softeck" },
    { 10560, "South Florida Water Management District" },
    { 10561, "Star Valley Solutions Inc." },
    { 10562, "Werkleitz Gesellschaft e.V." },
    { 10563, "Portland Public Schools" },
    { 10564, "T.I.A. Scandinavia" },
    { 10565, "Universite de Savoie" },
    { 10566, "Universiti Pendidikan Sultan Idris" },
    { 10567, "eyou.net Corp." },
    { 10568, "China Sunbo Corp." },
    { 10569, "Coker Net" },
    { 10570, "Manly Man Club" },
    { 10571, "Merck KGaA" },
    { 10572, "100world.com AG" },
    { 10573, "Aitech Space Systems Inc." },
    { 10574, "Carbon Based Pty Ltd." },
    { 10575, "Cumulus IT AS" },
    { 10576, "Cygsoft Limited" },
    { 10577, "Eilat On-Line Ltd." },
    { 10578, "Electric Insurance Company" },
    { 10579, "Eswoosh" },
    { 10580, "Handspring, Inc" },
    { 10581, "Icomera" },
    { 10582, "Linear Systems Ltd." },
    { 10583, "Netizen S.A." },
    { 10584, "Hopcount Limited" },
    { 10585, "Paris-alesia" },
    { 10586, "PennWell Corp" },
    { 10587, "PharmaPartners B.V." },
    { 10588, "Pixelboxx GmbH" },
    { 10589, "Rocketrader.com" },
    { 10590, "Sage Information Consultants , Inc." },
    { 10591, "Salix Training Limited" },
    { 10592, "SolutionInc" },
    { 10593, "SYBCOM GmbH" },
    { 10594, "Transynergy" },
    { 10595, "Tyrell Software Corporation" },
    { 10596, "Vignon Informatique France" },
    { 10597, "Alliance Capital" },
    { 10598, "Applied System Design" },
    { 10599, "Department of Families" },
    { 10600, "Innovative Computing Laboratory" },
    { 10601, "Jataayu Software Pvt Ltd." },
    { 10602, "JIERA" },
    { 10603, "Kafre" },
    { 10604, "Zarlink Semiconductor" },
    { 10605, "Infodesk S. A." },
    { 10606, "IntraCom Australia Pty Ltd" },
    { 10607, "ACG Solutions, LLC" },
    { 10608, "alpha-lab" },
    { 10609, "Applied Science Fiction" },
    { 10610, "Aubergiste Inc." },
    { 10611, "BLU SPA" },
    { 10612, "Centralny Osrodek Informatyki Gornictwa S.A." },
    { 10613, "Envivio" },
    { 10614, "Equity Technology Group, Inc." },
    { 10615, "GartonWorks, Inc." },
    { 10616, "GeDInfo s.c.r.l." },
    { 10617, "INFO Consulting GmbH" },
    { 10618, "InfoStream ASP" },
    { 10619, "innuworks" },
    { 10620, "iSoftel Ltd" },
    { 10621, "bvba Med. Kab. dr. Sebrechts E." },
    { 10622, "Karma Designs" },
    { 10623, "KnowledgeCube" },
    { 10624, "Richard Lucassen Electronics" },
    { 10625, "Maincube Inc." },
    { 10626, "Mulvey Family" },
    { 10627, "N-SOFT" },
    { 10628, "Project 49 AG" },
    { 10629, "Questus Group, Inc." },
    { 10630, "Scintec AG" },
    { 10631, "SeRIQA Networks" },
    { 10632, "Telecomet International" },
    { 10633, "TICOM, Inc." },
    { 10634, "Trio Networks" },
    { 10635, "Tucows Inc." },
    { 10636, "University of Applied Sciences Cologne" },
    { 10637, "Vanderbilt University Medical Center" },
    { 10638, "Venation" },
    { 10639, "Unassigned" },
    { 10640, "West Interactive Corporation" },
    { 10641, "White Eagle Informatics" },
    { 10642, "Zebra Technologies Corporation" },
    { 10643, "NC Soft" },
    { 10644, "Interactive Software Design" },
    { 10645, "Pandanus Ltd" },
    { 10646, "ADI Computer Solutions" },
    { 10647, "Advanced Science & Technology Institute" },
    { 10648, "BlazeNet Ltd." },
    { 10649, "DST Innovis" },
    { 10650, "Easter-eggs" },
    { 10651, "ENAC" },
    { 10652, "Ezitrust Limited" },
    { 10653, "Fotre & Associates" },
    { 10654, "Future Space, S.A." },
    { 10655, "Global Office Software Pty Ltd" },
    { 10656, "Hardy and Associates" },
    { 10657, "InfoCyclone Ltd." },
    { 10658, "IP Services" },
    { 10659, "ISR Global Telecom, Inc." },
    { 10660, "KeyTrend Technology (S) Pte Ltd" },
    { 10661, "MainBrain" },
    { 10662, "Mid-Hudson Communications" },
    { 10663, "MQS" },
    { 10664, "Netropolis" },
    { 10665, "Ocyrus" },
    { 10666, "Organization of Residence Students" },
    { 10667, "Proxima Technology Pty Ltd" },
    { 10668, "riodata GmbH" },
    { 10669, "San Miguel Industrial S.A." },
    { 10670, "Solutions E.T.C. GmbH" },
    { 10671, "studio Alpha" },
    { 10672, "Swarthmore College" },
    { 10673, "TELEM GmbH" },
    { 10674, "TOP-keskus" },
    { 10675, "UNESCO" },
    { 10676, "UniData Communication Systems, Inc" },
    { 10677, "University of Debrecen" },
    { 10678, "WorldWideWatson" },
    { 10679, "Zzyzx Technologies Inc." },
    { 10680, "CAPCom AG" },
    { 10681, "KASYS Incorporated" },
    { 10682, "UDcast" },
    { 10683, "Heaman System co.,ltd." },
    { 10684, "Terabolic" },
    { 10685, "Object Tools Limited" },
    { 10686, "Thruport Technologies" },
    { 10687, "Townsend Communications, Inc." },
    { 10688, "Unassigned" },
    { 10689, "Ahaza Systems" },
    { 10690, "Celltrex LTD" },
    { 10691, "Chataigner" },
    { 10692, "freenet.de AG" },
    { 10693, "iTopia Inc." },
    { 10694, "Measurable Solutions, Inc." },
    { 10695, "NIXC, Inc." },
    { 10696, "Nuxeo" },
    { 10697, "Optio Software, Inc." },
    { 10698, "Sanit\0303\0244tsbetrieb Meran" },
    { 10699, "SpellCaster Telecommunications Inc." },
    { 10700, "Bulldog Technologies" },
    { 10701, "Telefonica DataCorp, S.A." },
    { 10702, "Solvare" },
    { 10703, "ATnet" },
    { 10704, "Barracuda Networks AG (formerly 'phion Information Technologies')" },
    { 10705, "VOGT electronic AG" },
    { 10706, "Accelerated Encryption Processing Ltd" },
    { 10707, "Adhersis" },
    { 10708, "Advanced System Architectures Ltd" },
    { 10709, "ATUX" },
    { 10710, "Avanade Inc" },
    { 10711, "BAWI" },
    { 10712, "Belkamneft" },
    { 10713, "Chevin Ltd" },
    { 10714, "Dimension Data" },
    { 10715, "ForwardPath" },
    { 10716, "Freedomland ITN SpA" },
    { 10717, "Genie Telecom" },
    { 10718, "Harris Wilder Pty Ltd" },
    { 10719, "Atos Origin Nederland B.V. (aonl)" },
    { 10720, "LIMSI" },
    { 10721, "Britestream Networks, Inc." },
    { 10722, "Marque d'Or" },
    { 10723, "Mercury PS" },
    { 10724, "Morpheus Net" },
    { 10725, "Pacific Internet Ltd" },
    { 10726, "Quantiva, Inc" },
    { 10727, "Red Cientifica Peruana" },
    { 10728, "Redline Communications Inc." },
    { 10729, "Red-M Communications Ltd" },
    { 10730, "SEE Telecom" },
    { 10731, "Silicon Energy" },
    { 10732, "Symbidia Limited" },
    { 10733, "The Mercury File System" },
    { 10734, "TippingPoint Technologies" },
    { 10735, "Unicorn Holding a.s." },
    { 10736, "University of Denver" },
    { 10737, "Web Simulation" },
    { 10738, "Comuniq Inc." },
    { 10739, "DELPHIC Medical Systems" },
    { 10740, "Neodev" },
    { 10741, "Vertical Inversion Systems, Inc." },
    { 10742, "Nozema N.V." },
    { 10743, "Riksf\0303\0266rs\0303\0244kringsverket (RFV)" },
    { 10744, "Kvarnb\0303\0244cken Konsult AB" },
    { 10745, "CSO Lanifex GmbH" },
    { 10746, "Rechenzentrum der Bundesfinanzverwaltung Frankfurt am Main" },
    { 10747, "Rowan University" },
    { 10748, "Software Factory GmbH" },
    { 10749, "/dev/secure Pty Ltd" },
    { 10750, "3G-Scene Plc" },
    { 10751, "3Plex" },
    { 10752, "Artiman Oy" },
    { 10753, "Billing for Enterprises" },
    { 10754, "CAS Tecnologia S/A" },
    { 10755, "ChipData, Inc." },
    { 10756, "Chongho Information & Communications co., LTD" },
    { 10757, "Diogenes, Inc." },
    { 10758, "Elyzium Limited" },
    { 10759, "Energos asa" },
    { 10760, "Gravity Hill Technologies, Inc." },
    { 10761, "Greenheck Fan" },
    { 10762, "Horizon Web Graphics" },
    { 10763, "HanSung Teliann, Inc" },
    { 10764, "Infotrek" },
    { 10765, "INZEN Co., Ltd." },
    { 10766, "ISG Systems AB" },
    { 10767, "James Madison University" },
    { 10768, "L'Envol Limited" },
    { 10769, "ITDZ Berlin" },
    { 10770, "Make-Ing.com.ar" },
    { 10771, "Morrison Academy" },
    { 10772, "novalis media" },
    { 10773, "Pacific Northwest Networks, Inc." },
    { 10774, "Perforations Ltd" },
    { 10775, "PERI Formwork Systems, Inc." },
    { 10776, "Reactive Network Solutions Inc" },
    { 10777, "Revicon Srl" },
    { 10778, "RTCL Lab, University of Michigan" },
    { 10779, "Sparkassenversicherung Wiesbaden" },
    { 10780, "SWAN, s.r.o." },
    { 10781, "Schneider Electric Buildings AB (previous was 'TAC AB')" },
    { 10782, "TAZZ Networks" },
    { 10783, "The Church of Jesus Christ of Latter-Day Saints" },
    { 10784, "Time & Frequency Solutions Ltd" },
    { 10785, "Transtech Networks" },
    { 10786, "UNSW Physics APT" },
    { 10787, "Verity, Inc." },
    { 10788, "Volt Information Sciences" },
    { 10789, "WebAgents GmbH" },
    { 10790, "Websilicon" },
    { 10791, "WestOne" },
    { 10792, "Xeline Co., Ltd." },
    { 10793, "YourASP Pty Ltd" },
    { 10794, "ZTR Control System" },
    { 10795, "Bizz Technologies SAS" },
    { 10796, "C.R.F. Consulting Ltd" },
    { 10797, "Commercial Data Systems" },
    { 10798, "Commtel" },
    { 10799, "Jungo Software Technologies Ltd." },
    { 10800, "Kinor" },
    { 10801, "Rapid 7, Inc." },
    { 10802, "RBG" },
    { 10803, "Staudinger Wels" },
    { 10804, "Union Bank of California" },
    { 10805, "Wedgetail Communications" },
    { 10806, "Xebeo Communications, Inc." },
    { 10807, "Centrale Financien Instellingen" },
    { 10808, "China Greatwall Computer Shenzhen Co., LTD" },
    { 10809, "Disha Technologies" },
    { 10810, "Nobelmann" },
    { 10811, "XiaMen Good First Optics Electricity Integration CO.,LTD" },
    { 10812, "InfoTeCs" },
    { 10813, "Centre National de la Recherche Scientifique" },
    { 10814, "UNIFIED Technologies, Inc." },
    { 10815, "CyberTrader, Inc." },
    { 10816, "Datang Radio Communication Branch" },
    { 10817, "Heraeus Holding GmbH" },
    { 10818, ".windh AB" },
    { 10819, "[IIX-NAP] MAHATEL, PT" },
    { 10820, "LM Sistemas" },
    { 10821, "Absolight" },
    { 10822, "ADTEC" },
    { 10823, "Advanced Research & Technology Ltd" },
    { 10824, "AGAVA Software Ltd." },
    { 10825, "Alectta" },
    { 10826, "Alice-Salomon-Fachhochschule f\0303\0274r Sozialarbeit und Sozialp\0303\0244dagogik Berlin" },
    { 10827, "ALVE Technology Corporation" },
    { 10828, "American Data Technology, Inc." },
    { 10829, "Andover Controls Corporation" },
    { 10830, "APCON, Inc." },
    { 10831, "At Oliver.com" },
    { 10832, "B2C2, Inc." },
    { 10833, "binarycore networks" },
    { 10834, "CargoBay" },
    { 10835, "cartoonviolence.net" },
    { 10836, "Command-e Technology Co., Ltd." },
    { 10837, "CompHealth" },
    { 10838, "Contec C.V." },
    { 10839, "DISTRIBUTEL" },
    { 10840, "Dragon Computer Consultants Inc." },
    { 10841, "Ejasent Inc." },
    { 10842, "EnBW Systeme Infrastruktur Support GmbH" },
    { 10843, "Ferret" },
    { 10844, "Fidelia, Inc." },
    { 10845, "grandmas, inc" },
    { 10846, "Impact Technologies, Inc." },
    { 10847, "Insystek Inc." },
    { 10848, "IPfonix, Inc." },
    { 10849, "Ithiriel Software" },
    { 10850, "KEFTA Inc." },
    { 10851, "Knowledge Intelligence AG" },
    { 10852, "Kuulalaakeri Oy" },
    { 10853, "LTC Sp z o.o." },
    { 10854, "Lviv National Polytechnical University" },
    { 10855, "Mascon Communication Technologies" },
    { 10856, "Menlo Park Technologies" },
    { 10857, "Mindframe Software & Services Pvt. Ltd." },
    { 10858, "Mycon Networks" },
    { 10859, "myinternet Ltd" },
    { 10860, "Naumann EDV" },
    { 10861, "Niels Bohr Institute" },
    { 10862, "NOAH Industries, Inc." },
    { 10863, "Odyssey Technologies Limited" },
    { 10864, "Pacific University" },
    { 10865, "Pete Wilson, consulting software engineer" },
    { 10866, "Philip M Lembo" },
    { 10867, "playdead networks" },
    { 10868, "PremiTech A/S" },
    { 10869, "Datalogic Mobile, Inc." },
    { 10870, "Safewww r&d Ltd" },
    { 10871, "Shanghai Teraband Phtonics Co., Ltd." },
    { 10872, "SkyFlow Inc" },
    { 10873, "Soros Foundation Kazakhstan" },
    { 10874, "Spectrum Astro Inc" },
    { 10875, "SSH Communications Security Corp." },
    { 10876, "Super Micro Computer Inc." },
    { 10877, "System Services Sp. z o. o." },
    { 10878, "Techlink Desenvolvimentos Tecnologicos Ltda" },
    { 10879, "Tenebras, LLC" },
    { 10880, "Togabi Technologies, Inc." },
    { 10881, "Uffizio Software Consultants Pvt. Ltd." },
    { 10882, "Universit\0303\0251 Paris 5" },
    { 10883, "Unassigned" },
    { 10884, "Vinzant, Inc." },
    { 10885, "Virtual Monet Technologies" },
    { 10886, "Westland Helicopters Ltd" },
    { 10887, "WizCom Ltd" },
    { 10888, "Xelus Inc" },
    { 10889, "AL Digital Ltd." },
    { 10890, "CommWorks" },
    { 10891, "Dave's Network Services" },
    { 10892, "Doctors.net.uk" },
    { 10893, "Iomedex Corporation" },
    { 10894, "Novra Technologies Inc." },
    { 10895, "Raonet Systems Inc." },
    { 10896, "The Career and Education Network, Inc." },
    { 10897, "RECOMBINANTWEB" },
    { 10898, "OOZOOD" },
    { 10899, "Consors Discount-Broker AG" },
    { 10900, "Serco" },
    { 10901, "Spinnaker Networks, Inc." },
    { 10902, "3IC Inc." },
    { 10903, "Activate" },
    { 10904, "Alpine-Mayreder BauGmbH" },
    { 10905, "Arsenal Digital Solutions" },
    { 10906, "A-SK Computers" },
    { 10907, "Ateb Limited" },
    { 10908, "Bigsur Communications" },
    { 10909, "BroadTel Communications" },
    { 10910, "Chateau Systems, Inc" },
    { 10911, "Appello, a.s." },
    { 10912, "Cincom Systems, Inc." },
    { 10913, "Client Software International" },
    { 10914, "COLT Telecommunications" },
    { 10915, "ConAgra Foods, Inc." },
    { 10916, "Cyneta Networks" },
    { 10917, "Datamax Coporation" },
    { 10918, "Datamission" },
    { 10919, "dbap GmbH" },
    { 10920, "Dir Solutions bv" },
    { 10921, "Drumgrange Limited" },
    { 10922, "ELSIS" },
    { 10923, "Ericsson AB - Packet Core Networks" },
    { 10924, "ESTOS GmbH" },
    { 10925, "Firmseek" },
    { 10926, "Food Brokers Limited" },
    { 10927, "Fullsix" },
    { 10928, "Fybubblan.com Consulting" },
    { 10929, "GCD Printlayout" },
    { 10930, "Georg-August Univeristy Goettingen (Internet-AG)" },
    { 10931, "GIGA STREAM - UMTS Technologies GmbH" },
    { 10932, "Gunadarma University" },
    { 10933, "H.A. Technical Solutions" },
    { 10934, "Hamsch" },
    { 10935, "Horizon Digital Enterprise, Inc." },
    { 10936, "Ijichi Research" },
    { 10937, "INFALSYS" },
    { 10938, "International Messaging Associates Corporation" },
    { 10939, "internet news" },
    { 10940, "JD Thomlinson, Ltd." },
    { 10941, "Kandalaya" },
    { 10942, "LifeLine Networks bv" },
    { 10943, "Linagora" },
    { 10944, "Maikis - EDV Dienstleistungen" },
    { 10945, "Midway Games West, Inc." },
    { 10946, "Mouselink Ltd" },
    { 10947, "Multi-Druck GmbH" },
    { 10948, "MynaNET" },
    { 10949, "Netflix.com" },
    { 10950, "Netrake Corporation" },
    { 10951, "NetUSE AG" },
    { 10952, "NetZero Inc." },
    { 10953, "Nightlife.se" },
    { 10954, "nikolici.com" },
    { 10955, "Wescan Limited" },
    { 10956, "Noviforum, Ltd." },
    { 10957, "noze" },
    { 10958, "OLICORP Technologies" },
    { 10959, "Politechnika Warszawska" },
    { 10960, "Qualicontrol" },
    { 10961, "Ricciardi Technologies, Inc" },
    { 10962, "Rutgers, the State University of New Jersey" },
    { 10963, "SENA Systems" },
    { 10964, "SMT Data A/S" },
    { 10965, "SolidStreaming, Inc." },
    { 10966, "Sollie codeWorks" },
    { 10967, "Surftool Systems" },
    { 10968, "Systematic Software Engineering A/S" },
    { 10969, "Thales Communications" },
    { 10970, "Threshold Networks" },
    { 10971, "VPN Dynamics, Inc." },
    { 10972, "WIT-Software" },
    { 10973, "XMS" },
    { 10974, "Youngstown State University" },
    { 10975, "Zion Software, LLC" },
    { 10976, "Zoomtown.com" },
    { 10977, "Grid-Ireland" },
    { 10978, "Kumamoto Industrial Research Institute" },
    { 10979, "Capitel Group" },
    { 10980, "IQStor Networks" },
    { 10981, "RouterD Networks Limited" },
    { 10982, "UBS Warburg" },
    { 10983, "BTG, Inc." },
    { 10984, "bvba Woodstone" },
    { 10985, "Jive Software" },
    { 10986, "Beijing Polytechnic University" },
    { 10987, "Eircell 2000" },
    { 10988, "SoloMio Corporation" },
    { 10989, "Alibre Incorporated" },
    { 10990, "Astrum Consulting" },
    { 10991, "Axis Integrated" },
    { 10992, "Babel Professional Services srl" },
    { 10993, "BabelTech A/S" },
    { 10994, "BISS GmbH" },
    { 10995, "Blue Mug" },
    { 10996, "CCSS (Europe) Ltd" },
    { 10997, "Connection Software" },
    { 10998, "Conversant Systems, LLC" },
    { 10999, "COS AG / Austria" },
    { 11000, "Creative Networking Solutions" },
    { 11001, "Dreyer Consulting" },
    { 11002, "Du Maurier Ltd" },
    { 11003, "e^deltacom" },
    { 11004, "EarthTrax, Inc." },
    { 11005, "E-Certify" },
    { 11006, "FlashNet Computers Ltd" },
    { 11007, "FMV, Swedish Defence Materiel Administration" },
    { 11008, "Fujiwara Soft Office, Co., Ltd." },
    { 11009, "Hadmut Danisch" },
    { 11010, "Harrison Family Organization" },
    { 11011, "HiWAAY Information Services" },
    { 11012, "ImagineAsia, Inc." },
    { 11013, "LEC Information Systems" },
    { 11014, "Liberty University" },
    { 11015, "Lokomo Systems AB" },
    { 11016, "ManageStar.com, Inc." },
    { 11017, "MARA Systems AB" },
    { 11018, "Massillon Cable Communications" },
    { 11019, "MENTA" },
    { 11020, "MVP Systems, Inc." },
    { 11021, "N2 Broadband, Inc." },
    { 11022, "Omnisci Software, Inc." },
    { 11023, "Oxford University Computing Services" },
    { 11024, "P&S DataCom Corporation" },
    { 11025, "Pagoo" },
    { 11026, "Perfectway Corporation" },
    { 11027, "Physics Department, University of Kassel" },
    { 11028, "Reliable Networks, Inc." },
    { 11029, "Reziprozitaet Consulting" },
    { 11030, "RouteFree Inc" },
    { 11031, "SATEC SA" },
    { 11032, "Semandex Networks, Inc." },
    { 11033, "SentitO Networks" },
    { 11034, "Sentor Monitoring Systems Pty Ltd" },
    { 11035, "Sheer Genius Software" },
    { 11036, "Softax" },
    { 11037, "Stratyc L.L.C." },
    { 11038, "TECO SOFT Espa\0303\0261a, S.A." },
    { 11039, "Tivo, Inc." },
    { 11040, "Tool Banking Solutions" },
    { 11041, "UFSM" },
    { 11042, "ViaCLIX, Inc." },
    { 11043, "VIDA Software S.L." },
    { 11044, "Vodafone, Egypt" },
    { 11045, "Windborne Productions, Inc." },
    { 11046, "Zero Computing S.r.l." },
    { 11047, "AK-Industrieinformatik GmbH" },
    { 11048, "billiton internetservices" },
    { 11049, "CP Corporate Planning AG" },
    { 11050, "IDX Systems Corporations" },
    { 11051, "Point Systems" },
    { 11052, "Achmea Holding N.V." },
    { 11053, "Direct Internet, Inc." },
    { 11054, "Roman Seidl" },
    { 11055, "InnoAce CO., Ltd." },
    { 11056, "Allmycrap.com" },
    { 11057, "Eyefinity, Inc" },
    { 11058, "Hitachi Information & Telecommunication Engineering, Ltd." },
    { 11059, "IMPRESS SOFTWARE AG" },
    { 11060, "Intervoice-Brite" },
    { 11061, "Longitude, Inc." },
    { 11062, "Nurnberg Scientific" },
    { 11063, "PingMagic Limited" },
    { 11064, "RHB Securities" },
    { 11065, "Telcoware" },
    { 11066, "Teniad Technologies" },
    { 11067, "University of Belgrade" },
    { 11068, "Webscreen Technology Ltd." },
    { 11069, "Yandex" },
    { 11070, "uReach Technologies, Inc." },
    { 11071, "Motus Technologies" },
    { 11072, "IOTEC AB" },
    { 11073, "7th-Angel" },
    { 11074, "ALTER" },
    { 11075, "Antarix e Applications Limited" },
    { 11076, "Banesto S.A." },
    { 11077, "C.net d.o.o." },
    { 11078, "Centralworks LLC" },
    { 11079, "EIT Ltd" },
    { 11080, "Airwide Solutions (formerly 'First Hop')" },
    { 11081, "Hydrogen Line, Inc." },
    { 11082, "Illinois Central College" },
    { 11083, "Intersix Technologies S.A." },
    { 11084, "ITDevices, Inc." },
    { 11085, "Manojam" },
    { 11086, "MindTree Consulting Pvt Ltd" },
    { 11087, "Netforest Inc." },
    { 11088, "Netus Technologies Co., Ltd." },
    { 11089, "Preferred Systems" },
    { 11090, "Propero Limited" },
    { 11091, "Raze Technologies" },
    { 11092, "St. Boniface General Hospital" },
    { 11093, "Telamon Systems" },
    { 11094, "xpedite systems inc" },
    { 11095, "Loea Communications" },
    { 11096, "BlueArc, part of Hitachi Data Systems" },
    { 11097, "HEXAL AG" },
    { 11098, "ComTelco (North America), Inc." },
    { 11099, "Dickerson Enginering" },
    { 11100, "Linux NetworX" },
    { 11101, "NRI SecureTechnologies, Ltd." },
    { 11102, "OSA Technologies Inc." },
    { 11103, "Opus International Consultants Ltd" },
    { 11104, "Passback IT Consultancy" },
    { 11105, "Pivot Consulting Ltd" },
    { 11106, "Scene7, Inc" },
    { 11107, "Ucentric Systems" },
    { 11108, "WaveMarket, Inc." },
    { 11109, "XDV - Verein f\0303\0274r experimentelle Datenverarbeitung" },
    { 11110, "Arkivio" },
    { 11111, "Bell Ontario Service Assurance" },
    { 11112, "Stephen Gould Paper co" },
    { 11113, "BJC HealthCare" },
    { 11114, "Citrus communications GmbH" },
    { 11115, "George Fox University" },
    { 11116, "Marco Hentschel" },
    { 11117, "Vereniging Open DomeinZenon" },
    { 11118, "Alpha1 Communications" },
    { 11119, "123india.com" },
    { 11120, "Advanced Software Resources, Inc." },
    { 11121, "C3 Ltd" },
    { 11122, "Cencosud S.A." },
    { 11123, "Colruyt Group" },
    { 11124, "Contenture Ltd" },
    { 11125, "Domani Software Services" },
    { 11126, "ESCP-EAP" },
    { 11127, "Fst s.r.l." },
    { 11128, "Gadbois Consulting" },
    { 11129, "Google, Inc." },
    { 11130, "H\0303\0274lsmann Services e.K." },
    { 11131, "INSIDERS Information Management GmbH" },
    { 11132, "Integral Solutions Corporation" },
    { 11133, "Jemmac Software Limited" },
    { 11134, "Lentronics" },
    { 11135, "Marian Eichhloz" },
    { 11136, "Meitetsu System Dev Co.Ltd" },
    { 11137, "Metaparadigm Pte Ltd" },
    { 11138, "mFormation Technologies Inc." },
    { 11139, "NeoWiz Corporation" },
    { 11140, "Network Center, Shanghai Jiaotong University" },
    { 11141, "Omneon Video Networks" },
    { 11142, "O\0303\0226 Online" },
    { 11143, "PCSNC" },
    { 11144, "RadPharm" },
    { 11145, "Siemens Financial Services GmbH" },
    { 11146, "Siemens Informations Systems Limited" },
    { 11147, "SVTO Hewlett-Packard" },
    { 11148, "Swan Systems" },
    { 11149, "TI, d.o.o." },
    { 11150, "Roamware Inc. (formerly 'Unwiredsoft')" },
    { 11151, "Urschel Laboratories Incorporated" },
    { 11152, "Vocalcom" },
    { 11153, "WebWear" },
    { 11154, "WireX Communications, Inc." },
    { 11155, "WVS-groep" },
    { 11156, "CDMEDIC" },
    { 11157, "MultiTech Solutions Inc." },
    { 11158, "Panservice" },
    { 11159, "PC Dialogs Inc." },
    { 11160, "TDK Corporation" },
    { 11161, "Wistron Corporation" },
    { 11162, "Advanced Campus Services" },
    { 11163, "HAL Computer Systems Ltd" },
    { 11164, "PBH Planungsbuero Hammer" },
    { 11165, "Acer Mobile Networks Inc." },
    { 11166, "ALLEWA GmbH" },
    { 11167, "Azurtec, Inc." },
    { 11168, "Banca del Gottardo" },
    { 11169, "Beacon Bioscience, Inc." },
    { 11170, "Commsology" },
    { 11171, "CRoL" },
    { 11172, "Die Informatik-Werkstatt GmbH" },
    { 11173, "Directory Solutions" },
    { 11174, "DX Antenna Co., Ltd." },
    { 11175, "Epic Group plc" },
    { 11176, "Objective Pathology Services Limited (formerly 'Extelligence')" },
    { 11177, "Grapevine Interactive (Pty) Ltd" },
    { 11178, "Guardian Controls International" },
    { 11179, "hereUare Communications, Inc." },
    { 11180, "Invisible Hand Networks" },
    { 11181, "Jan Schmidt DV-Beratung" },
    { 11182, "Kretz Industries" },
    { 11183, "Mitac International Corp." },
    { 11184, "Naray Information & Communication Enterprise" },
    { 11185, "POSSIO AB" },
    { 11186, "Rattan Information" },
    { 11187, "SNV Netherlands Development Organisation" },
    { 11188, "Universitat Rovira i Virgili" },
    { 11189, "University of Applied Sciences Schmalkalden" },
    { 11190, "Viox Services Inc." },
    { 11191, "Xiam" },
    { 11192, "Xiph.org Foundation" },
    { 11193, "Salica Ltd" },
    { 11194, "Wireless Maingate" },
    { 11195, "VECTOR sp. z o.o." },
    { 11196, "Marcant Internet Services GmbH" },
    { 11197, "A l Jazeera Satellite Channel" },
    { 11198, "Atrid Systemes" },
    { 11199, "Auspice, Inc." },
    { 11200, "BellSouth" },
    { 11201, "Benefit Systems, Inc" },
    { 11202, "Blue Sky Studios" },
    { 11203, "Cybermation Inc." },
    { 11204, "Entercept Security Technologies" },
    { 11205, "Environmental Systems Research Institute (ESRI)" },
    { 11206, "EPLS Enterprise Computing Pte Ltd" },
    { 11207, "Falk eSolutions AG" },
    { 11208, "Global Media Systems" },
    { 11209, "Gold Wire Technology" },
    { 11210, "Iain Stevenson" },
    { 11211, "MobiTV Inc. (formerly 'Idetic Incorporated')" },
    { 11212, "IDM" },
    { 11213, "Information Services Extended Inc." },
    { 11214, "Meridis Corporation" },
    { 11215, "Navitaire, Inc." },
    { 11216, "Neoware Systems" },
    { 11217, "Oceanet Technology" },
    { 11218, "Oculan Corp" },
    { 11219, "OpVista" },
    { 11220, "Pirelli Cavi e Sistemi S.p.A." },
    { 11221, "PROCON GmbH" },
    { 11222, "Rochester General Hospital" },
    { 11223, "RWT Telefony Polskie S.A." },
    { 11224, "SAEBEX (Pty) Ltd" },
    { 11225, "SCMB" },
    { 11226, "Skandinaviska Magasin1 AB" },
    { 11227, "StartCorp" },
    { 11228, "SystemBase Co,.Ltd." },
    { 11229, "Systemware" },
    { 11230, "Voice Access Technologies" },
    { 11231, "Wincom Systems, Inc." },
    { 11232, "Apocalypse Computing Services" },
    { 11233, "Harald Gliebe" },
    { 11234, "Hotcircles" },
    { 11235, "WhichMall.com" },
    { 11236, "Mosakin International Corporation" },
    { 11237, "ITEK spf" },
    { 11238, "APS Systeme" },
    { 11239, "Bennett, Coleman & Co. Ltd." },
    { 11240, "Caixa d'Estalvis i Pensions de Barcelona" },
    { 11241, "Carmel Secondary School" },
    { 11242, "Custom Electronics" },
    { 11243, "DCWG" },
    { 11244, "NET Control" },
    { 11245, "E2open" },
    { 11246, "GHZ Inc." },
    { 11247, "GlaxoSmithKline" },
    { 11248, "Greenwich Technology Partners, Inc." },
    { 11249, "i-DNS.net International Inc" },
    { 11250, "Indiana Purdue University Ft. Wayne" },
    { 11251, "Intrado Inc." },
    { 11252, "iTouch Labs" },
    { 11253, "J.P. Stephenson Co." },
    { 11254, "Jydsk Consulting" },
    { 11255, "LocatioNet Systems LTD" },
    { 11256, "Stormshield (formerly 'NETASQ')" },
    { 11257, "Net-ES" },
    { 11258, "Nogui AB" },
    { 11259, "Sepulveda Systems" },
    { 11260, "Single Source oy" },
    { 11261, "Tschaeche Services" },
    { 11262, "Wire Card AG" },
    { 11263, "WRnetworks" },
    { 11264, "MobileArts AB" },
    { 11265, "SET Software, Inc." },
    { 11266, "JiangSu Fujitsu Telecommunications Technology CO.,LTD." },
    { 11267, "DISSC - Presidencia del Gobierno" },
    { 11268, "Aastra" },
    { 11269, "Aculab plc" },
    { 11270, "Adelphia Business Solutions" },
    { 11271, "Aria Technology Pte Ltd" },
    { 11272, "Birdstep Technology" },
    { 11273, "BJB Software, Inc." },
    { 11274, "Centric Telecom Ltd" },
    { 11275, "ChangingWorlds" },
    { 11276, "Commil Ltd" },
    { 11277, "convergence integrated media gmbh" },
    { 11278, "CS Engineering b.v." },
    { 11279, "Datalab Technologia S.A." },
    { 11280, "Digimob Ltd" },
    { 11281, "digital bus" },
    { 11282, "DKSIN" },
    { 11283, "Dobsonics Laboratories" },
    { 11284, "ESW - EXTEL SYSTEMS WEDEL" },
    { 11285, "FlipDog.com" },
    { 11286, "H1" },
    { 11287, "High-Availability.com" },
    { 11288, "iCreate Software, Inc." },
    { 11289, "imagine LAN Inc." },
    { 11290, "Information Services Plc." },
    { 11291, "IONA Technologies" },
    { 11292, "La Factor\0303\0255a de Comunicaciones Aplicadas,S.L." },
    { 11293, "LocaNet" },
    { 11294, "Mobinor AS" },
    { 11295, "Cybercity" },
    { 11296, "Neon Software, Inc." },
    { 11297, "NetNet, Inc" },
    { 11298, "NLweb.com" },
    { 11299, "On Time Systems" },
    { 11300, "Passageways Travel" },
    { 11301, "Pearson Education" },
    { 11302, "Perimeter Technology" },
    { 11303, "PhotoniXnet Corporation" },
    { 11304, "PrinterOn Corporation" },
    { 11305, "Research Institute for Particle and Nuclear Physics, Department of Biophysics" },
    { 11306, "Robarts Research Institute" },
    { 11307, "Solarwinds.net" },
    { 11308, "SWAPCOM" },
    { 11309, "TallGrass Communications, Inc." },
    { 11310, "Technique Consultants Pty Ltd" },
    { 11311, "Tubitak - UEKAE" },
    { 11312, "Universit\0303\0240 di Salerno - D.I.A." },
    { 11313, "University of Calgary" },
    { 11314, "University of Kansas" },
    { 11315, "USAconnect" },
    { 11316, "ware solutions" },
    { 11317, "Wieland Electric GmbH" },
    { 11318, "Xerox Research" },
    { 11319, "Alcatel (Alcatel Bell Space)" },
    { 11320, "Communal CC GmbH" },
    { 11321, "ECI IP Inc." },
    { 11322, "Integrated Support Systems, Inc." },
    { 11323, "Manpower, Inc." },
    { 11324, "netsols.de" },
    { 11325, "OpenDesign, Inc." },
    { 11326, "Blue Scooter, Inc." },
    { 11327, "Xi'an Jiaotong University Jump network Technology Co.,Ltd" },
    { 11328, "Rana" },
    { 11329, "LLNL-NIF" },
    { 11330, "Inpronetwork corporation" },
    { 11331, "BetaSoft, Wojciech Kruk" },
    { 11332, "Broadstorm Telecommunications, Inc." },
    { 11333, "Media Data Systems Pte Ltd" },
    { 11334, "OLES polymedia AG" },
    { 11335, "Quris, Inc." },
    { 11336, "R-Squared Technologies" },
    { 11337, "Software Workhouse of Hite Lee" },
    { 11338, "Success Information System Co., Ltd." },
    { 11339, "Danam Communications Inc." },
    { 11340, "DREGIS Dresdner Global IT-Services Gesellschaft mbH" },
    { 11341, "NoWalls" },
    { 11342, "Finnet Networks Ltd." },
    { 11343, "Terra, Sol 3" },
    { 11344, "The FreeRADIUS Server Project" },
    { 11345, "[microstage] Ingenieurbuero Raphael Dierkes" },
    { 11346, "Provinzial Versicherung" },
    { 11347, "Academ Consulting Services" },
    { 11348, "Airbus" },
    { 11349, "at rete ag" },
    { 11350, "Bondcar.com" },
    { 11351, "Bouwens" },
    { 11352, "Cognigen Corporation" },
    { 11353, "Das Buero am Draht GmbH" },
    { 11354, "Data Design Systems Incorporated" },
    { 11355, "DataVault" },
    { 11356, "DTV - Technical Knowledge Center of Denmark" },
    { 11357, "edeal Schroeder Maihoefer GbR" },
    { 11358, "Elcommtech Corp." },
    { 11359, "EML Ltd" },
    { 11360, "Excenon" },
    { 11361, "FASTER CZ" },
    { 11362, "FCS Partners" },
    { 11363, "Federation of Norwegian Agricultural Cooperatives" },
    { 11364, "Gaeasoft Corp." },
    { 11365, "Orange Slovakia" },
    { 11366, "Goanna Graphics" },
    { 11367, "Helix GmbH" },
    { 11368, "IAVista, Inc." },
    { 11369, "LenovoEMC Ltd (formerly 'Iomega')" },
    { 11370, "ITT CO., Ltd." },
    { 11371, "jung myung telecom. co., Ltd." },
    { 11372, "Meret Optical Communications" },
    { 11373, "NetVision Sp. z o.o." },
    { 11374, "OKO Bank Group" },
    { 11375, "Pacific Geoscience Center" },
    { 11376, "Pedestal Software" },
    { 11377, "Product Technology Partners Ltd" },
    { 11378, "Quartz Electronics Ltd." },
    { 11379, "Radiant Rt." },
    { 11380, "Retek Inc" },
    { 11381, "Rogers Communications Inc" },
    { 11382, "RR Enterprises" },
    { 11383, "SaudiNet" },
    { 11384, "SevenLayer Services" },
    { 11385, "Spanlink Communications" },
    { 11386, "Studer" },
    { 11387, "T4 Consulting Group" },
    { 11388, "Tarantola Labs" },
    { 11389, "TECFA (Technologie de Formation et Apprentissage)" },
    { 11390, "Texas Department of Housing and Community Affairs" },
    { 11391, "The Texas GigaPOP" },
    { 11392, "Tools4ever bv" },
    { 11393, "Tymlabs Management Inc" },
    { 11394, "UD Technology" },
    { 11395, "Vancouver Public Library" },
    { 11396, "Webex China" },
    { 11397, "Xpedio AB" },
    { 11398, "Pyx Engineering AG" },
    { 11399, "Washington State University Vancouver" },
    { 11400, "Dept. of Information and Communications Technology, HK Institute ofVocational Education (Tsing Yi)" },
    { 11401, "CONCATEL, S.L." },
    { 11402, "MRO Software Inc." },
    { 11403, "Corente, Inc." },
    { 11404, "Seanet Corporation" },
    { 11405, "shanghaionline Inc." },
    { 11406, "SANDY Group" },
    { 11407, "obsceneskills.com" },
    { 11408, "Fiberhome Telecommunication Technologies Co.,LTD" },
    { 11409, "adequate systems GmbH" },
    { 11410, "Advanced Communication Devices Corp." },
    { 11411, "AOL Australia" },
    { 11412, "BKtel communications GmbH" },
    { 11413, "Cape Clear Software Ltd." },
    { 11414, "Carnation Technology Ltd." },
    { 11415, "CLCsoft" },
    { 11416, "Allgera Corp. (formerly 'Coalsere Inc.')" },
    { 11417, "Cynops GmbH" },
    { 11418, "DFN-CERT Services GmbH" },
    { 11419, "FOTEL Corp." },
    { 11420, "GHS Data Management" },
    { 11421, "Industrial Networking Solution" },
    { 11422, "Larmouth T&PDS Ltd" },
    { 11423, "Lucid Vision, Inc." },
    { 11424, "MITSUBISHI GAS CHEMICAL COMPANY, Inc." },
    { 11425, "MobileWebSurf" },
    { 11426, "Netfusions s.r.l." },
    { 11427, "Particle Physics Group" },
    { 11428, "Redes de Computadoras" },
    { 11429, "Schumacher" },
    { 11430, "Simtek Corporation" },
    { 11431, "Southern Polytechnic State University" },
    { 11432, "TOWER Group Network" },
    { 11433, "University of West Bohemia" },
    { 11434, "Utah Scientific, Inc." },
    { 11435, "WebEx Communications, Inc." },
    { 11436, "XML Global Technologies, Inc." },
    { 11437, "Xymbol" },
    { 11438, "Canadian Center for Remote Sensing (GeoAccess Division)" },
    { 11439, "CCLRC" },
    { 11440, "Sapros" },
    { 11441, "Goshen College" },
    { 11442, "InsertAds Inc." },
    { 11443, "Morder Devices" },
    { 11444, "Frederick Engineering" },
    { 11445, "ANOREG-BR" },
    { 11446, "Adduce Networks" },
    { 11447, "XiLogic, L.L.C." },
    { 11448, "ITology Co., Ltd" },
    { 11449, "Tethernet, Inc." },
    { 11450, "xitec.de" },
    { 11451, "SINBON ELECTRONIC CO., LTD" },
    { 11452, "Allegient Systems" },
    { 11453, "Altadis" },
    { 11454, "Avencis SA" },
    { 11455, "Aviation Management Technologies GmbH" },
    { 11456, "CalvaEDI S.A." },
    { 11457, "Cimcor, Inc." },
    { 11458, "Computing Services Department, University of Liverpool" },
    { 11459, "Data Track Technology PLC" },
    { 11460, "datafront" },
    { 11461, "Deloitte & Touche" },
    { 11462, "DroneDAP" },
    { 11463, "EC-Founder" },
    { 11464, "Electronic Arts" },
    { 11465, "Envoy Technologies" },
    { 11466, "e-Pollination Enterprise, Inc." },
    { 11467, "IntermediaSP" },
    { 11468, "Jackson County School District 6" },
    { 11469, "Kokong" },
    { 11470, "LX networking" },
    { 11471, "mineit software ltd" },
    { 11472, "MoeTi Corp." },
    { 11473, "Nordic Messaging Technologies AB" },
    { 11474, "NTT DATA COPORATION" },
    { 11475, "Pro-Active" },
    { 11476, "Quest Controls, Inc." },
    { 11477, "Rasvia Systems Incorporation" },
    { 11478, "Scorpion Controls Inc" },
    { 11479, "Selso" },
    { 11480, "SunnyInd Corp" },
    { 11481, "TEIMA Audiotex" },
    { 11482, "Universal Traffic Management Society of Japan(UTMS)" },
    { 11483, "University of Illinois at Urbana-Champaign" },
    { 11484, "viastore systems GmbH" },
    { 11485, "Vida Network Technologies, Inc." },
    { 11486, "Vizzavi NL" },
    { 11487, "VoxSurf Ltd." },
    { 11488, "AB Computers" },
    { 11489, "Alacritus" },
    { 11490, "BetweenMarkets, Inc." },
    { 11491, "University of Jyvaskyla" },
    { 11492, "Micro Research Laboratory, Inc." },
    { 11493, "Obourg Origny Informatique" },
    { 11494, "Nebulon Pty. Ltd." },
    { 11495, "cubic.ch" },
    { 11496, "foo.cz" },
    { 11497, "Gamerz.NET Enterprises" },
    { 11498, "HCCnet B.V." },
    { 11499, "Hollmann Consulting Services" },
    { 11500, "Infrant Technology Inc." },
    { 11501, "IngmarNet" },
    { 11502, "ITU-T ASN.1 Project" },
    { 11503, "METRAWARE" },
    { 11504, "NDSL, Inc." },
    { 11505, "Network-1 Security Solutions, Inc." },
    { 11506, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11507, "ProBusiness" },
    { 11508, "School of Banking and Management in Cracow" },
    { 11509, "Schweizer Electronic AG" },
    { 11510, "Service Intelligence" },
    { 11511, "Southern Illinois University School of Medicine" },
    { 11512, "St. Joseph's College" },
    { 11513, "Strele Informatik" },
    { 11514, "Chris Abernethy" },
    { 11515, "SUB1 S.A." },
    { 11516, "The Academy of Sciences of the Czech Republic" },
    { 11517, "Trivadis AG" },
    { 11518, "T-Soft Ltd." },
    { 11519, "VET" },
    { 11520, "Visilinx, Inc." },
    { 11521, "Broadcast Music Incorporated" },
    { 11522, "LINXTEK" },
    { 11523, "Fujitsu Laboratories of America, Inc." },
    { 11524, "Ch5 Finland Oy" },
    { 11525, "brain://on AG" },
    { 11526, "GIRO LTD" },
    { 11527, "Bromax Communications, Inc." },
    { 11528, "DVBern AG" },
    { 11529, "KOGA ELECTRONICS CO." },
    { 11530, "3G - NetWorks" },
    { 11531, "aha-systems" },
    { 11532, "Bond University" },
    { 11533, "Chiba Industries" },
    { 11534, "coaXmedia" },
    { 11535, "COGITIS" },
    { 11536, "Cyber-Ark" },
    { 11537, "Direcci\0303\0263n General de la Polic\0303\0255a" },
    { 11538, "Elata Ltd." },
    { 11539, "Essent Kabelcom" },
    { 11540, "ETIT" },
    { 11541, "Fugu Angst Productions" },
    { 11542, "GuangZhou GaoKe Communication Equipment Co., Ltd." },
    { 11543, "Internet Northwest" },
    { 11544, "Kunsthochschule Fuer Medien" },
    { 11545, "Kurtev Intergalactic" },
    { 11546, "METRAWARE" },
    { 11547, "Mpower Communications Corporation" },
    { 11548, "NABLA2 s.r.l." },
    { 11549, "NETOUS TECHNOLOGIES Ltd." },
    { 11550, "NETPIA SYSTEMS Co.,LTD" },
    { 11551, "Orca Orcinus, Inc." },
    { 11552, "page87" },
    { 11553, "Planet Technologies NV" },
    { 11554, "Pomcor" },
    { 11555, "Rider University" },
    { 11556, "Robert Burrell Donkin" },
    { 11557, "S&CI" },
    { 11558, "SOFICE" },
    { 11559, "SoftGame International Pty. Ltd." },
    { 11560, "Tantia Technologies Inc." },
    { 11561, "Topcon Positioning Systems, Inc." },
    { 11562, "VE2UG" },
    { 11563, "Ahnlab, Inc" },
    { 11564, "CiteItWrite" },
    { 11565, "Instituto Nacional de Estat\0303\0255stica - PORTUGAL" },
    { 11566, "Prologue Software" },
    { 11567, "DeltaLoyd Deutschland" },
    { 11568, "bmbwk" },
    { 11569, "handy.de Vertriebs GmbH" },
    { 11570, "Mages Touch" },
    { 11571, "NTI Studio's" },
    { 11572, "Rasvia Systems, Inc." },
    { 11573, "rockus.at" },
    { 11574, "Seven-Winds" },
    { 11575, "Solution Design Laboratory" },
    { 11576, "Sunnycal Inc." },
    { 11577, "Global System Services" },
    { 11578, "AirZip, Inc." },
    { 11579, "Amadeus Data Processing GmbH" },
    { 11580, "Amdocs" },
    { 11581, "bylinux.net" },
    { 11582, "C&I Technologies" },
    { 11583, "Cayenta, Inc." },
    { 11584, "CLASS AG" },
    { 11585, "ColoradoBiz.net" },
    { 11586, "DLR e.V." },
    { 11587, "epictet AG" },
    { 11588, "ERA a.s." },
    { 11589, "Exsior Data & Information Tech. Inc." },
    { 11590, "Fortech Ltd." },
    { 11591, "Free Software Foundation" },
    { 11592, "HANGZHOUSUNYARD INFORMATION ENGINEERING CO.,LTD" },
    { 11593, "IMISE" },
    { 11594, "LDCOM Networks" },
    { 11595, "Lightmaze AG" },
    { 11596, "Mediakabel" },
    { 11597, "MFB-Multa spol. s r.o." },
    { 11598, "MGIC - Mortgage Guaranty Insurance Corp" },
    { 11599, "mille21" },
    { 11600, "Neogration Inc." },
    { 11601, "Netaxs Internet Services" },
    { 11602, "New York State Office of the State Comptroller" },
    { 11603, "Nexxient Communications" },
    { 11604, "NorduGrid" },
    { 11605, "Optical Wireless Link Inc." },
    { 11606, "Pacific Broadbank Networks" },
    { 11607, "Plumtree Software" },
    { 11608, "Pracom Pty Ltd" },
    { 11609, "PUSANWEB Ltd" },
    { 11610, "Sandvine Incorporated" },
    { 11611, "Secretaria da Fazenda do Estado de Sp" },
    { 11612, "STT s.r.l." },
    { 11613, "Vortex Ltd" },
    { 11614, "vrwg" },
    { 11615, "Webaronet Technology" },
    { 11616, "WebPerform Group Ltd" },
    { 11617, "Cablevision Systems Holdings" },
    { 11618, "SOLTECH CO., Ltd." },
    { 11619, "PTC Solutions Ltd" },
    { 11620, "PACE Anti-Piracy" },
    { 11621, "Agrotecnica Arpa scrl" },
    { 11622, "3PARData" },
    { 11623, "Aegis Software" },
    { 11624, "Bit-Lab PTY LTD" },
    { 11625, "Black Bear Software, LLC" },
    { 11626, "Combol GmbH" },
    { 11627, "David Pitts" },
    { 11628, "EDIPORT Telecommunication Ltd." },
    { 11629, "Educational Service Unit #2" },
    { 11630, "eircomnet" },
    { 11631, "EnablingTrust LLC" },
    { 11632, "e-Sec Tecnologia em Seguranca de Dados LTDA" },
    { 11633, "Europop AG" },
    { 11634, "Exempla" },
    { 11635, "Fiorano Software Inc." },
    { 11636, "Focal Point Software, Inc." },
    { 11637, "Generatio GmbH" },
    { 11638, "Grapes Network Services" },
    { 11639, "Intersys Uruguay Ltda" },
    { 11640, "Miritek, Inc." },
    { 11641, "NETOVA" },
    { 11642, "Nextra Ensure (UK)" },
    { 11643, "One Stop Consulting, Inc." },
    { 11644, "Orbism Consulting" },
    { 11645, "Pentalog Inet" },
    { 11646, "PentaMedia Co., Ltd." },
    { 11647, "Planetasia Ltd.," },
    { 11648, "RemoteSite Technologies Inc." },
    { 11649, "Ross Stores, Inc." },
    { 11650, "Schnedermann Software-Consulting GmbH" },
    { 11651, "SideSpace" },
    { 11652, "Sonoma State University" },
    { 11653, "Stack Computer Solutions" },
    { 11654, "Strott Network Solutions" },
    { 11655, "SY.O. srl" },
    { 11656, "Synapse Systems AB" },
    { 11657, "Taiwan Telecommunication Network Services Co., Ltd." },
    { 11658, "Universite Blaise PASCAL" },
    { 11659, "Virtual Security Research" },
    { 11660, "VMS Limited" },
    { 11661, "Wahoo International Enterprise Co., Ltd." },
    { 11662, "Marcel Ruff" },
    { 11663, "+X Alta\0303\0257r Toulouse" },
    { 11664, "base2" },
    { 11665, "dacom" },
    { 11666, "Institute of Communications Engineering - University of Hanover" },
    { 11667, "New York State Education Department" },
    { 11668, "WRLucas" },
    { 11669, "Milhouse Technologies USA" },
    { 11670, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11671, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11672, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11673, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11674, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11675, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11676, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11677, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11678, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11679, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11680, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11681, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11682, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11683, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11684, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11685, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11686, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11687, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11688, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11689, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11690, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11691, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11692, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11693, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11694, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11695, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11696, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11697, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11698, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11699, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11700, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11701, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11702, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11703, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11704, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11705, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11706, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11707, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11708, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11709, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11710, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11711, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11712, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11713, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11714, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11715, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11716, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11717, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11718, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11719, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11720, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11721, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11722, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11723, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11724, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11725, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11726, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11727, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11728, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11729, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11730, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11731, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11732, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11733, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11734, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11735, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11736, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11737, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11738, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11739, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11740, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11741, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11742, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11743, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11744, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11745, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11746, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11747, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11748, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11749, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11750, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11751, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11752, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11753, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11754, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11755, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11756, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11757, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11758, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11759, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11760, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11761, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11762, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11763, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11764, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11765, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11766, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11767, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11768, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11769, sminmpec_unknown },  /* (Added by Wireshark) */
    { 11770, "China Sanjiang Space Group" },
    { 11771, "81 Broad Street" },
    { 11772, "Adrock Software" },
    { 11773, "AGMODEL, NARC, JAPAN" },
    { 11774, "ASYK S.A." },
    { 11775, "Atchik" },
    { 11776, "AviBit data processing GmbH" },
    { 11777, "Ayman LLC." },
    { 11778, "BlueBridge Technologies AG" },
    { 11779, "Casedev Active Oy" },
    { 11780, "CBIM" },
    { 11781, "celtro" },
    { 11782, "Charles Industries, LTD" },
    { 11783, "Canon Software Information Systems Inc." },
    { 11784, "Credant Technologies" },
    { 11785, "Critical Integration Ltd" },
    { 11786, "Daisy Software" },
    { 11787, "Datagate d.o.o." },
    { 11788, "fluxx.com e-commerce GmbH" },
    { 11789, "ForeScout Technologies, Inc." },
    { 11790, "GateWay Community College" },
    { 11791, "Giesecke and Devrient" },
    { 11792, "Grant County PUD" },
    { 11793, "IBM Slovakia (test)" },
    { 11794, "Incentive Technologies, Inc." },
    { 11795, "Infoglobe" },
    { 11796, "InnoviData GmbH" },
    { 11797, "Kaboom Enterprises" },
    { 11798, "Lateral Sands Pty Ltd" },
    { 11799, "Latis Networks, Inc" },
    { 11800, "Logosoft" },
    { 11801, "MPSV" },
    { 11802, "Northwest Airlines, Inc." },
    { 11803, "Ohlone Community College" },
    { 11804, "PCS" },
    { 11805, "Plexus" },
    { 11806, "Antonveneta ABN AMRO Bank" },
    { 11807, "SamuelBalle.com" },
    { 11808, "Sifry Consulting" },
    { 11809, "Skobeltsyn Institute of Nuclesr Physics, Moscow State University" },
    { 11810, "Solesys SA" },
    { 11811, "Spaces, Inc." },
    { 11812, "TDC Internet A/S" },
    { 11813, "TMT Ltd." },
    { 11814, "University of Nantes" },
    { 11815, "Yellow Online Inc." },
    { 11816, "yuantong technology" },
    { 11817, "Zentrum Informatikdienste, Universitaet Zuerich" },
    { 11818, "Z-Star Microelectronics Corporation" },
    { 11819, "ZX Factory" },
    { 11820, "Fonterra Co-operative Group" },
    { 11821, "Jet Infosystems" },
    { 11822, "SPSU Selinux-LDAP Team" },
    { 11823, "WSMicroSystems Inc." },
    { 11824, "Computer & Technologies International Ltd" },
    { 11825, "Daji Workshop" },
    { 11826, "Sistemas Tecnicos de Ense\0303\0261anza Consultores" },
    { 11827, "ACUMEN ADVANCED TECHNOLOGIES Inc." },
    { 11828, "Coast Mountains School District" },
    { 11829, "Corvil Networks" },
    { 11830, "F'Arty Crafts Pty Ltd" },
    { 11831, "Interactive Transaction Services, Inc." },
    { 11832, "Joerg Preuss" },
    { 11833, "nCircle Network Security" },
    { 11834, "PLIVA d.d" },
    { 11835, "StreamServe, Inc." },
    { 11836, "Swiss National Bank" },
    { 11837, "Telenor Mobile Communications" },
    { 11838, "Vistaar" },
    { 11839, "WebWayOne Ltd" },
    { 11840, "YR CONSEIL" },
    { 11841, "Aaltonen & Vuorela" },
    { 11842, "Anchora" },
    { 11843, "Argus Systems Group, Inc" },
    { 11844, "Beijing Super Channel Network Limited" },
    { 11845, "Blueair Networks" },
    { 11846, "CITAP" },
    { 11847, "Himnebaugh Consulting, Inc." },
    { 11848, "INLINE Corporation" },
    { 11849, "Janus Technologies" },
    { 11850, "Native Names Corporation" },
    { 11851, "NetEconomist" },
    { 11852, "New Productivity Initiative Inc" },
    { 11853, "Public Service Company of New Mexico" },
    { 11854, "Healthvision (formerly 'Quovadx, Inc.')" },
    { 11855, "Retirement By Design" },
    { 11856, "TNT Logistics North America" },
    { 11857, "Transmode Systems AB" },
    { 11858, "UANGEL" },
    { 11859, "WorldChain Inc." },
    { 11860, "wossname.org.uk" },
    { 11861, "Codenet" },
    { 11862, "Columbia University in the City of New York" },
    { 11863, "TP-Link Technology Co.,Ltd" },
    { 11864, "B\0303\0266ke and Walterfang Electronic Systems Ltd" },
    { 11865, "Explo-IT Research" },
    { 11866, "GDTTI" },
    { 11867, "Loop Treinamento em Inform" },
    { 11868, "Placenet" },
    { 11869, "Roman Zielinski Metod och systemutveckling" },
    { 11870, "Sandhills Community College" },
    { 11871, "SpaceNet AG" },
    { 11872, "Systemy Mikroprocesorowe" },
    { 11873, "Yolke Corporation" },
    { 11874, "Scopus Tecnologia S. A." },
    { 11875, "Biomet Merck BV" },
    { 11876, "Siteseers Inc." },
    { 11877, "3UP Systems" },
    { 11878, "Achilles Guard, Inc d.b.a Critical Watch" },
    { 11879, "Castel et Fromaget" },
    { 11880, "Custom Business Link, Inc." },
    { 11881, "FiberSpans Corporation" },
    { 11882, "geschke internet consulting" },
    { 11883, "Ignite Communications" },
    { 11884, "Indeed - Visual Concepts GmbH" },
    { 11885, "MMC Technology" },
    { 11886, "Nextcard, Inc." },
    { 11887, "PSS Systems Inc" },
    { 11888, "Teamlog External" },
    { 11889, "The Answer Group, L.L.C." },
    { 11890, "The Nog Network" },
    { 11891, "Unified Communications Pte Ltd" },
    { 11892, "Vodafone Global Platform & Internet Services" },
    { 11893, "The Pep Boys - Manny, Moe & Jack" },
    { 11894, "Integrity Solutions, Inc" },
    { 11895, "Globalnet" },
    { 11896, "3G Lab" },
    { 11897, "Acantho" },
    { 11898, "Agere Systems, Inc." },
    { 11899, "Bitfone Corporation" },
    { 11900, "BlueSoft" },
    { 11901, "Bonndata GmbH" },
    { 11902, "Cartel Communication Systems Inc" },
    { 11903, "Case Western Reserve University" },
    { 11904, "CirqueDigital, LLC" },
    { 11905, "Icom Inc" },
    { 11906, "IF DRAUDIMAS" },
    { 11907, "ImaginaryRealities" },
    { 11908, "Instituto Cubano de Radio y Television" },
    { 11909, "Log On America, Inc." },
    { 11910, "Michael Roettig Consulting" },
    { 11911, "Unassigned" },
    { 11912, "NetMotion Wireless Inc." },
    { 11913, "netsys.com" },
    { 11914, "National Information Infrastructure Development Institute" },
    { 11915, "Oldring & Associates, Inc." },
    { 11916, "Pablix" },
    { 11917, "PAR3 Communications" },
    { 11918, "PRAJA inc" },
    { 11919, "QCOM, Inc." },
    { 11920, "quantumBEAM Ltd." },
    { 11921, "Ruprecht & Partner OEG" },
    { 11922, "SD Inc." },
    { 11923, "Spectrum Control, Inc." },
    { 11924, "Techsystem Technologies" },
    { 11925, "The IQ Group, Inc." },
    { 11926, "The United World Colleges (international)" },
    { 11927, "Tytrast Systems Inc." },
    { 11928, "Indievisible" },
    { 11929, "Veridicom" },
    { 11930, "Vseobecn\0303\0241 \0303\0272verov\0303\0241 banka, a.s." },
    { 11931, "Staten Island University Hospital" },
    { 11932, "The Wolf Group" },
    { 11933, "University of Alberta" },
    { 11934, "Stadtsparkasse K\0303\0266ln" },
    { 11935, "Josuya Technology Corporation" },
    { 11936, "Amadeus NMC Holding, Inc." },
    { 11937, "ArcSight, Inc." },
    { 11938, "Cominet" },
    { 11939, "Electronic Direct, Inc." },
    { 11940, "Medical Coding and Compliance Solutions, L.L.C." },
    { 11941, "Mssu" },
    { 11942, "Muhen Software" },
    { 11943, "Net Partnets Sp. z o.o." },
    { 11944, "Paulmichl NetWork's" },
    { 11945, "q-station.net" },
    { 11946, "Quanta Network Systems Inc." },
    { 11947, "Stowarzyszenie FREEZE NET ASK" },
    { 11948, "Syracuse University" },
    { 11949, "Ukrsotsbank" },
    { 11950, "VivoCom Inc." },
    { 11951, "VTechnologies S\0303\0240rl" },
    { 11952, "Zeta Broadband Inc" },
    { 11953, "ZUMtOBEL AG" },
    { 11954, "Elegant solutions consulting Inc." },
    { 11955, "BeiJing NetPower TECHNOLOGIES Inc." },
    { 11956, "Mobigen Co., Ltd." },
    { 11957, "ITC" },
    { 11958, "Premonitia, Inc" },
    { 11959, "Coyote Rock" },
    { 11960, "Downlode Media" },
    { 11961, "LARC-USP" },
    { 11962, "Nevala" },
    { 11963, "Propel" },
    { 11964, "Technical Chamber of Greece" },
    { 11965, "Thomas Monitor Systems" },
    { 11966, "Alstom Power Sweden AB" },
    { 11967, "MLP AG" },
    { 11968, "SymLABS" },
    { 11969, "Systech Retail Systems Inc." },
    { 11970, "Watch4Net Solutions" },
    { 11971, "Peter-Service Ltd." },
    { 11972, "TAIS, Inc." },
    { 11973, "North Central Collge" },
    { 11974, "Uffizio Internet Services GmbH" },
    { 11975, "ALPHA SYSTEMS" },
    { 11976, "AT&T Labs Intelligent Network Analysis" },
    { 11977, "Backwoods Communications, LLC" },
    { 11978, "Boxcar Media" },
    { 11979, "BrainStorm Business Resources, Inc." },
    { 11980, "Bravenet Web Services, Inc" },
    { 11981, "CAC Ltd" },
    { 11982, "chiz.net" },
    { 11983, "CollectiveBid Systems Inc." },
    { 11984, "Content Management AG" },
    { 11985, "Conysis S.A." },
    { 11986, "CreekPath Systems" },
    { 11987, "Dakos data & communication co., Ltd." },
    { 11988, "diCarta Inc." },
    { 11989, "DME Corporation" },
    { 11990, "gadgeteer.org" },
    { 11991, "Greenpeace" },
    { 11992, "HeliXense Pte Ltd" },
    { 11993, "Hilbert Computing, Inc." },
    { 11994, "Hubert Krause" },
    { 11995, "Hybrid Solutions, Inc." },
    { 11996, "IBSN" },
    { 11997, "iKnowTheAnswer.com" },
    { 11998, "JSC Desarrollos y Aplicaciones" },
    { 11999, "KFKI Systems" },
    { 12000, "Ki Consulting & Solutions AB" },
    { 12001, "Lakefield Telecom, Inc." },
    { 12002, "Lemur Networks, Inc." },
    { 12003, "luna8 Ltd." },
    { 12004, "MCK Advance Technologies" },
    { 12005, "MediaGS, Ltd." },
    { 12006, "N.C.H. spa Network Computer House" },
    { 12007, "NAMS" },
    { 12008, "Pacher" },
    { 12009, "Regenstrief Institute for Health Care" },
    { 12010, "Schnackelchen" },
    { 12011, "SEAGULL" },
    { 12012, "Seoul National University of Technology" },
    { 12013, "Softworks Group Inc." },
    { 12014, "Studio of Arts And Sciences" },
    { 12015, "TGA Technologies, Inc." },
    { 12016, "Universite de Cergy-Pontoise" },
    { 12017, "VeratNET" },
    { 12018, "Vivanet Inc." },
    { 12019, "waterford.org" },
    { 12020, "Webware Technologies Pvt. Ltd." },
    { 12021, "Wesley WorldWide Solutions, Inc" },
    { 12022, "BRECIS Communications" },
    { 12023, "Unassigned" },
    { 12024, "Miraesys Co., Ltd" },
    { 12025, "C-EISA" },
    { 12026, "Proactive Java Consultancy LLP" },
    { 12027, "AccelaNET" },
    { 12028, "AirWave Wireless, Inc." },
    { 12029, "Altawave Inc." },
    { 12030, "ANAM Wireless Internet Solutions" },
    { 12031, "BitStream Logic, Inc" },
    { 12032, "Booz Allen Hamilton" },
    { 12033, "Checkmate Management" },
    { 12034, "Czech Certification Authority s.r.o." },
    { 12035, "EBJ Consulting" },
    { 12036, "\0303\0211cole normale sup\0303\0251rieure - Paris" },
    { 12037, "Euronet Worldwide, Inc." },
    { 12038, "everyhost.com" },
    { 12039, "Exalead S.A." },
    { 12040, "gull house" },
    { 12041, "HTL Braunau" },
    { 12042, "Infosys Corporation" },
    { 12043, "Jasmap Inc." },
    { 12044, "Lakesoft Consulting & ISP" },
    { 12045, "Medfusion, Inc" },
    { 12046, "Metro Information Concepts as" },
    { 12047, "Meylan Consulting" },
    { 12048, "Millennium Microwave Corporation" },
    { 12049, "NetPlanetEarth" },
    { 12050, "Ohman IT Consult" },
    { 12051, "Onix Electronic Systems, LLC" },
    { 12052, "RCN Telecom" },
    { 12053, "Skjaerlund Software" },
    { 12054, "Special Applied Intelligence Corporation" },
    { 12055, "SUDAC" },
    { 12056, "Tadiran Communications" },
    { 12057, "TE Data" },
    { 12058, "The YAK Corporation" },
    { 12059, "Digital Appliance Corp." },
    { 12060, "TruePosition, Inc." },
    { 12061, "University of Western Ontario" },
    { 12062, "User Interface Technologies Ltd." },
    { 12063, "VeriCell, Inc." },
    { 12064, "Zurich Scudder Investments, Inc" },
    { 12065, "APATON" },
    { 12066, "Daedalus Networks" },
    { 12067, "Pajo Networks" },
    { 12068, "Wroc\0302\0263aw Centre of Networking and Supercomputing" },
    { 12069, "Corpex Internet GmbH" },
    { 12070, "WARCO" },
    { 12071, "@Home Japan Co., Ltd." },
    { 12072, "Acrowave Systems Co., Ltd" },
    { 12073, "Aer Novo" },
    { 12074, "Alison Associates" },
    { 12075, "beckhaus consulting" },
    { 12076, "Bonware" },
    { 12077, "Broadmind Research Corporation" },
    { 12078, "Circle24 Technologies" },
    { 12079, "dotmaudot" },
    { 12080, "e-peopleserve" },
    { 12081, "Estic & Partners bv" },
    { 12082, "European Computer Telecoms AG" },
    { 12083, "Getronics Solutions Italia S.p.A." },
    { 12084, "HighDeal" },
    { 12085, "KR Consulting" },
    { 12086, "MKAPIUM" },
    { 12087, "netdirectory.org" },
    { 12088, "Newdreamnet Co. Ltd." },
    { 12089, "o3sis Infomation Technology AG" },
    { 12090, "RCS (formerly 'Prophet Systems')" },
    { 12091, "Real FS Inc." },
    { 12092, "Rotech Healthcare Inc." },
    { 12093, "Severoceska energetika, a.s." },
    { 12094, "Sup\0303\0251lec Campus de Metz" },
    { 12095, "Telenor Satellite Broadcasting" },
    { 12096, "Telic Communications, Inc." },
    { 12097, "UZA - Universitair Ziekenhuis Antwerpen" },
    { 12098, "VooDoo X Solutions" },
    { 12099, "Woollen Services" },
    { 12100, "XecureNexus" },
    { 12101, "YCOM SA" },
    { 12102, "Airport Authority Hong Kong" },
    { 12103, "4Tier Software" },
    { 12104, "Asis Ltd." },
    { 12105, "BISC" },
    { 12106, "BIPOP-CARIRE spa" },
    { 12107, "Caw Networks" },
    { 12108, "Concordant" },
    { 12109, "IT Service Omikron GmbH" },
    { 12110, "Lifeway Christian resources" },
    { 12111, "Mark Schnur Consulting" },
    { 12112, "NORSYS" },
    { 12113, "Zox, Inc." },
    { 12114, "noris network AG" },
    { 12115, "Philips MP4Net" },
    { 12116, "Advanced Reality" },
    { 12117, "Atmel Nantes" },
    { 12118, "Centrata Inc." },
    { 12119, "City of Mesquite Texas" },
    { 12120, "Defense Supply center Richmond (DSCR)" },
    { 12121, "Fastnet Communications" },
    { 12122, "Henny Penny Corp." },
    { 12123, "iProcess Solutions" },
    { 12124, "Isilon Ststems" },
    { 12125, "Mediavirtuel" },
    { 12126, "Mirafor Associates Oy" },
    { 12127, "Rambold" },
    { 12128, "RoDoGu Consulting" },
    { 12129, "Safeweb Ltda" },
    { 12130, "SciQuest, Inc" },
    { 12131, "Siegfried Holding AG" },
    { 12132, "Simutronics Corporation" },
    { 12133, "Talking Blocks, Inc." },
    { 12134, "Tradetrans Inc" },
    { 12135, "Unique Broadbank Systems" },
    { 12136, "Universidad Nacional de San Luis" },
    { 12137, "Universite de Paris-Sorbonne Paris IV" },
    { 12138, "Laborat\0303\0263rio de Sistemas Distribu\0303\0255dos /CEFET-PR" },
    { 12139, "Iowa Outdoors" },
    { 12140, "ALCOMA, Ltd" },
    { 12141, "Aloes" },
    { 12142, "bob corbett networks" },
    { 12143, "Chrono-Logic" },
    { 12144, "Consumer Contact" },
    { 12145, "Core Integrated Tecnologies, Ltd." },
    { 12146, "SFT-Service (formerly 'Dialog.SFT-Service')" },
    { 12147, "Die Weltregierung" },
    { 12148, "ELTEK Energy AS" },
    { 12149, "Enalur S.A." },
    { 12150, "Finmatica S.p.A." },
    { 12151, "Fyrplus AB" },
    { 12152, "Guru Labs, L.C." },
    { 12153, "HPCinteractive" },
    { 12154, "IKEA IT AB" },
    { 12155, "Innovay Inc." },
    { 12156, "JOINT-STOCK COMPANY\"STC CONTACT\"" },
    { 12157, "KC Micro Specialists, Inc." },
    { 12158, "Mikros Kosmos" },
    { 12159, "M-TEC N.V." },
    { 12160, "NetCommplete Pty Lyd" },
    { 12161, "New World Telephone Ltd" },
    { 12162, "Orsus Solutions" },
    { 12163, "Quebeber.com" },
    { 12164, "Ringling School of Art and Design" },
    { 12165, "SANTIN E ASSOCIATI SRL" },
    { 12166, "ScanPlus GmbH" },
    { 12167, "Sequitur Systems" },
    { 12168, "server2000 internet technology gmbh" },
    { 12169, "SHENZHEN MODERN COMPUTER MANUFACTER Co.,Ltd" },
    { 12170, "SZCOM Broadband Network Technology Co.,Ltd" },
    { 12171, "Tony Bibbs" },
    { 12172, "Transparent Systems" },
    { 12173, "UNICC" },
    { 12174, "Consolidated Freightways" },
    { 12175, "Frontier Internet, Inc." },
    { 12176, "Canon IT Solutions Inc. (formerly 'Sumitomo Metal System Solutions Co.,Ltd')" },
    { 12177, "Henkel AG & Co. KGaA" },
    { 12178, "3va.net" },
    { 12179, "Alacris Inc." },
    { 12180, "ALI Technologies Inc" },
    { 12181, "Allegheny Energy Global Markets" },
    { 12182, "Astrium (UK)" },
    { 12183, "Baldwin Hackett & Meeks, Inc." },
    { 12184, "Bamsco" },
    { 12185, "Ben Nederland BV" },
    { 12186, "Compagnon AG" },
    { 12187, "Direct Solutions" },
    { 12188, "GBase Communications" },
    { 12189, "Holoplex Technologies, Inc." },
    { 12190, "in medias res" },
    { 12191, "Ins-sure Services Limited" },
    { 12192, "Iron Hill Technology" },
    { 12193, "Leapstone Systems, Inc" },
    { 12194, "MSS Communications Design GmbH" },
    { 12195, "Noicom S.p.A." },
    { 12196, "one4net GmbH" },
    { 12197, "ProvisionSoft" },
    { 12198, "RINET" },
    { 12199, "SAGE SRL" },
    { 12200, "Seneca Groep B.V." },
    { 12201, "University Health Network" },
    { 12202, "UP3I" },
    { 12203, "VTT Information Technology" },
    { 12204, "DevonIT" },
    { 12205, "Allianz Ireland PLC" },
    { 12206, "QinetiQ Ltd" },
    { 12207, "Acme Solutions" },
    { 12208, "actina AG" },
    { 12209, "ASTOR-PROMOCJA Poland" },
    { 12210, "Bauer Verlagsgruppe" },
    { 12211, "Biogem" },
    { 12212, "BlueHaven Services Ltd" },
    { 12213, "CAMIS Inc." },
    { 12214, "Covenant Retirement Communities" },
    { 12215, "CUETS" },
    { 12216, "DGT-LAB" },
    { 12217, "Ecole Polytechnique de Montreal" },
    { 12218, "Gl\0303\0274ckert, Machelett & Partner" },
    { 12219, "Hamilton and Sullivan, Ltd." },
    { 12220, "Institute of Environment and Development" },
    { 12221, "ITWM" },
    { 12222, "Kawatetsu Systems, Inc." },
    { 12223, "Kinetics Fluid Systems" },
    { 12224, "Knightnet" },
    { 12225, "Korea Embedded Linux Laboratory" },
    { 12226, "Max-Planck-Institut fuer Festkoerperforschung" },
    { 12227, "Naumen" },
    { 12228, "Niedermayer Systems" },
    { 12229, "Nirvana Research" },
    { 12230, "odahoda.de" },
    { 12231, "OpenAdvice IT Services GmbH" },
    { 12232, "Order N Ltd." },
    { 12233, "OZ Communications, Inc." },
    { 12234, "ProGuy.dk" },
    { 12235, "Roanoke College" },
    { 12236, "Sena Technologies, Inc." },
    { 12237, "SILOGIX" },
    { 12238, "Spumoni" },
    { 12239, "Symsoft AB" },
    { 12240, "System Solutions" },
    { 12241, "Szkola Glowna Handlowa" },
    { 12242, "teamnet GmbH" },
    { 12243, "Vislink PLC" },
    { 12244, "Celestica Corporation" },
    { 12245, "Elvin" },
    { 12246, "Scottish Qualifications Authority" },
    { 12247, "IDP" },
    { 12248, "Availix SA" },
    { 12249, "Escola Universitaria Polit\0303\0250cnica de Manresa" },
    { 12250, "Alosys SpA" },
    { 12251, "Avalon Net Ltd" },
    { 12252, "BAKU Construction office" },
    { 12253, "CN Solutions, LLC" },
    { 12254, "Compubahn, Inc" },
    { 12255, "Connecticut Telephone" },
    { 12256, "Covere" },
    { 12257, "Escosoft Technologies" },
    { 12258, "European Technology Consultants" },
    { 12259, "Forum des Images" },
    { 12260, "Global Telecom, Inc." },
    { 12261, "GlobalCenter" },
    { 12262, "Gnosys S.A.R.L" },
    { 12263, "HDFCBANK" },
    { 12264, "Imagine-IT" },
    { 12265, "Indraweb" },
    { 12266, "ircd" },
    { 12267, "Johns Hopkins Applied Physics Laboratory" },
    { 12268, "Liberty Communication Services, Inc." },
    { 12269, "Maybaum" },
    { 12270, "Novar" },
    { 12271, "Pruthvi Soft" },
    { 12272, "Sacred Bytes" },
    { 12273, "State of Minnesota" },
    { 12274, "Universite Joseph Fourier - Grenoble 1" },
    { 12275, "University of Southampton" },
    { 12276, "F5 Networks Inc" },
    { 12277, "VarySys Technologies GmbH & Co. KG" },
    { 12278, "VTX Technologie" },
    { 12279, "Warp Link GmbH" },
    { 12280, "Western Institute of technology at Taranaki" },
    { 12281, "Yumemi, Inc." },
    { 12282, "Crew Co.,Ltd" },
    { 12283, "PLANET internet commerce GmbH" },
    { 12284, "IMAX NETWORKS (SHENZHEN) Ltd." },
    { 12285, "Acclamation Systems, Inc" },
    { 12286, "Issaqua" },
    { 12287, "Globecomm Systems, Inc." },
    { 12288, "Andern Research Labs" },
    { 12289, "Beeweeb Srl" },
    { 12290, "Celestica International Inc." },
    { 12291, "Cellular Specialties, Inc." },
    { 12292, "cindercat" },
    { 12293, "Digital Insight" },
    { 12294, "Emblaze Systems" },
    { 12295, "ERCIST" },
    { 12296, "IDDEX Corp" },
    { 12297, "Independent Storage Corporation" },
    { 12298, "kinge & Co limited" },
    { 12299, "KTG, Inc." },
    { 12300, "Mennonite.net" },
    { 12301, "Mountain Visions P/L" },
    { 12302, "netikos spa" },
    { 12303, "New Bridges" },
    { 12304, "Next Advisors" },
    { 12305, "PetraSync Inc." },
    { 12306, "PreWorkX (Pty) Ltd." },
    { 12307, "Red Wagon Solutions Incorporated" },
    { 12308, "SecLab" },
    { 12309, "self-indulgence.org" },
    { 12310, "Simple Access Inc." },
    { 12311, "Strategic Service Alliance" },
    { 12312, "Taika Technologies, Ltd" },
    { 12313, "Tattersalls" },
    { 12314, "Universidade Federal de Campina Grande" },
    { 12315, "WorldWithoutWire.com" },
    { 12316, "Chuo Electroplaters' Cooperative Asscosiation" },
    { 12317, "GL-Trade" },
    { 12318, "Loomis Chaffee School" },
    { 12319, "HEIWAKOGYO" },
    { 12320, "Aspen Systems, Inc." },
    { 12321, "Bure Equity" },
    { 12322, "Delta Information & Communication" },
    { 12323, "Department of Computer Science, Indiana University" },
    { 12324, "Deutsche Lebens-Rettungs-Gesellschaft e.V." },
    { 12325, "Fraunhofer FOKUS" },
    { 12326, "Hermes Precisa Australia" },
    { 12327, "kjsanders professional consulting engineers" },
    { 12328, "LawsIT Pty Ltd" },
    { 12329, "Panasonic OWL" },
    { 12330, "plan42 gmbh" },
    { 12331, "Presto Pty Ltd" },
    { 12332, "Primus Telecommunications Group, Inc." },
    { 12333, "TE / TM-tiimi" },
    { 12334, "universal communication platform gmbh" },
    { 12335, "University of York" },
    { 12336, "BuyWays" },
    { 12337, "Broad band network center of Tsinghua University" },
    { 12338, "Netcore Network Technology" },
    { 12339, "Empowered Networks" },
    { 12340, "Net Facilities Group" },
    { 12341, "NOVOMODO Inc." },
    { 12342, "Pivia, Inc." },
    { 12343, "SK Access Devices" },
    { 12344, "Teros" },
    { 12345, "VWB Group" },
    { 12346, "Hagero" },
    { 12347, "Amalgamated Systems, LLC" },
    { 12348, "American Radio Relay League" },
    { 12349, "AT Consultancy" },
    { 12350, "ATMEL Hellas, S.A.n" },
    { 12351, "Barking Cow" },
    { 12352, "Central Data Services" },
    { 12353, "Clariden Bank" },
    { 12354, "Colbourn Associates Ltd" },
    { 12355, "CTI PET Systems, Inc" },
    { 12356, "Fortinet, Inc." },
    { 12357, "Generic Media, Inc." },
    { 12358, "Imagemedical" },
    { 12359, "Indigo Tango Ltd." },
    { 12360, "Instituto Espa\0303\0261ol de Inform\0303\0241tica y Derecho" },
    { 12361, "KGEx.com Co., Ltd" },
    { 12362, "Lombard Odier & Cie" },
    { 12363, "net-labs Systemhaus GmbH" },
    { 12364, "Newbreak LLC" },
    { 12365, "NTT COMWARE CORPORATION" },
    { 12366, "Pharmacia Corporation" },
    { 12367, "QUICK Corp." },
    { 12368, "Raesemann Enterprises, Inc." },
    { 12369, "R\0303\0266hrs Stahl- und Metallbau GmbH & Co.KG" },
    { 12370, "SARD Communications Ltd." },
    { 12371, "Scrutiny, Inc." },
    { 12372, "TeraCloud Corporation" },
    { 12373, "Tetrapod Communications, Inc." },
    { 12374, "Texas State Credit Company" },
    { 12375, "Universal Access, Inc." },
    { 12376, "University of Technology Dresden, Department of Computer Science" },
    { 12377, "Vivendi Telecom Hungary" },
    { 12378, "WellThot Inc." },
    { 12379, "Wingra Technologies" },
    { 12380, "WiWo Support" },
    { 12381, "Worldcom Asia Pacific" },
    { 12382, "UNIHUB GLOBAL NETWORK" },
    { 12383, "Chrysalis-ITS" },
    { 12384, "Commissariat a l'Energie Atomique" },
    { 12385, "Common Voices" },
    { 12386, "InteQ Corporation" },
    { 12387, "IPDirections" },
    { 12388, "JustThe.net LLC" },
    { 12389, "MacsDesign Studio" },
    { 12390, "Microcell Telecommunications Inc." },
    { 12391, "Universiteit Utrecht" },
    { 12392, "Welcat Inc." },
    { 12393, "Active Hotels" },
    { 12394, "Alvarion Ltd." },
    { 12395, "Centro de Informatica da Universidade de Coimbra" },
    { 12396, "Cintech Solutions" },
    { 12397, "Gesellschaft fuer Raumbildsysteme mbH" },
    { 12398, "E. O. Ospedali Galliera" },
    { 12399, "FIX Express Corp." },
    { 12400, "Gatea Ltd." },
    { 12401, "Germinus Solutions" },
    { 12402, "IDLSPM" },
    { 12403, "Imedia Semiconductor Corp." },
    { 12404, "Indianguide.com" },
    { 12405, "Matrics Inc." },
    { 12406, "Medinet IDG S.A." },
    { 12407, "NiceShipping Technology Corporation" },
    { 12408, "Noordelijke Hogeschool Leeuwarden" },
    { 12409, "Objectivity, Inc." },
    { 12410, "OPS" },
    { 12411, "Plasmedia" },
    { 12412, "Portbridge Internet" },
    { 12413, "Radio Frequency Systems" },
    { 12414, "SCRYPTO Systems" },
    { 12415, "SinnerSchrader AG" },
    { 12416, "Summit Place Ales" },
    { 12417, "Tata Infotech Limited" },
    { 12418, "THALES" },
    { 12419, "YAMAHA CORPORATION" },
    { 12420, "Yokogawa Blue Star india Ltd" },
    { 12421, "JWAY GROUP, Inc." },
    { 12422, "The Co-operators" },
    { 12423, "Concord Telephone Company" },
    { 12424, "Congregation of the Sacred Hearts" },
    { 12425, "ConLingual" },
    { 12426, "E-Control Systems" },
    { 12427, "Equinox Engineering Ltd." },
    { 12428, "Genie Information Co." },
    { 12429, "Interact, Inc.Software Systems" },
    { 12430, "I-Silver" },
    { 12431, "iXus Technologiedienstleistungen GmbH" },
    { 12432, "Jippi Group Oyj" },
    { 12433, "John Sheahan & co." },
    { 12434, "Knox College" },
    { 12435, "M2 Systems Corporation" },
    { 12436, "Navosha, Inc." },
    { 12437, "Next Level Design, Inc." },
    { 12438, "Paradigm.One Pty Ltd" },
    { 12439, "Ritzlmayr Consulting" },
    { 12440, "Securenet Ltd" },
    { 12441, "SELECTED HOSTING" },
    { 12442, "TechGemini Inc" },
    { 12443, "www.TrafficShaper.com" },
    { 12444, "Mangolution, Inc." },
    { 12445, "Teradyne" },
    { 12446, "UNPHU" },
    { 12447, "yc consultant" },
    { 12448, "7TH VISION BILLING COMPANY" },
    { 12449, "Audiofon Chat & Play GmbH" },
    { 12450, "Australian Department of Employment and Workplace Relations" },
    { 12451, "Communication Concept GmbH" },
    { 12452, "IntraConnect GmbH" },
    { 12453, "Alaska Power & Telephone" },
    { 12454, "Aria Solutions Inc" },
    { 12455, "CaCo" },
    { 12456, "CertiSur S.A." },
    { 12457, "Chunghwa Telecom Laboratories" },
    { 12458, "GranIT Solutions, LLC" },
    { 12459, "Global Name Registry Limited" },
    { 12460, "ISG Consultoria e Informatica" },
    { 12461, "Jamm" },
    { 12462, "Linuxfabrik GmbH" },
    { 12463, "Mendosus" },
    { 12464, "MicroDowell SpA" },
    { 12465, "MyKitchenTable.net" },
    { 12466, "Netfective Technology" },
    { 12467, "OneSecure, Inc." },
    { 12468, "Pixion Inc" },
    { 12469, "QAC - Quality Assurance Consult Ltda" },
    { 12470, "Rechberger" },
    { 12471, "Rocket Software, Inc" },
    { 12472, "ScapeVision AG" },
    { 12473, "UNILANG" },
    { 12474, "WAC" },
    { 12475, "Webmotion Inc." },
    { 12476, "Carmody Consulting, Inc." },
    { 12477, "Christian Michelsen Research AS" },
    { 12478, "Maryland Department of Transportation" },
    { 12479, "OpenDNS Corp" },
    { 12480, "Allied Worldwide" },
    { 12481, "Altrick" },
    { 12482, "Departmento T\0303\0251cnico" },
    { 12483, "Ebel" },
    { 12484, "Binary Solutions" },
    { 12485, "WUMAG GmbH Werk Ebersbach" },
    { 12486, "Access Grid" },
    { 12487, "Adam Communication Systems International" },
    { 12488, "Ankor Systems" },
    { 12489, "Arizona Mail Order Co., Inc" },
    { 12490, "B.Eckstein Systems" },
    { 12491, "BondDesk" },
    { 12492, "Cameron Net" },
    { 12493, "eList eXpress LLC" },
    { 12494, "enigmatec GmbH" },
    { 12495, "Eskata Systems, Inc." },
    { 12496, "goSBC" },
    { 12497, "Holborn Colleg" },
    { 12498, "Infofiend" },
    { 12499, "IPB" },
    { 12500, "ISRO Satellite Centre" },
    { 12501, "KeysoftEnterllect" },
    { 12502, "METZEMIX" },
    { 12503, "MYUGLYFACE COMPUTING" },
    { 12504, "Onlight" },
    { 12505, "Photonic Bridges Inc." },
    { 12506, "Pinpoint Networks, Inc." },
    { 12507, "PROFIS SA" },
    { 12508, "Scardine & Lopes Ltda" },
    { 12509, "SecureONE" },
    { 12510, "Slackworks" },
    { 12511, "Telesudeste Celular" },
    { 12512, "University of Utah College of Mines & Earth Sciences" },
    { 12513, "XiteMedia I.S. V.O.F." },
    { 12514, "Abbott Laboratories" },
    { 12515, "ORGA Kartensysteme GmbH" },
    { 12516, "ARL HomeCommunications Sdn Bhd" },
    { 12517, "MAN Nutzfahrzeuge AG" },
    { 12518, "University of Mainz" },
    { 12519, "Activa3" },
    { 12520, "ASYRES" },
    { 12521, "Avacue Ltd" },
    { 12522, "California State University, San Bernardino" },
    { 12523, "Credit Union Central of Manitoba" },
    { 12524, "D.I.B." },
    { 12525, "Echostar Solutions" },
    { 12526, "Groupe Eyrolles" },
    { 12527, "HOPF Elektronik GmbH" },
    { 12528, "PureSight Ltd" },
    { 12529, "IDG Communications Ltd" },
    { 12530, "Informatikdienste, ETH Zuerich" },
    { 12531, "James K. Fegan Consulting" },
    { 12532, "Neoteris, Inc." },
    { 12533, "NOX CO.,LTD" },
    { 12534, "NZPhone S/A" },
    { 12535, "Schmidt & Co. (HK) Ltd." },
    { 12536, "SIMSAM Consulting Limited" },
    { 12537, "Spider Eye Studios" },
    { 12538, "Telkom" },
    { 12539, "The Palantir Corporation" },
    { 12540, "T-Systems International" },
    { 12541, "Universidad de Carabobo" },
    { 12542, "UNIZETO Sp. z o.o." },
    { 12543, "Virgil BV" },
    { 12544, "AEGON Nederland N.V." },
    { 12545, "is Industrial Services AG" },
    { 12546, "VerySmartPeople Inc" },
    { 12547, "Principle Inc." },
    { 12548, "HSH Nordbank AG" },
    { 12549, "Air Navigation Services (ANS) of the Czech Republic" },
    { 12550, "Association for Multidiscipline Education in the Health Sciences" },
    { 12551, "CE+T" },
    { 12552, "Corporation of Balcultha" },
    { 12553, "Dispuut Meteoor" },
    { 12554, "Ecclesias.net" },
    { 12555, "Eduro Technologies, Inc." },
    { 12556, "EmSol LLC" },
    { 12557, "GuruMeditations.org" },
    { 12558, "icoserve information technologies GmbH." },
    { 12559, "INRIA" },
    { 12560, "InterEpoch Technology, Inc." },
    { 12561, "Khonraad Systems Engineering BV" },
    { 12562, "Marcom Department Shanghai Mitac Research Co. Ltd." },
    { 12563, "megatel GmbH" },
    { 12564, "Natverket" },
    { 12565, "Navaho Networks Inc" },
    { 12566, "NIKoil Investment Banking Group (joint stock bank)" },
    { 12567, "One5 Corporation" },
    { 12568, "Ranger Computers" },
    { 12569, "Rigel Corporation" },
    { 12570, "S.I.C.E. s.r.l." },
    { 12571, "Symnetics Holdings" },
    { 12572, "TCD Enterprise, Inc." },
    { 12573, "Telonor Business Solutions" },
    { 12574, "TMH The Marilyn House srl" },
    { 12575, "UIC" },
    { 12576, "Unidirect" },
    { 12577, "Unique Interactive" },
    { 12578, "Viola Systems" },
    { 12579, "ZIGZAG Internet Service Provider" },
    { 12580, "ZIRION NETWORKS, Inc." },
    { 12581, "Naruhodo Solutions" },
    { 12582, "Primerica Financial Services" },
    { 12583, "University of California, Irvine Information and Computer Science Department" },
    { 12584, "Butler" },
    { 12585, "Alstom Holdings" },
    { 12586, "Manono Software, Inc. (formerly 'ApiaTech Information Technologies, Inc.')" },
    { 12587, "430am" },
    { 12588, "Blueice Research AB" },
    { 12589, "Celestial Software LLC" },
    { 12590, "Changi International Airport Services Pte Ltd" },
    { 12591, "Corus group plc." },
    { 12592, "Dycec" },
    { 12593, "EKL Solutions LLC" },
    { 12594, "Elma Ingenierie Informatique" },
    { 12595, "EMS Enterprise Messaging Solutions GmbH" },
    { 12596, "JOUVE S.A." },
    { 12597, "Lightwave Communications" },
    { 12598, "Net Vista" },
    { 12599, "Ordyn Electronic Systems Private Limited" },
    { 12600, "Peramon Technology Ltd" },
    { 12601, "Reed College" },
    { 12602, "RooNetworks Inc." },
    { 12603, "ShadowSupport, Inc." },
    { 12604, "Spatial Wireless" },
    { 12605, "SHOM" },
    { 12606, "MBB Gelma GmbH" },
    { 12607, "Advance Fiber Optics Inc" },
    { 12608, "Ahapala" },
    { 12609, "Ascella Technologies" },
    { 12610, "Aspen Business Logic Computing" },
    { 12611, "Atlantique Software" },
    { 12612, "Barco BCI" },
    { 12613, "BroadJump" },
    { 12614, "CiRBA Inc." },
    { 12615, "Craig F. Donlan" },
    { 12616, "DataCorp" },
    { 12617, "Espedair Systems" },
    { 12618, "EZHi Technologies, Inc." },
    { 12619, "UFRGS" },
    { 12620, "Future System Consulting Corp." },
    { 12621, "GE Medical System Information Technologies SW GmbH & Co.KG" },
    { 12622, "Devicescape Software, Inc." },
    { 12623, "IRCI S.A." },
    { 12624, "Kennesaw State University" },
    { 12625, "LabBook, Inc" },
    { 12626, "Ministry of Education, Singapore" },
    { 12627, "Morgan Stanley S.V.S.A" },
    { 12628, "Movielink" },
    { 12629, "MSE" },
    { 12630, "m-solutions Ltd." },
    { 12631, "Nets AG" },
    { 12632, "Objekt Management" },
    { 12633, "Oceanbay Internet Services" },
    { 12634, "PICMG" },
    { 12635, "Redsonic, Inc." },
    { 12636, "Scripps College" },
    { 12637, "Shazam Entertainments ltd" },
    { 12638, "Siennax" },
    { 12639, "Supercable" },
    { 12640, "The Houston-Harris County Immunization Registry" },
    { 12641, "TRIBUNAL REGIONAL DO TRABALHO da 10\0302\0252 REGI\0303\0203O" },
    { 12642, "University of Southern Mississippi" },
    { 12643, "UTI Systems S.A." },
    { 12644, "VISAA" },
    { 12645, "Vodafone Information Technology and Technology Management" },
    { 12646, "WideBand Corporation" },
    { 12647, "Lulea University of Technology" },
    { 12648, "Systek Information Technology Ltd." },
    { 12649, "Utfors AB" },
    { 12650, "Administrative Management Group, Inc." },
    { 12651, "Alaska Department of Labor" },
    { 12652, "Aminor" },
    { 12653, "Armitel" },
    { 12654, "ATH system" },
    { 12655, "exceet Secure Solutions GmbH (formerly 'AuthentiDate International AG')" },
    { 12656, "Avest Plc." },
    { 12657, "Birm\0303\0251 Consulting" },
    { 12658, "Blue Star Sustainable Technologies Inc." },
    { 12659, "Brazier & Welch" },
    { 12660, "CacheWare, Inc." },
    { 12661, "Caroline Chisholm Catholic College" },
    { 12662, "CHM Inc." },
    { 12663, "DocFi" },
    { 12664, "DotCall" },
    { 12665, "Enfotec, Inc." },
    { 12666, "Etagon" },
    { 12667, "ETERE" },
    { 12668, "Garuda Networks" },
    { 12669, "Hanenkamp.com" },
    { 12670, "Indigo Development Corp." },
    { 12671, "Institut fuer System-Management" },
    { 12672, "isMobile AB" },
    { 12673, "iTelco Communications, Inc." },
    { 12674, "Kaon Interactive Inc" },
    { 12675, "Linux Unlimited, LLC" },
    { 12676, "Logical" },
    { 12677, "Mackeeg, Inc." },
    { 12678, "Nankai University Chuangyuan Information Technologies Co., Ltd." },
    { 12679, "NextFuture" },
    { 12680, "Objective Dynamics Ltd" },
    { 12681, "Parker Abex NWL" },
    { 12682, "PC Info Solutions" },
    { 12683, "PreCache Inc." },
    { 12684, "Quantum Solutions" },
    { 12685, "SCS Engineers" },
    { 12686, "SDS GmbH" },
    { 12687, "SiliconLogic Ltd." },
    { 12688, "Sohu.com Inc" },
    { 12689, "SUPERONLINE INTERNATIONAL ONLINE INFORMATION AND COMMUNICATION SERVICES Inc." },
    { 12690, "Technology Leaders, LLC" },
    { 12691, "Terilogy Co., Ltd." },
    { 12692, "Think4You IT Services GmbH" },
    { 12693, "Ti.KOM Tirol Kommunikation" },
    { 12694, "UNIVERSIT\0303\0211 DE MARNE-LA-VALL\0303\0211E" },
    { 12695, "VS Vision Systems" },
    { 12696, "Xavier College" },
    { 12697, "YoungHome.Com, Inc" },
    { 12698, "AFRANET Co. Ltd,." },
    { 12699, "Moy Corporation" },
    { 12700, "UNC Health Care" },
    { 12701, "Tuxnology" },
    { 12702, "724 Solutions Inc" },
    { 12703, "Acelet" },
    { 12704, "ALLTEL Corporation" },
    { 12705, "BAX Global" },
    { 12706, "BYTERAGE, INC" },
    { 12707, "Connect Systems Inc" },
    { 12708, "CyberLancet Corporation" },
    { 12709, "Davies, Inc." },
    { 12710, "Dedicated Hosting Services" },
    { 12711, "Experian Limited" },
    { 12712, "Four Corners Telecommunications Corp" },
    { 12713, "HighSpeed Surfing" },
    { 12714, "Ikosaeder" },
    { 12715, "Indian Institute of Technology, Bombay" },
    { 12716, "Infologigruppen Norr AB" },
    { 12717, "InterSAN, Inc" },
    { 12718, "Rheinische Friedrich -Wilhelms-Universitaet Bonn" },
    { 12719, "Open Software Services, LLC" },
    { 12720, "Reliant Resources" },
    { 12721, "Rendition Networks Incorporated" },
    { 12722, "Rite Aid Corporation" },
    { 12723, "Seisint Inc." },
    { 12724, "Sensinova AB" },
    { 12725, "Santa Clara County" },
    { 12726, "Sudoeste Servi\0303\0247os de Telem\0303\0241tica Ltda" },
    { 12727, "Supervise Network" },
    { 12728, "SYSWILL" },
    { 12729, "Be Think, Solve, Execute GmbH (formerly 'targit GmbH')" },
    { 12730, "TECSys Development, LP" },
    { 12731, "UTI Systems S.A." },
    { 12732, "VoIP Group Inc." },
    { 12733, "WildPackets, Inc." },
    { 12734, "Northrop Grumman Information Systems" },
    { 12735, "VFSPIH" },
    { 12736, "Elo & Mahout & Co" },
    { 12737, "Algenib Software, Inc." },
    { 12738, "BMW of North America" },
    { 12739, "dgstar co., Ltd." },
    { 12740, "EqualLogic" },
    { 12741, "ErgoIntegration AS" },
    { 12742, "HomeConcept" },
    { 12743, "Integrated Service Lab" },
    { 12744, "Nakisa Inc." },
    { 12745, "Nordisk Spr\0303\0245kteknologi AS" },
    { 12746, "Spinoza Technology Inc." },
    { 12747, "Teamsoft Inc." },
    { 12748, "Telenor ASA" },
    { 12749, "UTA Telekom AG" },
    { 12750, "xi'an huahai medical info-tech co.,ltd." },
    { 12751, "e-chiceros" },
    { 12752, "Acta Technology, Inc." },
    { 12753, "Biomedical Informatics Laboratory" },
    { 12754, "bTurtle" },
    { 12755, "Cup 2000 spa" },
    { 12756, "Delta Networks, Inc." },
    { 12757, "eCubeNet.com" },
    { 12758, "ExPet Technologies, Inc." },
    { 12759, "Garban Intercapital" },
    { 12760, "h00.org" },
    { 12761, "Hipbone, Inc." },
    { 12762, "iMpacct Technology Corp." },
    { 12763, "ISK Systems Ltd" },
    { 12764, "MEDIAOCEAN" },
    { 12765, "Mintera Corp." },
    { 12766, "Mobixell Networks Inc." },
    { 12767, "National Computer Helpdesk" },
    { 12768, "NaviSite Inc" },
    { 12769, "netvigator.com" },
    { 12770, "Nyttab Ab / SurfNet" },
    { 12771, "Palfrader" },
    { 12772, "PZU Zycie SA" },
    { 12773, "Resource Center" },
    { 12774, "Sengent, Inc." },
    { 12775, "Shiron Satellite Communications Ltd." },
    { 12776, "The Box IT" },
    { 12777, "TNG - the net generation GmbH" },
    { 12778, "TranTech, Inc." },
    { 12779, "University of Vermont" },
    { 12780, "VOLKTEK Corporation" },
    { 12781, "Progeny Linux Systems" },
    { 12782, "Rost+Oberndoerfer Consulting GbR" },
    { 12783, "University of Maine System" },
    { 12784, "Teamware Group AB" },
    { 12785, "Amacis Ltd" },
    { 12786, "Automatos, Inc." },
    { 12787, "AxxessAnywhere" },
    { 12788, "BladeLogic Inc" },
    { 12789, "Centre for Integrated Computer Systems Research" },
    { 12790, "CESKY TELECOM a.s. - Imaginet o.z." },
    { 12791, "Data & Control Systems Ltd" },
    { 12792, "Embarcadero Technologies, Inc." },
    { 12793, "EUREM GmbH" },
    { 12794, "Frank" },
    { 12795, "HCC Hobbynet" },
    { 12796, "I/O Software" },
    { 12797, "Interactive Payer Network" },
    { 12798, "Internet Kayttajat Ikuisesti - IKI ry" },
    { 12799, "IPv6 Research and Development" },
    { 12800, "iqdoq" },
    { 12801, "Linuxmagic" },
    { 12802, "Mathcom Solutions Inc" },
    { 12803, "Multitask Consultoria Ltda" },
    { 12804, "National Library of Australia" },
    { 12805, "Notnet Webhosting" },
    { 12806, "Peter Stamfest" },
    { 12807, "Rabbit Semiconductor" },
    { 12808, "S2IO Technologies Corp." },
    { 12809, "San Diego Unified School District" },
    { 12810, "Saratov State University" },
    { 12811, "SatService GmbH" },
    { 12812, "Trustwave Holdings, Inc." },
    { 12813, "Speedwise Technologies" },
    { 12814, "Staatliche Studienakademie Leipzig" },
    { 12815, "Terraspring, Inc." },
    { 12816, "Universit\0303\0244t Trier" },
    { 12817, "Z-World Incorporated" },
    { 12818, "The Key Centre for Human Factors and Applied Cognitive Psychology" },
    { 12819, "Banque Generale du Luxembourg" },
    { 12820, "Electrum Information Technology Co.Ltd" },
    { 12821, "e-Pie Entertainment & Technology Corporation(Beijing)" },
    { 12822, "icu" },
    { 12823, "AMIT, Inc." },
    { 12824, "AndTeK GmbH" },
    { 12825, "ATC Information Services" },
    { 12826, "AXL Performance Solutions Ltd" },
    { 12827, "Barco, Inc." },
    { 12828, "Blue Heron Biotechnology Inc" },
    { 12829, "Brady Motor Sports" },
    { 12830, "Central Florida Main" },
    { 12831, "Codemark" },
    { 12832, "COUNCIL OF EUROPE" },
    { 12833, "Covansys" },
    { 12834, "CPE" },
    { 12835, "Digitrust - Certificadora Notarial SA" },
    { 12836, "E-Advies" },
    { 12837, "Polytech'Lille" },
    { 12838, "Exis Srl" },
    { 12839, "German Gutierrez" },
    { 12840, "Griffin Plaza Partners, LLC" },
    { 12841, "Interactive TKO Inc." },
    { 12842, "Mediso Ltd." },
    { 12843, "MIPTelecom" },
    { 12844, "Northern Michigan University" },
    { 12845, "Oak Lawn School District 229" },
    { 12846, "ObjectCode" },
    { 12847, "Orincon Corporation" },
    { 12848, "Saddleback College" },
    { 12849, "SKYRIX Software AG" },
    { 12850, "Smart Tech Consulting" },
    { 12851, "Syncope Communication Systems GmbH" },
    { 12852, "SYSPAK" },
    { 12853, "Technical Toys Limited" },
    { 12854, "tellion" },
    { 12855, "Vastweb Technology Ltd." },
    { 12856, "Verge Networks" },
    { 12857, "Williams College" },
    { 12858, "eNetrex Inc." },
    { 12859, "HIGHWAY.RU" },
    { 12860, "Zaryba Ltd" },
    { 12861, "Bayerische Beamten Versicherungen" },
    { 12862, "NEEF LAPPCOM GmbH" },
    { 12863, "AirLink Technology, Inc." },
    { 12864, "INCOGEN, Inc" },
    { 12865, "Amin Group" },
    { 12866, "CardEngine Inc." },
    { 12867, "Cedar Point Communications" },
    { 12868, "CET Technologies Pte Ltd" },
    { 12869, "Codent Networks" },
    { 12870, "Danlab Electronics A/S" },
    { 12871, "die netzwerker GmbH" },
    { 12872, "DTE Energy" },
    { 12873, "E.C.C. sa" },
    { 12874, "EFM networks Inc." },
    { 12875, "ExperShare" },
    { 12876, "Fokker Space" },
    { 12877, "FORTIS" },
    { 12878, "Griffin Network Consulting" },
    { 12879, "IDNT Integrated Digital Network Technologies" },
    { 12880, "kiwi interaktive medien gmbh" },
    { 12881, "KnowGeeks" },
    { 12882, "LGC Wireless" },
    { 12883, "Martinsson informationssystem" },
    { 12884, "Moody Bible Institute" },
    { 12885, "MyArtic Communities" },
    { 12886, "National Technical Systems" },
    { 12887, "Netplex AB" },
    { 12888, "Prokom Bilgisayar ve Danismanlik Hizmetleri San. ve Tic. Ltd.Sti." },
    { 12889, "PTC" },
    { 12890, "Shorty" },
    { 12891, "Syndicat Interhospitalier Limousin" },
    { 12892, "University of Patras" },
    { 12893, "VisioWave S.A." },
    { 12894, "Wmode Inc" },
    { 12895, "Xsetup" },
    { 12896, "Xtria Healthcare" },
    { 12897, "ZiLOG Inc." },
    { 12898, "Sinter Consulting" },
    { 12899, "Visogent Technologies" },
    { 12900, "ITEC" },
    { 12901, "Institute of Software,Chinese Academy of Sciences" },
    { 12902, "Advanced Network Technology Laboratories Pte Ltd" },
    { 12903, "Bayshore Networks, Inc." },
    { 12904, "EVault, Inc." },
    { 12905, "Indian Institute of Technology Guwahati" },
    { 12906, "japc" },
    { 12907, "Kansai Broadband Planning Corp." },
    { 12908, "Litech Systems Design" },
    { 12909, "Machine Vision Products, Inc." },
    { 12910, "Next Element" },
    { 12911, "Oce NV" },
    { 12912, "PeerPro" },
    { 12913, "Procera Networks, Inc." },
    { 12914, "Production Robots Engineering Ltd" },
    { 12915, "Radio Free Europe/Radio Liberty, Inc." },
    { 12916, "Rockland Community College" },
    { 12917, "Saber e Lazer, SA" },
    { 12918, "TDI- Transistor Devices, Inc" },
    { 12919, "XAVi Technologies Corporation" },
    { 12920, "Xteam Software Co, ltd" },
    { 12921, "Yeaman Associates" },
    { 12922, "Your Voice S.p.A." },
    { 12923, "Kigyo Zanmai Corp." },
    { 12924, "Klon/Jawor Association" },
    { 12925, "3PAR Data" },
    { 12926, "Anheuser-Busch" },
    { 12927, "Axiom (Cambridge) Ltd" },
    { 12928, "Clarus Systems" },
    { 12929, "Cliff Berg" },
    { 12930, "CVS Travelhost International Pty Ltd" },
    { 12931, "Dreefs GmbH Schaltger\0303\0244te & Systeme" },
    { 12932, "FESD GmbH" },
    { 12933, "Global Orchestra" },
    { 12934, "Hunkeler AG" },
    { 12935, "i3 micro technology ab" },
    { 12936, "InCert Software Corporation" },
    { 12937, "Infradig Systems" },
    { 12938, "Innovative Technology Solutions, Inc." },
    { 12939, "Modus (Scotland) Ltd" },
    { 12940, "Pedestal Networks" },
    { 12941, "Press-Data" },
    { 12942, "SANSHA ELECTRIC MFG.CO.,LTD" },
    { 12943, "Sengena" },
    { 12944, "Sockeye Networks, Inc." },
    { 12945, "SoftProject GmbH" },
    { 12946, "State Services Commission" },
    { 12947, "SyntheSys Secure Technologies Inc." },
    { 12948, "Syred data systems" },
    { 12949, "T-Online France" },
    { 12950, "Venngo Inc." },
    { 12951, "VerizonWireless" },
    { 12952, "warpFactor Inc." },
    { 12953, "Xandros Corporation" },
    { 12954, "WM-data SDC a/s" },
    { 12955, "Metarete s.r.l." },
    { 12956, "Aarhus Universitet" },
    { 12957, "BLUE MARS GmbH" },
    { 12958, "Questerra" },
    { 12959, "am professional services" },
    { 12960, "Andelina Corporation" },
    { 12961, "Andrew Hewett Consulting" },
    { 12962, "Decru, Inc." },
    { 12963, "DIMONsoft" },
    { 12964, "ftlight.net" },
    { 12965, "New Media Data Marketing, Inc." },
    { 12966, "Next Generation Systems, Inc." },
    { 12967, "Petrobras - Petroleo Brasileiro S.A." },
    { 12968, "Menno Pieters (formerly 'Stelvio')" },
    { 12969, "The Rockefeller University" },
    { 12970, "Urban Development Co." },
    { 12971, "bigdom.com" },
    { 12972, "Callion Electronics Co., Ltd." },
    { 12973, "Wuhan Public Information Co.Ltd." },
    { 12974, "barrigon.com" },
    { 12975, "brainaid" },
    { 12976, "coWlan" },
    { 12977, "Level II Inc." },
    { 12978, "Michael Fromme EDV-Beratung" },
    { 12979, "Optimacy Corporation" },
    { 12980, "Person co., Ltd." },
    { 12981, "Rotterdam CS" },
    { 12982, "Synergy International Ltd" },
    { 12983, "TBS INTERNET" },
    { 12984, "Terraplay Systems AB" },
    { 12985, "University of St Andrews" },
    { 12986, "Verlagsgruppe Straubinger Tagblatt / Landshuter Zeitung" },
    { 12987, "Vineyard.NET, Inc." },
    { 12988, "Vistorm Limited" },
    { 12989, "XIP" },
    { 12990, "Star Communication Network Technology Co., Ltd." },
    { 12991, "California College of Arts & Crafts" },
    { 12992, "T&A SYSTEME GmbH" },
    { 12993, "weitlandt. Communication" },
    { 12994, "Abisoft Ltd." },
    { 12995, "Accet Network Inc" },
    { 12996, "adconsys AG" },
    { 12997, "Advanced Biometrics, Inc." },
    { 12998, "Agile Software" },
    { 12999, "Altiris" },
    { 13000, "Anglia Polytechnic University" },
    { 13001, "Anuvio Technologies" },
    { 13002, "Augsburg College" },
    { 13003, "Banca I.M.I." },
    { 13004, "beamNet" },
    { 13005, "Bitrage, Inc." },
    { 13006, "CAE-Technik Schmitt" },
    { 13007, "California Regional Intranet, Inc." },
    { 13008, "CanPrint Communications Pty. Ltd." },
    { 13009, "Coma" },
    { 13010, "Computer Business Sciences Ltd." },
    { 13011, "Consejo General del Notariado" },
    { 13012, "Cramer Systems Limited" },
    { 13013, "Denisowski Consulting" },
    { 13014, "Dreamcode Software Inc." },
    { 13015, "Eastern Electronics Co., Ltd" },
    { 13016, "eMagic.com" },
    { 13017, "e-Solutionist Inc." },
    { 13018, "ETH Zurich, Department of Computer Science" },
    { 13019, "ETSI" },
    { 13020, "Florida International University" },
    { 13021, "Halifax Cetelem Credit Ltd" },
    { 13022, "handhelds.org" },
    { 13023, "Hub2b" },
    { 13024, "Imagistics International Inc." },
    { 13025, "Inferno Labs" },
    { 13026, "IT Intergroup ApS" },
    { 13027, "IXOS Software AG" },
    { 13028, "Kuokoa Networks, Inc." },
    { 13029, "Managed Service Partners International" },
    { 13030, "Monitor724 Services Limited" },
    { 13031, "neix,Inc.  (formerly 'Digital Technologies Corporation')" },
    { 13032, "Reach Technologies" },
    { 13033, "shockunit productions" },
    { 13034, "SoftNet Systems, Inc." },
    { 13035, "Sonangol" },
    { 13036, "Stradient, Inc." },
    { 13037, "Subnetworx Corporation" },
    { 13038, "TELE Greenland Inc." },
    { 13039, "Tennessee Technological University" },
    { 13040, "The Horde Project" },
    { 13041, "Think Dynamics" },
    { 13042, "Trust Company of America" },
    { 13043, "University of Wisconsin - River Falls" },
    { 13044, "Unternehmensberatung Rahn" },
    { 13045, "Uptime Devices, Inc." },
    { 13046, "VisionShare Inc" },
    { 13047, "Welliver Enterprises" },
    { 13048, "Xorba, Inc." },
    { 13049, "Yacc Labs Ltd." },
    { 13050, "Ydilo Advanced Voice Solutions S.A." },
    { 13051, "MetaSolv Software, Inc." },
    { 13052, "Telefonbau Arthur Schwabe GmbH & Co KG" },
    { 13053, "TIS System Service Inc." },
    { 13054, "Ram Corp" },
    { 13055, "ShangHai JingLun Technologies CO.,LTD." },
    { 13056, "Tai Ping Life Insurance Co, Ltd." },
    { 13057, "Hays DSIA France" },
    { 13058, "National Hockey League" },
    { 13059, "Ahold Supermercados" },
    { 13060, "Airpath Wireless, Inc." },
    { 13061, "AlphaC srl" },
    { 13062, "Ascom" },
    { 13063, "Cambian" },
    { 13064, "Claymountain Solutions Oy" },
    { 13065, "Colomsat S.A." },
    { 13066, "Connaught Air Services" },
    { 13067, "CSH" },
    { 13068, "CzajSOFT" },
    { 13069, "Diveo do Brasil Telecom. LTDA" },
    { 13070, "Drutt Corporation" },
    { 13071, "ESDS" },
    { 13072, "Gallery IP Telephony Ltd." },
    { 13073, "gate5 AG" },
    { 13074, "Labyrinth Connections" },
    { 13075, "My Linux ISP" },
    { 13076, "MyCompany" },
    { 13077, "NetWolves Technologies Corporation" },
    { 13078, "NSSoft, Inc" },
    { 13079, "Persay LTD" },
    { 13080, "Persona Inc." },
    { 13081, "Pretax Systems Oy ltd" },
    { 13082, "Shanghai Sunrise Electronic Technology Co. Ltd." },
    { 13083, "Signal Technology Corporation" },
    { 13084, "Sonae Distribui\0303\0247\0303\0243o Brasil S.A." },
    { 13085, "StreamSec" },
    { 13086, "Yamagata Prefectural Government" },
    { 13087, "Vaelit Group." },
    { 13088, "Adquira Espa\0303\0261a" },
    { 13089, "Aristotle University of Thessaloniki, Department of Physics" },
    { 13090, "Artifact Entertainment" },
    { 13091, "Bethel College and Seminary" },
    { 13092, "Cellcloud Technologies Pvt Ltd" },
    { 13093, "College of Education" },
    { 13094, "Contego Solutions LLC" },
    { 13095, "Dalhousie University" },
    { 13096, "Dan of Steel" },
    { 13097, "Dascom Technology Co.Ltd" },
    { 13098, "dpa AFX Wirtschaftsnachrichten GmbH" },
    { 13099, "Drybridge Consulting" },
    { 13100, "fun communications GmbH" },
    { 13101, "GETEDES" },
    { 13102, "Hauni Maschinenbau AG" },
    { 13103, "Ilevo AB" },
    { 13104, "Infraservices Corporation" },
    { 13105, "Ingenium Technology Srl" },
    { 13106, "JLF Network" },
    { 13107, "JMatica Srl" },
    { 13108, "Linuxlab" },
    { 13109, "Liontech Co., Ltd." },
    { 13110, "Manageable Inc." },
    { 13111, "mcgu.net Consulting" },
    { 13112, "MDS Proteomics Inc." },
    { 13113, "MindTribe" },
    { 13114, "Nextra Investment Management SGR S.p.A." },
    { 13115, "Open Connections" },
    { 13116, "P & J Systems Support Station" },
    { 13117, "Plat'Home Co.,Ltd." },
    { 13118, "PointDx, Inc." },
    { 13119, "RAmEx Ars Medica, Inc." },
    { 13120, "RASilient Systems, Inc." },
    { 13121, "Signatron Technology Corporation" },
    { 13122, "Software Research Associates, Inc." },
    { 13123, "Starbak Communications Inc." },
    { 13124, "Terra Marketing" },
    { 13125, "TEYTEL, S.A." },
    { 13126, "themountain" },
    { 13127, "Thomas Jefferson University Hospital" },
    { 13128, "Universe Software" },
    { 13129, "UPMC" },
    { 13130, "Video Products Group" },
    { 13131, "de Passievruchten" },
    { 13132, "Softing Europe S.A." },
    { 13133, "Michelin" },
    { 13134, "Founder Broadband Network Technology Co.,Ltd" },
    { 13135, "SJTeK" },
    { 13136, "AlexS.DE Private Network" },
    { 13137, "Biocare sarl" },
    { 13138, "Boiled Frog Trading Co-operative" },
    { 13139, "caribNav Holdings, LLC" },
    { 13140, "Cluster File Systems, Inc." },
    { 13141, "FDK CO.LTD" },
    { 13142, "I M Consultancy Pty Ltd" },
    { 13143, "I&SI S.p.A." },
    { 13144, "Jakob Hatteland Computer AS" },
    { 13145, "Klik Systems Inc." },
    { 13146, "Klomp" },
    { 13147, "Leadfly Technologies Co., Ltd." },
    { 13148, "LeanLogistics" },
    { 13149, "Lee Printing, Inc." },
    { 13150, "m&m consulting intl" },
    { 13151, "MB Consultants" },
    { 13152, "Octalis S.A." },
    { 13153, "RFSAW" },
    { 13154, "RPost, Inc." },
    { 13155, "Shimanek" },
    { 13156, "SwitchPoint Networks, Inc" },
    { 13157, "Tsinghua Unisplendour Bitway Networking Technology Co.,Ltd." },
    { 13158, "Universitaet Muenster" },
    { 13159, "ZF Friedrichshafen AG" },
    { 13160, "Cerca.com S.r.l." },
    { 13161, "Quattro Software Limited" },
    { 13162, "Software Quality Engineering" },
    { 13163, "Ministry of Justice, Finland" },
    { 13164, "CyberSuperStore, Inc." },
    { 13165, "9105 - 1938 Qu\0303\0251bec Inc." },
    { 13166, "Acamar Systems" },
    { 13167, "Oeko.neT Mueller & Brandt" },
    { 13168, "Aries e-Publishing" },
    { 13169, "UNIPOWER, LLC. - IPS (formerly 'C&D Technologies, Inc.')" },
    { 13170, "caresys GmbH" },
    { 13171, "Cilys" },
    { 13172, "Dark Side of the Moon Software" },
    { 13173, "DILAX Intelcom GmbH" },
    { 13174, "Eglin Air Force Base" },
    { 13175, "Eurofer" },
    { 13176, "European Bank for Reconstruction and Development" },
    { 13177, "Firmaprofesional, SA" },
    { 13178, "Fremont Computer Corporation" },
    { 13179, "Internet Information Group" },
    { 13180, "JR Software" },
    { 13181, "Junot Systems Inc." },
    { 13182, "kapsch TrafficCom AG" },
    { 13183, "Kevab Thebasestationcompany" },
    { 13184, "Lanscape Netzwerkdienste GmbH" },
    { 13185, "Laqtib, Inc." },
    { 13186, "Light Computing Services Ltd" },
    { 13187, "MDlink GmbH" },
    { 13188, "Miami University Libraries" },
    { 13189, "MITAKE" },
    { 13190, "Northrop/Grumman- INRI division,NTCSS Support System" },
    { 13191, "OneAccess" },
    { 13192, "PCLinX snc" },
    { 13193, "Portelco (Asia) Limited" },
    { 13194, "PORTSITE GmbH" },
    { 13195, "Proditec" },
    { 13196, "SBS GmbH & Co OHG CWS 41" },
    { 13197, "Security Crossing" },
    { 13198, "Signtrust" },
    { 13199, "SiMind Inc" },
    { 13200, "BPK Penabur" },
    { 13201, "TJH Internet SP" },
    { 13202, "United States Advanced Network, Inc." },
    { 13203, "University of Pretoria" },
    { 13204, "VIA NET.WORKS Deutschland GmbH" },
    { 13205, "WebSwimmer LLC" },
    { 13206, "BSM Consulting" },
    { 13207, "NTNU" },
    { 13208, "ARGSOFT" },
    { 13209, "Aptilo Networks AB" },
    { 13210, "Armstrong Group of Companies" },
    { 13211, "AT4.NET INTERNET Y COMUNICACION" },
    { 13212, "bTrade, Inc." },
    { 13213, "Centre Tecnologic de Manresa" },
    { 13214, "Comunitel Global S.A." },
    { 13215, "Cougaar" },
    { 13216, "Digital Age Design" },
    { 13217, "FH Furtwangen" },
    { 13218, "Flowring Technology" },
    { 13219, "Gliwickie Stowarzyszenie Internaut\0303\0263w" },
    { 13220, "Interconnected Generation" },
    { 13221, "Kubota Systems Inc." },
    { 13222, "Millicom Peru" },
    { 13223, "mwain Corp" },
    { 13224, "Net Integration Technologies" },
    { 13225, "Network Services Group, LLC" },
    { 13226, "Network Technology Solutions" },
    { 13227, "Officescape" },
    { 13228, "Redline Telecommunications SA (pty) Ltd" },
    { 13229, "Samad Pty Ltd" },
    { 13230, "San Diego Supercomputer Center" },
    { 13231, "SchlumbergerSema Japan" },
    { 13232, "SpottedOwlRecipes.com" },
    { 13233, "Vimia GmbH" },
    { 13234, "TELPRO Ltd." },
    { 13235, "Teralink Communications" },
    { 13236, "The Brick Warehouse Corporation" },
    { 13237, "US Process, Inc" },
    { 13238, "Vienna University of Economics and Business Administration" },
    { 13239, "Vodatel" },
    { 13240, "VoIP Pty Ltd" },
    { 13241, "Wieland Gmeiner" },
    { 13242, "InfoCrypt" },
    { 13243, "Chip PC" },
    { 13244, "Duniya Technologies, Inc." },
    { 13245, "HST" },
    { 13246, "Alliente, Inc." },
    { 13247, "City of Naantali" },
    { 13248, "General Electric Power Management" },
    { 13249, "ICEM Technologies GmbH" },
    { 13250, "INECO" },
    { 13251, "Ingenix" },
    { 13252, "Kodansha Ltd." },
    { 13253, "ky-on" },
    { 13254, "London Stock Exchange" },
    { 13255, "net mobile AG" },
    { 13256, "Rabid Badgers" },
    { 13257, "Registradores de la Propiedad y Mercantil de Espa\0303\0261a" },
    { 13258, "Secretaria de Educaci\0303\0263n del Distrito (Bogota D.C Colombia)" },
    { 13259, "solution-x Software GmbH" },
    { 13260, "Study Area Training Center" },
    { 13261, "T-Systems ITS GmbH - DMS/PP" },
    { 13262, "ZbW - Zentrum fuer berufliche Weiterbildung" },
    { 13263, "Professional Systems Integration" },
    { 13264, "Atmel Germany GmbH" },
    { 13265, "Atofina" },
    { 13266, "C2 Creation" },
    { 13267, "Urban Traffic Management and Control (UTMC) (formerly 'City of York Council')" },
    { 13268, "Clark Hill PLC" },
    { 13269, "Complete Network Solutions, Inc." },
    { 13270, "Computing Center of Northeastern Univ." },
    { 13271, "Current Technologies" },
    { 13272, "DaniloMassa" },
    { 13273, "Design IT Solutions Ltd" },
    { 13274, "Digital Media Lab Corporation" },
    { 13275, "Golden Square Post Production" },
    { 13276, "gsta" },
    { 13277, "IEEE 802.11" },
    { 13278, "iNabling Technologies" },
    { 13279, "Intergate Browser Systems, Inc." },
    { 13280, "Internet Express, Inc." },
    { 13281, "IPSYN" },
    { 13282, "Kaparel Corporation" },
    { 13283, "Laitilan Puhelinosuuskunta" },
    { 13284, "London Stock Exchange" },
    { 13285, "LYCOS FRANCE" },
    { 13286, "MDM I&C" },
    { 13287, "Membrain Technologies" },
    { 13288, "MIS@MHIT" },
    { 13289, "Neoscale Systems" },
    { 13290, "nextSource, Inc." },
    { 13291, "Ogangi Corporation" },
    { 13292, "feel3 UG (haftungsbeschraenkt) (formerly 'oneShell Internet Services GmbH')" },
    { 13293, "OTTO International (Hong Kong) Ltd." },
    { 13294, "ph03n1x.net - Development" },
    { 13295, "Portugalmail" },
    { 13296, "SOFTINTEGRO" },
    { 13297, "Soliton Associates Limited" },
    { 13298, "SYNER S.A." },
    { 13299, "Syntlogo GmbH" },
    { 13300, "Syr\0303\0251n Software AB" },
    { 13301, "Teksouth Corporation" },
    { 13302, "The Advantage Media Group" },
    { 13303, "The Gillette Company" },
    { 13304, "T-Systems Solutions for Research GmbH" },
    { 13305, "BFH Berne University of Applied Sciences (formerly 'Berne University of Applied Sciences')" },
    { 13306, "University of Montana" },
    { 13307, "V.R.A.M. Rt." },
    { 13308, "V\0303\0241rosmajori Gimn\0303\0241zium" },
    { 13309, "Visanti A/S" },
    { 13310, "wwwolf" },
    { 13311, "Joys Online, Inc" },
    { 13312, "Factor-TS Ltd." },
    { 13313, "Analog Devices, Inc" },
    { 13314, "Blank" },
    { 13315, "BlueCat Networks" },
    { 13316, "Byteworks" },
    { 13317, "Celite Systems Inc." },
    { 13318, "Clarity AG" },
    { 13319, "Dipartimento di Biochimica e Biotecnologie Mediche" },
    { 13320, "Griffin Development" },
    { 13321, "Incard spa" },
    { 13322, "Peel Teaching Assistants Association" },
    { 13323, "SoftLogic Solutions" },
    { 13324, "Web-Addr LLC" },
    { 13325, "Associated Press" },
    { 13326, "Bermai" },
    { 13327, "htds" },
    { 13328, "Apoapsis Ltd" },
    { 13329, "Area51" },
    { 13330, "Ceyoniq Incorporated" },
    { 13331, "CICAIA - Universita` di Modena e Reggio Emilia" },
    { 13332, "Credit Union Central Alberta Limited" },
    { 13333, "ClearSky Technologies, Inc. (formerly 'Data On Air')" },
    { 13334, "Hewett Inc." },
    { 13335, "Internet Information Services" },
    { 13336, "IronHide Corp" },
    { 13337, "Kochan und Partner" },
    { 13338, "Krocus Communications Oy" },
    { 13339, "Lange Software GmbH" },
    { 13340, "Lee Bradshaw" },
    { 13341, "Live Systems Integration" },
    { 13342, "Unassigned" },
    { 13343, "Networking Laboratory of DMIS, BUTE" },
    { 13344, "Ningbo Success Information Industry CO.,LTD." },
    { 13345, "Pacificorp" },
    { 13346, "Pace France (formerly 'Philips CE STB')" },
    { 13347, "Qbranch" },
    { 13348, "Randall Kunkee" },
    { 13349, "RMP & Associates" },
    { 13350, "SDN Online, Inc." },
    { 13351, "Shanghai Mining Computer Software Co., Ltd." },
    { 13352, "SNS Solutions" },
    { 13353, "Sonofon" },
    { 13354, "SpaceTime Co., Ltd." },
    { 13355, "Stodge.org" },
    { 13356, "Summit Imaging, Inc." },
    { 13357, "SunGard Bi-Tech" },
    { 13358, "Tim O Callaghan" },
    { 13359, "TM Ryder Insurance Agency, Inc." },
    { 13360, "Trinity Convergence" },
    { 13361, "Universit\0303\0251 Fran\0303\0247ois Rabelais" },
    { 13362, "University of Applied Sciences Stralsund" },
    { 13363, "University of Southern California" },
    { 13364, "ViaBridge" },
    { 13365, "ViewBridge Technologies, Inc" },
    { 13366, "W*H Interactive Ltd" },
    { 13367, "Whale Queens Org" },
    { 13368, "Zand Elektronic" },
    { 13369, "Zeta Associates Incorporated" },
    { 13370, "7+ Computer Networks Ltd." },
    { 13371, "Qualityware Inform\0303\0241tica Ltda." },
    { 13372, "UGC" },
    { 13373, "Apt Minds, LLC" },
    { 13374, "Axitus" },
    { 13375, "Brainzsquare Inc." },
    { 13376, "Carambole" },
    { 13377, "Conceptis Technologies Inc" },
    { 13378, "Concretio India Private Limited" },
    { 13379, "Crysec GmbH" },
    { 13380, "DOTSTAR Technology" },
    { 13381, "DRP Data" },
    { 13382, "INTEC International GmbH" },
    { 13383, "iNTELEGO" },
    { 13384, "Letins Corporation" },
    { 13385, "Mount Saint Mary College" },
    { 13386, "Nagar" },
    { 13387, "NeuroStar Solutions" },
    { 13388, "Ticoon Technology Inc." },
    { 13389, "Wraith Computer Systems" },
    { 13390, "AV Automotive Group" },
    { 13391, "Callaway Golf" },
    { 13392, "Cavena Image Products AB" },
    { 13393, "Cite-SI" },
    { 13394, "Colligo Networks" },
    { 13395, "CommerceQuest, Inc." },
    { 13396, "DANVILLE ASSOCIATES" },
    { 13397, "DemandTec Inc." },
    { 13398, "SicherByte GmbH Dr. Ralf Schwedler" },
    { 13399, "Dune Semiconductor" },
    { 13400, "Emerson Network Power Co.,Ltd." },
    { 13401, "ETE Software" },
    { 13402, "Exent Technologies Ltd." },
    { 13403, "Foton-2000 Kft." },
    { 13404, "fSONA Communications" },
    { 13405, "Inside Products" },
    { 13406, "Institute of Medical and Veterinary Science" },
    { 13407, "Link2it Corp." },
    { 13408, "Macrobyte Resources" },
    { 13409, "Mega System Technologies, Inc." },
    { 13410, "National Public Radio" },
    { 13411, "ms Neumann-Elektronik GmbH" },
    { 13412, "Ophios GmbH" },
    { 13413, "Olabisi.com" },
    { 13414, "Pairlink" },
    { 13415, "Schlag&rahm GmbH" },
    { 13416, "SecurityMatrix, Inc." },
    { 13417, "silicon broadcasts, Inc." },
    { 13418, "SKKU Information and comunication lab" },
    { 13419, "SRS SAKURA Internet Inc." },
    { 13420, "Surgitec Pte Ltd" },
    { 13421, "Tango Telecom Limited" },
    { 13422, "Uniscope" },
    { 13423, "universite de valenciennesJean-Luc Petit, Jean-Guy Avelin" },
    { 13424, "UPC Netherlands" },
    { 13425, "Virtual Space Research" },
    { 13426, "WZab Software" },
    { 13427, "Artesyn Embedded Technologies (formerly 'Emerson Network Power ')" },
    { 13428, "JAPAN STORAGE BATTERY CO., Ltd." },
    { 13429, "Queen Elizabeth School Old Students' Association" },
    { 13430, "Shanghai Online Bussiness Co.,Ltd." },
    { 13431, "A2E Ltd" },
    { 13432, "CampusEdge Apartments" },
    { 13433, "CodeZombie.com" },
    { 13434, "DYSER S.R.L." },
    { 13435, "General Magic, Inc." },
    { 13436, "iControls, Inc." },
    { 13437, "libits" },
    { 13438, "Logic Eastern(I) Pvt Ltd" },
    { 13439, "Melle Service GmbH" },
    { 13440, "Network Telephone" },
    { 13441, "Norfolk Southern Corp" },
    { 13442, "OpenVES" },
    { 13443, "OZIS" },
    { 13444, "Robert Bird and Partners" },
    { 13445, "Silicon Cocoon Pty.Ltd." },
    { 13446, "Singapore Cable Vision Limited" },
    { 13447, "The Training Mann" },
    { 13448, "Transat Technologies, Inc." },
    { 13449, "trusdata.com" },
    { 13450, "TT&S Tecnologia e Sistemas Ltda." },
    { 13451, "Network Information Center, univ.of buaa" },
    { 13452, "My Lan Guys" },
    { 13453, "Lanmix Technology Co." },
    { 13454, "Hays Supply Chain" },
    { 13455, "Deutsche Rentenversicherung Rechenzentrum Leipzig" },
    { 13456, "A.E.T. Europe B.V." },
    { 13457, "ARM Holdings plc" },
    { 13458, "ATMedia GmbH" },
    { 13459, "CAIS" },
    { 13460, "COMELIS" },
    { 13461, "eBsuccess Solutions Inc." },
    { 13462, "estei" },
    { 13463, "Fort Wayne Community Schools" },
    { 13464, "GCOM Technologies Co.,Ltd. (formerly 'GREENNET TECHNOLOGY CO.,LTD.')" },
    { 13465, "Ingate Systems AB" },
    { 13466, "Jabber, Inc." },
    { 13467, "Medasys" },
    { 13468, "Montclair State University" },
    { 13469, "netLibrary, Inc." },
    { 13470, "SecureGUARD GmbH (formerly 'Otto Security & Software Technologie GmbH')" },
    { 13471, "PowerWAN, Inc" },
    { 13472, "RTS Realtimes Systems (Deutschland) AG" },
    { 13473, "SafeWeb, Inc." },
    { 13474, "Sierra Systems Group Inc." },
    { 13475, "SnapTrack, Inc." },
    { 13476, "Telemant Corp." },
    { 13477, "Shanghai HAORUN Technologies Ltd." },
    { 13478, "Clear2Talk Ltd" },
    { 13479, "dstl" },
    { 13480, "Anyware Technology, Inc." },
    { 13481, "Appload Nordic AB" },
    { 13482, "ATL Telecom" },
    { 13483, "Aviri" },
    { 13484, "Choice One Communications" },
    { 13485, "Comindico" },
    { 13486, "Princeton University" },
    { 13487, "CorVu Corporation" },
    { 13488, "DNCP, LLC" },
    { 13489, "Eastern Goldfields Senior High School" },
    { 13490, "Eplication" },
    { 13491, "EuroMACC Ltd." },
    { 13492, "First Data Merchant Services" },
    { 13493, "Global Science & Technology, Inc." },
    { 13494, "Illinois Mathematics and Science Academy" },
    { 13495, "INAT GmbH" },
    { 13496, "Institute of Informatics, Slovak Academy of Sciences" },
    { 13497, "IT3 Consultants" },
    { 13498, "KKE, Inc" },
    { 13499, "Metoda S.p.A." },
    { 13500, "MPL AG" },
    { 13501, "Nexstar Financial Corporation" },
    { 13502, "OneSquared" },
    { 13503, "Orchestria Limited" },
    { 13504, "Polkomtel S.A." },
    { 13505, "PROCOS AG" },
    { 13506, "Psionic Software, Inc." },
    { 13507, "Radcom Software Romania" },
    { 13508, "SIGDCI" },
    { 13509, "SKY Computers" },
    { 13510, "Somoma County Water Agency" },
    { 13511, "SpaceIP" },
    { 13512, "TeamWarrior Ltd" },
    { 13513, "The Technology Partner" },
    { 13514, "Unassigned" },
    { 13515, "Unitech Networks .Ltd" },
    { 13516, "Viloke Oy" },
    { 13517, "Xi'an Jiaotong University" },
    { 13518, "ABN AMRO NL/CCC" },
    { 13519, "Amsoft Systems India Inc" },
    { 13520, "BizWebApps" },
    { 13521, "Sysnight" },
    { 13522, "Account Synchronization Project" },
    { 13523, "Australian Industry Group" },
    { 13524, "Barham House Publishing, Inc." },
    { 13525, "Blarg! Online Services, Inc." },
    { 13526, "Clickmarks Inc." },
    { 13527, "Digitasaru" },
    { 13528, "DLESE" },
    { 13529, "DreamLAN Network Consulting Ltd." },
    { 13530, "Fahnestock & Co." },
    { 13531, "Tryo Communication Systems S.A. (formerly 'Mier Comunicaciones, S.A.')" },
    { 13532, "Pennant Systems" },
    { 13533, "Petr Zahradnik Computer Laboratory" },
    { 13534, "Proteus Mobile, Inc" },
    { 13535, "IonPipe. Inc." },
    { 13536, "Serome Technology, Inc." },
    { 13537, "Shine Global" },
    { 13538, "VideoBureau, Inc." },
    { 13539, "Voorhout Data Connection BV" },
    { 13540, "Shenzhen Keybridge Communications Co.,Ltd." },
    { 13541, "DBV-Winterthur Versicherungen" },
    { 13542, "Datapac s.r.o." },
    { 13543, "100 Percent IT Ltd" },
    { 13544, "Acopia Networks, Inc." },
    { 13545, "Adverb Software" },
    { 13546, "Alta A/S" },
    { 13547, "Axiom Systems Limited" },
    { 13548, "BakBone Software Inc" },
    { 13549, "Banque de France" },
    { 13550, "Celstream Technologies" },
    { 13551, "Cofunds LTD" },
    { 13552, "CQG, Inc" },
    { 13553, "Cyber Space Systems, Inc." },
    { 13554, "DTN SpeedNet Services, LLC" },
    { 13555, "Enterprise Business Solutions" },
    { 13556, "Filtronic plc" },
    { 13557, "FLOORgraphics, Inc." },
    { 13558, "Gary Reynolds" },
    { 13559, "Global Technology Associates, Inc." },
    { 13560, "Grant County PUD #2" },
    { 13561, "Griffith University" },
    { 13562, "Information Sciences Institute, USC" },
    { 13563, "Integrated Software Technologies Inc." },
    { 13564, "Logistik World GmbH" },
    { 13565, "Lucent Technologies India Ltd" },
    { 13566, "Neolytica" },
    { 13567, "UBIqube Solutions" },
    { 13568, "Neustar, Inc." },
    { 13569, "OIZ" },
    { 13570, "Security Integration, Inc." },
    { 13571, "TESIS SYSware GmbH" },
    { 13572, "TJEdwards" },
    { 13573, "Tran Empire Industries" },
    { 13574, "TVG Technologies Ltd." },
    { 13575, "University of Windsor" },
    { 13576, "WAGO Kontakttechnik GmbH" },
    { 13577, "Youjin" },
    { 13578, "apogee solutions" },
    { 13579, "LMN Associates" },
    { 13580, "Europ Assistance France" },
    { 13581, "TAMAGAWA UNIV." },
    { 13582, "Nordija A/S" },
    { 13583, "UCBIRL" },
    { 13584, "Schering AG" },
    { 13585, "Mangalore Refinery And Petrochemicals Limited" },
    { 13586, "Woodside Networks, Inc." },
    { 13587, "Universite de Franche-Comte" },
    { 13588, "Acegi Technology Pty Limited" },
    { 13589, "Air Traffic Control & Business Systems GmbH" },
    { 13590, "Americredit Corp" },
    { 13591, "BE Intelligent Systems" },
    { 13592, "Blunk Microsystems" },
    { 13593, "CommerceFlow, Inc." },
    { 13594, "Company Watch Limited" },
    { 13595, "EMKA electronic AG" },
    { 13596, "Fachhochschule Bingen" },
    { 13597, "FEIS, University of Hertfordshire" },
    { 13598, "General Dynamics Canada" },
    { 13599, "Golden Triangle Online" },
    { 13600, "greenmokey.net" },
    { 13601, "Hwa Chong Junior College" },
    { 13602, "IS4-O" },
    { 13603, "KPNQwest Czechia s.r.o." },
    { 13604, "Liberate Technologies" },
    { 13605, "Maverick workgroup" },
    { 13606, "Nicomaque" },
    { 13607, "Unassigned" },
    { 13608, "OpenHandHome Inc" },
    { 13609, "Palladium Consulting Inc." },
    { 13610, "Q Solutions" },
    { 13611, "RBC Data" },
    { 13612, "Schlund + Partner AG" },
    { 13613, "StrataVerio" },
    { 13614, "Tartu K\0303\0265rgem Kunstikool" },
    { 13615, "TH" },
    { 13616, "THALES SYSTEM INTEGRATION GmbH" },
    { 13617, "Those Interactive Guys" },
    { 13618, "Transim Technology Corp." },
    { 13619, "UnderCoverWear Collection" },
    { 13620, "University of Wisconsin - Eau Claire" },
    { 13621, "Wind Telecom" },
    { 13622, "Yaina" },
    { 13623, "point it GmbH" },
    { 13624, "EASTCOM-BUPT INFORMATION TECHNOLOGY CO.,LTD." },
    { 13625, "pohlcity.de" },
    { 13626, "Rastel" },
    { 13627, "Netfor, Inc." },
    { 13628, "SerCon GmbH" },
    { 13629, "A.G.Tech Network Service" },
    { 13630, "AFX News Ltd" },
    { 13631, "Arax Communications" },
    { 13632, "ATOMiX DESiGN" },
    { 13633, "AVA Afzar Co." },
    { 13634, "B&B Computersysteme GbR" },
    { 13635, "BSWS" },
    { 13636, "Corestreet, Ltd." },
    { 13637, "Cresent Software Products (PVT) Ltd." },
    { 13638, "Expert Systems IVR (Asia) Co., Ltd." },
    { 13639, "FibroTEC" },
    { 13640, "Jon Wood" },
    { 13641, "Kremlin Computing Limited" },
    { 13642, "LITAS, s.r.o." },
    { 13643, "MIMOS Berhad" },
    { 13644, "Netgate" },
    { 13645, "OKB MEI" },
    { 13646, "Oninit Ltd" },
    { 13647, "Ostsee-Zeitung GmbH & Co. KG" },
    { 13648, "Pointred Technologies, Inc" },
    { 13649, "Polizei Rheinland-Pfalz" },
    { 13650, "Relativity" },
    { 13651, "RexKramer" },
    { 13652, sminmpec_unknown },  /* (Added by Wireshark) */
    { 13653, "Seoul Mobile Telecom, Inc." },
    { 13654, "SHENZHEN XIFENG NETWORK TECHNOLOGIES CO.,LTD" },
    { 13655, "SpaceMonster Gaming Network" },
    { 13656, "SUNNYbell Technology" },
    { 13657, "Tango SA" },
    { 13658, "Teddy's Network" },
    { 13659, "The Worley Companies" },
    { 13660, "U.S. Army CECOM" },
    { 13661, "The University of Manchester (formerly 'UMIST')" },
    { 13662, "Universidad de Palermo" },
    { 13663, "VRGroup.com" },
    { 13664, "VSS KB, a.s." },
    { 13665, "Webs-are.us" },
    { 13666, "Wolf Hill, s.r.o." },
    { 13667, "Wozzle Internet Solutions" },
    { 13668, "Yes Technology" },
    { 13669, "Cubic Transportation Systems, Inc." },
    { 13670, "San Diego Data Processing Corporation" },
    { 13671, "TechTV" },
    { 13672, "General Dynamics - Decision Systems/Secure Products" },
    { 13673, "Internet Cz\0303\0252stochowa" },
    { 13674, "PESA Switching Systems, Inc." },
    { 13675, "bandwave internet" },
    { 13676, "French Data Network" },
    { 13677, "Kb/TEL Telecomunicaciones SA de CV" },
    { 13678, "acter AG" },
    { 13679, "AltiGen Communications Inc." },
    { 13680, "Aviva Solutions Inc." },
    { 13681, "CHILDLOCK solutions" },
    { 13682, "Ecole des Mines de Nantes" },
    { 13683, "EFTechnologies, Inc." },
    { 13684, "ELPROMA Elektronika" },
    { 13685, "Faculty of Mathematics and Computer Science, Nicholas Copernicus University of Torun" },
    { 13686, "go win" },
    { 13687, "Humboldt-Universitaet zu Berlin" },
    { 13688, "Icequake Networks" },
    { 13689, "In Town Consulting LLC" },
    { 13690, "Madras Computer Vertriebsges.m.b.H." },
    { 13691, "Maison d'en France" },
    { 13692, "mediface" },
    { 13693, "Mirage Networks, Inc" },
    { 13694, "Nervus Systems Ltd" },
    { 13695, "Neurosphere Consulting" },
    { 13696, "Ohio Wesleyan University" },
    { 13697, "Paul Dlug" },
    { 13698, "RunCircle Ltd" },
    { 13699, "Sarvega Inc." },
    { 13700, "Scale Eight" },
    { 13701, "Sonic Software" },
    { 13702, "Store Media Engineering" },
    { 13703, "SunDataCom pvt.Ltd.," },
    { 13704, "TNO" },
    { 13705, "Universitas Indonesia" },
    { 13706, "Volvo Event Management" },
    { 13707, "wasiliana solutions" },
    { 13708, "AIC NETWORK" },
    { 13709, "The Bank of New York" },
    { 13710, "LVM Versicherungen" },
    { 13711, "Primus Telecommunications Australia Pty Ltd" },
    { 13712, "ARINC (Aeronautical Radio, Inc.) Roy L. Courtney" },
    { 13713, "Gateweaver" },
    { 13714, "Reea" },
    { 13715, "Alescere" },
    { 13716, "Caja Madrid" },
    { 13717, "Carreker Corporation" },
    { 13718, "CCITRIAD" },
    { 13719, "CEGETEL SI" },
    { 13720, "CoreMedia AG" },
    { 13721, "Corning Cable Systems" },
    { 13722, "deot.net" },
    { 13723, "Division of BITL" },
    { 13724, "Erasmus University Rotterdam" },
    { 13725, "EuroNetics" },
    { 13726, "FH Bonn-Rhein-Sieg" },
    { 13727, "Funda\0303\0247\0303\0243o CPqD - Centro de Pesquisa e Desenvolvimento em Telecomunica\0303\0247\0303\0265es" },
    { 13728, "Fundaci\0303\0263> Aplicaci\0303\0263" },
    { 13729, "Funktional Solutions Group" },
    { 13730, "Geobot, Inc" },
    { 13731, "Huth Engineering Inc" },
    { 13732, "iDirect" },
    { 13733, "IMServ Europe Ltd" },
    { 13734, "Institut fuer Theorie der Elektrotechnik, Universitaet Stuttgart" },
    { 13735, "Integra5 Ltd." },
    { 13736, "Manufacture des Montres Rolex SA" },
    { 13737, "Mark Wilcox & Associates" },
    { 13738, "MindMatics AG" },
    { 13739, "Pacesetter Electronics" },
    { 13740, "Popwire Technology AB" },
    { 13741, "Proinos, INC" },
    { 13742, "Raritan Computer, Inc." },
    { 13743, "SGTE-IES" },
    { 13744, "SkyTel, Inc." },
    { 13745, "Plixer International, Inc. (formerly 'Somix Technologies, INC')" },
    { 13746, "UNIversity of Detroit Mercy" },
    { 13747, "Virtual Health Networks, Inc." },
    { 13748, "Wizzbit" },
    { 13749, "Madison Consulting Inc." },
    { 13750, "Juergen Weber Unternehmensberatung" },
    { 13751, "AGY Therapeutics Incorporated" },
    { 13752, "Amarna Software Productions" },
    { 13753, "Ascent Computing Group Inc" },
    { 13754, "Banco Zaragozano" },
    { 13755, "Carleton College" },
    { 13756, "C-LOG International" },
    { 13757, "COXnet" },
    { 13758, "cr-team.de" },
    { 13759, "Examen, Inc" },
    { 13760, "Fourth House Security Inc" },
    { 13761, "Glencore International AG" },
    { 13762, "Innovery" },
    { 13763, "Johannes Passing Softwareentwicklung" },
    { 13764, "Khodayss Systems Limited" },
    { 13765, "Life Time Fitness, Inc." },
    { 13766, "LOEWE Opta GmbH" },
    { 13767, "Metalogue Communications" },
    { 13768, "Movaris" },
    { 13769, "mozilla.org" },
    { 13770, "MTA Solutions" },
    { 13771, "Navic Systems, Inc., d/b/a Navic Networks, Inc." },
    { 13772, "NPULSE Software, Inc." },
    { 13773, "NTELOS Inc." },
    { 13774, "Onetta, Inc." },
    { 13775, "Pomona College" },
    { 13776, "Potlatch Corporation" },
    { 13777, "Rakuten Inc." },
    { 13778, "Sociedade Diginet, LdaJacques" },
    { 13779, "SUMIX Corporation" },
    { 13780, "ubernul projekt" },
    { 13781, "Universite d'AUVERGNE" },
    { 13782, "University of Dortmund, Department of Mathematics" },
    { 13783, "Viking Society of SA" },
    { 13784, "WhidbeyNet" },
    { 13785, "YH" },
    { 13786, "ZP system" },
    { 13787, "PageMail Inc." },
    { 13788, "Dev-Labs Ltd." },
    { 13789, "Innovations GmbH" },
    { 13790, "U-King Communications Corp." },
    { 13791, "Associa\0303\0247\0303\0243o dos Estudantes" },
    { 13792, "Active Telecom" },
    { 13793, "Acumen Sciences, LLC." },
    { 13794, "Beijing Educational Information Network" },
    { 13795, "Blue Edge Bulgaria" },
    { 13796, "Caliari Research S.p.A. Nicola" },
    { 13797, "CIRAD" },
    { 13798, "Globenet" },
    { 13799, "Internet 78" },
    { 13800, "IS Services" },
    { 13801, "IUFM des Pays de la Loire" },
    { 13802, "Mundee Internet Services" },
    { 13803, "Navajo Law Enforcement Training Academy" },
    { 13804, "Pontifical College Josephinum" },
    { 13805, "Southland Christian Church" },
    { 13806, "SysOpen Plc" },
    { 13807, "Tpack" },
    { 13808, "ubernul projekt" },
    { 13809, "Universit\0303\0251 Jean Monnet Saint Etienne" },
    { 13810, "University of Alaska" },
    { 13811, "Israel Discount Bank" },
    { 13812, "SmartPrice SA" },
    { 13813, "Evalesco Systems ApS" },
    { 13814, "alfa Media Partner GmbH" },
    { 13815, "Angel Iglesias, S.A." },
    { 13816, "AppSense Technologies" },
    { 13817, "Ausw\0303\0244rtiges Amt" },
    { 13818, "BHI" },
    { 13819, "BTI Communications Co." },
    { 13820, "CESKY TELECOM, a.s." },
    { 13821, "CNI/Prairienet" },
    { 13822, "Command Software Systems, Inc" },
    { 13823, "Comtarsia IT Services" },
    { 13824, "Consus Ltd" },
    { 13825, "Crisp Hughes Evans LLP" },
    { 13826, "Dept of Veterans Affairs" },
    { 13827, "EndRun Technologies LLC" },
    { 13828, "ETM International / Austria" },
    { 13829, "Flecha de Lima Associados" },
    { 13830, "GED-SOFTWARE" },
    { 13831, "Geo-Marine, Inc." },
    { 13832, "The Go Daddy Group, Inc." },
    { 13833, "Gobierno de Canarias" },
    { 13834, "iMach, Ltd." },
    { 13835, "inet-logistics GmbH" },
    { 13836, "Information and Logistics Consultancy" },
    { 13837, "IntroTec" },
    { 13838, "KadeL Data Servis s.r.o." },
    { 13839, "MarkitServFX (formerly 'Logicscope Realisations Ltd')" },
    { 13840, "Media Driver, LLC" },
    { 13841, "MetiLinx" },
    { 13842, "Moser-Baer AG" },
    { 13843, "Ned Davis Research Group" },
    { 13844, "North East Worcestershire College" },
    { 13845, "Ohio Northern University" },
    { 13846, "PatientKeeper, Inc." },
    { 13847, "Pearco Services" },
    { 13848, "rnix.com" },
    { 13849, "Sepro Telecom" },
    { 13850, "Static" },
    { 13851, "Swisscom IT SErvices AG" },
    { 13852, "TopoLogica" },
    { 13853, "Tularik" },
    { 13854, "Universitaet Mannheim, Rechenzentrum" },
    { 13855, "Universitaet Oldenburg" },
    { 13856, "University of Michigan Health System" },
    { 13857, "Ursys Pty Ltd" },
    { 13858, "Eltek Valere Inc. (formerly 'Valere Power Inc')" },
    { 13859, "Voxpilot" },
    { 13860, "WASKO" },
    { 13861, "Wolf IT Concepts" },
    { 13862, "XTec, Incorporated" },
    { 13863, "Airwolf Systems, Inc." },
    { 13864, "MAMINOS, Inc." },
    { 13865, "Universit\0303\0251 Charles de Gaulle - Lille 3" },
    { 13866, "ACE TIMING" },
    { 13867, "Adfinis SyGroup AG" },
    { 13868, "Bahrain Credit" },
    { 13869, "Blum Capital Partners, LP" },
    { 13870, "Corporate Oxygen" },
    { 13871, "Falcon Software NV" },
    { 13872, "Federal University of Sao Paulo" },
    { 13873, "FMC" },
    { 13874, "goepp.net" },
    { 13875, "Interact" },
    { 13876, "Ionic Productions LLC" },
    { 13877, "Kanda Tsushin Kogyo Co., Ltd." },
    { 13878, "Kariboo Technologies SA" },
    { 13879, "Natural Soft S.A." },
    { 13880, "ADS Networks Pvt. Ltd" },
    { 13881, "neobee.net" },
    { 13882, "Netilla Networks" },
    { 13883, "New Morning Windows" },
    { 13884, "Pepco AS" },
    { 13885, "Polycom, Inc." },
    { 13886, "Prosodic Communications Inc." },
    { 13887, "Red Roby Software, Inc." },
    { 13888, "South Texas Lighthouse for the Blind" },
    { 13889, "Spriral Designs Inc." },
    { 13890, "Teltier Technologies Inc." },
    { 13891, "The Advantage Group" },
    { 13892, "University of New Hampshire" },
    { 13893, "International Truck and Engine Corporation" },
    { 13894, "LGNsys" },
    { 13895, "LaGrange School District 102" },
    { 13896, "Atos Origin CMS / TSP" },
    { 13897, "Advanced Technologies Lab" },
    { 13898, "Alexander Horsch und Thomas Balbach IT Solutions" },
    { 13899, "Anka Systems, Inc" },
    { 13900, "Blue Gargoyle Consulting, LLC" },
    { 13901, "Broadwave Inc." },
    { 13902, "Business Internet Trends" },
    { 13903, "CAMH PET Centre" },
    { 13904, "Caymas Systems" },
    { 13905, "Cemagref" },
    { 13906, "Chantry Networks Inc." },
    { 13907, "Compera" },
    { 13908, "Croatian Physical Society, Student Section" },
    { 13909, "CTTC - Centre Tecnol\0303\0262gic de Telecomunicacions de Catalunya" },
    { 13910, "Das B\0303\0274ro am Draht" },
    { 13911, "Epsilon d.o.o." },
    { 13912, "Everest Connections" },
    { 13913, "EVoto Team" },
    { 13914, "FreakySoft" },
    { 13915, "Harry R\0303\0274ter Software Solutions" },
    { 13916, "Heimat di Andrea Rota" },
    { 13917, "Hostcentric" },
    { 13918, "Inkasbank" },
    { 13919, "Instinct Internet Solutions" },
    { 13920, "Magic Hosting" },
    { 13921, "NEBS" },
    { 13922, "nologin" },
    { 13923, "Peter Verhas" },
    { 13924, "Powell's Bookstores" },
    { 13925, "Real Time Productions" },
    { 13926, "Road Tech Compter Systems Ltd" },
    { 13927, "SCCNET SOHO Consulting" },
    { 13928, "TC Communications" },
    { 13929, "Teragen Pty Ltd" },
    { 13930, "The Aquarius Network" },
    { 13931, "uberLAN Technologies" },
    { 13932, "Vogon.Net" },
    { 13933, "Alstom Transport" },
    { 13934, "Micchi" },
    { 13935, "100comm" },
    { 13936, "AEGIS Mortgage Corp" },
    { 13937, "Art Global Limited" },
    { 13938, "Ashton Raggatt McDougall" },
    { 13939, "automatX" },
    { 13940, "COE Ltd" },
    { 13941, "Communicator Inc." },
    { 13942, "Candera Inc" },
    { 13943, "Datanet" },
    { 13944, "Denali SA" },
    { 13945, "Deutsche Forschungsgemeinschaft" },
    { 13946, "Educational Systems Ltd" },
    { 13947, "EEMA" },
    { 13948, "Exostar LLC" },
    { 13949, "FRANK-EDV-SERVICE Gesellschaft m.b.H." },
    { 13950, "Galileo, Inc." },
    { 13951, "Gentek Marketing Inc." },
    { 13952, "GLOBAL SUN TECHNOLOGY" },
    { 13953, "HelioGraph Limited" },
    { 13954, "IT Guardian Ltd" },
    { 13955, "JPConsulting" },
    { 13956, "KATCH Network Inc" },
    { 13957, "Liquidsite, Inc." },
    { 13958, "M.N. Ramos Ferreira, Electricidade e Mec\0303\0242nica, Lda" },
    { 13959, "MLA Power Systems" },
    { 13960, "NESTAR" },
    { 13961, "NLIP - Dutch ISP Association" },
    { 13962, "QoS Labs" },
    { 13963, "R.V.R. Elettronica SpA" },
    { 13964, "SWCS Chan Pak Sha School" },
    { 13965, "tpgpost" },
    { 13966, "University of Bath" },
    { 13967, "Vaporware" },
    { 13968, "Verlag Fur Neue Medien" },
    { 13969, "VOXSIS Inform\0303\0241tica" },
    { 13970, "Aerostrong Science & Technology Co., Ltd." },
    { 13971, "ChinaBizone Infomation Technology Co., Ltd." },
    { 13972, "Varga Limited" },
    { 13973, "investir publications" },
    { 13974, "Epigenomics AG" },
    { 13975, "Naval Global Directory Service" },
    { 13976, "Interaktivna Consulting" },
    { 13977, "SHAYNE ENTERPRISES" },
    { 13978, "GuardedNet, Inc." },
    { 13979, "Mintact Software Inc (formerly 'CompuCS Inc.')" },
    { 13980, "Platinum Web Pages" },
    { 13981, "INGCHEM" },
    { 13982, "FibreSpeed Ltd." },
    { 13983, "WWR Development, Inc." },
    { 13984, "Cybrick Information Systems" },
    { 13985, "TAE KWANG INDUSTRIAL CO., Ltd." },
    { 13986, "Larry Drummond,Consulting Engineer" },
    { 13987, "C. Plath GmbH" },
    { 13988, "tele-akademie der Fachhochschule Furtwangen" },
    { 13989, "Markus Heiden SAP / EC Consulting" },
    { 13990, "Coloma Community Schools" },
    { 13991, "Accellence Technologies GmbH" },
    { 13992, "M-Net Sys" },
    { 13993, "ITWorx" },
    { 13994, "STN ATLAS Elektronik GmbH" },
    { 13995, "Amperion, Incorporated" },
    { 13996, "kbox" },
    { 13997, "Invisible Industries" },
    { 13998, "Conceptual MindWorks, Inc." },
    { 13999, "ItsNotA.com" },
    { 14000, "Michail Kamprianis" },
    { 14001, "DRS Technologies Canada Ltd. (formerly 'DRS Flight Safety and Communications')" },
    { 14002, "University of Wisconsin - Whitewater" },
    { 14003, "Saint Mary's College" },
    { 14004, "Gap Inc." },
    { 14005, "Kelly" },
    { 14006, "Thomas Melzer Softwareentwicklung" },
    { 14007, "IMPACT Science & Technology, Inc." },
    { 14008, "KT" },
    { 14009, "onSynergy Solutions" },
    { 14010, "Cirrus Real Time Processing" },
    { 14011, "Cyber-Project" },
    { 14012, "net-safe Co., Ltd." },
    { 14013, "Tata Consultancy Services" },
    { 14014, "TP EmiTel Sp. z o.o." },
    { 14015, "Unet Ltd." },
    { 14016, "HG-France" },
    { 14017, "Fachhochschule Technikum Wien" },
    { 14018, "Bryan Bellamy" },
    { 14019, "Betronic Design BV" },
    { 14020, "Zencod" },
    { 14021, "Shapers" },
    { 14022, "Arachne (Poland)" },
    { 14023, "KCOM Service Provider Network (formerly 'Mistral Internet Group')" },
    { 14024, "fiscus GmbH" },
    { 14025, "Landesversicherungsanstalt" },
    { 14026, "Slapd.Net" },
    { 14027, "RiverNorth Systems, Inc." },
    { 14028, "Real Time Engineering" },
    { 14029, "Netzwerk-Lehmann" },
    { 14030, "Smartology vof" },
    { 14031, "STATO MAGGIORE DIFESA - COMANDO C4" },
    { 14032, "SUNY Geneseo" },
    { 14033, "Samart Info Media Co.,Ltd." },
    { 14034, "OU Artaxis" },
    { 14035, "CyberStar" },
    { 14036, "LineCom Ltd" },
    { 14037, "DasW:Lab" },
    { 14038, "Karns Technology" },
    { 14039, "Gagliano & Cia" },
    { 14040, "Branda Tech." },
    { 14041, "Railway Information Systems Co.,Ltd" },
    { 14042, "Freudenberg Haushaltsprodukte KF" },
    { 14043, "Sociedad Andaluza para el Desarrollo de la Sociedad de laInformacion, S.A.U." },
    { 14044, "Kernfysisch Versneller Instituut" },
    { 14045, "iServe (Pty) Ltd." },
    { 14046, "Statens Bostadsfinansierings AB" },
    { 14047, "ISET" },
    { 14048, "Lyse Energi" },
    { 14049, "ProactiveThought Technologies Ltd.Inc." },
    { 14050, "Desert Academy at Sante Fe" },
    { 14051, "NetMaster Digital Security" },
    { 14052, "Profluent systems Australia" },
    { 14053, "Prosum Solutions, LLC" },
    { 14054, "Fibercom" },
    { 14055, "IP Mobile Net, Inc." },
    { 14056, "CEGELEC" },
    { 14057, "Longhill High School" },
    { 14058, "Excogita S.r.l." },
    { 14059, "Oberoesterreichische Versicherung AG" },
    { 14060, "ENS GmbH" },
    { 14061, "Conectiva S.A." },
    { 14062, "Escritorio Juridico Alcala Rhode & Asociados" },
    { 14063, "SeaFire Networks Inc." },
    { 14064, "UC Berkeley Residential Computing" },
    { 14065, "Shanghai FOCI Fiber Optic Communication Equipments Inc." },
    { 14066, "pit.at" },
    { 14067, "allied networks GmbH" },
    { 14068, "Thueringer Netkom GmbH (formerly 'TEAG Netkom GmbH')" },
    { 14069, "Syngenio AG" },
    { 14070, "C3T" },
    { 14071, "Bohr- und Rohrtechnik GmbH" },
    { 14072, "Mistral Software Private Ltd." },
    { 14073, "SMART Technology" },
    { 14074, "Shorcan Brokers Ltd." },
    { 14075, "Rational Software Corporation" },
    { 14076, "Marsh Inc." },
    { 14077, "Esial" },
    { 14078, "ANECT a. s." },
    { 14079, "Active Tools" },
    { 14080, "Brivo Systems, Inc." },
    { 14081, "Armstrong World Industries" },
    { 14082, "uplink coherent solutions" },
    { 14083, "Thomas Enterprises" },
    { 14084, "Cochran Consulting, Inc." },
    { 14085, "ADVFN.com PLC" },
    { 14086, "ESHA Research" },
    { 14087, "Zultys Technologies" },
    { 14088, "Navis LLc" },
    { 14089, "City of Ontario, Oregon" },
    { 14090, "Powerview Systems" },
    { 14091, "Hawker College" },
    { 14092, "University of Rhode Island" },
    { 14093, "Medibase Technologies Co., Ltd." },
    { 14094, "Snow B.V." },
    { 14095, "TechDirection" },
    { 14096, "Forlink Software Corporation Inc." },
    { 14097, "ITW-Informationstechnik GmbH" },
    { 14098, "Hotelequip Ltd." },
    { 14099, "Butchwax Software" },
    { 14100, "WLAN Alliance AB" },
    { 14101, "D.A.Tsenov EA" },
    { 14102, "dacore Datenbanksysteme AG" },
    { 14103, "ICE Systems" },
    { 14104, "tetronik GmbH AEN" },
    { 14105, "Business interactif" },
    { 14106, "Syndicat Interhospitalier de Bretagne" },
    { 14107, "WIENSTROM" },
    { 14108, "Odense Kommune" },
    { 14109, "Jaguar Cars Limited" },
    { 14110, "ORIMOS" },
    { 14111, "Oxspring Network Solutions Ltd." },
    { 14112, "hzw design" },
    { 14113, "MagneTek" },
    { 14114, "Aepona England" },
    { 14115, "Platespin" },
    { 14116, "Telecore, Inc." },
    { 14117, "aostar" },
    { 14118, "Hanover College" },
    { 14119, "Netlife AG" },
    { 14120, "Letifer.org" },
    { 14121, "Stone-IT" },
    { 14122, "Wireless Broadband Alliance Ltd (formerly 'Wi-Fi Alliance')" },
    { 14123, "Expertcity Inc." },
    { 14124, "UK/CA/JN Joint Astronomy Centre" },
    { 14125, "SENAO INTERNATIONAL CO., Ltd." },
    { 14126, "New World PCS Limited" },
    { 14127, "OneChannel" },
    { 14128, "Programming Arts, Inc." },
    { 14129, "Sevan Networks, Inc." },
    { 14130, "Bifco" },
    { 14131, "Ifoundry Systems" },
    { 14132, "CS Systemes d'Information" },
    { 14133, "Buergernetz Weihenstephan e.V." },
    { 14134, "University of Szeged" },
    { 14135, "SysDM" },
    { 14136, "PONTON GmbH" },
    { 14137, "Karis" },
    { 14138, "TGM" },
    { 14139, "City of Nottingham Council" },
    { 14140, "Fachhochschule Lippe und Hoexter" },
    { 14141, "ERECA" },
    { 14142, "ALPWARE" },
    { 14143, "FimOSSchober & Hartl OEG" },
    { 14144, "Malkom S.J." },
    { 14145, "Society for Humanity and International Trancendentalism" },
    { 14146, "Blackbox Consulting Corporation" },
    { 14147, "Fermi National Accelerator Laboratory" },
    { 14148, "Officina di idee" },
    { 14149, "Waddell & Reed Services" },
    { 14150, "Transaction Auditing Group" },
    { 14151, "Splentec Ltd." },
    { 14152, "Dyncorp Systems and Solutions" },
    { 14153, "Sigma SaA" },
    { 14154, "NTKO Network Co., Ltd." },
    { 14155, "TIL TECHNOLOGIES" },
    { 14156, "University of Reading" },
    { 14157, "FHLBank Topeka" },
    { 14158, "Consultoria y estrategia electr\0303\0263nica para internet, S.L.(TestaNet)" },
    { 14159, "Fluent Inc." },
    { 14160, "Tribune Interactive" },
    { 14161, "EPCNet GmbH" },
    { 14162, "IT Solution GmbH" },
    { 14163, "SAGA D.C. GmbH" },
    { 14164, "SANavigator, Inc." },
    { 14165, "iReady" },
    { 14166, "Saviso Consulting Ltd." },
    { 14167, "Seattle University" },
    { 14168, "Owl River Company" },
    { 14169, "INFORMEDIA" },
    { 14170, "Australian Research Centre for Medical Engineering" },
    { 14171, "Memorial University of Newfoundland" },
    { 14172, "Boca Software, Inc." },
    { 14173, "ETRI" },
    { 14174, "Softforum Co., Ltd." },
    { 14175, "Hospital La Fe" },
    { 14176, "Katholieke Hogeschool Leuven" },
    { 14177, "implementa GmbH" },
    { 14178, "JNI Corporation" },
    { 14179, "Airespace, Inc (formerly 'Black Storm Networks')" },
    { 14180, "DS Consulting" },
    { 14181, "Cygnus Technologies" },
    { 14182, "GlobalLocate" },
    { 14183, "Arezzo Telecomunicazioni Srl" },
    { 14184, "Getabigger Network" },
    { 14185, "CYBER SERVICE" },
    { 14186, "Gallant Technologies, Inc." },
    { 14187, "China Netcom Corporation Ltd." },
    { 14188, "Thomas K. Williams, Ltd." },
    { 14189, "probusiness AG" },
    { 14190, "Western Outdoor Interactive" },
    { 14191, "MNOFBB" },
    { 14192, "Granite Technologies" },
    { 14193, "Strabon" },
    { 14194, "Ministry of Social Development" },
    { 14195, "Now Software" },
    { 14196, "California State University, Monterey Bay" },
    { 14197, "SISNEMA Informatica Ltda." },
    { 14198, "PANNAWAY Technologies Incorporated" },
    { 14199, "Accelrys Inc." },
    { 14200, "HCL Comnet Ltd." },
    { 14201, "Daxworld" },
    { 14202, "Dottech International Inc.Ltd." },
    { 14203, "AQL" },
    { 14204, "Reksoft Ltd." },
    { 14205, "MAI Insurance Brokers Ltd." },
    { 14206, "Informatie Beheer Groep" },
    { 14207, "Leroy Somer" },
    { 14208, "OpenWide" },
    { 14209, "Accellent" },
    { 14210, "The Storyteller's Place" },
    { 14211, "Tiffany and Company" },
    { 14212, "Universitaet Muenchen" },
    { 14213, "Scitech it solutions GmbH" },
    { 14214, "Tyco Services" },
    { 14215, "Interactive Visuals, Inc." },
    { 14216, "Sendfar Technology Co., Ltd." },
    { 14217, "Wuestenrot Datenservice GmbH" },
    { 14218, "Facultes Universitaires Notre-Dame de la Paix" },
    { 14219, "Hapag-Lloyd Container Linie AG" },
    { 14220, "Akaflieg Munchen e.V." },
    { 14221, "Prodigy Labs" },
    { 14222, "Electric Reliability Council of Texas, Inc." },
    { 14223, "Sourcefire, Inc." },
    { 14224, "Software Machine" },
    { 14225, "SPL / ACT Wireless" },
    { 14226, "Vizafone" },
    { 14227, "Tampere Polytechnic" },
    { 14228, "Flanders Electric" },
    { 14229, "University of Arkansas-Fayetteville" },
    { 14230, "Engine GmbH & Co. KG" },
    { 14231, "The Shmoo Group" },
    { 14232, "Exelon Corporation" },
    { 14233, "Sonag Company" },
    { 14234, "Isotomic Technologies" },
    { 14235, "SpinCircuit Inc." },
    { 14236, "Banco de la Republica" },
    { 14237, "Sarawak Information Systems Sdn. Bhd." },
    { 14238, "Dilithium Networks" },
    { 14239, "SPRITEInc." },
    { 14240, "Top Global Technology Ltd" },
    { 14241, "Mentorgen, LLC" },
    { 14242, "AOSA Telekom GmbH & Co." },
    { 14243, "RTS Real Time Computersoftware Ges.mbH." },
    { 14244, "Bjerkeset Consulting" },
    { 14245, "The Caudium Group" },
    { 14246, "Natural Convergence" },
    { 14247, "signaflex Inc." },
    { 14248, "Gemini Security Solutions, Inc." },
    { 14249, "Vienne Informatique" },
    { 14250, "Conseil General de la Vienne" },
    { 14251, "Stellar Craft Inc." },
    { 14252, "Prime Solutions Ltd." },
    { 14253, "GridXpert" },
    { 14254, "enhansiv" },
    { 14255, "brvenik.com" },
    { 14256, "Arlys S. A." },
    { 14257, "Link Margin, Inc." },
    { 14258, "Northern Trust Company" },
    { 14259, "Groupe ECE Paris" },
    { 14260, "Linux Systemberatung" },
    { 14261, "Bank Leumi LeIsrael Ltd." },
    { 14262, "Dipl. Ing. Felix Beer" },
    { 14263, "Sven Meinhardt EDV-Service" },
    { 14264, "OutPost Sentinel" },
    { 14265, "itouch" },
    { 14266, "Bulletproff Networks" },
    { 14267, "WrjTec" },
    { 14268, "Projekt Avalon" },
    { 14269, "Beijing Vanlink Communication Co. P.R.China Yu" },
    { 14270, "Technology Hackworks, Inc." },
    { 14271, "Iliad" },
    { 14272, "AWO Kreisverband Essen e.V." },
    { 14273, "IFEN" },
    { 14274, "BDILukasz Tylski" },
    { 14275, "Deutsche Bundeswehr" },
    { 14276, "Osystem AB" },
    { 14277, "tylerfam.net" },
    { 14278, "DINX GmbH" },
    { 14279, "NetHere Internet Services, Inc." },
    { 14280, "All Optical Networks, Inc." },
    { 14281, "RCAT.net" },
    { 14282, "Vertrian" },
    { 14283, "Webraska" },
    { 14284, "Technische Universitat Chemnitz" },
    { 14285, "Cegetel SI" },
    { 14286, "nVISIA" },
    { 14287, "Aegis:Net" },
    { 14288, "Lucterra Informatica Ltda" },
    { 14289, "A3 Design" },
    { 14290, "Infocorp Computer Solutions, Inc." },
    { 14291, "Stefan Lefnaer" },
    { 14292, "The Document Academy" },
    { 14293, "Aditel nv" },
    { 14294, "Collax GmbH" },
    { 14295, "DOP Systems Ltd." },
    { 14296, "Confmon Corp" },
    { 14297, "One.Tel.UK" },
    { 14298, "Control Products, Inc." },
    { 14299, "SiteSuite Australasia" },
    { 14300, "Cyber Switching Inc." },
    { 14301, "Pro Medicus Ltd." },
    { 14302, "papiNet.org" },
    { 14303, "Nextgen, Inc." },
    { 14304, "ScenPro Inc." },
    { 14305, "Kora Institute of Science and Technology Information (KISTI)" },
    { 14306, "FOCI Fiber Optic Communications, Inc." },
    { 14307, "Kawamura Electric Inc." },
    { 14308, "REP" },
    { 14309, "Technische Universitaet Clausthal, Rechenzentrum" },
    { 14310, "Adjoin Solutions, Inc." },
    { 14311, "Technion Communications Corporation" },
    { 14312, "Skypath Networks, Inc." },
    { 14313, "Proceda Tecnologia e Informatica SA" },
    { 14314, "Imaginet" },
    { 14315, "UBServices" },
    { 14316, "Shanghai Huateng Software System Co., Ltd." },
    { 14317, "Ratwater" },
    { 14318, "Alstom T&D P&D" },
    { 14319, "DDD Design GmbH" },
    { 14320, "Credit Lyonnais DSTI/DSAT/PLANET" },
    { 14321, "Techelp Ky" },
    { 14322, "Arnold Design & Informatica Ltda." },
    { 14323, "Dennis IT" },
    { 14324, "The Written Word, Inc." },
    { 14325, "PuceBaboon" },
    { 14326, "Sirius Satellite Radio" },
    { 14327, "VA Linux Systems Japan K.K." },
    { 14328, "JAG Productions, Inc." },
    { 14329, "TimeCertain, LLC" },
    { 14330, "Shanghai Ewaytek Co., Ltd." },
    { 14331, "Beijing Topsec Network Security Technology Co., Ltd." },
    { 14332, "DeadSquid Communications" },
    { 14333, "Phonologies (India) Pvt. Ltd." },
    { 14334, "Milton Keynes Council" },
    { 14335, "Econnect" },
    { 14336, "The Chesapeake Computer Group, Incorporated" },
    { 14337, "Superintendencia de Servicios de Salud" },
    { 14338, "ImpSat S.A.-Colombia" },
    { 14339, "Hioptel" },
    { 14340, "LinuxTek, Inc." },
    { 14341, "Ministry of Pacific Island Affairs" },
    { 14342, "Netway Networks Pty. Ltd." },
    { 14343, "Osprey Network Technologies, Inc." },
    { 14344, "Electronic Commerce Technologies" },
    { 14345, "ETG" },
    { 14346, "Erich Jaeger GmbH" },
    { 14347, "RealNet Kft." },
    { 14348, "Swist Group Technologies (Pty.) Ltd." },
    { 14349, "Dyband Corporation" },
    { 14350, "Storbit" },
    { 14351, "Applied Engineering, Inc." },
    { 14352, "Penn State University" },
    { 14353, "Alessandro Bertela" },
    { 14354, "Menlo Park Presbyterian Church" },
    { 14355, "Chapman University" },
    { 14356, "Bank of Bermuda" },
    { 14357, "WORLDPAC" },
    { 14358, "SnapGear Pty Ltd" },
    { 14359, "Abacus" },
    { 14360, "Routrek Networks, Inc." },
    { 14361, "Foresearch" },
    { 14362, "Telekom Slovenije d.d." },
    { 14363, "Blue Oak Wireless (Pty) Ltd." },
    { 14364, "CLG" },
    { 14365, "IgH Essen GmbH" },
    { 14366, "Energy Research Foundation" },
    { 14367, "Ironic Design, Inc." },
    { 14368, "PUBLIC.AT Internet" },
    { 14369, "TSI" },
    { 14370, "GeoTrust Inc." },
    { 14371, "IOTAC" },
    { 14372, "Universidad Simon Bolivar" },
    { 14373, "MystroTV" },
    { 14374, "International Software Solutions" },
    { 14375, "Wireless Services Corp." },
    { 14376, "Applied Signal Technology, Inc." },
    { 14377, "CORE SECURITY TECHNOLOGIES" },
    { 14378, "lmjn.com" },
    { 14379, "VarioSecure Networks, Inc." },
    { 14380, "KT ICOM" },
    { 14381, "TeleCIS, Inc." },
    { 14382, "Superlong IT Ltd." },
    { 14383, "Openexpertise Pty. Ltd." },
    { 14384, "Romsym Data" },
    { 14385, "RTE Software" },
    { 14386, "soLNet, s.r.o" },
    { 14387, "Absolute Systems (PTY) Ltd" },
    { 14388, "Toll Collect" },
    { 14389, "Spider Internet Technologies, Inc." },
    { 14390, "QRS Healthcare Solutions" },
    { 14391, "Ace Suares" },
    { 14392, "SI-Solucoes de Informatica" },
    { 14393, "PRODASAL Companhia de Processamento de Dados de Salvador" },
    { 14394, "New Mass Media, Inc." },
    { 14395, "University of Oregon" },
    { 14396, "c4net" },
    { 14397, "ICSS" },
    { 14398, "Behavioral Informatics Inc." },
    { 14399, "NEC Platforms, Ltd." },
    { 14400, "VentureTechs Corp." },
    { 14401, "Joint Stock Company Volgatelecom, Penza region" },
    { 14402, "University of Geneva" },
    { 14403, "Gymnasium Hermann-Boese-Str." },
    { 14404, "Spediant Systems Ltd." },
    { 14405, "Charon Systems Inc." },
    { 14406, "United Land Services, Inc." },
    { 14407, "Xidus.Net" },
    { 14408, "nDosa Technologies, Inc." },
    { 14409, "DCANet" },
    { 14410, "TSSX" },
    { 14411, "Beijing QXCOMM Technology CO., Ltd." },
    { 14412, "European Transaction Bank AG" },
    { 14413, "Comfone AG" },
    { 14414, "Regio Ltd." },
    { 14415, "e-mobilizer" },
    { 14416, "ntl" },
    { 14417, "Continentale Krankenversicherung A.G." },
    { 14418, "Centro de Tecnologia da Informa\0303\0247\0303\0243o \"Luiz de Queiroz\"" },
    { 14419, "EMIGRATUS Communications Inc." },
    { 14420, "ltinetworks.com" },
    { 14421, "Mocana Corporation" },
    { 14422, "Tazmen Technologies" },
    { 14423, "Rondosoft, Inc." },
    { 14424, "humatix" },
    { 14425, "Telkonet Inc." },
    { 14426, "Enterprise Innovations Corporation" },
    { 14427, "NACT Telecommunications Inc." },
    { 14428, "Welstand" },
    { 14429, "McLuckie and Associates" },
    { 14430, "PoliVec Inc." },
    { 14431, "Universitas Kristen Krida Wacana" },
    { 14432, "Reserved" },
    { 14433, "China Financial Certification Authority" },
    { 14434, "Network Systems and Technologies" },
    { 14435, "Vrije Universiteit Amsterdam" },
    { 14436, "Quiconnect.com" },
    { 14437, "baltz.org" },
    { 14438, "PolarLake" },
    { 14439, "Hit Internet Technologies S.p.A" },
    { 14440, "Longship Scout Group" },
    { 14441, "Miller Zell" },
    { 14442, "XYBASE (Malaysia) Sdn Bhd" },
    { 14443, "July Systems" },
    { 14444, "Redback IT Pty Ltd" },
    { 14445, "Elecs Industry Co., Ltd." },
    { 14446, "INDEO GmbH" },
    { 14447, "Spektra Group Ltd" },
    { 14448, "Iatrogenix.com" },
    { 14449, "HitNet e.V." },
    { 14450, "Twicom" },
    { 14451, "Industrial Computing Ltd" },
    { 14452, "Everyone.net" },
    { 14453, "ISIS Networks" },
    { 14454, "Tel-Aviv University" },
    { 14455, "IntercontinentalExchange" },
    { 14456, "Lemuria Asesores Informaticos C.A." },
    { 14457, "Lorex Industries, Inc." },
    { 14458, "ILIENT" },
    { 14459, "Hennessy Digital" },
    { 14460, "B Digital" },
    { 14461, "Keyware Solutions Inc." },
    { 14462, "Psgue Corporation" },
    { 14463, "Tour2000 co., LTD" },
    { 14464, "ValueCommerce" },
    { 14465, "NOC Grove" },
    { 14466, "Heinrich-Heine-Universitaet Duesseldorf" },
    { 14467, "STIME" },
    { 14468, "Marconi Integrated Systems" },
    { 14469, "Cyclone Computer Consultants Ltd" },
    { 14470, "Plahl Karl Consult" },
    { 14471, "Wasabi Systems" },
    { 14472, "VIA NET.WORKS Services AG" },
    { 14473, "Queen's University" },
    { 14474, "NextAxiom Technology, Inc." },
    { 14475, "Ralph DeHart" },
    { 14476, "Network Executive Software, Inc." },
    { 14477, "RELIX" },
    { 14478, "University of Melbourne" },
    { 14479, "Korea National Defence University" },
    { 14480, "norisbank AG" },
    { 14481, "KOBIL Systems GmbH" },
    { 14482, "System 5" },
    { 14483, "UNIC Internet Consulting" },
    { 14484, "Digital V6 Corp." },
    { 14485, "Sanmina-SCI Inc" },
    { 14486, "Marlboro College" },
    { 14487, "Erkkila Consulting" },
    { 14488, "Darkmist" },
    { 14489, "mcgrew.net Inc." },
    { 14490, "Ariadne Internet Services, Inc." },
    { 14491, "Standard School District" },
    { 14492, "Dialogue Technology Corporation" },
    { 14493, "Aurigo Software Technologies" },
    { 14494, "ASPedi GmbH" },
    { 14495, "Hans Lie" },
    { 14496, "SwedishAmerican Health System Corporation" },
    { 14497, "Gist Communications, Inc." },
    { 14498, "Style Networks, Inc." },
    { 14499, "e-Bank" },
    { 14500, "Warsaw University" },
    { 14501, "Blue Coat Systems" },
    { 14502, "Sam Asher Computing Services, Inc." },
    { 14503, "Asylum Visual Effects" },
    { 14504, "Packet Signal Corporation" },
    { 14505, "Spiral Designs Inc." },
    { 14506, "Ministerul Apararii Nationale" },
    { 14507, "Russian American Glass Company - RASKO Ltd" },
    { 14508, "Teknovus" },
    { 14509, "Mercateo AG" },
    { 14510, "Astra Datentechnik GmbH" },
    { 14511, "London Metropolitan University" },
    { 14512, "Aspivia (Pty) Ltd." },
    { 14513, "Webflex" },
    { 14514, "DAVE s.r.l." },
    { 14515, "GenoGRID" },
    { 14516, "Sanoma Budapest Publishing Ltd." },
    { 14517, "Tactel AB" },
    { 14518, "Pihana Pacific, Inc." },
    { 14519, "Washington University" },
    { 14520, "Wolfram Research Inc." },
    { 14521, "H K Moore Limited" },
    { 14522, "GVI Medical Devices" },
    { 14523, "hermit.org" },
    { 14524, "Pharos Systems" },
    { 14525, "Trapeze Networks, Inc" },
    { 14526, "Safenet Informatica Ltda" },
    { 14527, "iWiring" },
    { 14528, "Newlands College" },
    { 14529, "FHPWireless" },
    { 14530, "Robert Baptista" },
    { 14531, "Blackwell Consulting Services" },
    { 14532, "The Asylum" },
    { 14533, "Apoteket AB" },
    { 14534, "SCHIFFKO GmbH" },
    { 14535, "Europoint Networking" },
    { 14536, "Inceritus" },
    { 14537, "TMP Consultoria de Informatica S/C Ltda" },
    { 14538, "Beijing SinceTimes Communication Co., Ltd." },
    { 14539, "realprogrammers.com" },
    { 14540, "Leszek Pisarek" },
    { 14541, "DeanO" },
    { 14542, "Verizon ESG" },
    { 14543, "N30D" },
    { 14544, "Shanghai Posts&Telecommunications Equipment CO., Ltd." },
    { 14545, "ICT, Academy of Science, CHINA" },
    { 14546, "NTO \"IRE-POLUS\"" },
    { 14547, "Neue Zurcher Zeitung" },
    { 14548, "Autovalley" },
    { 14549, "Awanim" },
    { 14550, "Metaware S.p.A" },
    { 14551, "GSI mbH" },
    { 14552, "Rison Craft" },
    { 14553, "DaimlerChrysler Corp." },
    { 14554, "VU MIF" },
    { 14555, "CMGCC" },
    { 14556, "Graven Software" },
    { 14557, "Infowave Software Inc." },
    { 14558, "SunGard BSR, Inc." },
    { 14559, "Mondru AB" },
    { 14560, "TSCNet, Inc." },
    { 14561, "Vocent Solutions" },
    { 14562, "e-Project Solutions Pte Ltd" },
    { 14563, "National Information and Communication Technology Australia" },
    { 14564, "elbers.com" },
    { 14565, "Z-Force, Inc." },
    { 14566, "BMF" },
    { 14567, "Coventry University Enterprises Ltd" },
    { 14568, "Weiser" },
    { 14569, "Heidelberger Druckmaschinen AG" },
    { 14570, "Majentis Technologies Inc." },
    { 14571, "Atomz Corporation" },
    { 14572, "EDIWISE" },
    { 14573, "Abest Research Corp." },
    { 14574, "Cellicium SA" },
    { 14575, "Attention Software, Inc." },
    { 14576, "Total Network" },
    { 14577, "ForestExpress, LLC" },
    { 14578, "Geac Library Solutions" },
    { 14579, "Q Linux Solutions, Inc." },
    { 14580, "The Manticore Group" },
    { 14581, "ManaSoft" },
    { 14582, "LUZ Engenharia Financeira" },
    { 14583, "TruTeq Wireless" },
    { 14584, "Celestix Networks" },
    { 14585, "Compass Internet" },
    { 14586, "Tmax soft" },
    { 14587, "Technological Centre \"Tushino\" CB RF" },
    { 14588, "Neosymmetria" },
    { 14589, "Sicap Ltd" },
    { 14590, "Passave Inc." },
    { 14591, "ncc network consulting GmbH" },
    { 14592, "iOrange - Internet Software and Service GmbH" },
    { 14593, "Dyode" },
    { 14594, "Rudolf Bahr" },
    { 14595, "BillReilly" },
    { 14596, "Martin Wismans GmbH" },
    { 14597, "DolphinSearch, Inc." },
    { 14598, "USDS" },
    { 14599, "Corman" },
    { 14600, "CryptAll Limited" },
    { 14601, "Baazee.com" },
    { 14602, "Interval Media" },
    { 14603, "Cyberport.de GmbH" },
    { 14604, "Commvault Systems" },
    { 14605, "Wesleyan University" },
    { 14606, "Hewlett-Ward Inc." },
    { 14607, "Futuro Technologies Inc" },
    { 14608, "Transfinity Corp" },
    { 14609, "Todito.com S.A. de C.V." },
    { 14610, "Solutions First" },
    { 14611, "Web-Alm GmbH" },
    { 14612, "Link\0303\0266ping University" },
    { 14613, "Ecora" },
    { 14614, "AvantCom Corporation" },
    { 14615, "Vivato Inc." },
    { 14616, "University of Arkansas at Little Rock" },
    { 14617, "Dise\0303\0261os Electronicos" },
    { 14618, "Mennen Medical" },
    { 14619, "Quadrox Inc." },
    { 14620, "Saint-Gobain" },
    { 14621, "Wendy's International" },
    { 14622, "VTLS Inc" },
    { 14623, "Riverstyx Internet" },
    { 14624, "vergerus" },
    { 14625, "Servecomm" },
    { 14626, "Reuters" },
    { 14627, "Idt Corp" },
    { 14628, "ResEl" },
    { 14629, "SourceTech AB" },
    { 14630, "Binary Systems Inc" },
    { 14631, "American Institute of Physics" },
    { 14632, "Via Internaathional" },
    { 14633, "Nuberry Ltd" },
    { 14634, "Itool Systems" },
    { 14635, "daviesco" },
    { 14636, "Ontain Corporation" },
    { 14637, "Solectron" },
    { 14638, "Concurrent Reality Pty Ltd" },
    { 14639, "HXTP" },
    { 14640, "Wurley Solutions" },
    { 14641, "Raymond James Financial" },
    { 14642, "104.com" },
    { 14643, "Future Beacon, Inc." },
    { 14644, "HiFlyCom Corp." },
    { 14645, "W-ibeda High Tech. Develop. Co. Ltd." },
    { 14646, "buptNKL" },
    { 14647, "Rossberry Consulting" },
    { 14648, "SurfNShop E-Commerce Inc." },
    { 14649, "holleyism.com" },
    { 14650, "Lead Up Software" },
    { 14651, "T-Systems International GmbH SL NWS" },
    { 14652, "University of St. Thomas" },
    { 14653, "Metaways Infosystems GmbH" },
    { 14654, "MUZO, a.s." },
    { 14655, "Gatespace" },
    { 14656, "4IT S.A." },
    { 14657, "Universita' degli Studi di Parma" },
    { 14658, "Dieter Kluenter System Beratung" },
    { 14659, "Vividlink Detlef Ingendorf" },
    { 14660, "Fachhochschule Wiesbaden" },
    { 14661, "KAV-EMB" },
    { 14662, "Bid-Owl Bildung im Dialog Ostwestfalen-Lippe" },
    { 14663, "IXIF Limited" },
    { 14664, "Init Systems" },
    { 14665, "Comlab Telecommunications inc" },
    { 14666, "McLeod Lake Indian Band" },
    { 14667, "NextiraOne LLC" },
    { 14668, "ViaSat, Inc., Acceleration Research and Technology (formerly 'Intelligent Compression Technologies')" },
    { 14669, "Systemhaus x-Team" },
    { 14670, "MTX Networks Inc." },
    { 14671, "GenFour Communications, LLC" },
    { 14672, "Datamaxx Applied Technologies Inc" },
    { 14673, "Prefeitura Municipal de Alegrete" },
    { 14674, "InfoQuality Consultoria em Inform\0303\0241tica" },
    { 14675, "Centell Kingdom Technologies Corporation Shanghai Branch" },
    { 14676, "Obsidian Systems" },
    { 14677, "geekhosting" },
    { 14678, "BFW Informationssysteme GmbH" },
    { 14679, "Hansard International Ltd" },
    { 14680, "Bright Grey" },
    { 14681, "Tixoronet Vertriebsgesellschaft mbH" },
    { 14682, "Asopos de Vliet" },
    { 14683, "Centell Kingdom Technologies Corporation Shanghai" },
    { 14684, "System Management Network" },
    { 14685, "DataPower Technology, Inc." },
    { 14686, "Megasoft Limited" },
    { 14687, "Halion Systems" },
    { 14688, "Systems Experience" },
    { 14689, "Urbancode Software Development, Inc." },
    { 14690, "Greymoose" },
    { 14691, "Fingerlos" },
    { 14692, "Integrators AG" },
    { 14693, "CISL Systems Ltd." },
    { 14694, "bmd wireless AG" },
    { 14695, "Herrmannsdoerfer Software Entwicklung" },
    { 14696, "Absolut OK" },
    { 14697, "RRDtool" },
    { 14698, "CSRI \"Elektropribor\"" },
    { 14699, "Hagen Software Inc." },
    { 14700, "frontiertech" },
    { 14701, "Persist Technologies" },
    { 14702, "Neusoft Digital Medical System CO., LTD." },
    { 14703, "MIYAKAWA ELECTRIC WORKS LTD." },
    { 14704, "PingoS e.V." },
    { 14705, "Province of British Columbia" },
    { 14706, "sFlow.org" },
    { 14707, "Tatara Systems, Inc." },
    { 14708, "Graceland University" },
    { 14709, "Reactivity, Inc." },
    { 14710, "Taua Biomatica" },
    { 14711, "Vaka Technology Limited" },
    { 14712, "Sascha Growe" },
    { 14713, "Blacksburg Electronic Village" },
    { 14714, "Questra Corporation" },
    { 14715, "ManyStreams Inc." },
    { 14716, "British Columbia Institute of Technology" },
    { 14717, "sunHosting company" },
    { 14718, "BKit Gruppen AB" },
    { 14719, "Harmony Gold Operations" },
    { 14720, "HD-info" },
    { 14721, "Techem AG" },
    { 14722, "Peter Shillan" },
    { 14723, "canal systems GmbH" },
    { 14724, "Business Objects" },
    { 14725, "SaM Solutions" },
    { 14726, "Server Side S.A" },
    { 14727, "Henrik Edlund" },
    { 14728, "Pronet sp. j." },
    { 14729, "Innerwall" },
    { 14730, "Telecom Italia Lab" },
    { 14731, "Christian Kuelker" },
    { 14732, "Nodots Development, Inc." },
    { 14733, "YASKAWA INFORMATION SYSTEMS Corporation" },
    { 14734, "FLOW Communications" },
    { 14735, "ESOO" },
    { 14736, "ghip systems GmbH" },
    { 14737, "Global Grid Forum" },
    { 14738, "Henderson & Co" },
    { 14739, "rleague.com" },
    { 14740, "TechAngle Inc." },
    { 14741, "Catalyst International, Inc." },
    { 14742, "Digital Multitools Inc." },
    { 14743, "Wachovia Bank" },
    { 14744, "TeleNova Research and Development Centre" },
    { 14745, "Pumpkin Networks" },
    { 14746, "Interstorm, Inc." },
    { 14747, "Vision Internet Services" },
    { 14748, "Computer Support Systems Pty. Ltd." },
    { 14749, "University of Rochester" },
    { 14750, "Aware Servers, Inc." },
    { 14751, "SkyWare Communications Limited" },
    { 14752, "Proware Technology Corp." },
    { 14753, "ppyworld" },
    { 14754, "Koch Mikrosysteme AG" },
    { 14755, "LYNX Technik AG" },
    { 14756, "ProgTec GmbH" },
    { 14757, "Groiss Informatics GmbH" },
    { 14758, "BPS Co. Ltd." },
    { 14759, "Adesium R\0303\0251seaux et Services" },
    { 14760, "Wincor Nixdorf International GmbH" },
    { 14761, "Ubisecure Solutions" },
    { 14762, "intarsys consulting GmbH" },
    { 14763, "Video-Net Systems" },
    { 14764, "MisrNet, S.A.E." },
    { 14765, "Grafix Profesional S.R.L." },
    { 14766, "AVICONSULT" },
    { 14767, "BWXT-PANTEX" },
    { 14768, "AGMarine, Inc." },
    { 14769, "Sybari Software, Inc." },
    { 14770, "Teleport Consulting and Systemmangement" },
    { 14771, "Computer Sciences Corporation" },
    { 14772, "Neptune Project" },
    { 14773, "Engitech Ltd." },
    { 14774, "GNU Internet" },
    { 14775, "Peak Internet" },
    { 14776, "Mystic Coders" },
    { 14777, "izenpe s.a." },
    { 14778, "GEV - Ecole des Mines" },
    { 14779, "e2 Technology Inc." },
    { 14780, "KAEVEE" },
    { 14781, "ThoughtPort Authority of Chicacgo" },
    { 14782, "Cole Innovations, Inc." },
    { 14783, "Asociacion para la Promocion del Arte a traves de Internet" },
    { 14784, "AltaTrust" },
    { 14785, "Five4321" },
    { 14786, "Open Network Solutions Ltd" },
    { 14787, "ZYM Linux" },
    { 14788, "William D. Petitt" },
    { 14789, "Principal Financial Group" },
    { 14790, "Statsbiblioteket" },
    { 14791, "Nakua Technologies" },
    { 14792, "Data Conseil" },
    { 14793, "System-Entwicklung Dietrich Schulten" },
    { 14794, "Banco Herrero" },
    { 14795, "Intellocity" },
    { 14796, "AUCOS elektronische Geraete GmbH" },
    { 14797, "DynaStar Communications" },
    { 14798, "NETdelivery Corporation" },
    { 14799, "StarNET Services" },
    { 14800, "Legra Systems" },
    { 14801, "tangro software components gmbh" },
    { 14802, "Inder.Net" },
    { 14803, "Schubert Informationssysteme" },
    { 14804, "Innotrac Diagnostics Oy" },
    { 14805, "AFP7" },
    { 14806, "Tadiran Electronic Systems" },
    { 14807, "FrIc-Net" },
    { 14808, "The Sage Colleges" },
    { 14809, "Datasul MED S.A." },
    { 14810, "Advanced Digital Broadcast Ltd." },
    { 14811, "Xilith LLC" },
    { 14812, "Cedars-Sinai Health Systems" },
    { 14813, "Fujitsu Transaction Solutions Inc." },
    { 14814, "CaroTechnology BV" },
    { 14815, "Datasul S.A." },
    { 14816, "Thomas Polnik" },
    { 14817, "4RF Communications Ltd." },
    { 14818, "Voice Mobility, Inc." },
    { 14819, "University of Cyprus" },
    { 14820, "net outremer caledonie" },
    { 14821, "Stibo" },
    { 14822, "FaJo.de" },
    { 14823, "Aruba Networks Inc" },
    { 14824, "Centaur Technology Inc" },
    { 14825, "Aldata Solutions S.A." },
    { 14826, "Adage Networks" },
    { 14827, sminmpec_unknown },  /* (Added by Wireshark) */
    { 14828, "Sonorys Technology GmbH" },
    { 14829, "Centra Software" },
    { 14830, "UPtime Systeml\0303\0266sungen" },
    { 14831, "voetter.at" },
    { 14832, "ESO Consortium" },
    { 14833, "Portal Solutions Technology, Inc." },
    { 14834, "Konsec GmbH (formerly 'mediales GmbH')" },
    { 14835, "INFOTEC" },
    { 14836, "VARTA Microbattery GmbH" },
    { 14837, "Trenchant Consulting, LLC" },
    { 14838, "National Management & Organization SA" },
    { 14839, "Newtech-BT Ltd" },
    { 14840, "Smartwave SA" },
    { 14841, "LEA (Laboratoire Europeen ADSL)" },
    { 14842, "LANergy" },
    { 14843, "Satnet SARL" },
    { 14844, "Upfront Systems" },
    { 14845, "Engineering Ingegneria Informatica S.p.A." },
    { 14846, "Padtec Optical Components and Systems" },
    { 14847, "Order of Preachers" },
    { 14848, "better networks" },
    { 14849, "Corporate Computer Services, Inc." },
    { 14850, "Arc Solutions Limited" },
    { 14851, sminmpec_unknown },  /* (Added by Wireshark) */
    { 14852, "Kinpo Electronics, Inc." },
    { 14853, "CipherQuest Ltd." },
    { 14854, "Beijing Hisense Digi_Tech Co.,Ltd." },
    { 14855, "CERAMISTA Recom Serviex" },
    { 14856, "Trinitel Corporation" },
    { 14857, "XCAT Co.,Ltd." },
    { 14858, "Azundris Consulting" },
    { 14859, "Lawo AG" },
    { 14860, "GWS mbH" },
    { 14861, "Britannia Building Society" },
    { 14862, "Ministerio de Administraciones P\0303\0272blicas" },
    { 14863, "ATMAVA Ltd" },
    { 14864, "TNCE" },
    { 14865, "Interplex Telecom" },
    { 14866, "Cottonwood Technology Group, Inc." },
    { 14867, "Halcyon Software Limited" },
    { 14868, "MAV INFORMATIKA Ltd." },
    { 14869, "Saudi Telecom" },
    { 14870, "AVAYA" },
    { 14871, "Inter-Land.Net" },
    { 14872, "AVK-AdherSIS Inc." },
    { 14873, "Broadband services" },
    { 14874, "Rockstorm Technology AB" },
    { 14875, "Leadglobe" },
    { 14876, "Open Text Corporation" },
    { 14877, "Plexus Technology Ltd." },
    { 14878, "vcrDev" },
    { 14879, "woko" },
    { 14880, "Systemhaus Kalkhoff" },
    { 14881, "QunaTech" },
    { 14882, "smartBridges" },
    { 14883, "antek networks INC." },
    { 14884, "Exelmon Technologies" },
    { 14885, "JSC RPE \"Polygon\"" },
    { 14886, "AIR Co., Ltd." },
    { 14887, "Nomura Research Institute, Ltd." },
    { 14888, "Das Werk" },
    { 14889, "openforum.us" },
    { 14890, "Team-Konzept Informationstechnologien GmbH & Co KG" },
    { 14891, "Lawseal" },
    { 14892, "Netsynt S.p.A." },
    { 14893, "NOXA" },
    { 14894, "Teatica" },
    { 14895, "Propel Software Corporation" },
    { 14896, "Attingo" },
    { 14897, "York Consulting" },
    { 14898, "Access Communications" },
    { 14899, "Town of Suffield" },
    { 14900, "Integrated Concepts International" },
    { 14901, "Vodafone Libertel NV" },
    { 14902, "DATAmark" },
    { 14903, "Digirose Technology Co., Ltd." },
    { 14904, "TwTec" },
    { 14905, "DEVAU Lemppenau GmbH" },
    { 14906, "NVISION, INC." },
    { 14907, "NOC-CCE-USP" },
    { 14908, "Upcast Inc" },
    { 14909, "Igenda Software" },
    { 14910, "IP Solutions, Inc." },
    { 14911, "RFP Depot, LLC." },
    { 14912, "Smiths Aerospace" },
    { 14913, "Retriever Communications" },
    { 14914, "Vexus Consulting Group" },
    { 14915, "ASPire Technologies(Shenzhen) Ltd" },
    { 14916, "Utah Interactive, Inc." },
    { 14917, "SimpleTech" },
    { 14918, "Algar Telecom Leste" },
    { 14919, "Singlestep Technologies" },
    { 14920, "Mineco" },
    { 14921, "CTW Computer" },
    { 14922, "Realnode Ltd" },
    { 14923, "Abilene Christian University" },
    { 14924, "The NewSof Group, Inc." },
    { 14925, "Wavecentral, L.L.C." },
    { 14926, "atraia.com" },
    { 14927, "DISC, Universidad Cat\0303\0263lica del Norte" },
    { 14928, "Unipulse" },
    { 14929, "Onscom Co., Ltd." },
    { 14930, "Solar Telecom. Technology Inc." },
    { 14931, "Victoria University of Technology" },
    { 14932, "GuangZhou TopTeam Software Technology Co., Ltd." },
    { 14933, "Chung Yuan Christian University" },
    { 14934, "Vodafone IT (Turkey)" },
    { 14935, "FS Walker Hughes Limited" },
    { 14936, "Eurotux Inform\0303\0241tica, SA" },
    { 14937, "Itech" },
    { 14938, "Exacom, Inc." },
    { 14939, "StyleeB LLC" },
    { 14940, "BlueCross and BlueShield of North Carolina" },
    { 14941, "Inflection Systems" },
    { 14942, "Avvio Networks" },
    { 14943, "INNOVATION Data Processing" },
    { 14944, "Primal Technologies" },
    { 14945, "JBX Designs Inc" },
    { 14946, "Gothenburg University" },
    { 14947, "Kyrgyz-Russian Slavic University" },
    { 14948, "Hungarian Foreign Trade Bank" },
    { 14949, "North Building Technologies Ltd." },
    { 14950, "Servicios Digitales de Certificacion, S.L." },
    { 14951, "EFACEC SISTEMAS DE ELECTR\0303\0223NICA, S.A." },
    { 14952, "Eyeheight Ltd." },
    { 14953, "Serio Ltd" },
    { 14954, "Cingular Wireless" },
    { 14955, "CANAM" },
    { 14956, "NetGate SL" },
    { 14957, "Nissan North America" },
    { 14958, "PSC technology GmbH" },
    { 14959, "CBR Yaz\0303\0275l\0303\0275m dan\0303\0275\0303\0276manl\0303\0275k A.\0303\0236" },
    { 14960, "Undernet" },
    { 14961, "Millennium Technology Limited" },
    { 14962, "Ingosstrakh Ltd." },
    { 14963, "Telemetry & Communications Systems, Inc." },
    { 14964, "Cogenit" },
    { 14965, "Wideinfo Corporation" },
    { 14966, "Linos Photonics GmbH & Co KG" },
    { 14967, "horsfall.org" },
    { 14968, "WYNIWYG" },
    { 14969, "Columbia Ultimate" },
    { 14970, "CAM Internet" },
    { 14971, "dlh services" },
    { 14972, "Jeb" },
    { 14973, "Deeming.net" },
    { 14974, "Data Telecom O\0303\0234" },
    { 14975, "BRy Tecnologia S.A." },
    { 14976, "softmillennium" },
    { 14977, "Wuerth Elektronik" },
    { 14978, "Commerzbank AG" },
    { 14979, "Core Tec Communications, LLC" },
    { 14980, "Guidant Corporation" },
    { 14981, "Cogent Logic Corporation" },
    { 14982, "iKu Systemhaus AG" },
    { 14983, "Woaf Tech Ltd" },
    { 14984, "PoCo" },
    { 14985, "Hsi Hu Serion High School" },
    { 14986, "Nextreaming Corporation" },
    { 14987, "E3Networks,LTD" },
    { 14988, "MikroTik" },
    { 14989, "Cinesite Europe Ltd" },
    { 14990, "inm magic" },
    { 14991, "RESA Airport Data Systems" },
    { 14992, "Stagira" },
    { 14993, "IGD" },
    { 14994, "MITEQ, Inc." },
    { 14995, "Netinary" },
    { 14996, "Stille Design" },
    { 14997, "SOHOware, Inc." },
    { 14998, "Transportation Security Administration" },
    { 14999, "Codesic" },
    { 15000, "Kontron Canada Inc" },
    { 15001, "Seward Designs, Inc." },
    { 15002, "Intentional Software Corporation" },
    { 15003, "IPonWEB Ltd" },
    { 15004, "RuggedCom Inc." },
    { 15005, "Fiba Software srl" },
    { 15006, "P.W.P.T. Wasko sp. z o.o." },
    { 15007, "Metro Ethernet Forum" },
    { 15008, "Tilaria Inc." },
    { 15009, "Gplicity" },
    { 15010, "LogiTEL Ltd" },
    { 15011, "Revivio Incorporated" },
    { 15012, "Bernard Madoff Investment Securities" },
    { 15013, "Quantec, LLC" },
    { 15014, "8004 Limited" },
    { 15015, "Integrated Modular Systems, Inc." },
    { 15016, "Nettiportti OY" },
    { 15017, "Johns Hopkins Singapore" },
    { 15018, "DayDay Software LTD." },
    { 15019, "Bazy i Systemy Bankowe Sp. z o.o." },
    { 15020, "Productos Profesionales de Telecomunicacion" },
    { 15021, "mobidot" },
    { 15022, "Golden Gate University" },
    { 15023, "tremium" },
    { 15024, "Tougas.NET" },
    { 15025, "Studentersamfundet i Trondhjem" },
    { 15026, "centre hospitalier de roanne" },
    { 15027, "SecCommerce Technologies AG" },
    { 15028, "James Collings" },
    { 15029, "Jareva Technologies, Inc" },
    { 15030, "Guangzhou RCOM Communication Co., Ltd" },
    { 15031, "University of Melbourne, Computer Science/Grid Computing" },
    { 15032, "INQGEN Technology Co., Ltd." },
    { 15033, "Realtime Embedded AB" },
    { 15034, "KSolutions S.p.A." },
    { 15035, "Partner Voxtream" },
    { 15036, "Logical" },
    { 15037, "Shands Healthcare and Teaching Clinics, Inc." },
    { 15038, "Charles Stark Draper Laboratory, Inc" },
    { 15039, "Armedia" },
    { 15040, "Global Aeon Pty.Ltd." },
    { 15041, "Poznan University of Technology" },
    { 15042, "vsecure" },
    { 15043, "Jeng-Ye Tech. Enterprise Co.,LTD." },
    { 15044, "Transatel" },
    { 15045, "MoneyAM Ltd" },
    { 15046, "ClickFox, LLC" },
    { 15047, "Java Software Foundry" },
    { 15048, "Startek Engineering, Inc." },
    { 15049, "Seattle Central Community College" },
    { 15050, "Waycom International" },
    { 15051, "Finkle Enterprises" },
    { 15052, "Gemini Technologies Inc." },
    { 15053, "MeriTek Systems, Inc." },
    { 15054, "PASS-K" },
    { 15055, "Ikegami Tsushinki Co., Ltd." },
    { 15056, "anthonyhan.org" },
    { 15057, "MORAVIAPRESS a.s." },
    { 15058, "CEISEC" },
    { 15059, "Baptiste Malguy" },
    { 15060, "Zentic" },
    { 15061, "ServuS A.S" },
    { 15062, "Million Corporation" },
    { 15063, "eko systems inc" },
    { 15064, "MANY sa" },
    { 15065, "Mantas, Inc." },
    { 15066, "James Richardson Enterprises" },
    { 15067, "SMTMS" },
    { 15068, "Beijing CAPE Computer Software Engineering Corp." },
    { 15069, "Elasto Centro" },
    { 15070, "YESComm" },
    { 15071, "Frontier Solution Co., Ltd." },
    { 15072, "HSB Bank AB" },
    { 15073, "Synad Technologies Ltd." },
    { 15074, "Thus Plc." },
    { 15075, "Icom" },
    { 15076, "Fresenius AG" },
    { 15077, "Thermeon Corporation" },
    { 15078, "Sysnet Telematica srl" },
    { 15079, "Remark! Internet Limited" },
    { 15080, "XAIDAT" },
    { 15081, "Screwage, Inc." },
    { 15082, "Carey International, Inc." },
    { 15083, "RentPayment.com" },
    { 15084, "Mobile Radius USA, Inc." },
    { 15085, "AFPA DSIS" },
    { 15086, "Omega-Trin Ltd." },
    { 15087, "projekt13" },
    { 15088, "AdvizeX Technologies LLC" },
    { 15089, "Scientific Systems Company, Inc." },
    { 15090, "teamix GmbH" },
    { 15091, "Boyd Consulting Services, LLC" },
    { 15092, "Perfcap Corpoation" },
    { 15093, "Novartis International AG" },
    { 15094, "Linetec Gmbh" },
    { 15095, "TDC Services A/S" },
    { 15096, "Ag\0303\0250ncia Catalana de Certificaci\0303\0263" },
    { 15097, "SevenSpace" },
    { 15098, "Smithsonian Institution" },
    { 15099, "Loma Linda University" },
    { 15100, "Grupo de Arquitectura y Concurrencia (GAC)" },
    { 15101, "Volt Delta Resources Inc." },
    { 15102, "US LEC" },
    { 15103, "EIVD" },
    { 15104, "ModLink Networks" },
    { 15105, "503 Integrated Systems" },
    { 15106, "Wificom Technologies Ltd" },
    { 15107, "Siraya Inc." },
    { 15108, "Macao Post eSignTrust Certification Authority" },
    { 15109, "Psytechnics" },
    { 15110, "Savantis Systems, Inc." },
    { 15111, "Dennis Eriksson" },
    { 15112, "Whack Productions" },
    { 15113, "MagTek" },
    { 15114, "Stabilizer AB" },
    { 15115, "Obvius LLc" },
    { 15116, "Liberty IT Solutions" },
    { 15117, "Protection One Inc." },
    { 15118, "Westar Energy" },
    { 15119, "Fidelity National Information Solutions" },
    { 15120, "CRCnet Wireless Network" },
    { 15121, "Mentata Systems" },
    { 15122, "Interface Web Hosting" },
    { 15123, "Fachhochschule Oldenburg/Ostfriesland/Wilhelmshaven" },
    { 15124, "Rodan Systems S.A." },
    { 15125, "Vectura" },
    { 15126, sminmpec_unknown },  /* (Added by Wireshark) */
    { 15127, "CUNY/CIS" },
    { 15128, "Vergata EDV-Beratung" },
    { 15129, "E-CARD Ltd." },
    { 15130, "Gens Software Ltd." },
    { 15131, "EDGEACCESS" },
    { 15132, "Six Continents Hotels" },
    { 15133, "Illinois Institute of Technology" },
    { 15134, "Christian Boesch" },
    { 15135, "omatis" },
    { 15136, "Sukumar Patel" },
    { 15137, "ENOVIA" },
    { 15138, "Sim Freaks" },
    { 15139, "LandTime, Inc" },
    { 15140, "YoYoWeb" },
    { 15141, "Infotropic AB" },
    { 15142, "comunicando societ\0303\0240 per azioni" },
    { 15143, "Synergy Business Solutions, Inc." },
    { 15144, "Binary Wave Technologies Inc." },
    { 15145, "iReasoning Networks" },
    { 15146, "M444 Systems, Inc." },
    { 15147, "Hrvatske Autoceste d.o.o (HAC)" },
    { 15148, "Witteveen+Bos" },
    { 15149, "xantury.com" },
    { 15150, "EXOSEC" },
    { 15151, "Spyderworks Ltd" },
    { 15152, "Scholl Engineering" },
    { 15153, "DMSfactory GmbH" },
    { 15154, "ActiVia Networks" },
    { 15155, "IPSQUARE Inc." },
    { 15156, "Accusys" },
    { 15157, "dL_s" },
    { 15158, "SCA" },
    { 15159, "ultraDyne" },
    { 15160, "Interactive Northwest, Inc." },
    { 15161, "Idealab" },
    { 15162, "Movilok Interactividad Movil S.L." },
    { 15163, "NetKingCall Co., LTD." },
    { 15164, "Open Point Networks" },
    { 15165, "NT-SYSTEMS" },
    { 15166, "Brian Bunnell" },
    { 15167, "Chapcom" },
    { 15168, "Vossloh Information Technologies Karlsfeld GmbH" },
    { 15169, "IIZUKA Software Technologies" },
    { 15170, "Crinis Networks" },
    { 15171, "Landmark Graphics Corporation" },
    { 15172, "Supcik.net" },
    { 15173, "Hammerhead Systems" },
    { 15174, "Safescrypt Limited" },
    { 15175, "Lonny Software" },
    { 15176, "Advanced Info Service PLC." },
    { 15177, "ADMtek Incorporated" },
    { 15178, "Axtion Systems Corporation" },
    { 15179, "Seance Software Inc." },
    { 15180, "City of Bloomington, IN" },
    { 15181, "IneoQuest Technologies Inc." },
    { 15182, "ads-tec GmbH" },
    { 15183, "objectlab, llc" },
    { 15184, "ITXC" },
    { 15185, "Phantasia Broadcast Ltd." },
    { 15186, "SolumSTAR" },
    { 15187, "NYS Department of Civil Service" },
    { 15188, "Gemfor s.r.o." },
    { 15189, "objectlab, llc" },
    { 15190, "incNETWORKS, Inc." },
    { 15191, "Voice Print International, Inc." },
    { 15192, "Evergreen Assurance, Inc." },
    { 15193, "Tacit Networks" },
    { 15194, "Alan Flett" },
    { 15195, "privat" },
    { 15196, "Liqwid Networks" },
    { 15197, "HOW CO.,LTD" },
    { 15198, "FNET Co., Ltd" },
    { 15199, "Infologic Nederland B.V." },
    { 15200, "Flexibix Inc." },
    { 15201, "UpSync Software India Private ltd." },
    { 15202, "Oe-Consult Software GmbH" },
    { 15203, "TDC Mobile A/S" },
    { 15204, "Mobilethink A/S" },
    { 15205, "Nordsan Technology Co., Ltd." },
    { 15206, "Visualpix SA" },
    { 15207, "Modul 1" },
    { 15208, "Ombre et Pixel" },
    { 15209, "Precision Therapy International" },
    { 15210, "Shinkuro Inc." },
    { 15211, "North Country Internet Access" },
    { 15212, "ITAU" },
    { 15213, "ITAUSA" },
    { 15214, "Global Network Operations Ltd." },
    { 15215, "Agilejava.com" },
    { 15216, "White Rabbit" },
    { 15217, "AltaVista" },
    { 15218, "KSC Commercial Internet Co.,Ltd." },
    { 15219, "SEVOI Co. Ltd" },
    { 15220, "n.v. QWENTES  s.a." },
    { 15221, "Lorus Inc." },
    { 15222, "Rastar Digital Marketing" },
    { 15223, "Andago" },
    { 15224, "OZTECH" },
    { 15225, "NightStar Corporation" },
    { 15226, "Etronics" },
    { 15227, "Venus Info Tech Inc." },
    { 15228, "Damm Cellular Systems A/S" },
    { 15229, "T-Systems Schweiz AG" },
    { 15230, "SecurIT BV" },
    { 15231, "schulz engineering" },
    { 15232, "COM.BOX Fotofinder GmbH" },
    { 15233, "Regenative Inc." },
    { 15234, "SoftSwitching Technologies" },
    { 15235, "Xpoint Technologies, Inc." },
    { 15236, "R & K Global Business Services, Inc." },
    { 15237, "Intellinger Software Corporation" },
    { 15238, "Collins Enterprises LLC." },
    { 15239, "Applico Security, Inc." },
    { 15240, "AHB Internet Solutions" },
    { 15241, "nimel" },
    { 15242, "ToolCASE LLC" },
    { 15243, "gav-lv" },
    { 15244, "Essential Systems, Inc." },
    { 15245, "INFNIS" },
    { 15246, "EDV Beratung & Netzwerktechnik Dipl.-Ing. Matthias Kahle" },
    { 15247, "Rocksoft Limited" },
    { 15248, "Quantel Ltd" },
    { 15249, "x-cellent technologies GmbH" },
    { 15250, "Morse Group Ltd" },
    { 15251, "Deutsche Telekom T-Com" },
    { 15252, "SB&C, Ltd." },
    { 15253, "Ceyba" },
    { 15254, "Kaseya Sweden AB (formerly 'Intellipool AB')" },
    { 15255, "Reliable Controls Corporation" },
    { 15256, "United Nations" },
    { 15257, "City Computing Limited" },
    { 15258, "Exers Technologies, Inc." },
    { 15259, "Saarl\0303\0244ndischer Rundfunk" },
    { 15260, "Universit\0303\0251 Cahtolique de l'Ouest" },
    { 15261, "UniCon Software GmbH" },
    { 15262, "Data Display Limited." },
    { 15263, "DLRG Landesverband Rheinland-Pfalz" },
    { 15264, "Anonymizer Inc." },
    { 15265, "Telelogic AB" },
    { 15266, "Omnibus Systems Ltd" },
    { 15267, "Damage Prevention Systems" },
    { 15268, "Oy NetItBe Ltd" },
    { 15269, "Craniac Entertainment" },
    { 15270, "Printcafe Software, Inc." },
    { 15271, "Oberfinanzdirektion Koblenz" },
    { 15272, "MaaTec" },
    { 15273, "The Paloma Group, Inc." },
    { 15274, "Paul Scherrer Institut" },
    { 15275, "AAE Systems" },
    { 15276, "BearASP" },
    { 15277, "SoftTree Technologies, Inc." },
    { 15278, "Oblicore Inc." },
    { 15279, "WFI" },
    { 15280, "Relapixity, LLC" },
    { 15281, "ZeOmega Infotect" },
    { 15282, "GCom" },
    { 15283, "Mikroliitti Oy" },
    { 15284, "POSTA SLOVENIJE" },
    { 15285, "iSolv Technologies cc" },
    { 15286, "ADPM" },
    { 15287, "Joachim Bauch (formerly 'FOB Team')" },
    { 15288, "REGISTER.IT S.p.a." },
    { 15289, "Advanced Broadband Communications Center (CCABA-UPC)" },
    { 15290, "Ordway Center for the Performing Arts" },
    { 15291, "Mach Technology, Inc." },
    { 15292, "American City Business Journals" },
    { 15293, "Coderanger inc." },
    { 15294, "EP Imaging Concepts, Inc." },
    { 15295, "Metrima" },
    { 15296, "Plum Financial Service Pty Ltd" },
    { 15297, "Sonera Solutions Oy" },
    { 15298, "Volkswagen Bank GmbH" },
    { 15299, "Elcoteq Network Corporation" },
    { 15300, "Wireless Independent Provider AB" },
    { 15301, "KFKI RMKI SzHK" },
    { 15302, "GalaxE.Solutions, Inc" },
    { 15303, "accelerate IT services" },
    { 15304, "TakeIT" },
    { 15305, "MBUF" },
    { 15306, "Mount Royal College" },
    { 15307, "Esphion Ltd" },
    { 15308, "Peace Software" },
    { 15309, "e-Dynasty Limited" },
    { 15310, "Exodus Communicaitons" },
    { 15311, "misTrust Certification Authority" },
    { 15312, "Jozef Stefan Institute" },
    { 15313, "REDLINK Mediendienste GmbH" },
    { 15314, "IT+ A/S" },
    { 15315, "Internet Business News" },
    { 15316, "Hub Hill Software" },
    { 15317, "Wells Fargo" },
    { 15318, "Edu4 France S.A." },
    { 15319, "SkyPilot Network, Inc." },
    { 15320, "Custom7" },
    { 15321, "Transcor, Inc" },
    { 15322, "Echopass Corporation" },
    { 15323, "INP-net" },
    { 15324, "Walter E. Helmke Library" },
    { 15325, "STVA" },
    { 15326, "Mobicus Oy" },
    { 15327, "Halden Dataservice AS" },
    { 15328, "Svanberg Consulting" },
    { 15329, "Dalian University of Technology" },
    { 15330, "KLEEGROUP" },
    { 15331, "Indagon Oy" },
    { 15332, "Logica UK Ltd" },
    { 15333, "Global Communication Technologies,Inc." },
    { 15334, "MWVCAA" },
    { 15335, "ITXC" },
    { 15336, "Telemet America, Inc" },
    { 15337, "Photronics, Inc." },
    { 15338, "PalmSource, Inc" },
    { 15339, "ilse media groep b.v." },
    { 15340, "George Furniture" },
    { 15341, "Wuhan Yangtze Communications Industry Group Co.,Ltd.,China." },
    { 15342, "Vitalect Technologies India Pvt. Ltd." },
    { 15343, "FUNDACION INASMET" },
    { 15344, "Yomi PLC." },
    { 15345, "Dansk R\0303\0270de Kors" },
    { 15346, "Viking Systems" },
    { 15347, "IGH Ingenieurgesellschaft H\0303\0266pfner mbH" },
    { 15348, "Precision Interop, LLC" },
    { 15349, "Andreas Bartsch IT Solutions" },
    { 15350, "Jatosoft LLC" },
    { 15351, "ForeverLiving.com" },
    { 15352, "University of Arkansas at Fort Smith" },
    { 15353, "Integrated Digital Solutions Inc." },
    { 15354, "Number 1 Customer, LLC" },
    { 15355, "Integan" },
    { 15356, "BartNET" },
    { 15357, "Diversified Systems Resources, LTD" },
    { 15358, "Cygnetron, Inc." },
    { 15359, "Multidas Technologies, Inc." },
    { 15360, "CENTRE DE SANTE MENTALE" },
    { 15361, "RPA Research Co., Ltd." },
    { 15362, "Digital on net Co., Ltd." },
    { 15363, "Hotel Interski ****" },
    { 15364, "Sibsnet Technologies" },
    { 15365, "INFOSTEP" },
    { 15366, "Dunhuang Academy" },
    { 15367, "ZlanTec" },
    { 15368, "UnixAG Siegen" },
    { 15369, "Cititech Australia" },
    { 15370, "GIGA-BYTE TECHNOLOGY CO., LTD" },
    { 15371, "Horry Telephone Cooperative" },
    { 15372, "Max-Planck-Institute for evolutionary Anthropology" },
    { 15373, "NASK" },
    { 15374, "Enfo Oy" },
    { 15375, "HSB Systemhaus GmbH" },
    { 15376, "De Nayer" },
    { 15377, "ChiliMoon Foundation" },
    { 15378, "CSI Piemonte" },
    { 15379, "Allocity" },
    { 15380, "AlterPoint, Inc." },
    { 15381, "Wilkes University" },
    { 15382, "Bit Hosting" },
    { 15383, "BlueJavelin, Inc." },
    { 15384, "NCARP.COM" },
    { 15385, "Genasys II Spain" },
    { 15386, "Ibis Tecnologia e Informacao" },
    { 15387, "Industri Telekomunikasi Indonesia (INTI)" },
    { 15388, "MagiNet Company, Ltd." },
    { 15389, "Bestway Telecom" },
    { 15390, "Silu co." },
    { 15391, "iei" },
    { 15392, "OLVIKO" },
    { 15393, "AvestaPolarit AB" },
    { 15394, "P.T Sigma Cipta Caraka" },
    { 15395, "CrossML" },
    { 15396, "Alfa & Ariss b.v." },
    { 15397, "Netintact AB" },
    { 15398, "IC3S AG" },
    { 15399, "Universite de Poitiers" },
    { 15400, "Post Consult International" },
    { 15401, "EUnet EDV und Internet Dienstleistungs AG" },
    { 15402, "Proximity Corp" },
    { 15403, "T-Systems CDS GmbH" },
    { 15404, "PenTeleData Inc" },
    { 15405, "Comunicaciones NetPeople C.A." },
    { 15406, "Axiom Integration, Inc." },
    { 15407, "Ambicom, Inc." },
    { 15408, "TrueContext Inc." },
    { 15409, "Customized Database Systems" },
    { 15410, "Seaway Networks" },
    { 15411, "Lasipalatsin Mediakeskus Oy" },
    { 15412, "Cotagesoft Inc." },
    { 15413, "Oden Oden Wireless Networks Technology (Shanghai) Ltd" },
    { 15414, "BillHusler.com" },
    { 15415, "Openet Information Technology (Shenzhen) Co.,Ltd" },
    { 15416, "Saft Power Systems" },
    { 15417, "IMA - Informatica de Municipios Associados" },
    { 15418, "Forum Systems Inc." },
    { 15419, "Forest Siding Supply" },
    { 15420, "Lightsurf Technologies" },
    { 15421, "Chiemgau Gymnasium Traunstein" },
    { 15422, "ARTIFintelligence, LLC" },
    { 15423, "NetSpace - Solu\0303\0247\0303\0265es Inform\0303\0241ticas" },
    { 15424, "Storeimage Programs Inc." },
    { 15425, "ImageStream Internet Solutions" },
    { 15426, "Korea Internet Data Center" },
    { 15427, "Hwa-jin Seo" },
    { 15428, "Cybertec Pty Ltd" },
    { 15429, "Future Computing Solutions India Pvt. Ltd." },
    { 15430, "JIN Information Systems" },
    { 15431, "Xion IT Systems AG" },
    { 15432, "Cybcon Industries" },
    { 15433, "Landespolizei Mecklenburg- Vorpommern" },
    { 15434, "Chebucto Community Net" },
    { 15435, "worldnet21" },
    { 15436, "OsiTools" },
    { 15437, "SSO" },
    { 15438, "RTL Television" },
    { 15439, "PASS Technologie" },
    { 15440, "ZPH Litex" },
    { 15441, "Karell" },
    { 15442, "Orchestel Systems" },
    { 15443, "JP Sync" },
    { 15444, "Saffron Solutions, Inc" },
    { 15445, "SBS" },
    { 15446, "CyberPower Systems, Inc." },
    { 15447, "SEM Ltd" },
    { 15448, "DAMOVO Ceska Republika" },
    { 15449, "Foursys, Inc." },
    { 15450, "Innominate Security Technologies AG" },
    { 15451, "Realitatea TV" },
    { 15452, "Geovariances" },
    { 15453, "ABZ Nederland" },
    { 15454, "Arbor AudioCommunications" },
    { 15455, "Unassigned" },
    { 15456, "La cocina" },
    { 15457, "Ackernet" },
    { 15458, "Mark McKenzie" },
    { 15459, "M-Systems" },
    { 15460, "Orchestel Systems" },
    { 15461, "Corybant" },
    { 15462, "Rupprecht & Patashnick Co., Inc." },
    { 15463, "Huron Superior Catholic District School Board" },
    { 15464, "Muskoka.com" },
    { 15465, "University of Toronto" },
    { 15466, "Peacefulhaven" },
    { 15467, "Digibel" },
    { 15468, "Siege.org" },
    { 15469, "Internet Connection" },
    { 15470, "Digital System Resources" },
    { 15471, "Nucleo de Pesquisa em Redes e Sistemas Abertos" },
    { 15472, "SOA Software, Inc." },
    { 15473, "Spring Worth Inc." },
    { 15474, "Lighthouse Software Group" },
    { 15475, "Zhongguang Telecommunications" },
    { 15476, "Fareastone telecommunication Corp." },
    { 15477, "Bank for foreign trade" },
    { 15478, "H\0303\0266ft & Wessel AG" },
    { 15479, "dudley.org" },
    { 15480, "Trillion Digital Communications" },
    { 15481, "Capital Channel Information Co. Ltd." },
    { 15482, "Tian En" },
    { 15483, "O.C.A. S.A." },
    { 15484, "Lux Technologies" },
    { 15485, "University of Otago" },
    { 15486, "keyon" },
    { 15487, "Daisy Technologies Inc." },
    { 15488, "Pure Matrix, Inc." },
    { 15489, "Home SE AB" },
    { 15490, "Prasanna Technologies" },
    { 15491, "Protegrity Inc." },
    { 15492, "Sichuan Changhong Electric Group Co,Ltd." },
    { 15493, "Goll Enterprises" },
    { 15494, "Helium LLC" },
    { 15495, "eHouse" },
    { 15496, "LaScoala" },
    { 15497, "IronPort Systems, Inc." },
    { 15498, "TESI S.p.A" },
    { 15499, "The King's University College" },
    { 15500, "eWings Technologies, Inc." },
    { 15501, "M&C Laboratory Inc." },
    { 15502, "Animezone" },
    { 15503, "University of Berne" },
    { 15504, "Minist\0303\0250re de l'\0303\0251quipement, des transports, du logement, du tourisme et de la mer" },
    { 15505, "Echoworx Corporation" },
    { 15506, "Akiratech Limited" },
    { 15507, "TierOne OSS Technologies, Inc." },
    { 15508, "PacketIQ Corp." },
    { 15509, "direto.org.br" },
    { 15510, "Rhetorical Systems, Ltd." },
    { 15511, "Groupe ERMEWA S.A." },
    { 15512, "COMAX INC." },
    { 15513, "Gendac" },
    { 15514, "Financijska agencija" },
    { 15515, "DGET" },
    { 15516, "SoftWorks Australia Pty Ltd" },
    { 15517, "Entri ltd" },
    { 15518, "Vocalocity, Inc." },
    { 15519, "Results Computing Corporation" },
    { 15520, "actiSwitch, Inc." },
    { 15521, "signalkontor GmbH" },
    { 15522, "Whitman College" },
    { 15523, "Equine.com" },
    { 15524, "Access Point Inc" },
    { 15525, "Braum's Ice Cream" },
    { 15526, "Mixmobile" },
    { 15527, "ANIENIB" },
    { 15528, "Naviair" },
    { 15529, "Universidad del Valle" },
    { 15530, "Integrated Technology S.C." },
    { 15531, "VPNChina Tech-Development Corp." },
    { 15532, "hollomey consultants gmbh" },
    { 15533, "Mobile Tornado" },
    { 15534, "Linup Front GmbH" },
    { 15535, "Vereniging Milieudefensie" },
    { 15536, "PTM.com" },
    { 15537, "EMK Design" },
    { 15538, "ASIGRA Inc." },
    { 15539, "Media 4 Sp. z o.o." },
    { 15540, "AM Corporation" },
    { 15541, "RH Ministarstvo gospodarstva" },
    { 15542, "EMK Design" },
    { 15543, "Illinois Power Company" },
    { 15544, "American Mensa, Ltd." },
    { 15545, "Probix" },
    { 15546, "eleven.am" },
    { 15547, "Onaras AG" },
    { 15548, "Pillar Data Systems" },
    { 15549, "XCache Technologies, Inc." },
    { 15550, "La Sierra University" },
    { 15551, "Object Engineering GmbH" },
    { 15552, "Statmon Technologies Corp." },
    { 15553, "SnarlSNMP Dynamic Web Application Monitor Developers Group" },
    { 15554, "Democratic National Committee" },
    { 15555, "Gold Coast City Council" },
    { 15556, "Chuq Yang" },
    { 15557, "Inflection Technologies" },
    { 15558, "Institute of Chemical Process Fundamentals" },
    { 15559, "Orionet" },
    { 15560, "Yanfa" },
    { 15561, "Coleman Family Camps" },
    { 15562, "mbrace.org" },
    { 15563, "Adtron" },
    { 15564, "Aselia Technologies, Inc." },
    { 15565, "Great Plains Mall.net" },
    { 15566, "Experian Japan Co., Ltd (formerly 'A-Care Systems, Inc.')" },
    { 15567, "Neople Ltd." },
    { 15568, "Center for Development of Information Technology - CDIT" },
    { 15569, "Krasnoyarsk ICC subdivision of MCC, JSC \"Russian Railways\"" },
    { 15570, "Bayerische Landesbank" },
    { 15571, "Schuler Electronics" },
    { 15572, "Tcom&dtvro" },
    { 15573, "Apertio Ltd" },
    { 15574, "E-milio Internet Services, S.L." },
    { 15575, "Chimes, Inc." },
    { 15576, "Pompoen B.V" },
    { 15577, "AirPrism" },
    { 15578, "DeepRoot Linux" },
    { 15579, "Saeson Telecom co., ltd" },
    { 15580, "VNIINS" },
    { 15581, "Telemed Communications Services GmbH" },
    { 15582, "Xtradyne Technologies AG" },
    { 15583, "EUREG" },
    { 15584, "de Werknaam" },
    { 15585, "Northern Light Technology" },
    { 15586, "Response Mechanics, Inc." },
    { 15587, "Humboldt State University" },
    { 15588, "WetWebMedia" },
    { 15589, "IntiGate Inc." },
    { 15590, "Catboy Technologies" },
    { 15591, "Alex Shepard" },
    { 15592, "Viking Telecom" },
    { 15593, "Kore Systems GmbH" },
    { 15594, "Causeway Technologies" },
    { 15595, "MEAG MUNICH ERGO AssetManagement GmbH" },
    { 15596, "SONORK S.R.L." },
    { 15597, "Avamar" },
    { 15598, "Compro Technologies, Inc." },
    { 15599, "Groom Lake Laboratories" },
    { 15600, "Xeta Technologies" },
    { 15601, "Velocity Software" },
    { 15602, "lottasophie.de" },
    { 15603, "Sunhillo Corporation" },
    { 15604, "Kuopio Telephone PLC" },
    { 15605, "Gray Laboratories, Inc." },
    { 15606, "TopPioneer Technologies Limited" },
    { 15607, "Encentuate, Inc." },
    { 15608, "Anders & Rodewyk" },
    { 15609, "Iskon Internet d.d." },
    { 15610, "Herbert Retail Ltd." },
    { 15611, "MIC Electronics Limited" },
    { 15612, "SoftWare Services" },
    { 15613, "gen-i limited" },
    { 15614, "Rick Bauman Consulting" },
    { 15615, "kma, inc." },
    { 15616, "Dullroar Enterprises" },
    { 15617, "newlimits" },
    { 15618, "Adrenalize, Inc." },
    { 15619, "Delean Vision" },
    { 15620, "Ceiva Logic" },
    { 15621, "ZP Technologies" },
    { 15622, "APTARE" },
    { 15623, "Bachblue Pty Ltd t/a AFOYI" },
    { 15624, "Skopeo LLC" },
    { 15625, "Excedent Technologies" },
    { 15626, "Campus Crusade Asia Ltd" },
    { 15627, "Spezifikum" },
    { 15628, "LAMARC GmbH" },
    { 15629, "IQSoft Rt" },
    { 15630, "InfoGuard HB" },
    { 15631, "Vivista Limited" },
    { 15632, "prime factory Gmbh & Co KG" },
    { 15633, "Tonisoft" },
    { 15634, "d3.net internet - technologien gmbh" },
    { 15635, "China PKI" },
    { 15636, "Althea Technical" },
    { 15637, "Spinlock Network LLC" },
    { 15638, "commissaire.net" },
    { 15639, "e-solutions, lda" },
    { 15640, "Clear Technology, Inc." },
    { 15641, "Masobit SRL" },
    { 15642, "Transplace, Inc." },
    { 15643, "Hallway Software Design Corp." },
    { 15644, "Brenda Bell" },
    { 15645, "pixell daten & design GmbH" },
    { 15646, "Pjusarafelag Islands" },
    { 15647, "thesysadmin" },
    { 15648, "Atlantis Services" },
    { 15649, "VOSGAMES" },
    { 15650, "Citrenesys Corporation" },
    { 15651, "Seventh Moon Co., Ltd." },
    { 15652, "SHE Informationssysteme AG" },
    { 15653, "Intesys" },
    { 15654, "Max Momentum" },
    { 15655, "SITADELLE" },
    { 15656, "Computer Park Ltd" },
    { 15657, "Macrocall" },
    { 15658, "Fillmore Labs" },
    { 15659, "Alaska Airlines" },
    { 15660, "TLM Software" },
    { 15661, "0x2.net" },
    { 15662, "fumph.com" },
    { 15663, "Aswan Co. Ltd." },
    { 15664, "Aractel Networks Ltd" },
    { 15665, "Eastern Communication Technology Development CO.LTD" },
    { 15666, "orgatech Ulrich Tiemann GmbH" },
    { 15667, "Lechner-Rau Haustechnik" },
    { 15668, "ZHONGFANG Information Co.,Ltd" },
    { 15669, "Lifecycle Software" },
    { 15670, "The Internet Marketing Center" },
    { 15671, "Wardega Consulting" },
    { 15672, "Javno preduzece \"Posta Srbije\" (formerly 'Javno preduzece PTT saobracaja \"Srbija\"')" },
    { 15673, "Codeangels Solutions" },
    { 15674, "Valente CC" },
    { 15675, "StoneDonut, LLC" },
    { 15676, "baede" },
    { 15677, "Thomson-Thomson" },
    { 15678, "Software Projects Pty Ltd" },
    { 15679, "Cape Com Inc" },
    { 15680, "Digirati" },
    { 15681, "ROSCO Associates Technology Staffing Ltd." },
    { 15682, "pkiclue.com, Inc." },
    { 15683, "Acrosonic Corporation" },
    { 15684, "Macro Technology" },
    { 15685, "agala.net" },
    { 15686, "Mei Communication Co." },
    { 15687, "Magic Software Enterprises Ltd." },
    { 15688, "Practical Labs" },
    { 15689, "Heinz Family Germany" },
    { 15690, "LIISP" },
    { 15691, "NetPower Solutions" },
    { 15692, "Minnigerode" },
    { 15693, "IonIdea" },
    { 15694, "Silicom" },
    { 15695, "A. Pomerantz & Company" },
    { 15696, "Bayer AG" },
    { 15697, "Cellon Inc" },
    { 15698, "NLoci" },
    { 15699, "Renesys Corporation" },
    { 15700, "Henrici IT-Consulting" },
    { 15701, "Schmut" },
    { 15702, "Computer Image Technology" },
    { 15703, "Software Diversified Services" },
    { 15704, "Cyan Worlds, Inc." },
    { 15705, "Multitalents" },
    { 15706, "IGLOO SECURITY, Inc." },
    { 15707, "silve.net" },
    { 15708, "Beijing Westman Automation Ltd. Co." },
    { 15709, "CBOSS" },
    { 15710, "Megasoft" },
    { 15711, "Euro DB" },
    { 15712, "Taringold Ltd." },
    { 15713, "Drinsama GmbH" },
    { 15714, "Lenel Systems International, Inc." },
    { 15715, "Blue Tree Systems" },
    { 15716, "gogo6 (formerly 'Hexago')" },
    { 15717, "Cegetel Net" },
    { 15718, "Loyalty Management Group Canada, Inc." },
    { 15719, "Mass College of Liberal Arts" },
    { 15720, "binaryMedia" },
    { 15721, "7COMm" },
    { 15722, "Concare" },
    { 15723, "Holoscenes.com" },
    { 15724, "VisionBank Corp." },
    { 15725, "ZyFLEX Technologies, Inc." },
    { 15726, "Klug GmbH integrierte Systeme" },
    { 15727, "hofen.org" },
    { 15728, "Sentry Information and Alert Systems Corp" },
    { 15729, "SyTrust GmbH" },
    { 15730, "Lulu Enterprises, Inc." },
    { 15731, "EasyPax Inc." },
    { 15732, "ZIV Aplicaciones y Tecnolog\0303\0255a S.A. (formerly 'uSysCom')" },
    { 15733, "Washington State University" },
    { 15734, "AION Systems" },
    { 15735, "Secure Technology Hawaii" },
    { 15736, "Emergepoint" },
    { 15737, "Zozoa Inc" },
    { 15738, "Business Network Communications" },
    { 15739, "Ruzz Technology Pty Ltd" },
    { 15740, "Digital Vision Technology Ltd" },
    { 15741, "Softerra, LLC" },
    { 15742, "DiskSites Ltd." },
    { 15743, "VTL (UK) Ltd" },
    { 15744, "NetRatings, Inc." },
    { 15745, "Schoren NMS Solutions" },
    { 15746, "ZONER software, s.r.o." },
    { 15747, "Locus Portal Corporation" },
    { 15748, "NetGhost Communications" },
    { 15749, "Ingersoll-Rand Co Inc" },
    { 15750, "University of Troms\0303\0270" },
    { 15751, "TRC Fiord, JSC" },
    { 15752, "slamb.org" },
    { 15753, "APPServer" },
    { 15754, "Vancouver Community Network" },
    { 15755, "PIVoD Technologies" },
    { 15756, "Wistron NeWeb Corporation" },
    { 15757, "MITSUBISHI ELECTRIC INFORMATION TECHNOLOGY CORPORATION(MDIT)" },
    { 15758, "suntek beijingyanjiuyuan" },
    { 15759, "Greener Pastures Innovations" },
    { 15760, "NMSWorks  Software Limited" },
    { 15761, "ATS Elektronik GmbH" },
    { 15762, "Khety" },
    { 15763, "Lagan" },
    { 15764, "REPSOL YPF, S.A." },
    { 15765, "JX Solutions Ltd." },
    { 15766, "Matrix Mailing, LLC" },
    { 15767, "Triblen" },
    { 15768, "Ericsson Inc. (formerly 'BelAir Networks')" },
    { 15769, "Argecy Computer Corporation" },
    { 15770, "Zeera Networks, Inc." },
    { 15771, "JF Possibilities" },
    { 15772, "Fachhochschule Landshut" },
    { 15773, "e-BS, a.s." },
    { 15774, "DesigNET, INC." },
    { 15775, "HEIDENHAIN" },
    { 15776, "Advanced Data Integration" },
    { 15777, "Openin" },
    { 15778, "DaxNetwork" },
    { 15779, "Novel TongFang" },
    { 15780, "Kiloutou" },
    { 15781, "TRANSFLOW Informationslogistik GmbH" },
    { 15782, "VIA MAT MANAGEMENT AG" },
    { 15783, "HRsmart, Inc" },
    { 15784, "ELB Consulting" },
    { 15785, "Montrusco Bolton Investments Inc." },
    { 15786, "NetLedger, Inc." },
    { 15787, "DGN Service GmbH" },
    { 15788, "The Elders of the Universe" },
    { 15789, "Infineon Technologies AG" },
    { 15790, "Wideray Corporation" },
    { 15791, "La Canada Wireless Association" },
    { 15792, "Interlink Group Incorporated" },
    { 15793, "Pittig Software & Internet Services" },
    { 15794, "DeGeorge Family" },
    { 15795, "Vandelay Internet Services, Inc." },
    { 15796, "ImageONE Co., Ltd." },
    { 15797, "Infosys Technologies Limited" },
    { 15798, "Rato International Communication Co" },
    { 15799, "Cesky Mobil a.s." },
    { 15800, "JN Data A/S" },
    { 15801, "Huitsing Embedded Systems" },
    { 15802, "Farlep" },
    { 15803, "mercatis information systems gmbh" },
    { 15804, "DLR SISTEC" },
    { 15805, "Sweetheart Cup Company, Inc." },
    { 15806, "ConnecTalk Inc." },
    { 15807, "DGN Service GmbH" },
    { 15808, "DGN Service GmbH" },
    { 15809, "WNET ISP" },
    { 15810, "Bank Severnaya Kazna OAO" },
    { 15811, "Digital Control, LLC" },
    { 15812, "Radical Corporation" },
    { 15813, "AIS.PL" },
    { 15814, "Applied Concepts" },
    { 15815, "NetQA" },
    { 15816, "Infra 911, Inc." },
    { 15817, "Falcon System Consulting, Inc." },
    { 15818, "Stadt Braunschweig" },
    { 15819, "Cryptolog International" },
    { 15820, "CASTOR Informatique" },
    { 15821, "FreeBSD-CN Project" },
    { 15822, "I-ST.net GmbH" },
    { 15823, "LinuxWithin.com" },
    { 15824, "InaSoft" },
    { 15825, "ClearMetrix, Inc." },
    { 15826, "Cryptek, Incorporated" },
    { 15827, "Crocker Communications, Inc." },
    { 15828, "H3G Italia S.p.A. - Enterprise C.A." },
    { 15829, "DIGITAL PRODUCTION SARL" },
    { 15830, "Robinlea" },
    { 15831, "DENSO IT LABORATORY, INC." },
    { 15832, "BT Ignite solutions" },
    { 15833, "SIGEC" },
    { 15834, "Tigard-Tualatin School District" },
    { 15835, "M&S Systems" },
    { 15836, "Marcor Associates, Ltd." },
    { 15837, "Investment Technology Group" },
    { 15838, "AKA" },
    { 15839, "The E.W. Scripps Company" },
    { 15840, "GEIDAX" },
    { 15841, "Daniel Ritter" },
    { 15842, "Blasberg-Computer-Systeme GmbH" },
    { 15843, "Massenbach" },
    { 15844, "SELEX Communications S.p.A." },
    { 15845, "DixPER Systems" },
    { 15846, "IP Fabrics" },
    { 15847, "Harvard Law School" },
    { 15848, "Sensorsoft Corporation" },
    { 15849, "Evans Companies" },
    { 15850, "ReShape" },
    { 15851, "Computerized Medical Systems" },
    { 15852, "Legion Interactive" },
    { 15853, "Computer Center, Hitotsubashi university" },
    { 15854, "RIPE NCC" },
    { 15855, "Lule\0303\0245 Segels\0303\0244llskap" },
    { 15856, "Open Power Network, R.Sch\0303\0244r" },
    { 15857, "Administracion del Principado de Asturias" },
    { 15858, "all-in-green.com GmbH" },
    { 15859, "City of Tampere" },
    { 15860, "ParTec" },
    { 15861, "KiNETiK GmbH" },
    { 15862, "BankService Plc." },
    { 15863, "Innovative Navigation" },
    { 15864, "Unicity Pty. Ltd." },
    { 15865, "cab Produkttechnik GmbH & Co KG" },
    { 15866, "Joe Rhodes Consulting LLC" },
    { 15867, "IXI Mobile (R&D) Ltd." },
    { 15868, "Cybris Network Information Systems" },
    { 15869, "Tijd Beursmedia" },
    { 15870, "Egon Technologies" },
    { 15871, "Omnilux" },
    { 15872, "IT Merge Inc." },
    { 15873, "Guardian Life Insurance Inc" },
    { 15874, "MDS Proteomics A/S" },
    { 15875, "M-PLIFY S.A." },
    { 15876, "Microprogram Information LD. CO." },
    { 15877, "API Technologies, LLC" },
    { 15878, "AZTECH SYSTEMS LTD" },
    { 15879, "WaveIP Ltd." },
    { 15880, "MONEYLINE BANKING SYSTEMS" },
    { 15881, "Thomas Fahle" },
    { 15882, "smart ip" },
    { 15883, "Getronics France" },
    { 15884, "Noble Turkey Software" },
    { 15885, "ESAG Energieversorgung Sachsen Ost AG" },
    { 15886, "Manhattan Associates" },
    { 15887, "Cosini Networks, Inc" },
    { 15888, "TAI S.r.l." },
    { 15889, "Q-Free ASA" },
    { 15890, "Prairie Grove Telephone Co." },
    { 15891, "Panda Restaurant Group, Inc." },
    { 15892, "Openmodes Technology Group Inc." },
    { 15893, "Emerson Climate Technologies Retail Solutions, Inc. (formerly 'Computer Process Controls')" },
    { 15894, "AstroStage Inc." },
    { 15895, "4Linux" },
    { 15896, "Southern Federal University (formerly 'Rostov State University, Computer Center')" },
    { 15897, "Guangzhou GaoU S & T Development Co. Ltd." },
    { 15898, "Polizei Brandenburg" },
    { 15899, "inubit" },
    { 15900, "OpenWeb" },
    { 15901, "Valsimmon Technology Group" },
    { 15902, "MEN@NET" },
    { 15903, "Seebek Ingenier\0303\0255a S.R.L." },
    { 15904, "Peter Eckel, System and Network Management" },
    { 15905, "Defero Systems AB" },
    { 15906, "WLAN AG" },
    { 15907, "Canyon Networks" },
    { 15908, "Business Technology Associates, Inc." },
    { 15909, "MRX Solutions" },
    { 15910, "AutoTrader.com" },
    { 15911, "he chuan" },
    { 15912, "BlueCom AS" },
    { 15913, "Networking Support Services" },
    { 15914, "Netreo Incorporated" },
    { 15915, "High Tower Software" },
    { 15916, "LANDesk Software" },
    { 15917, "Expedient Communications" },
    { 15918, "the MORROW group" },
    { 15919, "Hitachi Storage Software Incorporated" },
    { 15920, "Switch Management" },
    { 15921, "MobileAccess" },
    { 15922, "YISHANG INNOVATION TECHNOLOGY CO.,LTD" },
    { 15923, "ICS GmbH" },
    { 15924, "Kuwait Linux Company" },
    { 15925, "Cadence Design Systems" },
    { 15926, "Cartier Partners Financial Group Inc." },
    { 15927, "Point Loma Nazarene University" },
    { 15928, "SNB" },
    { 15929, "Cambodia Samart Communication" },
    { 15930, "Lucasfilm Ltd." },
    { 15931, "Center for International Rehabilitation" },
    { 15932, "Wuertele" },
    { 15933, "Cyanea Systems Corp." },
    { 15934, "Multip Kft." },
    { 15935, "Centerplex" },
    { 15936, "Koreadotcom" },
    { 15937, "Svyazinform of Republic Mordovia Joint Stock Company" },
    { 15938, "JOINT-STOCK COMPANY IMPORT-EXPORT BANK \"IMPEXBANK\" , Moscow" },
    { 15939, "Coral Telecom Ltd" },
    { 15940, "Factoria de iniciativas internet fi2, s.a" },
    { 15941, "Galena Park ISD" },
    { 15942, "Cabildo de Gran Canaria" },
    { 15943, "CONEXUS Credit Union" },
    { 15944, "Agence de la Francophonie" },
    { 15945, "Ascertia" },
    { 15946, "Calypso Networks" },
    { 15947, "New Jersey Institute of Technology" },
    { 15948, "TREVSPLACE.COM" },
    { 15949, "F\0303\0241brica de Id\0303\0251ias" },
    { 15950, "4am Media, Inc." },
    { 15951, "Axent Global" },
    { 15952, "Advanced Computer Resources" },
    { 15953, "Aaron Spangler" },
    { 15954, "Filesure Pte Ltd" },
    { 15955, "OmniComp Technology Services" },
    { 15956, "InCore Technology Ltd" },
    { 15957, "Muonics, Inc." },
    { 15958, "TREVSPLACE.COM" },
    { 15959, "Sue's Sound cc" },
    { 15960, "eAirports" },
    { 15961, "Cocking and Co. Ltd." },
    { 15962, "ASML" },
    { 15963, "INFORMA COLOMBIA" },
    { 15964, "Instituto Nacional de Astrof\0303\0255sica, Optica y Electr\0303\0263nica" },
    { 15965, "Public Resources Management Group, Inc." },
    { 15966, "Visa, International." },
    { 15967, "NCast Corporation" },
    { 15968, "Emico Vero" },
    { 15969, "Vindigo, Inc." },
    { 15970, "Aspen Networks Inc" },
    { 15971, "Advanced Biometric Controls, LLC" },
    { 15972, "Disaster Kleenup International, Inc" },
    { 15973, "JCorporate Ltd" },
    { 15974, "Skywave Corporation" },
    { 15975, "MEIKYO ELECTRIC CO.,LTD." },
    { 15976, "Adacom S.A." },
    { 15977, "ComPol II" },
    { 15978, "IT=it" },
    { 15979, "Tomsoft" },
    { 15980, "TrackWell Software hf" },
    { 15981, "Anillo Networks, Inc." },
    { 15982, "Hubbub IT Services" },
    { 15983, "Meru Networks" },
    { 15984, "Authenex, Inc." },
    { 15985, "The University of Lethbridge" },
    { 15986, "Binara, Inc." },
    { 15987, "Topoz Pty Ltd" },
    { 15988, "Cymes GmbH" },
    { 15989, "Torsten Schneider" },
    { 15990, "x9 (formerly 'MikroBitti')" },
    { 15991, "Raso" },
    { 15992, "Tracerdigital, LLC" },
    { 15993, "Net-Scale Technologies, Inc." },
    { 15994, "XCOM Comunicacao Segura" },
    { 15995, "it consultant Henning Follmann" },
    { 15996, "RNP Rede Nacional de Ensino e Pesquisa" },
    { 15997, "Wave Systems Corp." },
    { 15998, "University of Glamorgan" },
    { 15999, "CPS Technology Group" },
    { 16000, "Syrea s.r.l." },
    { 16001, "Ministry of Finance, Czech Republic" },
    { 16002, "Glyphix" },
    { 16003, "Zschimmer GmbH" },
    { 16004, "Intrusec, Inc." },
    { 16005, "Durham University" },
    { 16006, "CodeFab Inc" },
    { 16007, "Native Instruments" },
    { 16008, "Consolidated Communications Inc" },
    { 16009, "TelemaxX Telekommunikation GmbH" },
    { 16010, "Kapsch BusinessCom AG" },
    { 16011, "State of Utah DAS/ITS" },
    { 16012, "MEMSCAP" },
    { 16013, "byteCentric" },
    { 16014, "Applied Materials Inc." },
    { 16015, "Primary Objective, LLC" },
    { 16016, "Simmey Limited" },
    { 16017, "CEW Co Ltd" },
    { 16018, "punker.org" },
    { 16019, "Reitek" },
    { 16020, "Wasadata System AB" },
    { 16021, "cassava Enterprises" },
    { 16022, "Minicom Advanced Systems Ltd." },
    { 16023, "inetadmin" },
    { 16024, "Netzwert Aktiengesellschaft" },
    { 16025, "CIBLIS Engenharia S/C" },
    { 16026, "SoftAplic S/C Ltda." },
    { 16027, "Shah-USA" },
    { 16028, "XAOS Systems" },
    { 16029, "Westleader International Inc." },
    { 16030, "Hongkong Post" },
    { 16031, "Atmark Techno, Inc." },
    { 16032, "Uraltransbank" },
    { 16033, "Telemic Oy" },
    { 16034, "Opus Hadsel" },
    { 16035, "Icom Mobile" },
    { 16036, "InfoCentre Ltd." },
    { 16037, "em|Motion GmbH" },
    { 16038, "ORAYLIS GmbH" },
    { 16039, "Automated Systems Engineering, Inc." },
    { 16040, "dataparty.net" },
    { 16041, "Hogeschool Brabant" },
    { 16042, "JMP SYSTEMS" },
    { 16043, "Viasec, s.r.o." },
    { 16044, "todo Gesellschaft fuer Informationstechnik mbH" },
    { 16045, "Ocaco Finland Oy" },
    { 16046, "DSD S.A." },
    { 16047, "IT Practice" },
    { 16048, "BOFRIIS" },
    { 16049, "Flamenco Networks, Inc." },
    { 16050, "Krupczak Org" },
    { 16051, "CORETEAM AB" },
    { 16052, "Chris Rauschuber" },
    { 16053, "Burger King Corporation" },
    { 16054, "Resource Data Management Ltd" },
    { 16055, "Blandsite" },
    { 16056, "okazaki city office" },
    { 16057, "EventGnosis, Inc." },
    { 16058, "GENKEY" },
    { 16059, "Tsinghua TongFang Software Co. Ltd." },
    { 16060, "Lighthouse Information Systems, Inc." },
    { 16061, "Adhersis North America" },
    { 16062, "ZINCNetworks" },
    { 16063, "DC Technologies" },
    { 16064, "Perspectix AG" },
    { 16065, "softArk Solutions" },
    { 16066, "NEC Telenetworx,Ltd" },
    { 16067, "BarcoIntelligentDisplays" },
    { 16068, "Repeatit AB" },
    { 16069, "MINEFI/SP" },
    { 16070, "Bundesamt f\0303\0274r Finanzen" },
    { 16071, "Pictet & Cie, Banquiers" },
    { 16072, "Linkeo.com" },
    { 16073, "Edith Cowan University" },
    { 16074, "VBL Karlsruhe" },
    { 16075, "Uninet, S.A." },
    { 16076, "Dominion Diagnostics" },
    { 16077, "Witbe" },
    { 16078, "Mouvement R\0303\0251publicain et Citoyen" },
    { 16079, "bitMaster" },
    { 16080, "Software Logistics, LLC" },
    { 16081, "KTALAND" },
    { 16082, "Bechtel Corporation" },
    { 16083, "MaineBase" },
    { 16084, "House of Noise" },
    { 16085, "Telexpertise de Mexico S.A. de C.V." },
    { 16086, "MITSUMI ELECTRIC CO.,LTD" },
    { 16087, "Zayed University" },
    { 16088, "Groats Laboratories" },
    { 16089, "eXwavecom Co.,Ltd." },
    { 16090, "Estweb Ltd." },
    { 16091, "ECR" },
    { 16092, "AirWalk Communications, Inc." },
    { 16093, "AW Software" },
    { 16094, "Stacken" },
    { 16095, "Fluency Voice Technology Ltd." },
    { 16096, "RCS-TECHNOLOGY" },
    { 16097, "voice robots GmbH" },
    { 16098, "SCA Graphic Sundsvall AB" },
    { 16099, "Pinion Group, LLC" },
    { 16100, "Iron Mountain" },
    { 16101, "Cadero, Inc." },
    { 16102, "Miharu Communications Inc." },
    { 16103, "Nilgiri Networks" },
    { 16104, "KeyCOM Information Technology CO.,Ltd" },
    { 16105, "Standard Information Data Centre of Ministry of Education P.R.C" },
    { 16106, "ICCS" },
    { 16107, "Enea Data AB" },
    { 16108, "Garderos Software Innovations GmbH" },
    { 16109, "Pfannenberg" },
    { 16110, "InfoCentre Ltd." },
    { 16111, "Beaumont Hospital" },
    { 16112, "Valentine KOUTCHERBAEV" },
    { 16113, "Network Dweebs Corporation" },
    { 16114, "Qualstar Corporation" },
    { 16115, "CyberSarge, Inc." },
    { 16116, "Enforcer Group, Inc." },
    { 16117, "Rev D Networks" },
    { 16118, "3gfp" },
    { 16119, "Catalog.com" },
    { 16120, "SIMCON" },
    { 16121, "Caliber Technoloigies & Consultancy" },
    { 16122, "Netguild" },
    { 16123, "University of Florence" },
    { 16124, "X32 Pty Ltd" },
    { 16125, "NET SPACE" },
    { 16126, "Parliament of Finland" },
    { 16127, "Fathom Technology KFT" },
    { 16128, "A LAWRENCE RIEDEL" },
    { 16129, "LightHouse Training and Consulting srl" },
    { 16130, "NEC Australia P/L" },
    { 16131, "Humax Co., Ltd." },
    { 16132, "Pham Kim Binh Nguyen" },
    { 16133, "Artur Sabik" },
    { 16134, "CIRTI de Nantes" },
    { 16135, "Coherent Light" },
    { 16136, "FT Interactive Data" },
    { 16137, "Dr. Huggle & Partner GmbH" },
    { 16138, "E*Trade Financial Inc." },
    { 16139, "Compellent Technologies" },
    { 16140, "MozApps.org" },
    { 16141, "A-NeT Internet Services bv" },
    { 16142, "Network Technology and Engineering Institute of Xi'an Jiaotong University" },
    { 16143, "Gina & Jonathan Oberg" },
    { 16144, "KERBEROS" },
    { 16145, "DResearch Digital Media Systems GmbH" },
    { 16146, "United Bulgarian Bank" },
    { 16147, "intY Ltd" },
    { 16148, "JavaRealm Software Development Team" },
    { 16149, "Del Mar Analytical" },
    { 16150, "White Wolf Camarilla" },
    { 16151, "Pima Community College" },
    { 16152, "The Cincinnati Insurance Companies" },
    { 16153, "Snert" },
    { 16154, "Network Resource Technologies Corp" },
    { 16155, "HalcyonFlame" },
    { 16156, "Feral Nerds Enterprises" },
    { 16157, "RDI" },
    { 16158, "CiTR Pty Ltd" },
    { 16159, "UQ Business School" },
    { 16160, "Sphere Systems" },
    { 16161, "CSC - Scientific Computing Ltd" },
    { 16162, "RM-System Holding, a.s." },
    { 16163, "Elettronika S.r.l." },
    { 16164, "zylk" },
    { 16165, "Crescendo Networks" },
    { 16166, "University of Sheffield" },
    { 16167, "Repsol Quimica" },
    { 16168, "MediSync Midwest Limited" },
    { 16169, "Teleredes" },
    { 16170, "totaleasy" },
    { 16171, "Zucchetti.com srl" },
    { 16172, "Danger Incorporated" },
    { 16173, "Arizona Western College" },
    { 16174, "Sensatronics LLC" },
    { 16175, "TRIADE Beratungsgesellschaft f\0303\0274r Informationstechnologie mbH" },
    { 16176, "Zephra Corp." },
    { 16177, "Westermo Teleindustri AB" },
    { 16178, "WellPoint Health Networks" },
    { 16179, "WAN Norway" },
    { 16180, "Blue Data Networks Ltd" },
    { 16181, "E3Switch LLC" },
    { 16182, "Whitesmiths Australia Pty Ltd" },
    { 16183, "Hanaro Telecom" },
    { 16184, "PT. Indorama Synthetics Tbk" },
    { 16185, "NM Systems Co.,Ltd." },
    { 16186, "Peter Schneider EDV" },
    { 16187, "Aedilis UAB" },
    { 16188, "Materials Science and Technology Dept. - Univ. of Crete GREECE" },
    { 16189, "Assured Communications Group Limited" },
    { 16190, "Colegio Oficial de Arquitectos de Madrid" },
    { 16191, "NightFire Software, Inc." },
    { 16192, "BCN Associates, Inc." },
    { 16193, "Eagle Mountain International Church Inc." },
    { 16194, "Rancho Morado" },
    { 16195, "Thomson Corp Switzerland AG" },
    { 16196, "Washington Mutual" },
    { 16197, "Scoobtec" },
    { 16198, "Investment Company Institute" },
    { 16199, "openForce Information Technology GesmbH" },
    { 16200, "Casero Inc." },
    { 16201, "TI Telecomunicazioni & Informatica" },
    { 16202, "Oakland University" },
    { 16203, "Sysdata Kft." },
    { 16204, "Westinghouse Electric Company" },
    { 16205, "T-Systems GCF MSY" },
    { 16206, "Mobile TeleSystems Limited libility company" },
    { 16207, "Splicecom Ltd" },
    { 16208, "Universidade Lusiada" },
    { 16209, "Collaborative Network Technologies Inc." },
    { 16210, "Delta Piktori Oy" },
    { 16211, "Certified Security Solutions" },
    { 16212, "wang" },
    { 16213, "CEN/ISSS XFS Workshop" },
    { 16214, "Pehkonen Family" },
    { 16215, "Elbit Systems Ltd." },
    { 16216, "Trinity CC Consulting, Inc." },
    { 16217, "KDDI Media Will Corporation" },
    { 16218, "Talkline GmbH" },
    { 16219, "DB Telematik GmbH" },
    { 16220, "LANDMAT" },
    { 16221, "Strodl" },
    { 16222, "DONOBi, Inc." },
    { 16223, "Global Messaging Solutions, Inc." },
    { 16224, "HTBLuVA Wiener Neustadt" },
    { 16225, "PaeTec Communications" },
    { 16226, "Public Service Enterprise Group" },
    { 16227, "VitalStream, Inc." },
    { 16228, "AuriQ Systems, Inc." },
    { 16229, "NU Informationssysteme GmbH" },
    { 16230, "eCornell" },
    { 16231, "Introspect Consulting, Inc." },
    { 16232, "netMANj Project" },
    { 16233, "Tukcedo Services" },
    { 16234, "Dogico" },
    { 16235, "insignia financial group, inc." },
    { 16236, "Andrew Maldonado Consulting" },
    { 16237, "Mantis Technology LLC" },
    { 16238, "TheCartCompany.com" },
    { 16239, "Corbett Systems Development, Inc." },
    { 16240, "skinoske tech" },
    { 16241, "butlerNetworks AS" },
    { 16242, "Thames Valley University" },
    { 16243, "AVS Consulting" },
    { 16244, "Ecole des Mines d'Al\0303\0250s" },
    { 16245, "Humanor" },
    { 16246, "Hertz Comunicaciones" },
    { 16247, "eServGlobal" },
    { 16248, "litus.at" },
    { 16249, "Italtel S.p.A." },
    { 16250, "NetPrecept Ltd." },
    { 16251, "Bonuso Industries" },
    { 16252, "M\0303\0244t\0303\0244sahon suku" },
    { 16253, "M\0303\0244t\0303\0244sahon suku" },
    { 16254, "Holmen Paper AB" },
    { 16255, "Action Engine Corp." },
    { 16256, "Develtech" },
    { 16257, "The Hong Kong Polytechnic University" },
    { 16258, "FeelingK" },
    { 16259, "KOWA COMPANY,LTD. RESEARCH CENTER FOR ADVANCED TECHNOLOGY" },
    { 16260, "The FreeBSD China Community" },
    { 16261, "Kopint-Datorg Rt." },
    { 16262, "Repsol Petroleo" },
    { 16263, "swisswebgroup gmbh" },
    { 16264, "Itheon" },
    { 16265, "Open Methods" },
    { 16266, "The Optym Group" },
    { 16267, "American Network Communications, Inc" },
    { 16268, "US Linux Networks, LLC" },
    { 16269, "iomart ltd" },
    { 16270, "GravityRock.com" },
    { 16271, "New South Wales Fire Brigades" },
    { 16272, "Legend (Beijing) Limited" },
    { 16273, "Nexge technology p ltd" },
    { 16274, "TELMAT Industrie" },
    { 16275, "University of Kuopio" },
    { 16276, "Communications Regulation Commission" },
    { 16277, "Mobile Internet Limited" },
    { 16278, "sLAB Informationssysteme" },
    { 16279, "St. Francis Borgia RHS" },
    { 16280, "OLTPCorp" },
    { 16281, "SYSLOG Gmbh" },
    { 16282, "H5 Technologies" },
    { 16283, "OM" },
    { 16284, "QuadFore Corporation" },
    { 16285, "ibpsearch" },
    { 16286, "Hungarocom Ltd" },
    { 16287, "Swiss Federal Institute of Technology" },
    { 16288, "EDV-Beratung" },
    { 16289, "Mediva Inc." },
    { 16290, "SIAT" },
    { 16291, "Meeting Maker, Inc." },
    { 16292, "Susurro" },
    { 16293, "BRVL Technology Ltd." },
    { 16294, "Applied Instruments Inc" },
    { 16295, "Ormond college" },
    { 16296, "Vindicia" },
    { 16297, "Semnode" },
    { 16298, "hanbang-soft technology co.,Ltd" },
    { 16299, "corega K.K." },
    { 16300, "Penguin Infotech Pvt. Ltd. (formerly 'Penguin India Linux Solutions Pvt. Ltd.')" },
    { 16301, "Silesian University in Opava" },
    { 16302, "intrae" },
    { 16303, "Sans Serif" },
    { 16304, "EADS" },
    { 16305, "KIBS AD Skopje" },
    { 16306, "Repsol Distribucion" },
    { 16307, "StreamScale" },
    { 16308, "RHOEN-KLINIKUM AG" },
    { 16309, "NTT Software Corporation" },
    { 16310, "Marketline Rt." },
    { 16311, "Alatec, S.A." },
    { 16312, "Register.com" },
    { 16313, "Valemount Networks Corp" },
    { 16314, "Bureautique Services Developpement" },
    { 16315, "X|support" },
    { 16316, "HSBC Bank North America" },
    { 16317, "Quebecor World North America" },
    { 16318, "empuron" },
    { 16319, "ViaVis Mobile Solutions Inc." },
    { 16320, "The Brain Room Ltd" },
    { 16321, "ZOOM INTERNATIONAL s.r.o." },
    { 16322, "Leading Edge Telemetry, LLC" },
    { 16323, "Trax Holdings" },
    { 16324, "Itelsys" },
    { 16325, "NESCO CO., LTD." },
    { 16326, "iyaburo.com" },
    { 16327, "Mark Chesney" },
    { 16328, "NARI Corp. (Nanjing Automation Research Institute)" },
    { 16329, "AdiSyS Oy" },
    { 16330, "Reutech Radar System" },
    { 16331, "cosmocode GmbH" },
    { 16332, "Longshine Technologie Europe GmbH" },
    { 16333, "bitmine AB" },
    { 16334, "Northrop Grumman" },
    { 16335, "Seoul Electric Power System co.,ltd" },
    { 16336, "Alatec, S.A." },
    { 16337, "Canadian National Railway Company" },
    { 16338, "IPOne" },
    { 16339, "GlobeOp Financial Services, LLC" },
    { 16340, "White Rock Networks" },
    { 16341, "Biomedical Informatics Research Network  (BIRN)" },
    { 16342, "Menta Group" },
    { 16343, "UTTC United Tri-Tech Corporation" },
    { 16344, "Perfigo" },
    { 16345, "The Anvil Organisation Ltd." },
    { 16346, "Farabi Technology" },
    { 16347, "IPCAST" },
    { 16348, "Shanghai Transfiber Science&Technology Co.,Ltd." },
    { 16349, "ComGear" },
    { 16350, "TOT Corporation Public Company Limited" },
    { 16351, "Caixa Bank S. A." },
    { 16352, "Newman College of HE" },
    { 16353, "Howaldtswerke - Deutsche Werft AG" },
    { 16354, "Gruppennest" },
    { 16355, "MIDRAY GmbH" },
    { 16356, "Transfer Limited" },
    { 16357, "Hain Celestial Group" },
    { 16358, "United Carrier Networks" },
    { 16359, "Miller Samuel, Inc." },
    { 16360, "Contralor\0303\0255a General de la Rep\0303\0272blica" },
    { 16361, "Progressive Linux Consultants LLC" },
    { 16362, "Waters Network Systems" },
    { 16363, "SCHOLZ & VOLKMER Intermediales Design, GmbH" },
    { 16364, "SMARTDATA" },
    { 16365, "Dion Global Solutions GmbH (formerly 'Swissrisk Financial Systems GmbH')" },
    { 16366, "INFORMA DEL PERU, INFORMACION ECONOMICA SA" },
    { 16367, "saarstahl" },
    { 16368, "Sysapex Communications Inc." },
    { 16369, "Clark University" },
    { 16370, "DASS Consulting Group Inc." },
    { 16371, "tygrysek.com" },
    { 16372, "T-Mobile Czech Republic a.s." },
    { 16373, "Federal Public service Transport & Mobility" },
    { 16374, "NV Multikabel" },
    { 16375, "University Of Athens" },
    { 16376, "ACOSS" },
    { 16377, "IMCTech" },
    { 16378, "Sarian Systems Limited" },
    { 16379, "River Cities Reader" },
    { 16380, "NEXVU Technologies" },
    { 16381, "Verifiber, LLC" },
    { 16382, "InterBox Internet" },
    { 16383, "HP GSE Security" },
    { 16384, "California State Polytechnic University, Pomona" },
    { 16385, "Hudli" },
    { 16386, "Daxiongmao" },
    { 16387, "OEone Corporation" },
    { 16388, "J\0303\0266rg Eichhorn" },
    { 16389, "Pegasus EDV-Betreuungs-GmbH" },
    { 16390, "VineSys Technology" },
    { 16391, "RouteOne" },
    { 16392, "Cortland Communications" },
    { 16393, "Sean Champ Enterprises" },
    { 16394, "Pentair Technical Products (formerly 'Pigeon Point Systems')" },
    { 16395, "William R Sowerbutts" },
    { 16396, "justinknash.com" },
    { 16397, "U.S. Army ALTESS" },
    { 16398, "Metallect Corp." },
    { 16399, "Greyhavens" },
    { 16400, "Singapore Telecommunication Limited" },
    { 16401, "Hewlett-Packard Slovakia" },
    { 16402, "Teleformix, LLC" },
    { 16403, "Brobus International, Inc." },
    { 16404, "NeuralWorx" },
    { 16405, "CPEG.Net" },
    { 16406, "ADWIN" },
    { 16407, "Lanux Limited" },
    { 16408, "Leo Consulting" },
    { 16409, "Futuri Ltd" },
    { 16410, "NEC COMPUTERS INTERNATIONAL B.V." },
    { 16411, "Indicia Nederland bv" },
    { 16412, "Home Health Corporation of America" },
    { 16413, "rahbany.com" },
    { 16414, "itsanaddiction.org" },
    { 16415, "B.Bradenahl & H.Eggers" },
    { 16416, "REAL DATA S.C." },
    { 16417, "TMC HealthCare" },
    { 16418, "ULYSSIS" },
    { 16419, "PINBOARD" },
    { 16420, "SRA International" },
    { 16421, "Christian Albrechts Universitaet" },
    { 16422, "MUMPK limited partnership" },
    { 16423, "ABACUS Research AG" },
    { 16424, "Alanta" },
    { 16425, "City Utilities of Springfield MO" },
    { 16426, "Lawrence Technological University" },
    { 16427, "Internet Access Facilities BV" },
    { 16428, "Dial Assurance, Inc." },
    { 16429, "Lindorff Holding AS" },
    { 16430, "Mutiny Limited" },
    { 16431, "Engineering.MO S.p.A. (formerly 'T-Systems Italia S.p.A.')" },
    { 16432, "PKI Innovations Inc." },
    { 16433, "Moorehead Communications" },
    { 16434, "Jenzabar, Inc" },
    { 16435, "Clearswift Corporation" },
    { 16436, "Bookham Inc." },
    { 16437, "Bart" },
    { 16438, "Kansas Information Consortium" },
    { 16439, "PNX Pty Ltd" },
    { 16440, "netINS, Inc." },
    { 16441, "ENST" },
    { 16442, "ProActive A/S" },
    { 16443, "P&O Nedlloyd Limited" },
    { 16444, "UPTI" },
    { 16445, "Kineto Wireless" },
    { 16446, "Adlink" },
    { 16447, "epix Internet Services" },
    { 16448, "Neogate Co., Ltd" },
    { 16449, "Charcoal Generation Limited" },
    { 16450, "IT-Concepts GmbH" },
    { 16451, "SMC Pneumatics (N.Z.) Limited" },
    { 16452, "Infocomp Pty Ltd" },
    { 16453, "Beijing Municipal Local Taxation Bureau" },
    { 16454, "AXWAY" },
    { 16455, "DFS Deutsche Flugsicherung GmbH" },
    { 16456, "GPL Eletro Eletronica S/A" },
    { 16457, "Opera Logic, Inc." },
    { 16458, "Gemini Mobile Technologies, Inc." },
    { 16459, "Epygi Technologies Ltd." },
    { 16460, "Convertronic GmbH" },
    { 16461, "Eurofluxo-Suporte a Novas Tecnologias, Lda." },
    { 16462, "JAVCO Consulting" },
    { 16463, "Metavante Corporation" },
    { 16464, "Pangolin Software Industries Ltd" },
    { 16465, "State College Area School District" },
    { 16466, "Sonartech Atlas Pty Ltd" },
    { 16467, "Gigaworks" },
    { 16468, "Deriva GmbH" },
    { 16469, "Coastal Wave Internet" },
    { 16470, "KEBA AG" },
    { 16471, "SCAN ASSOCIATES SDN BHD" },
    { 16472, "QMedit" },
    { 16473, "Terranet Ltd." },
    { 16474, "mencial" },
    { 16475, "Hays IMS" },
    { 16476, "awsys gmbh" },
    { 16477, "SYSLINE S.p.A." },
    { 16478, "eiwei Training & Consulting" },
    { 16479, "P4 Tecnologia Ltda." },
    { 16480, "Ministry of Transportation of Ontario" },
    { 16481, "JOutfitters LLC" },
    { 16482, "Old Dominion University" },
    { 16483, "Pure Networks" },
    { 16484, "Gavin Newman" },
    { 16485, "Advanced Multifake Systems" },
    { 16486, "Dauphin MultiMedia" },
    { 16487, "THALES NL" },
    { 16488, "Electralink Ltd" },
    { 16489, "The Hanover Company" },
    { 16490, "Sentryware" },
    { 16491, "INMETRICS LTDA - EPP" },
    { 16492, "Scitor Corporation" },
    { 16493, "AutoCell Laboratories, Inc." },
    { 16494, "MassMutual" },
    { 16495, "iafrica.com" },
    { 16496, "ACU-RITE COMPANIES INC." },
    { 16497, "Repsol Exploracion" },
    { 16498, "MEDIUM SOFT a.s." },
    { 16499, "Graburn Technology" },
    { 16500, "S.W.A.C. GmbH" },
    { 16501, "S&H Greenpoints" },
    { 16502, "LGB PhOeNiX" },
    { 16503, "Prairie Fire Internet Technologies" },
    { 16504, "SindhSoft" },
    { 16505, "TeamStaff Inc" },
    { 16506, "NeXtorage, Inc." },
    { 16507, "Evanz Enterprises" },
    { 16508, "Progel srl" },
    { 16509, "Association des Medecins de Saint-Hilaire" },
    { 16510, "The Pepsi Bottling Group" },
    { 16511, "Sentor Managed Security Services AB" },
    { 16512, "Medienzentrum Osnabrueck" },
    { 16513, "Monaco Interactive" },
    { 16514, "UUNET SA" },
    { 16515, "GRNET S.A." },
    { 16516, "elipsan" },
    { 16517, "Partners HealthCare System Inc." },
    { 16518, "New Particles Corporation" },
    { 16519, "Microdasys Inc." },
    { 16520, "pg-cs" },
    { 16521, "Pronto Networks" },
    { 16522, "Telefonica Publicidad e Informacion S.A." },
    { 16523, "Eric Yeo" },
    { 16524, "Morty Abzug" },
    { 16525, "Unicorn" },
    { 16526, "KYA group" },
    { 16527, "Internet Pictures Corporation" },
    { 16528, "Leadtek Research Inc." },
    { 16529, "HCL Infosystems Limited" },
    { 16530, "Exalt Technologies" },
    { 16531, "brico d\0303\0251pot" },
    { 16532, "Sparda-Datenverarbeitung eG" },
    { 16533, "Consejo General de la Abogacia Espa\0303\0261ola" },
    { 16534, "Mycom International" },
    { 16535, "BitBand Technologies Ltd." },
    { 16536, "Tiscali UK" },
    { 16537, "Wireless Data Services" },
    { 16538, "Progressive Electrical Services, Inc." },
    { 16539, "Graber Enterprises, Inc." },
    { 16540, "E.D.S. Pubblica Amministrazione S.p.A." },
    { 16541, "Wapiti Regional Library" },
    { 16542, "Harley Systems" },
    { 16543, "Standard Bank of South Africa" },
    { 16544, "LEASFINANZ AG" },
    { 16545, "Cardservice International" },
    { 16546, "BBHK" },
    { 16547, "Alixen" },
    { 16548, "Fachschaft Elektrotechnik und Informationstechnik" },
    { 16549, "Giddens Industries Inc" },
    { 16550, "Masters of Branding" },
    { 16551, "ComQuest Tecnologia" },
    { 16552, "Clear Communications Corporation" },
    { 16553, "MediaWorlds" },
    { 16554, "MDS Reprocessing" },
    { 16555, "Vassar College" },
    { 16556, "www.schenkman.com" },
    { 16557, "IRT Electronics Pty Ltd" },
    { 16558, "Jiangsu Yitong High-tech Co.,Ltd." },
    { 16559, "ALOC Bonnier A/S" },
    { 16560, "Dr. T\0303\0266pper Datentechnik" },
    { 16561, "Sandar TeleCast AS" },
    { 16562, "DePaul University" },
    { 16563, "InterSystems" },
    { 16564, "EVERSTREAM, INC." },
    { 16565, "Pine Digital Security" },
    { 16566, "R.T. Shin and Associates" },
    { 16567, "University of Belize" },
    { 16568, "FUKKEN CO.,LTD." },
    { 16569, "RealVision Inc." },
    { 16570, "linux-at-work.de" },
    { 16571, "Hungarian Telekom Plc. (formerly 'Westel Mobile Telecommunications Company Ltd.')" },
    { 16572, "Centro Tecnico per la Rete Unitaria della Pubblica Amministrazione" },
    { 16573, "ICP Europe PLC" },
    { 16574, "Ontario Systems" },
    { 16575, "Oops Org" },
    { 16576, "Novso" },
    { 16577, "Virtual Targets Center" },
    { 16578, "geos" },
    { 16579, "meurisse" },
    { 16580, "Swiftel Communications" },
    { 16581, "SIIG" },
    { 16582, "BOC ONCOLOGY CENTER" },
    { 16583, "NET6a" },
    { 16584, "EVPU a.s." },
    { 16585, "ISOLUTION S.C." },
    { 16586, "Pallas Athena B.V." },
    { 16587, "Global Locate, Inc" },
    { 16588, "SSI Micro, Ltd." },
    { 16589, "CNMP Networks, Inc." },
    { 16590, "Scytl Online World Security SA" },
    { 16591, "Avtec, Inc." },
    { 16592, "Laboratory Automation Inc." },
    { 16593, "STIXO" },
    { 16594, "EmbTek" },
    { 16595, "RE-Design" },
    { 16596, "TrendDiscovery Corporation" },
    { 16597, "Landala N\0303\0244t AB" },
    { 16598, "Ton- und Studiotechnik GmbH" },
    { 16599, "VasSol, Inc." },
    { 16600, "Marketing Resources, Inc." },
    { 16601, "Intrex" },
    { 16602, "IT-Vision AG" },
    { 16603, "AirMagnet, Inc." },
    { 16604, "The OpenSSL group" },
    { 16605, "Radiance BBS" },
    { 16606, "DELFI" },
    { 16607, "Distra Pty Ltd" },
    { 16608, "Tottori SANYO Electric Co.,Ltd." },
    { 16609, "Phalanyx" },
    { 16610, "Telemedia Software Corp." },
    { 16611, "QNET" },
    { 16612, "Zenon GmbH" },
    { 16613, "Cross" },
    { 16614, "Genome Sequencing Center" },
    { 16615, "Entrada Software, Inc." },
    { 16616, "DiscipleMakers, Inc." },
    { 16617, "Merlin Aviation Systems Ltd." },
    { 16618, "SAITC" },
    { 16619, "Bandspeed, Inc." },
    { 16620, "Bugalux Denmark A/S" },
    { 16621, "Computer Care, Inc." },
    { 16622, "IntelligentAgents" },
    { 16623, "Mobile Broadcasting Corporation" },
    { 16624, "Planetactive GmbH" },
    { 16625, "Ocado Limited" },
    { 16626, "Norkom Technologies Ltd." },
    { 16627, "Chang Industry, Inc." },
    { 16628, "pdxcolo.net" },
    { 16629, "Certeon Inc" },
    { 16630, "IntellAgent GmbH" },
    { 16631, "Bermuda Holding" },
    { 16632, "Seton Hall University" },
    { 16633, "Danamis Associates" },
    { 16634, "VoxAge Teleinformatica Ltda" },
    { 16635, "S-FRiENdS" },
    { 16636, "KTROAD, Ltd." },
    { 16637, "SANYCOM Technology Co.,Ltd" },
    { 16638, "AVL List GmbH" },
    { 16639, "SoftSolutions!" },
    { 16640, "X.net 2000 GmbH" },
    { 16641, "International Solar Energy Society" },
    { 16642, "The Amulet Group" },
    { 16643, "EXAGO" },
    { 16644, "Xtensive" },
    { 16645, "San Joaquin Valley College, Inc." },
    { 16646, "R. F. Systems, Inc." },
    { 16647, "Regal CineMedia" },
    { 16648, "Centos Prime" },
    { 16649, "Softel Systems Pty Ltd" },
    { 16650, "JSC Dalcombank" },
    { 16651, "Gift of the Givers Foundation" },
    { 16652, "ThunderGeek" },
    { 16653, "Eltron" },
    { 16654, "Electralink Ltd" },
    { 16655, "Lunar Gravity Networks" },
    { 16656, "m3production" },
    { 16657, "ING Direct" },
    { 16658, "ITA Software" },
    { 16659, "Computer Science House" },
    { 16660, "DMX Technologies" },
    { 16661, "TACteam GmbH" },
    { 16662, "CFS Global Services" },
    { 16663, "Westec Holding Company Ltd" },
    { 16664, "ACI Europe Ltd" },
    { 16665, "Estonian Business School Group" },
    { 16666, "PEC Products" },
    { 16667, "Freax Sistemas" },
    { 16668, "PCI Technologies Inc" },
    { 16669, "Freeland Haynes Limited" },
    { 16670, "Action Technologies, Inc" },
    { 16671, "American Physical Society" },
    { 16672, "AirFlow Networks" },
    { 16673, "Chris Mitchell" },
    { 16674, "Voyage Data, Inc." },
    { 16675, "Chace Community School" },
    { 16676, "Servibanca- Grupo BCP" },
    { 16677, "Centre of Medical Technology" },
    { 16678, "inX Services" },
    { 16679, "Sta Track Enterprise Limited" },
    { 16680, "Axia SuperNet Ltd" },
    { 16681, "Valid Solutions" },
    { 16682, "Xtrac Ltd" },
    { 16683, "IIT GmbH" },
    { 16684, "European Humanities University" },
    { 16685, "Optinel Systems" },
    { 16686, "Protego Networks, Inc." },
    { 16687, "Cyantel" },
    { 16688, "InfraSec Sweden AB" },
    { 16689, "Retalix" },
    { 16690, "Small Electric Motors Ltd" },
    { 16691, "Tekron Communication Systems Inc." },
    { 16692, "Optimal Technologies" },
    { 16693, "LongReach Telecommunications Pty Ltd" },
    { 16694, "Purple Sun" },
    { 16695, "CYGNUS MICROSYSTEMS PRIVATE LIMITED" },
    { 16696, "Decisiv Inc." },
    { 16697, "The Free Software Initiative of Japan" },
    { 16698, "SCS Entriprise Systems" },
    { 16699, "GYL" },
    { 16700, "Southwest Airlines Co." },
    { 16701, "Carlson Hospitality Worldwide" },
    { 16702, "Naval Research Laboratory" },
    { 16703, "University of Westminster" },
    { 16704, "Yaga, Inc." },
    { 16705, "Loyola Marymount University" },
    { 16706, "NavinMail Services (India) pvt ltd" },
    { 16707, "Exelixis Deutschland GmbH" },
    { 16708, "Wuhan Wearnes Technology CO,.Ltd(China)" },
    { 16709, "same" },
    { 16710, "Screaming Genius Meta Labs" },
    { 16711, "basis0.net" },
    { 16712, "ILB" },
    { 16713, "FH-Rosenheim" },
    { 16714, "Gossamer Group, LLC" },
    { 16715, "TRLabs Regina" },
    { 16716, "Unisyn Software, LLC" },
    { 16717, "University of Victoria" },
    { 16718, "GMV S.A." },
    { 16719, "SAS IRIS Technologies" },
    { 16720, "OSS Service" },
    { 16721, "Chronos Technology Ltd" },
    { 16722, "Methics Oy" },
    { 16723, "LawBase Technologies" },
    { 16724, "Fitzgerald Associates" },
    { 16725, "Itech Inc." },
    { 16726, "Dowslake Microsystems Corporation" },
    { 16727, "THALES AVIONICS" },
    { 16728, "Wolcott Systems Group, LLC" },
    { 16729, "Midling and Associates" },
    { 16730, "Higher Ground Networks LLC" },
    { 16731, "Industrial Medium" },
    { 16732, "Guardent, Inc." },
    { 16733, "ActiveLife Ltd." },
    { 16734, "Orbital Data Corporation" },
    { 16735, "TechnoCom Corporation" },
    { 16736, "JavaLi Ltd." },
    { 16737, "NeoTool Development, LLC" },
    { 16738, "InterVideo Inc." },
    { 16739, "CompanyName" },
    { 16740, "3C Limited" },
    { 16741, "Alexander M\0303\0274ller Informatik" },
    { 16742, "topteam Services GmbH" },
    { 16743, "Hessische Zentrale fuer Datenverarbeitung" },
    { 16744, "BLANKOM" },
    { 16745, "Alfa-Bank OJSC" },
    { 16746, "springtimesoft LTD (formerly 'norbu09.org')" },
    { 16747, "InterCommIT b.v." },
    { 16748, "Studentska Unie CVUT" },
    { 16749, "Extensible Systems Ltd." },
    { 16750, "Gee Broadcast Systems Ltd" },
    { 16751, "INSA, S.A." },
    { 16752, "4G Consulting Ltd." },
    { 16753, "dbNet Pty Ltd" },
    { 16754, "MERLIN, spol. s r.o." },
    { 16755, "DanuSys, Ltd." },
    { 16756, "Juasun.net" },
    { 16757, "IT SOFTWARE" },
    { 16758, "Lakeridge Health Corporation" },
    { 16759, "Central Missouri State University" },
    { 16760, "Internet Direct Inc." },
    { 16761, "New Mexico Tech" },
    { 16762, "Olson Technology, Inc." },
    { 16763, "EZ Web-Tech, Inc." },
    { 16764, "IDD Works Inc." },
    { 16765, "Schmitz-IT" },
    { 16766, "SV Systems" },
    { 16767, "Wonderline Rt." },
    { 16768, "Marine Interface Inc" },
    { 16769, "SV Systems" },
    { 16770, "Dave Dodge" },
    { 16771, "7seas Solutions Ltd." },
    { 16772, "University of California, Santa Barbara" },
    { 16773, "Sourwood Research" },
    { 16774, "4U S.r.l." },
    { 16775, "GIP-MDS" },
    { 16776, "mmit of ECNU" },
    { 16777, "Oxance" },
    { 16778, "Uniteam Init" },
    { 16779, "More-Secure B.V." },
    { 16780, "Pathway Computing, Inc" },
    { 16781, "WASP Systems Inc." },
    { 16782, "ClickCadence, LLC." },
    { 16783, "Abacus Technical Services" },
    { 16784, "Olson Technology, Inc." },
    { 16785, "Medizinische Universit\0303\0244t Wien" },
    { 16786, "Eosys srl" },
    { 16787, "T-Systems Nova International GmbH" },
    { 16788, "Information Technology Center (KYTP), Aristotle Univ. of Thessaloniki GREECE" },
    { 16789, "Berklee College of Music" },
    { 16790, "Myrio Corporation" },
    { 16791, "BRASCON" },
    { 16792, "Zapata Engineering, P.A." },
    { 16793, "University of New England" },
    { 16794, "Savant Technologies Private Ltd" },
    { 16795, "MRO - TEK LIMITED" },
    { 16796, "Institute of High Energy Physics ,Beijing,China" },
    { 16797, "InfoThuis Nieuwe Media BV" },
    { 16798, "Digital Technical Ltd., National Libaray of China" },
    { 16799, "XL Global Services Ltd." },
    { 16800, "IDYLIC" },
    { 16801, "Open Pricer" },
    { 16802, "i2Q Ltd" },
    { 16803, "Tetra Pak Information Management AB" },
    { 16804, "netcadabra" },
    { 16805, "Validus Medical Systems, Inc" },
    { 16806, "Dot New Media Ltd" },
    { 16807, "Millennium Digital Media" },
    { 16808, "hambrecht.org" },
    { 16809, "Payless Shoesource, Inc" },
    { 16810, "Along Software Developer WorkShop" },
    { 16811, "BlueTie, Inc." },
    { 16812, "UnixIron" },
    { 16813, "Micronet Communications,INC." },
    { 16814, "Quinsy B.V." },
    { 16815, "GlidePath BV" },
    { 16816, "Computer Plus GmbH" },
    { 16817, "De La Rue International Ltd" },
    { 16818, "United Media Company GmbH" },
    { 16819, "Priocom Corp." },
    { 16820, "SOC" },
    { 16821, "Institute for Advanced Study" },
    { 16822, "Scott L. H. Yuan" },
    { 16823, "Abeling-IT-Design" },
    { 16824, "OTAGAKI" },
    { 16825, "Network Technology" },
    { 16826, "Innomedia Technologies Private Limited" },
    { 16827, "Secure Systems Ltd." },
    { 16828, "IntelSoft Ltd." },
    { 16829, "DuckCorp" },
    { 16830, "Fidelity Information Services" },
    { 16831, "benhall.ca" },
    { 16832, "Auchan" },
    { 16833, "Logicworks Inc." },
    { 16834, "Hospital Billing Collection Service, Ltd. (HBCS)" },
    { 16835, "Dahle Consulting" },
    { 16836, "M2Studio Ltd." },
    { 16837, "Washington County" },
    { 16838, "Omron Corporation" },
    { 16839, "Rodion Software" },
    { 16840, "Shanghai E-Rom Communication Technology Co.,Ltd" },
    { 16841, "Ifeelnet" },
    { 16842, "In Phase Consulting" },
    { 16843, "BarcoVision" },
    { 16844, "CreaCare GmbH" },
    { 16845, "Electricit\0303\0251 de France - Gaz de France" },
    { 16846, "MPEC Wroclaw S.A." },
    { 16847, "Sakura Network Japan" },
    { 16848, "Independent Consulting Solutions Ltd." },
    { 16849, "BeyondData.net ITS" },
    { 16850, "13 Colonies Software" },
    { 16851, "rheingold Institut f\0303\0274r qualitative Markt- und Medienanalysen Gesellschaft b\0303\0274rgerlichen Rechts" },
    { 16852, "Telinfos" },
    { 16853, "barracuda digitale agentur GmbH" },
    { 16854, "STI Healthcare, Inc." },
    { 16855, "Metromorph Softworks Ruhri/List GbR" },
    { 16856, "Bradford Software Inc." },
    { 16857, "3 Bean" },
    { 16858, "Tall Maple Systems, Inc." },
    { 16859, "Multimedia Games, Inc." },
    { 16860, "Thomas Endo" },
    { 16861, "Wefi.Net IT Consulting" },
    { 16862, "ICONZ Ltd" },
    { 16863, "JSR.COM" },
    { 16864, "{M:U} Consulting" },
    { 16865, "ZIM Technologies International Inc." },
    { 16866, "Software North, Inc." },
    { 16867, "TIBCO Software, Inc. DSPG (formerly 'DataSynapse, Inc.')" },
    { 16868, "Conseil Internet & Logiciels Libres, J\0303\0251r\0303\0264me Alet" },
    { 16869, "ROMmon Ltd" },
    { 16870, "Banco do Estado do Rio Grande do Sul,S.A." },
    { 16871, "Tchibo Frisch-R\0303\0266st-Kaffee GmbH" },
    { 16872, "Collaborative Commerce Engines" },
    { 16873, "future gate group" },
    { 16874, "HiTRUST Incorporated" },
    { 16875, "Computer Plus GmbH" },
    { 16876, "KungFoo Coders" },
    { 16877, "All Media Banking BV" },
    { 16878, "Oldham Metropolitan Borough Council" },
    { 16879, "SCA Transforest AB" },
    { 16880, "zehome.com" },
    { 16881, "emni GmbH" },
    { 16882, "OpenEAI Software Foundation" },
    { 16883, "GKB Technology Co., Ltd" },
    { 16884, "(IPL) Instituto Polit\0303\0251cnico de Lisboa" },
    { 16885, "Nortel Networks" },
    { 16886, "Revelstone Technology" },
    { 16887, "IPLocks Inc." },
    { 16888, "Neutelligent.com" },
    { 16889, "MYIT.BIZ, Inc." },
    { 16890, "Technisys" },
    { 16891, "Meta GmbH" },
    { 16892, "Signalisation Ver-Mac, Inc." },
    { 16893, "Enterprise Rent-A-Car" },
    { 16894, "Cotelligent, Inc" },
    { 16895, "J.P. Evans, Inc." },
    { 16896, "SUNGARD Front Office Solutions" },
    { 16897, "sdata - C. Splittgerber Datentechnik" },
    { 16898, "Venture Industry International Corp." },
    { 16899, "Corvigo, Inc." },
    { 16900, "a metareal material" },
    { 16901, "Mojo Networks, Inc. (formerly 'Wibhu Technologies Pvt. Ltd.')" },
    { 16902, "APPLETZ CO., LTD." },
    { 16903, "TeleCats BV" },
    { 16904, "Aylesford Newsprint Limited" },
    { 16905, "Ginger Alliance Ltd." },
    { 16906, "Enertron LLC" },
    { 16907, "Truman State University" },
    { 16908, "Binary Ape" },
    { 16909, "Newberg Public Schools" },
    { 16910, "chinaunionpay" },
    { 16911, "General Wireless Scandinavia AB" },
    { 16912, "Bundesanstalt Statistik Oesterreich" },
    { 16913, "Open Network Solutions, Inc" },
    { 16914, "nuit.ca" },
    { 16915, "The Hal Lewis Group, Inc." },
    { 16916, "ma-planete" },
    { 16917, "Seecago" },
    { 16918, "AEIIE - ARISE" },
    { 16919, "Augsburger Computer Forum e.V." },
    { 16920, "ARTE G.E.I.E" },
    { 16921, "HWACOM SYSTEMS INC." },
    { 16922, "ville d'Echirolles" },
    { 16923, "RTV Slovenija, Javni zavod" },
    { 16924, "British Sky Broadcasting Ltd" },
    { 16925, "IGA-PEGASE" },
    { 16926, "Systemberatung Axel Dunkel GmbH" },
    { 16927, "MLB Associates" },
    { 16928, "Mark South West" },
    { 16929, "University of California, Merced" },
    { 16930, "CAM Security and Connections B.V." },
    { 16931, "Sandwell Technologies, Inc." },
    { 16932, "DICOM Group" },
    { 16933, "ALC Computertechnik GmbH" },
    { 16934, "Marian Bracinik" },
    { 16935, "Espoo-Vantaa Institute of Technology" },
    { 16936, "Databay AG" },
    { 16937, "e-Wriedt" },
    { 16938, "Sensational AG" },
    { 16939, "Addix Internet Services GmbH" },
    { 16940, "CryptoGram SA" },
    { 16941, "Oakley, Inc." },
    { 16942, "TRX" },
    { 16943, "Overture Networks, Inc. (formerly 'Ceterus Networks')" },
    { 16944, "Seven Blades" },
    { 16945, "Grupo de Usuarios de Linux de Canarias" },
    { 16946, "Litchfield Communications, Inc." },
    { 16947, "Program Line" },
    { 16948, "RHODITECH" },
    { 16949, "Mobifon S.A." },
    { 16950, "AOM Active Online Marketing GmbH" },
    { 16951, "COGEMA LA HAGUE" },
    { 16952, "Eisodus Networks Pvt. Ltd" },
    { 16953, "TECCO Software Entwicklung AG" },
    { 16954, "Software Poetry, Inc." },
    { 16955, "modulus-systems GmbH & Co. KG" },
    { 16956, "InboxCop, Inc." },
    { 16957, "FioNet Internet Services" },
    { 16958, "Instituto Tecnol\0303\0263gico y de Energ\0303\0255as Renovables, S.A." },
    { 16959, "Cipher Security Services, Inc." },
    { 16960, "Darron Nesbitt" },
    { 16961, "Vaisala" },
    { 16962, "Seven Levels Consultants AB" },
    { 16963, "Intuwave Ltd." },
    { 16964, "nonap" },
    { 16965, "AUNA TLC" },
    { 16966, "Kiff Analytical, LLC" },
    { 16967, "University Texas Medical Branch Galveston" },
    { 16968, "Magnifire" },
    { 16969, "eyebits studios" },
    { 16970, "Coublis Ltd" },
    { 16971, "Lemche Net" },
    { 16972, "DSL Terminal Remote Management Alliance" },
    { 16973, "CITS Group Inc." },
    { 16974, "WORLDMINGO" },
    { 16975, "Horst Thiele - Maschinenbau - Hydraulische Geraete GmbH" },
    { 16976, "S.I.D.E. Resources & Development" },
    { 16977, "Zwi1zek Bankow Polskich" },
    { 16978, "Medical Insight A/S" },
    { 16979, "M2 Ingenierie et Conseil SARL" },
    { 16980, "Jacob & Sundstrom, Inc." },
    { 16981, "ITG Inc." },
    { 16982, "Masaryk University" },
    { 16983, "CINECA" },
    { 16984, "Exacore Consolidated Systems" },
    { 16985, "Global Technology Co.,Ltd." },
    { 16986, "FACTOR SPE" },
    { 16987, "Esker SA" },
    { 16988, "The Manufacturers Life Insurance Company" },
    { 16989, "KiSP, Inc." },
    { 16990, "Print Inc." },
    { 16991, "Starsoft" },
    { 16992, "The Halifax Herald Limited" },
    { 16993, "Norsec" },
    { 16994, "Key Circle" },
    { 16995, "elego Software Solutions GmbH" },
    { 16996, "Aboriginal Sports and Recreation Association of BC" },
    { 16997, "Innovative Consultants, LLC" },
    { 16998, "Intoto Inc." },
    { 16999, "Cortinovis S.A." },
    { 17000, "Centre de Telecomunicacions i TI de la Generalitat de Catalunya" },
    { 17001, "Act Technology Co.,Ltd." },
    { 17002, "Copsey Communications Projects" },
    { 17003, "University Of Dundee" },
    { 17004, "Israel InterUniversity Computation Center" },
    { 17005, "Mangrove Systems, Inc." },
    { 17006, "Spherion" },
    { 17007, "Cool IT" },
    { 17008, "Clever Age SARL" },
    { 17009, "imove" },
    { 17010, "hopecom optic communication Ltd." },
    { 17011, "Metadata Systems, Inc." },
    { 17012, "eCareme Technologies, Inc." },
    { 17013, "Guaranty Technology Corp." },
    { 17014, "Izumi Cyber Networks Inc." },
    { 17015, "manage.it GmbH & Co. KG" },
    { 17016, "Info Jure Knowledge Ltd." },
    { 17017, "CyberTech de Colombia Ltd." },
    { 17018, "Silikone.com" },
    { 17019, "Heinrich Berndes Haushaltstechnik GmbH&Co. KG" },
    { 17020, "IRSN" },
    { 17021, "University of Central Florida" },
    { 17022, "Avista Labs Inc." },
    { 17023, "Apptera" },
    { 17024, "Jackson Local School District" },
    { 17025, "Rether Networks Inc." },
    { 17026, "dotNSF, Inc." },
    { 17027, "YAAO" },
    { 17028, "MarketXS.com BV" },
    { 17029, "baumer it-services (formerly '0mode')" },
    { 17030, "Velveo" },
    { 17031, "Cluster Labs GmbH" },
    { 17032, "City of Helsinki" },
    { 17033, "Medical University of South Carolina" },
    { 17034, "NHN Corp." },
    { 17035, "Cerberian Inc" },
    { 17036, "Alisys Software S.L." },
    { 17037, "Brannstroms Elektronik AB" },
    { 17038, "Federal State Unitary Enterprise \"Production Company 'Start'\"" },
    { 17039, "Vontu, Inc" },
    { 17040, "Integrits Corporation" },
    { 17041, "TeleDomani, Inc." },
    { 17042, "Consultores Globales Online S.L." },
    { 17043, "PC-Repair Aalestrup" },
    { 17044, "Red Fig Ltd" },
    { 17045, "Network Technologies Group" },
    { 17046, "ErrorNet" },
    { 17047, "Eurofresh.inc" },
    { 17048, "Ashland Inc." },
    { 17049, "Eurospider Information Technology A.G." },
    { 17050, "MediaSonic" },
    { 17051, "Last Minute Network Limited" },
    { 17052, "A Plus Marketing" },
    { 17053, "www.slavel.ru" },
    { 17054, "Severoceska plynarenska, a.s." },
    { 17055, "MoshJahan Ltd" },
    { 17056, "Fusion Network Services Corp." },
    { 17057, "Victor-Sierra" },
    { 17058, "National Radio Astronomy Observatory" },
    { 17059, "Cookingwise" },
    { 17060, "zetein.net" },
    { 17061, "Shanghai 4U Network Tech.Co.,Ltd." },
    { 17062, "ArielServices" },
    { 17063, "Lightship Telecom, LLC" },
    { 17064, "CSX Technologies" },
    { 17065, "Zions Bancorporation" },
    { 17066, "Collaboratech, Inc." },
    { 17067, "Padimax Limited" },
    { 17068, "Jcast Networks Corp." },
    { 17069, "Leucotron Equipamentos Ltda." },
    { 17070, "Hi De Ho" },
    { 17071, "Prime Electronics & Satellitics Inc." },
    { 17072, "Transgate" },
    { 17073, "Universitaetsklinikum Freiburg" },
    { 17074, "Senatsverwaltung fuer Gesundheit, Soziales und Verbraucherschutz Berlin" },
    { 17075, "Edwin L. Cox School of Business" },
    { 17076, "EXCELLENCE High Tech - Georgia LTD." },
    { 17077, "Girit Projects Inc." },
    { 17078, "Innovation Software Group, LLC" },
    { 17079, "AppIQ, Inc." },
    { 17080, "BeTrained, Baumgartner KEG" },
    { 17081, "M.F. van Loon" },
    { 17082, "Oregon University System" },
    { 17083, "COMPART MEDICAL SYSTEMS" },
    { 17084, "HON HAI PRECISION IND. CO., LTD." },
    { 17085, "Beijing BU Telecom Tech co.,Ltd" },
    { 17086, "BIK Aschpurwis + Behrens GmbH" },
    { 17087, "GrECo International AG" },
    { 17088, "sichuan wisesoft Ltd." },
    { 17089, "Universit\0303\0244t Paderborn, Zentrum IT-Dienste" },
    { 17090, "Packetizer, Inc." },
    { 17091, "Ciphire Labs" },
    { 17092, "MediaRing Limited" },
    { 17093, "Ellemedia Technologies Ltd." },
    { 17094, "Blueslice Networks Inc." },
    { 17095, "Microchip Technology Inc." },
    { 17096, "Invesco Institutional, Fixed Income Group" },
    { 17097, "Weltek Technologies Co., Ltd." },
    { 17098, "Innomenta GmbH & Co. KG" },
    { 17099, "TellusTech Ltd." },
    { 17100, "Fabasoft R&D Software GmbH & Co KG" },
    { 17101, "InternetNu" },
    { 17102, "Bororos" },
    { 17103, "Biznet Information Systems and Consultancy" },
    { 17104, "1-800 Communications, Inc." },
    { 17105, "Insignia Solutions" },
    { 17106, "GlobNIX" },
    { 17107, "The Konopka Corporation" },
    { 17108, "Vinci Systems, Inc." },
    { 17109, "Chotaro Co." },
    { 17110, "Institut de Recherche pour le D\0303\0251veloppement (IRD)" },
    { 17111, "JMSE" },
    { 17112, "Axstone Co., Ltd." },
    { 17113, "EvoNet Computer Network Evolution GmbH" },
    { 17114, "Keyrus S.A." },
    { 17115, "D-APP-X Corporation" },
    { 17116, "GMA COMMUNICATION MANUFACTURING & MARKETING 1991 LTD." },
    { 17117, "Advantage Sales & Marketing" },
    { 17118, "Byram Healthcare Centers, Inc." },
    { 17119, "OctetString, Inc" },
    { 17120, "Team Cool Networks" },
    { 17121, "Geronimo Group Inc." },
    { 17122, "Apogent Technologies Inc." },
    { 17123, "Tavata Software Corporation" },
    { 17124, "Psycat Group" },
    { 17125, "Eze Castle Integration, Inc." },
    { 17126, "Nova Engineering, Inc." },
    { 17127, "Kilowatt Networking, Inc." },
    { 17128, "mg2.org" },
    { 17129, "Zaclick Co.,Ltd" },
    { 17130, "antiquity books" },
    { 17131, "Rectifier Technologies Pacific Pty Ltd" },
    { 17132, "Shanghai Dare Opto-electronic Communication Co.,Ltd" },
    { 17133, "ILWOO DATA & TECHNOLOGY Co.,LTD" },
    { 17134, "Good Health Network, Inc" },
    { 17135, "Raaijmakers" },
    { 17136, "PLG AG" },
    { 17137, "GradSoft Ltd." },
    { 17138, "INHOLLAND Universities" },
    { 17139, "Internet Gold" },
    { 17140, "Versatel Nederland B.V." },
    { 17141, "Incenti S.A." },
    { 17142, "Static Bytes" },
    { 17143, "Georg-Hewegh-Oberschule" },
    { 17144, "State University of New York at Stony Brook" },
    { 17145, "Rusch Consultancy B.V." },
    { 17146, "UVHC" },
    { 17147, "Eastern Illinois University" },
    { 17148, "iBurst Forum" },
    { 17149, "Lodestar Technology Ltd" },
    { 17150, "simatika" },
    { 17151, "COGNICA Ltd" },
    { 17152, "creamen" },
    { 17153, "University of Connecticut" },
    { 17154, "Kittredge Archery Co. Inc." },
    { 17155, "VoiceAge Corporation" },
    { 17156, "Zone Labs, Inc" },
    { 17157, "Chengdu Runwang Tchnology Co. LTD" },
    { 17158, "Laurasia Computing" },
    { 17159, "Henri Maire SA" },
    { 17160, "Lund University Hospital" },
    { 17161, "Covisint LLC" },
    { 17162, "Airversal Technology Inc" },
    { 17163, "Riverbed Technology, Inc." },
    { 17164, "Callcast, Inc." },
    { 17165, "Advantest R&D Center, Inc." },
    { 17166, "Louisiana State University and A&M College" },
    { 17167, "Daotec Ltd." },
    { 17168, "Century 21 Mike Bowman, Inc." },
    { 17169, "Diablotin" },
    { 17170, "Universit\0303\0251 Henri Poincar\0303\0251 - Nancy 1 -" },
    { 17171, "Qindel" },
    { 17172, "Melco International Development Ltd." },
    { 17173, "Squeeky Clean" },
    { 17174, "Iridium Systems (Hangzhou) Limited" },
    { 17175, "shanghai letel communications Co., Ltd" },
    { 17176, "Perm State Pedagogical University" },
    { 17177, "TIS Inc." },
    { 17178, "VERA Autonoom Provinciebedrijf" },
    { 17179, "Diaz" },
    { 17180, "Altibase" },
    { 17181, "Dantek Computer Systems, Inc." },
    { 17182, "CCC Data Oy" },
    { 17183, "Yang Mei Technology Co., LTD." },
    { 17184, "ProLAN" },
    { 17185, "Richemont Group" },
    { 17186, "MEDIA LINKS Co.,LTD." },
    { 17187, "Onaro Inc." },
    { 17188, "GigaClue" },
    { 17189, "Ingrafted Software Inc." },
    { 17190, "Fulcrum Microsystems, Inc." },
    { 17191, "Universidad de La Laguna" },
    { 17192, "Emprisa Networks" },
    { 17193, "dbc Digital Broadcast Consulting GmbH" },
    { 17194, "Whoopy Engineering Ltd." },
    { 17195, "Securesoft Systems, Inc." },
    { 17196, "CacheLogic Ltd." },
    { 17197, "Relicore, Inc." },
    { 17198, "martinskafte.dk" },
    { 17199, "Ministry of Fisheries - NZ" },
    { 17200, "Optus Internet Engineering" },
    { 17201, "Digital Item" },
    { 17202, "NEC informatec systems,ltd." },
    { 17203, "Pekarek Handelsges.m.b.H" },
    { 17204, "IIM CORPORATION" },
    { 17205, "ARPENT ENTERPRISES" },
    { 17206, "Open Stock Company \0302\0253Oskol Electrometallurgical Kombinat\0302\0273" },
    { 17207, "Cloverleaf Communications Inc." },
    { 17208, "Fa Nea Sj\0303\0266holm" },
    { 17209, "Strategic Systems Consultants Ltd." },
    { 17210, "GZS Gesellschaft fuer Zahlungssysteme mbH" },
    { 17211, "Potronics sp. z o.o." },
    { 17212, "AWETA b.v." },
    { 17213, "DAY-S.COM" },
    { 17214, "Network Designers Ltd." },
    { 17215, "Institute of Linguistic Studies" },
    { 17216, "Triplanet Partners LLC" },
    { 17217, "University of Richmond" },
    { 17218, "Union Internationale des Chemins de Fer" },
    { 17219, "NsTEL Inc." },
    { 17220, "eBenX, Inc." },
    { 17221, "CHBE UBC" },
    { 17222, "Sierhuis Digitale Diensten" },
    { 17223, "Cena Salvatore" },
    { 17224, "Newbury Networks" },
    { 17225, "ispi of Lincoln, Inc" },
    { 17226, "BC5 Technologies Inc." },
    { 17227, "DMP Initiatives" },
    { 17228, "Kommando" },
    { 17229, "Miracle Group, Ltd." },
    { 17230, "UniqMinds Ltd." },
    { 17231, "Otto UK" },
    { 17232, "PANNOCOM Ltd." },
    { 17233, "ICODEX Software AG" },
    { 17234, "ET Enterprise Technologies srl" },
    { 17235, "2e Systems GmbH" },
    { 17236, "Shout Telecoms Limited" },
    { 17237, "S.P.E.Sistemi e Progetti Elettronici s.a.s. di P.Prandini & C" },
    { 17238, "NsTEL Inc." },
    { 17239, "Plan B Email Services, LLC" },
    { 17240, "Spread Teleinform\0303\0241tica Ltda" },
    { 17241, "Federal Trade Commission" },
    { 17242, "Mission Vi" },
    { 17243, "World Access Canada Inc." },
    { 17244, "Briteace Enterprise Pte Ltd" },
    { 17245, "Genentech, Inc." },
    { 17246, "FreeSNMP" },
    { 17247, "SBC Internet Services" },
    { 17248, "Gemstone Communications, Inc" },
    { 17249, "VAN Company Ltd." },
    { 17250, "Yore Elektronik Yayimcilik A.S." },
    { 17251, "WeRMSPoWKe" },
    { 17252, "MS Global Consulting GmbH" },
    { 17253, "Arcada Polytechnic" },
    { 17254, "Goad.US" },
    { 17255, "Vidyatel Ltd." },
    { 17256, "CL-NET s.r.o." },
    { 17257, "Initial Security Limited" },
    { 17258, "DRQ Sp. z o.o." },
    { 17259, "Manex" },
    { 17260, "Numinatek Co." },
    { 17261, "RJWare, Inc" },
    { 17262, "Devonshire Group, Inc" },
    { 17263, "Alpes Team" },
    { 17264, "Mount Clemens General Hospital" },
    { 17265, "Escape OE" },
    { 17266, "California Internet Inc" },
    { 17267, "Hitachi Computer Products (Europe) S.A.S" },
    { 17268, "ABB Process Analytics" },
    { 17269, "Hansa JSC" },
    { 17270, "Comcast Corporation" },
    { 17271, "Sunshine Village Ski & Snowboard Resort" },
    { 17272, "akashic Inc." },
    { 17273, "The Rabbithole Org." },
    { 17274, "Nevis Networks Inc." },
    { 17275, "MicroBit" },
    { 17276, "Colegio de Registradores de la Propiedad y Mercantiles de Espa\0303\0261a" },
    { 17277, "TUI Nederland N.V." },
    { 17278, "IZB-Soft" },
    { 17279, "Stowe Holdings (Pty) Ltd" },
    { 17280, "Fadesa Inmobiliaria" },
    { 17281, "Luther College" },
    { 17282, "Abhai Inc." },
    { 17283, "YACME S.r.l." },
    { 17284, "UNICOM UNIversal computer COMmunication, spol. s r.o." },
    { 17285, "DOBS" },
    { 17286, "Steuerungs- & Netzwerktechnik" },
    { 17287, "Pacific Life" },
    { 17288, "VicSuper" },
    { 17289, "LinuxHQ" },
    { 17290, "Key Digital Solutions Ltd." },
    { 17291, "Mithra Biodindustry Co., Ltd" },
    { 17292, "NXN Software AG" },
    { 17293, "DavidRLee" },
    { 17294, "Agile Teamwork, Inc." },
    { 17295, "WestNoble" },
    { 17296, "Fourth Corner Systems" },
    { 17297, "Sine Nomine Associates" },
    { 17298, "BlueWater Technologies Inc" },
    { 17299, "vMoksha Technologies Private Limited" },
    { 17300, "Axxius b.v." },
    { 17301, "AllServe Automatisering B.V." },
    { 17302, "Iconology Ltd" },
    { 17303, "Paramount Pictures" },
    { 17304, "Layer 7 Technologies Inc." },
    { 17305, "Aeras Networks" },
    { 17306, "Armenian e-Science Foundation (ArmeSFo)" },
    { 17307, "Tribunal Regional do Trabalho da 15\0302\0252 Regi\0303\0243o" },
    { 17308, "Digimedworx" },
    { 17309, "Saudi Arabian Monetary Agency (SAMA)" },
    { 17310, "Vanquish International Ltd." },
    { 17311, "Myllykoski Corp." },
    { 17312, "Shizuoka System Technology" },
    { 17313, "Ratiodata GmbH" },
    { 17314, "Soltim" },
    { 17315, "EtherAddress.com" },
    { 17316, "Peoria Christian School" },
    { 17317, "MassiveEgo" },
    { 17318, "Media5 Corporation  (formerly 'M5T Centre d'Excellence en Telecom Inc.')" },
    { 17319, "JC Computing" },
    { 17320, "J&M Crowther Ltd." },
    { 17321, "Calpine" },
    { 17322, "SOFTLAND" },
    { 17323, "Datatekniska Byr\0303\0245n" },
    { 17324, "YDI Wireless Inc." },
    { 17325, "Babastik" },
    { 17326, "AC Camerfirma, S.A." },
    { 17327, "City of Northglenn" },
    { 17328, "Imenta Sweden AB" },
    { 17329, "School of Information Technology, Universiti Utara Malaysia" },
    { 17330, "Zetta Systems, Inc." },
    { 17331, "30San Information System Co.,Ltd." },
    { 17332, "Pete Attkins Engineering Ltd" },
    { 17333, "Critical Networks, Inc." },
    { 17334, "DN-Solutions" },
    { 17335, "UPM-Kymmene Corporation" },
    { 17336, "Bank of Russia" },
    { 17337, "Solace Systems, Inc." },
    { 17338, "IBS Technology & Services" },
    { 17339, "SAFA GALENICA, S.A." },
    { 17340, "Microtest Ltd" },
    { 17341, "Fonner Consulting" },
    { 17342, "Danske Gymnasieelevers Sammenslutning" },
    { 17343, "Edula" },
    { 17344, "OFSET" },
    { 17345, "fusionOne, Inc." },
    { 17346, "AlienForceIT" },
    { 17347, "Hilti Corporation" },
    { 17348, "USTC E-Business Technology Company" },
    { 17349, "DELTA N.V." },
    { 17350, "OnRelay Ltd" },
    { 17351, "Simmons College" },
    { 17352, "FrancisScott Communications LLC" },
    { 17353, "VisSim AS" },
    { 17354, "Zone Trading Partners" },
    { 17355, "Cirrus Multimedia Limited" },
    { 17356, "RiskMetrics Group Inc." },
    { 17357, "Derks.IT" },
    { 17358, "Fulford Consulting Ltd" },
    { 17359, "net9" },
    { 17360, "T&J Computer Systems" },
    { 17361, "Infoscience Corporation" },
    { 17362, "Asia Pacific Bioinformatics Network (APBioNet)" },
    { 17363, "SANYO DDP-BU" },
    { 17364, "SITELI" },
    { 17365, "SISSA - ISAS Scuola Internazionale Superiore di Studi Avanzati" },
    { 17366, "Torbay Council" },
    { 17367, "Grep AS" },
    { 17368, "PIFAUT" },
    { 17369, "sustainable development networking programme" },
    { 17370, "OnRelay Ltd" },
    { 17371, "4DotNet oHG" },
    { 17372, "iFoni Cellular Services" },
    { 17373, "IT Watchdogs, Inc." },
    { 17374, "Clearfield Knowledge Solutions Ltd." },
    { 17375, "Image Analysis,Inc." },
    { 17376, "Intelcom San Marino S.p.A." },
    { 17377, "aesys spa" },
    { 17378, "Interlink Software Services Ltd" },
    { 17379, "University of Applied Sciences Wolfenbuettel" },
    { 17380, "Spazio ZeroUno SpA" },
    { 17381, "The Kinkaid School" },
    { 17382, "VAI bv" },
    { 17383, "EASY SOFTWARE" },
    { 17384, "Contemporary Control Systems, Inc." },
    { 17385, "Appriss, Inc" },
    { 17386, "iCanSP, inc" },
    { 17387, "Frontier Financial" },
    { 17388, "Allen Systems Group INC" },
    { 17389, "Core NAP, L.P." },
    { 17390, "Family Video" },
    { 17391, "NOSE Applied Intelligence AG" },
    { 17392, "Abucco Technologies Inc." },
    { 17393, "Allen Systems Group INC" },
    { 17394, "BRAINBOW EDV-Beratung GmbH" },
    { 17395, "Beijing Founder Electronic Co.,Ltd." },
    { 17396, "Sapura Advance Systems Sdn Bhd" },
    { 17397, "BVE des Kantons Bern" },
    { 17398, "HBhard, spol. s.r.o." },
    { 17399, "AKiT Ltd." },
    { 17400, "tourisline AG" },
    { 17401, "Lands' End, Inc." },
    { 17402, "Sevis Systems, Inc." },
    { 17403, "Oklahoma Department of Career and Technology Education" },
    { 17404, "WebundCo GmbH & CoKG" },
    { 17405, "Telecommunications Industry Association TR8dot5" },
    { 17406, "HITS" },
    { 17407, "OmegaWare Systems Ltd." },
    { 17408, "HICOM COMUNICA\0303\0207\0303\0203O INTEGRADA LTDA." },
    { 17409, "National Standardization Committee of Radio & Television" },
    { 17410, "SOPRA GROUP" },
    { 17411, "newsky software" },
    { 17412, "GateConnect Technologies GmbH" },
    { 17413, "Ministerio del Interior - Espa\0303\0261a" },
    { 17414, "vzw CDS" },
    { 17415, "PUCRS" },
    { 17416, "Root IT" },
    { 17417, "Portiva Corporation" },
    { 17418, "Mahanaxar Networks" },
    { 17419, "Lincoln Investment Planning, Inc" },
    { 17420, "DigiPower Manufacturing Inc." },
    { 17421, "H\0303\0264pital de la ville d'Esch-sur-Alzette" },
    { 17422, "Real Enterprise Solutions Development B.V." },
    { 17423, "Multidata Gesellschaft f\0303\0274r Datentechnik und Informatik mbH" },
    { 17424, "Chart Pilot Ltd." },
    { 17425, "ilink Kommunikationssysteme GmbH" },
    { 17426, "Sega.com, Inc." },
    { 17427, "ABYZ Inform\0303\0241tica LTDA" },
    { 17428, "WebDesign BK" },
    { 17429, "Michael Telecom AG" },
    { 17430, "TCL NETWORK EQUIPMENT (SHENZEHN) CO., LTD." },
    { 17431, "shenzhen SDG Information Co.,Ltd. STEC Telecom Branch" },
    { 17432, "Georgia Perimeter College" },
    { 17433, "pieas educational institute" },
    { 17434, "THERALYS" },
    { 17435, "BEAC" },
    { 17436, "Worlight International" },
    { 17437, "Insurance Corporation of British Columbia" },
    { 17438, "Novannet, LLC" },
    { 17439, "Panasonic Avionics Corporation (formerly 'Matsushita Avionics Systems Corporation')" },
    { 17440, "Omnipod, Inc." },
    { 17441, "Unholy.org" },
    { 17442, "Iter8 Inc." },
    { 17443, "Gerd Koslowski" },
    { 17444, "wrevak.net" },
    { 17445, "FEAS v.o.f." },
    { 17446, "Stefan Drees" },
    { 17447, "STATE MACHINE" },
    { 17448, "Fabrice Co." },
    { 17449, "KLS Air Express Inc." },
    { 17450, "WFW.org" },
    { 17451, "Unassigned" },
    { 17452, "Visy Industries Holdings Pty Ltd" },
    { 17453, "Billion Electric Co., Ltd." },
    { 17454, "Integuru Inc." },
    { 17455, "K-BEST TECHNOLOGY INC." },
    { 17456, "Jigsaw Systems" },
    { 17457, "UTi Worldwide" },
    { 17458, "Connect Internet Solutions PTY LTD" },
    { 17459, "Mibtree Ltd" },
    { 17460, "Revelant Technologies" },
    { 17461, "Pryde Systems and Software" },
    { 17462, "Akamai Technologies, Inc." },
    { 17463, "Demarc Security, Inc." },
    { 17464, "O1 Communications" },
    { 17465, "TruSystems, Inc" },
    { 17466, "Wooju Communications CO.,LTD." },
    { 17467, "Gamer's Valhalla Pty. Ltd." },
    { 17468, "ICONAG AG" },
    { 17469, "BioWisdom Ltd." },
    { 17470, "Str\0303\0245lfors AB" },
    { 17471, "Actona Technologies, Inc" },
    { 17472, "Tetraplex Ltd." },
    { 17473, "Telluce Corporation" },
    { 17474, "CRM-Informatik GmbH" },
    { 17475, "Genetec Information Systems" },
    { 17476, "V-ONE Corporation" },
    { 17477, "Trailblazer Systems Inc." },
    { 17478, "Nexadesic, Inc." },
    { 17479, "One Unified" },
    { 17480, "Choice Communications" },
    { 17481, "Logic Fusion" },
    { 17482, "Ogmios.ca" },
    { 17483, "Hong Kong School Net Ltd." },
    { 17484, "Adyoron Intelligent Systems Ltd." },
    { 17485, "HierWeb" },
    { 17486, "EDS Deutschland GmbH" },
    { 17487, "Manchester Airport" },
    { 17488, "GENERAL TOUCH TECHNOLOGY CO.,LTD" },
    { 17489, "Curtis Consulting LLC" },
    { 17490, "DM Trucking" },
    { 17491, "Barix AG" },
    { 17492, "Northco.net" },
    { 17493, "Halliburton Company" },
    { 17494, "Matthias Rath, Inc." },
    { 17495, "Gardel Software" },
    { 17496, "Canadian Broadcasting Corporation" },
    { 17497, "Tallinn School No. 21" },
    { 17498, "Kommunale Datenverarbeitung Oldenburg" },
    { 17499, "Packetsurge" },
    { 17500, "Georgia Gwinnett College" },
    { 17501, "Drake University" },
    { 17502, "Newfield Automation" },
    { 17503, "TechForge Software" },
    { 17504, "Security Wizard" },
    { 17505, "Wamin Optocomm Mfg.corporation" },
    { 17506, "Eulerian Technologies, Sarl" },
    { 17507, "omnidata" },
    { 17508, "Sotrange Transportes Rodovi\0303\0241rios Ltda." },
    { 17509, "Versatel Networks Inc." },
    { 17510, "GoldenHope" },
    { 17511, "XtremeX Corporation" },
    { 17512, "Flinders University" },
    { 17513, "RVA" },
    { 17514, "FDF, Frivilligt Drenge- og Pige-Forbund" },
    { 17515, "BNSF Railway Inc." },
    { 17516, "Nighthawk Radiology Services" },
    { 17517, "Clementi Software" },
    { 17518, "Comba Telecom System(Guang Zhou) Ltd." },
    { 17519, "InteliTrac, Inc." },
    { 17520, "Easton Technologies Inc." },
    { 17521, "RealEast Networks" },
    { 17522, "Ozitem" },
    { 17523, "FiberLan GmbH" },
    { 17524, "Ferrari electroni AG" },
    { 17525, "Amsterdam Internet Exchange B.V." },
    { 17526, "symentis GmbH" },
    { 17527, "FORMWARE GmbH" },
    { 17528, "KMS Internet Solution Providers Ltd" },
    { 17529, "FeldTech" },
    { 17530, "Chernigov State Technological University" },
    { 17531, "Henrico County Public Schools" },
    { 17532, "BSI Informatica Ltda" },
    { 17533, "Association KAZAR" },
    { 17534, "Optelecom Inc." },
    { 17535, "EGT Inc." },
    { 17536, "Telenity, Inc." },
    { 17537, "Florence Public School District One" },
    { 17538, "Village Grille Family Diner" },
    { 17539, "MXC Software" },
    { 17540, "TB-Solutions Advanced Technologies S.L." },
    { 17541, "Lamda Inc." },
    { 17542, "TFS Technology Inc" },
    { 17543, "ADUNEO" },
    { 17544, "BSP Partners GmbH" },
    { 17545, "Wirefree Innovision pvt ltd" },
    { 17546, "Magno Comunicacoes Ltda." },
    { 17547, "Centre for Good Governance" },
    { 17548, "Air2Web, Inc." },
    { 17549, "LogicLibrary Inc." },
    { 17550, "True Blade Systems, Inc." },
    { 17551, "Kmart Corporation" },
    { 17552, "NKI/AvL" },
    { 17553, "Telefonica Data Colombia S.A." },
    { 17554, "PODi - the Digital Printing initiative" },
    { 17555, "Webster University" },
    { 17556, "MAXINA GmbH" },
    { 17557, "Tokyo Woman's Christian University" },
    { 17558, "Moveo Systemy Teleinformatyczne" },
    { 17559, "The Art Institute of Chicago" },
    { 17560, "NETFORYOU CO.,LTD." },
    { 17561, "CLink" },
    { 17562, "Expect Technology" },
    { 17563, "ENCODE SA" },
    { 17564, "www.portocervo.cc" },
    { 17565, "Rural Servicios Inform\0303\0241ticos S. C." },
    { 17566, "EFG EUROBANK ERGASIAS A.E." },
    { 17567, "Certimail SA" },
    { 17568, "SLAT SA" },
    { 17569, "Schranzhofer DIAS" },
    { 17570, "IFS audiovisuals" },
    { 17571, "Glensound Electronics Ltd." },
    { 17572, "Mainframe Oy" },
    { 17573, "Secretaria das Finan\0303\0247as do Estado da Para\0303\0255ba" },
    { 17574, "Oxford Microsystems" },
    { 17575, "Lebenshilfe Niederoesterreich" },
    { 17576, "mahalingam & co." },
    { 17577, "Ralf Bisges Informationstechnik" },
    { 17578, "Berlitz International, Inc." },
    { 17579, "Groove Media" },
    { 17580, "Telefonica Data Colombia S.A." },
    { 17581, "Hofmann Software Engineering International" },
    { 17582, "Loran Technologie" },
    { 17583, "Information Technologies Australia Pty Ltd" },
    { 17584, "United Network Communication Corp." },
    { 17585, "Compusys" },
    { 17586, "BANDAI NETWORKS CO., LTD." },
    { 17587, "Laserbit Communications Corporation" },
    { 17588, "GLOBAL ELECTRICITY CO., LTD." },
    { 17589, "AMEC SPIE Communications" },
    { 17590, "Orbis Terrarum Networks" },
    { 17591, "The Defender Association" },
    { 17592, "Javacise Software" },
    { 17593, "eath Co.,Ltd." },
    { 17594, "Simitel S. de R.L. de C.V." },
    { 17595, "SEU" },
    { 17596, "DigiOnline GmbH" },
    { 17597, "IntraData BV" },
    { 17598, "Jouve SI" },
    { 17599, "Northern Alberta Institute of Technology" },
    { 17600, "CHUQ" },
    { 17601, "Group One Trading, LP" },
    { 17602, "Midnight Linux" },
    { 17603, "surespeed" },
    { 17604, "ScySoft Multimedia" },
    { 17605, "Jens Br\0303\0244uer" },
    { 17606, "helloWorld Inc." },
    { 17607, "RETIA, Inc" },
    { 17608, "GIE AGORA" },
    { 17609, "AZ Mercury Ltd." },
    { 17610, "Sadhu Software Services Pvt. Ltd." },
    { 17611, "eXc Software, LLC" },
    { 17612, "Groupe Caisse d'Epargne" },
    { 17613, "S-Access GMBH" },
    { 17614, "Queensland Parallel Supercomputing Foundation (QPSF)" },
    { 17615, "Ashway Software" },
    { 17616, "Exclusive Flor Sales Ltd." },
    { 17617, "MessageGate, Inc." },
    { 17618, "Ziniti.Net" },
    { 17619, "J Enterprise BV" },
    { 17620, "Mould Industria de Matrizes Ltda" },
    { 17621, "Lightwave Access, LLC" },
    { 17622, "OpenServe" },
    { 17623, "Millersville University" },
    { 17624, "Scouting Nederland" },
    { 17625, "Brightline Technology, Inc." },
    { 17626, "Phoenix Business Technologies Group, Inc." },
    { 17627, "Will Systems" },
    { 17628, "Mount Hay Technology" },
    { 17629, "NISHIMU ELECTRONICS INDUSTRIES CO., LTD." },
    { 17630, "Anana Ltd" },
    { 17631, "Oral Diagnostic Systems" },
    { 17632, "TPISACOM" },
    { 17633, "Phoenix Color Corporation" },
    { 17634, "AGB UK Limited" },
    { 17635, "DragonTail Online Security" },
    { 17636, "Novahead, Inc." },
    { 17637, "fudo.org" },
    { 17638, "JAJOK Ltd." },
    { 17639, "Abbeynet Srl" },
    { 17640, "Reifenberger" },
    { 17641, "Web Publications Pty Ltd" },
    { 17642, "PrintSoft Czech Republic" },
    { 17643, "Shanghai Neotune Information Technology Co.,Ltd." },
    { 17644, "Next Generation Broadband, LLC" },
    { 17645, "CBCA, Inc." },
    { 17646, "Contact Energy Ltd" },
    { 17647, "NTT Innovation Institute, Inc. (formerly 'NTT Multimedia Communications Laboratories, Inc.')" },
    { 17648, "Amat-SC, Service & Consulting" },
    { 17649, "PUMA AG" },
    { 17650, "ITSOFT" },
    { 17651, "necron-X" },
    { 17652, "McKesson IS France" },
    { 17653, "Moot Hall Holdings Limited" },
    { 17654, "Sheer Networks, Ltd." },
    { 17655, "Epsys" },
    { 17656, "Tohoku Ricoh Co., Ltd." },
    { 17657, "@tp-net e. K." },
    { 17658, "Thinklogical, Inc  (formerly 'Logical Solutions Inc.')" },
    { 17659, "The Lutheran University Association, Inc (d/b/a Valparaiso University)" },
    { 17660, "AStA Universitaet Potsdam" },
    { 17661, "Lincoln National Corporation" },
    { 17662, "Lucent EBS" },
    { 17663, "I.C.S. Industrielle Automatisierungssysteme GmbH" },
    { 17664, "Watkins Contracting" },
    { 17665, "IMAKE Software & Services" },
    { 17666, "New Jersey Hgiher Education Student Assistance Authority" },
    { 17667, "PCT-International, Inc." },
    { 17668, "American Medical Security" },
    { 17669, "VSL Catena" },
    { 17670, "Celliance Sarl." },
    { 17671, "PT. Mugi Rekso Abadi (Holding)" },
    { 17672, "MACH Software, Inc." },
    { 17673, "CERT-ONERA" },
    { 17674, "VT100" },
    { 17675, "Hill McGlynn & Associates Ltd" },
    { 17676, "nextevolution AG" },
    { 17677, "Tradition Financial Services Ltd" },
    { 17678, "Open X Tecnologia da Informacao Ltda" },
    { 17679, "Chapter Eight Ltd" },
    { 17680, "Dialup USA, Inc." },
    { 17681, "Johns Hopkins Bloomberg School of Public Health Center for Communication Programs" },
    { 17682, "BNX Systems Corporation" },
    { 17683, "Davis Polk & Wardwell" },
    { 17684, "Xi Software Ltd" },
    { 17685, "Dunes Technologies SA" },
    { 17686, "BF&M Insurance Group" },
    { 17687, "Teamwork Solutions, Inc." },
    { 17688, "O'Farrell Community School" },
    { 17689, "TJM Computing" },
    { 17690, "The University Of Newcastle" },
    { 17691, "i-Net Device Co.Ltd." },
    { 17692, "Torkild L\0303\0270mo" },
    { 17693, "Insitut de Recherche en Communication et Cybern\0303\0251tique de Nantes (IRCCyN)" },
    { 17694, "Elekta" },
    { 17695, "COM.BOX WINET GmbH & Co. KG" },
    { 17696, "GAD IT fuer Banken eG" },
    { 17697, "Sanderson Townend & Gilbert Ltd" },
    { 17698, "John Lewis PLC" },
    { 17699, "Japan Control Engineering, Co., Ltd." },
    { 17700, "PowerWallz Network Security Inc." },
    { 17701, "BAE Systems, CNIR" },
    { 17702, "SmartPants Media, Inc." },
    { 17703, "Rudjer Boskovic Institute" },
    { 17704, "Critical Telecom Corp." },
    { 17705, "Sovelto Oy" },
    { 17706, "Kidery" },
    { 17707, "The Meme Factory, Inc" },
    { 17708, "sysmango.com" },
    { 17709, "Shanghai Telecommnunications Technological Research Institute" },
    { 17710, "michael j van ham" },
    { 17711, "Aisai communication technology CO.,LTD" },
    { 17712, "TB-Solutions Technologies Software S.L." },
    { 17713, "Cambium Networks Limited (formerly 'PipingHot Networks Limited')" },
    { 17714, "ASM Enterprises" },
    { 17715, "Mitsukoshi Infomation Service Co.,Ltd." },
    { 17716, "Georgia Tech Foundation" },
    { 17717, "Escription, Inc." },
    { 17718, "Vanu, Inc." },
    { 17719, "Noldata Ltd." },
    { 17720, "Prompt" },
    { 17721, "AGL Resources Inc." },
    { 17722, "STEAG GmbH" },
    { 17723, "Softel SA de CV" },
    { 17724, "SinoCDN Ltd." },
    { 17725, "HW Termination Union" },
    { 17726, "Adva Technologies Ltd." },
    { 17727, "Wiplug" },
    { 17728, "AboveCable, Inc." },
    { 17729, "SPUeNTRUP Software" },
    { 17730, "RedDot Solutions AG" },
    { 17731, "CQS Technology Holdings (Pty) Ltd" },
    { 17732, "SNA lab,National Dong-Hwa university ,Hualien,Taiwan" },
    { 17733, "Delaware State University" },
    { 17734, "OC Systems, Inc." },
    { 17735, "Quark Communications, Inc." },
    { 17736, "Trading Metrics, Inc." },
    { 17737, "Tablus, Inc." },
    { 17738, "Tracey Bernath" },
    { 17739, "Embedded Technologies s.r.o." },
    { 17740, "iSecurity Technology Limited" },
    { 17741, "Open Enterprise Systems, Ltd." },
    { 17742, "Rootsr" },
    { 17743, "M-Web Business Solutions" },
    { 17744, "Dubex A/S" },
    { 17745, "Huntek Co., Ltd." },
    { 17746, "By Intertrade" },
    { 17747, "Nexagent Ltd." },
    { 17748, "Card Systems Consulting SRL" },
    { 17749, "TGC Ltd" },
    { 17750, "iTechnology GmbH" },
    { 17751, "Radio Systems Ltd." },
    { 17752, "Instituto Atl\0303\0242ntico" },
    { 17753, "MetroHealth Medical Center" },
    { 17754, "Alexander Pilger Consulting" },
    { 17755, "Lane Department of Computer Science and Electrical Engineering, West Virginia University" },
    { 17756, "science + computing ag" },
    { 17757, "Orthopedic Healthcare Northwest, P.C." },
    { 17758, "Trematon UK Ltd" },
    { 17759, "Synctomi, Inc." },
    { 17760, "Identify" },
    { 17761, "WiredPlace" },
    { 17762, "Covert Security Services Ltd" },
    { 17763, "Teske Netzwerkberatung" },
    { 17764, "Ditelco, LLC" },
    { 17765, "Tessna Private Limited" },
    { 17766, "PGP Corporation" },
    { 17767, "Schruth, LLC" },
    { 17768, "Ecobyte Limited" },
    { 17769, "Werft22 AG" },
    { 17770, "Cia Metropolitano de S\0303\0243o Paulo - Metr\0303\0264" },
    { 17771, "Lingard Knowledge Software Engineering" },
    { 17772, "Ironico Pty Ltd" },
    { 17773, "NEXCOM International Co.,LTD" },
    { 17774, "Smart Computer Systems Ltd" },
    { 17775, "INTOREL" },
    { 17776, "SIN solution" },
    { 17777, "JaserNet" },
    { 17778, "nic.at Internet Verwaltungs- und Betriebsgesellschaft m. b. H." },
    { 17779, "Econtec GmbH" },
    { 17780, "Truman Medical Centers, Inc." },
    { 17781, "University of Vale do Itajai - CES Sao Jose" },
    { 17782, "Michael Parker" },
    { 17783, "SeTel S.p.a." },
    { 17784, "Mitsubishi Electric Business Systems Co.,Ltd." },
    { 17785, "BONNA SABLA SA" },
    { 17786, "Frankendata GmbH & Co.KG" },
    { 17787, "tschaufrei" },
    { 17788, "EDAG GmbH & Co. KGaA" },
    { 17789, "sitharus.com internet services" },
    { 17790, "IPAD Owners Association" },
    { 17791, "Turoks.Net" },
    { 17792, "Billing Concepts, Inc." },
    { 17793, "Hong Kong Broadband Network Ltd." },
    { 17794, "EXARTECH International Corp." },
    { 17795, "Echo Communications" },
    { 17796, "EK Technology, Ltd." },
    { 17797, "PrimeScale AG" },
    { 17798, "Beijing Lingtu Software Co., LTD" },
    { 17799, "Eurovast Ltd." },
    { 17800, "Telephone Company Chereda" },
    { 17801, "tarent GmbH" },
    { 17802, "Egyptian Telephone Company" },
    { 17803, "iTechnology GmbH" },
    { 17804, "Towers Perrin" },
    { 17805, "Radio UNiCC e.V." },
    { 17806, "isw" },
    { 17807, "WELLX TELECOM S.A." },
    { 17808, "ACTCOM - Active Communication Ltd." },
    { 17809, "civil information security organisation" },
    { 17810, "GIE GETIMA" },
    { 17811, "Anixe Systems GmbH" },
    { 17812, "TLS-Technologie sp. z o.o." },
    { 17813, "iVAST Inc." },
    { 17814, "Boolean Systems, Inc." },
    { 17815, "Pollard Banknote Ltd." },
    { 17816, "Federated Systems Group" },
    { 17817, "Fuji Research Institute Corporation" },
    { 17818, "SAPPORO BREWERIES LTD." },
    { 17819, "GIP RENATER" },
    { 17820, "Foresttek Networks Limited" },
    { 17821, "Tempest spol. s r.o." },
    { 17822, "Easytouch Robert Redl KG (formerly 'EASYTOUCH Robert Divoky KEG')" },
    { 17823, "Arnes - Academic and Research Network of Slovenia" },
    { 17824, "Hisense Information Technology Ltd." },
    { 17825, "BEconnectIT GmbH" },
    { 17826, "ZerBit S.L." },
    { 17827, "Infostar Technology" },
    { 17828, "MetaTV Inc." },
    { 17829, "IDN Communication System Co.,Ltd" },
    { 17830, "SYRUS SYSTEMS" },
    { 17831, "TwinCats Production sprl" },
    { 17832, "Alphyra Nordic AB" },
    { 17833, "All for One Systemhaus AG" },
    { 17834, "C.N.S. Systems AB" },
    { 17835, "Magyar Telekom Nyrt. (formerly 'MAT\0303\0201V Rt.')" },
    { 17836, "Norbert Z\0303\0244nker & Kollegen" },
    { 17837, "Experimental Factory of Scientific Engineering" },
    { 17838, "JunCon" },
    { 17839, "Secureseal Systems Ltd." },
    { 17840, "KOITO INDUSTRIES, LIMITED" },
    { 17841, "bombini.net" },
    { 17842, "Ipsum Networks, Inc." },
    { 17843, "Concerto Software" },
    { 17844, "Orion Associates" },
    { 17845, "GeniServer Corporation" },
    { 17846, "Ocamar Technologies,Inc." },
    { 17847, "Mermit Business Applications Oy" },
    { 17848, "Qamcom Technology AB" },
    { 17849, "Neuroimage Nord" },
    { 17850, "Groupe Danone" },
    { 17851, "SPRINGWAVE,Inc." },
    { 17852, "The ProFTPD Project" },
    { 17853, "Heilpraktikerschule Luzern Ltd." },
    { 17854, "Twenty First Century Communications (TFCC)" },
    { 17855, "zipRealty, Inc." },
    { 17856, "NetNumber, Inc." },
    { 17857, "Tiscali France" },
    { 17858, "sonik.org" },
    { 17859, "Septier Communications Ltd." },
    { 17860, "Alembic, Inc." },
    { 17861, "Twise Labo Inc." },
    { 17862, "Kelly Martin" },
    { 17863, "dotOpen Pty Ltd" },
    { 17864, "Fudan GrandHorizon Information Technology, Inc." },
    { 17865, "eValley.VS" },
    { 17866, "GPS Applications, Inc." },
    { 17867, "C&M Fine Pack, Inc." },
    { 17868, "Codersnetwork.co.uk" },
    { 17869, "etherstack.com" },
    { 17870, "Bradford Technology Limited" },
    { 17871, "NexGen City" },
    { 17872, "iDOC K.K." },
    { 17873, "Gcom, Inc" },
    { 17874, "Michael F. Doyle" },
    { 17875, "Macromedia, Inc." },
    { 17876, "Factline Webservices GmbH." },
    { 17877, "Unassigned" },
    { 17878, "Journalistic, Inc." },
    { 17879, "Ask Software Corporation" },
    { 17880, "Robert Kurtys" },
    { 17881, "Profil Kft" },
    { 17882, "Costco Wholesale Corp." },
    { 17883, "CSS Versicherung" },
    { 17884, "Rocketseed" },
    { 17885, "Agarwal Associates Ltd" },
    { 17886, "bross ag" },
    { 17887, "Realtime Systems Limited" },
    { 17888, "Xor-Technologies" },
    { 17889, "Porsche Informatik GmbH" },
    { 17890, "JSC \"OSS Corporation\"" },
    { 17891, "MidAmerica Nazarene University" },
    { 17892, "Lumenar\0303\0251 Networks, Inc" },
    { 17893, "Cellent AG" },
    { 17894, "Airtria" },
    { 17895, "Keopsys" },
    { 17896, "TelePro C.S" },
    { 17897, "QUANTUM RADIONICS CORPORATION" },
    { 17898, "RISS (Regional Information Sharing Systems)" },
    { 17899, "mIstA Technologies" },
    { 17900, "Pivetal Ltd" },
    { 17901, "Koolspan, Inc." },
    { 17902, "Copeland Corporation" },
    { 17903, "Grouse Media" },
    { 17904, "boros consulting gmbh" },
    { 17905, "Aktion Kritischer Sch\0303\0274lerInnen Salzburg" },
    { 17906, "Folleville" },
    { 17907, "Kumashiro System Frontier Co., Ltd." },
    { 17908, "Tobias Punke" },
    { 17909, "Zandar Technologies" },
    { 17910, "Meridian VAT Processing (International) Ltd" },
    { 17911, "Mountain Area Information Network" },
    { 17912, "Jugendzentrum Kirchheim" },
    { 17913, "MacShed" },
    { 17914, "Escriban\0303\0255a de la Fuente" },
    { 17915, "Iris Media Ltd." },
    { 17916, "Istituto Tecnico Commerciale Cesare Battisti" },
    { 17917, "Computer-Essence" },
    { 17918, "Smart Systems Pty. Ltd." },
    { 17919, "Light Socket, Ltd." },
    { 17920, "C-Borne Co.,Ltd." },
    { 17921, "HALLE-DOT-COM Germany" },
    { 17922, "PinPoint Israel Ltd." },
    { 17923, "Tinext SA" },
    { 17924, "RatNet" },
    { 17925, "Dresdner Kleinwort Wasserstein" },
    { 17926, "Banco Nacional de Costa Rica" },
    { 17927, "Sana Security, Inc." },
    { 17928, "siikuls incorporated" },
    { 17929, "Synthetic Networks Inc" },
    { 17930, "SAGA University" },
    { 17931, "Diligent Technologies Corporation" },
    { 17932, "ZeCo GmbH" },
    { 17933, "Compulogic Limited" },
    { 17934, "Association of Teachers and Lecturers" },
    { 17935, "Videolarm, Inc." },
    { 17936, "Penn State Hershey Medical Center" },
    { 17937, "Lollipop Learning Ltd." },
    { 17938, "Unassigned" },
    { 17939, "Guangdong Province Electronic Technology Research Institute" },
    { 17940, "The University of Texas at Austin" },
    { 17941, "Web Fabric LLC" },
    { 17942, "ISN, Inc. D/B/A inSolutions" },
    { 17943, "Progressix" },
    { 17944, "Subrenat Expansion S.A." },
    { 17945, "Alpha Telecom Inc. USA" },
    { 17946, "Sinema Instruction" },
    { 17947, "Card Access Services Pty Ltd" },
    { 17948, "LV Power (2003) Ltd" },
    { 17949, "i-neda Ltd" },
    { 17950, "Endian" },
    { 17951, "Barnim.Net" },
    { 17952, "Scalent, Inc" },
    { 17953, "Advanced Clustering Technologies, Inc." },
    { 17954, "Voicenet Cyber Cafe" },
    { 17955, "Polytron Corporation" },
    { 17956, "NetCare" },
    { 17957, "Uniwide Technologies inc." },
    { 17958, "KAIYO DENSHI KOGYO Co., Ltd." },
    { 17959, "Accense Technology Inc." },
    { 17960, "ETRI" },
    { 17961, "Luottokunta" },
    { 17962, "Zandan" },
    { 17963, "CONI Servizi S.p.A." },
    { 17964, "Mairie de Pierrefitte-sur-Seine" },
    { 17965, "mediaskill OHG" },
    { 17966, "space2go GmbH" },
    { 17967, "Qovia, Inc" },
    { 17968, "Fortress Systems, Ltd." },
    { 17969, "OC4, LLC." },
    { 17970, "jSNMP Enterprises" },
    { 17971, "Authenti-Corp" },
    { 17972, "IntraMeta Corporation" },
    { 17973, "Terravox Technologie Inc" },
    { 17974, "JWM3, Inc." },
    { 17975, "World Radio Missionary Fellowship Inc." },
    { 17976, "ISI-ESM" },
    { 17977, "Rokeby Technologies Ltd." },
    { 17978, "Elfwerks" },
    { 17979, "HyperMedia Systems Ltd." },
    { 17980, "Oliver Huf" },
    { 17981, "Interacct Solutions(Australia)" },
    { 17982, "Clickerty-Click Ltd" },
    { 17983, "OutPostal Corporation" },
    { 17984, "SHENZHEN COSHIP SOFTWARE CO.,LTD." },
    { 17985, "kingsoft" },
    { 17986, "Systems Union (Shanghai) Ltd." },
    { 17987, "Vodafone Group Services Limited (formerly 'Cable & Wireless UK')" },
    { 17988, "PYLON R.I.S.C. GmbH" },
    { 17989, "petujek.net" },
    { 17990, "NEC Electronics Corporation" },
    { 17991, "Weldun, s.r.o." },
    { 17992, "Net Direct Inc." },
    { 17993, "Aware-Networks Ltda" },
    { 17994, "Mathematical Institute" },
    { 17995, "Asociaci\0303\0263n de Escribanos del Uruguay" },
    { 17996, "Alien Technology Corporation" },
    { 17997, "Artis Inc." },
    { 17998, "Vordel Ltd." },
    { 17999, "Rapsodie" },
    { 18000, "AGRICULTURAL BANK OF GREECE SA" },
    { 18001, "University of Cape Town" },
    { 18002, "Talisen Technologies" },
    { 18003, "Stichting Wireless Leiden (Foundation under Dutch Law)" },
    { 18004, "Micro Fort\0303\0251 Pty Ltd" },
    { 18005, "K.K. Alice" },
    { 18006, "cognitas GmbH" },
    { 18007, "Phonalyse BVBA" },
    { 18008, "Fachhochschule Mannheim HS f. Technik u. Gestaltung" },
    { 18009, "Outram Research Ltd" },
    { 18010, "Eastern Washington University" },
    { 18011, "Apollo Communications, International" },
    { 18012, "connectLOGIC" },
    { 18013, "DBL Technologies, Ltd." },
    { 18014, "Department of Electrical & Electronics Engineering" },
    { 18015, "Futarque A/S" },
    { 18016, "JBoss Group, LLC" },
    { 18017, "PUBLIC VOICE Lab - International Media Co-op" },
    { 18018, "Northwoods Catholic School" },
    { 18019, "On Q Holdings Pty Ltd" },
    { 18020, "Pacific Retail Group" },
    { 18021, "Construction Electronique et Telecommunication Internationnal" },
    { 18022, "Covaro Networks, Inc." },
    { 18023, "Tatung Science & Technology, Inc." },
    { 18024, "Cinergy Communications Company" },
    { 18025, "siWan GmbH & Co. KG" },
    { 18026, "Extron Electronics" },
    { 18027, "Battleaxe Technologies, Inc." },
    { 18028, "Battleaxe Technologies, Inc." },
    { 18029, "Sonic Foundry, Inc." },
    { 18030, "Molecular Therapeutics, Inc." },
    { 18031, "ATM Telecom" },
    { 18032, "matieux.net" },
    { 18033, "Viviale Ltd" },
    { 18034, "FrogNet, Inc." },
    { 18035, "Netsolus.com Inc." },
    { 18036, "United Telecoms Ltd" },
    { 18037, "Pramati Technologies Pvt Ltd" },
    { 18038, "Schotten & Marchart OEG" },
    { 18039, "Toyo Radiator Co., Ltd." },
    { 18040, "H.T.T.P. Planitis Communications Ltd." },
    { 18041, "pdv.com Beratungs-GmbH" },
    { 18042, "Meteksan Net" },
    { 18043, "FinanzIT GmbH" },
    { 18044, "Synelec Telecom Multimedia" },
    { 18045, "IMFORM GmbH" },
    { 18046, "Skellefte\0303\0245 kommun" },
    { 18047, "NeoLogica s.r.l." },
    { 18048, "SunGard Futures Systems" },
    { 18049, "Pixel Power Ltd" },
    { 18050, "Enterprise Products Integration Pte Ltd" },
    { 18051, "RF Systems Nachrichtentechnik GmbH" },
    { 18052, "FachschaftsvertreterInnenversammlung" },
    { 18053, "citecs GmbH" },
    { 18054, "Tenovis GmbH & Co. KG" },
    { 18055, "Unassigned" },
    { 18056, "Pioneer Digital Technologies, Inc." },
    { 18057, "Procondo GmbH" },
    { 18058, "Optimus Inc." },
    { 18059, "B2SCorp" },
    { 18060, "The Apache Software Foundation" },
    { 18061, "OCEAN DEVELOPMENT" },
    { 18062, "Jo Tankers AS" },
    { 18063, "Technetix BV (formerly 'Tratec Telecom b.v.')" },
    { 18064, "Marek Walther" },
    { 18065, "XOU Solutions Limited" },
    { 18066, "Planet Lauritsen" },
    { 18067, "PowerTech Information Systems AS" },
    { 18068, "hansmi.ch" },
    { 18069, "Fulfillment Plus" },
    { 18070, "BTI Photonic Systems" },
    { 18071, "Cendura  Corporation" },
    { 18072, "R-MEDIA" },
    { 18073, "hinegardner.org" },
    { 18074, "Kass Enterprises LLC" },
    { 18075, "Combridge Medical Information Corporation" },
    { 18076, "b1n" },
    { 18077, "Acasim Technologies, Inc." },
    { 18078, "Unassigned" },
    { 18079, "City I.T. (UK) Ltd" },
    { 18080, "BlueBoard Ltd." },
    { 18081, "Numa Technology Inc." },
    { 18082, "Midwest Independent Media Foundation" },
    { 18083, "European Society of Cardiology" },
    { 18084, "PharmXplorer" },
    { 18085, "Ciaolab Technologies Spa" },
    { 18086, "ProTelevision Technologies A/S" },
    { 18087, "Optare Solutions S.L." },
    { 18088, "Jackson" },
    { 18089, "Inovis Inc." },
    { 18090, "FrogNet, Inc." },
    { 18091, "CaboVerde" },
    { 18092, "Ssji Networks" },
    { 18093, "K-Opticom Corporation" },
    { 18094, "Kingdom LAN Network" },
    { 18095, "Beijing Neutron TeleCOM Co. Ltd." },
    { 18096, "Advanced Ceramics Research, Inc." },
    { 18097, "Sevilla Project" },
    { 18098, "alexander stensrud" },
    { 18099, "Amoke Networks Pvt. Ltd." },
    { 18100, "Descom Consulting Ltd." },
    { 18101, "Adaptive Mobile Security Ltd." },
    { 18102, "Leostream Corp" },
    { 18103, "Shanghai Helitech Telecommunication Co.,Ltd Neijing Technical Branch" },
    { 18104, "net-worked.co.uk" },
    { 18105, "Calyptix Security Corporation" },
    { 18106, "University of Iceland Computing Services" },
    { 18107, "EEG Enterprises, Inc." },
    { 18108, "PingID Network, Inc." },
    { 18109, "NeoSpire, inc." },
    { 18110, "Speakeasy, Inc." },
    { 18111, "A.I.C. Communications, Inc." },
    { 18112, "oDesk Corp." },
    { 18113, "Wanspot.com Inc." },
    { 18114, "Twotrees Technologies, LLC" },
    { 18115, "ICRISAT" },
    { 18116, "Node Computing Solutions" },
    { 18117, "HTK NetCommunication Oy (PHNet)" },
    { 18118, "New Voice International AG" },
    { 18119, "MONOPRIX" },
    { 18120, "Hyder Consulting PLC" },
    { 18121, "ObjectSource Software GmbH" },
    { 18122, "Universidade de Sao Paulo" },
    { 18123, "Pleasant Ridge Waldorf School" },
    { 18124, "Verticon, Inc." },
    { 18125, "End To End" },
    { 18126, "Quantum Internet Services, Inc." },
    { 18127, "Net Consequence GbR" },
    { 18128, "Komos" },
    { 18129, "Yorkshire Building Society" },
    { 18130, "CdC-Sagax" },
    { 18131, "Echoraith" },
    { 18132, "Fundaci\0303\0263n Universidad del Norte" },
    { 18133, "Genesis Networks and Communications, Inc." },
    { 18134, "CEPRI" },
    { 18135, "Nortel Networks Netas" },
    { 18136, "Delsyne Software srl" },
    { 18137, "Wegener Communications, Inc." },
    { 18138, "Adwise Ltd." },
    { 18139, "NTT FACILITIES,INC." },
    { 18140, "PetT Luxembourg" },
    { 18141, "RRZN, Leibniz Universitaet Hannover" },
    { 18142, "Gruender-AV" },
    { 18143, "Lindenaar" },
    { 18144, "Michael Vistein" },
    { 18145, "Agricultural Mineral Prospectors Inc." },
    { 18146, "PS Solutions Ltd." },
    { 18147, "TerraLuna" },
    { 18148, "cool.de" },
    { 18149, "B.I. Tecnologia Ltda" },
    { 18150, "Webage" },
    { 18151, "Pflug Datentechnik" },
    { 18152, "ezGet.net" },
    { 18153, "Software Engineering GmbH" },
    { 18154, "Telnet Media Ltd" },
    { 18155, "Stilpo Laboratories" },
    { 18156, "Great Pacific Industries Inc." },
    { 18157, "Willowglen MSC Berhad" },
    { 18158, "GATSWAY DATA COMMUNICATION TECHNOLOGY CO.,LTD." },
    { 18159, "Accordance Systems Inc." },
    { 18160, "SHENZHEN GBIT ELECTRONIC TECHNICAL LTD." },
    { 18161, "iPoint Ltd." },
    { 18162, "EYME Technologies Pvt. Ltd." },
    { 18163, "Commit; Oy" },
    { 18164, "Office of the Prime Minister" },
    { 18165, "VB Pros Oy / RS-Solutions" },
    { 18166, "Chalmege" },
    { 18167, "Integro Networks" },
    { 18168, "Infogate-Online Ltd" },
    { 18169, "DOTFLUX" },
    { 18170, "Inno.com" },
    { 18171, "Torchbox Ltd" },
    { 18172, "AP-WDSL GbR" },
    { 18173, "Ramanam Software Distributors Private Limited" },
    { 18174, "Wisconsin Department of Justice" },
    { 18175, "Araknos Srl" },
    { 18176, "Pikeville Methodist Hospital" },
    { 18177, "INPE" },
    { 18178, "Front Range Internet, Inc." },
    { 18179, "Quest Software, Inc. (formerly 'Vintela Inc.')" },
    { 18180, "UNIT Ltd." },
    { 18181, "Western Union Financial Services, Inc" },
    { 18182, "Ahold Information Services" },
    { 18183, "Systems Atlanta, Inc." },
    { 18184, "ackrium" },
    { 18185, "Rene van Rooyen" },
    { 18186, "Awacs ltd" },
    { 18187, "Linkwise Software(Shanghai) Co.,Ltd" },
    { 18188, "Torinet" },
    { 18189, "Direction G\0303\0251n\0303\0251rale des Imp\0303\0264ts" },
    { 18190, "dabs.com PLC" },
    { 18191, "Audiovision" },
    { 18192, "eSchoolOnline" },
    { 18193, "Ruban Consulting" },
    { 18194, "Bewer-Enterprises" },
    { 18195, "Xsec Srl" },
    { 18196, "Landeszahn\0303\0244rztekammer Sachsen" },
    { 18197, "Sony Communication Network Corporation" },
    { 18198, "Zemilogix, LLc" },
    { 18199, "Objective Data Storage" },
    { 18200, "Software Expedition" },
    { 18201, "Bestseller A/S" },
    { 18202, "Belatronix Kommunikation & EDV" },
    { 18203, "TC Electronic A/S" },
    { 18204, "HPD Software, LLC (formerly 'Computer And Software Enterprises, Inc.')" },
    { 18205, "Pioneer Industries, Inc." },
    { 18206, "iVolve Pty Ltd" },
    { 18207, "ANTs software inc." },
    { 18208, "TeleSym" },
    { 18209, "Midwest Radiology of Kentucky" },
    { 18210, "Agilis Communication Technologies Pte Ltd" },
    { 18211, "Catalina Computers & Discount" },
    { 18212, "A && L soft, s.r.o." },
    { 18213, "Voxsant Resources, Inc." },
    { 18214, "Olgierd Ziolko" },
    { 18215, "Metro Packet Systems, Inc." },
    { 18216, "AnyWeb AG" },
    { 18217, "Profium OY" },
    { 18218, "DIGORA" },
    { 18219, "Salten Bredband AS" },
    { 18220, "W en J" },
    { 18221, "SY Electronics Ltd" },
    { 18222, "Hopitaux Universitaires de Strasbourg" },
    { 18223, "W-OneSys S.L." },
    { 18224, "Dipl.-Inf. Carsten Dumke" },
    { 18225, "guenever.net" },
    { 18226, "imap4all B.V." },
    { 18227, "OpenCA" },
    { 18228, "University Of Stuttgart" },
    { 18229, "Sonitrol Security Systems of Hartford, Inc." },
    { 18230, "Conectium Limited" },
    { 18231, "Clear Reach Networks, Inc." },
    { 18232, "Equipos Telemo E.T. S.A." },
    { 18233, "HEC Montreal" },
    { 18234, "NetSrv Consulting Ltd" },
    { 18235, "Andreas Schulze" },
    { 18236, "McGill University" },
    { 18237, "IntelliVid Corporation" },
    { 18238, "SkyLink Design" },
    { 18239, "DTS, Inc. (formerly 'Digital Theater Systems, Inc')" },
    { 18240, "berger.de" },
    { 18241, "w3design" },
    { 18242, "Wyyzzk, Inc." },
    { 18243, "G&J FOSTER TECHNOLOGIES, INC." },
    { 18244, "Matisse Networks Inc" },
    { 18245, "Dishnet DSL Ltd." },
    { 18246, "Degussa AG" },
    { 18247, "IT&T s.r.l." },
    { 18248, "PaPouch elektronika" },
    { 18249, "Arcane Project" },
    { 18250, "TECHNOLOGIES RESEAUX & SOLUTIONS" },
    { 18251, "Beijing ACT Technology Co., Ltd." },
    { 18252, "Symmetrus Systems Ltd." },
    { 18253, "mVerify Corporation" },
    { 18254, "Mimezine" },
    { 18255, "Taller de Ideas (de C. Daniel Mojoli B.)" },
    { 18256, "Babcock & Wilcox Company (McDermott)" },
    { 18257, "KHAMSIN Security GmbH" },
    { 18258, "Binken.com" },
    { 18259, "CBTCBT Inc." },
    { 18260, "Bandapart.Net" },
    { 18261, "TigerByte" },
    { 18262, "Technicolor Media Asset Management" },
    { 18263, "Sanders Technology & Design" },
    { 18264, "ICT Group HHW" },
    { 18265, "Kestrel Technologies, Inc." },
    { 18266, "Dallas Genealogical Society" },
    { 18267, "NEOJAPAN, Inc." },
    { 18268, "SkyNet Network Security System Integration co.,Ltd." },
    { 18269, "Mapfre" },
    { 18270, "BANKSYS" },
    { 18271, "CIFOM-ESNIG" },
    { 18272, "Alerta Comunicaciones SAL" },
    { 18273, "French Senate" },
    { 18274, "Shenzhen Experiment School" },
    { 18275, "CIBERNET Corporation" },
    { 18276, "Lurcher Link" },
    { 18277, sminmpec_unknown },  /* (Added by Wireshark) */
    { 18278, "Columbus Metropolitan Library" },
    { 18279, "Rainer Fischer, EDV-Service" },
    { 18280, "NetTempo, Inc." },
    { 18281, "Bodacion Technologies, LLC." },
    { 18282, "Muttsoft, Inc" },
    { 18283, "Paraxip Technologies" },
    { 18284, "EXEMYS SRL" },
    { 18285, "Vidiator Technology Inc." },
    { 18286, "Assurent Software Inc." },
    { 18287, "InnoPath Software" },
    { 18288, "RABA Technologies LLC" },
    { 18289, "Router Management Solutions, Inc." },
    { 18290, "szeles tibor" },
    { 18291, "Ligfy" },
    { 18292, "Metis Oy" },
    { 18293, "Blackhawk Internet Communications Inc." },
    { 18294, "Cambridge University Press" },
    { 18295, "Applied Software Solutions, LLC" },
    { 18296, "Emigrant Savings Bank" },
    { 18297, "Symbium Corporation" },
    { 18298, "drugref.org" },
    { 18299, "Institute for International Ecomonic and Political Studies, Russian Academy of Sciences" },
    { 18300, "Xoba Inc." },
    { 18301, "Datacard Corporation" },
    { 18302, "Metroplex Webs" },
    { 18303, "Sollae Systems Co.,Ltd." },
    { 18304, "Douglas Needham" },
    { 18305, "North American Astrophysical Observatory" },
    { 18306, "Sichuan e-link Co., Ltd." },
    { 18307, "Eadiefleet Corporation" },
    { 18308, "aphona Kommunikationssysteme Entwicklungs- und VertriebsgmbH" },
    { 18309, "Einsle" },
    { 18310, "Heitec AG" },
    { 18311, "Linzies' computers" },
    { 18312, "Data Flow Systems" },
    { 18313, "Bodacion Technologies, LLC." },
    { 18314, "Canberra Industries" },
    { 18315, "McCormick & Company, Inc." },
    { 18316, "Ordination Med.-Rat Dr. Roesler" },
    { 18317, "Muttsoft, Inc" },
    { 18318, "Copel Telecomunica\0303\0247\0303\0265es S/A" },
    { 18319, "Asociaci\0303\0263n Nacional Ecum\0303\0251nica de Desarrollo" },
    { 18320, "Hydrologic Consultants, Inc of Colorado" },
    { 18321, "Universidad del Sagrado Corazon" },
    { 18322, "ITaCS GmbH" },
    { 18323, "Mindways Software, Inc." },
    { 18324, "Press Communications P/L" },
    { 18325, "Advanced Relay Corporation" },
    { 18326, "InfoGin Ltd." },
    { 18327, "42networks AB" },
    { 18328, "OpenMIND Networks Limited" },
    { 18329, "AMC Ltd." },
    { 18330, "Electrobusiness Connections Inc." },
    { 18331, "Huber S-Consulting GmbH" },
    { 18332, "ANF Autoridad de Certificaci\0303\0263n" },
    { 18333, "ANF AC Entidad de Certificaci\0303\0263n Per\0303\0272 S.A.C." },
    { 18334, "KONICA MINOLTA HOLDINGS, INC." },
    { 18335, "Melloul-Blamey Construction Inc." },
    { 18336, "Computer Logix" },
    { 18337, "creedon engineering" },
    { 18338, "Centrum voor Wiskunde en Informatica" },
    { 18339, "ANF AC MALTA, LTD." },
    { 18340, "Proquest Information and Learning" },
    { 18341, "The Institute for Open Systems Technologies Pty Ltd" },
    { 18342, "CEYONIQ Technology GmbH" },
    { 18343, "Performance Solutions Limited" },
    { 18344, "Intmain.Com" },
    { 18345, "Messagesoft Inc." },
    { 18346, "Sebastian Denef Computer Service" },
    { 18347, "MAUSER-Werke GmbH & Co. KG" },
    { 18348, "Avitech International Corp." },
    { 18349, "Luther Seminary" },
    { 18350, "Polva Central Library" },
    { 18351, "Velare Technologies Inc." },
    { 18352, "Sony Pictures Imageworks" },
    { 18353, "MAUSER-Werke GmbH & Co. KG" },
    { 18354, "Calyptech Pty Ltd" },
    { 18355, "Avitech International Corp." },
    { 18356, "kevinstevens.info" },
    { 18357, "Full Frontal Ingenuity LLC (formerly 'Leathern Apron Incorporated')" },
    { 18358, "EPITECH" },
    { 18359, "Intransa, Inc." },
    { 18360, "INTEC Web and Genome Informatics Corporation" },
    { 18361, "A3 Security Consulting Co., Ltd." },
    { 18362, "Hong Kong CSL Limited" },
    { 18363, "Epok, Inc." },
    { 18364, "Nezabudka" },
    { 18365, "Konzumbank Rt." },
    { 18366, "Applicata" },
    { 18367, "Nanoteq PTY LTD" },
    { 18368, "ComUnics Informatik GmbH" },
    { 18369, "Phoenix Zeppelin spol. s r.o." },
    { 18370, "Internet Consult SARL" },
    { 18371, "Pickering Interfaces Ltd" },
    { 18372, "BalaBit IT Ltd." },
    { 18373, "CSAS - Computer Systeme Arno Seidel" },
    { 18374, "Andri Saar" },
    { 18375, "Ruprecht-Karls-Universitaet Heidelberg" },
    { 18376, "ORGA Systems GmbH" },
    { 18377, "Universita` degli Studi di Trieste" },
    { 18378, "Eastern Kentucky University" },
    { 18379, "ExtraQuest, Corporation" },
    { 18380, "NEXTFOR S.A." },
    { 18381, "Suramericana de Seguros S.A." },
    { 18382, "Bank of Valletta plc" },
    { 18383, "Enterux Solutions" },
    { 18384, "Reflective Solutions Ltd." },
    { 18385, "Ecki Patang Org" },
    { 18386, "oshiire" },
    { 18387, "Litrius Group" },
    { 18388, "AstraZeneca" },
    { 18389, "Old Genie Hottabych Company" },
    { 18390, "MTS S.p.A." },
    { 18391, "Learning Objects Network Inc." },
    { 18392, "Applied Personal Computing, Inc." },
    { 18393, "Goblin" },
    { 18394, "Fred Chef Inc." },
    { 18395, "vivaxis SAS" },
    { 18396, "Dassault Aviation" },
    { 18397, "InfoSys" },
    { 18398, "jMind Consulting Ltd." },
    { 18399, "K/P Corporation" },
    { 18400, "Kommandoraden" },
    { 18401, "Xiqa Networks" },
    { 18402, "SecurityMetrics, Inc." },
    { 18403, "City of Chicago - Office of Budget Management" },
    { 18404, "United Nations Development Programme" },
    { 18405, "Redbird Informatics, Inc." },
    { 18406, "Internetworking Ltd." },
    { 18407, "Transcendence.net" },
    { 18408, "Association Ohana" },
    { 18409, "Planet A.S." },
    { 18410, "H\0303\0244me Polytechnic" },
    { 18411, "DataCenterTechnologies" },
    { 18412, "Epoch Design Ltd" },
    { 18413, "EGIM" },
    { 18414, "Imaginative IT Limited" },
    { 18415, "ELM Computer Technologies Ltd." },
    { 18416, "Victron bva" },
    { 18417, "Argon Technologies Inc." },
    { 18418, "Endace Technology" },
    { 18419, "glaven.org" },
    { 18420, "cerebrasoft" },
    { 18421, "tetera.org" },
    { 18422, "AetherStorm.com" },
    { 18423, "NetHarmonix, Inc." },
    { 18424, "MooreWare" },
    { 18425, "COMCO AG" },
    { 18426, sminmpec_unknown },  /* (Added by Wireshark) */
    { 18427, "Patrick N\0303\0244f" },
    { 18428, "American Registry for Internet Numbers" },
    { 18429, "IT Consulting & Education Ltd." },
    { 18430, "GenerationE Technologies LLC" },
    { 18431, "Stmk. Krankenanstalten GesmbH" },
    { 18432, sminmpec_unknown },  /* (Added by Wireshark) */
    { 18433, "deny all" },
    { 18434, "University of Leipzig" },
    { 18435, "Advanced Computer Systems, ACS S.P.A." },
    { 18436, "Bell Mobility" },
    { 18437, "W.I.S.V. Christiaan Huygens" },
    { 18438, sminmpec_unknown },  /* (Added by Wireshark) */
    { 18439, "Composite Software, Inc." },
    { 18440, "peerix" },
    { 18441, "National Football League" },
    { 18442, "Vimatix" },
    { 18443, "Netsys.IT GbR" },
    { 18444, "Sandwich.Net Internet Services" },
    { 18445, "Datacard Corporation" },
    { 18446, "Ascendant Technologies, Inc." },
    { 18447, "Willis Consulting" },
    { 18448, "Vanquish, Inc." },
    { 18449, "Alexander Gretha" },
    { 18450, "SevenL Networks Inc." },
    { 18451, "PC-Pool Physik, TU-Berlin" },
    { 18452, "Tempod" },
    { 18453, "The City Of Calgary" },
    { 18454, "OATSystems, Inc" },
    { 18455, "MEDICAL INFOMATION CO., LTD." },
    { 18456, "NetKlass Technology Inc." },
    { 18457, "European Directorate for the Quality of Medicines & HealthCare, Council of Europe (EDQM) (formerly 'European Directorate for the Quality of Medicines')" },
    { 18458, "Image Processing Techniques Ltd" },
    { 18459, "Semafor Informatik & Energie AG" },
    { 18460, "Powell Companies" },
    { 18461, "Osix Inc." },
    { 18462, "Lifetree Convergence Ltd" },
    { 18463, "Spektar JSC" },
    { 18464, "ROMATSA R.A." },
    { 18465, "TradeLink L.L.C." },
    { 18466, "Aviva Communications Inc." },
    { 18467, "AdvancePCS" },
    { 18468, "hughes network systems" },
    { 18469, "UNIS LUMIN INC." },
    { 18470, "Ingenieurbuero Michael Kappler" },
    { 18471, "e-Scripps" },
    { 18472, "Crystal Computer Corporation (Georgia)" },
    { 18473, "Form-IT" },
    { 18474, "Etype Co." },
    { 18475, "Research Institute of America" },
    { 18476, "Actinium Network Sdn Bhd" },
    { 18477, "Bundesministerium des Innern" },
    { 18478, "Wehay AB" },
    { 18479, "FS-VDSL" },
    { 18480, "RF-DESIGN" },
    { 18481, "Trustworx GmbH" },
    { 18482, "ARCWave Inc." },
    { 18483, "ROMATSA R.A." },
    { 18484, "ProcoliX" },
    { 18485, "Marietta College" },
    { 18486, "Quickshift, Inc." },
    { 18487, "Everbank" },
    { 18488, "Interbaun Communications, Inc." },
    { 18489, "CarrierComm, Inc." },
    { 18490, "Bolsa Nacional de Valores" },
    { 18491, "NII Voskhod" },
    { 18492, "Tacoma, spol.s r.o." },
    { 18493, "ProcoliX" },
    { 18494, "S.W.I.F.T. SCRL" },
    { 18495, "GRAU DATA  AG" },
    { 18496, "Rolotec AG" },
    { 18497, "gec UOC Group" },
    { 18498, "A&M Consulting Co" },
    { 18499, "PD3 Tecnologia em Redes e Sistemas Digitais" },
    { 18500, "Oddpost.com" },
    { 18501, "Code Fusion cc." },
    { 18502, "Mendel University of Agriculture and Forestry" },
    { 18503, "Intelli7 Inc." },
    { 18504, "Brainstorm Internet" },
    { 18505, "Tele-Consulting GmbH" },
    { 18506, "CAcert Inc." },
    { 18507, "Precise Time and Frequency, Inc." },
    { 18508, "MURASHITA CONSTRUCTION INDUSTRY CO., LTD." },
    { 18509, "IVK Smart Software Solutions LLC" },
    { 18510, "Reid Enterprises" },
    { 18511, "Centre Informatique Region Bruxelloise" },
    { 18512, "Schaake" },
    { 18513, "pete23.com" },
    { 18514, "BekArts International" },
    { 18515, "Nortech Management Ltd." },
    { 18516, "Eclipse Networking Limited" },
    { 18517, "Orbit Research Ltd" },
    { 18518, "Crea d.o.o." },
    { 18519, "Jahi Networks Inc." },
    { 18520, "APSI Inc." },
    { 18521, "TakeNET" },
    { 18522, "Unassigned" },
    { 18523, "Liverton Limited" },
    { 18524, "Empresa Metal\0303\0272rgica Central de Acero \"Jos\0303\0251 Valdes Reyes\"" },
    { 18525, "robinbowes.com" },
    { 18526, "Fisk Labs, Inc." },
    { 18527, "Maersk Data Organisator A/S" },
    { 18528, "Cetelem" },
    { 18529, "Swisscom-Eurospot" },
    { 18530, "NightCity.net" },
    { 18531, "DecisionPoint Applications, Inc." },
    { 18532, "The University of New Brunswick" },
    { 18533, "NTH A.G." },
    { 18534, "MCI" },
    { 18535, "Echostar Data Services" },
    { 18536, "Oolong project" },
    { 18537, "TAM Internet service Ltd." },
    { 18538, "R.L. Phillips, Inc." },
    { 18539, "flagwireless.com" },
    { 18540, "Webmeesters" },
    { 18541, "Roland Baum System Consult" },
    { 18542, "Sphinx Information Technologies Inc." },
    { 18543, "Innove Communications" },
    { 18544, "ecofinance" },
    { 18545, "Joint-stock company \"Trading System Administrator of Wholesale Electricity Market Transactions\"" },
    { 18546, "FAST Video Security AG" },
    { 18547, "Amanda Emily" },
    { 18548, "Relationalware" },
    { 18549, "Kealia Inc." },
    { 18550, "Gemplus do Brasil" },
    { 18551, "Anders Bystrup IT" },
    { 18552, "Firevue Security Systems" },
    { 18553, "Arachne Prime Inc." },
    { 18554, "Xenotropic Systems" },
    { 18555, "youneek organisation limited" },
    { 18556, "Zaurum ECP project" },
    { 18557, "Hurray!Solution Ltd." },
    { 18558, "WUSHIGONG Ltd." },
    { 18559, "Softpak International" },
    { 18560, "Makedonski Telekomunikacii, MTnet" },
    { 18561, "StarNIC" },
    { 18562, "Jazz Telecom, S.A." },
    { 18563, "DarkPhuture Technologies, Research & Development" },
    { 18564, "BFI-Burgenland" },
    { 18565, "SCHUH-TV" },
    { 18566, "Hogeschool Gent" },
    { 18567, "Epic Systems Corporation" },
    { 18568, "Service Availability Forum" },
    { 18569, "Ensequence, Inc." },
    { 18570, "GreenPulse Limited" },
    { 18571, "Mindhut Limited" },
    { 18572, "ORC" },
    { 18573, "Educate Inc." },
    { 18574, "Hush Communications Canada Inc." },
    { 18575, "Sagem Morpho, Inc." },
    { 18576, "Typosign AG" },
    { 18577, "Contemporary Cybernetics Group, Inc." },
    { 18578, "Eardown" },
    { 18579, "Clear Edge Networks LLC" },
    { 18580, "Whetstone Software" },
    { 18581, "SPD-Bundestagsfraktion" },
    { 18582, "Slack Ltd." },
    { 18583, "Bit 9 Inc." },
    { 18584, "Avanex  Co." },
    { 18585, "GuangDong Poson Company.Ltd" },
    { 18586, "bbassett.net" },
    { 18587, "Fortess Ltd." },
    { 18588, "Mekhanika-Service, Ltd." },
    { 18589, "GlobeTOM (Pty) Ltd" },
    { 18590, "Sterci SA" },
    { 18591, "HORUS HARDWARE S.A." },
    { 18592, "Universita' degli Studi di Milano-Bicocca" },
    { 18593, "Ministry of Finance, Tax Administration of the Republic of Slovenia" },
    { 18594, "Globalvision Media" },
    { 18595, "Berufsbildende Schulen I - Uelzen" },
    { 18596, "Professional Computers Services Organization" },
    { 18597, "HELIOS Software GmbH" },
    { 18598, "Firebox Internet Technologies" },
    { 18599, "Fachhochschule Hagenberg" },
    { 18600, "Marzek Etiketten GmbH" },
    { 18601, "Blue Mountains Grammer School" },
    { 18602, "MediaZen Corp." },
    { 18603, "Powercn" },
    { 18604, "Delta E.S., a.s." },
    { 18605, "RiS Gmbh" },
    { 18606, "Orbitel, Inc." },
    { 18607, "KLM Royal Dutch Airlines" },
    { 18608, "Synlogic AG" },
    { 18609, "JP.DIAS SERVI\0303\0207OS DE INFORMATICA LTD." },
    { 18610, "University at Buffalo" },
    { 18611, "Alenia Spazio S.p.A." },
    { 18612, "smspundit.com" },
    { 18613, "CGL Consulting" },
    { 18614, "Albert White Technologies" },
    { 18615, "North American Networks Corporation" },
    { 18616, "nextWLAN Corporation" },
    { 18617, "Timestock, Inc." },
    { 18618, "Publi Van Dyck N.V." },
    { 18619, "web-m GbR" },
    { 18620, "Jaw Networks" },
    { 18621, "Hinson and Associates" },
    { 18622, "K-n-A Ltd." },
    { 18623, "micro systems" },
    { 18624, "Lehrstuhl fuer Technische Dienstleistungen" },
    { 18625, "UniVision (Canada) Ltd." },
    { 18626, "UNET BV" },
    { 18627, "Bakasquared" },
    { 18628, "Microelectronics Technology Inc." },
    { 18629, "Iclass Co. Ltd." },
    { 18630, "Reeuenta Design Service Taiwan Ltd." },
    { 18631, "DARG" },
    { 18632, "SA SST Informatique" },
    { 18633, "STATER" },
    { 18634, "Advanced Software Production Line, S.L." },
    { 18635, "m-otion GmbH" },
    { 18636, "UVT s.r.o." },
    { 18637, "JNS Inc." },
    { 18638, "Avedya" },
    { 18639, "Kinnikinnick Foods Inc." },
    { 18640, "Digital Envoy, Inc" },
    { 18641, "Royal Military College of Canada" },
    { 18642, "C&C Power, Inc." },
    { 18643, "Montgomery County Government" },
    { 18644, "Daniel Skadlubowicz" },
    { 18645, "Cesart Creation inc." },
    { 18646, "Electric Mail Co." },
    { 18647, "DEXTER COMMUNICATIONS, INC." },
    { 18648, "HTU Graz" },
    { 18649, "Magnet.ch AG" },
    { 18650, "Projectiondesign AS" },
    { 18651, "GLANCE AG" },
    { 18652, "Zentrum f\0303\0274r Bioinformatik, Hamburg" },
    { 18653, "Eraia srl" },
    { 18654, "Scottish Police Authority (formerly 'Central Scotland Police')" },
    { 18655, "IUNDS AG" },
    { 18656, "AirRunner Technologies" },
    { 18657, "GoldenGate Software, Inc." },
    { 18658, "Xcitel Ltd." },
    { 18659, "Chung Hua University" },
    { 18660, "WebKMS" },
    { 18661, "Elitech Information Technology Co.,Ltd." },
    { 18662, "Mathias Kettner" },
    { 18663, "Laakirchen Papier AG" },
    { 18664, "IPnP" },
    { 18665, "Axelero Internet Szolg\0303\0241ltat\0303\0263 Rt." },
    { 18666, "Payroll Sweden AB" },
    { 18667, "HBware" },
    { 18668, "freshmeat.net, part of OSDN, Inc." },
    { 18669, "Memorial Hermann healthcare System" },
    { 18670, "General Atomics" },
    { 18671, "Knovative, Inc." },
    { 18672, "Secured Computer Concepts" },
    { 18673, "Webjorn Data & Natverkskonsult" },
    { 18674, "telecomSoftware" },
    { 18675, "Strategy & Technology ltd" },
    { 18676, "LEOFOO DEVELOPMENT CO., LTD" },
    { 18677, "Datenzentrale Baden-Wuerttemberg" },
    { 18678, "Winston Industries" },
    { 18679, "Behr Internet Solutions, Inc." },
    { 18680, "Con Edison Communications" },
    { 18681, "Travelping GmbH" },
    { 18682, "Dr. Brunthaler IITech GmbH" },
    { 18683, "CJ Ltd." },
    { 18684, "Davey Control Systems" },
    { 18685, "Portal M\0303\0274nchen GmbH & Co. KG" },
    { 18686, "InControl Technology Inc" },
    { 18687, "Information Flow" },
    { 18688, "IU.TV Ltd" },
    { 18689, "Neonetix, LLC." },
    { 18690, "Healthlink Limited" },
    { 18691, "Bussi" },
    { 18692, "Katana Technology, Inc." },
    { 18693, "NDS Media Solutions" },
    { 18694, "isometry.net" },
    { 18695, "Soluciones Telematicas Avanzadas S.L." },
    { 18696, "Idiom Communications LLC" },
    { 18697, "Syniverse Technologies Asia Pacific Limited (formerly 'IVRS (International) Limited')" },
    { 18698, "Tonghua Wanghang Information & Technology Co.,Ltd." },
    { 18699, "DAPYXIS NETWORK LIMITED" },
    { 18700, "ACOM CO.,LTD" },
    { 18701, "Minplan" },
    { 18702, "REUTERS S.A." },
    { 18703, "Siix d.o.o." },
    { 18704, "Institute of Mathematics of the Romanian Academy" },
    { 18705, "Dynamix Promotions Limited" },
    { 18706, "Corporacion Aceros Arequipa S.A." },
    { 18707, "Muskingum College" },
    { 18708, "Guardium Inc." },
    { 18709, "INOTESKA s.r.o." },
    { 18710, "Kaytec Ltd." },
    { 18711, "Burger Knowledge Consultancy" },
    { 18712, "Ajin Techline co., Ltd" },
    { 18713, "FH JOANNEUM Gesellschaft mbH" },
    { 18714, "Lanzhou University of Technology" },
    { 18715, "Grand Electronic Co.,Ltd." },
    { 18716, "Grand Electronic Co.,Ltd." },
    { 18717, "UCB SA/NV" },
    { 18718, "Association of Hellenic Internet Users" },
    { 18719, "O2 Ltd" },
    { 18720, "FarSite Communications Limited" },
    { 18721, "EMICT Ltd." },
    { 18722, "Universidade Federal do Parana" },
    { 18723, "Digicast Networks Inc" },
    { 18724, "EDJ Enterprises, Inc." },
    { 18725, "Paycom Billing Services, Inc." },
    { 18726, "Isala Klinieken" },
    { 18727, "Apollo Group, Inc." },
    { 18728, "Unassigned" },
    { 18729, "RB Holdings" },
    { 18730, "C&A srl" },
    { 18731, "INGENIERIA DE SISTEMAS MULTIAGENTE, S.L." },
    { 18732, "Horner Brothers Print Group" },
    { 18733, "Magnifire Networks" },
    { 18734, "Wildher ICT Solutions" },
    { 18735, "Hayes Lemmerz International" },
    { 18736, "Ertius Consulting" },
    { 18737, "Northrop Grumman" },
    { 18738, "DjE" },
    { 18739, "CraftAnalogy, Inc." },
    { 18740, "J. S. Thrower and Associates Ltd." },
    { 18741, "Leurck Software" },
    { 18742, "SACEM" },
    { 18743, "Entrada Internet Systems, Inc." },
    { 18744, "Idea Tec Sahar (ITS) Ltd" },
    { 18745, "ERANET srl" },
    { 18746, "Matsushita Electric Europe" },
    { 18747, "American Fibertek, Inc." },
    { 18748, "Engelschall" },
    { 18749, "The OpenPKG Project" },
    { 18750, "solar" },
    { 18751, "IPDeliver Inc." },
    { 18752, "Financial Engines, Inc." },
    { 18753, "Adelphia Communications" },
    { 18754, "University of Wisconsin - Parkside" },
    { 18755, "MavriQ Technologies, LLC" },
    { 18756, "Michal Charvat" },
    { 18757, "United Systems Access Inc." },
    { 18758, "Stordyne Corporation" },
    { 18759, "Netlink Technology Ltd." },
    { 18760, "Guangdong Electronic Certification Authority" },
    { 18761, "Regal Cyber Limited" },
    { 18762, "Sumtech Inc" },
    { 18763, "TheNetWerk" },
    { 18764, sminmpec_unknown },  /* (Added by Wireshark) */
    { 18765, "Comtel Electronics GmbH" },
    { 18766, "Procitec GmbH" },
    { 18767, "Kaba Management + Consulting AG" },
    { 18768, "Virtual Royal Danish Air Force" },
    { 18769, "University Computer Center (URC) Banja Luka" },
    { 18770, "SUNCOM Systems" },
    { 18771, "The Salvage Association" },
    { 18772, "Microbus plc" },
    { 18773, "Internet  Creation Co.,Ltd." },
    { 18774, "Banca Monte dei Paschi di Siena S.p.A." },
    { 18775, "Neuronenwerk" },
    { 18776, "eAcceleration Corp" },
    { 18777, "Thomas Luzat IT-Services" },
    { 18778, "ARCANE NETWORKS" },
    { 18779, "Synergy Information Services, Inc." },
    { 18780, "ANSES" },
    { 18781, "Zagamma Labs" },
    { 18782, "Rozhled.cz" },
    { 18783, "Interwoven, Inc." },
    { 18784, "Great Clips, Inc." },
    { 18785, "Collation Inc." },
    { 18786, "Global-Arts" },
    { 18787, "Clubhaus PLC" },
    { 18788, "MyNym" },
    { 18789, "Pro QC International Ltd" },
    { 18790, "EcGuard Technology Co. Ltd." },
    { 18791, "Chatchalerm Namwongprom" },
    { 18792, "HORIBA Europe Automation Division GmbH" },
    { 18793, "Norske Skogindustrier ASA" },
    { 18794, "Uni Regensburg" },
    { 18795, "ASPLinux" },
    { 18796, "Horizon.Net S.A" },
    { 18797, "Lunics GmbH" },
    { 18798, "digital design GmbH" },
    { 18799, "Layer14" },
    { 18800, "WRK Computer Systems" },
    { 18801, "Forrest Aldrich" },
    { 18802, "AUCONET GmbH" },
    { 18803, "MEDCOM sp. z o.o." },
    { 18804, "Advisec AB" },
    { 18805, "Struktuur Meedia" },
    { 18806, "Calm Computer Corp." },
    { 18807, "MAPLE NETWORKS Co.,Ltd" },
    { 18808, "Fondation pour l'institut de hautes \0303\0251tudes internationales et du d\0303\0251veloppement (formerly 'Graduate Institute of International and Development Studies')" },
    { 18809, "NetLink Consulting LLC" },
    { 18810, "Inotera Memories Inc." },
    { 18811, "Colgate-Palmolive Company" },
    { 18812, "Sageway Computer Solutions Pte Ltd" },
    { 18813, "DEMARINA SDN. BHD." },
    { 18814, "RoCNet Linux-Services" },
    { 18815, "ConD GmbH" },
    { 18816, "Andrea Fino" },
    { 18817, "Ethernet Powerlink Standardisation Group (EPSG)" },
    { 18818, "Dinsa Soluciones" },
    { 18819, "Pardes Group SA" },
    { 18820, "RAMCS" },
    { 18821, "m-Wise UK Ltd." },
    { 18822, "FOTEK ,Ltd." },
    { 18823, "COM-PAN s.c." },
    { 18824, "av" },
    { 18825, "Topio, Inc." },
    { 18826, "PSA Corporation Limited" },
    { 18827, "LOBOK - projects" },
    { 18828, "danet GmbH" },
    { 18829, "COM.BOX Internet Service GmbH" },
    { 18830, "Jingo Digital" },
    { 18831, "InFormaL" },
    { 18832, "Universit\0303\0244t Potsdam" },
    { 18833, "MICROTROL SRL" },
    { 18834, "Competitionhill" },
    { 18835, "Government of the District of Columbia" },
    { 18836, "Flathead Valley Community College" },
    { 18837, "Spectracom Corporation" },
    { 18838, "AEAT" },
    { 18839, "Data Consulting Group, Inc." },
    { 18840, "Milwaukee Public Schools" },
    { 18841, "Acorn Packet Solutions" },
    { 18842, "Linuxl\0303\0266sungen Michael R\0303\0266\0303\0237ler" },
    { 18843, "CPR Software LLC" },
    { 18844, "Triacta Power Technologies, Inc." },
    { 18845, "eCartsoft.com" },
    { 18846, "State of Tennessee" },
    { 18847, "Objectpark Software GbR" },
    { 18848, "UIS Abler Electronics Corp. Ltd." },
    { 18849, "OneDataCentral" },
    { 18850, "CoSystems, Inc." },
    { 18851, "Association DSPNet" },
    { 18852, "Gerdes Aktiengesellschaft" },
    { 18853, "EURILOGIC Technologies" },
    { 18854, "Axiliance" },
    { 18855, "Beijing Fibridge Co., Ltd." },
    { 18856, "Monitor Electronics Ltd" },
    { 18857, "dh computersysteme" },
    { 18858, "RDR Technologies LLC" },
    { 18859, "PaX AG" },
    { 18860, "Friends of the Earth International" },
    { 18861, "Educational Standards and Certifictations Inc." },
    { 18862, "WillMedia Corp." },
    { 18863, "Sisters of Charity Health Service" },
    { 18864, "Touring Club Suisse (TCS)" },
    { 18865, "Turunch Technologies" },
    { 18866, "White & Stover Innovations, LLC" },
    { 18867, "Meetinghouse Data Communications" },
    { 18868, "InterNiche Technologies Inc" },
    { 18869, "University of Helsinki" },
    { 18870, "OpsPoint" },
    { 18871, "FirstAttribute AG" },
    { 18872, "The Groovy Corporation" },
    { 18873, "Works Operating Company" },
    { 18874, "S & S Professionals, Inc." },
    { 18875, "Scorpion Software Corp." },
    { 18876, "TEVRON, LLC" },
    { 18877, "Darwin Solutions LLC" },
    { 18878, "Asschem" },
    { 18879, "LinuxHeaven" },
    { 18880, "American Museum of Natural History" },
    { 18881, "Prometeia Srl" },
    { 18882, "Adventist International Institute of Advanced Studies (AIIAS)" },
    { 18883, "Projektgroup LDAP University of Siegen" },
    { 18884, "Shanghai Sansi Technology Co., Ltd." },
    { 18885, "geeks.pl" },
    { 18886, "PFU LIMITED" },
    { 18887, "University of Massachusetts Boston CPCS" },
    { 18888, "Guoxin Telecom System Ltd" },
    { 18889, "\"Arhangelsk Television Company\" Ltd." },
    { 18890, "Integrated Communication Technologies" },
    { 18891, "The Closed Joint-Stock Company ?DeltaBank\0302\0246" },
    { 18892, "GEMMA Systems, spol. s r.o." },
    { 18893, "SMS Siemag AG" },
    { 18894, "Technische Fachhochschule Wildau" },
    { 18895, "Moravska zemska knihovna" },
    { 18896, "Esilog Consulting, S.L." },
    { 18897, "Cellopoint International Corporation" },
    { 18898, "Freie Universitaet Berlin (FU-Berlin)" },
    { 18899, "Isvara" },
    { 18900, "evosoft GmbH" },
    { 18901, "Capital Lease GmbH" },
    { 18902, "Aetat" },
    { 18903, "MANDOZZI ELETTRONICA S.A." },
    { 18904, "Propylon" },
    { 18905, "Total Card, Inc." },
    { 18906, "stefi" },
    { 18907, "Pironet NDH AG" },
    { 18908, "Inpriva, Inc." },
    { 18909, "Service Management Software" },
    { 18910, "Bombardier Transportation Inc." },
    { 18911, "Professional Data Management Again Inc." },
    { 18912, "N-able Technologies Inc." },
    { 18913, "Statna pokladnica" },
    { 18914, "Empneusis Internet Services" },
    { 18915, "Nautronix Ltd" },
    { 18916, "Shanghai TransEngines Technologies Co.,Ltd" },
    { 18917, "Shanghai Futures Exchange" },
    { 18918, "Bringe Informationstechnik GmbH" },
    { 18919, "Alfa21 Outsourcing, S.L." },
    { 18920, "Agencia Notarial de Certificacion" },
    { 18921, "NextiraOne Deutschland GmbH" },
    { 18922, "Trellis Tecnologia Ltda." },
    { 18923, "Yamaguchi University" },
    { 18924, "Relston Consulting Limited" },
    { 18925, "Prior" },
    { 18926, "JTT \"Novel-IL\"" },
    { 18927, "tandav enterprises" },
    { 18928, "Areca Technology Corporation" },
    { 18929, "Interwise, Inc." },
    { 18930, "Skyx.Org" },
    { 18931, "DaveLinux" },
    { 18932, "Naeilnet Inc." },
    { 18933, "ActivNetworks" },
    { 18934, "Vivex GmbH" },
    { 18935, "Essex Electronics, Inc." },
    { 18936, "National Institute of Advanced Industrial Science and Technology" },
    { 18937, "Lynk" },
    { 18938, "Rubix Information Technologies, Inc." },
    { 18939, "Retail Decisions Inc." },
    { 18940, "Kristopher Johnson Consulting" },
    { 18941, "Vermont State Colleges" },
    { 18942, "Liquid Computing Corporation" },
    { 18943, "HealthPartners" },
    { 18944, "nethype GmbH" },
    { 18945, "Dynamic Infosystems Ltd." },
    { 18946, "Digital Species Ltd" },
    { 18947, "CANOPEE SECURITY" },
    { 18948, "Sonatel Multim\0303\0251dia" },
    { 18949, "Golden Eagle Enterprises Ltd" },
    { 18950, "LAN Force Inc." },
    { 18951, "Fast Lane Institute for Knowledge Transfer GmbH" },
    { 18952, "Prudential Finanical" },
    { 18953, "Altkom Akademia S.A." },
    { 18954, "Brandywine Communciations" },
    { 18955, "Digital Identity Ltd." },
    { 18956, "Trusted Network Technologies, Inc." },
    { 18957, "Robert's Computer & Electrical Service" },
    { 18958, "EZNETSOFT" },
    { 18959, "sichuan normal university" },
    { 18960, "Larsen & Toubro Infotech Ltd" },
    { 18961, "Auditor revizijska druzba d.o.o., Ptuj" },
    { 18962, "LRP" },
    { 18963, "EDN Sovintel" },
    { 18964, "ELEKTRONIK HENGARTNER AG" },
    { 18965, "Netyantra Inc." },
    { 18966, "Unassigned" },
    { 18967, "Oxford County Telephone and Telegraph Company" },
    { 18968, "012 goldenlines Ltd" },
    { 18969, "University of Maryland Baltimore" },
    { 18970, "Expert SA" },
    { 18971, "G&S Sistemas de Informaci\0303\0263n, S.L." },
    { 18972, "Panama Canal Authority" },
    { 18973, "TuXic.nl" },
    { 18974, "Universal Business Matrix, LLC" },
    { 18975, "BRG16" },
    { 18976, "Badger Alarm and Control, LLC" },
    { 18977, "NIC-IQ Ltd" },
    { 18978, "CXO Systems Inc." },
    { 18979, "EVERYWHERECOMMUNICATIONS.NET" },
    { 18980, "Cypak AB" },
    { 18981, "Reserved" },
    { 18982, "Link-Yug Ltd." },
    { 18983, "AOK Sachsen" },
    { 18984, "Magos Consulting, Ltd." },
    { 18985, "Insinova AG" },
    { 18986, "FleetBoston Financial Corporation" },
    { 18987, "Ralf Meister" },
    { 18988, "Shanghai Eastimage Equipments Co.,LTD" },
    { 18989, "Day Dreams And Information Technologies" },
    { 18990, "CNC a.s." },
    { 18991, "IOP Publishing Ltd" },
    { 18992, "WEBForce GmbH" },
    { 18993, "ObjectFusion, L.L.C." },
    { 18994, "Olix" },
    { 18995, "CommSpeed, LLC" },
    { 18996, "Globix Corporation" },
    { 18997, "Ibrix Corp." },
    { 18998, "Redstone Consulting, LLC" },
    { 18999, "Health Management Corporation" },
    { 19000, "Dongyang Telecom Ltd." },
    { 19001, "Research Center of Computational Mechanics, Inc." },
    { 19002, "Sun Yat-sen (Zhongshan) University" },
    { 19003, "SENAS.NET" },
    { 19004, "CreationPoint Systems, Inc." },
    { 19005, "AdytumSolutions, Inc." },
    { 19006, "Polish Professional Publishers Ltd." },
    { 19007, "3C Systems Oy" },
    { 19008, "GateHouse" },
    { 19009, "Clever IT di Ivan Raimondi" },
    { 19010, "Bluetop Technology Co., Ltd." },
    { 19011, "Jacarta Ltd." },
    { 19012, "Net Evidence (SLM) Ltd" },
    { 19013, "Sonario" },
    { 19014, "Magix s.r.o." },
    { 19015, "oulman.org" },
    { 19016, "Scholl Consulting" },
    { 19017, "XTEND Consulting, LLC" },
    { 19018, "Dandre" },
    { 19019, "Coastal Carolina University" },
    { 19020, "ryanscool" },
    { 19021, "Ensemble Designs, Inc." },
    { 19022, "Invocom Ltd." },
    { 19023, "LMU" },
    { 19024, "Bixby Telephone Company" },
    { 19025, "OSLiNK Spolka z o.o." },
    { 19026, "Dirk Gorny Unternehmensberatung" },
    { 19027, "TriAWorks, Inc." },
    { 19028, "Sputnik, Inc." },
    { 19029, "Nittotsushinki Co.,Ltd." },
    { 19030, "Suva" },
    { 19031, "LogIn S&C GmbH" },
    { 19032, "Apollis AG" },
    { 19033, "Moniforce B.V." },
    { 19034, "3SP, Investiga\0303\0247\0303\0243o e Desenvolvimento de Tecnologias, Lda." },
    { 19035, "Omnirei s.r.l." },
    { 19036, "Etherboot Project" },
    { 19037, "Bolsa Nacional de Valores" },
    { 19038, "WebNet, Ltd" },
    { 19039, "National Research Center for High Performace Computers" },
    { 19040, "Trusted Computer Solutions, Inc." },
    { 19041, "Apparent Networks Inc." },
    { 19042, "ACBR Computadores Ltda." },
    { 19043, "XiTrust Secure Technologies GmbH" },
    { 19044, "JSC \"Kredyt Bank (Ukrajina)\"" },
    { 19045, "MyNetwork System Co.,Ltd" },
    { 19046, "Lenovo Enterprise Business Group" },
    { 19047, "Magerealm Enterprises" },
    { 19048, "Fambus" },
    { 19049, "Scalix Corporation" },
    { 19050, "Conchis, LLC" },
    { 19051, "Martin Thorpe" },
    { 19052, "Seekamp Enterprises" },
    { 19053, "KUBOTEK Corporation" },
    { 19054, "Intraperson" },
    { 19055, "Naviscan PET Systems, Inc." },
    { 19056, "Access Computech Pvt Ltd." },
    { 19057, "Exavio, Inc." },
    { 19058, "BISON Systems AG" },
    { 19059, "moreCom A/S" },
    { 19060, "UXComm" },
    { 19061, "Werner Wiethege" },
    { 19062, "Tuxee Network" },
    { 19063, "Alterlane" },
    { 19064, "Bureau Ing\0303\0251nierie Richard Domon SA" },
    { 19065, "PETIT-FR" },
    { 19066, "Macnetix OHG" },
    { 19067, "Universidade Cat\0303\0263lica Portuguesa" },
    { 19068, "Travel Only" },
    { 19069, "xenocastle" },
    { 19070, "Kevcom Microsolutions" },
    { 19071, "I-Assure" },
    { 19072, "Magnasync" },
    { 19073, "Sundowner Trailers Inc" },
    { 19074, "Fidelis Security Systems, Inc" },
    { 19075, "Po\0305\0241tna banka Slovenije, d. d." },
    { 19076, "xenocastle" },
    { 19077, "Xing-Lab" },
    { 19078, "Fujitsu Component Limited" },
    { 19079, "Silicon Data International Co., Ltd." },
    { 19080, "Tsukasa Enterprise" },
    { 19081, "Wuhan Jetway Information Security Industry Co.,Ltd" },
    { 19082, "Voelcker Informatik AG" },
    { 19083, "Albanet Ltd" },
    { 19084, "Mimic Productions" },
    { 19085, "The Davidge Group" },
    { 19086, "Maytech Publishing Ltd" },
    { 19087, "NTx BackOffice Consulting Group GmbH" },
    { 19088, "Maersk Data SPECTIVE" },
    { 19089, "Infor.org Inc. Taiwan" },
    { 19090, "Bernhard-Riemann-Gymnasium Scharnebeck" },
    { 19091, "NuGenesis Technologies, Inc" },
    { 19092, "Exa Networks Ltd" },
    { 19093, "Hofsvang" },
    { 19094, "peerVue LLC" },
    { 19095, "TiL Solutions inc." },
    { 19096, "info2cell.com FZ-LLC" },
    { 19097, "DefaultCity" },
    { 19098, "PAL Communications" },
    { 19099, "Whitewater Mobile LLC" },
    { 19100, "OHANA WIRELESS INCORPORATED" },
    { 19101, "Vouch Integrated Technologies (P) Ltd." },
    { 19102, "Karlsruher Lebensversicherung AG" },
    { 19103, "CHMS, Inc." },
    { 19104, "BOUYGUES, SA" },
    { 19105, "Fabian Fagerholm Consulting" },
    { 19106, "Deep Eddy Internet Consulting" },
    { 19107, "boojum mobile, inc" },
    { 19108, "I&TC Solutions Pty. Ltd." },
    { 19109, "PacketMotion, Inc." },
    { 19110, "Conduit Networks, Inc" },
    { 19111, "eBdesk Ltd" },
    { 19112, "RJL Computer Consulting, LLC" },
    { 19113, "Server Place LTDA" },
    { 19114, "Proximion Fiber Systems AB" },
    { 19115, "Bernhard-Riemann-Gymnasium Scharnebeck" },
    { 19116, "Antidot" },
    { 19117, "MAMM d.o.o." },
    { 19118, "Europlex Technologies Ltd." },
    { 19119, "Blue Chip Technology Ltd" },
    { 19120, "800onemail Inc." },
    { 19121, "Augmentix Corporation" },
    { 19122, "Yang Arts" },
    { 19123, "Virtual Charting" },
    { 19124, "Pexim d.o.o." },
    { 19125, "Planar Systems, Inc." },
    { 19126, "AECODI" },
    { 19127, "SpamPet" },
    { 19128, "KomKom Electronics" },
    { 19129, "Sanek Systems" },
    { 19130, "MenuSiS Technologies (Pty) Ltd." },
    { 19131, "Stiftung Synanon" },
    { 19132, "The Cheshire Web Mill" },
    { 19133, "Baycom Opoto-Electronics Technology Co., Ltd." },
    { 19134, "Texocom Inc" },
    { 19135, "Darkerhosting.net" },
    { 19136, "Trichord, Inc." },
    { 19137, "Sebastian Staiger Computer  Services" },
    { 19138, "Bright Prospects LLC" },
    { 19139, "Edgewater Networks, Inc." },
    { 19140, "Matthew R. Wilson" },
    { 19141, "Quest Serviced Apartments" },
    { 19142, "Carlo Strozzi (formerly 'ScriptaWorks s.r.l.')" },
    { 19143, "SecureAge Technology" },
    { 19144, "Arjuna" },
    { 19145, "Xonix" },
    { 19146, "Jubatus Corporation" },
    { 19147, "Universit\0303\0240 degli Studi di Milano" },
    { 19148, "acticall" },
    { 19149, "Innovaciones Microelectr\0303\0263nicas S.L." },
    { 19150, "Ville d'Aulnay-sous-bois" },
    { 19151, "WRX Slovakia s.r.o." },
    { 19152, "Camargo e Souza SC/LTDA" },
    { 19153, "Instituto Polit\0303\0251cnico Do Porto" },
    { 19154, "Corporacion Nacional de Angioplastia" },
    { 19155, "AirManage Networks Ltd." },
    { 19156, "Cutting Edge" },
    { 19157, "Chongqing Changsong Network Information Co.LTD" },
    { 19158, "PlumStreet, LLC" },
    { 19159, "Shelton School District" },
    { 19160, "ICAT Managers, LLC" },
    { 19161, "POSnet Services, LLC" },
    { 19162, "Evolving Media Network, LLC" },
    { 19163, "insen" },
    { 19164, "Initial City Link Limited" },
    { 19165, "Kanton Solothurn" },
    { 19166, "Alswille Gloabal Services" },
    { 19167, "CapMon A/S" },
    { 19168, "Fruno S.A." },
    { 19169, "Volantis Systems Ltd" },
    { 19170, "X-Taskforce s.r.l." },
    { 19171, "Checkcare Enterprises, LLC" },
    { 19172, "PFM.Net, Inc." },
    { 19173, "Rex Consulting, Inc." },
    { 19174, "Gestalt, LLC" },
    { 19175, "oraise GmbH" },
    { 19176, "SCOMCENTER" },
    { 19177, "Tandem Systems, Ltd." },
    { 19178, "Skill Corporation" },
    { 19179, "Raysis Co.,Ltd" },
    { 19180, "Guidewire Software, Inc." },
    { 19181, "Optimum Holding Inc." },
    { 19182, "JDA Software" },
    { 19183, "Herdt Domain Service" },
    { 19184, "Widerthan.com" },
    { 19185, "LinuxCare Ltd." },
    { 19186, "Xtramus Technologies" },
    { 19187, "MEK" },
    { 19188, "satunol mikrosistem" },
    { 19189, "Senshu University" },
    { 19190, "Bildanalyssystem AB" },
    { 19191, "woofertom media" },
    { 19192, "Iglooz Technologies" },
    { 19193, "b-next GmbH" },
    { 19194, "Interbyte bvba" },
    { 19195, "TRANSRADIO SenderSysteme Berlin AG" },
    { 19196, "Agarik" },
    { 19197, "Eastlink GmbH" },
    { 19198, "activ-net GmbH & Co. KG" },
    { 19199, "SHC Netzwerktechnik GmbH" },
    { 19200, "MMG" },
    { 19201, "Oyster Partners Ltd" },
    { 19202, "meto-logic" },
    { 19203, "DAI-Labor" },
    { 19204, "Milano Medien GmbH" },
    { 19205, "Secardeo GmbH" },
    { 19206, "Hollins University" },
    { 19207, "Graphic Management Partners Inc." },
    { 19208, "analytiq consulting gmbh" },
    { 19209, "Caterpillar Inc." },
    { 19210, "Cassatt Corporation" },
    { 19211, "TEZ Georgsberg GmbH" },
    { 19212, "University System of Maryland" },
    { 19213, "Raining Data Corporation" },
    { 19214, "Ogilvy & Mather Deutschland GmbH  (formerly 'WPP Service GmbH & Co. KG')" },
    { 19215, "European Organisation for Research and Treatment of Cancer AISBL / IVZW" },
    { 19216, "Heringa" },
    { 19217, "iiNet Pty Ltd" },
    { 19218, "Fortress Networks (Aust) Pty Ltd" },
    { 19219, "Pi Kappa Alpha - Gamma Tau" },
    { 19220, "Local-Web AG" },
    { 19221, "Metropolis AG" },
    { 19222, "Eurotek srl" },
    { 19223, "Internap Network Services Corporation" },
    { 19224, "OSSBroadNet K.K" },
    { 19225, "Tumel" },
    { 19226, "Titanium" },
    { 19227, "Blackwood Medical Inc" },
    { 19228, "Finish Line, Inc." },
    { 19229, "CFOknows, LLC" },
    { 19230, "Graphix Prose, LLC" },
    { 19231, "Lumenware, LLC" },
    { 19232, "LSC Linux Support Center Kft." },
    { 19233, "Blue Lane Technologies Inc." },
    { 19234, "M2" },
    { 19235, "Silver Diamond Services, LLP" },
    { 19236, "CPM SA" },
    { 19237, "becom Informationssysteme GmbH" },
    { 19238, "Moore Systems, Inc." },
    { 19239, "cfSOFTWARE, Inc." },
    { 19240, "Nanshu Densetsu" },
    { 19241, "Cemaphore Systems Inc." },
    { 19242, "Tellusoft" },
    { 19243, "Titus" },
    { 19244, "SafeNet Media" },
    { 19245, "CBPM Software" },
    { 19246, "XWDL" },
    { 19247, "Romat Telecom Ltd." },
    { 19248, "MANIA Research Group" },
    { 19249, "FabianSoft di Fabiano Copeta" },
    { 19250, "Image Systems Corporation" },
    { 19251, "KIP Information Network" },
    { 19252, "NuPi Solutions" },
    { 19253, "Jaspert" },
    { 19254, "Dark Blue Sea" },
    { 19255, "Vaccius ITsec Pte LTd" },
    { 19256, "iCADA GmbH" },
    { 19257, "ProSyntic Ingenieurs b.v." },
    { 19258, "La Joliverie" },
    { 19259, "Ansync Inc." },
    { 19260, "MagiQ Technologies, Inc." },
    { 19261, "Minneapolis College of Art and Design" },
    { 19262, "Dedicado" },
    { 19263, "ET VOILA !!" },
    { 19264, "Magnus Weis" },
    { 19265, "Momentum Computer, Inc." },
    { 19266, "Bayerisches Landesamt f\0303\0274r Statistik und Datenverarbeitung" },
    { 19267, "Ajuntament de Palma" },
    { 19268, "Intercomp Ltd." },
    { 19269, "Hybrigenics SA" },
    { 19270, "Stora Enso Oyj" },
    { 19271, "Minist\0303\0250re de l'\0303\0251conomie, des finances et de l'industrie (Minefi)" },
    { 19272, "praksys" },
    { 19273, "TMBNET" },
    { 19274, "Services Industriels de Geneve" },
    { 19275, "Constant Data, Inc." },
    { 19276, "Paedagogische Hochschule  Ludwigsburg" },
    { 19277, "Shenandoah Solutions, Inc." },
    { 19278, "INOV - INESC Inova\0303\0203\0302\0247\0303\0203\0302\0243o" },
    { 19279, "TMBNET" },
    { 19280, "China Daily" },
    { 19281, "Intrasync, LLC" },
    { 19282, "Institute of Continuous Media Mechanics" },
    { 19283, "Sibelius Academy" },
    { 19284, "TGS Telonic GmbH" },
    { 19285, "BRAZILMALL NETWORK LTDA" },
    { 19286, "Universidad de Los Andes" },
    { 19287, "META Industriesoftware GmbH" },
    { 19288, "ECOPETROL S.A." },
    { 19289, "3Sharp" },
    { 19290, "Just Aaron" },
    { 19291, "Macrad" },
    { 19292, "Pirel inc." },
    { 19293, "Danriver Technologies Corporation (formerly 'Shanghai jisung information technology co.,Ltd')" },
    { 19294, "LeapComm Communication Technologies Inc." },
    { 19295, "Kolle, IT-Ingeni\0303\0270rfirma ApS" },
    { 19296, "Filterlogix, LLC" },
    { 19297, "DSpace Pty Ltd" },
    { 19298, "Media Cruise Solutions k.k." },
    { 19299, "Turkcell Iletisim Hizmetleri A.S." },
    { 19300, "Deutscher Sparkassen Verlag GmbH" },
    { 19301, "Pulse Software & Consulting Inc." },
    { 19302, "CryptCOM Securities, Inc." },
    { 19303, "Zhejiang Telecom Equipment Factory" },
    { 19304, "BNP Paribas Arbitrage" },
    { 19305, "Indio Technologies" },
    { 19306, "FatPipe Networks" },
    { 19307, "MDS INC." },
    { 19308, "Genesee Freenet" },
    { 19309, "chandan" },
    { 19310, "D.H.S. - Data, Hardware, Software spol s r.o." },
    { 19311, "Sterling Crane" },
    { 19312, "Archivas, Inc." },
    { 19313, "beu.ch" },
    { 19314, "Hein Roehrig IT Consulting GbR" },
    { 19315, "Andrew Johnson" },
    { 19316, "Mitsubishi Motors Corporation" },
    { 19317, "1310369 Ontario Ltd." },
    { 19318, "SPAN International" },
    { 19319, "CLSA Ltd" },
    { 19320, "Tomsktelecom, a branch of Sibirtelecom OJSC" },
    { 19321, "VSnet" },
    { 19322, "netiq s.r.o." },
    { 19323, "National Centre for Physics" },
    { 19324, "Rover Laboratories S.p.A." },
    { 19325, "Eroski S. Coop." },
    { 19326, "Tancsics Mihaly SzSzK" },
    { 19327, "Deutscher Skiverband" },
    { 19328, "TRANSGENE SA" },
    { 19329, "Telcotec Ltd." },
    { 19330, "R&K Engineering, Inc." },
    { 19331, "TECNET GMBH" },
    { 19332, "Paperlinx NZ Ltd" },
    { 19333, "Electro Industries/GaugeTech" },
    { 19334, "Cerzan, Inc." },
    { 19335, "Intermax BV" },
    { 19336, "Signull Technologies" },
    { 19337, "Dynamx Internet Services" },
    { 19338, "Bharti Telesoft International Pvt. Ltd." },
    { 19339, "Fachhochschule Bochum" },
    { 19340, "Provincia di Reggio Emilia" },
    { 19341, "Foreningssparbanken" },
    { 19342, "Pinuts media+science Multimedia-Agentur GmbH" },
    { 19343, "Medictyon" },
    { 19344, "United SSL Deutschland GmbH" },
    { 19345, "Odd Element Inc." },
    { 19346, "SMComputer EDV Service & Consulting Schmid Manfred" },
    { 19347, "Pyzzo Software Corporation" },
    { 19348, "Synacor, Inc." },
    { 19349, "Lightshore" },
    { 19350, "eyevis" },
    { 19351, "Ivega Corporation Pvt. Ltd." },
    { 19352, "IP Labs GmbH" },
    { 19353, "ScottRickman" },
    { 19354, "E-Force S.r.l." },
    { 19355, "Sebastian Dietzold" },
    { 19356, "Agroportal B.V." },
    { 19357, "University Medical Centre Nijmegen" },
    { 19358, "Wildner AG" },
    { 19359, "TOPPAN FORMS CO.,LTD." },
    { 19360, "Q&R B.V." },
    { 19361, "Knowledge Media Research Center" },
    { 19362, "Virtuous, Inc." },
    { 19363, "Net Island Networks" },
    { 19364, "4thpass Inc." },
    { 19365, "Nike Inc." },
    { 19366, "Westel Systems" },
    { 19367, "Ecolab, Inc" },
    { 19368, "Azul Systems, Inc." },
    { 19369, "Laboratorio Imagen Radiologica" },
    { 19370, "Telecast Fiber Systems, Inc." },
    { 19371, "Lanvise" },
    { 19372, "Miami County ESC" },
    { 19373, "PowerTel Limited" },
    { 19374, "Orc Software" },
    { 19375, "Max-SI" },
    { 19376, "Integrating the Healthcare Enterprise" },
    { 19377, "Nekotec Telecom" },
    { 19378, "MagicCastle Cummunication" },
    { 19379, "Imperva, Inc." },
    { 19380, "TAMURA Corporation" },
    { 19381, "Bundesanstalt fuer Finanzdienstleistungsaufsicht" },
    { 19382, "Manzara Electronics LTD." },
    { 19383, "Mikromarketingas UAB" },
    { 19384, "VIC TOKAI CORPORATION" },
    { 19385, "Infinity Comunicaciones" },
    { 19386, "Martech Systems (Weymouth) Ltd." },
    { 19387, "Laboratori Guglielmo Marconi" },
    { 19388, "DB Systems GmbH" },
    { 19389, "ComSign Ltd." },
    { 19390, "Trend Software LLC" },
    { 19391, "SASH Management, LLC" },
    { 19392, "City of Union City, Georgia" },
    { 19393, "Trident Systems Incorporated" },
    { 19394, "I.T. By Design, Inc." },
    { 19395, "NewLink Genetics" },
    { 19396, "CITI - Center for Information Technology Integration" },
    { 19397, "TrafficSim Co., Ltd." },
    { 19398, "JSC Institute of Informational Technologies" },
    { 19399, "Xylon Computersystems" },
    { 19400, "TriggerPlus Software Ltd." },
    { 19401, "Fachhochschule Kaiserslautern Standort Zweibruecken" },
    { 19402, "Robert W. Baird & Co" },
    { 19403, "Westbridge Technology, Inc." },
    { 19404, "NIC Inc." },
    { 19405, "Advanced Systems Concepts, Inc." },
    { 19406, "Adiscon GmbH" },
    { 19407, "Atomic9.NET" },
    { 19408, "Zweicom Ltd." },
    { 19409, "Smittskyddsinstitutet" },
    { 19410, "Ministerio de Economia y Hacienda" },
    { 19411, "Andreas Falk" },
    { 19412, "TeliaSonera Mobile Networks AB" },
    { 19413, "SBIM-FMUP" },
    { 19414, "Kolab Project" },
    { 19415, "Docucorp International" },
    { 19416, "Edison Schools" },
    { 19417, "Envoy International, LLC" },
    { 19418, "Stampede Technologies, Inc." },
    { 19419, "Internet-Team GmbH" },
    { 19420, "NodeMinder" },
    { 19421, "Futago LLC" },
    { 19422, "LDAP Technologies" },
    { 19423, "Global Dial Pty Ltd" },
    { 19424, "ECoCoMS Ltd." },
    { 19425, "Hinttech BV" },
    { 19426, "ESDG Konsult AB" },
    { 19427, "The Excel Ortho Group" },
    { 19428, "NovAG-Services Ltd." },
    { 19429, "Alphawave Ltd" },
    { 19430, "NET-2COM Ltd." },
    { 19431, "JSC Kordon" },
    { 19432, "Virulent Software" },
    { 19433, "Austin Independent School District" },
    { 19434, "Concepts et contenus" },
    { 19435, "Hectec GmbH" },
    { 19436, "Concordia University" },
    { 19437, "European School of Management and Technology GmbH" },
    { 19438, "Broadweave Networks" },
    { 19439, "Kingstar&winning Medical Info-Tech Co.,Ltd." },
    { 19440, "IAD GENERAL CO.,LTD" },
    { 19441, "Toroki, Inc." },
    { 19442, "PHANTOM" },
    { 19443, "EGATEL S.L." },
    { 19444, "Metaswitch Networks Ltd (formerly 'Data Connection Ltd')" },
    { 19445, "Calltech Sp. z o.o." },
    { 19446, "Cable One" },
    { 19447, "Swift and Company" },
    { 19448, "zending" },
    { 19449, "Systinet Corp." },
    { 19450, "NetShift Software Ltd" },
    { 19451, "NextG Networks, Inc." },
    { 19452, "BeiJing NuQX Technology CO.,LTD" },
    { 19453, "Ufinity Pte. Ltd." },
    { 19454, "Airspan Networks Inc." },
    { 19455, "Marks & Spencer PLC" },
    { 19456, "Prediwave, Inc" },
    { 19457, "Platinum Equity, LLC" },
    { 19458, "Application Security, Inc." },
    { 19459, "RF Applications, Inc." },
    { 19460, "Sycamore.US" },
    { 19461, "Cendant Mortgage Corporation" },
    { 19462, "Roberto Capancioni" },
    { 19463, "Division of Johns Hopkins in Singapore Limited" },
    { 19464, "Hitachi Communication Technologies, Ltd." },
    { 19465, "Franziska Buendgens" },
    { 19466, "PND1" },
    { 19467, "GeekBone.org" },
    { 19468, "Ishihata industry" },
    { 19469, "Highnet Systems Ltd." },
    { 19470, "Highnet Systems Ltd." },
    { 19471, "Secgo Group Oy" },
    { 19472, "Staer Sistemi s.r.l." },
    { 19473, "North American Electric Reliabiity Corporation" },
    { 19474, "CRL" },
    { 19475, "Confedera\0303\0247\0303\0243o Interestadual das Cooperativas Ligadas ao Sicredi - Sicredi" },
    { 19476, "Highwall Technologies, LLC" },
    { 19477, "Infocaja, S.L." },
    { 19478, "Rapidpacket" },
    { 19479, "KeyOn Communications, LLC" },
    { 19480, "litica.de - Hermann & Matejek GbR" },
    { 19481, "BluePig" },
    { 19482, "Waldmann" },
    { 19483, "Aqua Systems, Inc." },
    { 19484, "BANCO DE ESPA\0303\0221A" },
    { 19485, "art of object GmbH" },
    { 19486, "Venali Inc" },
    { 19487, "Lucent Technologies, Mobility IN" },
    { 19488, "Toadico, Inc" },
    { 19489, "IP3 Networks, Inc." },
    { 19490, "Hiper S.A." },
    { 19491, "Epeople Solu\0303\0247\0303\0265es S/C LTDA" },
    { 19492, "ADDC Infotech GmbH" },
    { 19493, "iMEDIC GmbH" },
    { 19494, "Richard Schilling, MBA" },
    { 19495, "National Informatics Company" },
    { 19496, "Cognition Group, Inc." },
    { 19497, "OSS Application Consulting Centre, Taiwan" },
    { 19498, "HMJ - Projets D\0303\0251localis\0303\0251s" },
    { 19499, "Association Inforoots" },
    { 19500, "Government Information Technology Services" },
    { 19501, "Trust Investment Bank, JSB" },
    { 19502, "QORVUS Systems, Inc." },
    { 19503, "Lockdown Networks, Inc." },
    { 19504, "Mullen" },
    { 19505, "verzeichnisdienst" },
    { 19506, "Christian Jahn" },
    { 19507, "haroldbeumer.com" },
    { 19508, "The Software Guild, Inc." },
    { 19509, "Trident Microsystem INC" },
    { 19510, "Center for Excellence in Telecommunications and Space" },
    { 19511, "Larry Burton" },
    { 19512, "SAHM Technologies LLC" },
    { 19513, "C3 Desenvolvimento de Sistemas Computacionais Ltd." },
    { 19514, "On Demand Systems Limited Partnership" },
    { 19515, "TREND Service GmbH" },
    { 19516, "Universitaet Erfurt" },
    { 19517, "Colibria AS" },
    { 19518, "Technische Universit\0303\0244t M\0303\0274nchen" },
    { 19519, "E.Novation Portal Technology B.V." },
    { 19520, "Samartha Information Systems Pty. Ltd." },
    { 19521, "dataschalt e+a GmbH" },
    { 19522, "Aineas.net" },
    { 19523, "Sequence Solutions" },
    { 19524, "Rational Innovations" },
    { 19525, "Tippecanoe County Public Library" },
    { 19526, "BlueBoxStudio.net" },
    { 19527, "Global Technology Ltd" },
    { 19528, "Meson Fiber Optics" },
    { 19529, "NetStrong Information Ltd." },
    { 19530, "NetMaster Ltd." },
    { 19531, "INSA de Rennes" },
    { 19532, "businessMart AG" },
    { 19533, "TeleMessage Ltd." },
    { 19534, "Gorenjska banka d.d. Kranj" },
    { 19535, "ACNMS" },
    { 19536, "Panduit Corp." },
    { 19537, "M5 Networks, Inc." },
    { 19538, "Add2Net, Inc." },
    { 19539, "Country Haven Academy" },
    { 19540, "NCS Consulting Inc." },
    { 19541, "Belgorodenergo" },
    { 19542, "Aalborg University Library" },
    { 19543, "Wellcome Trust Sanger Institute" },
    { 19544, "Weather Strategies" },
    { 19545, "Sony CISC" },
    { 19546, "MELENTANE" },
    { 19547, "Oplink Communications, Inc." },
    { 19548, "FROX communication" },
    { 19549, "Uni-Q Systems (formerly 'ENGREN.NET')" },
    { 19550, "an Academic Network at Sao Paulo (ANSP)" },
    { 19551, "Thales Naval France" },
    { 19552, "Alexander Kowalski" },
    { 19553, "Beijing Gtt Telecom Technologies Co.Ltd" },
    { 19554, "PIPPKRO" },
    { 19555, "Engim Inc" },
    { 19556, "NextJet Technologies" },
    { 19557, "Frank Holtz" },
    { 19558, "StoneHole" },
    { 19559, "Zones Inc" },
    { 19560, "Informationssicherheit Christian Scheucher" },
    { 19561, "Maxim Integrated Products, Inc." },
    { 19562, "Telena Communication" },
    { 19563, "Center for Imaging Research" },
    { 19564, "GOLUM" },
    { 19565, "Escape Communications, Inc." },
    { 19566, "C-Scape Consulting Corp." },
    { 19567, "ScienceLogic LLC" },
    { 19568, "Global Gate Systems LLC." },
    { 19569, "Grid Research Lab" },
    { 19570, "frottage.org" },
    { 19571, "Micromatic Tecnologia e Sistemas Ltda" },
    { 19572, "ecnuee" },
    { 19573, "Adeptiva" },
    { 19574, "Network Gulf Information Technology" },
    { 19575, "Sansay Inc." },
    { 19576, "Slovanet a.s." },
    { 19577, "ACE electronics N.V." },
    { 19578, "IPConsulting AG" },
    { 19579, "Info Point" },
    { 19580, "RZF Rechenzentrum der Finanzverwaltung des Landes NRW" },
    { 19581, "TTC Telecom Ltd." },
    { 19582, "Pixelpark AG" },
    { 19583, "Wayfarer Transit Systems Ltd." },
    { 19584, "headissue GmbH" },
    { 19585, "Laboranowitsch" },
    { 19586, "ICAN (International Communications and Navigation Ltd.)" },
    { 19587, "Adtec Digital, Inc." },
    { 19588, "Tecnologia Bancaria SA" },
    { 19589, "Business Link Kent Ltd" },
    { 19590, "Systems Solution, Inc." },
    { 19591, "Oral Roberts University" },
    { 19592, "Prince Law Offices, P.C." },
    { 19593, "Nerim" },
    { 19594, "MediaCell, Inc." },
    { 19595, "Alcatel Shanghai Bell Co. Ltd." },
    { 19596, "nhnghia" },
    { 19597, "Capnova Oy" },
    { 19598, "ianet" },
    { 19599, "GeniusBytes Software Solutions GmbH" },
    { 19600, "CTA Systemsource Inc." },
    { 19601, "RGB Networks, Inc." },
    { 19602, "Custom IdM Solutions" },
    { 19603, "dezcom" },
    { 19604, "Secure Network Systems, LLC" },
    { 19605, "Starview Technology Inc" },
    { 19606, "Nienschanz Ltd." },
    { 19607, "Argelcom Limited" },
    { 19608, "Astea International Inc." },
    { 19609, "Zytec" },
    { 19610, "BaseN Oy" },
    { 19611, "trustsec IT solutions GmbH" },
    { 19612, "Wyncote.net" },
    { 19613, "Willing Minds LLC" },
    { 19614, "Business Port Systems Inc." },
    { 19615, "FCS India (Pvt) Ltd." },
    { 19616, "InterCard AG" },
    { 19617, "Taglicht.Com S\0303\0240rl" },
    { 19618, "Return Data" },
    { 19619, "Go Net" },
    { 19620, "NETDEVICES INC." },
    { 19621, "alibaba" },
    { 19622, "Shenzhen Union Broadband Communication Co., Ltd." },
    { 19623, "is:energy czech a.s." },
    { 19624, "MANDA" },
    { 19625, "Unilever PLC" },
    { 19626, "Permabit, Inc." },
    { 19627, "NTPL" },
    { 19628, "webslingerZ, Inc." },
    { 19629, "University of Cincinnati" },
    { 19630, "Alopa Networks Inc." },
    { 19631, "eDial Inc." },
    { 19632, "Rygo Technical Enterprises" },
    { 19633, "BOFH Networks Oy" },
    { 19634, "THALIX" },
    { 19635, "Prager, Sealy & Co. LLC" },
    { 19636, "SolNet Data Service" },
    { 19637, "Oakmoon Consulting, Inc." },
    { 19638, "University of Texas at Arlington" },
    { 19639, "Teztech, Inc." },
    { 19640, "Automated Marketing Solutions Inc." },
    { 19641, "Holley Communications Group" },
    { 19642, "East Alabama Medical Center" },
    { 19643, "Yipes Enterprise Services Inc." },
    { 19644, "Polaris Wireless Inc." },
    { 19645, "Sioux Medical Systems B.V." },
    { 19646, "Computing Edge, Inc." },
    { 19647, "Frederiksborg Amt" },
    { 19648, "TransCore" },
    { 19649, "ERP-HQ Inc." },
    { 19650, "etilize Inc." },
    { 19651, "Seven-Star Inc." },
    { 19652, "National Chi Nan University, Taiwan" },
    { 19653, "Integral Technology Solutions Pty Ltd" },
    { 19654, "Infoteria Corporation" },
    { 19655, "University of Zululand" },
    { 19656, "dreamtel" },
    { 19657, "PlewsNet" },
    { 19658, "Macro-System" },
    { 19659, "Paradigit Computers B.V." },
    { 19660, "CRO24 GmbH" },
    { 19661, "Gleiss Lutz" },
    { 19662, "Telenor AB" },
    { 19663, "Secure-Group AS" },
    { 19664, "gr3 a/s" },
    { 19665, "Grazer Wechselseitige Versicherung AG" },
    { 19666, "Alcatel Suomi Oy" },
    { 19667, "Dr. Ing. h.c. F. Porsche AG" },
    { 19668, "A.S. Reiiseveranstaltungs GmbH" },
    { 19669, "aserva GmbH (formerly 'newthinking IT, Inhaber Alexander Scheibner')" },
    { 19670, "IT University of Copenhagen" },
    { 19671, "DMDsecure.com BV" },
    { 19672, "Gratisavisa Stimuli" },
    { 19673, "ByteHoard" },
    { 19674, "Catalis Health, Inc." },
    { 19675, "Lixto Software GmbH" },
    { 19676, "University of Houston" },
    { 19677, "Unassigned" },
    { 19678, "Relinace Infocomm" },
    { 19679, "Prusch" },
    { 19680, "Dembach Goo Informatik GmbH" },
    { 19681, "vitadurum ag" },
    { 19682, "Balo n Co" },
    { 19683, "WelLink.,Ltd" },
    { 19684, "Town & Country Credit Corp." },
    { 19685, "Virginia Dept. of Social Services" },
    { 19686, "net-concept" },
    { 19687, "Indicative Software, Inc" },
    { 19688, "Cargo IT AG" },
    { 19689, "Evolta B.V." },
    { 19690, "Line4, Inc." },
    { 19691, "eProcess Burkina" },
    { 19692, "Hoppe Dialog GmbH" },
    { 19693, "University of California Santa Cruz (UCSC)" },
    { 19694, "Enterprise Management Shareware" },
    { 19695, "projektfarm GmbH" },
    { 19696, "Cherrypicks" },
    { 19697, "May10 Technology Inc." },
    { 19698, "Information Technology Services Department" },
    { 19699, "System Detection, Inc." },
    { 19700, "Traqueur SA" },
    { 19701, "Mars Computer Systems Sp. J." },
    { 19702, "BSZ Leonberg" },
    { 19703, "Agence de l'Eau Seine Normandie" },
    { 19704, "NetFocus S.R.L" },
    { 19705, "Citto Tecnologia LTDA" },
    { 19706, "BBned NV" },
    { 19707, "Micran Ltd." },
    { 19708, "Brain BroadCast sas" },
    { 19709, "TexRamp, Inc." },
    { 19710, "Bitbuzz Ltd" },
    { 19711, "scaryclowns.org" },
    { 19712, "WebSolve, Inc." },
    { 19713, "Elfiq Inc." },
    { 19714, "Logic Development" },
    { 19715, "LinkAir Communications, Inc." },
    { 19716, "Ars Lumina, Inc." },
    { 19717, "Greatmark" },
    { 19718, "Motorola Israel Ltd. - NSA" },
    { 19719, "QuaQuaNet" },
    { 19720, "Westmarsh Consulting Ltd" },
    { 19721, "BlazeArts Ltd. services.hu network" },
    { 19722, "CONYSER Consulting y Servicios S.L." },
    { 19723, "Broadbus Technologies, Inc." },
    { 19724, "DigiDyne Inc." },
    { 19725, "D. Trust Certifikacna Autorita, a.s." },
    { 19726, "Clinical Reference Laboratory, Inc." },
    { 19727, "Shylex Telecomunicaciones, S.L." },
    { 19728, "Techno-Toolsmiths" },
    { 19729, "SOFTREK CORPORATION" },
    { 19730, "Logic Etc, Inc." },
    { 19731, "Sinaptica Networks" },
    { 19732, "dragonsdawn.net" },
    { 19733, "HUB Consulting, Inc." },
    { 19734, "RAYCOM Co.,LTD." },
    { 19735, "OGA SynCom Co..,LTD" },
    { 19736, "i-RAID" },
    { 19737, "Kyneste S.p.A." },
    { 19738, "Campana" },
    { 19739, "UZorg B.V." },
    { 19740, "Institut de Math\0303\0251matiques et de Sciences Physiques/Universit\0303\0251" },
    { 19741, "Residential Technology, Incorporated" },
    { 19742, "Kazeon Systems, Inc" },
    { 19743, "jpwebworks Pty Ltd" },
    { 19744, "Novacoast, Inc." },
    { 19745, "netz.ooo (formerly 'Dataflake Weblications')" },
    { 19746, "Data Domain, Inc" },
    { 19747, "The Open and Free Technology Community" },
    { 19748, "Affiliated Computer Services, Inc. TripPak SERVICES" },
    { 19749, "CISNS" },
    { 19750, "Beijing YTT Telecom Technologies Co.,Ltd" },
    { 19751, "NOTE Torsby AB" },
    { 19752, "AIS, Aplicaciones de Inteligencia Artificial, S.A." },
    { 19753, "Inexbee" },
    { 19754, "ESG Elektroniksystem- und Logistik-GmbH" },
    { 19755, "Pera International Ltd" },
    { 19756, "Schwabing Software" },
    { 19757, "Iontas" },
    { 19758, "Hafsjold Data ApS" },
    { 19759, "Compunetix, Inc" },
    { 19760, "Leon County Schools" },
    { 19761, "Gordon Aluminum Industries, Inc." },
    { 19762, "Caminos y Canales Ltd." },
    { 19763, "Branch Banking and Trust Corporation" },
    { 19764, "Vandenberg Systems Inc." },
    { 19765, "Systems Engineering Associates, Inc." },
    { 19766, "Wuhan University of Technology" },
    { 19767, "Cooperativa Novanta s.c.r.l." },
    { 19768, "Skybox Security Ltd." },
    { 19769, "JLCX Inc" },
    { 19770, "SelfSigned.com" },
    { 19771, "IBM, Tivoli Provisioning and Orchestration" },
    { 19772, "Mobile Wisdom, Inc." },
    { 19773, "New-Global Corporation" },
    { 19774, "mBlox, Inc." },
    { 19775, "IPG Photonics Corporation" },
    { 19776, "TI Paperco Inc." },
    { 19777, "Taylor University" },
    { 19778, "LinguaNet" },
    { 19779, "BOBEK" },
    { 19780, "Claridion Inc." },
    { 19781, "Odys-solutions" },
    { 19782, "AEGEE-Utrecht" },
    { 19783, "NorthLANs Alliance, LLC" },
    { 19784, "Little Box Solutions Inc." },
    { 19785, "Grand Central Communications" },
    { 19786, "Esteban Pizzini" },
    { 19787, "Ayub Yaqub" },
    { 19788, "LDT Communication Technology CO. LTD" },
    { 19789, "Sheard and Company Pty Limited" },
    { 19790, "INSE7120 conU" },
    { 19791, "MW EDV-Beratung" },
    { 19792, "Forte IT" },
    { 19793, "firstServed NV" },
    { 19794, "IP Security Consulting" },
    { 19795, "AssetHouse Technology Ltd" },
    { 19796, "Jostens Inc" },
    { 19797, "Stefan Fiedler KEG" },
    { 19798, "FBIS" },
    { 19799, "Jeremy McMillan" },
    { 19800, "Derek Balling" },
    { 19801, "PineApp Ltd." },
    { 19802, "Atlanta Business Software, Inc." },
    { 19803, "EC Telecom" },
    { 19804, "The Norns Laboratories" },
    { 19805, "idiotwind.org" },
    { 19806, "SportOdds Systems Pty Limited" },
    { 19807, "AlarmsPro Inc." },
    { 19808, "Open Cloud Ltd." },
    { 19809, "GOUDRON S.A.R.L." },
    { 19810, "R Brooks Associates, Inc." },
    { 19811, "WildOne Information Systems" },
    { 19812, "Hsiuping Institute of Technology" },
    { 19813, "Systems International" },
    { 19814, "Duosoft Inc" },
    { 19815, "Getronics Solutions Malaysia" },
    { 19816, "Philips Medizin Systeme Boeblingen GmbH" },
    { 19817, "Soluzioni Informatiche s.r.l." },
    { 19818, "KIABI" },
    { 19819, "Informatik Club der Universit\0303\0244t Z\0303\0274rich - ICU" },
    { 19820, "Prival ODC, Inc." },
    { 19821, "Bridgeport Networks" },
    { 19822, "Bossers & Cnossen BV" },
    { 19823, "Castle Building Centres Group Ltd." },
    { 19824, "teleganov.net" },
    { 19825, "Kisslinger EDV-Beratung" },
    { 19826, "Institut Teknologi Bandung (ITB)" },
    { 19827, "N2N Consulting Pte Ltd" },
    { 19828, "LBCN Communication Technology Co.,LTD." },
    { 19829, "BITSTREAM" },
    { 19830, "VDL SA" },
    { 19831, "IRT Institut fuer Rundfunktechnik GmbH" },
    { 19832, "Rostrvm Solutions Ltd" },
    { 19833, "Team17 Software Ltd." },
    { 19834, "Bulldog Communications Ltd" },
    { 19835, "Excibir Ltd." },
    { 19836, "Qwest QNMS" },
    { 19837, "USPFO for CA" },
    { 19838, "Univits International AB" },
    { 19839, "Synthean Inc." },
    { 19840, "Avalon Networks Inc." },
    { 19841, "Public Communications Services, Inc." },
    { 19842, "Pantel Service & Holding GmbH" },
    { 19843, "anarcho.com" },
    { 19844, "MOBIGEN Co., Ltd." },
    { 19845, "Solenovo Oy" },
    { 19846, "DDI POCKET,Inc" },
    { 19847, "KU Communication Technology Co.,LTD" },
    { 19848, "University of Bologna" },
    { 19849, "NSFOCUS  Ltd." },
    { 19850, "Waggener Edstrom" },
    { 19851, "Telnet ISG" },
    { 19852, "Southern Utah University" },
    { 19853, "aapala.com" },
    { 19854, "UCLA EE AINS LAB" },
    { 19855, "AIS Management GmbH" },
    { 19856, "Mobile TeleSystems OJSC, Komi Republic" },
    { 19857, "Kuban-GSM CJSC" },
    { 19858, "IPC Media Limited" },
    { 19859, "CGSS Guyane" },
    { 19860, "CGS Corporate Group Service Ltd" },
    { 19861, "Wake Forest University" },
    { 19862, "Motivity Telecom Inc." },
    { 19863, "Tippett Studio" },
    { 19864, "Jostens Inc" },
    { 19865, "NEOMONTANA ELECTRONIS" },
    { 19866, "Edouard Boissonneault" },
    { 19867, "digitec GmbH" },
    { 19868, "Krafty Creations, Inc." },
    { 19869, "Beagle Internet Pty Ltd" },
    { 19870, "The dot.GOD Registry, Limited" },
    { 19871, "AG Consulting, LLP." },
    { 19872, "TVEngineer.org" },
    { 19873, "MarsolsNet Inc." },
    { 19874, "Distributel Communications Ltd." },
    { 19875, "hutuworm.org Inc." },
    { 19876, "USE" },
    { 19877, "Nuernberger Versicherungsgruppe" },
    { 19878, "ITNet S.p.a." },
    { 19879, "Makedonski Telekomunikacii, MTnet" },
    { 19880, "Conarcom C.A. Sirena" },
    { 19881, "AEGEE-Europe" },
    { 19882, "Radius., Ltd" },
    { 19883, "Meta4 Spain S.A." },
    { 19884, "Ontier" },
    { 19885, "Navimedix Inc." },
    { 19886, "Corio, inc" },
    { 19887, "California School Information Services" },
    { 19888, "The Tarc Group" },
    { 19889, "AppTrigger" },
    { 19890, "Global Interactive Technology Pte Ltd" },
    { 19891, "bay. Innenministerium (Verfassungsschutz)" },
    { 19892, "HONKO MFG.co.,ltd." },
    { 19893, "Brighton Consulting Inc." },
    { 19894, "CubeRoot" },
    { 19895, "Heolys France SARL" },
    { 19896, "udayan kumar" },
    { 19897, "IUT FOTSO Victor de Bandjoun, Universit\0303\0251 de Dschang" },
    { 19898, "LT Systems LLC" },
    { 19899, "Thinking Systems Corporation" },
    { 19900, "Advanced RF Technologies, Inc." },
    { 19901, "Atkinson, Inglis & Associates" },
    { 19902, "University of Texas Pan American" },
    { 19903, "Jharding" },
    { 19904, "Sage Technology Ltd." },
    { 19905, "Beijing YTT Telecom Technologies Co.,Ltd" },
    { 19906, "Europacom.net Ltd" },
    { 19907, "Alpha Oil Ltd." },
    { 19908, "Alcopack Group" },
    { 19909, "PadzNet, Inc." },
    { 19910, "DirecTrust" },
    { 19911, "Global Velocity Inc." },
    { 19912, "Phatline" },
    { 19913, "murphx Innovative Solutions Ltd" },
    { 19914, "Optus SingTel Pty Ltd." },
    { 19915, "BeiJing Gefon Network Technology Ltd." },
    { 19916, "Fundaci\0303\0263n ESADE" },
    { 19917, "Sungard Finance" },
    { 19918, "Phoenix IT Services" },
    { 19919, "IPL Information Processing Ltd" },
    { 19920, "PREVX Ltd." },
    { 19921, "Gross" },
    { 19922, "Iowa State University" },
    { 19923, "ei3 Corporation" },
    { 19924, "Mirror Image Internet" },
    { 19925, "Triadigm Technology" },
    { 19926, "Feith Systems and Software, Inc." },
    { 19927, "Escherware b.v." },
    { 19928, "Linuxlab Ltd." },
    { 19929, "4X Information Technology GmbH" },
    { 19930, "SalesCatalysts.com Ltd." },
    { 19931, "BluntSoft Ltd." },
    { 19932, "MITTS Ltd." },
    { 19933, "University of Tasmania" },
    { 19934, "Key Business Services" },
    { 19935, "Allnet GmbH" },
    { 19936, "Philip Morris International Management SA" },
    { 19937, "Cogent Innovators, LLC" },
    { 19938, "OU College of Continuing Education" },
    { 19939, "AWARM.NET, Ltd." },
    { 19940, "broadreach systems" },
    { 19941, "Lind-Waldock" },
    { 19942, "Jumbo Corporation" },
    { 19943, "D2D Cars" },
    { 19944, "Sunwest Computers Ltd." },
    { 19945, "Abilitec Limited" },
    { 19946, "ITS Pub" },
    { 19947, "WIENER Plein & Baus GmbH" },
    { 19948, "OOO Maxidom" },
    { 19949, "Bellmonte" },
    { 19950, "Sveriges Television AB (SVT)" },
    { 19951, "AREA" },
    { 19952, "Message Systems, Inc." },
    { 19953, "Ironworks Consulting, LLC" },
    { 19954, "CenterBoard Inc" },
    { 19955, "Tenebris Technologies Inc." },
    { 19956, "Kabissa Inc." },
    { 19957, "Aurora Network Operations Management Services" },
    { 19958, "nex-G Systems Pte. Ltd." },
    { 19959, "Lund University" },
    { 19960, "SER Storage Technology GmbH" },
    { 19961, "Central Research Institute for Machine Building" },
    { 19962, "Netservers Ltd." },
    { 19963, "Enigma Software Corporation" },
    { 19964, "TRIBUNAL REGIONAL DO TRABALHO DA 22A. REGI\0303\0203O" },
    { 19965, "Spotwave Wireless, Inc." },
    { 19966, "Telexy Corp." },
    { 19967, "Meta Consulting" },
    { 19968, "Network Intelligence Corporation" },
    { 19969, "Klamath Networks Corp." },
    { 19970, "Clever Machine, Inc." },
    { 19971, "Tripleplay Services Ltd." },
    { 19972, "David Nesting" },
    { 19973, "Vader Logic, LLC" },
    { 19974, "Estonian Educational and Research Network" },
    { 19975, "ICTeam S.p.A." },
    { 19976, "Alberti Holdings Pty. Ltd." },
    { 19977, "Theta Networks, Inc." },
    { 19978, "o2 (Germany) GmbH & Co. OHG" },
    { 19979, "INPES" },
    { 19980, sminmpec_unknown },  /* (Added by Wireshark) */
    { 19981, "Venetica" },
    { 19982, "Cap Gemini Norway" },
    { 19983, "Cu-nes" },
    { 19984, "Pittsburg State University" },
    { 19985, "Vigoment Software Inc." },
    { 19986, "void solutions" },
    { 19987, "Anerist" },
    { 19988, "Rezel" },
    { 19989, "Netlanta.com" },
    { 19990, "NetTeem, LLC" },
    { 19991, "Beijing Zhengyou Networks&Communication Technology Co.,Ltd." },
    { 19992, "Ericsson, Inc." },
    { 19993, "S2 Systems, Inc." },
    { 19994, "Shanghai Withub General Technology Co.,Ltd." },
    { 19995, "SPES S.r.l." },
    { 19996, "SwissQual AG" },
    { 19997, "4D Technology (llc)" },
    { 19998, "Netspecs B.V." },
    { 19999, "eEpoch" },
    { 20000, "Ing. B\0303\0274ro Ziegler" },
    { 20001, "Ukraine Trust Network" },
    { 20002, "RZNet AG" },
    { 20003, "PTK Centertel sp z o. o." },
    { 20004, "HEUFT SYSTEMTECHNIK GMBH" },
    { 20005, "Air Products and Chemicals, Inc." },
    { 20006, "Nagios" },
    { 20007, "Kenati Technologies Inc." },
    { 20008, "Toshiba Electronics Europe GmbH" },
    { 20009, "Beaver Creek Cooperative Telephone Company" },
    { 20010, "reuter network consulting" },
    { 20011, "System Business Consulting" },
    { 20012, "QinetiQ Ltd" },
    { 20013, "Vanguard Integity Professionals" },
    { 20014, "Fernandez Industries Incorporated" },
    { 20015, "Ville d'Yverdon" },
    { 20016, "Mountain Top Applied Solutions, Inc." },
    { 20017, "Dansk Netcenter APS" },
    { 20018, "River City Software Associates, Ltd." },
    { 20019, "Antarctica Networks Ltd." },
    { 20020, "Pacific Wave Solutions, Incorporated" },
    { 20021, "Boswell Online B.V." },
    { 20022, "TETCO TECHNOLOGIES SA" },
    { 20023, "Rezel" },
    { 20024, "Proxyconn, Inc." },
    { 20025, "Compusaurus Bt." },
    { 20026, "RedeNetwork.com" },
    { 20027, "TDK-LAMBDA Corporation" },
    { 20028, "Line-tec, Inc." },
    { 20029, "Mortara Instrument, Inc." },
    { 20030, "ValidSoft Ltd" },
    { 20031, "Qnamic AG" },
    { 20032, "KISTER" },
    { 20033, "Dicr" },
    { 20034, "rjcdb.com" },
    { 20035, "Alexander Kellmann" },
    { 20036, "Advanced Control Technology, Inc." },
    { 20037, "HISL Limited" },
    { 20038, "LithiumCorp Pty Ltd" },
    { 20039, "Shanghai Communications Technologies Center" },
    { 20040, "GUMC" },
    { 20041, "INGENION GmbH" },
    { 20042, "Hitel Italia S.p.A." },
    { 20043, "Grupo 3A Recoletas" },
    { 20044, "Ekinops SAS" },
    { 20045, "Corporate Express Promotional Marketing" },
    { 20046, "Pilgerer e.V" },
    { 20047, "theglobe.com" },
    { 20048, "Internet Broadcasting Systems" },
    { 20049, "GnuArch" },
    { 20050, "Western United Insurance" },
    { 20051, "GlobalSkyVault" },
    { 20052, "Intesa Sanpaolo S.p.A." },
    { 20053, "I.NET2 S.r.l." },
    { 20054, "Statistisches Bundesamt" },
    { 20055, "FRANCE2" },
    { 20056, "ASC Program" },
    { 20057, "Lumenos, Inc." },
    { 20058, "Aramiska" },
    { 20059, "Acsera Corporation" },
    { 20060, "Pacific University" },
    { 20061, "Seacoast Synergy, Inc." },
    { 20062, "University of Crete - Faculty of Medicine" },
    { 20063, "vandalsWeb.com" },
    { 20064, "Tohoku Intelligent Telecommunication Co.,Inc." },
    { 20065, "Omega Consult Inc." },
    { 20066, "Entheos Software" },
    { 20067, "Karlstad University" },
    { 20068, "Artinfor" },
    { 20069, "JDG Trading(Pty Ltd.)" },
    { 20070, "Telecom Italia S.p.A." },
    { 20071, "Electronic Formations" },
    { 20072, "IWKA InformationsSysteme GmbH" },
    { 20073, "Abundance Networks, LLC" },
    { 20074, "Freerun Technologies Inc." },
    { 20075, "Werthmoeller IT-Service" },
    { 20076, "Makaera Vir 2000 Inc." },
    { 20077, "cMarket, Inc." },
    { 20078, "Escobar Enterprises" },
    { 20079, "SK-TECH.net" },
    { 20080, "MFD" },
    { 20081, "Alanne LLC" },
    { 20082, "ECE Projektmanagement" },
    { 20083, "Techno Group, Inc" },
    { 20084, "OnlineWeb Ltd." },
    { 20085, "HyperSpace Communications, Inc." },
    { 20086, "JRC ENGINEERING CO.,LTD." },
    { 20087, "Consultix GmbH" },
    { 20088, "Renewal Enterprises, LLC" },
    { 20089, "Cornerstone Consulting, LLC" },
    { 20090, "AIS Automations- und Informationssysteme GmbH" },
    { 20091, "SyAM Software, Inc." },
    { 20092, "Servicios de i-pro para competitividad, S.A. de C.V." },
    { 20093, "TrekLogic Inc." },
    { 20094, "Vaonet" },
    { 20095, "Positron Access Solutions Corp (formerly 'Aktino, Inc.')" },
    { 20096, "Image Entry, Inc." },
    { 20097, "Plope Consulting" },
    { 20098, "Dave Hoebe" },
    { 20099, "Impulse Internet Services" },
    { 20100, "Spliced Networks LLC" },
    { 20101, "Cox Enterprises" },
    { 20102, "multi.mediale.net.ltd" },
    { 20103, "allery.org" },
    { 20104, "Digital Evergreen, Inc." },
    { 20105, "N\0303\0240h-ko's world Inc." },
    { 20106, "Center for Leadership Solutions LLC" },
    { 20107, "ANIXIS" },
    { 20108, "LPC Condor Technologies" },
    { 20109, "Cynap Limited" },
    { 20110, "MediaPlan Inc." },
    { 20111, "LEADER ELECTRONICS CORP." },
    { 20112, "SMT Electronic Technology Limited" },
    { 20113, "Vecino" },
    { 20114, "Systems Management Enterprises, Inc." },
    { 20115, "J'raxis" },
    { 20116, "Janr" },
    { 20117, "Institute of Applied Internet Technology, Inc." },
    { 20118, "KCN Tech Co., Ltd." },
    { 20119, "EuroMarknet Internet Technol\0303\0263giai \0303\0251s Tan\0303\0241csad\0303\0263 Ltd." },
    { 20120, "VIDEOTRON Corp." },
    { 20121, "imos GmbH" },
    { 20122, "mind-n" },
    { 20123, "S\0303\0251bastien Nam\0303\0250che Consulting" },
    { 20124, "Cologne Systems GmbH" },
    { 20125, "Vitel Software, Inc" },
    { 20126, "LP Agent" },
    { 20127, "TTYS0 (formerly 'Gutenpress')" },
    { 20128, "SKH TKO Kei Tak Primary School" },
    { 20129, "SOURCECORP,Inc." },
    { 20130, "Advanced Digital Systems, Inc." },
    { 20131, "Vermeer Manufacturing Company" },
    { 20132, "Azonic Systems, Inc." },
    { 20133, "izac.org" },
    { 20134, "Surf and Sip Inc." },
    { 20135, "Elyo Services Ltd" },
    { 20136, "SCHMIEDER it-solutions GmbH" },
    { 20137, "codesupply.com" },
    { 20138, "Avara Technologies Pty Ltd." },
    { 20139, "Lobos, Inc." },
    { 20140, "DAVOLINK" },
    { 20141, "Axis Internet" },
    { 20142, "QianWang Networks Co." },
    { 20143, "Uffaq Technologies Private Ltd." },
    { 20144, "Optimo Service AG" },
    { 20145, "ELVIS-PLUS" },
    { 20146, "Ecutel" },
    { 20147, "Internet NetOnRamp" },
    { 20148, "runIT AG" },
    { 20149, "Optim Ltd Int Grp" },
    { 20150, "Zon Nederland N.V." },
    { 20151, "Martin-Luther-Universitaet Halle-Wittenberg" },
    { 20152, "eurofunk Kappacher GmbH" },
    { 20153, "ALCA INFORMATIQUE et TELECOM" },
    { 20154, "Redes de Telefon\0303\0255a M\0303\0263vil, S.A." },
    { 20155, "Winterthur Ib\0303\0251rica, AIE" },
    { 20156, "Lowe's Companies, Inc." },
    { 20157, "High Desert Education Service District" },
    { 20158, "Washburn University" },
    { 20159, "Force, Incorporated" },
    { 20160, "Hilton Hotels Corporation" },
    { 20161, "EWE TEL GmbH" },
    { 20162, "Trinity Capital Corporation" },
    { 20163, "Kerna Communications Ltd." },
    { 20164, "Subrafta Industries, Inc." },
    { 20165, "NIE Corporation" },
    { 20166, "DEODEO Co,.Ltd" },
    { 20167, "Sonic Industries Inc." },
    { 20168, "Gesellschaft fuer wissenschaftliche Datenverarbeitung mbH Goettingen" },
    { 20169, "Urmet TLC S.p.A." },
    { 20170, "Systemlegionen" },
    { 20171, "Burwood Group, Inc." },
    { 20172, "CRI Advantage" },
    { 20173, "sd&m AG" },
    { 20174, "Weldata bv" },
    { 20175, "FOR-A Company Ltd." },
    { 20176, "Mark Rose" },
    { 20177, "Chrome Cyz Co Ltd" },
    { 20178, "NetShield (Pty) Ltd" },
    { 20179, "RNDSoft co.,ltd" },
    { 20180, "SONGHWASOFT" },
    { 20181, "The Reynolds and Reynolds Company" },
    { 20182, "Appmind Software AB" },
    { 20183, "William G Dempsey & Associates" },
    { 20184, "Montreal University" },
    { 20185, "Brake Parts Inc" },
    { 20186, "Panareef Pty Ltd" },
    { 20187, "Gary T. Giesen" },
    { 20188, "PHOENIX SOFT" },
    { 20189, "Nature Care College" },
    { 20190, "iCable System" },
    { 20191, "Throughwave, Inc." },
    { 20192, "JK Technologies Corp." },
    { 20193, "ERZIA Technologies, SL" },
    { 20194, "Volexia Ltd." },
    { 20195, "AL.systems GmbH" },
    { 20196, "Rainbow Triangle, v. o. s." },
    { 20197, "St. Olaf College" },
    { 20198, "Equinox Information Systems, Inc" },
    { 20199, "SUSCERTE - Gobierno de la Republica Bolivariana de Venezuela" },
    { 20200, "Sioss Ltd" },
    { 20201, "Kinnarps AB" },
    { 20202, "First Canadian Title Company Ltd." },
    { 20203, "First Canadian Title Company Ltd." },
    { 20204, "EBC" },
    { 20205, "TIS Grupa d.o.o." },
    { 20206, "The Unwins Wine Group Ltd" },
    { 20207, "Closed Joint Stock Company \"PIOGLOBAL Services\"" },
    { 20208, "Latitude Technologies, Inc." },
    { 20209, "Submersion Corporation" },
    { 20210, "Vigilant Privacy Corporation" },
    { 20211, "Information and Telecommunications Technology Center" },
    { 20212, "Q1Labs, Inc." },
    { 20213, "Rock Island Communications, Inc." },
    { 20214, "Nordic Institute for Theoretical Physics" },
    { 20215, "Netkey, Inc." },
    { 20216, "more4u gbr" },
    { 20217, "Polystar Instruments AB" },
    { 20218, "Ajeco Oy" },
    { 20219, "BSH Hausgeraete GmbH" },
    { 20220, "EB Software Enk, John Weholdt" },
    { 20221, "IMAGINEON oHG" },
    { 20222, "PROFSOFT Sp. z o.o." },
    { 20223, "Ementor Norge AS" },
    { 20224, "Institut Pasteur" },
    { 20225, "Sub Service Ltd." },
    { 20226, "Cel*Star Guyana Inc." },
    { 20227, "BitPoint AG" },
    { 20228, "Teleflex Incorporated" },
    { 20229, "Karl Hofmann Schule Berufsbildende Schule" },
    { 20230, "Luis Lewis" },
    { 20231, "LDAP Technology" },
    { 20232, "LocalNet Systems" },
    { 20233, "Pro-G Information Security and Research Ltd." },
    { 20234, "Superlativ" },
    { 20235, "LinuxForce, Inc." },
    { 20236, "China Telecom-Guangzhou Research and Development Center" },
    { 20237, "PJ Velzeboer" },
    { 20238, "AMBIZ, Inc." },
    { 20239, "Sterrewacht Leiden" },
    { 20240, "CICA" },
    { 20241, "Premiere Fernsehen GmbH & Co. KG" },
    { 20242, "Stephan Ruckelshaussen" },
    { 20243, "SNR S.A." },
    { 20244, "Police IT Management Agency" },
    { 20245, "Deverto Systems Ltd." },
    { 20246, "Delta Energy Systems (Sweden) AB" },
    { 20247, "Bladiant Technologies, Inc." },
    { 20248, "Sony Computer Entertainment America, Inc." },
    { 20249, "Touchstone Systems, Inc." },
    { 20250, "GlobeRanger Corporation" },
    { 20251, "BN" },
    { 20252, "North American World Trade Group" },
    { 20253, "iologics, Inc." },
    { 20254, "Mediatria s.r.l." },
    { 20255, "Xalted Information Systems Pvt. Ltd" },
    { 20256, "Communicate Norge AS" },
    { 20257, "Azienda Ospedaliera Villascassi" },
    { 20258, "Sabanci University" },
    { 20259, "Sandprints" },
    { 20260, "MDTelecom, Inc." },
    { 20261, "EMS Wireless" },
    { 20262, "Odyssey Software, Inc." },
    { 20263, "Aurisp" },
    { 20264, "Muiderberg (M.H.C.)" },
    { 20265, "Cambridge University Faculty of Music" },
    { 20266, "OnWeb Technologies, c.a." },
    { 20267, "Days of Wonder Inc." },
    { 20268, "Chelsea Technologies Inc." },
    { 20269, "University of Yamanashi" },
    { 20270, "xtendo technologies Kurt Schwedes" },
    { 20271, "NetEnrich, Inc." },
    { 20272, "Creative Media GmbH" },
    { 20273, "Kunsthistorisches Museum" },
    { 20274, "Cyber Ware Ltd" },
    { 20275, "Ex Fructu Kft." },
    { 20276, "Citadec Solutions OY" },
    { 20277, "System-Net" },
    { 20278, "Sakana-home.net" },
    { 20279, "The Polestar Group Ltd" },
    { 20280, "CERNET, China Education and Research Network" },
    { 20281, "3TNet Experimental Network" },
    { 20282, "Cribbins Associates" },
    { 20283, "KnowGate" },
    { 20284, "FAURECIA" },
    { 20285, "E-work S.p.A" },
    { 20286, "VirusBuster Ltd." },
    { 20287, "Katholieke Theologische Universiteit" },
    { 20288, "TimeLink International GmbH" },
    { 20289, "indatex GmbH" },
    { 20290, "CNA INSURANCE" },
    { 20291, "onTimeTek Inc." },
    { 20292, "Dept. Network Center, China University of Geosciences" },
    { 20293, "Onirban Networks" },
    { 20294, "Caperio AB" },
    { 20295, "Euler Hermes Poland" },
    { 20296, "Banco Popular" },
    { 20297, "Rodos" },
    { 20298, "If-Tech" },
    { 20299, "Sussex Community Wireless" },
    { 20300, "InsightETE" },
    { 20301, "IBM eServer X" },
    { 20302, "Medica" },
    { 20303, "Banco Industrial e Comercial S.A." },
    { 20304, "Matrix Bancorp" },
    { 20305, "DIR A/S" },
    { 20306, "Kapsch CarrierCom AG" },
    { 20307, "Lie-Comtel" },
    { 20308, "Regent Group of Companies" },
    { 20309, "CIRIL - Centre Interuniversitaire de Ressources Informatiques de Lorraine," },
    { 20310, "Nicotra Sistemi spa" },
    { 20311, "Views On News" },
    { 20312, "Semantico Limited" },
    { 20313, "ix-tech" },
    { 20314, "FabDouglas" },
    { 20315, "OCA \"OpenCallArgentina\"" },
    { 20316, "Qosmetrics, Inc." },
    { 20317, "Lissi Co. Ltd." },
    { 20318, "Friedrich + Lochner GmbH" },
    { 20319, "University of California, San Francisco, Information Technology Services" },
    { 20320, "CAE Inc" },
    { 20321, "G+G Comsoft GmbH" },
    { 20322, "Udo Schledorn  EDV-Beratung" },
    { 20323, "Success Medical Computer Co., Ltd." },
    { 20324, "Provinzial Rheinland Versicherung AG" },
    { 20325, "neska Schiffahrts- und Speditionskontor GmbH" },
    { 20326, "Education Nationale" },
    { 20327, "Helsinki Polytechnic Stadia" },
    { 20328, "Whitehead Institute for Biomedical Research" },
    { 20329, "University of Maine at Farmington" },
    { 20330, "WPS Health Insurance" },
    { 20331, "ILTC - Instituto Doris Aragon" },
    { 20332, "Bau- und Wohngenossenschaft Brachvogel" },
    { 20333, "ASC System" },
    { 20334, "IDS GmbH" },
    { 20335, "Teknologisk Institut" },
    { 20336, "N&TS spa" },
    { 20337, "Arquematica" },
    { 20338, "Addamark Technologies, Inc." },
    { 20339, "Daniel Kelley and Associates" },
    { 20340, "Information Builders, Inc" },
    { 20341, "LifeSize Communications, Inc" },
    { 20342, "Agencia Mar\0303\0255tima de Consignaciones, S.A." },
    { 20343, "Altexia" },
    { 20344, "Portrait Displays, Inc." },
    { 20345, "Edgewater Computer Systems. Inc." },
    { 20346, "MetroFi, Inc." },
    { 20347, "Equinox Converged Solutions Ltd" },
    { 20348, "ARCUS Software Pty Ltd" },
    { 20349, "Aruba S.r.l." },
    { 20350, "Milos Malik" },
    { 20351, "European Bridge-CA" },
    { 20352, "UNATECH.CO.,LTD" },
    { 20353, "Ebang Telecom Technologies HangZhou Co., Ltd" },
    { 20354, "Plexis Computing Limited" },
    { 20355, "Bundesverband der Deutschen Industrie e.V." },
    { 20356, "CONTER Control de Energ\0303\0255a, S.A." },
    { 20357, "TINC Associates NV" },
    { 20358, "Concordia College" },
    { 20359, "On Command Corporation" },
    { 20360, "Cronbank AG" },
    { 20361, "Ecole Centrale de Nantes" },
    { 20362, "Alcanet International Deutschland GmbH" },
    { 20363, "Terrecablate" },
    { 20364, "System Engineering International" },
    { 20365, "Malam Communications LTD" },
    { 20366, sminmpec_unknown },  /* (Added by Wireshark) */
    { 20367, "Univates" },
    { 20368, "Manzanita Systems" },
    { 20369, "MEPHARTEC  s.a.r.l" },
    { 20370, "Allware LTDA." },
    { 20371, "VhaYu Technologies" },
    { 20372, "Michael A Nachbaur" },
    { 20373, "Coast to Coast Hosting" },
    { 20374, "AVAL NAGASAKI CORPORATION" },
    { 20375, "ATT - AudioText Telecom AG" },
    { 20376, "Century Systems Inc." },
    { 20377, "ITMG GmbH" },
    { 20378, "Sabancy Telekom\0303\0274nikasyon Hizmetleri A.?." },
    { 20379, "Specstroy-Svyaz" },
    { 20380, "Privacy, Inc." },
    { 20381, "ShopperTrak" },
    { 20382, "Working Knowledge, Inc" },
    { 20383, "CNCLabs(CHINA NETCOM GROUP LABS)" },
    { 20384, "GAIA e.V." },
    { 20385, "Frameworx, Inc." },
    { 20386, "Apple Daily Publication Development Limited,Taiwan Branch" },
    { 20387, "Externet Kft" },
    { 20388, "Streamwide SAS" },
    { 20389, "Cape Clear Software" },
    { 20390, "OT Energy Services a.s. (formerly 'I & C Energo a.s.')" },
    { 20391, "FAKUS Elektronik GmbH" },
    { 20392, "Oberfinanzdirektion Berlin" },
    { 20393, "Money Services, Inc." },
    { 20394, "ackrium" },
    { 20395, "Sircom software" },
    { 20396, "Erbach Associates" },
    { 20397, "Telecooperation Office, University of Karlsruhe" },
    { 20398, "Quintech Electronics and Communications Inc." },
    { 20399, "Educational Consulting Services, Inc." },
    { 20400, "Raytech Technologies, Ltd." },
    { 20401, "InterMetro Communications" },
    { 20402, "COSTRON Co., Ltd." },
    { 20403, "First Communication, Inc." },
    { 20404, "PT. ELEKTRINDO NUSANTARA" },
    { 20405, "Omkhar, LLC" },
    { 20406, "Naesasoft,Inc." },
    { 20407, "Fuhrer Engineering AG" },
    { 20408, "pysnmp" },
    { 20409, "Kvinnherad Breiband AS" },
    { 20410, "Janusys Networks, Inc." },
    { 20411, "lepo" },
    { 20412, "OAO Link" },
    { 20413, "University of Exeter" },
    { 20414, "Fracarro Radioindustrie S.p.A." },
    { 20415, "Solid AB" },
    { 20416, "Fifth Third Bank" },
    { 20417, "EUROTUNNEL" },
    { 20418, "VectorMAX Corporation" },
    { 20419, "Security Certificates UK ltd" },
    { 20420, "Dyaptive Systems Inc." },
    { 20421, "RangoSur S.A." },
    { 20422, "The Log4perl Project" },
    { 20423, "NSS S.A." },
    { 20424, "LUKA netconsult GmbH" },
    { 20425, "Noea Corporation" },
    { 20426, "Tellus Group Corp." },
    { 20427, "TKD" },
    { 20428, "ISTIA-AUTO" },
    { 20429, "Kaliop Interactive Media" },
    { 20430, "OPTIMUM SYSTEMES INFORMATION" },
    { 20431, "Inventa Technologies, Inc." },
    { 20432, "iTRACS Corporation" },
    { 20433, "Phoenix Broadband Technologies, LLC." },
    { 20434, "Boca Internet Technologies, Inc. dba AlertSite" },
    { 20435, "Seenetix d.o.o." },
    { 20436, "TransUnion LLC" },
    { 20437, "Func. Internet Integration" },
    { 20438, "CITIZEN WATCH CO.,LTD" },
    { 20439, "Bodgit & Scarper" },
    { 20440, "PATLITE Corporation" },
    { 20441, "REMASYS Pty. Ltd." },
    { 20442, "Samsung SDS Co, Ltd." },
    { 20443, "Open Development" },
    { 20444, "MAX SCHMIDT PAPIERLOGISTIK" },
    { 20445, "Noncommercial partnership <Open Food Stock>" },
    { 20446, "Colegio Ingenieros Caminos Canales Puertos" },
    { 20447, "APX UK Ltd." },
    { 20448, "Gibr.Net" },
    { 20449, "NetWisdom(Beijing)Technology co,ltd" },
    { 20450, "Indigo Corp." },
    { 20451, "Identiga Karto" },
    { 20452, "FishNet, Inc." },
    { 20453, "Nakina Systems" },
    { 20454, "Middlesex Community College" },
    { 20455, "Concorde Microsystems" },
    { 20456, "Omnis Network, LLC" },
    { 20457, "Incipient, Inc." },
    { 20458, "Schneider National, Inc." },
    { 20459, "Oki Electric Industry Co., Ltd. (formerly 'OF Networks Co., Ltd.')" },
    { 20460, "goldenfile ltd" },
    { 20461, "Organika-Kuznetsk" },
    { 20462, "Multimedia Project Srl" },
    { 20463, "Perceval" },
    { 20464, "Mi4e AB" },
    { 20465, "Caja de Ahorros de CASTILLA-LA MANCHA" },
    { 20466, "DS Wilson Consulting" },
    { 20467, "SAPIENS TECHNOLOGIES Ltd" },
    { 20468, "TatraMed Software s.r.o." },
    { 20469, "Lycos Europe GmbH" },
    { 20470, "WINGcon GmbH" },
    { 20471, "Banca di Roma S.p.A." },
    { 20472, "Lyra Network" },
    { 20473, "Parlamento de Andalucia" },
    { 20474, "LondonLink Ltd" },
    { 20475, "Avalanche Mobile BV" },
    { 20476, "Fachhochschule Ravensburg-Weingarten" },
    { 20477, "Buongiorno S.p.A." },
    { 20478, "Noopys Store company" },
    { 20479, "UMC Genomics Lab" },
    { 20480, "StrikeForce Technologies, Inc." },
    { 20481, "CUBETECH" },
    { 20482, "L B Enterprises" },
    { 20483, "Ministerio de Hacienda" },
    { 20484, "Sukra Helitek, Inc." },
    { 20485, "Fuchsia Open Source Solutions" },
    { 20486, "ChyronHego Corporation (formerly 'Chyron Corporation')" },
    { 20487, "AXT Systems Pty Limited" },
    { 20488, "DTMC Systems" },
    { 20489, "Geotek Design Services" },
    { 20490, "China Putian Institute of Technology" },
    { 20491, "Teamsun Technology Co.,Ltd" },
    { 20492, "MTT Computer Consulting, Inc" },
    { 20493, "Koblenzer Elektrizit\0303\0244tswerk und Verkehrs-AG" },
    { 20494, "Consejo General del Poder Judicial" },
    { 20495, "Marvell Semiconductor Israel, Ltd" },
    { 20496, "CellVision AS" },
    { 20497, "Universita' Mediterranea di Reggio Calabria" },
    { 20498, "Gnoble Technologies" },
    { 20499, "Azeus Systems Ltd." },
    { 20500, "Soft Link AG" },
    { 20501, "Padcom" },
    { 20502, "Albertsons Inc." },
    { 20503, "BearingPoint NZ Ltd" },
    { 20504, "Franz Chladek - EDV Dienstleistungen" },
    { 20505, "Astrogator" },
    { 20506, "Huetron Co.Ltd" },
    { 20507, "Luvantix Co.Ltd" },
    { 20508, "Urbandale Community School District" },
    { 20509, "Dixon Hughes PLLC" },
    { 20510, "National Taiwan University Hospital" },
    { 20511, "Manzanita Systems" },
    { 20512, "Romania Internet Security Systems" },
    { 20513, "SARK Consultants Private Limited" },
    { 20514, "Home Office Life kernel" },
    { 20515, "FJD Information Technologies AG" },
    { 20516, "Battle Eagle Entertainment, Inc." },
    { 20517, "eBuild.ca Inc." },
    { 20518, "Flashbit Ruf and Heide GbR" },
    { 20519, "Y Soft, s.r.o." },
    { 20520, "Cronyx Engineering" },
    { 20521, "PSDA, Inc." },
    { 20522, "Javalobby.org" },
    { 20523, "Tom Addis Automotive Group" },
    { 20524, "SunStar Systems, Inc." },
    { 20525, "Anacomp, Inc." },
    { 20526, "Franciscan Missionaries of Our Lady Health System, Inc." },
    { 20527, "Sathee Inc" },
    { 20528, "PARANA EM REDE SISTEMAS LTDA." },
    { 20529, "AMETEK SolidState Controls Inc de Argentina" },
    { 20530, "Johannes Kornfellner" },
    { 20531, "Matrix Networx" },
    { 20532, "DevStream Corporation" },
    { 20533, "2Know-IT GmbH" },
    { 20534, "Uniklinik Ulm" },
    { 20535, "Latvijas Mobilais Telefons SIA" },
    { 20536, "Austrian Parliament" },
    { 20537, "NIPPON EXPRESS CO.,LTD" },
    { 20538, "FIBRENETIX" },
    { 20539, "//////////fur////" },
    { 20540, "Red Lion Controls (SIXNET)" },
    { 20541, "CITTIO, Inc." },
    { 20542, "AirLink Communications, Inc." },
    { 20543, "Optovia Corporation" },
    { 20544, "Sungkyunkwan University" },
    { 20545, "BusinessLink Advertising Ltd." },
    { 20546, "Wissenschaftszentrum Berlin fuer Sozialforschung gGmbH" },
    { 20547, "Matthias Braun EDV" },
    { 20548, "SAP Hosting" },
    { 20549, "Pride S.p.A." },
    { 20550, "Red Squared plc" },
    { 20551, "DDR Freak, LLC" },
    { 20552, "Swisscom Broadcast SA" },
    { 20553, "Wellington Management Company, LLP" },
    { 20554, "kraai.org" },
    { 20555, "eTelemetry, Inc." },
    { 20556, "Hastings Entertainment Inc." },
    { 20557, "NOFware, Ltd." },
    { 20558, "University College of Oslo. Faculty of Engineering" },
    { 20559, "Engedi Technologies, Inc." },
    { 20560, "Alexander Janssen Consulting" },
    { 20561, "LiveWave, Inc." },
    { 20562, "North Electric Company, Inc." },
    { 20563, "TNC S.A." },
    { 20564, "Albuquerque Technical Vocational Institute" },
    { 20565, "Oxford Wireless Networks Ltd" },
    { 20566, "Taonix" },
    { 20567, "TELEGRID Technologies, Inc." },
    { 20568, "Citco Technology Mangement, Inc." },
    { 20569, "Inventec Enterprise System Corp." },
    { 20570, "ShenZhen Yinghetong Information & Technology  Co.,Ltd." },
    { 20571, "International Turnkey Systems" },
    { 20572, "virtual-image" },
    { 20573, "Universitaetsklinikum Aachen" },
    { 20574, "OXYAN SOFTWARE" },
    { 20575, "Nucleonet Inc" },
    { 20576, "University of Wales, Bangor" },
    { 20577, "schunk edv systeme gmbh" },
    { 20578, "St Ives Plymouth Ltd" },
    { 20579, "BITSO Build IT Solutions GmbH" },
    { 20580, "Kiwi Enterprises" },
    { 20581, "EVR Ltd." },
    { 20582, "Ebocom, LLC" },
    { 20583, "Union Switch & Signal" },
    { 20584, "Hunan Talkweb Information System Co. Ltd." },
    { 20585, "Diamond State Port Corp." },
    { 20586, "Century Digital Investment & Management Consulting Ltd." },
    { 20587, "Rose Electronics" },
    { 20588, "MaxTronic International Co., Ltd." },
    { 20589, "UKeduPerson Pilot" },
    { 20590, "RUBY Inc." },
    { 20591, "VISTA International Ltd." },
    { 20592, "People's Telephone Saratov, cjsc" },
    { 20593, "Guangdong Multiplication Communication Ltd Co." },
    { 20594, "XSif Software" },
    { 20595, "Prefeitura Municipal de Florianopolis" },
    { 20596, "TomWare s.r.l." },
    { 20597, "SurfCloud Ltd" },
    { 20598, "eReM.Studio" },
    { 20599, "Coventry Health Care, Inc." },
    { 20600, "Atlab s.r.l." },
    { 20601, "Thomas Jefferson High School for Science and Technology" },
    { 20602, "Xaraya Development Group" },
    { 20603, "Softhouse Informatica Ltda." },
    { 20604, "Nexior IT Services" },
    { 20605, "Antepo, Inc." },
    { 20606, "CLINIQUES UNIVERSITAIRES SAINT-LUC" },
    { 20607, "University of Angers" },
    { 20608, "Radboud University Nijmegen" },
    { 20609, "Scalable Computing Lab" },
    { 20610, "NOAA, OAR, FSL, ITS, DSG" },
    { 20611, "Flarepath Software Limited" },
    { 20612, "Time iCR" },
    { 20613, "Universit\0303\0251 catholique de Louvain (UCL)" },
    { 20614, "Exeo Technologies Inc." },
    { 20615, "Netli, Inc." },
    { 20616, "CGS World Inc." },
    { 20617, "TeTeSys" },
    { 20618, "Cinetica s.r.l." },
    { 20619, "UPC Ceska republika, a.s." },
    { 20620, "Valox Systems Co.Ltd" },
    { 20621, "Crystal Technology Solutions Group Inc" },
    { 20622, "IainG" },
    { 20623, "RSDB Holding b.v." },
    { 20624, "Nexus Telecom AG" },
    { 20625, "Serviciul de Telecomunicatii Speciale" },
    { 20626, "Software Systems A/S" },
    { 20627, "Institut National d'Histoire de l'Art" },
    { 20628, "Qual-Pro Corporation" },
    { 20629, "STREAMTEL" },
    { 20630, "ODIBOSS NETWORKS" },
    { 20631, "MC110-GRUPO1" },
    { 20632, "Barracuda Networks, Inc." },
    { 20633, "Security First Networks" },
    { 20634, "Langochat" },
    { 20635, "IberiSign" },
    { 20636, "Bendigo and District Division of General Practice Inc." },
    { 20637, "University of Texas of the Permian Basin" },
    { 20638, "Capital Markets CRC" },
    { 20639, "Entura, LLC" },
    { 20640, "Inomial Pty Ltd" },
    { 20641, "Vincent Consulting Group Inc." },
    { 20642, "Nexus Community" },
    { 20643, "Prime MX" },
    { 20644, "Vaasa Polytechnic" },
    { 20645, "Poly Information Ltd." },
    { 20646, "Convergenz" },
    { 20647, "University of Cambridge Computer Laboratory" },
    { 20648, "PK7" },
    { 20649, "Tyco Safety Products" },
    { 20650, "WG78 Ptb central" },
    { 20651, "Computer Vision Networks, Inc." },
    { 20652, "Arizona Department of Environmental Quality" },
    { 20653, "Illusions Internet Solutions" },
    { 20654, "Telegence Corporation" },
    { 20655, "Ikoro Digital Inc" },
    { 20656, "Archer" },
    { 20657, "Rascular Technology Ltd" },
    { 20658, "Finobra S.A." },
    { 20659, "Comodo Japan Inc." },
    { 20660, "Topone Information technology Co., Ltd" },
    { 20661, "Hitachi ULSI Systems Co., Ltd." },
    { 20662, "Heiko Jerke" },
    { 20663, "BV Associates" },
    { 20664, "NDE Netzdesign und -entwicklung AG" },
    { 20665, "Enervation GmbH" },
    { 20666, "Synchronoss Technologies Inc" },
    { 20667, "Prosilient Technologies AB" },
    { 20668, "Kaballero.Com LLC" },
    { 20669, "jelte.com" },
    { 20670, "SysCologne, Lutz Mischa Heitm\0303\0274ller" },
    { 20671, "Gee-Wiz Consultancy" },
    { 20672, "MemoryLink Corp" },
    { 20673, "MRO Direct, Inc" },
    { 20674, "Fullerton Elementary School District" },
    { 20675, "Reed Networks" },
    { 20676, "NIS4Grids" },
    { 20677, "Pulizzi Engineering, Inc." },
    { 20678, "Department of Computer Science, Rensselaer Polytechnic Institute" },
    { 20679, "Helmer & Zimmermann GmbH & Co.KG" },
    { 20680, "Tekmark/CSL International Solutions Inc." },
    { 20681, "Anta Systems, Inc." },
    { 20682, "Campusmart Ltd." },
    { 20683, "DigiDoc AB" },
    { 20684, "Metropolitan Health Corporate (Proprietary) Limited" },
    { 20685, "ADIES" },
    { 20686, "Pohl & Co. GmbH & Co. KG" },
    { 20687, "Roving Planet, Inc." },
    { 20688, "Seiri Inc." },
    { 20689, "Alliance Information Systems, LLC" },
    { 20690, "Harald Svab" },
    { 20691, "Techtell, Inc." },
    { 20692, "Ruffdogs" },
    { 20693, "DYNAWEB IT Services L.P." },
    { 20694, "Lightspeed Technologies Pte. Ltd." },
    { 20695, "StratusStation Group Inc." },
    { 20696, "Caixa Andorrana de Seguretat Social" },
    { 20697, "ThinPrint GmbH" },
    { 20698, "Lipetskenergo JSC" },
    { 20699, "CitiMortgage" },
    { 20700, "Trend Communications Ltd" },
    { 20701, "Peryam & Kroll Research Corporation" },
    { 20702, "Ritchie Capital Management" },
    { 20703, "eBuz Internetdienste GbR" },
    { 20704, "muumilaakso ry" },
    { 20705, "Holguin, Fahan & Associates, Inc." },
    { 20706, "Vision Web Networks, LLC" },
    { 20707, "InterCerve, Inc." },
    { 20708, "SYSLAB.COM GmbH" },
    { 20709, "Fremme's SOFTWARE-Utvikling" },
    { 20710, "American Medical Response Inc." },
    { 20711, "Platform Solutions, Inc." },
    { 20712, "Paradise Datacom LLC" },
    { 20713, "Noran Tel Communications Limited" },
    { 20714, "limitland development" },
    { 20715, "GiK Gesellschaft fuer innovative Kommunikationssysteme mbH" },
    { 20716, "Corbel Solutions, Inc" },
    { 20717, "FF Network Inc" },
    { 20718, "American School Foundation of Monterrey, A.C." },
    { 20719, "SHIN.Ltd" },
    { 20720, "MX Logic Inc" },
    { 20721, "Atomicweb, LLC" },
    { 20722, "NetSpira Networks" },
    { 20723, "Indus International, Inc." },
    { 20724, "Csibra Bt" },
    { 20725, "Etria, LLP" },
    { 20726, "Wilmington College" },
    { 20727, "Net Theatre" },
    { 20728, "Spook Limited" },
    { 20729, "Piotr Matusz" },
    { 20730, "eEye Digital Security" },
    { 20731, "TrueTel Communications Inc" },
    { 20732, "BlueScope Steel Limited" },
    { 20733, "JA Davey" },
    { 20734, "Internet Sheriff Technology Ltd" },
    { 20735, "ANDSCO I.T. Pty Ltd" },
    { 20736, "RS Telematica e Tecnologia da Informacao Ltda" },
    { 20737, "Cynics at Large" },
    { 20738, "TIBBO Technology, Inc." },
    { 20739, "Cortec Systems Pty Ltd" },
    { 20740, "AXISSOFT Corporation" },
    { 20741, "Qala Singapore Pte Ltd" },
    { 20742, "Hormann Funkwerk K\0303\0266lleda" },
    { 20743, "ISO (International Organization for Standardization)" },
    { 20744, "ICZ a.s." },
    { 20745, "WLN Technologies" },
    { 20746, "DIS Data Integration Services GmbH" },
    { 20747, "NORTEK" },
    { 20748, "Frei GmbH" },
    { 20749, "Grintek TCI (Pty) Ltd" },
    { 20750, "Technolution BV" },
    { 20751, "PERAX" },
    { 20752, "SA Polyclinique de Courlancy" },
    { 20753, "Pharos Consulting (Pty) Ltd." },
    { 20754, "Universit\0303\0244tsklinikum Aachen" },
    { 20755, "WestGlobal Ltd." },
    { 20756, "het Concertgebouw NV" },
    { 20757, "Prisacom s.a." },
    { 20758, "netSurity Ltd" },
    { 20759, "Kepler-Rominfo S.A." },
    { 20760, "Autonomous noncommercial organization \"Scientific and Training Center of" },
    { 20761, "Uniklinikum Mannheim" },
    { 20762, "Passage Consortia C/O Sony Electronics (Trustee)" },
    { 20763, "Fastenal Company, Inc." },
    { 20764, "David Cross Technical Consulting" },
    { 20765, "Rosati Kain" },
    { 20766, "QAI India Ltd" },
    { 20767, "Vereinigte Postversicherung VVaG" },
    { 20768, "St. Mary's High School" },
    { 20769, "Immaculate Conception School" },
    { 20770, "ADSTRA SYSTEMS INC." },
    { 20771, "Priority Networks, Inc." },
    { 20772, "Optica Technologies Inc." },
    { 20773, "Accenture Business Services for Utilities" },
    { 20774, "OMT Systems (Shenzhen) Limited" },
    { 20775, "Aspire Information Services, LLC" },
    { 20776, "INAF - Osservatorio Astronomico di Padova" },
    { 20777, "Flexetech Solutions, Inc." },
    { 20778, "SmartWare" },
    { 20779, "Inova Venture Pte Ltd" },
    { 20780, "Gemeinsamenes Gebietsrechenzentrum Hagen - SG 2.5" },
    { 20781, "Scientific Research Institute of Applied Information Technologies" },
    { 20782, "soc. coop. bilanciai" },
    { 20783, "ARGELA Yazilim ve Bilisim Teknolojileri A.S." },
    { 20784, "HiTeKnowledge Limited" },
    { 20785, "Beta Systems Software AG" },
    { 20786, "Techspan System Ltd" },
    { 20787, "Parc Cientific de Barcelona" },
    { 20788, "Unassigned" },
    { 20789, "PowerMeMobile.com" },
    { 20790, "Harrington Group, Inc." },
    { 20791, "keyX.net Consulting SRL" },
    { 20792, "Erdmann Systemberatung" },
    { 20793, "NetBridge Inc." },
    { 20794, "IT Schaller GmbH" },
    { 20795, "REALTIMEIMAGE" },
    { 20796, "ShenZhen Roytel Technology Ltd." },
    { 20797, "Great Dragon Infomation Technology(Group)Co.,Ltd." },
    { 20798, "TDN GmbH" },
    { 20799, "Universitaet Konstanz" },
    { 20800, "JSC Promsvyaz-Invest" },
    { 20801, "Exxon Mobil Corporation" },
    { 20802, "Sanlam Ltd." },
    { 20803, "Tyler Retail Systems, Inc." },
    { 20804, "Open PLC European Research Alliance (Opera)" },
    { 20805, "Beijing Sunniwell BroadBand ditital technology Corp. Ltd." },
    { 20806, "Segurmatica" },
    { 20807, "Federal Bureau of Investigation" },
    { 20808, "Monaco Telecom" },
    { 20809, "Agami Systems, Inc." },
    { 20810, "Hamilton Consulting NSW Pty Ltd" },
    { 20811, "International Securities Exchange, LLC" },
    { 20812, "NetMon Information Systems Ltd." },
    { 20813, "Ipcon Informationssysteme oHG" },
    { 20814, "AMC SA" },
    { 20815, "Zend Technologies Ltd." },
    { 20816, "Alexandru Ioan Cuza University" },
    { 20817, "Argos Messtechnik GmbH" },
    { 20818, "SUNTEK TECHNOLOGY CO., LTD." },
    { 20819, "Allenbrook, Inc." },
    { 20820, "The University of Texas at San Antonio" },
    { 20821, "Information and Display Systems, LLC" },
    { 20822, "Franwell, Inc." },
    { 20823, "Carefx Corporation" },
    { 20824, "Lions Gate Software, Inc." },
    { 20825, "Touch22 Software and Consulting" },
    { 20826, "Convera" },
    { 20827, "Banco Central de Costa Rica" },
    { 20828, "Schweizerische Lebensversicherungs- und Rentenanstalt" },
    { 20829, "Stadtverwaltung Dresden" },
    { 20830, "Reflex AS" },
    { 20831, "CZFree.Net" },
    { 20832, "Ryder Systems Ltd." },
    { 20833, "Terminales de Telecomunicacion Terrestre, S.L." },
    { 20834, "Alike Group" },
    { 20835, "BD Digital Lab. Co., Ltd" },
    { 20836, "Confer Computing Consultants Company" },
    { 20837, "DFU services" },
    { 20838, "GaVI mbH" },
    { 20839, "Broadcast Tools, Inc." },
    { 20840, "Thomson Technology Limited" },
    { 20841, "The Community Group Inc" },
    { 20842, "Arena Solutions, Inc." },
    { 20843, "Philipp Strozyk" },
    { 20844, "L'OREAL" },
    { 20845, "Linux Information Systems AG" },
    { 20846, "SURFsara" },
    { 20847, "Atlas Development Corporation" },
    { 20848, "Zope Corporation" },
    { 20849, "OMT Systems (Shenzhen) Limited" },
    { 20850, "TechNerdVana" },
    { 20851, "Groupe Bell Nordiq inc." },
    { 20852, "CrimTrac" },
    { 20853, "Eurorail International" },
    { 20854, "OTC Wireless Inc." },
    { 20855, "Scientific Technologies Corp" },
    { 20856, "Pattern Matched Technologies" },
    { 20857, "Inspired Technologies Ltd" },
    { 20858, "Casa Systems, Inc." },
    { 20859, "Citco Technology Mangement, Inc." },
    { 20860, "Liberty Enterprises Inc." },
    { 20861, "Dansk System Elektronik A/S" },
    { 20862, "Online Learning Australia Pty. Ltd." },
    { 20863, "Utiba Pty Ltd" },
    { 20864, "Tower Technologies" },
    { 20865, "Sri Lanka Telecom" },
    { 20866, "Eljakim Information Technology BV" },
    { 20867, "danfferliu Corporation" },
    { 20868, "Helge Gudmundsen" },
    { 20869, "Frank Vercruesse" },
    { 20870, "Pufferbox Pty. Ltd." },
    { 20871, "Kredietbank S.A. Luxembourg" },
    { 20872, "Sto AG" },
    { 20873, "PROTEI Ltd" },
    { 20874, "H\0303\0245ms\0303\0270 Patentbyr\0303\0245 ANS" },
    { 20875, "DevExperts LLC" },
    { 20876, "Vorarlberger Telekommunikations GesmbH" },
    { 20877, "Vine Linux" },
    { 20878, "VineCaves, Ltd." },
    { 20879, "MBIT GmbH" },
    { 20880, "MagnaQuest Technologies" },
    { 20881, "Catenare LLC" },
    { 20882, "PCDEMANO Inc" },
    { 20883, "Evangelische Landeskirche Wuerttemberg" },
    { 20884, "BDT GmbH & Co. KG" },
    { 20885, "Kontron Modular Computers SA (formerly 'Thales Computers')" },
    { 20886, "Dr. Glinz COVIS GmbH" },
    { 20887, "SOLSOFT" },
    { 20888, "SIS Spektrum s.r.o." },
    { 20889, "Comsys B.V." },
    { 20890, "Sebastian Kueppers Computer-, Medien- und Eventservice" },
    { 20891, "Star Internet Ltd." },
    { 20892, "CITEL Technologies Inc." },
    { 20893, "LShift Ltd" },
    { 20894, "Yirdis B.V." },
    { 20895, "Diplomado" },
    { 20896, "NuVox Communications, Inc." },
    { 20897, "Determina Inc." },
    { 20898, "Sungard SBI" },
    { 20899, "Apollo Interactive, Inc." },
    { 20900, "Quantech Global Services LLC" },
    { 20901, "Virtual Business Communities Inc." },
    { 20902, "johnstonshome.org" },
    { 20903, "Children's Hospital - Boston" },
    { 20904, "Risolviamo" },
    { 20905, "Unicible S.A." },
    { 20906, "Cubika S.A." },
    { 20907, "Regent College" },
    { 20908, "Emergin, Inc." },
    { 20909, "Exempla Healthcare" },
    { 20910, "PT OneHUB Technology" },
    { 20911, "twilley.org" },
    { 20912, "Publishing firm \0302\0253Vidrodzhenia\0302\0273 Ltd." },
    { 20913, "OJSC RTComm.RU" },
    { 20914, "Deutsche Telekom - CSC Wuerzburg" },
    { 20915, "NATIONAL-BANK AG, Essen" },
    { 20916, "AVTECH Software, Inc." },
    { 20917, "FondsServiceBank" },
    { 20918, "Wicked Studio" },
    { 20919, "Manobi" },
    { 20920, "PKWARE, Inc." },
    { 20921, "Hillstone Products Ltd" },
    { 20922, "Pro Dimension Ltd." },
    { 20923, "Myxomop" },
    { 20924, "Proyecto OTF U.de.Chile" },
    { 20925, "Baker & McKenzie" },
    { 20926, "Mase Technologies, LLC" },
    { 20927, "TSI Sports Incorporated" },
    { 20928, "Tangent Systems" },
    { 20929, "SYSGO AG" },
    { 20930, "Ren\0303\0251 Alegr\0303\0255a S\0303\0241ez" },
    { 20931, "Software Builders Exchange" },
    { 20932, "yobe.org" },
    { 20933, "Tomsk State University of Control Systems and Radioelectronics" },
    { 20934, "ITdesign software projects and consulting" },
    { 20935, "Anystream, Inc." },
    { 20936, "CHINA COMMUNICATIONS STANDARDS ASSOCIATIONS" },
    { 20937, "Nimrod AS" },
    { 20938, "ETL Systems Ltd." },
    { 20939, "videoNEXT LLC" },
    { 20940, "The eBiz Shop, LLC." },
    { 20941, "Palo Alto Research Center, Inc." },
    { 20942, "China Telecom-Guangzhou Research and Development Center" },
    { 20943, "QOSMOS SA" },
    { 20944, "Modular Blade Server" },
    { 20945, "East Online, LLC" },
    { 20946, "BDM Business Data Management GmbH" },
    { 20947, "Cox Communications San Diego" },
    { 20948, "manzanita Inc." },
    { 20949, "Anadarko Petroleum Inc." },
    { 20950, "Interhack Corporation" },
    { 20951, "Brevient Technologies, Inc." },
    { 20952, "Exabridge" },
    { 20953, "Haifa University" },
    { 20954, "Xtendreach Limited" },
    { 20955, "Sunet" },
    { 20956, "Emerson Climate Technologies, Alco Products" },
    { 20957, "E-Government Solutions (UK) Ltd." },
    { 20958, "I-Nex Corporation Pty. Ltd." },
    { 20959, "Siemens d.d. Hrvatska" },
    { 20960, "Laboratory of Content Systems(LCS)" },
    { 20961, "Communication Technologies" },
    { 20962, "Multimedia Polska" },
    { 20963, "Kattare Internet Services" },
    { 20964, "Camille Bauer" },
    { 20965, "HVR Consulting Services Ltd" },
    { 20966, "Jesus College, Oxford" },
    { 20967, "Anevia" },
    { 20968, "Genomatix Software GmbH" },
    { 20969, "EUDATA SYSTEMS S.A." },
    { 20970, "LISA GmbH" },
    { 20971, "Baltnet Ltd." },
    { 20972, "British Airways Plc" },
    { 20973, "NextiraOne Czech s.r.o." },
    { 20974, "American Megatrends, Inc" },
    { 20975, "PONTUSYS" },
    { 20976, "Paul Smith Computer Services" },
    { 20977, "Comune di Imola" },
    { 20978, "DC-SatNet Ltd." },
    { 20979, "WT Finland Ltd" },
    { 20980, "tux LLC" },
    { 20981, "Atrocity MUD" },
    { 20982, "PCDEMANO Inc" },
    { 20983, "IIT Madras" },
    { 20984, "Geonetics" },
    { 20985, "Nethonnun ehf." },
    { 20986, "Universidad del CEMA" },
    { 20987, "Philadelphia Computer Institute" },
    { 20988, "Rackspace" },
    { 20989, "Systems Research and Development, Inc." },
    { 20990, "Aspect Loss Prevention LLC" },
    { 20991, "Family-Williams Inc." },
    { 20992, "CradlePoint, Inc." },
    { 20993, "Camujo" },
    { 20994, "Europa Communications Pty Ltd" },
    { 20995, "Progress Energy" },
    { 20996, "ACCESS Co. Ltd." },
    { 20997, "Lotus Technologies SRL" },
    { 20998, "Honeywell International Inc" },
    { 20999, "Willis Group" },
    { 21000, "imetric" },
    { 21001, "Stratizon Inc." },
    { 21002, "Parallax Networking Limited" },
    { 21003, "Dynamic Network Integration, Inc." },
    { 21004, "American Technology Integrators Corporation" },
    { 21005, "GERMAN NETWORK GMBH" },
    { 21006, "OpenDAS.org" },
    { 21007, "InoStor" },
    { 21008, "Informed Control Inc." },
    { 21009, "McGuire & Associates, Inc" },
    { 21010, "eCollege" },
    { 21011, "DotNetShop" },
    { 21012, "iHotel International Inc." },
    { 21013, "Xirrus, Inc." },
    { 21014, "Gamerz Hub" },
    { 21015, "Art of Living Foundation" },
    { 21016, "IntruGuard Devices" },
    { 21017, "IPeak Networks Inc." },
    { 21018, "Paxar Americas, Inc." },
    { 21019, "River Systems, Inc" },
    { 21020, "Stowarzyszenie Freeze NET Amatorska Siec Komputerowa" },
    { 21021, "Perimeter Technology Center, Inc." },
    { 21022, "The College Board" },
    { 21023, "Forbrich Computer Consulting Ltd." },
    { 21024, "Electronics corporation of india. Ltd" },
    { 21025, "ICOMM TELE LTD." },
    { 21026, "Hauf Electric Co." },
    { 21027, "MIP" },
    { 21028, "Digital Motorworks, LP." },
    { 21029, "Giant Steps" },
    { 21030, "PeerApp" },
    { 21031, "Helga Adam und Rocio Manzano Romero GBRmbH" },
    { 21032, "Argent Networks ltd" },
    { 21033, "Taikang Life Insurance Co.,Ltd." },
    { 21034, "Pratama Sastriawan Systems" },
    { 21035, "DEV Systemtechnik GmbH & Co. KG" },
    { 21036, "Ultrapower Software Co., Ltd. Beijing" },
    { 21037, "CHUNG HUNG STEEL CO., LTD." },
    { 21038, "Radio IP Software Inc." },
    { 21039, "YuCa Tech. Corp." },
    { 21040, "Fiberplex, Inc" },
    { 21041, "Banchile Corredores de Bolsa S.A." },
    { 21042, "PRT Systems Ltd" },
    { 21043, "AREVA" },
    { 21044, "Mauro Calderara" },
    { 21045, "Intinor AB" },
    { 21046, "University Of Wisconsin Extension" },
    { 21047, "Banco de Credito e Inversiones" },
    { 21048, "Copenhagen Municipal" },
    { 21049, "ROMPETROL SA" },
    { 21050, "Freebits" },
    { 21051, "Init Seven AG" },
    { 21052, "Interact S.A." },
    { 21053, "Singlefin" },
    { 21054, "Yardi Systems, Inc." },
    { 21055, "Sri Lanka Telecom Services Ltd." },
    { 21056, "DeployLinux Consulting" },
    { 21057, "Themis Computer" },
    { 21058, "Tizor Systems" },
    { 21059, "Nyvri" },
    { 21060, "Global Healthcare Exchange" },
    { 21061, "Netaquila Solutions Pvt. Ltd" },
    { 21062, "Chris Forkin Consulting" },
    { 21063, "MaqSys" },
    { 21064, "TSingTec Ltd." },
    { 21065, "SHENZHEN WLAN Research Center,CCSA" },
    { 21066, "SNCF (Soci\0303\0251t\0303\0251 Nationale des Chemins de fer Fran\0303\0247ais)" },
    { 21067, "Elitecore Technologies Ltd." },
    { 21068, "University of Southern Denmark" },
    { 21069, "Radford Control Systems" },
    { 21070, "Intentia Research & Development" },
    { 21071, "EFS Inc." },
    { 21072, "Arnold Magnetics" },
    { 21073, "webcreations.ca" },
    { 21074, "PureWave Networks, Inc." },
    { 21075, "Old Red Mill" },
    { 21076, "Science Museum of Minnesota" },
    { 21077, "DigiTar" },
    { 21078, "dafa" },
    { 21079, "HAIPE" },
    { 21080, "Frog Navigation Systems B.V." },
    { 21081, "Persium Inc." },
    { 21082, "EUN Partnership a.i.s.b.l." },
    { 21083, "Mairie de Paris" },
    { 21084, "SD Laboratories" },
    { 21085, "Open Alliance Sofware Libre, S.A." },
    { 21086, "Monolith Productions" },
    { 21087, "Infosia Services" },
    { 21088, "krix.biz Internetdienstleistungen" },
    { 21089, "Flywheel Corporation" },
    { 21090, "Ithaka Harbors, Inc." },
    { 21091, "Exinda Networks Pty Ltd" },
    { 21092, "Raindance Wireless" },
    { 21093, "Got.Net - The Internet Connection, Inc." },
    { 21094, "Ricoh Australia Pty Ltd" },
    { 21095, "Commonwealth Bank of Australia" },
    { 21096, "Quantier Inc." },
    { 21097, "Kerr-McGee Corporation" },
    { 21098, "IECAS(Chin. Acad. of Sci)" },
    { 21099, "Alltrix Sdn Bhd" },
    { 21100, "Linwork Inform\0303\0241tica S/C Ltda" },
    { 21101, "Verreau Enterprise" },
    { 21102, "ControlTier Software, Inc." },
    { 21103, "Mandrakesoft" },
    { 21104, "Mofet Instititue" },
    { 21105, "MANGO networks Inc." },
    { 21106, "Shanghai Ulink Telecom Technologies Co., Ltd." },
    { 21107, "Novagem Ltd" },
    { 21108, "Harting Electric GmbH & Co KG" },
    { 21109, "Knowledge Zone" },
    { 21110, "SANITOP-WINGENROTH GmbH & Co. KG" },
    { 21111, "Datalogic S.p.A" },
    { 21112, "TNO Telecom" },
    { 21113, "Hashbang Consulting Ltd" },
    { 21114, "Contec s.j." },
    { 21115, "TFTEN SA" },
    { 21116, "NoVi Pawel Zimnoch" },
    { 21117, "AMG Systems Limited" },
    { 21118, "AB2R" },
    { 21119, "Guru, informacijske tehnologije d.o.o." },
    { 21120, "Sanofi-Aventis" },
    { 21121, "m0n0" },
    { 21122, "G.I.S. Global Information Services GmbH" },
    { 21123, "Amps llc" },
    { 21124, "Adesium" },
    { 21125, "dico-online" },
    { 21126, "vFortress Network Security Pvt. Ltd." },
    { 21127, "KCI Technologies, Inc." },
    { 21128, "Heimetli Software AG" },
    { 21129, "Ideal Solution, LLC" },
    { 21130, "GlassHouse UK Ltd" },
    { 21131, "Phonesync Ltd." },
    { 21132, "Novum Information Technology BV" },
    { 21133, "University of Iowa Hospitals and Clinics" },
    { 21134, "University of Minnesota" },
    { 21135, "Kimmel.biz" },
    { 21136, "North Central University" },
    { 21137, "Astron Computer Corporation" },
    { 21138, "Electrosys S.r.l." },
    { 21139, "Proofpoint, Inc." },
    { 21140, "Xernolan Consulting" },
    { 21141, "Elemental Security, Inc." },
    { 21142, "ITER" },
    { 21143, "Devis" },
    { 21144, "Maieutica - Cooperativa de Ensino Superior, Crl" },
    { 21145, "Intalio, Inc." },
    { 21146, "Wiltel Communications LLC" },
    { 21147, "Innotrac Corporation" },
    { 21148, "Soleil Securities Group, Inc." },
    { 21149, "H Bauer Ediciones" },
    { 21150, "XKL, LLC" },
    { 21151, "Priority Technologies, Inc." },
    { 21152, "Nucor Steel Indiana" },
    { 21153, "Academy of Fine Arts" },
    { 21154, "Harland Financial Solutions" },
    { 21155, "Chameleon Technology, Inc." },
    { 21156, "pipp" },
    { 21157, "RAE Internet Inc." },
    { 21158, "Linux-Online" },
    { 21159, "IPcom S.A." },
    { 21160, "Emerson Retail Services" },
    { 21161, "Flamingo Internet Navigators" },
    { 21162, "Voxiva Inc." },
    { 21163, "EXPERTiS Tecnolog\0303\0255a S.A. de C.V." },
    { 21164, "Legacy Health System" },
    { 21165, "Tidal Networks" },
    { 21166, "Personal Broadband Australia" },
    { 21167, "The Correspondence School" },
    { 21168, "SCF of Arizona" },
    { 21169, "JTHInc Computing Solutions" },
    { 21170, "Vortice Research Development Pty Ltd" },
    { 21171, "NRG Global, Inc." },
    { 21172, "Elan Designs" },
    { 21173, "WSCICC" },
    { 21174, "DISC, State of Kansas" },
    { 21175, "Xinupro, LLC" },
    { 21176, "Datalucid limited" },
    { 21177, "St. John School" },
    { 21178, "Anteya Technology Corporation" },
    { 21179, "Beijing E-tech Technology Co., ltd" },
    { 21180, "SwiDyna Technologies,Inc" },
    { 21181, "anweb" },
    { 21182, "Tonediy" },
    { 21183, "lightelli Ltd." },
    { 21184, "AirMsg, Inc." },
    { 21185, "Ioneda, Inc." },
    { 21186, "Corner Stone Technology Inc" },
    { 21187, "SenseStream Limited" },
    { 21188, "eyes-works Corporation" },
    { 21189, "Huon Associates Pty Ltd" },
    { 21190, "MayAZ Software Services" },
    { 21191, "KCodes Corporation" },
    { 21192, "Goldman Sachs JBWere Pty Ltd" },
    { 21193, "Webvision" },
    { 21194, "LLC Inform-mobil" },
    { 21195, "Non-Stop Systems (South Africa) (Pty) Limited" },
    { 21196, "TerraPages Pty. Ltd." },
    { 21197, "CryptoEx" },
    { 21198, "RTI-Zone" },
    { 21199, "silkway" },
    { 21200, "Dr. Ruff Software GmbH" },
    { 21201, "Linuma Advanced Hosting, Inc." },
    { 21202, "BT (Germany) GmbH & Co. oHG" },
    { 21203, "ARES Inc." },
    { 21204, "MHGS" },
    { 21205, "Webdyn" },
    { 21206, "MobileRRD" },
    { 21207, "Technische Universitaet Bergakademie Freiberg" },
    { 21208, "IKS GmbH Jena" },
    { 21209, "Mayr-Melnhof Packaging International GmbH" },
    { 21210, "kairos" },
    { 21211, "Fraunhofer-Institute for Telecommunications Heinrich-Hertz-Institut" },
    { 21212, "Incito Ltd" },
    { 21213, "topolis.lt" },
    { 21214, "Eidetix S.r.L." },
    { 21215, "MM-Karton" },
    { 21216, "Telepo AB" },
    { 21217, "Lux Servizi di Luigi Iotti" },
    { 21218, "Sette Querce" },
    { 21219, "Solidex S.A." },
    { 21220, "BASF AG" },
    { 21221, "Nexus Advanced Technologies S.r.l." },
    { 21222, "Profline BV" },
    { 21223, "Akris BV" },
    { 21224, "4G Systeme GmbH" },
    { 21225, "British Heart Foundation" },
    { 21226, "Linn Products Ltd" },
    { 21227, "ABI - Associazione Bancaria Italiana" },
    { 21228, "Aspex Semiconductor Ltd" },
    { 21229, "Leningrad Research and Development Institute of Telecommunications" },
    { 21230, "Iriga Networks" },
    { 21231, "Kugele Elektronik" },
    { 21232, "Jung Myoung Ltd" },
    { 21233, "Peter Schmaedicke" },
    { 21234, "o-n-s CO.,LTD." },
    { 21235, "Nehlsen IT Training und Beratung" },
    { 21236, "Laseur Enterprises" },
    { 21237, "Wright Express" },
    { 21238, "BrasilSat Harald S/A" },
    { 21239, "Geist Manufacturing, Inc" },
    { 21240, "PinguSolution Meierhoff/Woltmann GbR" },
    { 21241, "Chezwam" },
    { 21242, "SimDesk Technologies Inc." },
    { 21243, "LANet Sp. z o.o." },
    { 21244, "Mt Umunhum Wireless" },
    { 21245, "Macdonald Associates GmbH" },
    { 21246, "Quantitative Imaging" },
    { 21247, "verimatrix" },
    { 21248, "Pixel Software Technologies" },
    { 21249, "Lightwave Solutions, Inc." },
    { 21250, "Crane River Consulting" },
    { 21251, "Secure Campus Inc" },
    { 21252, "FMS Internetservice M\0303\0274ller und Schaub GbR" },
    { 21253, "TransOptix Inc." },
    { 21254, "Arxceo Corporation" },
    { 21255, "SanYuHu LLC" },
    { 21256, "Corporate Technologies Incorporated" },
    { 21257, "Transera Communications Inc" },
    { 21258, "Tongel.org" },
    { 21259, "Oregon Department of Human Services" },
    { 21260, "XYPRO Technology Corporation" },
    { 21261, "Aventia SL" },
    { 21262, "Second Shift Inc." },
    { 21263, "Pacific College of Oriental Medicine" },
    { 21264, "AFC Commercial" },
    { 21265, "Dark Horse Comics, Inc." },
    { 21266, "Jab Ltd" },
    { 21267, "IT-Service Lehmann" },
    { 21268, "Tecnocity, S.C." },
    { 21269, "OnSite Systems, Inc." },
    { 21270, "SWAL" },
    { 21271, "ITT Educational Services, Inc." },
    { 21272, "Thomas P. Olsen" },
    { 21273, "MediaWeb IT" },
    { 21274, "Camiant Inc" },
    { 21275, "n3k Informatik Ltd" },
    { 21276, "A.C.C.E.S.S. Inc." },
    { 21277, "City of Ottawa" },
    { 21278, "Intellambda Systems Inc." },
    { 21279, "State of Kansas" },
    { 21280, "Computer Access Technology Corporation" },
    { 21281, "Empresa Jornal\0303\0255stica Caldas J\0303\0272nior Ltda" },
    { 21282, "SYS/IO" },
    { 21283, "The Forest Industry Online Inc." },
    { 21284, "Edustructures LLC" },
    { 21285, "Catalyst IT Ltd" },
    { 21286, "Sygate Technologies" },
    { 21287, "Mikrovlny s.r.o." },
    { 21288, "Cetacea Networks Corporation" },
    { 21289, "grid-zero.net" },
    { 21290, "GBP Software, LLC" },
    { 21291, "Tributes Online Ltd" },
    { 21292, "kaengs reich" },
    { 21293, "Fabric7 Systems, Inc." },
    { 21294, "KIKA S.A." },
    { 21295, "Cunningham and Othen" },
    { 21296, "Infinera Corp." },
    { 21297, "U.Z.KULeuven" },
    { 21298, "Odyssey Pharmaceuticals, Inc." },
    { 21299, "BigFix, Inc." },
    { 21300, "Watt 22 T\0303\0241vk\0303\0266zl\0303\0251stechnikai Szolg\0303\0241ltat\0303\0263 Kft." },
    { 21301, "Dialmex, L.L.C." },
    { 21302, "Wright State University" },
    { 21303, "Periscope Ltd." },
    { 21304, "BC Genome Sciences Centre" },
    { 21305, "Katholischen Hochschulgemeinde Linz" },
    { 21306, "Cyberfamily.dk" },
    { 21307, "Tel.Pacific" },
    { 21308, "NeoMon" },
    { 21309, "Juni Australia Pty Ltd" },
    { 21310, "Center for High Energy Physics" },
    { 21311, "GammaStream Technologies, Inc." },
    { 21312, "LISAsoft Pty. Ltd." },
    { 21313, "VRx, Inc." },
    { 21314, "Sizwe" },
    { 21315, "The State Key Laboratory Of Information Security of China" },
    { 21316, "Octtel Communication Co., Ltd." },
    { 21317, "ATEN INTERNATIONAL CO., LTD." },
    { 21318, "Intec NetCore, Inc," },
    { 21319, "Symbio Group" },
    { 21320, "SourceMachine Develop Ltd." },
    { 21321, "CITIC Telecom 1616 Limited" },
    { 21322, "Estonian Academy of Arts" },
    { 21323, "Consolidated Contractors International Company S.A.L" },
    { 21324, "Databus Inc." },
    { 21325, "Siedlung Cuxhaven AG" },
    { 21326, "Heim & Haus GmbH & Co KG" },
    { 21327, "Westsaechsische Hochschule Zwickau" },
    { 21328, "Metos Oy" },
    { 21329, "secXtreme GmbH" },
    { 21330, "JSC \"TransTeleCom Company\"" },
    { 21331, "RESEAUNANCE" },
    { 21332, "Luciad NV" },
    { 21333, "Chongqing Putian Communication Equipment Ltd, Co." },
    { 21334, "ACCIO GLOBAL" },
    { 21335, "OSRAM OS GmbH" },
    { 21336, "CAEN SpA" },
    { 21337, "PowerSource" },
    { 21338, "NetFX" },
    { 21339, "Fiat Auto S.p.A." },
    { 21340, "Verax Systems" },
    { 21341, "Corner Banca SA" },
    { 21342, "EpiSoftware Ltd." },
    { 21343, "n3k Informatik GmbH" },
    { 21344, "Claranet GmbH" },
    { 21345, "Sachs" },
    { 21346, "Forler IT Training & Consulting" },
    { 21347, "ITCnetworks" },
    { 21348, "Song Networks Svenska AB" },
    { 21349, "TTG Europe PLC" },
    { 21350, "SHS Informationssysteme AG" },
    { 21351, "Gyrus Prod SRL" },
    { 21352, "Zhang Ye" },
    { 21353, "Hospital Santa M\0303\0264nica" },
    { 21354, "Bezirksamt Lichtenberg von Berlin" },
    { 21355, "Ascential Software" },
    { 21356, "Austrian Grid" },
    { 21357, "antislash" },
    { 21358, "China ZLTelecom Telecommunication Equipment Co., LTD" },
    { 21359, "OPNET Technologies, Inc" },
    { 21360, "Chatsworth Products, Inc" },
    { 21361, "Catholic Healthcare West" },
    { 21362, "IFOTEC" },
    { 21363, "Valhalla Media" },
    { 21364, "Revinetix, Inc" },
    { 21365, "Accelerate Consultancy Limited" },
    { 21366, "Open Source Lab" },
    { 21367, "Connectathon.Net" },
    { 21368, "The Cloud Networks Ltd." },
    { 21369, "Terrasat Communications, Inc." },
    { 21370, "Thales Navigation" },
    { 21371, "Whited.US" },
    { 21372, "JavaPlus" },
    { 21373, "netfilter/iptables project" },
    { 21374, "Fabbricadigitale srl" },
    { 21375, "Interactive Vision Mind Beacon sp. z o.o." },
    { 21376, "Gruppenkasper" },
    { 21377, "Zhongyuan Institute of Technology" },
    { 21378, "Honda of America Mfg., Inc." },
    { 21379, "Shenzhen aike Co.,Ltd." },
    { 21380, "Guangzhou aike Co.,Ltd." },
    { 21381, "Viessmann Werke GmbH & Co KG" },
    { 21382, "united bolta nigeria limited" },
    { 21383, "bo-tech GmbH & Co. KG" },
    { 21384, "serie a - digitale medien und systeme GmbH" },
    { 21385, "Escalon Networks, Inc." },
    { 21386, "Quiettouch Inc." },
    { 21387, "The John Simon Guggenheim Memorial Foundation" },
    { 21388, "Risetek Inc." },
    { 21389, "King Fahd University of Petroleum and Minerals" },
    { 21390, "ALAIN BRION SARL" },
    { 21391, "Netalley Networks LLP" },
    { 21392, "Tech Arabia" },
    { 21393, "CareerWeaver.net" },
    { 21394, "aplis.cz, a.s." },
    { 21395, "Project Logicaldreams" },
    { 21396, "Brand X Software, Inc." },
    { 21397, "FiberZone Networks LTD." },
    { 21398, "Cybergate Technologies Corp" },
    { 21399, "Active Circle SA" },
    { 21400, "e-geek" },
    { 21401, "DSNCON GmbH" },
    { 21402, "Epic Energy" },
    { 21403, "A-First Technology CO.,LTD." },
    { 21404, "DG Telecom Co. Ltd." },
    { 21405, "COMSATS Internet Services" },
    { 21406, "azh GmbH" },
    { 21407, "Maier" },
    { 21408, "Ernitec A/S" },
    { 21409, "ARTAX, a. s." },
    { 21410, "Kennisnet" },
    { 21411, "gocept gmbh & co. kg" },
    { 21412, "Andreas Wachter" },
    { 21413, "ScriptLogic Corporation" },
    { 21414, "Batra Consulting, Inc." },
    { 21415, "Option nv" },
    { 21416, "Centre Hospitalier de la C\0303\0264te Basque" },
    { 21417, "tdb Software Service GmbH" },
    { 21418, "Unient Communications, a.s." },
    { 21419, "TEDIAL S.L." },
    { 21420, "HanseMerkur Krankenversicherung a.G." },
    { 21421, "Yassine Zairi LTD." },
    { 21422, "CVW" },
    { 21423, "ConnecTerra, Inc." },
    { 21424, "Kanagawa Prefectural Board of Education" },
    { 21425, "Institute for Automation and Control Processes (IACP) FEBRAS" },
    { 21426, "Hoekstra Consulting Group" },
    { 21427, "Weisenberger Solarstromerzeugung und Vertrieb" },
    { 21428, "Aepona Ltd" },
    { 21429, "SUNTECH Telecom Solution LTDA" },
    { 21430, "inPUT Softwareentwicklungs GmbH" },
    { 21431, "SAE International" },
    { 21432, "DigiNet Corporation" },
    { 21433, "Interface Software, Inc." },
    { 21434, "Karolis Dautartas Personal Enterprise" },
    { 21435, "Inner Class Software Engineering Limited" },
    { 21436, "basis06 AG" },
    { 21437, "ATEN Canada Technologies Inc." },
    { 21438, "Thrunet" },
    { 21439, "Beijing Mission Communication Co., Ltd." },
    { 21440, "XIUS India Ltd." },
    { 21441, "KBK e-vallalkozasa" },
    { 21442, "GAPIC (PVT) LTD" },
    { 21443, "Caemar Software" },
    { 21444, "OSS Technologies (Pty) Ltd" },
    { 21445, "eSilicon Corporation" },
    { 21446, "ZIPPtec Systemhaus GmbH" },
    { 21447, "Clinton Group, Inc." },
    { 21448, "KarstadtQuelle AG" },
    { 21449, "Riversoft Integracao e Desenvolvimento de Software Ltda" },
    { 21450, "Radiantek" },
    { 21451, "Topera Technology Ltd." },
    { 21452, "AUNA OPERADORES DE TELECOMUNICACIONES, S.A." },
    { 21453, "GatherWorks, Inc." },
    { 21454, "data voice technologies GmbH" },
    { 21455, "Sinosoft Co.,LTD" },
    { 21456, "LV1871" },
    { 21457, "Demandware, Inc." },
    { 21458, "Clovis Solutions, Inc." },
    { 21459, "CaLviX" },
    { 21460, "Global Infotek, Inc." },
    { 21461, "Cole National" },
    { 21462, "Toro Co" },
    { 21463, "UZ Gent" },
    { 21464, "Adelior SA" },
    { 21465, "Vipond Inc." },
    { 21466, "DOMISYS SA" },
    { 21467, "Uber Technologies cc" },
    { 21468, "Vijit Consulting" },
    { 21469, "Blade Fusion" },
    { 21470, "schematech" },
    { 21471, "SimpleRezo" },
    { 21472, "xmled.org" },
    { 21473, "View500" },
    { 21474, "Ardec International Pty. Ltd." },
    { 21475, "Farsands Corporation Limited" },
    { 21476, "Academia Sinica Grid Computing Centre" },
    { 21477, "TaiwanGrid" },
    { 21478, "AdCoCom GmbH" },
    { 21479, "Icepage AB" },
    { 21480, "Shenzhen Olym-tech Co., Ltd." },
    { 21481, "TKM Telekommunikation und Elektronik GmbH" },
    { 21482, "SAIPM" },
    { 21483, "Quest Retail Technology Pty Ltd" },
    { 21484, "SIGMETA GmbH" },
    { 21485, "UNIS Ukraine" },
    { 21486, "Secces information technologies ltd." },
    { 21487, "Japan Cable Laboratories" },
    { 21488, "NC Numericable" },
    { 21489, "die Antwort" },
    { 21490, "Booth & Associates, Inc." },
    { 21491, "Entelligencia" },
    { 21492, "jMesh Limited" },
    { 21493, "SKODA AUTO a.s." },
    { 21494, "3CPLUS GmbH" },
    { 21495, "SIG IT GmbH" },
    { 21496, "nSolutions, Inc." },
    { 21497, "Tuxeo sprl" },
    { 21498, "Daemonspace Inc." },
    { 21499, "LDCONFIG" },
    { 21500, "SIC LAB S.r.l." },
    { 21501, "Asdag" },
    { 21502, "Sysload Software" },
    { 21503, "Witt Weiden GmbH" },
    { 21504, "SipStorm, Inc." },
    { 21505, "Caton Technology(Beijing) Corporation" },
    { 21506, "Infinity Software Development" },
    { 21507, "Strategies & Solutions LLC" },
    { 21508, "LAAS-CNRS" },
    { 21509, "CanWest Global Communications Corp." },
    { 21510, "heicare GmbH" },
    { 21511, "Institut Laue-Langevin" },
    { 21512, "Instituto Superior T\0303\0251cnico" },
    { 21513, "Vormetric, Inc." },
    { 21514, "Computer Services and Solutions, Inc." },
    { 21515, "Hyperion VOF" },
    { 21516, "Secure Data in Motion, Inc." },
    { 21517, "Ehwa Technologies Information" },
    { 21518, "Queensdale Investment Corp." },
    { 21519, "Detlef Woltmann IT Consult GmbH" },
    { 21520, "Crossworks Co.,Ltd." },
    { 21521, "Engage Networks, Inc" },
    { 21522, "Knights of Columbus" },
    { 21523, "SIA European Softwarehouse" },
    { 21524, "Wintegra" },
    { 21525, "sydios-it-solutions GmbH" },
    { 21526, "Equip'Trans" },
    { 21527, "SLIT" },
    { 21528, "MICROSEC  Ltd." },
    { 21529, "2wcom GmbH" },
    { 21530, "Champ Cargosystems S.A." },
    { 21531, "Adventec" },
    { 21532, "Universidad T\0303\0251cnica Federico Santa Mar\0303\0255a" },
    { 21533, "Administration fiscale" },
    { 21534, "eWayDirect, Inc." },
    { 21535, "QVS Software Inc." },
    { 21536, "MeuPC Inform\0303\0241tica e Comunica\0303\0247\0303\0265es LTDA" },
    { 21537, "KUNet" },
    { 21538, "fqdn.org" },
    { 21539, "Klahn Integration, LLC" },
    { 21540, "Clulicon" },
    { 21541, "DNF CONTROLS" },
    { 21542, "NET-TEK.info" },
    { 21543, "Bartels System GmbH" },
    { 21544, "Ktech Telecom" },
    { 21545, "Universidad Nacional de Salta" },
    { 21546, "Virtual Conexions Inc" },
    { 21547, "Logic Product Development" },
    { 21548, "Qoris, Inc." },
    { 21549, "Vine Systems Limited" },
    { 21550, "Millennium Pharmaceutical, Inc." },
    { 21551, "IdleAire Technologies Corp." },
    { 21552, "XI INTERNET SERVICES" },
    { 21553, "Kineticode, INc." },
    { 21554, "Intertech Software Ltd" },
    { 21555, "VonWangelin" },
    { 21556, "Botho.Net" },
    { 21557, "Fabio Perini North America, Inc." },
    { 21558, "East Sea Group" },
    { 21559, "Parallelspace Corporation" },
    { 21560, "Atlanta Help Desk" },
    { 21561, "abk-technology GmbH" },
    { 21562, "Boing.com" },
    { 21563, "Center of the System Administration LLC" },
    { 21564, "MMForces.de" },
    { 21565, "R. E. Smith" },
    { 21566, "WMS Industries Inc." },
    { 21567, "Network Computing Services, Inc." },
    { 21568, "nGENn GmbH" },
    { 21569, "COMPSIS" },
    { 21570, "Crimson Microsystems" },
    { 21571, "Cornerstone University" },
    { 21572, "Incompatible Time Sharing Systems" },
    { 21573, "gb EDV Beratung" },
    { 21574, "Active Systems Ltd." },
    { 21575, "IRIS T\0303\0251l\0303\0251com & R\0303\0251seaux" },
    { 21576, "Vestfold Butikkdata AS" },
    { 21577, "Allgemeine Anthroposophische Gesellschaft" },
    { 21578, "Radium Instituto de Oncologia" },
    { 21579, "HarlemLIVE" },
    { 21580, "XDS" },
    { 21581, "Bird Technologies" },
    { 21582, "twam systems" },
    { 21583, "Oy Stinghorn Ltd" },
    { 21584, "BTT Software" },
    { 21585, "Apollo Medical Imaging Technology" },
    { 21586, "ELITECH DATACOM CO.,LTD." },
    { 21587, "Cemtek Computer Solutions Ltd." },
    { 21588, "Media Connect GmbH" },
    { 21589, "Infosila" },
    { 21590, "Zeni Corporation SA" },
    { 21591, "Systime Informatik AG" },
    { 21592, "Activis Polska Sp. z o.o." },
    { 21593, "Agnes Cebulla" },
    { 21594, "Dougs Computers" },
    { 21595, "Kerberos Research" },
    { 21596, "Low Fat Technology, LLC" },
    { 21597, "Paper Coaters Limited" },
    { 21598, "Net Design Studio S.L." },
    { 21599, "TRAK Microwave Corporation" },
    { 21600, "NETIKUS.NET ltd" },
    { 21601, "Cementhorizon" },
    { 21602, "Turbocomm Tech. Inc." },
    { 21603, "e-Lock Corporation Sdn. Bhd." },
    { 21604, "Fiserv" },
    { 21605, "Sollentuna Energi AB" },
    { 21606, "Asclep Communications Private Ltd" },
    { 21607, "SPAR Oesterreichische Warenhandels-AG" },
    { 21608, "John G Russell (Transport) Ltd.," },
    { 21609, "Syscomp GmbH" },
    { 21610, "Quality Objects S.L." },
    { 21611, "MDHM COMMUNICATION" },
    { 21612, "ise - Individuelle Software-Entwicklung GmbH" },
    { 21613, "TOYOTA Motor Marketing Europe" },
    { 21614, "Multix Finland Oy" },
    { 21615, "Bolton Sixth Form College" },
    { 21616, "Fraunhofer IIS" },
    { 21617, "TiFiC AB" },
    { 21618, "Navecor, SA" },
    { 21619, "Massey Wilcox Transport Ltd." },
    { 21620, "Morrow Technologies Corporation" },
    { 21621, "Perez Torres y Cia." },
    { 21622, "Centerpoint Technologies Inc" },
    { 21623, "Serono International SA" },
    { 21624, "EcoNet.Com, Inc." },
    { 21625, "Shikoku Instrumentation CO.,LTD" },
    { 21626, "NetMon Information Systems Ltd." },
    { 21627, "Embrapa Monitoramento por Sat\0303\0251lite" },
    { 21628, "Niagara LaSalle Corporation" },
    { 21629, "IKTEK" },
    { 21630, "University of Fukui" },
    { 21631, "Axero AG" },
    { 21632, "Kayak Software Corporation" },
    { 21633, "eCorridor, Inc." },
    { 21634, "Educational Community  Credit Union" },
    { 21635, "ZhongChuangXingCe Beijing,China" },
    { 21636, "Tech-Nous Ltd" },
    { 21637, "PacWan" },
    { 21638, "PROD-EL PRODOTTI ELETTRONICI S.P.A." },
    { 21639, "CONSIGNACIONES TORO Y BETOLAZA,S.A." },
    { 21640, "O2 (UK) Ltd" },
    { 21641, "mm Control AG" },
    { 21642, "Le Tual Consulting" },
    { 21643, "Allianz Cia. de Seguros y Reaseguros SA" },
    { 21644, "Hyperworx" },
    { 21645, "PDV-Systeme" },
    { 21646, "Meuleman Technologies bvba" },
    { 21647, "Credence Systems Corporation" },
    { 21648, "Mowa - Mobile Wireless Applications Ltda." },
    { 21649, "Access Prime" },
    { 21650, "The Integer Group" },
    { 21651, "FastSecure Technologies" },
    { 21652, "programmercafe" },
    { 21653, "Wirtualna Polska S.A." },
    { 21654, "netnea AG" },
    { 21655, "Deadpixi.com" },
    { 21656, "Iskraemeco d.d." },
    { 21657, "Abrantix AG" },
    { 21658, "Kashya" },
    { 21659, "IsarNet AG" },
    { 21660, "ADAM SOFTWARE Ingenieurbuero" },
    { 21661, "Verilet Corporation" },
    { 21662, "IIJ Technology Inc." },
    { 21663, "Pazmany Peter Catholic University" },
    { 21664, "SAPEC (Sociedad Anonima de Productos Electronicos y de Comunicacion)" },
    { 21665, "VSB - Technical University of Ostrava" },
    { 21666, "ToutProgrammer.com" },
    { 21667, "Claymore Systems, Inc." },
    { 21668, "one11.net" },
    { 21669, "Multiband Inc" },
    { 21670, "MM Invent" },
    { 21671, "VSS monitoring Inc." },
    { 21672, "Psyche Trading Company" },
    { 21673, "Bei Jing Polypegasus Technology Co., Ltd." },
    { 21674, "Beijing TeleSystem Technologies Co., Ltd" },
    { 21675, "Compunicate Technologies, Inc." },
    { 21676, "SparkLAN Communications, Inc." },
    { 21677, "Shanghai Huama Information Tech.Developmenet Co.,Ltd" },
    { 21678, "SCREEN SERVICE ITALIA S.p.A." },
    { 21679, "Bundesagentur f\0303\0274r Arbeit" },
    { 21680, "MeadWestvaco Intelligent Systems" },
    { 21681, "WholeSecurity, Inc." },
    { 21682, "ricilake.net" },
    { 21683, "Wyrdwright, Inc." },
    { 21684, "wayneandersen.com" },
    { 21685, "eFunds Corp." },
    { 21686, "Kyung Gee Electronics Co., Ltd." },
    { 21687, "KIP America, Inc." },
    { 21688, "Serge Co." },
    { 21689, "easynet" },
    { 21690, "David Bremner" },
    { 21691, "gnuTechnologies" },
    { 21692, "Coradir S.A." },
    { 21693, "LINET Services GbR" },
    { 21694, "BeiJing Sina Information Technology Co.,Ltd" },
    { 21695, "net-track GmbH" },
    { 21696, "KEYMILE AG" },
    { 21697, "Rivertree Networks Corp." },
    { 21698, "Field Boxmore Mareen" },
    { 21699, "Belgocontrol" },
    { 21700, "Keller & Partner GmbH" },
    { 21701, "MOBOTIX AG" },
    { 21702, "EAPLV" },
    { 21703, "Microhard Systems Inc." },
    { 21704, "DPS-Promatic srl" },
    { 21705, "ARG Electrodesign Ltd" },
    { 21706, "Dominion Resources, Inc." },
    { 21707, "DECATHLON" },
    { 21708, "Netsweeper Inc." },
    { 21709, "Procios Oy" },
    { 21710, "agentes AG" },
    { 21711, "MediSoft Egypt" },
    { 21712, "Caisse de Pr\0303\0251voyance Sociale" },
    { 21713, "Vectorsite" },
    { 21714, "Cape Byron Imports & Wholesale Pty. Ltd." },
    { 21715, "UFRJ" },
    { 21716, "hangzhou goldway information technology CO.,Ltd" },
    { 21717, "NIPPON KOEI POWER SYSTEMS Co.,Ltd." },
    { 21718, "ReestrRN" },
    { 21719, "EmmeciSoft S.n.c." },
    { 21720, "Microgaming Software Systems Limited" },
    { 21721, "SERVICIO DE CERTIFICACION DE LOS REGISTRADORES" },
    { 21722, "Marine Corps Community Services" },
    { 21723, "NTA CO.LTD." },
    { 21724, "elementec Software & Consulting" },
    { 21725, "Olaf Huebner" },
    { 21726, "HappyComm" },
    { 21727, "People's Bank of Georgia" },
    { 21728, "Synaccess Networks, Inc." },
    { 21729, "Somogy Informatika Kft." },
    { 21730, "stSoft" },
    { 21731, "CryptoSoft, Ltd" },
    { 21732, "Sparkasse Hanauerland" },
    { 21733, "Altar Sp. z o.o." },
    { 21734, "APO Consortium" },
    { 21735, "Alber Inc." },
    { 21736, "IntelliTrans Ltd" },
    { 21737, "Gestweb S.p.A." },
    { 21738, "Hong Kong Education City Ltd" },
    { 21739, "Trusted Solutions s.r.o." },
    { 21740, "Persystent Technology, Inc" },
    { 21741, "St. Margaret's Anglican Church" },
    { 21742, "uWink Inc." },
    { 21743, "yasp.at" },
    { 21744, "BlackRock Financial Management" },
    { 21745, "Arnprior KF" },
    { 21746, "Cheyenne Networks Inc." },
    { 21747, "Aldebaran Systems Ltd" },
    { 21748, "Iggesund Paperboard AB" },
    { 21749, "EtherTek Circuits" },
    { 21750, "Highbridge Capital Management, LLC" },
    { 21751, "St. Thomas University" },
    { 21752, "Societe Cooperative Migros Neuchatel-Fribourg" },
    { 21753, "ZKM - Zentrum f. Kunst und Medientechnologie, Karlsruhe" },
    { 21754, "Media-Com Sp. z o.o." },
    { 21755, "Collaborative Adaptive Sensing of the Atmosphere (CASA)" },
    { 21756, "SOFTEC sa" },
    { 21757, "Digicadd Computacao Grafica LTDA" },
    { 21758, "Slushpupie" },
    { 21759, "All China Federation Of Industry & Commmerce" },
    { 21760, "E-Access Broadband" },
    { 21761, "L\0303\0274becker Hafen-Gesellschaft mbH" },
    { 21762, "Cornwall County Council" },
    { 21763, "Claranet" },
    { 21764, "Hill Systems LLC" },
    { 21765, "The Lyarama Project" },
    { 21766, "Imperial College London" },
    { 21767, "Synarc, Inc." },
    { 21768, "Inspired Broadcast Networks Ltd" },
    { 21769, "M-Tech Information Technology, Inc." },
    { 21770, "Wesaidso Software Engineering" },
    { 21771, "Imolko C.A." },
    { 21772, "SEB Eesti \0303\0234hispank AS" },
    { 21773, "Choice Sourcing Pty" },
    { 21774, "ECLASS" },
    { 21775, "Digital Imaging Solutions" },
    { 21776, "TelcoBridges Inc." },
    { 21777, "Nitido Inc." },
    { 21778, "VA TECH ELIN EBG GmbH & Co" },
    { 21779, "jade.net" },
    { 21780, "ADURO d.o.o." },
    { 21781, "Montelnor SCL" },
    { 21782, "Chinasys Technologies Co.,Ltd." },
    { 21783, "ANTGroup s.r.l" },
    { 21784, "Calrec Audio Ltd" },
    { 21785, "V\0303\0226B-Service GmbH" },
    { 21786, "Boston.com" },
    { 21787, "Qualitas, Inc." },
    { 21788, "Poindexter Systems, Inc." },
    { 21789, "Cablevision - FiberTel" },
    { 21790, "Obidobi Software" },
    { 21791, "Wave-Tech, Inc." },
    { 21792, "BearingPoint, Inc." },
    { 21793, "Kisoku Networking" },
    { 21794, "Panthera Systems" },
    { 21795, "Integrated Decision Systems" },
    { 21796, "HW group s.r.o" },
    { 21797, "Googgun Technologies Inc." },
    { 21798, "Covergence, Inc." },
    { 21799, "CONSULTEC" },
    { 21800, "Island Internet Services" },
    { 21801, "California State University Los Angeles" },
    { 21802, "Maternit\0303\0251 R\0303\0251gionale A. Pinard" },
    { 21803, "Centrepoint Technologies" },
    { 21804, "360degreeweb, Inc" },
    { 21805, "monkeyjr.com" },
    { 21806, "Vitrado GmbH" },
    { 21807, "TRW Engine Components" },
    { 21808, "Prairie Systems Inc." },
    { 21809, "Campusware" },
    { 21810, "Yubivaza" },
    { 21811, "Kalion" },
    { 21812, "Kofax Image Products" },
    { 21813, "West Japan Railway Company" },
    { 21814, "Booth Software Consulting" },
    { 21815, "School of Veterinary Medicine Hannover" },
    { 21816, "CDE nove tehnologije d.d." },
    { 21817, "Gemini Storage Company" },
    { 21818, "CapTech Ventures, Inc." },
    { 21819, "Guernsey Customs" },
    { 21820, "ChanneLynx LLC" },
    { 21821, "Colibre" },
    { 21822, "Andrew Ducore, Independent Consultant" },
    { 21823, "MDS Caswell" },
    { 21824, "Fortuitous Technologies Inc" },
    { 21825, "asystec | Adolf Systemtechnik" },
    { 21826, "Metropipe Network Services Inc" },
    { 21827, "ArcanaNetworks Inc." },
    { 21828, "Meta Systems AS" },
    { 21829, "Ian A. Young" },
    { 21830, "CrossTalk G\0303\0266teborg AB" },
    { 21831, "ClearOne Communications Inc." },
    { 21832, "LabOne Inc." },
    { 21833, "Megas Media" },
    { 21834, "Tufin Technologies" },
    { 21835, "SESCAM - Servicio de Salud de Castilla la Mancha" },
    { 21836, "MRF Systems Ltd." },
    { 21837, "DiGIR" },
    { 21838, "LooseFlow Ltd" },
    { 21839, "ALAXALA Networks Corporation" },
    { 21840, "Hitachi IE Systems Co.,Ltd." },
    { 21841, "Hochschule fuer Angewandte Wissenschaften Hamburg" },
    { 21842, "Energy Technologies, Inc." },
    { 21843, "SHENZHEN MQ TECHNOLOGIES INDUSTRIAL CO., LTD." },
    { 21844, "Durham School Services" },
    { 21845, "Trium Sistemas Informaticos SL" },
    { 21846, "Trium Systems SL" },
    { 21847, "The Scott Lawson Group Ltd." },
    { 21848, "SLACALEK" },
    { 21849, "Riggs Heinrich Media" },
    { 21850, "Intaero Sdn Bhd" },
    { 21851, "MurrayLisook.com" },
    { 21852, "Norkring AS" },
    { 21853, "Gesellschaft fuer Informations- und Datenverarbeitungs mbH" },
    { 21854, "CollabNet, Inc." },
    { 21855, "Winterdale Computerdienste GbR" },
    { 21856, "Modulus Systems" },
    { 21857, "Chaucer Press Limited" },
    { 21858, "A.P. Woodham Ltd." },
    { 21859, "Leightons Paper & Printing Ltd." },
    { 21860, "Harrah's Entertainment, Inc." },
    { 21861, "Mobile Cohesion" },
    { 21862, "Alcasat" },
    { 21863, "INFOTEL" },
    { 21864, "ibte" },
    { 21865, "Unitrends Software Corp" },
    { 21866, "FMAudit, LLC." },
    { 21867, "ESI-HEB" },
    { 21868, "Highmark Inc." },
    { 21869, "CUI Inc (formerly 'Tectrol Inc')" },
    { 21870, "United Cerebral Palsy of Greater Chicago" },
    { 21871, "Datastream Systems, Inc." },
    { 21872, "WICEN (NSW) Inc" },
    { 21873, "XFI Corporation" },
    { 21874, "Moore Gallagher ltd." },
    { 21875, "macfadden.org" },
    { 21876, "metabit" },
    { 21877, "Multi Skilled Resources Australia" },
    { 21878, "MedStar Health" },
    { 21879, "Associazione Culturale Inventati" },
    { 21880, "Australian Experimental High Energy Physics Group" },
    { 21881, "Milom, Inc." },
    { 21882, "Justsystem Corp." },
    { 21883, "Brain ltd." },
    { 21884, "W. Schneider+Co AG" },
    { 21885, "Ericsson Mobile Platforms AB" },
    { 21886, "Newel Informatique" },
    { 21887, "Funkwerk AG, Traffic & Control Communication, Kiel (formerly 'Funkwerk Information Technologies Kiel GmbH')" },
    { 21888, "Content Management License Administrator" },
    { 21889, "Acsis, Inc." },
    { 21890, "GRIB" },
    { 21891, "Tibco Telecom Reseau" },
    { 21892, "Ringwald Mikroelektronik GmbH" },
    { 21893, "phil cornes" },
    { 21894, "ISABEL S.A." },
    { 21895, "Delta-Soft Ltd" },
    { 21896, "Niederrhein University of Applied Sciences" },
    { 21897, "i-CABLE Network Limited" },
    { 21898, "SvamberkNET, s.r.o." },
    { 21899, "Cape City Command, LLC" },
    { 21900, "Danacal Ltd." },
    { 21901, "Millward Brown UK Limited" },
    { 21902, "BAJM Internet" },
    { 21903, "NetServices LLC" },
    { 21904, "Yoshida's Inc." },
    { 21905, "Leibniz-Institut fuer Meereswissenschaften" },
    { 21906, "March Hare Software Ltd." },
    { 21907, "Wohnprojekt Schellingstrasse GmbH" },
    { 21908, "NexaSoft Inc." },
    { 21909, "Chaos Limited, LLC" },
    { 21910, "Electrocomponentes S.A." },
    { 21911, "Trusted Computing Group" },
    { 21912, "Priva Technologies, Inc." },
    { 21913, "dop intelligence" },
    { 21914, "Networx.AT - busta & neumayr oeg" },
    { 21915, "BitPusher, LLC" },
    { 21916, "Tehna" },
    { 21917, "Staatliche Berufsschule I Bayreuth" },
    { 21918, "Ideas to Interconnect B.V." },
    { 21919, "Clearwire, Inc." },
    { 21920, "Cipherium Systems Co., Ltd." },
    { 21921, "Inspiration Matters Ltd" },
    { 21922, "TIE - Tecnologias de Integra\0303\0247\0303\0243o Empresarial, Lda." },
    { 21923, "Bowater, Inc." },
    { 21924, "Adam Pordzik" },
    { 21925, "RTP Network Services, Inc" },
    { 21926, "MedOrder, Inc." },
    { 21927, "intralinux" },
    { 21928, "Renaissance Computing Institute" },
    { 21929, "Netikos Finland Oy" },
    { 21930, "Prihateam Networks Finland Ltd" },
    { 21931, "SE46 AB" },
    { 21932, "Tor.AT - Netzwerke-Server-Sicherheit" },
    { 21933, "Jamie Thompson" },
    { 21934, "FIlesX" },
    { 21935, "Sigtec LTD" },
    { 21936, "Senforce Technologies, Inc." },
    { 21937, "Ezrez Software, Inc." },
    { 21938, "Radio Muzyka Fakty, Sp. z o.o." },
    { 21939, "HYTEC GmbH" },
    { 21940, "Enatel Ltd" },
    { 21941, "Data Return, LLC" },
    { 21942, "Rubicon Software Ltd" },
    { 21943, "Uni-Sommerfest e.V." },
    { 21944, "Blitzen Networks" },
    { 21945, "Kerberos d.o.o." },
    { 21946, "University of Liverpool, Department of Electrical Engineering" },
    { 21947, "TintaDigital, Solu\0303\0247\0303\0265es em Tecnologias de Informa\0303\0247\0303\0243o, Lda." },
    { 21948, "TW TeamWare s.r.l." },
    { 21949, "Istituto Nazionale di Geofisica e Vulcanologia" },
    { 21950, "Open Consultants" },
    { 21951, "Katun Corporation" },
    { 21952, "Crescent Business, Inc." },
    { 21953, "Business Computer Maintenance Limited" },
    { 21954, "Transatlantic Diagnostics LLC" },
    { 21955, "CONTROL SYSTEMS Srl" },
    { 21956, "Megapath Cloud Company LLC" },
    { 21957, "Sealed Air (NZ) ltd" },
    { 21958, "Thermakraft IndustriesNZ Ltd." },
    { 21959, "P J Papers ltd." },
    { 21960, "Legend Communications plc" },
    { 21961, "Exeo Systems" },
    { 21962, "Nextel Communications Inc." },
    { 21963, "Obeco GmbH" },
    { 21964, "Nesym Consulting Srl" },
    { 21965, "LTLab" },
    { 21966, "Cooperativa Obrera Ltda." },
    { 21967, "Invento Networks, Inc." },
    { 21968, "Food Services of America" },
    { 21969, "Kernway Technology Co., Ltd" },
    { 21970, "AHTS" },
    { 21971, "Kisters AG" },
    { 21972, "1mage Software Inc." },
    { 21973, "CaribbeanClub" },
    { 21974, "Boris Kulig EDV und Statistik Beratung" },
    { 21975, "Infraserv Gmbh & Co Hoechst KG" },
    { 21976, "Roberts Wesleyan College" },
    { 21977, "The Sage Group PLC" },
    { 21978, "Fluid, Inc." },
    { 21979, "fks BVBA" },
    { 21980, "Enran Telecom" },
    { 21981, "Spiderbox P/L" },
    { 21982, "With Mobile Technology Co., Ltd." },
    { 21983, "Terrace technology, Inc." },
    { 21984, "Viswis, Inc." },
    { 21985, "Server-Center, JSC" },
    { 21986, "Shinnyo-en Buddhist Order Co." },
    { 21987, "Bugs Inc." },
    { 21988, "ARENAL" },
    { 21989, "Connex.cc DI Hadek GmbH" },
    { 21990, "Universidad Aut\0303\0263noma de Baja California Sur" },
    { 21991, "char" },
    { 21992, "Central Command Inc." },
    { 21993, "girrulat.de" },
    { 21994, "Norfolk Public Schools" },
    { 21995, "Magyar Elektronikus Al\0303\0241\0303\0255r\0303\0241s Sz\0303\0266vets\0303\0251g / Hungarian Association for Electronic" },
    { 21996, "crocobox.org" },
    { 21997, "PowerStar Ltd." },
    { 21998, "Tiani-Spirit" },
    { 21999, "PLUM Computer Consulting, Inc." },
    { 22000, "Pacific Laminations Co. limited" },
    { 22001, "Fachhochschule Esslingen - Hochschule fuer Technik" },
    { 22002, "Michael Breuer" },
    { 22003, "mst" },
    { 22004, "X-MD" },
    { 22005, "GE Healthcare -  IT" },
    { 22006, "AREVA T&D" },
    { 22007, "WinWholesale Inc." },
    { 22008, "pld-sparc64" },
    { 22009, "IP-LABEL" },
    { 22010, "Tranfa Optic Telecommunications Co., Ltd." },
    { 22011, "CORE MICRO SYSTEMS INC." },
    { 22012, "silkroadtaiwan,Inc" },
    { 22013, "SGDN" },
    { 22014, "China Beijing Broada Digital Technology Co.,Ltd" },
    { 22015, "BanianTech Co.,Ltd" },
    { 22016, "RackWatch LLC" },
    { 22017, "Claritas, Inc." },
    { 22018, "RedIce SA" },
    { 22019, "Tutus Data AB" },
    { 22020, "CoreTEC GmbH" },
    { 22021, "WestCall Ltd" },
    { 22022, "DeusXMachina" },
    { 22023, "Schaly" },
    { 22024, "Inoi" },
    { 22025, "ELTI d.o.o." },
    { 22026, "Texas State Technical College System" },
    { 22027, "Rock Mobile Corporation" },
    { 22028, "Hauser/Flimp Programming" },
    { 22029, "ActiveLive Technologies LLC" },
    { 22030, "Kign Foundation" },
    { 22031, "Lattice Semiconductor Corporation" },
    { 22032, "Actelion Pharmaceuticals Ltd." },
    { 22033, "Cynical Networks" },
    { 22034, "joztoz net" },
    { 22035, "ECT News Network, Inc." },
    { 22036, "Tapsell-Ferrier Limited" },
    { 22037, "Elektrownia Be\0302\0263chat\0303\0263w S.A." },
    { 22038, "Kommune42" },
    { 22039, "Mathias Wohlfarth EDV-Beratung" },
    { 22040, "STATCON B SCHAEFER" },
    { 22041, "Generalstaatsanwaltschaft Berlin" },
    { 22042, "GITEM" },
    { 22043, "Land-of-uz.net" },
    { 22044, "Moviltek, Inc." },
    { 22045, "Electrosystems Inc." },
    { 22046, "Planecom s.r.l." },
    { 22047, "Qascom S.r.l." },
    { 22048, "CAJA DE AHORROS EL MONTE" },
    { 22049, "Metro Group Information Technologies" },
    { 22050, "COPA-DATA GmbH" },
    { 22051, "SavageS Net" },
    { 22052, "Rising Technology Co., Ltd." },
    { 22053, "Neptune Gaming" },
    { 22054, "Three Rings Design, Inc." },
    { 22055, "HighSpeed America, Inc." },
    { 22056, "Prefeitura da Cidade do Rio de Janeiro" },
    { 22057, "New Signature" },
    { 22058, "Danaher Power Solutions" },
    { 22059, "Corp. Hostarica" },
    { 22060, "Labcom Sistemas Ltda" },
    { 22061, "Liquid Systems" },
    { 22062, "G2 Switchworks" },
    { 22063, "CIFE - Consorcio de Intermediaci\0303\0263n de Facturas Electr\0303\0263nicas" },
    { 22064, "Landeskreditbank Baden-W\0303\0274rttemberg (L-Bank)" },
    { 22065, "Mobiltel AD" },
    { 22066, "Mobitex Technology AB" },
    { 22067, "ENSEA" },
    { 22068, "Tai Liang Chemical Corporation" },
    { 22069, "Deuromedia Technologies" },
    { 22070, "LMR Robosistic Ltd. Co." },
    { 22071, "Associazione culturale Investici" },
    { 22072, "EDS" },
    { 22073, "Cerantus Technologies" },
    { 22074, "Vibrant Media Ltd" },
    { 22075, "Global Technical Engineering Solutions Inc." },
    { 22076, "Televisio de Catalunya, s.a." },
    { 22077, "Smiling Screens Inc." },
    { 22078, "Burlington Coat Factory Warehouse" },
    { 22079, "Matterform Media" },
    { 22080, "YACAST" },
    { 22081, "Guyton Networks" },
    { 22082, "IBM WPC Lab" },
    { 22083, "okkernoot.net" },
    { 22084, "Industec Industria Metalurgica Ltda." },
    { 22085, "CIDE Consorcio para la Interoperabilidad de Documentos Electr\0303\0263nicos" },
    { 22086, "Paul Poeltner" },
    { 22087, "Invelica GmbH" },
    { 22088, "Alpine-Energie Holding AG" },
    { 22089, "Paedagogische Hochschule Zentralschweiz" },
    { 22090, "GCommerce Inc." },
    { 22091, "MATRICS COMMUNICATIONS" },
    { 22092, "Mazda Motor Europe GmbH" },
    { 22093, "Software Systems" },
    { 22094, "Pulse Entertainment" },
    { 22095, "Baltic Online Computer GmbH" },
    { 22096, "Image Project Inc." },
    { 22097, "B&W Fahrzeugentwicklung GmbH" },
    { 22098, "CHEN" },
    { 22099, "EKF Elektronik &- Messtechnik GmbH" },
    { 22100, "Swisscom Fixnet AG" },
    { 22101, "Udo Meng GmbH" },
    { 22102, "KIM Systemhaus GmbH" },
    { 22103, "Paynet Ltd" },
    { 22104, "YesTurnkey Technology, Inc." },
    { 22105, "Central Visayas Information Sharing Network Foundation Inc." },
    { 22106, "Vodafone SDEC" },
    { 22107, "The Florida Lottery" },
    { 22108, "Application Science and Technology" },
    { 22109, "Beuth Hochschule Berlin / University of Applied Sciences" },
    { 22110, "Airedale International Air Conditioning Ltd" },
    { 22111, "Chilibyte Oy" },
    { 22112, "Vigil Security, LLC" },
    { 22113, "Gigabeam" },
    { 22114, "Battle.net Underground" },
    { 22115, "Netflexity, Ltd" },
    { 22116, "Queryus" },
    { 22117, "Epiq Electronic Assembly Ltd." },
    { 22118, "Advance America" },
    { 22119, "GBST Holdings" },
    { 22120, "datastacks.com" },
    { 22121, "Krasnoyarsk State Pedagogical University" },
    { 22122, "ESOLUTIONPROVIDERS" },
    { 22123, "Unimas Systems, Corp." },
    { 22124, "Networks & More! Inc." },
    { 22125, "Sierra Video Systems Inc." },
    { 22126, "AVONET, s.r.o." },
    { 22127, "Delvos" },
    { 22128, "RBC Capital Markets, Sydney" },
    { 22129, "AfterHours Upgrades" },
    { 22130, "Vivatas, Inc" },
    { 22131, "Technical Management System GmbH" },
    { 22132, "Mediasyscom SAS" },
    { 22133, "UWIC" },
    { 22134, "Eminds AB" },
    { 22135, "Sentiva Innovation AB" },
    { 22136, "outsmart Ltd." },
    { 22137, "Ivosh, s.r.o." },
    { 22138, "ATS-KONVERS Ltd." },
    { 22139, "Kurchatov Institute Grid Deployment" },
    { 22140, "Volker Scheuber" },
    { 22141, "ProCom GmbH" },
    { 22142, "Interferenza s.r.l." },
    { 22143, "Steatite Ltd" },
    { 22144, "InfoNotary Ltd." },
    { 22145, "ViDiSys GmbH" },
    { 22146, "Dpt. of Philosophy, Utrecht University" },
    { 22147, "Allpoint Security Ltd." },
    { 22148, "Venda Ltd" },
    { 22149, "Systemhaus Bad Waldsee" },
    { 22150, "Wettern Network Solutions" },
    { 22151, "Neotronic s.r.l." },
    { 22152, "CipherSec SPRL" },
    { 22153, "Viveon AG" },
    { 22154, "Jotron Electronics a.s." },
    { 22155, "Pontificia Universita Santa Croce" },
    { 22156, "Dynamit Nobel Kunststoff GmbH" },
    { 22157, "SLU" },
    { 22158, "Resolv SARL" },
    { 22159, "EPIN Technologies (China), Ltd." },
    { 22160, "RW Comercio e Servicos Ltda." },
    { 22161, "John Wiggins" },
    { 22162, "Beyond Disability, Inc." },
    { 22163, "Ricoh Printing Systems, Ltd." },
    { 22164, "Cambridge Silicon Radio Limited" },
    { 22165, "Web Service Solutions, Inc." },
    { 22166, "Ocean Broadband Networks" },
    { 22167, "nologic.org" },
    { 22168, "Crown College" },
    { 22169, "NetEngine, Inc." },
    { 22170, "FXCM" },
    { 22171, "CeSigma - Signals & Systems" },
    { 22172, "HaCon Ingenieurgesellschaft mbH" },
    { 22173, "Flex Engineering" },
    { 22174, "Virtual Trip Ltd." },
    { 22175, "Mitron Oy" },
    { 22176, "asknet AG" },
    { 22177, "DFN-Verein" },
    { 22178, "Kurs LLC" },
    { 22179, "Otsuka Corporation" },
    { 22180, "INSCAPE DATA CORPORATION" },
    { 22181, "Avision Inc." },
    { 22182, "Cascadia BHC" },
    { 22183, "Cylant, Inc." },
    { 22184, "21st Century Software Inc." },
    { 22185, "eScholar LLC" },
    { 22186, "Marketing Resource Consultants, Inc." },
    { 22187, "Symphoniq" },
    { 22188, "Correctime ltd" },
    { 22189, "Star Technologies, LLC" },
    { 22190, "NetEffect, Inc." },
    { 22191, "Bismarck Public Schools" },
    { 22192, "Pictou Regional Development Commission" },
    { 22193, "Computer Information Systems Ltd., Brest" },
    { 22194, "Orion Systems Inc" },
    { 22195, "NeoTIP SA" },
    { 22196, "Vistek Electronics Ltd" },
    { 22197, "SOFTBANK BB Corp." },
    { 22198, "University of St. Gallen" },
    { 22199, "United Arab Emirates University" },
    { 22200, "Sistemas Techniclite. C.A." },
    { 22201, "Research Center of NetWork Techology Nanjing University Of Posts And" },
    { 22202, "Security Tostem co.,Ltd." },
    { 22203, "Inform\0303\0241tica El Corte Ingl\0303\0251s, S.A." },
    { 22204, "Bundesversicherungsanstalt f\0303\0274r Angestellte" },
    { 22205, "3G Data Soluciones C.A." },
    { 22206, "M-real Corporation" },
    { 22207, "SureWest" },
    { 22208, "AGES International GmbH & Co KG" },
    { 22209, "LJXN inc." },
    { 22210, "FLsystem" },
    { 22211, "Legacy Property Investments LLC (formerly 'JMAnderson Enterprises')" },
    { 22212, "Cognio, Inc." },
    { 22213, "Posda" },
    { 22214, "Explorer Post 227" },
    { 22215, "Pogo Linux, Inc." },
    { 22216, "sighq networking" },
    { 22217, "Yitran Communications" },
    { 22218, "NAVARRO Y BORONAD, S.L." },
    { 22219, "BoreNet AB" },
    { 22220, "LACNIC" },
    { 22221, "Wescom GmbH" },
    { 22222, "ProaXial" },
    { 22223, "IntelliCal LLC" },
    { 22224, "Queensland Treasury" },
    { 22225, "Huazhong University of Science and Technology" },
    { 22226, "Acamaya SA" },
    { 22227, "David Mains & Co. Inc." },
    { 22228, "The University of Manchester Computer Society" },
    { 22229, "Heiks computerdiensten" },
    { 22230, "MyPoints, Inc." },
    { 22231, "VEL Technologies, LLC" },
    { 22232, "Kyle Hamilton" },
    { 22233, "German Overseas Institute" },
    { 22234, "DocuSign France (formerly 'KEYNECTIS')" },
    { 22235, "Beijing WellTelecom Co.,Ltd." },
    { 22236, "Ultrawaves Design, Inc." },
    { 22237, "Inventronik GmbH" },
    { 22238, "FOXCONN Technology Group" },
    { 22239, "Response Systems Corporation" },
    { 22240, "DATOR3 a.s." },
    { 22241, "C&A Computer Consultants Ltd." },
    { 22242, "GENTOO FOUNDATION, INC." },
    { 22243, "The Swatch Group Ltd" },
    { 22244, "Ing.-B\0303\0274ro Otte Gmbh" },
    { 22245, "Phalanx" },
    { 22246, "HSBC Bank plc" },
    { 22247, "Port of Tilbury London Ltd" },
    { 22248, "topf-sicret.org" },
    { 22249, "INSIGHT TECHNOLOGIES Co., Ltd" },
    { 22250, "Max-Planck-Institut fuer Radioastronomie" },
    { 22251, "Syderal SA" },
    { 22252, "McAfee Inc. (formerly 'Reconnex Corporation')" },
    { 22253, "Lite Speed Technologies, Inc." },
    { 22254, "Jerome's Furniture Warehouse" },
    { 22255, "StopTheGlaciers.org" },
    { 22256, "Groep T Hogeschool Leuven" },
    { 22257, "Consultation informatique Daniel Savard Inc." },
    { 22258, "Enlaces Tecnologicos S.A. de C.V." },
    { 22259, "WebAvis" },
    { 22260, "Scana" },
    { 22261, "California Lutheran University" },
    { 22262, "OpenSides sprl" },
    { 22263, "The Corporation of the County of Brant" },
    { 22264, "Artifact Software Inc." },
    { 22265, "Stewart Enterprises, Inc." },
    { 22266, "Evidant Corporation" },
    { 22267, "Integral Technologies Inc" },
    { 22268, "Flammiger Enterprises" },
    { 22269, "Charles A Gura" },
    { 22270, "Quality Comm Com\0303\0251rcio e Servi\0303\0247os de Teleinform\0303\0241tica Ltda" },
    { 22271, "Nimium d.o.o." },
    { 22272, "PAREXEL International Corporation" },
    { 22273, "Universita' degli Studi di Ferrara" },
    { 22274, "QSAN Technology, Inc." },
    { 22275, "PNMS" },
    { 22276, "FHD Ltd." },
    { 22277, "GIquadrat mbH" },
    { 22278, "Bob-paperi Ky" },
    { 22279, "Shiflett Consulting" },
    { 22280, "Telus Mobility" },
    { 22281, "CODE INGENIERIA INFORMATICA" },
    { 22282, "Qualys, Inc." },
    { 22283, "Gutemberg Medeiros Ltda" },
    { 22284, "Dimensao Digital Desenvolvimento Ltd." },
    { 22285, "Teracue" },
    { 22286, "SYSTEMA" },
    { 22287, "TRS SpA" },
    { 22288, "EXTIS GmbH" },
    { 22289, "Contec GmbH" },
    { 22290, "SkandSoft Technologies" },
    { 22291, "FUJITSU ADVANCED SOLUTIONS LIMITED" },
    { 22292, "Network Center of Peking University" },
    { 22293, "Daily Dose Language Systems, Inc." },
    { 22294, "CAR-FRESHNER Corporation" },
    { 22295, "Ministrstvo za obrambo Republike Slovenije" },
    { 22296, "Fazt! Networks, Ltd." },
    { 22297, "Allied Bank Corporation" },
    { 22298, "H\0303\0266jebrom\0303\0266lla" },
    { 22299, "Pontifical University of St. Thomas" },
    { 22300, "CableMatrix Technologies, Inc." },
    { 22301, "COMP Rzeszow S.A." },
    { 22302, "iC Compas GmbH and Co KG" },
    { 22303, "RSS Solutions Inc" },
    { 22304, "Westinghouse Savannah River Company, LLC" },
    { 22305, "schwaberow.de" },
    { 22306, "McMaster University" },
    { 22307, "Active Reasoning, Inc." },
    { 22308, "RedSky Technologies Inc." },
    { 22309, "California State Automobile Association" },
    { 22310, "ComNetMedia AG" },
    { 22311, "A.F. Blakemore and Son Ltd" },
    { 22312, "Universit\0303\0251 Saint-Louis - Bruxelles (USL-B) (formerly 'Universit\0303\0251 Saint-Louis (USL-B)')" },
    { 22313, "SP Controls, Inc." },
    { 22314, "TGN-Systeme Krueger + Partner" },
    { 22315, "spot media AG" },
    { 22316, "OnTapSolutions" },
    { 22317, "Applied Identity, Inc." },
    { 22318, "Anyware Video" },
    { 22319, "Dravske elektrarne Maribor" },
    { 22320, "Guardian Newspapers Limited" },
    { 22321, "ISAC, Inc." },
    { 22322, "Freecomm Corporation" },
    { 22323, "Capinfo Co, Ltd." },
    { 22324, "Cooperton LLC" },
    { 22325, "Blick SA" },
    { 22326, "Sago S.p.A" },
    { 22327, "Martos Ltd" },
    { 22328, "id Quantique SA" },
    { 22329, "same" },
    { 22330, "BIAS Inc." },
    { 22331, "State of Texas, Office of the Attorney General, Child Support Division" },
    { 22332, "ImmediateIT" },
    { 22333, "JPotter" },
    { 22334, "Laws and Wolfe Inc." },
    { 22335, "Alcorn State University" },
    { 22336, "Hopson Advanced Embedded Engineering" },
    { 22337, "Hitachi Electronics Services Co.,Ltd" },
    { 22338, "Paliot" },
    { 22339, "RHX Studio Snc" },
    { 22340, "Herlein Engineering, Inc." },
    { 22341, "ESO Technologies" },
    { 22342, "Dyndaco BVBA" },
    { 22343, "Technical Manangment" },
    { 22344, "Telcomanager Technologies" },
    { 22345, "Exalon Delft" },
    { 22346, "dass /IT GmbH" },
    { 22347, "IDS Services, LLC." },
    { 22348, "Braintower Technologies GmbH" },
    { 22349, "Premier Retail Networks" },
    { 22350, "debitel AG" },
    { 22351, "RedPrompt" },
    { 22352, "Pragmeta Networks" },
    { 22353, "Network Connection" },
    { 22354, "The Lapp Companies" },
    { 22355, "Clariton Networks Ltd." },
    { 22356, "Web-Cyber & Co" },
    { 22357, "INET-Consulting.com, Inc" },
    { 22358, "Albeo" },
    { 22359, "Jofee Internet Services" },
    { 22360, "Unzet ApS" },
    { 22361, "University of Michigan Radiation Oncology Physics" },
    { 22362, "General Software, Inc." },
    { 22363, "Ken Bass Consulting" },
    { 22364, "EMARKMONITOR INC." },
    { 22365, "Gluesys Co. Ltd." },
    { 22366, "EasySoft" },
    { 22367, "Digital Fallout" },
    { 22368, "Silver Spring Networks" },
    { 22369, "Hong Kong Applied Science and Technology Research Institute Company" },
    { 22370, "DUPLO CORPORATION" },
    { 22371, "Business Data Solutions" },
    { 22372, "Horst Reiterer" },
    { 22373, "ThunderTechnology Srl" },
    { 22374, "Allegro Wireless Canada Inc." },
    { 22375, "Crescent Real Estate Equities, LTD." },
    { 22376, "Masco Corporation" },
    { 22377, "VoicePort, LLC" },
    { 22378, "Spaceship.com, Inc." },
    { 22379, "InovaWeb" },
    { 22380, "Vincent Defert Consulting" },
    { 22381, "Linux User Group Roma" },
    { 22382, "Drazen Baic" },
    { 22383, "HCCP" },
    { 22384, "Benedikt Heinen" },
    { 22385, "Houston Academy of Medicine-Texas Medical Center Library" },
    { 22386, "ionflux.org" },
    { 22387, "InSync Technology Ltd" },
    { 22388, "SENTELCO" },
    { 22389, "IRIS Corporation Berhad" },
    { 22390, "Parsek Corporation Ltd." },
    { 22391, "Citadel Security Software, Inc." },
    { 22392, "Delco S.p.A." },
    { 22393, "CDL chair - Saarland University" },
    { 22394, "Digital Fuel Ltd." },
    { 22395, "DyLogic S.r.l." },
    { 22396, "Power Media sp. z o.o." },
    { 22397, "IBAMA" },
    { 22398, "Cooperativa de Computa\0303\0247\0303\0243o da Unimontes" },
    { 22399, "QBT Systems, Inc." },
    { 22400, "Inside Higher Ed" },
    { 22401, "VoIP, Inc." },
    { 22402, "lois.inc" },
    { 22403, "Koch, Neff & Volckmar GmbH" },
    { 22404, "SBS Technologies" },
    { 22405, "Fujitsu Services Finland OY" },
    { 22406, "Adermiis" },
    { 22407, "NeoMeridian Sdn Bhd" },
    { 22408, "PrimeKey Solutions AB" },
    { 22409, "Midland Memorial Hospital" },
    { 22410, "Pixel Technology" },
    { 22411, "Hawkis Consulting" },
    { 22412, "openenterprise.co.uk" },
    { 22413, "TheStreet.com Inc" },
    { 22414, "Pacific Lutheran University" },
    { 22415, "Mole Valley Farmers Ltd." },
    { 22416, "Shelton Internet Ltd" },
    { 22417, "Information Design Department of Tama Art University" },
    { 22418, "Usina de Imagens Photo+Design Ltda." },
    { 22419, "Relex, Inc." },
    { 22420, "accedian, Inc." },
    { 22421, "TSYS Prepaid, Inc." },
    { 22422, "Provideo Systems Pty Ltd" },
    { 22423, "Almos Systems Pty Ltd." },
    { 22424, "INTELSOFT" },
    { 22425, "Audio Processing Technology Ltd" },
    { 22426, "Digital Data Communications Asia Co., Ltd." },
    { 22427, "Sowood & Co Ltd" },
    { 22428, "RealOps, Inc." },
    { 22429, "Florical Systems, Inc." },
    { 22430, "Volke Entwicklungsring GmbH" },
    { 22431, "Phoenix Interactive Design Inc" },
    { 22432, "Gimlitech" },
    { 22433, "Silvermedia Group" },
    { 22434, "NET TIME Corp." },
    { 22435, "Beep Science AS" },
    { 22436, "Sumar\0303\0251 Consultores Associados Ltda." },
    { 22437, "ITZ Informationstechnologie GmbH" },
    { 22438, "Groxis, Inc." },
    { 22439, "CaseNEX" },
    { 22440, "Canadian Bank Note Company, Ltd." },
    { 22441, "Next Dimension Inc." },
    { 22442, "CHILE.COM S.A." },
    { 22443, "EMETEC" },
    { 22444, "GASCARD Partners, L.P." },
    { 22445, "Simon Holmgaard-IT" },
    { 22446, "Bitdefender SRL (formerly 'SOFTWIN SRL')" },
    { 22447, "B.Braun Melsungen AG" },
    { 22448, "Cluster-Worxx.net" },
    { 22449, "SOPA" },
    { 22450, "servicenetz.biz" },
    { 22451, "Custom IDEAS" },
    { 22452, "ING-DiBa AG" },
    { 22453, "H:S Hovedstadens Sygehusf\0303\0246llesskab" },
    { 22454, "Helmut Mauell GmbH" },
    { 22455, "Tribunal Regional do Trabalho  da 4a. Regiao" },
    { 22456, "Hebraic Hertiage Christian School of Theology" },
    { 22457, "Deutscher Ring LebensversicherungsAG" },
    { 22458, "Modulus Video, Inc." },
    { 22459, "QVidia Technologies, Inc." },
    { 22460, "Tangtop Technology Co.,Ltd" },
    { 22461, "JeeF Software" },
    { 22462, "NixSys BVBA" },
    { 22463, "heidemann.org" },
    { 22464, "01map" },
    { 22465, "G.I.E. AXA Technology Services Belgium" },
    { 22466, "hoehmann.biz" },
    { 22467, "Applied Global Technologies, Inc." },
    { 22468, "Red-C Optical Networking" },
    { 22469, "Universidad ORT Uruguay" },
    { 22470, "NetDeposit  Inc." },
    { 22471, "Visible School, Inc." },
    { 22472, "Boingo Wireless Inc." },
    { 22473, "Teledyne Controls" },
    { 22474, "Asylum Telecom, Ltd." },
    { 22475, "UK Broadband" },
    { 22476, "Syncor Systems, Inc." },
    { 22477, "KingHold Technology Co.,LTD" },
    { 22478, "My ERM Application" },
    { 22479, "Crosswalk, Inc." },
    { 22480, "XipLink Networking" },
    { 22481, "HHS Health Options, Inc." },
    { 22482, "nc" },
    { 22483, "StreamShield Networks" },
    { 22484, "grand.central.org" },
    { 22485, "SafeNet InfoTech Pvt Ltd" },
    { 22486, "Kyushu Institute of Technology" },
    { 22487, "2X Software Ltd" },
    { 22488, "Teltronic S.A.U." },
    { 22489, "Telvent Tr\0303\0241fico y Transporte, S.A." },
    { 22490, "Health Care Service Corporation" },
    { 22491, "Vircom, inc." },
    { 22492, "Forensic Signature Corp." },
    { 22493, "MW 2000 S.A." },
    { 22494, "Animaltracks.net" },
    { 22495, "Chandler Gilbert Community College" },
    { 22496, "Digital Stream, Inc." },
    { 22497, "shanghai blackstone communication Ltd" },
    { 22498, "Neddco Enterprises" },
    { 22499, "Document Processing Systems, Inc." },
    { 22500, "OfficeLink Plus Pty. Ltd." },
    { 22501, "UAB Skaitmeninio sertifikavimo centras" },
    { 22502, "DaVita, Inc." },
    { 22503, "Klaus Henske" },
    { 22504, "RedDevel.com" },
    { 22505, "Volker Englisch" },
    { 22506, "Incache LLC" },
    { 22507, "Ministerio da Ciencia e Tecnologia" },
    { 22508, "Beijing FiberHome Mobile Technologies Co.,Ltd" },
    { 22509, "The Potter Group Ltd" },
    { 22510, "WhatCounts" },
    { 22511, "thinkorswim group, inc." },
    { 22512, "Personal Software Developement Company" },
    { 22513, "PT Sapta Sarana Komunika" },
    { 22514, "RVision LLC" },
    { 22515, "Theoretic Solutions" },
    { 22516, "Castalia LLC" },
    { 22517, "Ernster Public Relations" },
    { 22518, "Arel Communications and Software, Ltd." },
    { 22519, "Akademische Fliegergruppe Karlsruhe" },
    { 22520, "Sandpath" },
    { 22521, "Schwegman, Lundberg, Woessner, & Kluth P.A." },
    { 22522, "ClearPath Networks" },
    { 22523, "Fontec Information Technology Inc." },
    { 22524, "Proyecto Fin de Carrera" },
    { 22525, "RMP WebWorks" },
    { 22526, "InstantServers, Inc." },
    { 22527, "Capella Technologies" },
    { 22528, "iPodion GmbH" },
    { 22529, "Kommunale Datenverarbeitungsgesellschaft mbH" },
    { 22530, "Takeda Pharmaceuticals North America, Inc." },
    { 22531, "Paloma Partners" },
    { 22532, "Computer Graphics Group" },
    { 22533, "Symetra Financial" },
    { 22534, "Purdue Pharma L.P." },
    { 22535, "Neiman Marcus Group" },
    { 22536, "COPAN Systems" },
    { 22537, "TreeTop GbR" },
    { 22538, "Reva Systems Corporation" },
    { 22539, "Champion Computer Technologies" },
    { 22540, "Oulun Lyseon lukio" },
    { 22541, "Open Acuity LLC" },
    { 22542, "Lex Persona" },
    { 22543, "GOUNOT" },
    { 22544, "Host Collective Inc." },
    { 22545, "Daudt Consulting" },
    { 22546, "Qwasartech" },
    { 22547, "Alfred University" },
    { 22548, "Biapo" },
    { 22549, "Broad Net Mux Corporation" },
    { 22550, "NANOTEX CORP." },
    { 22551, "MOIMSTONE Co.,LTD" },
    { 22552, "Sinco Informatica" },
    { 22553, "IT Saver" },
    { 22554, "Legion of the Bouncy Castle" },
    { 22555, "Safehaus" },
    { 22556, "JAPAN ADVANCED INSTITUTE OF SCIENCE AND TECHNOLOGY" },
    { 22557, "Deutsche B\0303\0266rse Group" },
    { 22558, "one4vision GmbH" },
    { 22559, "Intersys AG" },
    { 22560, "Dynamic Design GmbH" },
    { 22561, "Graphic Image Technologies (Pty) Ltd." },
    { 22562, "Trivector System AB" },
    { 22563, "ehotel AG" },
    { 22564, "ULX Ltd." },
    { 22565, "Odyss\0303\0251e Syst\0303\0250mes" },
    { 22566, "Devoteam" },
    { 22567, "Instituto Polit\0303\0251cnico de Castelo Branco" },
    { 22568, "Redwave Technology Ltd" },
    { 22569, "Dynameeting spa" },
    { 22570, "Thomas Taeger Datenblatt" },
    { 22571, "AMART Logic" },
    { 22572, "AD.NET solutions Enrico Roga" },
    { 22573, "Infinite Software, Inc." },
    { 22574, "iseg Spezialelektronik GmbH" },
    { 22575, "Astro-Med, Inc." },
    { 22576, "The OpenBSD SNMP Project" },
    { 22577, "Thomas Wollner - IT Beratung und Integration" },
    { 22578, "InFarmTech" },
    { 22579, "kaptara GmbH & Co. KG (formerly 'Christoph Michel IT Management')" },
    { 22580, "Martin-Baker Aircraft Company Ltd" },
    { 22581, "epollux.org" },
    { 22582, "Group 4 Technology Ltd" },
    { 22583, "Clarkson University" },
    { 22584, "Zetera Corporation" },
    { 22585, "Forest Laboratories, Inc." },
    { 22586, "Dotcast, Inc." },
    { 22587, "Hjelle IT-Bistand" },
    { 22588, "LucaS web studio" },
    { 22589, "P6R, Inc." },
    { 22590, "BHG Security Consulting" },
    { 22591, "Fachhochschule Muenchen - ZaK" },
    { 22592, "Informatec LTDA" },
    { 22593, "Emily Carr College of Art and Design" },
    { 22594, "GoldKrush" },
    { 22595, "Modulation Sciences Inc." },
    { 22596, "marrianne.com" },
    { 22597, "eOrg" },
    { 22598, "MissionMode Solutions, Inc." },
    { 22599, "Informatec Comercial e Servi\0303\0247os Ltda." },
    { 22600, "Harris CapRock Communications (formerly 'CapRock Communications')" },
    { 22601, "Tachometry Corporation" },
    { 22602, "TESI T\0303\0250cnica del So i la Imatge S.L." },
    { 22603, "skyblue.eu.com" },
    { 22604, "Rentokil Initial plc" },
    { 22605, "Winkowski Sp. z o.o." },
    { 22606, "Thomas Urban" },
    { 22607, "ChiliTech Internet Solutions, Inc." },
    { 22608, "Cmed Ltd" },
    { 22609, "CJ Microware and Associates" },
    { 22610, "Raksha Networks Inc." },
    { 22611, "Tele Lorca" },
    { 22612, "Envirocare of Utah, LLC" },
    { 22613, "City Animal Hospital Ltd." },
    { 22614, "Shutterbug Productions & Consulting" },
    { 22615, "Luna[e] Project" },
    { 22616, "Companhia de Sistemas - Compsis Consultoria e Comercio de" },
    { 22617, "Richland Community College" },
    { 22618, "IBM/NY Hospitals" },
    { 22619, "Universidade de Aveiro" },
    { 22620, "Serveapolis" },
    { 22621, "stepping stone GmbH" },
    { 22622, "Lightel Technologies Inc." },
    { 22623, "Excellent Rameur" },
    { 22624, "Source Technologies" },
    { 22625, "ProcessClaims" },
    { 22626, "COMET SYSTEM, s.r.o." },
    { 22627, "MIKRO-KOD Ltd." },
    { 22628, "Deutsche Angestellten-Krankenkasse" },
    { 22629, "Alpermann+Velte electronic engineering GmbH" },
    { 22630, "Istituto Nazionale per la Ricerca sul Cancro" },
    { 22631, "Fachhochschule Osnabrueck" },
    { 22632, "TOKYO BUSINESS SOLUTION CO.,LTD." },
    { 22633, "Banco Mercantil do Brasil SA" },
    { 22634, "Objectif Software" },
    { 22635, "SECIT Secure IT Ltd." },
    { 22636, "bbv AG" },
    { 22637, "Angel's Outpost" },
    { 22638, "Siemens PTD EA" },
    { 22639, "UNICO Computer Systems Pty Ltd" },
    { 22640, "LuXpert" },
    { 22641, "Microsyst\0303\0250mes S.A." },
    { 22642, "PROXID" },
    { 22643, "Carsales.com.au Ltd" },
    { 22644, "Zettai.net LLC" },
    { 22645, "Lane County" },
    { 22646, "Americom Government Services, Inc." },
    { 22647, "WRO-COM Maciej Jankowski" },
    { 22648, "TENSQUARE gmbh" },
    { 22649, "Astoria Networks Inc." },
    { 22650, "ADS Specialists, Inc." },
    { 22651, "Visual Commands" },
    { 22652, "Raptor Networks Technology Inc." },
    { 22653, "Stoke Inc" },
    { 22654, "Kodak Dental Systems" },
    { 22655, "Number41Media Corporation" },
    { 22656, "Intelicis Corporation" },
    { 22657, "Exprit s.r.o." },
    { 22658, "Apria Healthcare Group" },
    { 22659, "HHS International Ltd." },
    { 22660, "Wyoming.com" },
    { 22661, "Wolfram Schlich, IT Service" },
    { 22662, "UEcomm Ltd." },
    { 22663, "Banco do Estado de Sergipe S/A" },
    { 22664, "Soost Software Technology" },
    { 22665, "explicate.org" },
    { 22666, "Hautespot Networks" },
    { 22667, "phase5 information technology GbR" },
    { 22668, "Hawaiian Electric Company" },
    { 22669, "North West University" },
    { 22670, "ControlGuard Ltd." },
    { 22671, "VITRONIC Dr.-Ing. Stein Bildverarbeitungssysteme GmbH" },
    { 22672, "University of Peradeniya" },
    { 22673, "GTS Telecom SRL" },
    { 22674, "Gamersmafia" },
    { 22675, "Prorange Ltd." },
    { 22676, "manitu" },
    { 22677, "Finsoft Ltd" },
    { 22678, "Latens Systems Ltd" },
    { 22679, "Futura NT S.r.l." },
    { 22680, "Oxford BioSignals Ltd" },
    { 22681, "ARD Technology" },
    { 22682, "Vesuvius" },
    { 22683, "SIGMA Chemnitz GmbH" },
    { 22684, "ACS Automotive Communication Services GmbH" },
    { 22685, "Fronter AS" },
    { 22686, "Azbooka Publishers Ltd." },
    { 22687, "Brink's (UK) Limited" },
    { 22688, "jborder.com" },
    { 22689, "Yamagata University" },
    { 22690, "Cleon Solutions s.r.l." },
    { 22691, "APL Ltd." },
    { 22692, "Magma Soft" },
    { 22693, "Alpha Venega Corporation" },
    { 22694, "Broadcast Service Danmark A/S" },
    { 22695, "EPCglobal" },
    { 22696, "Netadmin System i Sverige AB" },
    { 22697, "First Point Global Pty Ltd" },
    { 22698, "Match Lab, Inc." },
    { 22699, "M&T Bank Corporation" },
    { 22700, "LUIS COLORADO SISTEMAS, S.L." },
    { 22701, "Hospices - CHUV" },
    { 22702, "SC Stonet  Computers SRL" },
    { 22703, "Ask IT's Done Ltd" },
    { 22704, "University of Kansas Medical Center" },
    { 22705, "DIGICAST Inc." },
    { 22706, "DIGITAL FORECAST Corporation" },
    { 22707, "Comtechservice" },
    { 22708, "eSYS Informationssysteme GmbH" },
    { 22709, "Appistry" },
    { 22710, "Lipman Elektronik ve Danismanlik Ltd.Sti" },
    { 22711, "SGS Societe Generale de Surveillance SA" },
    { 22712, "Wielkopolski Oddzial Wojewodzki NFZ w Poznaniu" },
    { 22713, "Universit\0303\0240 degli Studi di Cassino" },
    { 22714, "Mobilaris AB" },
    { 22715, "CenterPoint - Connective Software Engineering GmbH" },
    { 22716, "Modern World Internet Ltd" },
    { 22717, "VRT" },
    { 22718, "Centre Reseau Communication" },
    { 22719, "Pinellas County Government - IT" },
    { 22720, "Metreos Corporation" },
    { 22721, "SIM International, Inc." },
    { 22722, "KWPark Hardware" },
    { 22723, "Cyjaya Korea" },
    { 22724, "Store Alcala" },
    { 22725, "Marko Durkovic" },
    { 22726, "InfiniLogic (Private) Limited" },
    { 22727, "Z&Z Services" },
    { 22728, "V-Office" },
    { 22729, "Unleash Computers Ltd" },
    { 22730, "TurnTide Incorporated" },
    { 22731, "Data Aire,Inc." },
    { 22732, "Brock University" },
    { 22733, "NorBelle, LLC" },
    { 22734, "synetics gmbh" },
    { 22735, "GSC Mobile Solutions" },
    { 22736, "Digium" },
    { 22737, "SmarTone Mobile Communications Limited" },
    { 22738, "WiNetworks" },
    { 22739, "Network Technology Research Group" },
    { 22740, "S&P Computersysteme GmbH" },
    { 22741, "N-Dimension Solutions Inc." },
    { 22742, "Acbel Polytech Inc." },
    { 22743, "Linz AG" },
    { 22744, "Purple Labs S.A." },
    { 22745, "MathAn Praha, s.r.o." },
    { 22746, "PRIORITY ELECTRONICS LTD." },
    { 22747, "Travelpack" },
    { 22748, "Dade Behring" },
    { 22749, "Celebrity Resorts, Inc." },
    { 22750, "Teen Living Programs, Inc." },
    { 22751, "HealthlineIS" },
    { 22752, "PatchLink Corporation" },
    { 22753, "Convergent Media Network Ltd." },
    { 22754, "Cyntrum Web-Technologies, Inc." },
    { 22755, "Terma Software Labs LLC" },
    { 22756, "Revolution Linux inc." },
    { 22757, "Azonic Technology Ltd." },
    { 22758, "zrn.ru" },
    { 22759, "PROMAX ELECTRONICA,SA" },
    { 22760, "Sphera Corporation Ltd." },
    { 22761, "NAVI Sp. z o.o." },
    { 22762, "GROUPE ATLANTIC" },
    { 22763, "Artis Group GmbH" },
    { 22764, "SPIDCOM Technologies SA" },
    { 22765, "Augur Systems, Inc." },
    { 22766, "Hoatech Technologies Co., Ltd." },
    { 22767, "TTC InfoAge Inc." },
    { 22768, "Technical University of Crete" },
    { 22769, "mur.at - Verein zur Foerderung von Netzwerkkunst" },
    { 22770, "MediaSputnik Ltd." },
    { 22771, "BlueFinger Ltd." },
    { 22772, "Oesterreichische Nationalbank" },
    { 22773, "John Fan" },
    { 22774, "Ensuren Corporation" },
    { 22775, "Centromeric inc" },
    { 22776, "Covance Cardiac Safety Services" },
    { 22777, "Ventura24 S.L." },
    { 22778, "Reclusive Hermit" },
    { 22779, "Carefirst BlueCross BlueShield" },
    { 22780, "Powerline Technologies Ltd" },
    { 22781, "wenzhou telecom" },
    { 22782, "Bridgette, Inc" },
    { 22783, "Rauscher networX" },
    { 22784, "pimp.org.za" },
    { 22785, "ICTeam AG" },
    { 22786, "Lattelekom" },
    { 22787, "internetbureau Websight" },
    { 22788, "PSInd, LLC" },
    { 22789, "martyhill.net" },
    { 22790, "S.K.M. Informatik GmbH" },
    { 22791, "China Council for the Promotion of International Trade (CCPIT)" },
    { 22792, "Voice Technology Ind. and Com. Ltd." },
    { 22793, "Stratum Communications Pty Ltd" },
    { 22794, "Pagaros Pty Limited" },
    { 22795, "Mississippi Valley State University" },
    { 22796, "LOGSYS Inc." },
    { 22797, "openconcept gmbh" },
    { 22798, "University of Crete" },
    { 22799, "Endo7 GmbH/Srl" },
    { 22800, "FlexDSL Telecommunications AG" },
    { 22801, "Amedia Networks, Inc." },
    { 22802, "Telabria Ltd" },
    { 22803, "Psychosys Software Limited" },
    { 22804, "Trivium Technologies Ltd." },
    { 22805, "Utex Communications" },
    { 22806, "Scientica Life Sciences Pvt. Ltd." },
    { 22807, "Andreas Julius" },
    { 22808, "Oesterreichische Aerztekammer" },
    { 22809, "VLI Communications CO.,LTD." },
    { 22810, "Aktia Savings Bank p.l.c." },
    { 22811, "Pfeiffer & May Grosshandel AG" },
    { 22812, "Allscripts, LLC" },
    { 22813, "Pest Control Data Systems, Inc." },
    { 22814, "radiowave limted" },
    { 22815, "Axeda Systems Inc." },
    { 22816, "Rackable Systems, Inc." },
    { 22817, "BAE SYSTEMS Australia" },
    { 22818, "Naked Dwarf" },
    { 22819, "Chas Philly Steaks and Stix" },
    { 22820, "DATS Co. Ltd." },
    { 22821, "Saab AB" },
    { 22822, "MobiComp Computa\0303\0247\0303\0243o M\0303\0263vel S.A." },
    { 22823, "Crodo Technologies Pte Ltd" },
    { 22824, "Verbrugge Terminals BV" },
    { 22825, "Androsoft GmbH" },
    { 22826, "DFDS A/S" },
    { 22827, "Certagon Corporation" },
    { 22828, "Emacolet Networking Services" },
    { 22829, "Core Mobility, Inc." },
    { 22830, "NUMATA Kazuya" },
    { 22831, "Warpera Corporation" },
    { 22832, "POSDATA  Co. Ltd." },
    { 22833, "TMN TECHNOLOGIES Telecomunica\0303\0247\0303\0265es LTDA" },
    { 22834, "Redfish Group Pty Ltd" },
    { 22835, "Firetide Inc" },
    { 22836, "Tercina Inc." },
    { 22837, "Rogers Police Department" },
    { 22838, "A1 Enterprise, Inc" },
    { 22839, "ZQInteractive" },
    { 22840, "pbk2 GmbH & Co. KG" },
    { 22841, "external Business Information Services GmbH" },
    { 22842, "Scientific Games International GmbH" },
    { 22843, "ANWB B.V." },
    { 22844, "Scheede" },
    { 22845, "IntelSight" },
    { 22846, "YR20 GROUP INC." },
    { 22847, "Vindaloo Communications" },
    { 22848, "Id\0303\0251iaLivre" },
    { 22849, "T&F Computer und Networksystems GmbH" },
    { 22850, "MSB" },
    { 22851, "Children's Memorial Hospital" },
    { 22852, "ENEM B.V." },
    { 22853, "GuangZhou Net Control Tech. Ltd." },
    { 22854, "Wojew\0303\0263dzki O\0302\0266rodek Informatyki przy Warminsko - Mazurskim" },
    { 22855, "Multisuns Corp." },
    { 22856, "HiStor technologies" },
    { 22857, "Reflex Security, Inc." },
    { 22858, "financial.com AG" },
    { 22859, "Techaya Inc." },
    { 22860, "The LDAP Company" },
    { 22861, "MDOUK" },
    { 22862, "Winvision" },
    { 22863, "Softwarehaus Hartter" },
    { 22864, "ALPHA.CH AG" },
    { 22865, "University of Basel" },
    { 22866, "Vattenfall AB" },
    { 22867, "G-International Ltd" },
    { 22868, "Ventana Medical Systems, Inc." },
    { 22869, "Deutsche Gesellschaft f\0303\0274r Technische Zusammenarbeit (GTZ) GmbH" },
    { 22870, "Inter-Governmental Consultations on Asylum, Refugee and Migration Policies" },
    { 22871, "Autocom A/S" },
    { 22872, "Reinhard Moosauer IT Beratung" },
    { 22873, "Indian Institute of Information Technology" },
    { 22874, "Syntermed, Inc." },
    { 22875, "Fusion Laboratories, Inc" },
    { 22876, "BlueCows Technical Services" },
    { 22877, "Northern Arkansas Telephone Company, Inc." },
    { 22878, "Allen Corporation of America" },
    { 22879, "Affine DB Ltd." },
    { 22880, "SonicDuo OSP dep." },
    { 22881, "Man Investments Ltd" },
    { 22882, "CJSC \"UKRAINIAN MOBILE COMMUNICATIONS\"" },
    { 22883, "OPENLiMiT SignCubes GmbH" },
    { 22884, "Western Gas Resources, Inc." },
    { 22885, "GIP CPAGE" },
    { 22886, "Astro Strobel Kommunikationssysteme GmbH" },
    { 22887, "PC-Ware Information Technologies AG" },
    { 22888, "Interface Business GmbH" },
    { 22889, "Zenprise, Inc." },
    { 22890, "Department of Applied Mathematics \"U.Dini\"" },
    { 22891, "Future Connect (Pvt) Ltd" },
    { 22892, "Jan B. Telepski Trading" },
    { 22893, "Ing. Petr Setka" },
    { 22894, "Unipower Corporation" },
    { 22895, "RF Technologies, Inc." },
    { 22896, "Govern de les Illes Balears" },
    { 22897, "EPRCI" },
    { 22898, "Sericon Technology Inc." },
    { 22899, "Etherstuff" },
    { 22900, "Statewide Software & Systems" },
    { 22901, "Packet411 Corporation" },
    { 22902, "Discovery Communications Inc." },
    { 22903, "Preferred Communications, Inc." },
    { 22904, "R. L. Polk & Co." },
    { 22905, "OAG Worldwide  Ltd" },
    { 22906, "Medical Soft Instruments SLL" },
    { 22907, "Riege Software International GmbH" },
    { 22908, "Magnus Informatik A/S" },
    { 22909, "T-VIPS AS" },
    { 22910, "MaeSoft Group" },
    { 22911, "EPSILON Software Assistance SA" },
    { 22912, "Comrad Medical Systems Limited" },
    { 22913, "TJM Products Pty Ltd" },
    { 22914, "Sonim Technologies" },
    { 22915, "IFX Corp" },
    { 22916, "Pyramide Technologies Corp" },
    { 22917, "UHS Systems Pty Ltd" },
    { 22918, "TeDenium Ind\0303\0272stria Eletroeletr\0303\0264nica Ltda." },
    { 22919, "Herit Corporation" },
    { 22920, "Windows Consulting Group, Inc." },
    { 22921, "ATI Technologies Incorporated" },
    { 22922, "postlab" },
    { 22923, "moll-illner" },
    { 22924, "wegewerk GmbH" },
    { 22925, "LAB-EL Elektronika Laboratoryjna" },
    { 22926, "Heinrig Impex SRL" },
    { 22927, "Aqsacom SA" },
    { 22928, "Seokyo Telecommunication Co., Ltd." },
    { 22929, "Schuemperlin Engineering AG" },
    { 22930, "SPI Dynamics, Inc." },
    { 22931, "Parlano Inc." },
    { 22932, "Nvia2 Mensajes Interactivos, C.A." },
    { 22933, "itaas, Inc." },
    { 22934, "Rudolf Leiner GmbH" },
    { 22935, "Beijing Univ. of Aeronautics & Astrnautics" },
    { 22936, "Tonbrand Software" },
    { 22937, "Message Mobile GmbH" },
    { 22938, "NOS Technology AS" },
    { 22939, "WebInterstate Inc." },
    { 22940, "Arrowspan Inc." },
    { 22941, "PDX, Inc." },
    { 22942, "O2 Micro" },
    { 22943, "CVC Online" },
    { 22944, "Winuel SA" },
    { 22945, "KaiserAir" },
    { 22946, "Chordcom" },
    { 22947, "IT-INFORMATIK" },
    { 22948, "InSerTO" },
    { 22949, "EMAP Plc" },
    { 22950, "OEG Australia" },
    { 22951, "Lucid Security Corporation" },
    { 22952, "On2 Technologies" },
    { 22953, "EOSLINK CO., LTD" },
    { 22954, "UNIVERSAL MICROELECTRONICS CO., LTD." },
    { 22955, "Azent AB" },
    { 22956, "News International Supply Company Ltd." },
    { 22957, "ZEN Sistemi Srl" },
    { 22958, "Weston Digital Technologies Ltd." },
    { 22959, "Tony Chachere's Creole Foods of Opelousas Inc" },
    { 22960, "Sozotek, Inc." },
    { 22961, "SK Telesys" },
    { 22962, "matrix.mx" },
    { 22963, "Vale Technology LTD" },
    { 22964, "Acceris Communications" },
    { 22965, "Sundance Digital, Inc." },
    { 22966, "COSA GmbH" },
    { 22967, "ZR InfoTech" },
    { 22968, "ComBrio, Inc" },
    { 22969, "H+BEDV Datentechnik GmbH" },
    { 22970, "Dental-On-Line SARL" },
    { 22971, "A.P. Moller - Maersk A/S" },
    { 22972, "Wilibox" },
    { 22973, "Greenfield Networks, Inc." },
    { 22974, "Elgi Equipments Ltd" },
    { 22975, "The NGIM Project" },
    { 22976, "AirInfinite, Inc." },
    { 22977, "MedImpact Healthcare Systems" },
    { 22978, "GridConnect, Inc" },
    { 22979, "Bridgestream Inc." },
    { 22980, "Confio Software" },
    { 22981, "BPB plc" },
    { 22982, "Tectona SoftSolutions Pvt. Ltd." },
    { 22983, "SSTIC" },
    { 22984, "ALS&TEC Ltd" },
    { 22985, "Derdack GmbH" },
    { 22986, "Eurofighter Jagdflugzeug GmbH" },
    { 22987, "EVONET Belgium NV" },
    { 22988, "University of Kentucky" },
    { 22989, "Essex Property Trust, Inc" },
    { 22990, "Baltimore County Savings Bank, FSB" },
    { 22991, "Netalfa Ltd." },
    { 22992, "WIT, Inc." },
    { 22993, "Belarc, Inc." },
    { 22994, "SiliconWorks Corporation" },
    { 22995, "Axley.net" },
    { 22996, "City of Peabody" },
    { 22997, "Ab Initio Software Corporation" },
    { 22998, "Allstream Inc" },
    { 22999, "FURUNO SYSTEMS Co.,Ltd." },
    { 23000, "Nexis s.r.l." },
    { 23001, "Corporaci\0303\0263n Supermercados Unidos S.A" },
    { 23002, "Consentry Networks" },
    { 23003, "HyperWerk FHBB" },
    { 23004, "C&C Solution Technology" },
    { 23005, "Fluidsignal Group S.A." },
    { 23006, "e-Mont d.o.o." },
    { 23007, "Imatic" },
    { 23008, "WebPaws.com" },
    { 23009, "Asamnet e. V." },
    { 23010, "Maxima Communications" },
    { 23011, "OCLC PICA" },
    { 23012, "Netprovider S.A." },
    { 23013, "Salem-Keizer Public Schools" },
    { 23014, "Genie-uk" },
    { 23015, "NewBay Software Ltd." },
    { 23016, "Metaphor Studio, LLC" },
    { 23017, "Ideal Technologies Inc." },
    { 23018, "Matrix Networks China" },
    { 23019, "Pentacomp Systemy Informatyczne Sp. z o.o." },
    { 23020, "FGAN FKIE/KOM" },
    { 23021, "Acstre Support Ltd." },
    { 23022, "Net Optics Inc." },
    { 23023, "THX Ltd." },
    { 23024, "PT. Dinamika Mandiri" },
    { 23025, "meSSSoft" },
    { 23026, "SuedLeasing GmbH" },
    { 23027, "Area Electronic System" },
    { 23028, "Sunrise Technology Co. Ltd." },
    { 23029, "SQI, Inc." },
    { 23030, "Shing" },
    { 23031, "NSP Ltd." },
    { 23032, "MailFrontier, Inc." },
    { 23033, "Leivio Technologies, Inc." },
    { 23034, "SETIB" },
    { 23035, "Labware, s.a." },
    { 23036, "Isomorphic System Research Inc." },
    { 23037, "CMT Systems Inc." },
    { 23038, "Emphasys Software" },
    { 23039, "Ambient Corporation" },
    { 23040, "Exobit Networks, Inc." },
    { 23041, "CQ Inc." },
    { 23042, "The Real Estate Company, Inc." },
    { 23043, "CastIS Corp." },
    { 23044, "SmallBizConcepts BV" },
    { 23045, "Cassee.net" },
    { 23046, "MTD Systems" },
    { 23047, "Xinke (China) Information System Ltd" },
    { 23048, "Sabik OY" },
    { 23049, "Emsys n.v." },
    { 23050, "JSC Department of System Research" },
    { 23051, "SC TeSIS Logic SRL" },
    { 23052, "APPI Tecnologia S.A." },
    { 23053, "DOSHED Corp." },
    { 23054, "Cyris Networks" },
    { 23055, "H Zero Seven" },
    { 23056, "Riedel Communications GmbH" },
    { 23057, "ISD Holland BV" },
    { 23058, "Expertron Group (Pty) Ltd" },
    { 23059, "NetFuel, Inc." },
    { 23060, "Codebench, Inc." },
    { 23061, "VirtualBridges Communications Corp" },
    { 23062, "Huize-wel.nl" },
    { 23063, "Dominion Lasercom, Inc" },
    { 23064, "Kronback ApS" },
    { 23065, "TWINCLING Society" },
    { 23066, "Telmap LTD." },
    { 23067, "Nanomatic Ltd." },
    { 23068, "AngelGroup" },
    { 23069, "Sodexho" },
    { 23070, "Hubris Communications Inc" },
    { 23071, "Conformiq Software Ltd." },
    { 23072, "Australian Internet Company Pty Ltd" },
    { 23073, "WiMetrics Corporation" },
    { 23074, "Security Conscious Inc." },
    { 23075, "Novatel Wireless, Inc." },
    { 23076, "SP" },
    { 23077, "Keppler IT GmbH" },
    { 23078, "Administration des Douanes et Imp\0303\0264ts Indirects" },
    { 23079, "Kiles Consulting" },
    { 23080, "New York State Directory Services" },
    { 23081, "Opus One, Inc." },
    { 23082, "Riedell MotorSports" },
    { 23083, "University of Bridgeport" },
    { 23084, "SCT Consulting" },
    { 23085, "QQ Technology, INC." },
    { 23086, "Major & Minor Exims Pvt Ltd" },
    { 23087, "Ross Sampson Consulting" },
    { 23088, "Applied Watch Technologies, LLC" },
    { 23089, "Nanjing Gentech System CO., Ltd." },
    { 23090, "ncfritz.net" },
    { 23091, "Nilson Group AB" },
    { 23092, "gaztec services" },
    { 23093, "ANAGRAN" },
    { 23094, "Kuehne + Nagel (AG&Co.) KG" },
    { 23095, "ClarioNet, s.r.o." },
    { 23096, "jminet.com" },
    { 23097, "Municipalidad de Rosario" },
    { 23098, "ServicePilot Technologies" },
    { 23099, "NeTAMS" },
    { 23100, "H&T Greenline GmbH" },
    { 23101, "University Hygienic Laboratory" },
    { 23102, "San Mateo County Public Safety Communications" },
    { 23103, "SRP" },
    { 23104, "Raven Systems Design, Inc." },
    { 23105, "Action Systems, Inc." },
    { 23106, "RedPhone Security, Inc." },
    { 23107, "Women's Center for Radiology" },
    { 23108, "RP Online Verlagsgesellschaft mbH" },
    { 23109, "Netline Internet Service GmbH" },
    { 23110, "UNYICO MIEE" },
    { 23111, "Spun Pty Ltd" },
    { 23112, "University of Turku" },
    { 23113, "LXPT" },
    { 23114, "Comstar Ltd." },
    { 23115, "Observatoire Midi-Pyrenees" },
    { 23116, "iVOD Inc." },
    { 23117, "New Zealand Ministry of Health" },
    { 23118, "Telenet Systems Pvt. Ltd." },
    { 23119, "Shevchenko Didkovskiy & Partners" },
    { 23120, "BFE Studio and Media Systems GmbH" },
    { 23121, "Saint-Petersburg Certification Authority" },
    { 23122, "Swisscom Ltd. - formely Bluewin AG" },
    { 23123, "gedas deutschland GmbH" },
    { 23124, "Dickey Rural Telephone Cooperative" },
    { 23125, "Spring Lake Consulting, LLC" },
    { 23126, "BaneTele AS" },
    { 23127, "GINA-COMPUTING GmbH" },
    { 23128, "NitroSecurity, Inc." },
    { 23129, "Macrovision Corporation" },
    { 23130, "CPN International Inc." },
    { 23131, "Mithi Software Technologies private Limited" },
    { 23132, "Canadian Net" },
    { 23133, "IzhInformProject" },
    { 23134, "Skillsunited.co.uk <http://Skillsunited.co.uk>" },
    { 23135, "Articon Integralis AG" },
    { 23136, "Warweus S.r.l" },
    { 23137, "Altinity Limited" },
    { 23138, "Reutlingen University" },
    { 23139, "Software Eginerring Associated Consultants, Inc" },
    { 23140, "Cybernetik.net" },
    { 23141, "HOCHIKI CO.,LTD" },
    { 23142, "Akademia Swietokrzyska" },
    { 23143, "Peterson Packaging Oy" },
    { 23144, "Defenxis Sdn Bhd" },
    { 23145, "ExtendMedia Inc." },
    { 23146, "HOYA" },
    { 23147, "VIMESA, VIDEO MEDIOS S.A." },
    { 23148, "Dr. Peter Koch EDV Dienstleistungen" },
    { 23149, "Typodata" },
    { 23150, "MoCoTec  Mobile Communication Technologies" },
    { 23151, "SeeTec Communications GmbH & Co. KG" },
    { 23152, "HVB Leasing GmbH" },
    { 23153, "Cloanto Corporation" },
    { 23154, "AIT Austrian Institute of Technology GmbH" },
    { 23155, "SOFTWISE DEVELOPMENT" },
    { 23156, "Vitec Group Communications Limited" },
    { 23157, "Theobit GmbH" },
    { 23158, "CCIS sprl" },
    { 23159, "eventIS Software Solutions B.V." },
    { 23160, "Geneous Software AG" },
    { 23161, "Aran Technologies" },
    { 23162, "Ecole Sup\0303\0251rieure d'Informatique" },
    { 23163, "Defensor del Pueblo" },
    { 23164, "Revieworld Ltd" },
    { 23165, "SAFE-Biopharma Association" },
    { 23166, "Automatyka" },
    { 23167, "Operation Mobilisation" },
    { 23168, "Orchard View Community Network" },
    { 23169, "Sigma Systems Canada Inc." },
    { 23170, "Verizon Card Operations" },
    { 23171, "Servergraph" },
    { 23172, "Teletronics Technology Corp" },
    { 23173, "SubZeroNet" },
    { 23174, "WildBlue Communications, Inc." },
    { 23175, "WorkCompCentral.com, Inc." },
    { 23176, "SpeedPartner GmbH" },
    { 23177, "Cirond Corporation" },
    { 23178, "Helix Ltd." },
    { 23179, "Bilfrost Incorporated, Inc." },
    { 23180, "TELEVES S.A." },
    { 23181, "Weed Instrument Company Inc." },
    { 23182, "Sussman Automotive" },
    { 23183, "Amnis Limited Company" },
    { 23184, "Applied Microsystems, Inc." },
    { 23185, "Isensix, Inc." },
    { 23186, "4A Solutions Ltd." },
    { 23187, "Rene Thomas Folse Inc." },
    { 23188, "Maxi Net Services" },
    { 23189, "NETPLEX LLC" },
    { 23190, "Interland, Inc" },
    { 23191, "Nvia Gestion de Datos S.L" },
    { 23192, "Norlight Telecommunications" },
    { 23193, "M-Vision" },
    { 23194, "Northwest University" },
    { 23195, "Afar Communications Inc." },
    { 23196, "DeveTel S.A." },
    { 23197, "HAN InfoComm" },
    { 23198, "One Cow Standing" },
    { 23199, "MCGV Stack" },
    { 23200, "NetFocus Technologies, Inc." },
    { 23201, "ACI Communications, Inc." },
    { 23202, "zinfo.us" },
    { 23203, "tasmanstudios Ltd." },
    { 23204, "Stratacache, Inc." },
    { 23205, "Alcormizar Inc." },
    { 23206, "Clinical DataFax Systems Inc." },
    { 23207, "BIA B.V." },
    { 23208, "Rhodanie Systemes et Reseaux Sarl" },
    { 23209, "Union Compagnonnique" },
    { 23210, "Pyramid Robotics" },
    { 23211, "Queue Global Information Systems Corp." },
    { 23212, "Cuttriss Consulting" },
    { 23213, "Wilico Wireless Networking Solutions SA" },
    { 23214, "j2anywhere.com" },
    { 23215, "Netensia" },
    { 23216, "Bawue.Net e.V." },
    { 23217, "Chambre de Commerce et d'Industrie de Brest" },
    { 23218, "Betanetworks Ltd.,ShangHai, China" },
    { 23219, "DriveTime Automotive Group, Inc." },
    { 23220, "ICO Ltd." },
    { 23221, "ROCSYS Technologies Pvt.Ltd." },
    { 23222, "ESI SOFTWARE" },
    { 23223, "StartCom Ltd." },
    { 23224, "Sutton Group Realty Services Ltd." },
    { 23225, "Maxitel S/A" },
    { 23226, "Dolphin Software" },
    { 23227, "Kayak Interactive" },
    { 23228, "City of Las Vegas Nevada" },
    { 23229, "oneK Internet Solutions Inc." },
    { 23230, "Captara Corporation" },
    { 23231, "tekVizion PVS, Inc" },
    { 23232, "TrackAbout, Inc." },
    { 23233, "Webdoeds" },
    { 23234, "HOPS International Inc" },
    { 23235, "DTI2" },
    { 23236, "Escher Group Ltd" },
    { 23237, "Softier Inc." },
    { 23238, "FCI Broadband Communications Inc." },
    { 23239, "Aquest Systems, Incorporated" },
    { 23240, "the Centers" },
    { 23241, "Protection and Guard Service" },
    { 23242, "SDRC Inc." },
    { 23243, "Algorab SRL" },
    { 23244, "Improbable Universe" },
    { 23245, "Westdeutsche ImmobilienBank" },
    { 23246, "Harmonia Inc." },
    { 23247, "Wm-Data PARERE" },
    { 23248, "TRE-CE" },
    { 23249, "National Center for Biotechnology Information (NCBI)" },
    { 23250, "fgn GmbH" },
    { 23251, "Servicios Corporativos Gefe S.A. de C.V." },
    { 23252, "MYDOM" },
    { 23253, "Premier Image Corporation" },
    { 23254, "Leebel Services" },
    { 23255, "1D Solutions" },
    { 23256, "Wit-Sys Consulting Corporation" },
    { 23257, "OSIsoft, Inc." },
    { 23258, "SdO Information Technology s.r.l." },
    { 23259, "Stadt Frankfurt am Main" },
    { 23260, "Paradial AS" },
    { 23261, "Structured Information Management (SIM) Project" },
    { 23262, "Obiect Soft SRL" },
    { 23263, "EXCELIANCE" },
    { 23264, "Unicon Solutions NV" },
    { 23265, "Hedgehog Computer Services" },
    { 23266, "Frank Lowe Rubber & Gasket Co., Inc." },
    { 23267, "Certic\0302\0267mara S.A." },
    { 23268, "Sunwayworld Infomation Technology Inc." },
    { 23269, "NeoNova Network Services Inc." },
    { 23270, "AW Comp" },
    { 23271, "Protium Technologies, Inc." },
    { 23272, "Runcom Technologies Ltd." },
    { 23273, "Eletech S.r.l." },
    { 23274, "Mindsphere AS" },
    { 23275, "Pro Help" },
    { 23276, "Cooperativa dos Agricultores da Regiao de Orlandia" },
    { 23277, "ClusterVision BV" },
    { 23278, "Computer Royalties" },
    { 23279, "Picis, Inc." },
    { 23280, "DigitalFreaks.org" },
    { 23281, "Liaoning Mobile Communications CO.LTD" },
    { 23282, "iBright" },
    { 23283, "I/O Concepts, Inc." },
    { 23284, "Identify Technology Solutions" },
    { 23285, "STRATUM-IP" },
    { 23286, "Gottfried Hamm KommunikationsSysteme" },
    { 23287, "Joint Concepts Development" },
    { 23288, "Hands-On Security, Inc." },
    { 23289, "Dandy Connections, Inc." },
    { 23290, "Shaanxi Normal University" },
    { 23291, "SigValue Technologies" },
    { 23292, "Aternity Inc." },
    { 23293, "Zafin Labs" },
    { 23294, "GeFoekoM e.V." },
    { 23295, "Ingenium NET SRL" },
    { 23296, "Yawarra Information Appliances Pty Ltd" },
    { 23297, "schlittermann -- internet & unix support" },
    { 23298, "WestLotto GmbH & Co oHG" },
    { 23299, "LRF" },
    { 23300, "ABEM Instrument AB" },
    { 23301, "Datenverarbeitungszentrum Halle GmbH" },
    { 23302, "LINBIT Information Technologies GmbH" },
    { 23303, "Dot Communications" },
    { 23304, "Codan Limited" },
    { 23305, "Woojyun Systec" },
    { 23306, "BeiJing Techstar Ltd." },
    { 23307, "Machaira Enterprises Pty Ltd" },
    { 23308, "NATIONAL CENTER FOR HIGH-PERFORMANCE COMPUTING" },
    { 23309, "AR Infotek Inc." },
    { 23310, "OFiR a-s" },
    { 23311, "Macab AB" },
    { 23312, "IntelliCom Innovation AB" },
    { 23313, "Tesla a.s." },
    { 23314, "Plantron AB" },
    { 23315, "Boldon James Ltd" },
    { 23316, "Niedersaechische Forstliche Versuchsanstalt" },
    { 23317, "Heinrich Bauer Verlag KG" },
    { 23318, "Comune di Bologna" },
    { 23319, "SIRLAN Technologies SAS" },
    { 23320, "Orange Romania SA" },
    { 23321, "Frank Juedes EDV-Service" },
    { 23322, "Aircom International" },
    { 23323, "Cable & Wireless Telecommunication Services GmbH" },
    { 23324, "swarco" },
    { 23325, "KOTIO" },
    { 23326, "Association des dipl\0303\0264m\0303\0251s des formations Syst\0303\0250mes de " },
    { 23327, "VAD Video-Audio_Design GmbH" },
    { 23328, "quadraginta-duo.de" },
    { 23329, "McDaniel College" },
    { 23330, "CommScope Inc. of North Carolina" },
    { 23331, "Johnson Bible College" },
    { 23332, "ADCC Inc." },
    { 23333, "Computer Resource Team, Inc." },
    { 23334, "Gorman Electronics,Inc." },
    { 23335, "Hampton Roads Maritime Association" },
    { 23336, "VELUX A/S IT Department" },
    { 23337, "Cybertrust" },
    { 23338, "OpenS Tecnologia e Processamento de Dados Ltda." },
    { 23339, "JUNG Analog- und Digital-Systemtechnik GmbH" },
    { 23340, "Kedah Electronics Engineering" },
    { 23341, "Astute.BIZ, Inc." },
    { 23342, "Pathfinder Associates LLC" },
    { 23343, "Invensys/Wonderware" },
    { 23344, "AXS-One Inc." },
    { 23345, "System Control Networks" },
    { 23346, "Voya Financial (formerly 'CitiStreet, LLC')" },
    { 23347, "Infra Resource, LLC." },
    { 23348, "PC KNOW HOW CENTER Brachhold GmbH" },
    { 23349, "NTT GIN" },
    { 23350, "Vertasent, LLC" },
    { 23351, "Watertown Public Schools, Watertown, MA, USA" },
    { 23352, "Cognis Corporation" },
    { 23353, "Intelaware" },
    { 23354, "Niska AB" },
    { 23355, "Gosh Enterprises, Inc." },
    { 23356, "TRYSKEL" },
    { 23357, "TwentyFourNine (formerly 'oogyNetworks')" },
    { 23358, "Typhon SARL" },
    { 23359, "Hexod" },
    { 23360, "Pacific Union College" },
    { 23361, "TEConcept GmbH" },
    { 23362, "Leviton Mfg Co." },
    { 23363, "Sumach GB Ltd" },
    { 23364, "Bryn Mawr College" },
    { 23365, "Websense, Inc." },
    { 23366, "ValueClick, Inc." },
    { 23367, "Host Europe GmbH (formerly 'm networking')" },
    { 23368, "GHK Wireless" },
    { 23369, "Shawn Church, Information Systems Consultant" },
    { 23370, "Joel Davis" },
    { 23371, "BestInfo Cyber Technology Co.,Ltd" },
    { 23372, "Bloombase Technologies Ltd" },
    { 23373, "NEC Kansai, Ltd." },
    { 23374, "REDtone Telecommunications Sdn. Bhd." },
    { 23375, "Islandwide Express" },
    { 23376, "Hyundai Network System, Inc." },
    { 23377, "IT Solution Services Co.,Ltd." },
    { 23378, "T&C Technology" },
    { 23379, "HUK-COBURG VVaG" },
    { 23380, "Datadec Online, S.A." },
    { 23381, "Die GRUENEN" },
    { 23382, "Swissphone Telecom AG" },
    { 23383, "Azienda Sanitaria Locale N.4 Chiavarese" },
    { 23384, "Aptus Elektronik AB" },
    { 23385, "GESIS Gesellschaft f\0303\0274r Informationssysteme mit beschraenkter Haftung (formerly 'GESIS mbH')" },
    { 23386, "Pole Universitaire Leonard de Vinci" },
    { 23387, "iXTS Software GmbH" },
    { 23388, "Hypercube Systems Ltd." },
    { 23389, "IZB M\0303\0274nchen-Frankfurt a. M. GmbH & Co. KG" },
    { 23390, "easyWAN GmbH" },
    { 23391, "Atomwide Ltd." },
    { 23392, "Insightix Ltd." },
    { 23393, "LLC CTI - Center of Telephony Integration" },
    { 23394, "Groupe Wesford" },
    { 23395, "Trustedtec" },
    { 23396, "Neighbourhood Link" },
    { 23397, "Fine Point Technologies, Inc" },
    { 23398, "MTS Allstream Inc." },
    { 23399, "The National Science Foundation" },
    { 23400, "Midcontinent Communications" },
    { 23401, "Sliwa.EU.org Network" },
    { 23402, "Interstar Technologies Inc." },
    { 23403, "Sharp HealthCare" },
    { 23404, "DAVANTEL" },
    { 23405, "JSC Sahalinmorsvjaz" },
    { 23406, "LDAPtive Pty Ltd" },
    { 23407, "Bryant Unlimited" },
    { 23408, "Rhombus Systems Ltd." },
    { 23409, "Torque.net inc." },
    { 23410, "Hackstrike Ltd." },
    { 23411, "ServInfo" },
    { 23412, "Arcontech Ltd" },
    { 23413, "Melange Corporation" },
    { 23414, "Ilmarinen Mutual Pension Insurance Company" },
    { 23415, "nordsys.com" },
    { 23416, "MIT-xperts GmbH" },
    { 23417, "COPITEC - Consejo Profesional de Ingenier\0303\0255a de Telecomunicaciones," },
    { 23418, "Gridlogix, Inc." },
    { 23419, "Talk24" },
    { 23420, "APS systems AG" },
    { 23421, "Altana Pharma AG" },
    { 23422, "Instituto Superior de Contailidade e Administracao de Coimbra" },
    { 23423, "Osmosys S.A." },
    { 23424, "Maximum Impression, LLC" },
    { 23425, "QS Technologies, Inc." },
    { 23426, "Louverturenet" },
    { 23427, "The Home Depot Supply MRO" },
    { 23428, "NOC, School of Engineering, Morgan State University" },
    { 23429, "Eurocis" },
    { 23430, "Lumigent Technologies, Inc." },
    { 23431, "CAMed" },
    { 23432, "Packet Island Inc." },
    { 23433, "BGComp Inc." },
    { 23434, "Georgia Technology Authority" },
    { 23435, "Rock Holdings Inc." },
    { 23436, "Mexicana de Electromecanicos SA de CV" },
    { 23437, "Don Bosco Institute of Technology" },
    { 23438, "Beijing Wandong Medical Equipment Co. Ltd." },
    { 23439, "HurdFr" },
    { 23440, "Avvenu Inc." },
    { 23441, "R.A.Systems" },
    { 23442, "RockMon IT-Consulting" },
    { 23443, "miniprobe" },
    { 23444, "LATECOERE" },
    { 23445, "Jordan Curzon" },
    { 23446, "H5-Group" },
    { 23447, "Opsware Inc." },
    { 23448, "Avitech AG" },
    { 23449, "Tripod Technology Group, Inc." },
    { 23450, "W. A. Strosberg" },
    { 23451, "Wallenius Wilhelmsen Lines" },
    { 23452, "SunGard Availability Services" },
    { 23453, "KungFoo" },
    { 23454, "Belzebyte Network" },
    { 23455, "Exceptional Software Strategies, Inc." },
    { 23456, "NetCarrier Inc" },
    { 23457, "AMVESCAP PLC" },
    { 23458, "National Cybernet Security LTD" },
    { 23459, "Chunghwa Telecom Co., Ltd." },
    { 23460, "Profilium Inc." },
    { 23461, "In4S, Inc." },
    { 23462, "Unixconn" },
    { 23463, "Kolporter Info S.A." },
    { 23464, "Department of IT, University of Defense, Czech Armed Forces" },
    { 23465, "VIVOTEK INC." },
    { 23466, "Vision Fire and Security" },
    { 23467, "Shanghai INFOPLS Network Technology Co.,Ltd. , China" },
    { 23468, "NGC Systems Sdn Bhd" },
    { 23469, "opensoul.org" },
    { 23470, "LOGATIQUE" },
    { 23471, "Digita Oy" },
    { 23472, "mangoART.AT - Web- und Multimediatechnik, Softwareentwicklung" },
    { 23473, "Panda Software International S.L." },
    { 23474, "EITB" },
    { 23475, "Softel Group" },
    { 23476, "British Educational Communications and Technology Agency" },
    { 23477, "DABiS AG" },
    { 23478, "Provincia di Firenze" },
    { 23479, "Sulake Corporation Oy" },
    { 23480, "Degussa Bank GmbH" },
    { 23481, "Infoaxis Ltd" },
    { 23482, "Altobridge Ltd." },
    { 23483, "University of North Carolina Asheville" },
    { 23484, "C .D.H. srl" },
    { 23485, "AusCERT - Australian Computer Emergency Response Team" },
    { 23486, "NetCentrum Ltd." },
    { 23487, "Daxten Ltd" },
    { 23488, "Technica Corporation" },
    { 23489, "Visplex Association" },
    { 23490, "ENIDAN Technologies GmbH" },
    { 23491, "CyberTech B.V." },
    { 23492, "LightCore Co., Ltd." },
    { 23493, "Aminfu Hudima" },
    { 23494, "Mint Systems Ltd." },
    { 23495, "IT-Pro Peter Lechner" },
    { 23496, "Boursorama" },
    { 23497, "Lswei" },
    { 23498, "Shanghai Asia-Pacific Computer Information System Co, Ltd." },
    { 23499, "Siemens Programm- und Systementwicklung GmbH & Co. KG" },
    { 23500, "Articy Computer System & Service" },
    { 23501, "SailBum Enterprises, LLC" },
    { 23502, "Renew Data Corp" },
    { 23503, "Arizona Foundation for Medical Care" },
    { 23504, "TWENTIETH CENTURY FOX FILM CORPORATION" },
    { 23505, "Programming/Design" },
    { 23506, "Pleiades Consulting, Inc" },
    { 23507, "salesforce.com" },
    { 23508, "EVI" },
    { 23509, "BVCompuworks" },
    { 23510, "Centro Cultural y Deportivo Tajamar" },
    { 23511, "TELUS" },
    { 23512, "Copi Family" },
    { 23513, "Westline Security Ltd." },
    { 23514, "Michaels Stores Inc." },
    { 23515, "TEKMOB, lda" },
    { 23516, "CitiCards" },
    { 23517, "Leviton Voice And Data" },
    { 23518, "Tomas Zoufaly" },
    { 23519, "Regal-Beloit Corporation" },
    { 23520, "Unassigned" },
    { 23521, "Amherst County Public Schools" },
    { 23522, "Volicon, Inc." },
    { 23523, "MT Consulting S.A." },
    { 23524, "Weberhofer GmbH" },
    { 23525, "Aleksey Barabanov" },
    { 23526, "Auster Sistemas & Solu\0303\0247\0303\0265es de Inform\0303\0241tica Ltda." },
    { 23527, "NewPage Corporation" },
    { 23528, "The Laddie Group" },
    { 23529, "APP!X S.R.L." },
    { 23530, "State of Alaska, Enterprise Technology Services" },
    { 23531, "Practeo SA" },
    { 23532, "PLAN Australia Pty Ltd" },
    { 23533, "PJR.cc" },
    { 23534, "Supertronic Spa" },
    { 23535, "Holly Australia Pty Ltd" },
    { 23536, "eNClue Co., Ltd." },
    { 23537, "Shanghai Dreaming Information Technology Co., Ltd." },
    { 23538, "Jenston Technology Corporation Ltd." },
    { 23539, "teamdzr" },
    { 23540, "Cordys Holding B.V." },
    { 23541, "Emcore Corporation" },
    { 23542, "CryptoSign" },
    { 23543, "iCONN" },
    { 23544, "Allen ReSearch" },
    { 23545, "West Ridge Networks, Inc." },
    { 23546, "Wagner and Associates Groupware Services, Inc" },
    { 23547, "IFSERCON COM s.r.l." },
    { 23548, "Elber S.r.L." },
    { 23549, "Toyo Networks & System Integration Co., Ltd." },
    { 23550, "e-World Developments Ltd" },
    { 23551, "ErgonomiX Software GmbH" },
    { 23552, "JPS Communications" },
    { 23553, "Discover Financial Services, Inc." },
    { 23554, "PEMI" },
    { 23555, "contentteam GmbH" },
    { 23556, "Centre de Gestion Ocean" },
    { 23557, "EEA communication solutions" },
    { 23558, "IPsoft Inc." },
    { 23559, "United Information System Service Co., Ltd." },
    { 23560, "edreams" },
    { 23561, "Anite Deutschland GmbH & CO.KG" },
    { 23562, "Smartware Computing" },
    { 23563, "DUX Inc." },
    { 23564, "Schmidt GmbH" },
    { 23565, "Panta Computer Systems" },
    { 23566, "Infohit Computers d.o.o." },
    { 23567, "Georg-Christoph-Lichtenberg-Schule, Kassel" },
    { 23568, "Noel-Plus, s.r.o." },
    { 23569, "TeamWorx Productions Ltd." },
    { 23570, "Soliton" },
    { 23571, "IPBS-CNRS" },
    { 23572, "WebMagician Global" },
    { 23573, "Kids & Co g.e.V." },
    { 23574, "TU Hamburg-Harburg" },
    { 23575, "Wayfinder Systems AB" },
    { 23576, "ADVIS Maciej Matysiak" },
    { 23577, "Enfo Partner Oy" },
    { 23578, "MSC Vertriebs GmbH (formerly 'Smart Network Devices GmbH')" },
    { 23579, "Centrica plc" },
    { 23580, "Andritz Oy" },
    { 23581, "Hacousto Holland" },
    { 23582, "ESEO" },
    { 23583, "APOS Systems Inc." },
    { 23584, "Logical Progression Ltd" },
    { 23585, "Bank Technologies Centre" },
    { 23586, "Ralf Kirchner Systemanalyse" },
    { 23587, "PROFIcomms s.r.o." },
    { 23588, "FOI, Swedish Defence Research Agency" },
    { 23589, "Max Zinal's Number" },
    { 23590, "F.I.A.S.A." },
    { 23591, "CCNY" },
    { 23592, "Iowa Counties Information Technology" },
    { 23593, "Dipl.-Ing. Heiko Boesel" },
    { 23594, "EBI L.P." },
    { 23595, "Virginia Employment Commission" },
    { 23596, "pikkerton GmbH" },
    { 23597, "Esica Terra Inc." },
    { 23598, "UX" },
    { 23599, "Studio Network Solutions" },
    { 23600, "Transora" },
    { 23601, "Emcom Systems" },
    { 23602, "Fulano.com.br S/A" },
    { 23603, "Optellios" },
    { 23604, "GoldPocket Interactive, Inc." },
    { 23605, "Applications Plus, Inc." },
    { 23606, "DigiPen Institute of Technology" },
    { 23607, "M\0303\0251lix" },
    { 23608, "Paul's Farm" },
    { 23609, "Ix Appliance, Inc." },
    { 23610, "WDG s.c." },
    { 23611, "nLight, s.r.o." },
    { 23612, "Atlassian Software Systems" },
    { 23613, "JAPAN IMAGE & NETWORK INC." },
    { 23614, "A. Wilton" },
    { 23615, "HiFX IT & MEDIA SERVICES PVT. LTD." },
    { 23616, "SYNCHROSOFT" },
    { 23617, "Deutsches Literaturarchiv Marbach" },
    { 23618, "Saima Avandero Spa" },
    { 23619, "SERGAS" },
    { 23620, "Teltronix Ltd" },
    { 23621, "Bechtel SAIC Company LLC" },
    { 23622, "European Patent Office" },
    { 23623, "Icon Multimedia" },
    { 23624, "Prvn\0303\0255 certifika\0303\0250n\0303\0255 autorita, a.s." },
    { 23625, "Intechgral Inc." },
    { 23626, "Poggs Computer Services" },
    { 23627, "Interlix" },
    { 23628, "California State University Dominguez Hills" },
    { 23629, "SafeNet, Inc. (formerly 'Mykotronx, Inc.')" },
    { 23630, "Computer Aid, Inc." },
    { 23631, "Azalea Networks, Inc." },
    { 23632, "Sneha Technologies S.L." },
    { 23633, "ipsys Communications AG" },
    { 23634, "TC Automatisering" },
    { 23635, "colin.de" },
    { 23636, "Lycee Ader Bernay" },
    { 23637, "Novartis Institutes og BioMedical Research Vienna GmbH & Co KG" },
    { 23638, "Logilec" },
    { 23639, "ParsGroup Informationstechnologie GmbH" },
    { 23640, "Enercon Ltd." },
    { 23641, "Cascade Ltd" },
    { 23642, "Tmidia Inc." },
    { 23643, "bsecure.dk" },
    { 23644, "Siemens Ltd., China" },
    { 23645, "DAF Trucks" },
    { 23646, "Cell C (Pty) Ltd" },
    { 23647, "SARL GALLET.info" },
    { 23648, "ESV, LLC" },
    { 23649, "Cornerturn, LLC" },
    { 23650, "Opendicom" },
    { 23651, "Integrated Decisions and system Inc." },
    { 23652, "Lewes Computer Services" },
    { 23653, "Cirrus Technologies Pty Ltd" },
    { 23654, "AICHI ELECTRIC CO., LTD." },
    { 23655, "CallDesk S.A." },
    { 23656, "Cult Hill Innovation Limited" },
    { 23657, "TEDIS, a.s." },
    { 23658, "TUBITAK ULAKBIM" },
    { 23659, "lars morich Kommunikationstechnik GmbH" },
    { 23660, "DRS Technologies, Inc, C2 Systems" },
    { 23661, "American TeleCare, Inc." },
    { 23662, "Blue Jungle, Inc" },
    { 23663, "Storied Future Infrastructure" },
    { 23664, "Federal Deposit Insurance Corporation" },
    { 23665, "wiselink" },
    { 23666, "BeaufortWeb" },
    { 23667, "FredNet" },
    { 23668, "Kaspersky Lab ZAO" },
    { 23669, "Kyphon Europe" },
    { 23670, "Nihon Kohden Corporation" },
    { 23671, "CIS Hollywood" },
    { 23672, "nTime Servicos de Informatica e Comercio Ltda" },
    { 23673, "Bluesoft sp z o.o." },
    { 23674, "Edu Business Solutions" },
    { 23675, "Foray Technologies Inc." },
    { 23676, "G&K Services inc." },
    { 23677, "Colonial Fiji" },
    { 23678, "PCTEL, Inc." },
    { 23679, "Diligence Consulting, L.L.C." },
    { 23680, "Eclipse SP LLC." },
    { 23681, "terreActive AG" },
    { 23682, "emuse Technologies Ltd." },
    { 23683, "EDV-COMPAS GmbH" },
    { 23684, "Sensitech Inc." },
    { 23685, "Godsk.net" },
    { 23686, "Softential, Inc." },
    { 23687, "Pobeda JSC" },
    { 23688, "Summit  Development, Ltd" },
    { 23689, "Pervenio Ltd" },
    { 23690, "Abstract Ltd." },
    { 23691, "VIA" },
    { 23692, "IDactis" },
    { 23693, "Networks & Concepts GmbH" },
    { 23694, "PMX NETWORKS, INC" },
    { 23695, "PePLink Ltd." },
    { 23696, "Nilai International College" },
    { 23697, "hoi-polloi.org (formerly 'aspector GmbH')" },
    { 23698, "RELDATA Inc." },
    { 23699, "Zyden Software" },
    { 23700, "Internews 98 Ltd." },
    { 23701, "Cannon Technologies Ltd" },
    { 23702, "SHD Holding GmbH" },
    { 23703, "Agile Software (NZ) Ltd" },
    { 23704, "Calypso Capital Management" },
    { 23705, "Salient Corporation, Inc" },
    { 23706, "GlobalPOPs" },
    { 23707, "LAFARGE ALUMINATES" },
    { 23708, "HYMATOM SA" },
    { 23709, "Miltope Corporation" },
    { 23710, "Agincourt Computing" },
    { 23711, "Seventh Skill Ltd" },
    { 23712, "Minnesota Office of Enterprise Technology" },
    { 23713, "Keating Inc" },
    { 23714, "Data Systems S.A.E.C.A." },
    { 23715, "Live Monitoring Pty Ld (formerly 'Produ-Tech Monitoring Pty Ld')" },
    { 23716, "United States Council for Automotive Research" },
    { 23717, "Siricomm, Inc." },
    { 23718, "Esensors, Inc." },
    { 23719, "Arishi" },
    { 23720, "Netifice Communications, Inc." },
    { 23721, "The Ideal Computer Group Inc." },
    { 23722, "CS-Soft, s.r.o" },
    { 23723, "Great Power Electrin Science and Technology stock CO.LTD" },
    { 23724, "Udo Neumann" },
    { 23725, "Theserver Brasil / Multidiagnostica IT Team" },
    { 23726, "VOTORANTIM INVESTIMENTOS INDUSTRIAIS S.A." },
    { 23727, "Marlin Trust Management Organization L.L.C" },
    { 23728, "Versio SARL" },
    { 23729, "DiVitas Networks" },
    { 23730, "OVEA" },
    { 23731, "Telestar" },
    { 23732, "ShijiaZhuang Railway Institute" },
    { 23733, "JGC Corporation" },
    { 23734, "OEBB" },
    { 23735, "Fondation RESTENA" },
    { 23736, "IceWarp Ltd." },
    { 23737, "Hochschule Ulm" },
    { 23738, "AWR Solution Network" },
    { 23739, "HUG" },
    { 23740, "SynerGIS Informationssysteme GmbH" },
    { 23741, "Wogri Unlimited" },
    { 23742, "CONNOTECH Experts-conseils inc." },
    { 23743, "Kerridge Computer Company Ltd" },
    { 23744, "BITMARCK SOFTWARE GMBH (formerly 'Arbeitsgemeinschaft Informationssysteme in der gesetzlichen Krankenversicherung (ISKV)')" },
    { 23745, "Black Hen Limited" },
    { 23746, "Administration communale de Braine-l'Alleud" },
    { 23747, "Areste Centre Informatique" },
    { 23748, "Edinform S.p.A" },
    { 23749, "Federal State Unitary Enterprise Leningrad Radio Research and " },
    { 23750, "new10 GmbH" },
    { 23751, "PT. TRG international" },
    { 23752, "ExcellNet IT Services and Consulting" },
    { 23753, "Infinit Productions" },
    { 23754, "Mairie de Savigny-Sur-Orge" },
    { 23755, "Softrax Corporation" },
    { 23756, "Promotora de Informaciones, S.A." },
    { 23757, "AR Telecom" },
    { 23758, "Desert Cascade" },
    { 23759, "Szolnok V\0303\0241ros Polg\0303\0241rmesteri Hivatal" },
    { 23760, "LayerZero Power Systems, Inc." },
    { 23761, "CMSL" },
    { 23762, "Time-Ware" },
    { 23763, "Rent a PACS GmbH" },
    { 23764, "Atamo Pty Ltd" },
    { 23765, "GetNet Comunicacoes S/C LTDA" },
    { 23766, "TriGeo Network Security, Inc." },
    { 23767, "Rensselaer Hartford Graduate Center, Inc" },
    { 23768, "Integrated Management Resources, Inc." },
    { 23769, "Infinity Technology, Inc." },
    { 23770, "Andreoli Domenico" },
    { 23771, "Marakana, Inc." },
    { 23772, "RoutePulse Technologies" },
    { 23773, "Starfire Engineering & Technologies, Inc." },
    { 23774, "jNetX Inc." },
    { 23775, "Outer TI" },
    { 23776, "RougeNetwork" },
    { 23777, "Elektrarny Opatovice a.s." },
    { 23778, "BEZ Systems, Inc." },
    { 23779, "Asklepios Group" },
    { 23780, "Prose Consulting Ltd. (formerly 'Freedomware UK')" },
    { 23781, "Albertslund Ungdomsboliger" },
    { 23782, "ASN" },
    { 23783, "iTellus Holdings, Inc. (formerly 'Tellurian Networks, Inc.')" },
    { 23784, "StrataLight Communications" },
    { 23785, "CIC/CAFMICRO" },
    { 23786, "DS DATA SYSTEMS GmbH" },
    { 23787, "gnyrf.net" },
    { 23788, "Matt Wright Consulting" },
    { 23789, "GrammaTech, Inc." },
    { 23790, "Pearce Bevill Leesburg & Moore, P.C." },
    { 23791, "Adaptix" },
    { 23792, "Axell Wireless Israel Ltd (formerly 'Dekolink Wireless Ltd')" },
    { 23793, "Cluster Resources" },
    { 23794, "Significant Bits" },
    { 23795, "Movile (formerly 'Yavox Latin America')" },
    { 23796, "SunWare GmbH & Co KG" },
    { 23797, "KSIGN Co., Ltd." },
    { 23798, "Australia Post" },
    { 23799, "icon Systemhaus GmbH" },
    { 23800, "Roca Corporaci\0303\0263n Empresarial, S.A" },
    { 23801, "Metrima Energi AB" },
    { 23802, "Dekabank" },
    { 23803, "Ecole Polytechnique" },
    { 23804, "Rena Electronica B.V." },
    { 23805, "International Industrial Bank" },
    { 23806, "Touch Clarity Ltd." },
    { 23807, "UIB Umwelt Informatik B\0303\0274ro GmbH" },
    { 23808, "CCM Software Services Ltd." },
    { 23809, "Bridicum Security Group A/S" },
    { 23810, "Rothschild Bank AG" },
    { 23811, "Qbizm technologies, a.s." },
    { 23812, "INL SARL" },
    { 23813, "Cendant TDS" },
    { 23814, "ID-Tech Servicos em Informatica Ltda." },
    { 23815, "Waterbury Republican American" },
    { 23816, "SlipStream Data Inc." },
    { 23817, "Ministerio de Econom\0303\0255a, Rep\0303\0272blica Argentina" },
    { 23818, "FirstEnergy Corp." },
    { 23819, "Epoch Integration Inc." },
    { 23820, "Lateral Net Ltd." },
    { 23821, "Irish Centre for High End Computing" },
    { 23822, "MITSUI HOME CO.,LTD." },
    { 23823, "Wise Technology Co.,Ltd." },
    { 23824, "LAC Co., Ltd." },
    { 23825, "EZconn Corporation" },
    { 23826, "HiSpeed Data, Inc." },
    { 23827, "GHY International" },
    { 23828, "MKI Systems" },
    { 23829, "W&W Informatik GmbH" },
    { 23830, "Blekinge Studentservice AB" },
    { 23831, "Teneros, Inc." },
    { 23832, "Aitec do Brasil Ltda" },
    { 23833, "DentaQuest Ventures, Inc." },
    { 23834, "Fachhochschule Salzburg GmbH" },
    { 23835, "emFAST Inc" },
    { 23836, "DS4 Laser Technology s.r.l." },
    { 23837, "Jefferson County School District" },
    { 23838, "BIATEL Systemy Komputerowe Sp. z oo." },
    { 23839, "GROX Networks" },
    { 23840, "School District #57 (Prince George)" },
    { 23841, "RAD-OP" },
    { 23842, "Kuban Pharm Stocks, Ltd." },
    { 23843, "Departamento de Ci\0303\0252ncia da Computa\0303\0247\0303\0243o/Universidade Federal da" },
    { 23844, "Constellation Brands, Inc." },
    { 23845, "Schowalter, GbR" },
    { 23846, "Endress+Hauser InfoServe GmbH+Co. KG" },
    { 23847, "Elogic snc di Antonini Filippo" },
    { 23848, "Middle Kingdom - SCA, Inc." },
    { 23849, "PACSGEAR, Inc." },
    { 23850, "Zyberit AB" },
    { 23851, "CCI Consulting Ltd." },
    { 23852, "Seeing Machines Pty Ltd" },
    { 23853, "eThinkSolutions,Inc." },
    { 23854, "Shipbuilding SS" },
    { 23855, "Bullant Software" },
    { 23856, "Imtec Imaging, LLC" },
    { 23857, "NextIO, Inc" },
    { 23858, "VadaTech Inc." },
    { 23859, "Puntoblu Srl" },
    { 23860, "Schubert-Unternehmensgruppe" },
    { 23861, "redweb.cz" },
    { 23862, "AimValley B.V." },
    { 23863, "Fort Hays State University" },
    { 23864, "Cascadia Information Technologies, Inc." },
    { 23865, "Synapps" },
    { 23866, "Starnix Care Inc." },
    { 23867, "Silver Peak Systems, Inc." },
    { 23868, "sis-tec" },
    { 23869, "HIOKI E.E.Corporation" },
    { 23870, "EMSTONE Co." },
    { 23871, "Qno Technology Inc." },
    { 23872, "Rikom d.o.o." },
    { 23873, "MKC Michels & Kleberhoff Computer GmbH" },
    { 23874, "ACLI Associazioni Cristiane dei Lavoratori Italiani" },
    { 23875, "Gymnasium M\0303\0274nchenstein" },
    { 23876, "PIXID SNC" },
    { 23877, "Grid Operation Center, Aristotle University of Thessaloniki," },
    { 23878, "Stanton Grove Ltd" },
    { 23879, "SAG Systemhaus GmbH AMS" },
    { 23880, "Motionpath Digital Media Ltd" },
    { 23881, "Avanton Inc." },
    { 23882, "Investidor Profissional Gest\0303\0243o de Recursos Ltda" },
    { 23883, "Fresenius Medical Care North America" },
    { 23884, "Fotofuxx" },
    { 23885, "Continental City Networks Ltd" },
    { 23886, "Hay Group, Inc." },
    { 23887, "Kawashima Labo Inc." },
    { 23888, "Tymar Systems Development" },
    { 23889, "Daco System Elaborazione Dati S.r.l." },
    { 23890, "HCL Peripherals" },
    { 23891, "ErgoGroup" },
    { 23892, "Milpower Source" },
    { 23893, "Klir Technologies, Inc." },
    { 23894, "Northshore School District" },
    { 23895, "EvilGenius Networks" },
    { 23896, "Netus Vaizovic k.d." },
    { 23897, "Trigger Software" },
    { 23898, "Tesseract Corporation" },
    { 23899, "SineRay Consulting Co.,Ltd" },
    { 23900, "Progetti Ambientali Integrati s.a.s." },
    { 23901, "Digigram" },
    { 23902, "ABB STOTZ-KONTAKT GmbH" },
    { 23903, "Cargol.net Solucions Lliures S.L.L." },
    { 23904, "The Nielsen Company (formerly 'Arbitron Inc.')" },
    { 23905, "VOCAL Technologies, Ltd." },
    { 23906, "Axalto Inc." },
    { 23907, "Advantage Security, S. de R.L. de C.V." },
    { 23908, "InfoEng Organization" },
    { 23909, "Bel Ami Reisen" },
    { 23910, "iPoint-media LTD." },
    { 23911, "Aurus" },
    { 23912, "Q-go" },
    { 23913, "Belle Bonfils Memorial Blood Center" },
    { 23914, "pedro armelim unipessoal lda." },
    { 23915, "SuperGeo Tech. Inc." },
    { 23916, "Appear TV AS" },
    { 23917, "Under Dusken" },
    { 23918, "JPBerlin" },
    { 23919, "Corporaci\0303\0263n Tedexis C.A." },
    { 23920, "Zoic Studios" },
    { 23921, "ISSP Internet-Solutions Szongott & Pertl OEG" },
    { 23922, "Milstein & Asoociates Inc." },
    { 23923, "Hobnob" },
    { 23924, "readshaw.com" },
    { 23925, "Cacti" },
    { 23926, "Golf-Leagues.com" },
    { 23927, "Ukrainian Catholic University" },
    { 23928, "MVV Energie AG" },
    { 23929, "entire technologies gmbh" },
    { 23930, "Inferno Enterprises" },
    { 23931, "Goodrich Corporation" },
    { 23932, "TLD Solutions Ltd" },
    { 23933, "CaveraSystems" },
    { 23934, "April Nine Inc." },
    { 23935, "Architects of VoIP GmbH" },
    { 23936, "china group zhejiang telecom corporation" },
    { 23937, "ExtricomLtd" },
    { 23938, "ANEDER BT" },
    { 23939, "Avokia Inc." },
    { 23940, "Sysco S.p.A." },
    { 23941, "Opentaskforce" },
    { 23942, "Intelligent Mobile Solutions, Inc." },
    { 23943, "Cendres & M\0303\0251taux SA" },
    { 23944, "DENIC eG" },
    { 23945, "Institute of Journalism, University Dortmund" },
    { 23946, "MINISTERO DELL'INTERNO - DIREZIONE CENTRALE POLIZIA CRIMINALE" },
    { 23947, "Innovene LLC" },
    { 23948, "Confernet Produtos e Servicos Ltd." },
    { 23949, "Swyx Solutions GmbH" },
    { 23950, "Print Associates A/S" },
    { 23951, "ExaProtect Technology" },
    { 23952, "TJ COLLECTION Co Ltd" },
    { 23953, "Australian Partnership for Advanced Computing" },
    { 23954, "TriNix AB" },
    { 23955, "PUCCAMP - Pontificia Universidade Cat\0303\0263lica de Campinas" },
    { 23956, "PCL Constructors Inc." },
    { 23957, "Spacelabs Medical Data" },
    { 23958, "310, JSC" },
    { 23959, "micneu" },
    { 23960, "Acquist Incorporated" },
    { 23961, "CertiMail" },
    { 23962, "Saisung Corporation Ltd." },
    { 23963, "Safe Host" },
    { 23964, "T-Mobile Austria" },
    { 23965, "Detecon International GmbH" },
    { 23966, "Leiner & Wolff GbR" },
    { 23967, "Tallence AG" },
    { 23968, "Netvoyager PLC" },
    { 23969, "arvato mobile" },
    { 23970, "Hamburg S\0303\0274damerikanische Dampfschifffahrts-Gesellschaft KG" },
    { 23971, "Menzebach und Wolff IT-Consulting GbR" },
    { 23972, "Fidelity MLS Systems and Solutions" },
    { 23973, "Still Tripping Productions." },
    { 23974, "General Dynamics Robotic Systems" },
    { 23975, "et al Innovations Ltd" },
    { 23976, "Zebanon Inc." },
    { 23977, "My Computer Person" },
    { 23978, "Sadel S.p.a." },
    { 23979, "Knoways s.r.l." },
    { 23980, "STS GmbH & Co. OHG" },
    { 23981, "MWS" },
    { 23982, "tty1.net" },
    { 23983, "Hampshire Constabulary" },
    { 23984, "RyCo Electronic Systems Limited" },
    { 23985, "S.O.Ge.S.A. s.a.s. di Ugo Grassi & C." },
    { 23986, "ENENSYS Technologies SAS" },
    { 23987, "Autoridad Portuaria de Barcelona" },
    { 23988, "Elink GmbH" },
    { 23989, "Cablefree Solutions Limited" },
    { 23990, "Shifa International Hospitals" },
    { 23991, "Planeetta Internet Oy" },
    { 23992, "Social Science Computing Cooperative" },
    { 23993, "Linear Technology Corporation" },
    { 23994, "OpenDarwin Project" },
    { 23995, "Eightball Productions" },
    { 23996, "Fuego Inc." },
    { 23997, "Florida Department of State" },
    { 23998, "RUF Telematik AG" },
    { 23999, "FTI Consulting, Inc" },
    { 24000, "ABN AMRO Bank Services" },
    { 24001, "Fiege Logistik (Schweiz)  AG" },
    { 24002, "Ingenieria Diez Cisneros, S.A." },
    { 24003, "Cellcom" },
    { 24004, "Onus Petro Services" },
    { 24005, "Alexa Internet, Inc." },
    { 24006, "Weidlinger Associates Inc." },
    { 24007, "Globat.com" },
    { 24008, "Great Bay Software" },
    { 24009, "NextHop Technologies, Inc." },
    { 24010, "ELESIGN" },
    { 24011, "Newtech.Co.,Ltd." },
    { 24012, "eASPNet Taiwan Inc." },
    { 24013, "RTX Telecom A/S" },
    { 24014, "Landesversicherungsanstalt Rheinprovinz" },
    { 24015, "CODAFIX SYSTEM" },
    { 24016, "Bionix AB" },
    { 24017, "teegee" },
    { 24018, "Frederikshavn Gymnasium og HF-kursus" },
    { 24019, "CertiPath, LLC" },
    { 24020, "Metagistics" },
    { 24021, "13 Spiders Ltd" },
    { 24022, "Optelian Access Networks  Corp." },
    { 24023, "IEA Software, Inc." },
    { 24024, "Tecsidel, S.A." },
    { 24025, "MVP Software, Inc." },
    { 24026, "Cube Route" },
    { 24027, "Dexa Medica Group" },
    { 24028, "Bayerwald Fenster Haustueren GmbH & Co. KG" },
    { 24029, "HEYFRA electronic GmbH" },
    { 24030, "CenterTools Software GmbH" },
    { 24031, "Nomus Comm-Systems" },
    { 24032, "dmstools AG" },
    { 24033, "Peerex Ltd" },
    { 24034, "The Royal Botanic Gardens, Kew" },
    { 24035, "AFIP" },
    { 24036, "howard.org" },
    { 24037, "Revolt Ltd." },
    { 24038, "VistaPrint USA Inc." },
    { 24039, "Lutz Badenheuer" },
    { 24040, "BARREL Investment Company Ltd." },
    { 24041, "M7 Software BV" },
    { 24042, "AMS 1769 Ltd" },
    { 24043, "Tanel Unt" },
    { 24044, "Cthulhu Inc." },
    { 24045, "Dwerryhouse IT Consulting" },
    { 24046, "TMSw Corp." },
    { 24047, "Netfabric Corporation" },
    { 24048, "United Devices" },
    { 24049, "eApps" },
    { 24050, "Orion Systems International" },
    { 24051, "Seneca Software & Solar, Inc." },
    { 24052, "Wedo Consulting" },
    { 24053, "Xspedius Communications" },
    { 24054, "NextNine Ltd." },
    { 24055, "Govolution, Inc." },
    { 24056, "JDI ICT" },
    { 24057, "Robert D. Allen" },
    { 24058, "AltCall Pty Ltd" },
    { 24059, "Zuzax LLC" },
    { 24060, "icube" },
    { 24061, "Amtium Computer Network Communiction  Tech. CO,LTD\0302\0243\0302\0273" },
    { 24062, "Korenix Technology Co., Ltd." },
    { 24063, "Call Direct Cellular Solutions Pty. Ltd" },
    { 24064, "Florian Hagedorn IT-Services" },
    { 24065, "TelcoSI" },
    { 24066, "Beijing WaterTek Information Technology Co.,Ltd." },
    { 24067, "Webraska do Brasil" },
    { 24068, "Tier-3 Pty Ltd." },
    { 24069, "IP Systems Pty Ltd" },
    { 24070, "AMANO Corporation" },
    { 24071, "Zenitel Radioteknik" },
    { 24072, "Code Mercenaries Hard- und Software GmbH" },
    { 24073, "Abeo AS" },
    { 24074, "ASI Controls" },
    { 24075, "ELIA  N.V. / S.A." },
    { 24076, "National Institute for Public Health and the Environment" },
    { 24077, "Zeus Gesellschaft fuer Integration und Kommunikation GmbH" },
    { 24078, "ISVA-Project Team (EADS-ISR, FHG-IITB, FGAN-FOM, FGAN-FKIE)" },
    { 24079, "Cacanska banka a.d. Cacak" },
    { 24080, "key-stone BV" },
    { 24081, "Paxfire Inc" },
    { 24082, "GTL Limited" },
    { 24083, "Securitect" },
    { 24084, "Managed Network Solutions, Inc." },
    { 24085, "Fitre S.p.A." },
    { 24086, "Medizinische Hochschule Hannover" },
    { 24087, "International Grid Trust Federation" },
    { 24088, "Diamelle inc" },
    { 24089, "Lexbox" },
    { 24090, "Central Library, Aristotle University of Thessaloniki" },
    { 24091, "SEW-EURODRIVE GmbH & Co KG" },
    { 24092, "I-Way Computers bvba" },
    { 24093, "JSC Format Link" },
    { 24094, "UniBwM" },
    { 24095, "MioSoft Corporation" },
    { 24096, "University of Douala" },
    { 24097, "Thoralf Linss" },
    { 24098, "Southwest Youth Collaborative" },
    { 24099, "Hosanna Christian Academy" },
    { 24100, "LogiSoft AR Ltd, Inc." },
    { 24101, "Banyan Tree Hotels & Resorts Pte Ltd" },
    { 24102, "Aeris Enterprises Inc." },
    { 24103, "DIR Wieslawa Rozynek" },
    { 24104, "Lennar Corporation" },
    { 24105, "di-Cross" },
    { 24106, "Damovo do Brasil S/A" },
    { 24107, "xkoto Inc." },
    { 24108, "UAB \"Eltera\"" },
    { 24109, "AtcaNet" },
    { 24110, "Vigilix. LLC" },
    { 24111, "Optivus Technology, Inc." },
    { 24112, "Shorter College" },
    { 24113, "Netzbiotop Dresden e.V." },
    { 24114, "City of Tulsa" },
    { 24115, "Ginix" },
    { 24116, "68k.se" },
    { 24117, "Idera" },
    { 24118, "artemis-design GbR" },
    { 24119, "eSimone" },
    { 24120, "JSDAAV INTERNET SOLUTIONS CC" },
    { 24121, "Centro Nacional de Infromaci\0303\0263n y Comunicaci\0303\0263n Educativa" },
    { 24122, "Brodersen Controls A/S" },
    { 24123, "Sparkasse Haslach-Zell" },
    { 24124, "Aqon Ltd." },
    { 24125, "OceanLake Asia Pte Ltd." },
    { 24126, "Junxion, Inc." },
    { 24127, "UUHosting.Net" },
    { 24128, "Casino Arizona" },
    { 24129, "International Road Dynamics Inc." },
    { 24130, "Oneformatics" },
    { 24131, "thePlatform for Media, Inc" },
    { 24132, "zyp.org" },
    { 24133, "Calassa Labs Ltd" },
    { 24134, "Torex Retail Solutions GmbH" },
    { 24135, "Smartcom-Bulgaria AD" },
    { 24136, "Schur Pack Danmark a/s" },
    { 24137, "Optimum Computing Solutions" },
    { 24138, "JSC TaxNet" },
    { 24139, "RFK International" },
    { 24140, "VoiceObjects AG" },
    { 24141, "T-2, d.o.o." },
    { 24142, "Bunya Technology Pty Ltd" },
    { 24143, "MallNet Ltd." },
    { 24144, "Mobillion BV" },
    { 24145, "ECS GmbH" },
    { 24146, "Zone Systems" },
    { 24147, "Ex Libris Ltd." },
    { 24148, "DATALAB DO BRASIL LTDA" },
    { 24149, "Milestone Systems A/S" },
    { 24150, "TIM BRASIL" },
    { 24151, "Inforsis Informatica y Formacion, SL" },
    { 24152, "OTA Management LLC" },
    { 24153, "Defense Finance and Accounting Service" },
    { 24154, "Moog Components Group" },
    { 24155, "Mission Hopitals" },
    { 24156, "Intelliant" },
    { 24157, "Spectrum Signal Processing, Inc." },
    { 24158, "Landstar System Holdings, Inc." },
    { 24159, "Neureol Technologies Private Limited" },
    { 24160, "Cool IP" },
    { 24161, "MLL Telecom Limited" },
    { 24162, "CareWorks vof" },
    { 24163, "SUPERMEDIA Internet Provider" },
    { 24164, "KBOSS.hu Kft." },
    { 24165, "Digi-Sign Limited" },
    { 24166, "Centro de Estudos e Sistemas Avan\0303\0247ados do Recife" },
    { 24167, "WEYCO, INC" },
    { 24168, "GMAC" },
    { 24169, "Sunsetbrew Inc." },
    { 24170, "Motricity, Inc." },
    { 24171, "8e6 Technologies" },
    { 24172, "Tenaska Power Services, Co" },
    { 24173, "Rho, Inc." },
    { 24174, "Institutional Shareholder Services, Inc." },
    { 24175, "SILVER SERVER GmbH" },
    { 24176, "Comgate Engineering Ltd." },
    { 24177, "Tivit S.A." },
    { 24178, "Stillwater Medical Center Authority" },
    { 24179, "Ministerie van Binnenlandse Zaken en Koninkrijksrelaties" },
    { 24180, "Tgusta.com C.A" },
    { 24181, "Fri-Jado B.V." },
    { 24182, "SRH" },
    { 24183, "Vimio PLC" },
    { 24184, "MEDNET Service f\0303\0274r \0303\0204rzte AG" },
    { 24185, "Kvalix Automatika Kft." },
    { 24186, "Netsol Network Solutions Oy" },
    { 24187, "LambdaStream" },
    { 24188, "Mail Object" },
    { 24189, "Cain Computing" },
    { 24190, "Distributed Systems Services, Inc." },
    { 24191, "Digital Fugue" },
    { 24192, "trial-n-error" },
    { 24193, "Strandbygaard" },
    { 24194, "Mary Kay Inc." },
    { 24195, "i5k.net" },
    { 24196, "OSEB NV" },
    { 24197, "Colliers Turley Martin Tucker" },
    { 24198, "Netcordia, Inc." },
    { 24199, "Primagraphics Ltd" },
    { 24200, "Quality Software Solutions Ltd." },
    { 24201, "Adrenio GmbH" },
    { 24202, "MIKRONIKA" },
    { 24203, "Wellington Technology, Inc." },
    { 24204, "Randolph Products Company" },
    { 24205, "JUPITER TECHNOLOGY(WUXI)CO.,LTD" },
    { 24206, "EGROUP Services Ltd." },
    { 24207, "Deimos-Space S.L." },
    { 24208, "Cystelcom Sistemas S.A." },
    { 24209, "MWare CZ, s.r.o." },
    { 24210, "ComWorth Co.,Ltd." },
    { 24211, "Solent Technology Ltd." },
    { 24212, "Conexim Australia Pty Ltd" },
    { 24213, "Oxford Health Plans, Llc. (subsidiary of UnitedHealth Group)" },
    { 24214, "Mount Holyoke College Computer Science Department" },
    { 24215, "Reed Technology and Information Services, Inc." },
    { 24216, "uptime software inc." },
    { 24217, "j-buzz, LLC" },
    { 24218, "Metaweb Technologies, Inc." },
    { 24219, "nuBridges, LLC" },
    { 24220, "Marcelo Rinesi" },
    { 24221, "Donorware LLC" },
    { 24222, "Resolute Networks Ltd." },
    { 24223, "Fabryka Stron Internetowych Sp. z o.o." },
    { 24224, "Southern Regional Education Board" },
    { 24225, "Formula Telecom Solutions" },
    { 24226, "Braxcomm Eletr\0303\0264nica Ltda." },
    { 24227, "Negeso Ukraine Ltd" },
    { 24228, "HOT Technology" },
    { 24229, "arvato technology GmbH" },
    { 24230, "Verint Systems Canada Inc." },
    { 24231, "GUFI - Gruppo Utenti FreeBSD Italia" },
    { 24232, "6th Sense Software, Inc." },
    { 24233, "Ikatu" },
    { 24234, "VuCOMP" },
    { 24235, "Hannum Computer Service" },
    { 24236, "NStudioCorp" },
    { 24237, "ResourceChain Inc." },
    { 24238, "PACLABS Technology and Innovation, Inc." },
    { 24239, "V-shine Co., Ltd" },
    { 24240, "TongSoft Tech." },
    { 24241, "Accucast, Inc." },
    { 24242, "SimWorks International Limited" },
    { 24243, "Amrita Institute of Medical Sciences" },
    { 24244, "IntroMobile CO., Ltd" },
    { 24245, "OSS Corporaton" },
    { 24246, "MGP \"Mosvodokanal\"" },
    { 24247, "Bettge" },
    { 24248, "Stockway Oy" },
    { 24249, "Clinique Saint-Luc (Bouge)" },
    { 24250, "MATRICE SYSTEM S.A.S." },
    { 24251, "Banca24-7 S.p.A." },
    { 24252, "ESG GmbH" },
    { 24253, "Systems Trust Co., Ltd." },
    { 24254, "C4 Solutions Oy" },
    { 24255, "Outpost24 AB" },
    { 24256, "Deutsche WertpapierService Bank AG" },
    { 24257, "Idtect" },
    { 24258, "Ministry of the Flemish Community" },
    { 24259, "Achilles Information Limited" },
    { 24260, "VIELAGE" },
    { 24261, "Mobeon AB" },
    { 24262, "TEAM S.A" },
    { 24263, "up to data professional services GmbH" },
    { 24264, "Neusta GmbH" },
    { 24265, "The British Museum" },
    { 24266, "Infoscope Kft." },
    { 24267, "Directory Enabled Solutions" },
    { 24268, "Opendium Ltd" },
    { 24269, "CR2 LTD" },
    { 24270, "S3 Srl Servizi Soluzioni Sistemi" },
    { 24271, "Nessus Internet Services Florian Schicker" },
    { 24272, "Universit\0303\0240 della Svizzera italiana" },
    { 24273, "nihilistic.org.uk" },
    { 24274, "Beyond Security Inc." },
    { 24275, "IUT Verdun" },
    { 24276, "Universidad de Oriente" },
    { 24277, "Tiaxa do Brasil Ltda." },
    { 24278, "Universit\0303\0240 Campus Bio-Medico" },
    { 24279, "LDAP Administration Console (opensource project)" },
    { 24280, "HdL Coren & Cone" },
    { 24281, "Family Health International" },
    { 24282, "StackFrame, LLC" },
    { 24283, "dns Ltd" },
    { 24284, "wesde" },
    { 24285, "Novax Industries Corporation" },
    { 24286, "HumanConcepts" },
    { 24287, "Telex Communication Inc." },
    { 24288, "BHMS Webhosting" },
    { 24289, "HotFeet GmbH" },
    { 24290, "Datorf\0303\0266reningen vid LU & LTH" },
    { 24291, "E-Planit Systems, Inc." },
    { 24292, "BRAKKE SCHAFNITZ INS BROKERS INC" },
    { 24293, "Toyota New Zealand Ltd" },
    { 24294, "Air Broadband Communications" },
    { 24295, "Pickwick Consulting" },
    { 24296, "DENSO WAVE INCORPORATED" },
    { 24297, "Sonic Solutions" },
    { 24298, "Freudenberg Dichtungs- & Schwingungstechnik GmbH & CoKG" },
    { 24299, "go4teams GmbH" },
    { 24300, "Wotif" },
    { 24301, "stj company" },
    { 24302, "Network constructor, Core Constructor , Kun Shan University" },
    { 24303, "Pegacat Pty Ltd" },
    { 24304, "ArgusConnect Pty LTD" },
    { 24305, "INBOS Pty LTD" },
    { 24306, "3 Vias Technologies" },
    { 24307, "Activesec S.A." },
    { 24308, "Media & Telecom  Ventures" },
    { 24309, "Terrascale Technologies Inc." },
    { 24310, "Medical Information Technology, Inc." },
    { 24311, "SunHELP" },
    { 24312, "Identity Automation, LP" },
    { 24313, "TiendaLinux.com" },
    { 24314, "What Creek" },
    { 24315, "Fatih University" },
    { 24316, "IT bridge.net s.r.o." },
    { 24317, "torrini.org" },
    { 24318, "InTouch B.V." },
    { 24319, "VOCONS IT Consulting GmbH" },
    { 24320, "ELCOM GROUP" },
    { 24321, "NetMagic Ltd." },
    { 24322, "Petastor, Inc." },
    { 24323, "Deephaven Ltd" },
    { 24324, "Electric-Tronics Incorporated" },
    { 24325, "OGL Computer Services Group Ltd" },
    { 24326, "Exsys" },
    { 24327, "Estacha Proyectos y Servicios" },
    { 24328, "Spirit AeroSystems, Inc." },
    { 24329, "Lixil" },
    { 24330, "In Reach Technology" },
    { 24331, "Evolix" },
    { 24332, "Hardware Online AS" },
    { 24333, "FH Ingolstadt" },
    { 24334, "EADS DS UK Ltd" },
    { 24335, "Storewiz Inc." },
    { 24336, "ATM Express, Inc." },
    { 24337, "Monster Cable Products Inc." },
    { 24338, "Situs Management Inc." },
    { 24339, "ADLINK TECHNOLOGY INC." },
    { 24340, "Macalester College" },
    { 24341, "Pontis Inc." },
    { 24342, "FIO Labs, LLC" },
    { 24343, "Rokonet Electronics LTD." },
    { 24344, "eSPECTRUM Internet-Solution GmbH" },
    { 24345, "Xsite GmbH" },
    { 24346, "Adaway Consulting" },
    { 24347, "Magicpot Inc." },
    { 24348, "GPTech GmbH" },
    { 24349, "Frank Agerholm" },
    { 24350, "Sensoria Corporation" },
    { 24351, "Linux Network Care Inc" },
    { 24352, "Alpha Centauri Software Limited" },
    { 24353, "Media Technology Systems Inc." },
    { 24354, "secscend LLC" },
    { 24355, "Lemon I.T. Co., Ltd." },
    { 24356, "Solinus, Inc." },
    { 24357, "CD-Telematika a. s." },
    { 24358, "Nomics" },
    { 24359, "Deutsche Rentenversicherung Mitteldeutschland" },
    { 24360, "Transmitton Ltd" },
    { 24361, "InnovaSON" },
    { 24362, "Duquesne University" },
    { 24363, "Super Star enterprises" },
    { 24364, "ON Semiconductor" },
    { 24365, "Constellation Energy" },
    { 24366, "gui.org" },
    { 24367, "Somerdata Ltd" },
    { 24368, "Paat Software" },
    { 24369, "Medem, Inc." },
    { 24370, "Chang Cheng Information consultant Co., LTD" },
    { 24371, "London Business School" },
    { 24372, "Exiis Corporation" },
    { 24373, "information unlimited" },
    { 24374, "Life Sciences Collaborative Access Team" },
    { 24375, "Aleksandar Milivojevic" },
    { 24376, "Landeshauptstadt Muenchen" },
    { 24377, "Nassauische Sparkasse" },
    { 24378, "Kizoom Ltd" },
    { 24379, "Tracewell Power" },
    { 24380, "certegy" },
    { 24381, "Joachim Uhr" },
    { 24382, "CH2M HILL, Ltd." },
    { 24383, "Orange Cable Corporation" },
    { 24384, "Caerus, Inc." },
    { 24385, "CryptGuard" },
    { 24386, "STM Networks, Inc" },
    { 24387, "Software-Engineering Fabiani" },
    { 24388, "Washington State Bar Association" },
    { 24389, "Suzhou Keda Technology Company, Ltd." },
    { 24390, "IRI Communications, Inc." },
    { 24391, "DoremiLabs, inc." },
    { 24392, "Flexagonal Systems Ltd" },
    { 24393, "Office National des Forets" },
    { 24394, "Concurrent Technologies Plc." },
    { 24395, "Datamat S.p.a." },
    { 24396, "Xinjiang Sailing Information Technology Co., Ltd" },
    { 24397, "Libertas Solucoes em T.I. LTDA" },
    { 24398, "Espirito Santo Centrais Eletricas S.A" },
    { 24399, "Telsource Corporation" },
    { 24400, "TNS Business Solutions S.A." },
    { 24401, "Kanton Basel-Stadt" },
    { 24402, "Omgeo LLC" },
    { 24403, "Ministerio da Cultura" },
    { 24404, "DroidOS Project" },
    { 24405, "TC Software, Inc" },
    { 24406, "Dynamic Biometrics Ltd." },
    { 24407, "OnAir USA, Inc." },
    { 24408, "Video Technics Inc." },
    { 24409, "Rising System Inc." },
    { 24410, "WHEEL Sp. z o.o." },
    { 24411, "Multi Service Forum" },
    { 24412, "Bundesamt f\0303\0274r Verbraucherschutz und Lebensmittelsicherheit" },
    { 24413, "University of Cambridge, Department of Archaeology" },
    { 24414, "CORE CORPORATION" },
    { 24415, "Unimatrix-One" },
    { 24416, "NC Interactive" },
    { 24417, "Infoweapons Corporation" },
    { 24418, "Infinico Corporation" },
    { 24419, "Red Crow Group LLC" },
    { 24420, "European Airlift Centre" },
    { 24421, "Roweb Development" },
    { 24422, "Information Management Services" },
    { 24423, "Xtek Computer" },
    { 24424, "IDSRDL" },
    { 24425, "Monksoft" },
    { 24426, "Metavize, Inc" },
    { 24427, "Coyote Point Systems, Inc" },
    { 24428, "Nusoft System Inc." },
    { 24429, "Mangold Elektronik" },
    { 24430, "Red Earth Systems AB" },
    { 24431, "ACCEL Instruments GmbH" },
    { 24432, "UIIP NASB" },
    { 24433, "Yunet International D.O.O." },
    { 24434, "Ohio Bureau of Workers' Compensation" },
    { 24435, "Ubitech Systems Inc" },
    { 24436, "Power Distribution, Inc." },
    { 24437, "Deightime, LLC" },
    { 24438, "OAO RoEduNet" },
    { 24439, "JBG/Development Group, L.L.C." },
    { 24440, "Xsigo Systems" },
    { 24441, "oddbit.com" },
    { 24442, "smartx GmbH" },
    { 24443, "Colby Sas" },
    { 24444, "UniBridge AS" },
    { 24445, "Carsten Heinrici" },
    { 24446, "TILIAR Services" },
    { 24447, "St Basil's Homes" },
    { 24448, "WEB.DE GmbH" },
    { 24449, "Ketsujin Studios" },
    { 24450, "AlphaGeek, Inc." },
    { 24451, "Transitional Data Services, Inc." },
    { 24452, "AXI" },
    { 24453, "Bank Hapoalim ltd." },
    { 24454, "Schenker-Joyau" },
    { 24455, "Isotoma Limited" },
    { 24456, "CODA Plc" },
    { 24457, "BWMS Solu\0303\0247\0303\0265es M\0303\0263veis Ltda" },
    { 24458, "Wise Telecomunica\0303\0247\0303\0265es Ltda." },
    { 24459, "Saskatchewan Wheat Pool Inc." },
    { 24460, "Fortean Technologies, Inc." },
    { 24461, "Advanced Solutions International, Inc." },
    { 24462, "E-Sauce Limited" },
    { 24463, "Banco de Costa Rica" },
    { 24464, "First Citizens Bank" },
    { 24465, "BELNET" },
    { 24466, "move.L consulting" },
    { 24467, "walkgame" },
    { 24468, "LK PRODUKT CZ a.s." },
    { 24469, "University of Leeds" },
    { 24470, "Boston Maine Airways Corp." },
    { 24471, "Omniphasic Institute LLC" },
    { 24472, "University of Virginia's College at Wise" },
    { 24473, "NetMedia, Inc." },
    { 24474, "Jacobacci" },
    { 24475, "Optena Corporation" },
    { 24476, "Server-side Systems Ltd" },
    { 24477, "eenterphace" },
    { 24478, "megatrade corp." },
    { 24479, "E.ON Business Services Czech Republic s.r.o." },
    { 24480, "oncampusuk" },
    { 24481, "Warsaw Data Center Sp. z o.o." },
    { 24482, "Light Backup Services" },
    { 24483, "ISO New England Inc." },
    { 24484, "Advanced Broadcast Components Ltd." },
    { 24485, "webmasters akademie GmbH" },
    { 24486, "Micromedia International" },
    { 24487, "Bulletproof Solutions Inc" },
    { 24488, "United Solutions International" },
    { 24489, "brut" },
    { 24490, "The Phone House Telecom GmbH" },
    { 24491, "Asociaci\0303\0263n Centro de Cooperaci\0303\0263n Interbancaria" },
    { 24492, "Consorzio Torino Time" },
    { 24493, "Safend Ltd." },
    { 24494, "Extra Prof S.R.L." },
    { 24495, "comundus Unternehmensberatung GmbH" },
    { 24496, "Western Telematic Inc." },
    { 24497, "KMD.COM.TW" },
    { 24498, "Interprise (Pty) Ltd" },
    { 24499, "European Aviation Safety Agency" },
    { 24500, "MorkoM GmbH" },
    { 24501, "Green Hat Consulting Ltd." },
    { 24502, "Wandering Barque" },
    { 24503, "ICONICS, Inc." },
    { 24504, "CENTR\0303\0201L Mosod\0303\0241k Szolg\0303\0241ltat\0303\0263 R\0303\0251szv\0303\0251nyt\0303\0241rsas\0303\0241g" },
    { 24505, "Emerging Systems" },
    { 24506, "Osaki Electric co.,ltd." },
    { 24507, "Peadar Grant" },
    { 24508, "StagniNET" },
    { 24509, "Commonwealth of Massachusetts" },
    { 24510, "SHANGHAI SIMED TECH LTD." },
    { 24511, "FlowInspect SpA" },
    { 24512, "Beijing Hugeland Technologies co.,Ltd." },
    { 24513, "Finnish Game and Fisheries Research Institute" },
    { 24514, "Rivulet Communications, Inc." },
    { 24515, "ROC Software Systems, Inc." },
    { 24516, "Conair Corporation" },
    { 24517, "LTIA" },
    { 24518, "Great-West Life & Annuity Insurance Company" },
    { 24519, "Trustwave Holdings, Inc. (formerly 'XRamp Security Services Inc.')" },
    { 24520, "Tokash Consulting Inc." },
    { 24521, "SupplyFX, Inc" },
    { 24522, "PT. Excelcomindo Pratama, Tbk." },
    { 24523, "infeurope S.A." },
    { 24524, "RheinEnergie AG" },
    { 24525, "Twisted Pair Solutions, Inc." },
    { 24526, "St James the Great R.C Primary & Nursery School" },
    { 24527, "commax Co.,Ltd." },
    { 24528, "ProgramDuon AB" },
    { 24529, "Systembetreuung.com" },
    { 24530, "Universidade Federal do Amazonas" },
    { 24531, "Metis Communication Co., Ltd" },
    { 24532, "Intelliguard I.T." },
    { 24533, "Akvi-Patent Co." },
    { 24534, "Gordano Ltd" },
    { 24535, "MD Systems" },
    { 24536, "DAS" },
    { 24537, "NNMI" },
    { 24538, "Morning" },
    { 24539, "IST Holdings (Pty) Ltd." },
    { 24540, "Betty TV Entwicklungs GmbH" },
    { 24541, "Beijing GrandRole Software Co.,Ltd." },
    { 24542, "Albert-Einstein-Gymnasium" },
    { 24543, "Black Eyed Moon" },
    { 24544, "JSC \"Eltel\"" },
    { 24545, "Ursus Technologies, Inc." },
    { 24546, "ServerCave, Inc." },
    { 24547, "Linux Users Group Singapore" },
    { 24548, "OutSys snc" },
    { 24549, "Triple-m Systems AG" },
    { 24550, "edoras GmbH & Co. KG" },
    { 24551, "CPU d.o.o." },
    { 24552, "Inverse Path Ltd." },
    { 24553, "Prompttec Product Management GmbH" },
    { 24554, "Church of the Nazarene" },
    { 24555, "RACKMASTER SYSTEMS INC." },
    { 24556, "Starwave Technologies,Inc." },
    { 24557, "Obcanske sdruzeni HKfree" },
    { 24558, "Arcade ICT BV" },
    { 24559, "Net Tecnologies" },
    { 24560, "inode GmbH" },
    { 24561, "Celletra Ltd." },
    { 24562, "Bridge Technologies Co AS" },
    { 24563, "Kerfi AB Avdelning Norge" },
    { 24564, "HOLON Corp." },
    { 24565, "Yuba Community College District" },
    { 24566, "koreanair" },
    { 24567, "YIT Corporation" },
    { 24568, "DawnSpill Ltd." },
    { 24569, "directnews AG" },
    { 24570, "OpenWired" },
    { 24571, "uniwan.be" },
    { 24572, "Totaltel Telecommunication Ltd." },
    { 24573, "Massachusetts Board of Library Commissioners" },
    { 24574, "Opsera Ltd." },
    { 24575, "Tranzeo Wireless Technologies Inc." },
    { 24576, "HL7 Lithuania" },
    { 24577, "Tosharecomu LLC" },
    { 24578, "IDSignet" },
    { 24579, "Australian Style Pty Ltd" },
    { 24580, "TietoEnator Broadcasting IT Oy" },
    { 24581, "Zemp Informatik" },
    { 24582, "credativ GmbH" },
    { 24583, "Guerrier" },
    { 24584, "Nagoya University" },
    { 24585, "Cassiano Morgado de Aquino - ME" },
    { 24586, "BA Systems" },
    { 24587, "Judson College" },
    { 24588, "Automatic IT Corporation" },
    { 24589, "Redoc Inc." },
    { 24590, "Bristol Technology Inc." },
    { 24591, "Marchex, Inc." },
    { 24592, "Brazos County, Texas" },
    { 24593, "Think Zone S.C." },
    { 24594, "MYOB Australia E1 Pty Ltd (formerly 'Ilisys Web Hosting Pty Ltd')" },
    { 24595, "safari video networks llc." },
    { 24596, "Ascent Technology, Inc." },
    { 24597, "NRW.BANK" },
    { 24598, "NC Cable Pty Ltd t/as Neighbourhood Cable" },
    { 24599, "Downey Savings and Loan Association, F.A." },
    { 24600, "EDI Branch,Shanghai Telecom Corporation Ltd." },
    { 24601, "Premicare AB" },
    { 24602, "Siemens Com EN PSY DB" },
    { 24603, "Peavey Electronics Corporation" },
    { 24604, "CosmosKey" },
    { 24605, "Owl Computing Technologies, Inc." },
    { 24606, "The People's Republic of Ames" },
    { 24607, "Drystone" },
    { 24608, "Centre hospitalier de Lagny Marne la vall\0303\0251e" },
    { 24609, "R. S. Software (India) Ltd." },
    { 24610, "gemeentebestuur sint-gillis-waas" },
    { 24611, "Baptist Memorial Health Care Corporation" },
    { 24612, "Fujitsu Hong Kong Ltd." },
    { 24613, "Kingston University" },
    { 24614, "Jakota Design Group GmbH" },
    { 24615, "b.comp GmbH" },
    { 24616, "CROSSPOiNT" },
    { 24617, "NMS Software, Inc." },
    { 24618, "BOXALINO AG" },
    { 24619, "MOSDAN Technology Co.,Ltd" },
    { 24620, "Tecnosis, S.A." },
    { 24621, "Tazz Networks Inc." },
    { 24622, "netCo GmbH Hamburg" },
    { 24623, "Samsung Thales Co., Ltd." },
    { 24624, "EuroCableLabs" },
    { 24625, "Luxcore Optronics, Inc." },
    { 24626, "Lime Brokerage LLC" },
    { 24627, "Vitas" },
    { 24628, "CXR Larus Corporation" },
    { 24629, "Telio AS" },
    { 24630, "Skinkers ltd" },
    { 24631, "mediaproxy pty ltd" },
    { 24632, "CorEdge Networks, Inc." },
    { 24633, "Toyo Radio Systems Co.,Ltd." },
    { 24634, "Ericpol Telecom sp. z o.o." },
    { 24635, "ALPS Electric Europa GmbH" },
    { 24636, "XPass Technologies Co., Ltd" },
    { 24637, "NETWAVE CO., LTD." },
    { 24638, "JotSpot Inc." },
    { 24639, "Elecom scsi" },
    { 24640, "Nova Technologies" },
    { 24641, "Allodial Solutions, Inc." },
    { 24642, "University of Sarajevo - Faculty of Electrical Engineering" },
    { 24643, "Cedval Info inc." },
    { 24644, "Applied Broadband, Inc." },
    { 24645, "e-DMZ Security, LLC." },
    { 24646, "Fonner" },
    { 24647, "\"NTC-Atlas\"" },
    { 24648, "SL EDV-Dienstleistungen" },
    { 24649, "MainSkill Technologies GmbH&Co.KG" },
    { 24650, "Control Systems srl" },
    { 24651, "RongJi Network Security Technology Co., Ltd" },
    { 24652, "Everbee Networks" },
    { 24653, "Studec" },
    { 24654, "NPO TrustGear" },
    { 24655, "Applied Broadband, Inc." },
    { 24656, "Pre-Emptive Limited" },
    { 24657, "TCSYS Limited" },
    { 24658, "intivo" },
    { 24659, "Caringo, Inc." },
    { 24660, "Rapid Mobile (Pty) Ltd" },
    { 24661, "WM-data Infra Solutions AB" },
    { 24662, "Digital Instruments S.r.l." },
    { 24663, "Norventure Ltda." },
    { 24664, "Delaware Technical and Community College" },
    { 24665, "BytePark" },
    { 24666, "Camelcom" },
    { 24667, "Atlanta Technical Consultants, LLC" },
    { 24668, "Quay Security Ltd." },
    { 24669, "Beijing Mobile Interactive Co. LTD." },
    { 24670, "Gemini Observatory" },
    { 24671, "Vienna University" },
    { 24672, "Watkins MFG Inc." },
    { 24673, "ServerEngines LLC" },
    { 24674, "Linzer Technikum - LITEC" },
    { 24675, "Nordh Sistemas de Controle Ltda" },
    { 24676, "Applied Voice & Speech Technologies, Inc." },
    { 24677, "NexGen Communications, LLC." },
    { 24678, "Oklahoma City University" },
    { 24679, "China Sports Lottery Printing(Beijing) Co. Ltd." },
    { 24680, "Bradmark Technologies, Inc." },
    { 24681, "QNAP SYSTEMS, INC" },
    { 24682, "SAT" },
    { 24683, "Hutchison 3G Austria GmbH" },
    { 24684, "Helsinki Business Polytechnic" },
    { 24685, "Omada A/S" },
    { 24686, "PROFIBUS Nutzerorganisation e.V." },
    { 24687, "Integrated Broadband Services, LLC" },
    { 24688, "C. & H. Euser Transport B.V." },
    { 24689, "WAR Ink" },
    { 24690, "Japan Communication Equipment Co.,Ltd." },
    { 24691, "Beijing GoodMedia Co. LTD." },
    { 24692, "Ask Jeeves (Hangzhou) Limited" },
    { 24693, "Firebrick Ltd." },
    { 24694, "Technische Universiteit Eindhoven" },
    { 24695, "Prodemge - Companhia de Tecnologia da Informa\0303\0247\0303\0243o do Estado de" },
    { 24696, "Falkin Systems LLC" },
    { 24697, "Canal de Isabel II" },
    { 24698, "WH Trading, LLC" },
    { 24699, "AGB Nielsen Media Research" },
    { 24700, "Prolon Control Systems" },
    { 24701, "Spitzenverb\0303\0244nde der landwirtschaftlichen Sozialversicherung" },
    { 24702, "CLS Services Ltd" },
    { 24703, "Sven Meyer IT-Services" },
    { 24704, "Informatikzentrum Landesverwaltung Baden-W\0303\0274rttemberg" },
    { 24705, "Clal Insurance Ltd" },
    { 24706, "RW Consulting" },
    { 24707, "Computation Systemhaus GmbH" },
    { 24708, "University of PISA" },
    { 24709, "North York General Hospital" },
    { 24710, "OPSOFT s.r.o." },
    { 24711, "MLK - ST informatique" },
    { 24712, "Waterstone Environmental Hydrology and Engineering, Inc." },
    { 24713, "Grammofonartistenes forening" },
    { 24714, "Intesis Software S.L." },
    { 24715, "Beijing Langhua Ltd." },
    { 24716, "Start Stelcom Ltd Corp" },
    { 24717, "Berg-BSP" },
    { 24718, "Pierre Bruy\0303\0250re" },
    { 24719, "Cyberview Technology Ltd" },
    { 24720, "Thales Training & Simulation Ltd" },
    { 24721, "Svisj" },
    { 24722, "Kef Solutions Inc." },
    { 24723, "SOS GmbH" },
    { 24724, "Aluria Software" },
    { 24725, "Australian Technology Information Pty Ltd" },
    { 24726, "USHER" },
    { 24727, "CleanOffer, Inc." },
    { 24728, "pythea" },
    { 24729, "AutoGas Systems, Inc." },
    { 24730, "Audible Magic Corp." },
    { 24731, "Beijing Kexin Technology Co. Ltd" },
    { 24732, "Universit\0303\0244t Bayreuth - RZ" },
    { 24733, "Summit Computer Systems, Inc." },
    { 24734, "cintech" },
    { 24735, "Gunnebo AB" },
    { 24736, "Narcommunications" },
    { 24737, "ION R-D Elektronika Bt." },
    { 24738, "Cablecom GmbH" },
    { 24739, "Slaski Urzad Wojewodzki" },
    { 24740, "ARFWorks" },
    { 24741, "MDT Inc." },
    { 24742, "Danish Ministry of the Environment" },
    { 24743, "Memorex Telex Japan Ltd." },
    { 24744, "a2 system" },
    { 24745, "TVWorks" },
    { 24746, "Oberto Sausage Company" },
    { 24747, "Capella Education Company" },
    { 24748, "TPSA LTD." },
    { 24749, "Scrutable Systems, Inc." },
    { 24750, "Unassigned" },
    { 24751, "Cluster-Works GbR" },
    { 24752, "SyncIO oHG" },
    { 24753, "SSC Publications Inc." },
    { 24754, "SIRCA Ltd" },
    { 24755, "Satellite Music Australia Pty Limited" },
    { 24756, "PARTAD" },
    { 24757, "WiMAX Forum" },
    { 24758, "Brightwire Media" },
    { 24759, "Panacya Inc" },
    { 24760, "ILS Technology LLC" },
    { 24761, "Euro/IP B.V." },
    { 24762, "Smart and Final Stores Corporation" },
    { 24763, "rrothos.com" },
    { 24764, "IRIS Corp Bhd" },
    { 24765, "Aylus Networks, Inc." },
    { 24766, "Spiceberry" },
    { 24767, "NOX SYSTEMS AG" },
    { 24768, "Pott & K\0303\0266rner" },
    { 24769, "Acronis, Inc." },
    { 24770, "IZALL.COM Ltd." },
    { 24771, "Intercooperation" },
    { 24772, "SolidX AB" },
    { 24773, "SG GENIKI BANK S.A." },
    { 24774, "World Health Organization" },
    { 24775, "Aviareto Limited" },
    { 24776, "Brasil Telecom S/A" },
    { 24777, "Ingenious Corporation Ltd." },
    { 24778, "TenXc Wireless Inc." },
    { 24779, "SeaNet Technologies, Inc." },
    { 24780, "SBIN Systems" },
    { 24781, "A.F.P.B.T.P. du Calvados" },
    { 24782, "TetraNed" },
    { 24783, "Wola Info S.A." },
    { 24784, "Logintas AG" },
    { 24785, "Luganda Group, Inc" },
    { 24786, "AsteriskAD.com" },
    { 24787, "TU Dresden, Chair of Road Design" },
    { 24788, "Itilon Pty Ltd" },
    { 24789, "Teletech d.o.o." },
    { 24790, "Handmade Mobile Entertainment" },
    { 24791, "InZon Corp" },
    { 24792, "Red Oxygen Pty Ltd" },
    { 24793, "GSTeletech Co.,Ltd." },
    { 24794, "Federated Department Stores" },
    { 24795, "blue elephant systems GmbH" },
    { 24796, "Bundes\0303\0244rztekammer" },
    { 24797, "IMSEC GmbH" },
    { 24798, "data-complex gmbh" },
    { 24799, "App-Line" },
    { 24800, "Apogee Network Systems & Consulting, LLC" },
    { 24801, "MTI co. LTD" },
    { 24802, "Saratoga Systems, Inc" },
    { 24803, "nu.org" },
    { 24804, "Akorri Networks, Inc." },
    { 24805, "Bankoa Credit Agricole" },
    { 24806, "Tern Systems Inc." },
    { 24807, "RISO KAGAKU CORPORATION" },
    { 24808, "EODP Section ( For Testing Only)" },
    { 24809, "Manic Productions" },
    { 24810, "Innerspace Ltd." },
    { 24811, "Robatech AG" },
    { 24812, "tribaldi GmbH" },
    { 24813, "chellomedia services Ltd" },
    { 24814, "Yinhoo Software Inc." },
    { 24815, "Golzari IT-Consultancy" },
    { 24816, "Asoka USA Corporation" },
    { 24817, "TuVox Inc" },
    { 24818, "Micro Industries Inc." },
    { 24819, "CARDIONICS SA" },
    { 24820, "Oskarshamns Konverterings AB" },
    { 24821, "TELEFUNKEN Radio Communication Systems GmbH & Co. KG" },
    { 24822, "Instituto Nacional de Estadistica" },
    { 24823, "Amey Datel" },
    { 24824, "NightStorm Software Systems, Inc." },
    { 24825, "Creighton University" },
    { 24826, "Weyerhaeuser" },
    { 24827, "Bieles Stano" },
    { 24828, "Speedway Internet Service SC LTDA" },
    { 24829, "Estacado Systems, LLC" },
    { 24830, "THOTT Solutions" },
    { 24831, "Sirit Technologies Inc." },
    { 24832, "Mi5 Inc." },
    { 24833, "Eliteitminds Technologies Inc." },
    { 24834, "KAT Project" },
    { 24835, "University of Ostrava" },
    { 24836, "Johannes Kapune GbR" },
    { 24837, "Sobha Renaissance Information Technology Private Limited" },
    { 24838, "Danbury Health Systems" },
    { 24839, "Universidade Federal Fluminense" },
    { 24840, "David Ross" },
    { 24841, "Red [E] Entertainment Group" },
    { 24842, "Gravitime" },
    { 24843, "Halier" },
    { 24844, "Petroleum Convenience Alliance for Technology Standards, Inc." },
    { 24845, "JSC institute \"Promstrojniiproject\"" },
    { 24846, "Scivo Technology Co. Ltd." },
    { 24847, "International Criminal Court - Cour Penale Internationale" },
    { 24848, "bollcons" },
    { 24849, "ELITNET, Ltd." },
    { 24850, "Mercantile Network Brasil, Ltda." },
    { 24851, "Hillsborough Community College" },
    { 24852, "Phihong USA" },
    { 24853, "Komerccentrs DATI grupa" },
    { 24854, "Pacific Star Communications" },
    { 24855, "Sensonxi Inc." },
    { 24856, "MDS Pharma Services" },
    { 24857, "VECTORsgi" },
    { 24858, "Vendetta Performance Limited" },
    { 24859, "Shanghai PONX technology com.,Ltd." },
    { 24860, "tosker.net" },
    { 24861, "StudyStack" },
    { 24862, "Qualimedic.com AG" },
    { 24863, "MTI Technology GmbH" },
    { 24864, "Link GmbH" },
    { 24865, "Cramer Systems Ltd" },
    { 24866, "Hans Turck GmbH & Co. KG" },
    { 24867, "Goldsmiths College, University of London" },
    { 24868, "Technoface Corporation" },
    { 24869, "KLab Inc." },
    { 24870, "ZE PAK SA" },
    { 24871, "Webroot Software, Inc." },
    { 24872, "H-D-H" },
    { 24873, "Procesamiento Digital y Sistemas, S.L." },
    { 24874, "GO Networks, Inc." },
    { 24875, "Andxor Soluzioni Informatiche S.r.l." },
    { 24876, "Atlas Advanced Internet Solutions Ltd." },
    { 24877, "Informatica y Comunicaciones Avanzadas, S.L." },
    { 24878, "Mercurio Comunicaciones" },
    { 24879, "Gi Gesundheitsinformatik GmbH" },
    { 24880, "DIRECCION DE IMPUESTOS Y ADUANAS NACIONALES" },
    { 24881, "CERIST" },
    { 24882, "Alcatel Japan Ltd." },
    { 24883, "Vertigo Media, LLC" },
    { 24884, "Toneware Technology co. Ltd." },
    { 24885, "Banca Intesa AD Beograd" },
    { 24886, "Eigil Bj\0303\0270rgum" },
    { 24887, "Parlamento de Galicia" },
    { 24888, "Malden Electronics Ltd." },
    { 24889, "IB Technologies Sdn. Bhd." },
    { 24890, "Extant Solutions" },
    { 24891, "Instituto Tecnol\0303\0263gico y de Estudios Superiores de Occidente A.C." },
    { 24892, "Great Atlantic and Pacific Tea Company, Inc." },
    { 24893, "GE Intelligent Platforms, Inc." },
    { 24894, "PantheraNet" },
    { 24895, "Medifacts International Inc." },
    { 24896, "Microdental Laboratories" },
    { 24897, "Indel Industria Eletronica Ltda" },
    { 24898, "d&b audiotechnik GmbH" },
    { 24899, "Agama Technologies AB" },
    { 24900, "Aurora Networks (GoBackTV)" },
    { 24901, "Future Infonet" },
    { 24902, "Astech Corporation" },
    { 24903, "Corporaci\0303\0263n Polit\0303\0251cnica Nacional de Colombia" },
    { 24904, "Skyrecon Systems SA" },
    { 24905, "Nextsense Ltd" },
    { 24906, "Electronic Solutions Ltd." },
    { 24907, "Infopact Netwerkdiensten B.V." },
    { 24908, "Stored IQ, Inc." },
    { 24909, "Secure-24, LLC" },
    { 24910, "OOO \"ElitStudio\"" },
    { 24911, "Foxbyte Ltd" },
    { 24912, "ASELSAN INC." },
    { 24913, "Cook Group Incorporated" },
    { 24914, "WSOFT, Lda." },
    { 24915, "iG Internet Group do Brasil Ltda" },
    { 24916, "Essent Corporation" },
    { 24917, "Intermedix Corporation (formerly 'Collaborative Fusion, Inc.')" },
    { 24918, "Radmer" },
    { 24919, "Web Wizard Design" },
    { 24920, "Our Help Desk" },
    { 24921, "MAINDATA, spol. s r.o." },
    { 24922, "VoX Communications, Inc." },
    { 24923, "Shodor Education Foundation, Inc" },
    { 24924, "Unicentrix Solutions" },
    { 24925, "Jordet" },
    { 24926, "LAIKA, Inc." },
    { 24927, "Exegy, Inc." },
    { 24928, "WaterEd Australia Pty Ltd" },
    { 24929, "vt100 digital solutions" },
    { 24930, "synedra information technologies GmbH" },
    { 24931, "Mixed Signals, Inc." },
    { 24932, "Mcomms Design" },
    { 24933, "angel bosch" },
    { 24934, "ISCG Ltd." },
    { 24935, "TetraNed" },
    { 24936, "Snecma Propulsion Solide, Groupe SAFRAN" },
    { 24937, "Universal Display and Fixtures Company" },
    { 24938, "Technolabs S.p.A." },
    { 24939, "qpass" },
    { 24940, "Department of Computer Science, National Chiao Tung University" },
    { 24941, "EMKA Technologies SA" },
    { 24942, "Kyle Fox DBA DigitalFennec Networks" },
    { 24943, "Rigpa" },
    { 24944, "Kreuzinger IT-Trilogie" },
    { 24945, "ParaSun Technologies Inc." },
    { 24946, "Corredoira Abogados" },
    { 24947, "Shanalyst Corporation" },
    { 24948, "Mitsubishi Materials Corporation" },
    { 24949, "Sentillion, Inc" },
    { 24950, "Uniform Industrial Corp." },
    { 24951, "Industrial Video and Control, LLC" },
    { 24952, "Cool Bananas Limited" },
    { 24953, "Numachi" },
    { 24954, "Mobile Complete" },
    { 24955, "SyncCast" },
    { 24956, "Innovative Electronic Designs, Inc." },
    { 24957, "Onoclea" },
    { 24958, "Ascent Media Group" },
    { 24959, "Pankerl - Media" },
    { 24960, "The Sip-router Project (formerly 'iptel.org')" },
    { 24961, "Tail-f  Systems AB" },
    { 24962, "Atlantic Harbour Limited" },
    { 24963, "SiliconVortex" },
    { 24964, "Shanghai Qianjin Electronic Equipment Co.,ltd" },
    { 24965, "Picdar Technology Limited" },
    { 24966, "Greenwich Hospital" },
    { 24967, "EPCON Sp. z o.o." },
    { 24968, "Beijing SecuWard Information Security Technology Co.,Ltd" },
    { 24969, "Wharfe Electronic Data Ltd" },
    { 24970, "InterWay, s.r.o." },
    { 24971, "GIDE LOYRETTE NOUEL" },
    { 24972, "Lipman Electronic Engineering Ltd" },
    { 24973, "Guilin Jharden Communication CO., LTD" },
    { 24974, "Lootah" },
    { 24975, "WINGS Ltd." },
    { 24976, "OmegaSphere Inc." },
    { 24977, "Sxip Identity" },
    { 24978, "Martin Henschke Geraetebau" },
    { 24979, "madpilot.net" },
    { 24980, "CERVICEM" },
    { 24981, "Amex Information Technologies Ltd." },
    { 24982, "Fiebig+Team GmbH" },
    { 24983, "Tod Lewin" },
    { 24984, "Kestral Computing Pty Ltd" },
    { 24985, "Xeround Systems" },
    { 24986, "Bj\0303\0270rn Ruberg konsulenttjenester" },
    { 24987, "Ortiva Wireless Inc." },
    { 24988, "Singh Travels" },
    { 24989, "Synalogic e.K." },
    { 24990, "Bluestem Ltd." },
    { 24991, "CardContact Software & System Consulting" },
    { 24992, "Toko University" },
    { 24993, "MySQL, Inc." },
    { 24994, "nabios GmbH" },
    { 24995, "Integratech S.A." },
    { 24996, "SAFE Health" },
    { 24997, "Cirrologic Ltd" },
    { 24998, "SBA Technologies, Inc" },
    { 24999, "VATSIM.net" },
    { 25000, "ConSol* Consulting & Solutions Software GmbH" },
    { 25001, "Codra Ingenierie Informatique" },
    { 25002, "VistiC Ltd." },
    { 25003, "SQUILD" },
    { 25004, "AEGON Magyarorszag Rt." },
    { 25005, "sevecek" },
    { 25006, "NVision Czech Republic a.s. (formerly 'SITRONICS Telecom Solutions, Czech Republic a.s.')" },
    { 25007, "Precesamiento Digital y Sistemas S.L." },
    { 25008, "I.T.E.N.O.S. GmbH - Mobile Solutions" },
    { 25009, "Sysworksoft" },
    { 25010, "Bedag Informatique SA" },
    { 25011, "Cranite Systems Inc." },
    { 25012, "Minux Bt." },
    { 25013, "RS Consulting" },
    { 25014, "Visimetrics (UK) Ltd" },
    { 25015, "2PM Technologies Ltd" },
    { 25016, "Vizrt/Ardendo AB" },
    { 25017, "CertSign" },
    { 25018, "Proxyconn Ukraine" },
    { 25019, "ProfiTrade 90 Ltd." },
    { 25020, "MobilMail Ltd." },
    { 25021, "Devon County Council" },
    { 25022, "Medox Exchange, Inc." },
    { 25023, "Cyberspace Technology Corporation Ltd." },
    { 25024, "Auriga" },
    { 25025, "Concentrum, Inc." },
    { 25026, "Linear Equipamentos Eletr\0303\0264nicos S.A." },
    { 25027, "Billerud AB" },
    { 25028, "WebService Sp. z o.o." },
    { 25029, "Antek Healthware LLC" },
    { 25030, "Ward-Beck Systems" },
    { 25031, "Network Orange Inc" },
    { 25032, "DACI Com\0303\0251rcio e Servi\0303\0247os de Equipamentos de Inform\0303\0241tica Ltda." },
    { 25033, "Naztec, Inc." },
    { 25034, "Dima Ltda." },
    { 25035, "JINAN DEAN COMPUTER TECHNOLOGY CO LTD" },
    { 25036, "Kantonsschule Romanshorn" },
    { 25037, "Novovia" },
    { 25038, "denver health" },
    { 25039, "vitroconnect systems GmbH (formerly 'infinity-3 GmbH')" },
    { 25040, "Keytronix GmbH." },
    { 25041, "Microsol Ltd." },
    { 25042, "JDM Software BV" },
    { 25043, "litts.net" },
    { 25044, "CapWIN" },
    { 25045, "MET/Administration wallonne/Belgique" },
    { 25046, "GlobalTouch Telecom" },
    { 25047, "Fluid4 Studios" },
    { 25048, "Synchronica PLC" },
    { 25049, "Opengear Inc." },
    { 25050, "IT Knows ApS" },
    { 25051, "Pythagoras Software (UK)" },
    { 25052, "Idya Bt." },
    { 25053, "Ruckus Wireless, Inc." },
    { 25054, "Carillon Information Security Inc." },
    { 25055, "Oxford ArchDigital" },
    { 25056, "Hungarian Television Corporation" },
    { 25057, "Rural Technologies Inc" },
    { 25058, "Bain Capital LLC" },
    { 25059, "Abicom International" },
    { 25060, "pbxnsip Inc." },
    { 25061, "Domaingruppe Riemann2000.de" },
    { 25062, "MessageOne Inc" },
    { 25063, "American Tribu Corp" },
    { 25064, "Women's Health Services" },
    { 25065, "Identity Engines Inc." },
    { 25066, "PELCO" },
    { 25067, "G Central" },
    { 25068, "Axistech" },
    { 25069, "LISA! Reisen GmbH" },
    { 25070, "MULTICERT - Servicos de Certificacao Electronica S.A." },
    { 25071, "Teradici Corporation" },
    { 25072, "LFW ENTERPRISES, INC." },
    { 25073, "Thinking Phone Networks, Inc." },
    { 25074, "Presbyterian Healthcare Services" },
    { 25075, "Inventec Multimedia & Telecom(Tianjin) Co.,Ltd." },
    { 25076, "45RU TRUST" },
    { 25077, "BGC Australia Pty Ltd" },
    { 25078, "MKQ Internetservice" },
    { 25079, "Gyanasoft Inc" },
    { 25080, "Beluga Software, Inc." },
    { 25081, "Universidad de Chile" },
    { 25082, "FishNet Connect" },
    { 25083, "Sirius Creations" },
    { 25084, "Argent Productions" },
    { 25085, "Metrocast Cablevision LLC" },
    { 25086, "Sydney Missionary and Bible College Ltd." },
    { 25087, "HWS" },
    { 25088, "Transactional Records Access Clearinghouse" },
    { 25089, "DSK Bank PLC" },
    { 25090, "Ambientia Oy" },
    { 25091, "Piranha Messtechnik GmbH & Co. KG" },
    { 25092, "Aptic AB" },
    { 25093, "GreysonBaines Innovation" },
    { 25094, "Vonage Holdings Corp" },
    { 25095, "XenIT GmbH" },
    { 25096, "Maimonides Medical Center" },
    { 25097, "TJX Companies" },
    { 25098, "Reflectent Software, Inc." },
    { 25099, "H.E.B. Company Inc." },
    { 25100, "Hochschule Vechta" },
    { 25101, "Dataarmor Pvt Ltd." },
    { 25102, "Phyxia Networks" },
    { 25103, "Netsol International Argentina S.A." },
    { 25104, "Gannett Co., Inc." },
    { 25105, "Cable & Wireless Jamaica" },
    { 25106, "CSE Sh.p..k." },
    { 25107, "Stan Winston Studio" },
    { 25108, "iRadeon, Inc." },
    { 25109, "Wireless Edge Canada Inc." },
    { 25110, "Vanguard Technology Corp." },
    { 25111, "VODCA" },
    { 25112, "Top Gun Drywall Supply" },
    { 25113, "Konstructiv Ltd." },
    { 25114, "SSE INFONET LTD" },
    { 25115, "Delbuilt(Pty)Ltd" },
    { 25116, "EBInteractive" },
    { 25117, "ID Innovative Datenverarbeitung GmbH" },
    { 25118, "StanaPhone LLC" },
    { 25119, "Adder Technology Limited" },
    { 25120, "SAGUAPAC" },
    { 25121, "Temex Sync" },
    { 25122, "Hauk & Sasko GmbH" },
    { 25123, "Barco Orthogon GmbH" },
    { 25124, "Trade-On-Technology Holdings" },
    { 25125, "ALWIL Software" },
    { 25126, "Jackson State University" },
    { 25127, "Radialink Corp" },
    { 25128, "BreastScreen Victoria" },
    { 25129, "SFBC Anapharm Inc." },
    { 25130, "Scouts of Greece, 10th Group of Akropoli, Thessaloniki" },
    { 25131, "P-tec Co., Ltd." },
    { 25132, "Redeal Ltd" },
    { 25133, "HKU School of Professional and Continuing Education" },
    { 25134, "ComDesign Inc." },
    { 25135, "Ministerul pentru Societatea Informa\0310\0233ional\0304\0203 (formerly 'Ministerul Comunicatiilor si Tehnologiei Informatiei')" },
    { 25136, "Haute Ecole Arc" },
    { 25137, "Voronezh State Pedagogical University" },
    { 25138, "Alyseo" },
    { 25139, "Adept Internet (Pty) Ltd" },
    { 25140, "Institut Catholique de Toulouse" },
    { 25141, "La Poste" },
    { 25142, "IP Control Systems Ltd." },
    { 25143, "Damovo Deutschland Gmbh & Co. KG" },
    { 25144, "Perpustakaan Institut Pertanian Bogor" },
    { 25145, "Netzwerk f\0303\0274r Kinder- & Jugendarbeit e.V." },
    { 25146, "Cyprus Research and Academic Network" },
    { 25147, "Internet Solutions" },
    { 25148, "Pivot3, Inc." },
    { 25149, "National Electronics and Computer Technology Center" },
    { 25150, "KK-DENSO.Co.Ltd" },
    { 25151, "Dragontech Corporation Limited" },
    { 25152, "UpTime New Zealand Ltd." },
    { 25153, "AvanSec" },
    { 25154, "Seeker Wireless Pty Ltd" },
    { 25155, "Unisis Solutions Corporation" },
    { 25156, "GECI GmbH" },
    { 25157, "Beckhoff Automation GmbH" },
    { 25158, "Aros Magic" },
    { 25159, "OJSC Svyazintek" },
    { 25160, "Arackal Digital Solutions Inc" },
    { 25161, "Telavox AB" },
    { 25162, "Industrias I, S.C." },
    { 25163, "Broadband Power Solutions" },
    { 25164, "Interpay" },
    { 25165, "FMN communications GmbH" },
    { 25166, "Fachhochschule Muenster" },
    { 25167, "Genexis B.V." },
    { 25168, "Edentity Labs Ltd" },
    { 25169, "Avco Systems Ltd" },
    { 25170, "AFA Systems srl" },
    { 25171, "Armbruster IT" },
    { 25172, "Integra Soluciones Avanzadas, S.L." },
    { 25173, "MET-Minist\0303\0250re de l'Equipement et des Transports" },
    { 25174, "NetOp as" },
    { 25175, "DCN" },
    { 25176, "Familie Uhlig" },
    { 25177, "VAS \"Latvijas Pasts\"" },
    { 25178, "Trans-European Research and Education Networking Association" },
    { 25179, "GESA Elektronik GmbH" },
    { 25180, "Itonis Ltd." },
    { 25181, "HEBUS SARL" },
    { 25182, "University of Tampere" },
    { 25183, "SS WorkGroup Solutions" },
    { 25184, "Zinwave Limited" },
    { 25185, "Banco Esp\0303\0255rito Santo, S.A." },
    { 25186, "Uwe Daube" },
    { 25187, "A.Ir.Br. Associations des Ing\0303\0251nieurs sortis de l'Universit\0303\0251 Libre" },
    { 25188, "Bob Jones University" },
    { 25189, "INVIA" },
    { 25190, "ETI A/S" },
    { 25191, "Smart Bear Inc" },
    { 25192, "Positive Networks, Inc." },
    { 25193, "Wireless Nomad Co-operative Inc." },
    { 25194, "Bizanga Ltd" },
    { 25195, "Waha Oil Company" },
    { 25196, "TM Software" },
    { 25197, "eLearningRecord" },
    { 25198, "SmartServ Web Hosting & Design" },
    { 25199, "Kobe University" },
    { 25200, "TurkTel Ltd." },
    { 25201, "Uniwell Electronics Ltd." },
    { 25202, "Beechler Real Estate Services" },
    { 25203, "Pete Rushmere" },
    { 25204, "Prodato Integration Technology GmbH" },
    { 25205, "Movial Corporation" },
    { 25206, "Axxess Identification Limited" },
    { 25207, "JSC \"ATLAS\"" },
    { 25208, "CSC Scandihealth A/S" },
    { 25209, "CURON Inc." },
    { 25210, "bizEbox" },
    { 25211, "Edison Electric Corp." },
    { 25212, "Initworks B.V." },
    { 25213, "Nexus Web AS" },
    { 25214, "Minnesota Judicial Branch" },
    { 25215, "Novacell Solutions Ltd" },
    { 25216, "ADI Video Technologies" },
    { 25217, "Nautilus Hyosung" },
    { 25218, "httv" },
    { 25219, "RPSoft" },
    { 25220, "sportcentric Systems" },
    { 25221, "Viewpoint Construction Software" },
    { 25222, "Blue Gecko Inc." },
    { 25223, "Mindbreeze Software GmbH" },
    { 25224, "Grupo Pochteca SA de CV" },
    { 25225, "The Austin Diagnostic Clinic, P.A." },
    { 25226, "MaxMD" },
    { 25227, "Ohio Department of Transportation" },
    { 25228, "NAV Canada" },
    { 25229, "Swedish Alliance for Middleware" },
    { 25230, "The Ohio Casualty Insurance Company" },
    { 25231, "Riverforge LLC" },
    { 25232, "Linog consulting" },
    { 25233, "ACS" },
    { 25234, "Emdeon Corporation" },
    { 25235, "Windrush Frozen Foods Ltd" },
    { 25236, "Invitrogen Corporation" },
    { 25237, "L-3 Communications/Narda Satellite Networks" },
    { 25238, "GreenLight Networks" },
    { 25239, "Tknika" },
    { 25240, "Peggy A. Pugh, MD, CPC" },
    { 25241, "Proximus Information Technologies" },
    { 25242, "ACTORS CONSULTING" },
    { 25243, "Agglut Technologies, Inc." },
    { 25244, "BrightNet Oklahoma" },
    { 25245, "Order of St. Charbel" },
    { 25246, "South-Russia State Technical University" },
    { 25247, "DANDELION C.A." },
    { 25248, "Solidcore Systems Inc" },
    { 25249, "Dispuut Interlink" },
    { 25250, "AnQ Systems, Ltd." },
    { 25251, "Princeton Alliance Church" },
    { 25252, "vptechnologies srl" },
    { 25253, "MFEC Public Company Limited" },
    { 25254, "Makena Technologies, Inc." },
    { 25255, "Broadsoft Systems" },
    { 25256, "Nable Communications, Inc." },
    { 25257, "Sipera Systems Inc" },
    { 25258, "Randombit Consulting" },
    { 25259, "JWR Software Services Ltd" },
    { 25260, "Frauerpower!" },
    { 25261, "Westenberg & Kueppers GbR" },
    { 25262, "Network Automation" },
    { 25263, "mareco gmbh" },
    { 25264, "Propolys" },
    { 25265, "Dave Pusey - IT Services" },
    { 25266, "FUH EOS" },
    { 25267, "Virtual Synthesis" },
    { 25268, "enfon" },
    { 25269, "CFNetTools" },
    { 25270, "MeepZor Consulting" },
    { 25271, "Lotus Interworks, Inc." },
    { 25272, "GRUPO XMARTS SA DE CV" },
    { 25273, "Konsole Network" },
    { 25274, "IT2Media GmbH" },
    { 25275, "Peter Hall" },
    { 25276, "Gear6" },
    { 25277, "Pekao Inc." },
    { 25278, "Canon Electronics Inc." },
    { 25279, "Nasdaq MTS (formerly 'OMX Group')" },
    { 25280, "Market Pulse International" },
    { 25281, "Westerstrand Urfabrik AB" },
    { 25282, "MDK Baden-W\0303\0274rttemberg" },
    { 25283, "CONSEIL GENERAL DU CHER" },
    { 25284, "Taylor Made Computer Solutions Ltd" },
    { 25285, "Beheer-Net" },
    { 25286, "Open Logic Solutions Ltd." },
    { 25287, "Megabit Informationstechnik GmbH" },
    { 25288, "onShore Development" },
    { 25289, "Alabama A&M University" },
    { 25290, "Convert Italia SpA" },
    { 25291, "Zeacom Ltd." },
    { 25292, "Skagit County Government" },
    { 25293, "MaxMD" },
    { 25294, "EESTEC International" },
    { 25295, "Affiniti" },
    { 25296, "VeriCenter, Inc" },
    { 25297, "Hotxt Ltd" },
    { 25298, "Rohm and Haas Company" },
    { 25299, "Rodic M&B-Co d.o.o." },
    { 25300, "OfficeNet AS" },
    { 25301, "Netauth Consulting" },
    { 25302, "Deakin University" },
    { 25303, "subnetz.computing GmbH" },
    { 25304, "Demon Netherlands" },
    { 25305, "Vodafone Holding GmbH, FPU-CEC" },
    { 25306, "Sunmine Communications