/* preferences_dialog.h
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0+
 */

#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

#include <config.h>

#include <epan/prefs.h>

#include <ui/qt/models/pref_models.h>
#include <ui/qt/models/pref_delegate.h>

#include "geometry_state_dialog.h"

class QComboBox;

namespace Ui {
class PreferencesDialog;
}

class PreferencesDialog : public GeometryStateDialog
{
    Q_OBJECT

public:
    explicit PreferencesDialog(QWidget *parent = 0);
    ~PreferencesDialog();

    void setPane(const QString pane_name);

protected:
    void showEvent(QShowEvent *evt);

private:
    Ui::PreferencesDialog *pd_ui_;

    QHash<QString, QWidget*> prefs_pane_to_item_;

    PrefsModel model_;
    AdvancedPrefsModel advancedPrefsModel_;
    AdvancedPrefDelegate advancedPrefsDelegate_;
    ModulePrefsModel modulePrefsModel_;
    gboolean saved_capture_no_extcap_;

private slots:
    void selectPane(QString pane);
    void on_advancedSearchLineEdit_textEdited(const QString &search_re);

    void on_buttonBox_accepted();
    void on_buttonBox_rejected();
    void on_buttonBox_helpRequested();
};

#endif // PREFERENCES_DIALOG_H
