/* export_objects_view.cpp
 * Tree view of Export object data.
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0+
 */

#include "export_objects_view.h"
#include <ui/qt/models/export_objects_model.h>

ExportObjectsTreeView::ExportObjectsTreeView(QWidget *parent) : QTreeView(parent)
{
}

void ExportObjectsTreeView::currentChanged(const QModelIndex &current, const QModelIndex &previous)
{
    if (current.isValid())
    {
        int packetNum = model()->data(model()->index(current.row(), ExportObjectModel::colPacket)).toInt();
        emit goToPacket(packetNum);
    }

    QTreeView::currentChanged(current, previous);
}

/* * Editor modelines
 *
 * Local Variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * ex: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
