/* wmem.h
 * Definitions for the Wireshark Memory Manager
 * Copyright 2012, Evan Huus <eapache@gmail.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef __WMEM_H__
#define __WMEM_H__

#include "wmem_array.h"
#include "wmem_core.h"
#include "wmem_list.h"
#include "wmem_map.h"
#include "wmem_miscutl.h"
#include "wmem_queue.h"
#include "wmem_scopes.h"
#include "wmem_stack.h"
#include "wmem_strbuf.h"
#include "wmem_strutl.h"
#include "wmem_tree.h"
#include "wmem_interval_tree.h"
#include "wmem_user_cb.h"

#endif /* __WMEM_H__ */

/*
 * Editor modelines  -  http://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
