/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import com.sun.jimi.util.RandomAccessStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class FileRandomAccessStorage
extends RandomAccessFile
implements RandomAccessStorage {
    protected InputStream in = new InputStreamWrapper(this);
    protected OutputStream out = new OutputStreamWrapper(this);
    protected File file;

    public FileRandomAccessStorage(File file) throws IOException {
        super(file, "rw");
        this.file = file;
    }

    public InputStream asInputStream() {
        return this.in;
    }

    public OutputStream asOutputStream() {
        return this.out;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.file.delete();
    }

    public void seek(long l) throws IOException {
        super.seek(l);
    }

    public void skip(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
    }

    protected final class OutputStreamWrapper
    extends OutputStream {
        private final /* synthetic */ FileRandomAccessStorage this$0;
        protected FileRandomAccessStorage storage;

        protected OutputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }

        public void write(int n) throws IOException {
            this.storage.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.storage.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.storage.write(byArray, n, n2);
        }
    }

    protected final class InputStreamWrapper
    extends InputStream {
        private final /* synthetic */ FileRandomAccessStorage this$0;
        protected FileRandomAccessStorage storage;

        protected InputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }

        public int read() throws IOException {
            return this.storage.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.storage.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.storage.read(byArray, n, n2);
        }
    }
}

