/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package javax.xml.bind.util;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBException;
import javax.xml.transform.sax.SAXSource;

import org.xml.sax.InputSource;


/** <p>This utility class allows to use a JAXB object as the
 * source of a stylesheet transformation.</p>
 * 
 * @author JSR-31
 * @since JAXB1.0
 */
public class JAXBSource extends SAXSource {
  /** <p>Creates a new instance of JAXBSource. The given
   * {@link javax.xml.bind.JAXBContext} will be used to
   * construct a {@link javax.xml.bind.Marshaller} and
   * invoke the constructor
   * {@link #JAXBSource(javax.xml.bind.Marshaller, Object)}.</p>
   */
  public JAXBSource(javax.xml.bind.JAXBContext pContext, Object pObject) throws JAXBException {
    this(pContext.createMarshaller(), pObject);
  }

  /** <p>Creates a new instance of JAXBSource.</p>
   */
  public JAXBSource(javax.xml.bind.Marshaller pMarshaller, Object pObject) throws JAXBException {
    // This could use performance improvement ... first marshalling
    // into a string and then parsing back is not what we like to see.
    StringWriter sw = new StringWriter();
    pMarshaller.marshal(pObject, sw);
    String s = sw.toString();
    super.setInputSource(new InputSource(new StringReader(s)));
  }
}
