/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme;

import javax.xml.bind.JAXBException;

import javax.xml.bind.DatatypeConverterInterface;

import org.apache.ws.jaxme.impl.JAXBContextImpl;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.ContentHandler;


/** <p>A Handler is capable and used to unmarshal a certain
 * subclass of JMElement. It is unable to marshal generic JMElements.
 * The JMHandler is typically created by the Manager.</p>
 * <p>A JMHandler is reusable: If the sequence
 * <code>startDocument()</code>, ..., <code>endDocument()</code>
 * was executed, you can immediately perform the same sequence
 * again, effectively reading another document. If the sequence
 * was interrupted, you may also reset the handlers state by
 * calling its <code>init()</code> method.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: JMHandler.java,v 1.2 2004/02/16 23:39:48 jochen Exp $
 */
public interface JMHandler extends ContentHandler, Observable {
  public interface Data {
    /** <p>Returns the Unmarshaller controlling the unmarshalling
     * process.</p>
     */
    public JMUnmarshaller getUnmarshaller();

    /** <p>Returns the object factory used to create new objects.</p>
     */
    public JAXBContextImpl getFactory();

    /** <p>Returns a ContentHandler used to parse an elements contents.</p>
     */
    public JMHandler getAtomicHandler();

    /** <p>Returns the {@link javax.xml.bind.DatatypeConverterInterface}.</p>
     */
    public DatatypeConverterInterface getDatatypeConverter();

    /** <p>Returns the {@link javax.xml.namespace.NamespaceContext}.</p>
     */
    public NamespaceSupport getNamespaceContext();
  }

  /** <p>Initializes the handler by setting its Data.</p>
   * 
   * @param pData An instance of {@link Data} providing access to the
   *   handlers configuration..
   */
  public void init(Data pData) throws JAXBException;

  /** <p>Initializes the handler by creating a new Data instance
   * and calling <code>init(Data)</code>.</p>
   */
  public void init(JMUnmarshaller pUnmarshaller) throws JAXBException;

  /** <p>Returns the handlers Data.</p>
   */
  public Data getData();

  /** <p>Returns the handlers result object.</p>
   * 
   * @return Result object
   * @throws IllegalStateException If called before a full
   *   <code>startDocument()</code>, ..., </code>endDocument()</code>
   *   sequence.
   */
  public Object getResult();
}
