/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme;

import javax.xml.namespace.QName;

import org.apache.ws.jaxme.impl.JAXBContextImpl;


/** <p>A JMManager controls the object factory (aka JAXBContext)
 * for a given document type. The document type is both identified
 * by its QName and its interface, which is extending JMElement.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: JMManager.java,v 1.3 2004/02/16 23:39:48 jochen Exp $
 */
public interface JMManager {
  /** <p>Returns a property value, which is used to configure
   * the manager. The property value is set in the configuration
   * file.</p>
   *
   * @param pName The property name
   * @return pValue The property value; null, if the property is not
   *   set.
   */
  public String getProperty(String pName);

  /** <p>Returns the {@link org.apache.ws.jaxme.impl.JAXBContextImpl},
   * that created this manager.</p>
   */
  public JAXBContextImpl getFactory();

  /** <p>Returns the QName of the document type that this
   * Manager controls.</p>
   */
  public QName getQName();

  /** <p>Returns the interface matching the document type.
   * This must be a subinterface of JMElement.</p>
   */
  public Class getElementInterface();

  /** <p>Returns the implementation class of the interface
   * returned by <code>getElementInterface()</code>.</p>
   */
  public Class getElementClass();

  /** <p>Returns the document types handler class. This class
   * must be implementing JMHandler and it must be able to
   * convert the document type controlled by the manager into
   * objects implementing the element interface.</p>
   */
  public Class getHandlerClass();

  /** <p>Returns the document types marshaller class. This class
   * must be implementing JMXmlSerializer and it must be able
   * to convert objects implementing the element interface into
   * a stream of SAX events.</p>
   */
  public Class getMarshallerClass();

  /** <p>Returns the persistency class. The persistency class
   * must be able to store documents in a database, update,
   * delete or retrieve them.</p>
   */
  public Class getPmClass();
}
