/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.generator.sg.impl;

import org.apache.ws.jaxme.generator.sg.ComplexContentSG;
import org.apache.ws.jaxme.generator.sg.ComplexContentSGChain;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSType;
import org.xml.sax.SAXException;


/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public class JAXBComplexContentTypeSG implements ComplexContentSGChain {
  private final GroupSG groupSG;

  protected JAXBComplexContentTypeSG(ComplexTypeSG pComplexTypeSG, XSType pType) throws SAXException {
    if (pType.getComplexType().isEmpty()) {
      groupSG = null;
    } else {
      XSParticle particle = pType.getComplexType().getParticle();
      if (particle == null) {
      	throw new NullPointerException("Missing group particle for type = " + pType.getName());
      }
      if (particle.isGroup()) {
        XSGroup group = particle.getGroup();
        groupSG = pComplexTypeSG.getTypeSG().getFactory().getGroupSG(group, pComplexTypeSG.getClassContext());
      } else {
        throw new IllegalStateException("Expected internal group");
      }
    }
  }

  public void init(ComplexContentSG pController) throws SAXException {}

  public GroupSG getGroupSG(ComplexContentSG pController) {
    return groupSG;
  }
}
