/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.generator.util;

import java.util.Comparator;

import javax.xml.namespace.QName;

import org.apache.ws.jaxme.generator.QNameOwner;



/** <p>Used for sorting arrays or lists of QNameOwner's.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: QNameComparator.java,v 1.2 2004/02/16 23:39:58 jochen Exp $
 */
public class QNameComparator implements Comparator {
  private static final QNameComparator theInstance = new QNameComparator();

  protected QNameComparator() {}

  public static QNameComparator getInstance() { return theInstance; }

  /** <p>Compares two instances of <code>QNameOwner</code> by
   * calling their <code>getQName()</code> method.</p>
   * 
   * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
   * @see org.apache.ws.jaxme.generator.QNameOwner#getQName()
   */
  public int compare(Object o1, Object o2) {
    if (o1 == null) {
      return o2 == null ? 0 : -1;
    }
    if (o2 == null) {
      return 1;
    }
    QNameOwner qo1 = (QNameOwner) o1;
    QNameOwner qo2 = (QNameOwner) o2;
    QName n1 = qo1.getQName();
    QName n2 = qo2.getQName();
    if (n1 == null) {
      return n2 == null ? 0 : -1;
    }
    if (n2 == null) {
      return 1;
    }
    String s1 = n1.getNamespaceURI();
    String s2 = n2.getNamespaceURI();
    if (s1 == null) { s1 = ""; }
    if (s2 == null) { s2 = ""; }
    int result = s1.compareTo(s2);
    if (result == 0) {
      result = n1.getLocalPart().compareTo(n2.getLocalPart());
    }
    return result;
  }

}
