/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.impl;

import javax.xml.bind.ValidationEvent;

import org.apache.ws.jaxme.ValidationEvents;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: AtomicHandler.java,v 1.2 2004/02/16 23:39:57 jochen Exp $
 */
public class AtomicHandler extends JMHandlerBase {
  private StringBuffer contents = new StringBuffer();
  private int level;
  private String qName;

  /** <p>Returns a string with the parsed elements contents.</p>
   */
  public Object getResult() {
    return contents.toString();
  }

  public void startDocument() throws SAXException {
    contents.setLength(0);
    level = 0;
  }

  public void startElement(String pNamespaceURI, String pLocalName,
                            String pQName, Attributes pAttr)
      throws SAXException {
    switch (level++) {
      case 0:
        qName = pQName;
        break;
      case 1:
        validationEvent(ValidationEvent.WARNING,
                        "Unexpected child element " + pQName +
                        "in element " + qName + " with simple content.",
                        ValidationEvents.EVENT_UNEXPECTED_CHILD_ELEMENT);
        break;
      default:
        // Ignore this
        break;
    }
  }

  public void endElement(String pNamespaceURI, String pLocalName, String pQName)
      throws SAXException {
  }

  public void characters(char[] pChars, int pStart, int pLength)
      throws SAXException {
    if (level == 1) {
      contents.append(pChars, pStart, pLength);
    }
  }

  public void ignorableWhitespace(char[] ch, int start, int length)
      throws SAXException {
  }
}
