/*
 * Copyright 2003,2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.impl;

import javax.xml.bind.ValidationEvent;

import org.apache.ws.jaxme.ValidationEvents;
import org.apache.ws.jaxme.XMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;


/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: JMHandlerImpl.java,v 1.5.2.1 2004/07/23 07:00:33 jochen Exp $
 */
public abstract class JMHandlerImpl extends JMHandlerBase {
  private Object result;

  /** <p>Sets the result object.</p>
   */
  public void setResult(Object pResult) {
    result = pResult;
  }

  public Object getResult() {
    return result;
  }

  public void ignorableWhitespace(char[] ch, int start, int length)
    throws SAXException {
  }

  public void addAttribute(String pNamespaceURI, String pLocalName,
                           String pValue) throws SAXException {
  	if (javax.xml.XMLConstants.XML_NS_URI.equals(pNamespaceURI)
        ||  javax.xml.XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(pNamespaceURI)
        ||  XMLConstants.XML_SCHEMA_URI.equals(pNamespaceURI)) {
  		// Ignore attributes in the xsi namespace
    } else {
    	validationEvent(ValidationEvent.ERROR,
    			        "Unknown attribute: '" + pLocalName
                        + "' in namespace '" + pNamespaceURI + "'",
						ValidationEvents.EVENT_UNKNOWN_ATTRIBUTE);
    }
  }

  public void startElement(String pNamespaceURI, String pLocalName,
                            String pQName, Attributes pAttr) throws SAXException {
    validationEvent(ValidationEvent.WARNING,
                    "Unexpected element: '" + pQName + "'",
                    ValidationEvents.EVENT_UNEXPECTED_CHILD_ELEMENT);
  }

  public void characters(char[] pChars, int pOffset, int pLen) throws SAXException {
    for (int i = 0;  i < pLen;  i++) {
      if (!Character.isWhitespace(pChars[pOffset+i])) {
        validationEvent(ValidationEvent.WARNING, "Unexpected non-whitespace characters: '" +
                        new String(pChars, pOffset, pLen) + "'",
                        ValidationEvents.EVENT_UNEXPECTED_TEXTUAL_CONTENTS);
      }
    }
  }

  public void endElement(String pNamespaceURI, String pLocalName,
                          String pQName) throws SAXException {
    validationEvent(ValidationEvent.WARNING,
                    "Unexpected element: '" + pQName + "'",
                    ValidationEvents.EVENT_UNEXPECTED_CHILD_ELEMENT);
  }
}
