/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.junit;

import junit.framework.TestCase;


/** <p>A base class for JUnit tests.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 * @version $Id: BaseTestCase.java,v 1.3.2.1 2004/08/20 12:22:55 jochen Exp $
 */
public abstract class BaseTestCase extends TestCase {
  public BaseTestCase(String pName) {
    super(pName);
  }

  public BaseTestCase(Class c) {
    this(c.getName());
  }

  // Asserts equality of the two given byte arrays.
  protected void assertEquals(byte[] pExpect, byte[] pGot) {
    if (pExpect.length != pGot.length) {
      fail("Expected " + pExpect.length + " bytes, got " + pGot.length);
    } else {
      for (int i = 0;  i < pExpect.length;  i++) {
        if (pExpect[i] != pGot[i]) {
          fail("Expected byte " + ((int) pExpect[i]) + " at offset " + i +
               ", got byte " + ((int) pGot[i]));
        }
      }
    }
  }
}
