/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.junit;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.JAXBContext;

import org.apache.ws.jaxme.test.misc.group.Persons;
import org.apache.ws.jaxme.test.misc.group.PersonsType.PersonType;
import org.xml.sax.InputSource;

/**
 * @author <a href="mailto:iasandcb@tmax.co.kr">Ias</a>
 */
public class NestedGroupTest extends BaseTestCase {
  public NestedGroupTest(String pName) {
    super(pName);
  }

  private String getPersons() throws Exception {
    return "<Persons xmlns=\"http://ws.apache.org/jaxme/test/misc/group\">\n"
      + "  <Person Alias=\"Ias\">\n"
      /*
      + "    <FirstName>Changshin</FirstName>\n"
      + "    <LastName>Lee</LastName>\n"
      + "    <Age>30</Age>\n"
      */
      + "  </Person>\n"
      + "</Persons>";
  }

  public void testNestedGroup() throws Exception {
    String persons = getPersons();
    InputSource isource = new InputSource(new StringReader(persons));
    JAXBContext context =
      JAXBContext.newInstance("org.apache.ws.jaxme.test.misc.group");
    Persons unmarshalledPersons =
      (Persons) context.createUnmarshaller().unmarshal(isource);
    List personList = unmarshalledPersons.getPerson();
    Iterator i = personList.iterator();
    i.hasNext();
    PersonType person = (PersonType) i.next();
    /*
    assertEquals("Changshin", person.getFirstName());
    assertEquals("Lee", person.getLastName());
    assertEquals(25, person.getAge());
    */
    assertEquals("Ias", person.getAlias());
  }
}
