/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.util;

import java.io.IOException;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;


/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public class Base64Binary {
  public static byte[] getClone(byte[] pValue) {
    byte[] result = new byte[pValue.length];
    System.arraycopy(pValue, 0, result, 0, pValue.length);
    return result;
  }

  public static byte[] decode(String pValue) throws IOException {
    return (new BASE64Decoder()).decodeBuffer(pValue);
  }

  public static String encode(byte[] pValue) {
    return (new BASE64Encoder()).encode(pValue);
  }

  public static void main(String[] args) throws Exception {
    byte[] bytes = new byte[]{1, 17, 35, 78, 115, -99, -69, -1};
    String base64 = encode(bytes);
    System.out.println(base64);
    byte[] result = decode(base64);
    if (result.length != bytes.length) {
      System.err.println("length: " + result.length + " != " + bytes.length);
    } else {
      for (int i = 0;  i < bytes.length;  i++) {
        if (bytes[i] != result[i]) {
          System.err.println("byte " + i + ": " + bytes[i] + " != " + result[i]);
        }
      }
    }
    System.out.println("Ok");
  }
}
