/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.logging;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

/** <p>A LoggerFactory logging via an Ant project.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public class AntProjectLoggerFactory extends LoggerFactoryImpl {
  final Project project;
  final Task task;

  public AntProjectLoggerFactory(Project pProject) {
    project = pProject;
    task = null;
  }

  public AntProjectLoggerFactory(Task pTask) {
    task = pTask;
    project = null;
  }

  public Logger newLogger(String pName) {
    return task == null ?
      new AntProjectLogger(pName, project) : new AntProjectLogger(pName, task);
  }
}
