/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.sqls;

import org.apache.ws.jaxme.sqls.impl.BooleanConstraintImpl;

/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public interface BooleanConstraint extends Constraint, Parts {
  /** <p>The type of a boolean constraint.</p>
   */
  public interface Type {
    public static final Type EQ = new BooleanConstraintImpl.TypeImpl("EQ");
    public static final Type NE = new BooleanConstraintImpl.TypeImpl("NE");
    public static final Type LT = new BooleanConstraintImpl.TypeImpl("LT");
    public static final Type GT = new BooleanConstraintImpl.TypeImpl("GT");
    public static final Type LE = new BooleanConstraintImpl.TypeImpl("LE");
    public static final Type GE = new BooleanConstraintImpl.TypeImpl("GE");
    public static final Type LIKE = new BooleanConstraintImpl.TypeImpl("LIKE");
    public static final Type ISNULL = new BooleanConstraintImpl.TypeImpl("ISNULL");
    public static final Type IN = new BooleanConstraintImpl.TypeImpl("IN");
    public static final Type EXISTS = new BooleanConstraintImpl.TypeImpl("EXISTS");
  }

  /** <p>Returns the boolean constraints type.</p>
   */
  public BooleanConstraint.Type getType();
}
