/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.sqls;


/** <p>A factory object for creating all the objects used by
 * the SQL factory.</p>
 *
 * @author <a href="mailto:jwi@softwareag.com">Jochen Wiedmann</a>
 */
public interface ObjectFactory {
    /** <p>Returns an instance of {@link RawSQLCode}.</p>
     */
    public RawSQLCode newRawSQL(String pRawSQLCode);
    
    /** <p>Returns an instance of {@link JoinReference}.</p>
     */
    public JoinReference newJoinReference(SelectTableReference pSelectTableReference,
            Table pTable,
            boolean pIsLeftOuterJoin);
    
    /** <p>Returns an instance of {@link Function}.</p>
     */
    public Function newFunction(Statement pStatement, String pName);
    
    /** <p>Returns an instance of {@link Table}, which allows to embed
     * the given instance of {@link SelectStatement} into another
     * SELECT statement.</p>
     */
    public Table newView(SelectStatement pSelectStatement, Table.Name pName);

    /** <p>Creates a new instance of {@link Constraint} constraining
     * the given {@link ConstrainedStatement}.</p>
     */
    public CombinedConstraint newCombinedConstraint(ConstrainedStatement pStatement,
            										CombinedConstraint.Type pType);
}
