/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.sqls;

import java.util.Calendar;
import java.util.Iterator;


/** <p>A common base interface for {@link org.apache.ws.jaxme.sqls.InsertStatement}
 * and {@link org.apache.ws.jaxme.sqls.UpdateStatement}.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public interface SetStatement extends Statement {
  public interface SetValue {
     /** <p>Returns the column being set.</p>
      */
     public ColumnReference getColumnReference();
     /** <p>Returns the value to which the column is being set.</p>
      */
     public Value getValue();
  }

  /** <p>Returns an {@link Iterator} to all values being set.
   * Any element in the iterator is an instance of {@link SetValue}.</p>
   */
  public Iterator getSetValues();

  /** <p>Adds a SET clause setting the given column to NULL.</p>
   */
  public void addSetNull(Column pColumn);
  /** <p>Adds a SET clause setting the given column to NULL.</p>
   */
  public void addSetNull(Column.Name pColumn);
  /** <p>Adds a SET clause setting the given column to NULL.</p>
   */
  public void addSetNull(String pColumn);

  /** <p>Adds a SET clause setting the given column to a value
   * given by a placeholder.</p>
   */
  public void addSet(Column pColumn);
  /** <p>Adds a SET clause setting the given column to a value
   * given by a placeholder.</p>
   */
  public void addSet(Column.Name pColumn);
  /** <p>Adds a SET clause setting the given column to a value
   * given by a placeholder.</p>
   */
  public void addSet(String pColumn);

  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, byte pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, byte pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, byte pValue);

  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, short pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, short pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, short pValue);

  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, int pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, int pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, int pValue);

  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, long pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, long pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, long pValue);


  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, float pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, float pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, float pValue);
 
  /** <p>Adds a SET clause setting the given column to the value
   * TRUE or FALSE, depending on <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, boolean pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * TRUE or FALSE, depending on <code>pValue<code>.</p>
   */
  public void addSet(Column.Name pColumn, boolean pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * TRUE or FALSE, depending on <code>pValue<code>.</p>
   */
  public void addSet(String pColumn, boolean pValue);

  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue<code>.</p>
   */
  public void addSet(Column pColumn, String pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(Column.Name pColumn, String pValue);
  /** <p>Adds a SET clause setting the given column to the value
   * <code>pValue</code>.</p>
   */
  public void addSet(String pColumn, String pValue);

  /** <p>Adds a SET clause setting the given column to the datetime
   * value <code>pValue<code>.</p>
   */
  public void addSetDateTime(Column pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the datetime
   * value <code>pValue</code>.</p>
   */
  public void addSetDateTime(Column.Name pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the datetime
   * value <code>pValue</code>.</p>
   */
  public void addSetDateTime(String pColumn, Calendar pValue);

  /** <p>Adds a SET clause setting the given column to the time value
   * <code>pValue<code>. Shortcut for
   * <code>addSet(getTable().newColumnReference(pColumn), pValue)</code>.</p>
   */
  public void addSetTime(Column pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the time value
   * <code>pValue</code>. Shortcut for
   * <code>addSet(getTable().newColumnReference(pColumn), pValue)</code>.</p>
   */
  public void addSetTime(Column.Name pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the time value
   * <code>pValue</code>.</p>
   */
  public void addSetTime(String pColumn, Calendar pValue);

  /** <p>Adds a SET clause setting the given column to the date value
   * <code>pValue<code>.</p>
   */
  public void addSetDate(Column pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the date value
   * <code>pValue</code>.</p>
   */
  public void addSetDate(Column.Name pColumn, Calendar pValue);
  /** <p>Adds a SET clause setting the given column to the date value
   * <code>pValue</code>.</p>
   */
  public void addSetDate(String pColumn, Calendar pValue);
}
