/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.sqls.impl;

import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.ConstrainedStatement;


/**
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public class BooleanConstraintImpl extends PartsImpl implements BooleanConstraint {
  public static class TypeImpl extends SQLFactoryImpl.IdentImpl implements BooleanConstraint.Type {
    public TypeImpl(String pName) {
      super(pName);
    }
  }

  private BooleanConstraint.Type type;

  protected BooleanConstraintImpl(CombinedConstraint pCombinedConstraint,
                                   BooleanConstraint.Type pType) {
    super(pCombinedConstraint.getConstrainedStatement());
    if (pType == null) {
      throw new NullPointerException("The type must not be null.");
    }
    type = pType;
	}

	public BooleanConstraint.Type getType() {
      return type;
	}

	protected void add(Object pPart) {
    if (getType().equals(BooleanConstraint.Type.IN)) {
      // Arbitrary number of parts
    } else if (getType().equals(BooleanConstraint.Type.ISNULL)) {
      // Exactly one part
      if (getNumParts() == 1) {
        throw new IllegalStateException("An IS NULL clause cannot have more than one part.");
      }
    } else {
      // Exactly two parts
      if (getNumParts() == 2) {
        throw new IllegalStateException("An " + getType() + " clause cannot have more than two parts.");
      }
    }
    super.add(pPart);
  }

  public ConstrainedStatement getConstrainedStatement() {
    return (ConstrainedStatement) getStatement();
  }
}
