/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.test.misc.jaxb.impl;

/** <p>An example class demonstrating the use of
 * <code>xs:annotation/xs:appinfo/jaxb:class/@implClass</code>.
 * The example file <samp>src/test/jaxb/jaxb.xsd</samp> defines this
 * class to be the implementation of
 * {@link org.apache.ws.jaxme.test.misc.jaxb.SomeClass}.</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public class SomeClass extends org.apache.ws.jaxme.test.misc.jaxb.impl.SomeClassImpl
    implements org.apache.ws.jaxme.test.misc.jaxb.SomeClass {
  private String someAttribute;
  private int someElement;

  public String getSomeAttribute() { return someAttribute; }
  public void setSomeAttribute(String pSomeAttribute) { someAttribute = pSomeAttribute; }

  public int getSomeElement() { return someElement; }
  public void setSomeElement(int pSomeElement) { someElement = pSomeElement; }
}
