/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.xs.xml;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;


/** <p>Base interface for all the types, attributes, elements, ...</p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public interface XsObject {
  /** <p>Returns the objects syntactical schema.</p>
   */
  public XsESchema getXsESchema();

  /** <p>Returns whether the object is a top-level object. This is
   * the case for the XsESchema itself and for all its childs only.</p>
   */
  public boolean isTopLevelObject();

  /** <p>Returns either of the following:
   * <ul>
   *   <li>If the object is the schema itself, returns null. The
   *     schema doesn't have a parent object.</p>
   *   <li>If the object is a top-level object, returns the
   *     schema.</p>
   *   <li>Otherwise returns the object in which the given object
   *     is embedded.</li>
   * </ul>
   */
  public XsObject getParentObject();

  /** <p>Returns the {@link XsObjectFactory object factory}, that
   * created this instance.</p>
   */ 
  public XsObjectFactory getObjectFactory();

  /** <p>Returns the SAX {@link Locator} with the instances
   * location.</p>
   */
  public Locator getLocator();

  /** <p>Validates the types, attributes, elements, ... internal state.</p>
   */
  public void validate() throws SAXException;
}
