/////////////////////////////////////////////////////////////////////////////
// Name:        _richtexthtml
// Purpose:     wxRichTextHTMLHandler
//
// Author:      Robin Dunn
//
// Created:     18-May-2007
// RCS-ID:      $Id: _richtexthtml.i 46675 2007-06-23 20:50:39Z RD $
// Copyright:   (c) 2007 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Not a %module


//---------------------------------------------------------------------------

%{
#include <wx/richtext/richtexthtml.h>
%}

//---------------------------------------------------------------------------
%newgroup

MAKE_CONST_WXSTRING2(HtmlName, wxT("HTML"));
MAKE_CONST_WXSTRING2(HtmlExt,  wxT("html"));

class wxRichTextHTMLHandler: public wxRichTextFileHandler
{
public:
    wxRichTextHTMLHandler(const wxString& name = wxPyHtmlName,
                          const wxString& ext = wxPyHtmlExt,
                          int type = wxRICHTEXT_TYPE_HTML);

    DocDeclStr(
        virtual bool , CanSave() const,
        "Can we save using this handler?", "");
    DocDeclStr(
        virtual bool , CanLoad() const,
        "Can we load using this handler?", "");
    DocDeclStr(
        virtual bool , CanHandle(const wxString& filename) const,
        "Can we handle this filename (if using files)? By default, checks the
extension.", "");
    

    DocDeclStr(
        void , SetTemporaryImageLocations(const wxArrayString& locations),
        "Set the list of image locations generated by the last operation", "");
    DocDeclStr(
        const wxArrayString& , GetTemporaryImageLocations() const,
        "Get the list of image locations generated by the last operation", "");
    %property(TemporaryImageLocations, GetTemporaryImageLocations, SetTemporaryImageLocations);

    

    DocDeclStr(
        void , ClearTemporaryImageLocations(),
        "Clear the image locations generated by the last operation", "");
    DocDeclStr(
        bool , DeleteTemporaryImages(),
        "Delete the in-memory or temporary files generated by the last operation", "");
    

//     DocDeclStr(
//         static bool , DeleteTemporaryImages(int flags, const wxArrayString& imageLocations),
//         "Delete the in-memory or temporary files generated by the last operation. This
// is a static function that can be used to delete the saved locations from an
// earlier operation, for example after the user has viewed the HTML file.", "");
    

    DocDeclStr(
        static void , SetFileCounter(int counter),
        "Reset the file counter, in case, for example, the same names are required each
time", "");
    

    DocDeclStr(
        void , SetTempDir(const wxString& tempDir),
        "Set the directory for storing temporary files. If empty, the system temporary
directory will be used.", "");
    DocDeclStr(
        const wxString& , GetTempDir() const,
        "Get the directory for storing temporary files. If empty, the system temporary
directory will be used.", "");
    %property(TempDir, GetTempDir, SetTempDir);

    
    DocDeclStr(
        void , SetFontSizeMapping(const wxArrayInt& fontSizeMapping),
        "Set mapping from point size to HTML font size. There should be 7 elements, one
for each HTML font size, each element specifying the maximum point size for
that HTML font size. E.g. 8, 10, 13, 17, 22, 29, 100
", "");    
    DocDeclStr(
        wxArrayInt , GetFontSizeMapping() const,
        "Get mapping deom point size to HTML font size.", "");
    %property(FontSizeMapping, GetFontSizeMapping, SetFontSizeMapping);

};

//---------------------------------------------------------------------------
